/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.IntDef;
import android.app.PendingIntent;
import android.content.Context;
import android.net.ConnectivityThread;
import android.net.IConnectivityManager;
import android.net.INetworkPolicyManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkUtils;
import android.net.Proxy;
import android.net.ProxyInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkActivityListener;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.telephony.ITelephony;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.util.HashMap;
import libcore.net.event.NetworkEventDispatcher;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnectivityManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ConnectivityManager";
    public static String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static String CONNECTIVITY_ACTION_SUPL = "android.net.conn.CONNECTIVITY_CHANGE_SUPL";
    public static String ACTION_CAPTIVE_PORTAL_SIGN_IN = "android.net.conn.CAPTIVE_PORTAL";
    @Deprecated
    public static String EXTRA_NETWORK_INFO = "networkInfo";
    public static String EXTRA_NETWORK_TYPE = "networkType";
    public static String EXTRA_IS_FAILOVER = "isFailover";
    public static String EXTRA_OTHER_NETWORK_INFO = "otherNetwork";
    public static String EXTRA_NO_CONNECTIVITY = "noConnectivity";
    public static String EXTRA_REASON = "reason";
    public static String EXTRA_EXTRA_INFO = "extraInfo";
    public static String EXTRA_INET_CONDITION = "inetCondition";
    public static String EXTRA_CAPTIVE_PORTAL = "android.net.extra.CAPTIVE_PORTAL";
    public static String EXTRA_CAPTIVE_PORTAL_URL = "android.net.extra.CAPTIVE_PORTAL_URL";
    public static String EXTRA_CAPTIVE_PORTAL_USER_AGENT = "android.net.extra.CAPTIVE_PORTAL_USER_AGENT";
    public static String ACTION_DATA_ACTIVITY_CHANGE = "android.net.conn.DATA_ACTIVITY_CHANGE";
    public static String EXTRA_DEVICE_TYPE = "deviceType";
    public static String EXTRA_IS_ACTIVE = "isActive";
    public static String EXTRA_REALTIME_NS = "tsNanos";
    @Deprecated
    public static String ACTION_BACKGROUND_DATA_SETTING_CHANGED = "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED";
    public static String INET_CONDITION_ACTION = "android.net.conn.INET_CONDITION_ACTION";
    public static String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    public static String EXTRA_AVAILABLE_TETHER = "availableArray";
    public static String EXTRA_ACTIVE_LOCAL_ONLY = "localOnlyArray";
    public static String EXTRA_ACTIVE_TETHER = "tetherArray";
    public static String EXTRA_ERRORED_TETHER = "erroredArray";
    public static String ACTION_CAPTIVE_PORTAL_TEST_COMPLETED = "android.net.conn.CAPTIVE_PORTAL_TEST_COMPLETED";
    public static String EXTRA_IS_CAPTIVE_PORTAL = "captivePortal";
    public static String ACTION_PROMPT_UNVALIDATED = "android.net.conn.PROMPT_UNVALIDATED";
    public static String ACTION_PROMPT_LOST_VALIDATION = "android.net.conn.PROMPT_LOST_VALIDATION";
    public static int TETHERING_INVALID = -1;
    public static int TETHERING_WIFI = 0;
    public static int TETHERING_USB = 1;
    public static int TETHERING_BLUETOOTH = 2;
    public static String EXTRA_ADD_TETHER_TYPE = "extraAddTetherType";
    public static String EXTRA_REM_TETHER_TYPE = "extraRemTetherType";
    public static String EXTRA_SET_ALARM = "extraSetAlarm";
    public static String EXTRA_RUN_PROVISION = "extraRunProvision";
    public static String EXTRA_PROVISION_CALLBACK = "extraProvisionCallback";
    public static int TYPE_NONE = -1;
    public static int TYPE_MOBILE = 0;
    public static int TYPE_WIFI = 1;
    @Deprecated
    public static int TYPE_MOBILE_MMS = 2;
    @Deprecated
    public static int TYPE_MOBILE_SUPL = 3;
    public static int TYPE_MOBILE_DUN = 4;
    @Deprecated
    public static int TYPE_MOBILE_HIPRI = 5;
    public static int TYPE_WIMAX = 6;
    public static int TYPE_BLUETOOTH = 7;
    public static int TYPE_DUMMY = 8;
    public static int TYPE_ETHERNET = 9;
    public static int TYPE_MOBILE_FOTA = 10;
    public static int TYPE_MOBILE_IMS = 11;
    public static int TYPE_MOBILE_CBS = 12;
    public static int TYPE_WIFI_P2P = 13;
    public static int TYPE_MOBILE_IA = 14;
    public static int TYPE_MOBILE_EMERGENCY = 15;
    public static int TYPE_PROXY = 16;
    public static int TYPE_VPN = 17;
    public static int MAX_RADIO_TYPE = 17;
    public static int MAX_NETWORK_TYPE = 17;
    @Deprecated
    public static int DEFAULT_NETWORK_PREFERENCE = 1;
    public static int REQUEST_ID_UNSET = 0;
    public static int NETID_UNSET = 0;
    private IConnectivityManager mService;
    private static ConnectivityManager sInstance;
    private Context mContext;
    private INetworkManagementService mNMService;
    private INetworkPolicyManager mNPManager;
    private static HashMap<NetworkCapabilities, LegacyRequest> sLegacyRequests;
    private static SparseIntArray sLegacyTypeToTransport;
    private static SparseIntArray sLegacyTypeToCapability;
    private ArrayMap<OnNetworkActiveListener, INetworkActivityListener> mNetworkActivityListeners;
    public static int TETHER_ERROR_NO_ERROR = 0;
    public static int TETHER_ERROR_UNKNOWN_IFACE = 1;
    public static int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    public static int TETHER_ERROR_UNSUPPORTED = 3;
    public static int TETHER_ERROR_UNAVAIL_IFACE = 4;
    public static int TETHER_ERROR_MASTER_ERROR = 5;
    public static int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    public static int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    public static int TETHER_ERROR_ENABLE_NAT_ERROR = 8;
    public static int TETHER_ERROR_DISABLE_NAT_ERROR = 9;
    public static int TETHER_ERROR_IFACE_CFG_ERROR = 10;
    public static int TETHER_ERROR_PROVISION_FAILED = 11;
    private static int BASE = 524288;
    public static int CALLBACK_PRECHECK = 524289;
    public static int CALLBACK_AVAILABLE = 524290;
    public static int CALLBACK_LOSING = 524291;
    public static int CALLBACK_LOST = 524292;
    public static int CALLBACK_UNAVAIL = 524293;
    public static int CALLBACK_CAP_CHANGED = 524294;
    public static int CALLBACK_IP_CHANGED = 524295;
    public static int CALLBACK_RELEASED = 524296;
    public static int CALLBACK_EXIT = 524297;
    private static int EXPIRE_LEGACY_REQUEST = 524298;
    public static int CALLBACK_SUSPENDED = 524299;
    public static int CALLBACK_RESUMED = 524300;
    private static HashMap<NetworkRequest, NetworkCallback> sCallbacks;
    private static CallbackHandler sCallbackHandler;
    private static int LISTEN = 1;
    private static int REQUEST = 2;
    public static String EXTRA_NETWORK = "android.net.extra.NETWORK";
    public static String EXTRA_NETWORK_REQUEST = "android.net.extra.NETWORK_REQUEST";
    public static int MULTIPATH_PREFERENCE_HANDOVER = 1;
    public static int MULTIPATH_PREFERENCE_RELIABILITY = 2;
    public static int MULTIPATH_PREFERENCE_PERFORMANCE = 4;
    public static int MULTIPATH_PREFERENCE_UNMETERED = 7;
    public static int RESTRICT_BACKGROUND_STATUS_DISABLED = 1;
    public static int RESTRICT_BACKGROUND_STATUS_WHITELISTED = 2;
    public static int RESTRICT_BACKGROUND_STATUS_ENABLED = 3;
    public static String ACTION_RESTRICT_BACKGROUND_CHANGED = "android.net.conn.RESTRICT_BACKGROUND_CHANGED";

    @Deprecated
    private static final boolean $$robo$$android_net_ConnectivityManager$isNetworkTypeValid(int networkType) {
        return networkType >= 0 && networkType <= 17;
    }

    private static final String $$robo$$android_net_ConnectivityManager$getNetworkTypeName(int type) {
        switch (type) {
            case 0: {
                return "MOBILE";
            }
            case 1: {
                return "WIFI";
            }
            case 2: {
                return "MOBILE_MMS";
            }
            case 3: {
                return "MOBILE_SUPL";
            }
            case 4: {
                return "MOBILE_DUN";
            }
            case 5: {
                return "MOBILE_HIPRI";
            }
            case 6: {
                return "WIMAX";
            }
            case 7: {
                return "BLUETOOTH";
            }
            case 8: {
                return "DUMMY";
            }
            case 9: {
                return "ETHERNET";
            }
            case 10: {
                return "MOBILE_FOTA";
            }
            case 11: {
                return "MOBILE_IMS";
            }
            case 12: {
                return "MOBILE_CBS";
            }
            case 13: {
                return "WIFI_P2P";
            }
            case 14: {
                return "MOBILE_IA";
            }
            case 15: {
                return "MOBILE_EMERGENCY";
            }
            case 16: {
                return "PROXY";
            }
            case 17: {
                return "VPN";
            }
        }
        return Integer.toString(type);
    }

    private static final boolean $$robo$$android_net_ConnectivityManager$isNetworkTypeMobile(int networkType) {
        switch (networkType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static final boolean $$robo$$android_net_ConnectivityManager$isNetworkTypeWifi(int networkType) {
        switch (networkType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    private final void $$robo$$android_net_ConnectivityManager$setNetworkPreference(int preference) {
    }

    @Deprecated
    private final int $$robo$$android_net_ConnectivityManager$getNetworkPreference() {
        return -1;
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getActiveNetworkInfo() {
        try {
            return this.mService.getActiveNetworkInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Network $$robo$$android_net_ConnectivityManager$getActiveNetwork() {
        try {
            return this.mService.getActiveNetwork();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Network $$robo$$android_net_ConnectivityManager$getActiveNetworkForUid(int uid) {
        return this.getActiveNetworkForUid(uid, false);
    }

    private final Network $$robo$$android_net_ConnectivityManager$getActiveNetworkForUid(int uid, boolean ignoreBlocked) {
        try {
            return this.mService.getActiveNetworkForUid(uid, ignoreBlocked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$setAlwaysOnVpnPackageForUser(int userId, String vpnPackage, boolean lockdownEnabled) {
        try {
            return this.mService.setAlwaysOnVpnPackage(userId, vpnPackage, lockdownEnabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_net_ConnectivityManager$getAlwaysOnVpnPackageForUser(int userId) {
        try {
            return this.mService.getAlwaysOnVpnPackage(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getActiveNetworkInfoForUid(int uid) {
        return this.getActiveNetworkInfoForUid(uid, false);
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getActiveNetworkInfoForUid(int uid, boolean ignoreBlocked) {
        try {
            return this.mService.getActiveNetworkInfoForUid(uid, ignoreBlocked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getNetworkInfo(int networkType) {
        try {
            return this.mService.getNetworkInfo(networkType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getNetworkInfo(Network network) {
        return this.getNetworkInfoForUid(network, Process.myUid(), false);
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getNetworkInfoForUid(Network network, int uid, boolean ignoreBlocked) {
        try {
            return this.mService.getNetworkInfoForUid(network, uid, ignoreBlocked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final NetworkInfo[] $$robo$$android_net_ConnectivityManager$getAllNetworkInfo() {
        try {
            return this.mService.getAllNetworkInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final Network $$robo$$android_net_ConnectivityManager$getNetworkForType(int networkType) {
        try {
            return this.mService.getNetworkForType(networkType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Network[] $$robo$$android_net_ConnectivityManager$getAllNetworks() {
        try {
            return this.mService.getAllNetworks();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NetworkCapabilities[] $$robo$$android_net_ConnectivityManager$getDefaultNetworkCapabilitiesForUser(int userId) {
        try {
            return this.mService.getDefaultNetworkCapabilitiesForUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final LinkProperties $$robo$$android_net_ConnectivityManager$getActiveLinkProperties() {
        try {
            return this.mService.getActiveLinkProperties();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final LinkProperties $$robo$$android_net_ConnectivityManager$getLinkProperties(int networkType) {
        try {
            return this.mService.getLinkPropertiesForType(networkType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final LinkProperties $$robo$$android_net_ConnectivityManager$getLinkProperties(Network network) {
        try {
            return this.mService.getLinkProperties(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NetworkCapabilities $$robo$$android_net_ConnectivityManager$getNetworkCapabilities(Network network) {
        try {
            return this.mService.getNetworkCapabilities(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_net_ConnectivityManager$getCaptivePortalServerUrl() {
        try {
            return this.mService.getCaptivePortalServerUrl();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final int $$robo$$android_net_ConnectivityManager$startUsingNetworkFeature(int networkType, String feature) {
        this.checkLegacyRoutingApiAccess();
        NetworkCapabilities netCap = this.networkCapabilitiesForFeature(networkType, feature);
        if (netCap == null) {
            Log.d("ConnectivityManager", "Can't satisfy startUsingNetworkFeature for " + networkType + ", " + feature);
            return 3;
        }
        NetworkRequest request = null;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l != null) {
                Log.d("ConnectivityManager", "renewing startUsingNetworkFeature request " + l.networkRequest);
                this.renewRequestLocked(l);
                if (l.currentNetwork != null) {
                    return 0;
                }
                return 1;
            }
            request = this.requestNetworkForFeatureLocked(netCap);
        }
        if (request != null) {
            Log.d("ConnectivityManager", "starting startUsingNetworkFeature for request " + request);
            return 1;
        }
        Log.d("ConnectivityManager", " request Failed");
        return 3;
    }

    @Deprecated
    private final int $$robo$$android_net_ConnectivityManager$stopUsingNetworkFeature(int networkType, String feature) {
        this.checkLegacyRoutingApiAccess();
        NetworkCapabilities netCap = this.networkCapabilitiesForFeature(networkType, feature);
        if (netCap == null) {
            Log.d("ConnectivityManager", "Can't satisfy stopUsingNetworkFeature for " + networkType + ", " + feature);
            return -1;
        }
        if (this.removeRequestForFeature(netCap)) {
            Log.d("ConnectivityManager", "stopUsingNetworkFeature for " + networkType + ", " + feature);
        }
        return 1;
    }

    private final NetworkCapabilities $$robo$$android_net_ConnectivityManager$networkCapabilitiesForFeature(int networkType, String feature) {
        if (networkType == 0) {
            switch (feature) {
                case "enableCBS": {
                    return ConnectivityManager.networkCapabilitiesForType(12);
                }
                case "enableDUN": 
                case "enableDUNAlways": {
                    return ConnectivityManager.networkCapabilitiesForType(4);
                }
                case "enableFOTA": {
                    return ConnectivityManager.networkCapabilitiesForType(10);
                }
                case "enableHIPRI": {
                    return ConnectivityManager.networkCapabilitiesForType(5);
                }
                case "enableIMS": {
                    return ConnectivityManager.networkCapabilitiesForType(11);
                }
                case "enableMMS": {
                    return ConnectivityManager.networkCapabilitiesForType(2);
                }
                case "enableSUPL": {
                    return ConnectivityManager.networkCapabilitiesForType(3);
                }
            }
            return null;
        }
        if (networkType == 1 && "p2p".equals(feature)) {
            return ConnectivityManager.networkCapabilitiesForType(13);
        }
        return null;
    }

    private final int $$robo$$android_net_ConnectivityManager$inferLegacyTypeForNetworkCapabilities(NetworkCapabilities netCap) {
        NetworkCapabilities testCap;
        if (netCap == null) {
            return -1;
        }
        if (!netCap.hasTransport(0)) {
            return -1;
        }
        if (!netCap.hasCapability(1)) {
            return -1;
        }
        String type = null;
        int result = -1;
        if (netCap.hasCapability(5)) {
            type = "enableCBS";
            result = 12;
        } else if (netCap.hasCapability(4)) {
            type = "enableIMS";
            result = 11;
        } else if (netCap.hasCapability(3)) {
            type = "enableFOTA";
            result = 10;
        } else if (netCap.hasCapability(2)) {
            type = "enableDUN";
            result = 4;
        } else if (netCap.hasCapability(1)) {
            type = "enableSUPL";
            result = 3;
        } else if (netCap.hasCapability(12)) {
            type = "enableHIPRI";
            result = 5;
        }
        if (type != null && (testCap = this.networkCapabilitiesForFeature(0, type)).equalsNetCapabilities(netCap) && testCap.equalsTransportTypes(netCap)) {
            return result;
        }
        return -1;
    }

    private final int $$robo$$android_net_ConnectivityManager$legacyTypeForNetworkCapabilities(NetworkCapabilities netCap) {
        if (netCap == null) {
            return -1;
        }
        if (netCap.hasCapability(5)) {
            return 12;
        }
        if (netCap.hasCapability(4)) {
            return 11;
        }
        if (netCap.hasCapability(3)) {
            return 10;
        }
        if (netCap.hasCapability(2)) {
            return 4;
        }
        if (netCap.hasCapability(1)) {
            return 3;
        }
        if (netCap.hasCapability(0)) {
            return 2;
        }
        if (netCap.hasCapability(12)) {
            return 5;
        }
        if (netCap.hasCapability(6)) {
            return 13;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkRequest $$robo$$android_net_ConnectivityManager$findRequestForFeature(NetworkCapabilities netCap) {
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l != null) {
                return l.networkRequest;
            }
        }
        return null;
    }

    private final void $$robo$$android_net_ConnectivityManager$renewRequestLocked(LegacyRequest l) {
        ++l.expireSequenceNumber;
        Log.d("ConnectivityManager", "renewing request to seqNum " + l.expireSequenceNumber);
        this.sendExpireMsgForFeature(l.networkCapabilities, l.expireSequenceNumber, l.delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ConnectivityManager$expireRequest(NetworkCapabilities netCap, int sequenceNum) {
        int ourSeqNum = -1;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l == null) {
                return;
            }
            ourSeqNum = l.expireSequenceNumber;
            if (l.expireSequenceNumber == sequenceNum) {
                this.removeRequestForFeature(netCap);
            }
        }
        Log.d("ConnectivityManager", "expireRequest with " + ourSeqNum + ", " + sequenceNum);
    }

    private final NetworkRequest $$robo$$android_net_ConnectivityManager$requestNetworkForFeatureLocked(NetworkCapabilities netCap) {
        int delay = -1;
        int type = this.legacyTypeForNetworkCapabilities(netCap);
        try {
            delay = this.mService.getRestoreDefaultNetworkDelay(type);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        LegacyRequest l = new LegacyRequest();
        l.networkCapabilities = netCap;
        l.delay = delay;
        l.expireSequenceNumber = 0;
        l.networkRequest = this.sendRequestForNetwork(netCap, l.networkCallback, 0, 2, type, this.getDefaultHandler());
        if (l.networkRequest == null) {
            return null;
        }
        sLegacyRequests.put(netCap, l);
        this.sendExpireMsgForFeature(netCap, l.expireSequenceNumber, delay);
        return l.networkRequest;
    }

    private final void $$robo$$android_net_ConnectivityManager$sendExpireMsgForFeature(NetworkCapabilities netCap, int seqNum, int delay) {
        if (delay >= 0) {
            Log.d("ConnectivityManager", "sending expire msg with seqNum " + seqNum + " and delay " + delay);
            CallbackHandler handler = this.getDefaultHandler();
            Message msg = handler.obtainMessage(524298, seqNum, 0, netCap);
            handler.sendMessageDelayed(msg, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_ConnectivityManager$removeRequestForFeature(NetworkCapabilities netCap) {
        LegacyRequest l;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            l = sLegacyRequests.remove(netCap);
        }
        if (l == null) {
            return false;
        }
        this.unregisterNetworkCallback(l.networkCallback);
        l.clearDnsBinding();
        return true;
    }

    private static final NetworkCapabilities $$robo$$android_net_ConnectivityManager$networkCapabilitiesForType(int type) {
        NetworkCapabilities nc = new NetworkCapabilities();
        int NOT_FOUND = -1;
        int transport = sLegacyTypeToTransport.get(type, -1);
        if (transport == -1) {
            throw new IllegalArgumentException("unknown legacy type: " + type);
        }
        nc.addTransportType(transport);
        nc.addCapability(sLegacyTypeToCapability.get(type, 12));
        nc.maybeMarkCapabilitiesRestricted();
        return nc;
    }

    private final PacketKeepalive $$robo$$android_net_ConnectivityManager$startNattKeepalive(Network network, int intervalSeconds, PacketKeepaliveCallback callback, InetAddress srcAddr, int srcPort, InetAddress dstAddr) {
        PacketKeepalive k = new PacketKeepalive(this, network, callback);
        try {
            this.mService.startNattKeepalive(network, intervalSeconds, k.mMessenger, new Binder(), srcAddr.getHostAddress(), srcPort, dstAddr.getHostAddress());
        }
        catch (RemoteException e) {
            Log.e("ConnectivityManager", "Error starting packet keepalive: ", e);
            k.stopLooper();
            return null;
        }
        return k;
    }

    @Deprecated
    private final boolean $$robo$$android_net_ConnectivityManager$requestRouteToHost(int networkType, int hostAddress) {
        return this.requestRouteToHostAddress(networkType, NetworkUtils.intToInetAddress(hostAddress));
    }

    @Deprecated
    private final boolean $$robo$$android_net_ConnectivityManager$requestRouteToHostAddress(int networkType, InetAddress hostAddress) {
        this.checkLegacyRoutingApiAccess();
        try {
            return this.mService.requestRouteToHostAddress(networkType, hostAddress.getAddress());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_net_ConnectivityManager$getBackgroundDataSetting() {
        return true;
    }

    @Deprecated
    private final void $$robo$$android_net_ConnectivityManager$setBackgroundDataSetting(boolean allowBackgroundData) {
    }

    private final NetworkQuotaInfo $$robo$$android_net_ConnectivityManager$getActiveNetworkQuotaInfo() {
        try {
            return this.mService.getActiveNetworkQuotaInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_net_ConnectivityManager$getMobileDataEnabled() {
        IBinder b = ServiceManager.getService("phone");
        if (b != null) {
            try {
                ITelephony it = ITelephony.Stub.asInterface(b);
                int subId = SubscriptionManager.getDefaultDataSubscriptionId();
                Log.d("ConnectivityManager", "getMobileDataEnabled()+ subId=" + subId);
                boolean retVal = it.getDataEnabled(subId);
                Log.d("ConnectivityManager", "getMobileDataEnabled()- subId=" + subId + " retVal=" + retVal);
                return retVal;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Log.d("ConnectivityManager", "getMobileDataEnabled()- remote exception retVal=false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final INetworkManagementService $$robo$$android_net_ConnectivityManager$getNetworkManagementService() {
        ConnectivityManager connectivityManager = this;
        synchronized (connectivityManager) {
            if (this.mNMService != null) {
                return this.mNMService;
            }
            IBinder b = ServiceManager.getService("network_management");
            this.mNMService = INetworkManagementService.Stub.asInterface(b);
            return this.mNMService;
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$addDefaultNetworkActiveListener(OnNetworkActiveListener l) {
        ShadowedObject rl = new ShadowedObject(this, l){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ OnNetworkActiveListener val$l;
            /* synthetic */ ConnectivityManager this$0;

            private void $$robo$$android_net_ConnectivityManager_1$__constructor__(ConnectivityManager this$0, OnNetworkActiveListener onNetworkActiveListener) {
            }

            private final void $$robo$$android_net_ConnectivityManager_1$onNetworkActive() throws RemoteException {
                this.val$l.onNetworkActive();
            }

            private void __constructor__(ConnectivityManager connectivityManager, OnNetworkActiveListener onNetworkActiveListener) {
                this.$$robo$$android_net_ConnectivityManager_1$__constructor__(connectivityManager, onNetworkActiveListener);
            }
            {
                this.this$0 = connectivityManager;
                this.val$l = onNetworkActiveListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_1$__constructor__(android.net.ConnectivityManager android.net.ConnectivityManager$OnNetworkActiveListener ), 0, this, connectivityManager, onNetworkActiveListener);
            }

            @Override
            public void onNetworkActive() throws RemoteException {
                InvokeDynamicSupport.bootstrap("onNetworkActive", $$robo$$android_net_ConnectivityManager_1$onNetworkActive(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            this.getNetworkManagementService().registerNetworkActivityListener((INetworkActivityListener)rl);
            this.mNetworkActivityListeners.put(l, (INetworkActivityListener)rl);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$removeDefaultNetworkActiveListener(OnNetworkActiveListener l) {
        INetworkActivityListener rl = this.mNetworkActivityListeners.get(l);
        if (rl == null) {
            throw new IllegalArgumentException("Listener not registered: " + l);
        }
        try {
            this.getNetworkManagementService().unregisterNetworkActivityListener(rl);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isDefaultNetworkActive() {
        try {
            return this.getNetworkManagementService().isNetworkActive();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void $$robo$$android_net_ConnectivityManager$__constructor__(Context context, IConnectivityManager service) {
        this.mNetworkActivityListeners = new ArrayMap();
        this.mContext = Preconditions.checkNotNull(context, "missing context");
        this.mService = Preconditions.checkNotNull(service, "missing IConnectivityManager");
        sInstance = this;
    }

    private static final ConnectivityManager $$robo$$android_net_ConnectivityManager$from(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    private static final boolean $$robo$$android_net_ConnectivityManager$checkChangePermission(Context context) {
        int uid = Binder.getCallingUid();
        return Settings.checkAndNoteChangeNetworkStateOperation(context, uid, Settings.getPackageNameForUid(context, uid), false);
    }

    private static final void $$robo$$android_net_ConnectivityManager$enforceChangePermission(Context context) {
        int uid = Binder.getCallingUid();
        Settings.checkAndNoteChangeNetworkStateOperation(context, uid, Settings.getPackageNameForUid(context, uid), true);
    }

    private static final void $$robo$$android_net_ConnectivityManager$enforceTetherChangePermission(Context context) {
        if (context.getResources().getStringArray(17236013).length == 2) {
            context.enforceCallingOrSelfPermission("android.permission.TETHER_PRIVILEGED", "ConnectivityService");
        } else {
            int uid = Binder.getCallingUid();
            Settings.checkAndNoteWriteSettingsOperation(context, uid, Settings.getPackageNameForUid(context, uid), true);
        }
    }

    @Deprecated
    private static final ConnectivityManager $$robo$$android_net_ConnectivityManager$getInstanceOrNull() {
        return sInstance;
    }

    @Deprecated
    private static final ConnectivityManager $$robo$$android_net_ConnectivityManager$getInstance() {
        if (ConnectivityManager.getInstanceOrNull() == null) {
            throw new IllegalStateException("No ConnectivityManager yet constructed");
        }
        return ConnectivityManager.getInstanceOrNull();
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableIfaces() {
        try {
            return this.mService.getTetherableIfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetheredIfaces() {
        try {
            return this.mService.getTetheredIfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetheringErroredIfaces() {
        try {
            return this.mService.getTetheringErroredIfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetheredDhcpRanges() {
        try {
            return this.mService.getTetheredDhcpRanges();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$tether(String iface) {
        try {
            return this.mService.tether(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$untether(String iface) {
        try {
            return this.mService.untether(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isTetheringSupported() {
        try {
            return this.mService.isTetheringSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$startTethering(int type, boolean showProvisioningUi, OnStartTetheringCallback callback) {
        this.startTethering(type, showProvisioningUi, callback, null);
    }

    private final void $$robo$$android_net_ConnectivityManager$startTethering(int type, boolean showProvisioningUi, OnStartTetheringCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback, "OnStartTetheringCallback cannot be null.");
        ShadowedObject wrappedCallback = new ShadowedObject(this, handler, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ OnStartTetheringCallback val$callback;
            /* synthetic */ ConnectivityManager this$0;

            private void $$robo$$android_net_ConnectivityManager_2$__constructor__(ConnectivityManager this$0, Handler handler, OnStartTetheringCallback onStartTetheringCallback) {
            }

            private final void $$robo$$android_net_ConnectivityManager_2$onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 0) {
                    this.val$callback.onTetheringStarted();
                } else {
                    this.val$callback.onTetheringFailed();
                }
            }

            private void __constructor__(ConnectivityManager connectivityManager, Handler handler, OnStartTetheringCallback onStartTetheringCallback) {
                this.$$robo$$android_net_ConnectivityManager_2$__constructor__(connectivityManager, handler, onStartTetheringCallback);
            }
            {
                this.this$0 = connectivityManager;
                this.val$callback = onStartTetheringCallback;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_2$__constructor__(android.net.ConnectivityManager android.os.Handler android.net.ConnectivityManager$OnStartTetheringCallback ), 0, this, connectivityManager, handler, onStartTetheringCallback);
            }

            @Override
            protected void onReceiveResult(int n, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("onReceiveResult", $$robo$$android_net_ConnectivityManager_2$onReceiveResult(int android.os.Bundle ), 0, this, n, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            this.mService.startTethering(type, (ResultReceiver)wrappedCallback, showProvisioningUi);
        }
        catch (RemoteException e) {
            Log.e("ConnectivityManager", "Exception trying to start tethering.", e);
            wrappedCallback.send(2, null);
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$stopTethering(int type) {
        try {
            this.mService.stopTethering(type);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableUsbRegexs() {
        try {
            return this.mService.getTetherableUsbRegexs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableWifiRegexs() {
        try {
            return this.mService.getTetherableWifiRegexs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableBluetoothRegexs() {
        try {
            return this.mService.getTetherableBluetoothRegexs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$setUsbTethering(boolean enable) {
        try {
            return this.mService.setUsbTethering(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$getLastTetherError(String iface) {
        try {
            return this.mService.getLastTetherError(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$reportInetCondition(int networkType, int percentage) {
        try {
            this.mService.reportInetCondition(networkType, percentage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_net_ConnectivityManager$reportBadNetwork(Network network) {
        try {
            this.mService.reportNetworkConnectivity(network, true);
            this.mService.reportNetworkConnectivity(network, false);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$reportNetworkConnectivity(Network network, boolean hasConnectivity) {
        try {
            this.mService.reportNetworkConnectivity(network, hasConnectivity);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$setGlobalProxy(ProxyInfo p) {
        try {
            this.mService.setGlobalProxy(p);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ProxyInfo $$robo$$android_net_ConnectivityManager$getGlobalProxy() {
        try {
            return this.mService.getGlobalProxy();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ProxyInfo $$robo$$android_net_ConnectivityManager$getProxyForNetwork(Network network) {
        try {
            return this.mService.getProxyForNetwork(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ProxyInfo $$robo$$android_net_ConnectivityManager$getDefaultProxy() {
        return this.getProxyForNetwork(this.getBoundNetworkForProcess());
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isNetworkSupported(int networkType) {
        try {
            return this.mService.isNetworkSupported(networkType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isActiveNetworkMetered() {
        try {
            return this.mService.isActiveNetworkMetered();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$updateLockdownVpn() {
        try {
            return this.mService.updateLockdownVpn();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$checkMobileProvisioning(int suggestedTimeOutMs) {
        int timeOutMs = -1;
        try {
            timeOutMs = this.mService.checkMobileProvisioning(suggestedTimeOutMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return timeOutMs;
    }

    private final String $$robo$$android_net_ConnectivityManager$getMobileProvisioningUrl() {
        try {
            return this.mService.getMobileProvisioningUrl();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_net_ConnectivityManager$setProvisioningNotificationVisible(boolean visible, int networkType, String action) {
        try {
            this.mService.setProvisioningNotificationVisible(visible, networkType, action);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$setAirplaneMode(boolean enable) {
        try {
            this.mService.setAirplaneMode(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$registerNetworkFactory(Messenger messenger, String name) {
        try {
            this.mService.registerNetworkFactory(messenger, name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$unregisterNetworkFactory(Messenger messenger) {
        try {
            this.mService.unregisterNetworkFactory(messenger);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$registerNetworkAgent(Messenger messenger, NetworkInfo ni, LinkProperties lp, NetworkCapabilities nc, int score, NetworkMisc misc) {
        try {
            return this.mService.registerNetworkAgent(messenger, ni, lp, nc, score, misc);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final String $$robo$$android_net_ConnectivityManager$getCallbackName(int whichCallback) {
        switch (whichCallback) {
            case 524289: {
                return "CALLBACK_PRECHECK";
            }
            case 524290: {
                return "CALLBACK_AVAILABLE";
            }
            case 524291: {
                return "CALLBACK_LOSING";
            }
            case 524292: {
                return "CALLBACK_LOST";
            }
            case 524293: {
                return "CALLBACK_UNAVAIL";
            }
            case 524294: {
                return "CALLBACK_CAP_CHANGED";
            }
            case 524295: {
                return "CALLBACK_IP_CHANGED";
            }
            case 524296: {
                return "CALLBACK_RELEASED";
            }
            case 524297: {
                return "CALLBACK_EXIT";
            }
            case 524298: {
                return "EXPIRE_LEGACY_REQUEST";
            }
            case 524299: {
                return "CALLBACK_SUSPENDED";
            }
            case 524300: {
                return "CALLBACK_RESUMED";
            }
        }
        return Integer.toString(whichCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CallbackHandler $$robo$$android_net_ConnectivityManager$getDefaultHandler() {
        HashMap<NetworkRequest, NetworkCallback> hashMap = sCallbacks;
        synchronized (hashMap) {
            if (sCallbackHandler == null) {
                sCallbackHandler = new CallbackHandler(this, ConnectivityThread.getInstanceLooper());
            }
            return sCallbackHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkRequest $$robo$$android_net_ConnectivityManager$sendRequestForNetwork(NetworkCapabilities need, NetworkCallback callback, int timeoutMs, int action, int legacyType, CallbackHandler handler) {
        NetworkRequest request;
        if (callback == null) {
            throw new IllegalArgumentException("null NetworkCallback");
        }
        if (need == null && action != 2) {
            throw new IllegalArgumentException("null NetworkCapabilities");
        }
        try {
            HashMap<NetworkRequest, NetworkCallback> hashMap = sCallbacks;
            synchronized (hashMap) {
                Messenger messenger = new Messenger(handler);
                Binder binder = new Binder();
                request = action == 1 ? this.mService.listenForNetwork(need, messenger, binder) : this.mService.requestNetwork(need, messenger, timeoutMs, binder, legacyType);
                if (request != null) {
                    sCallbacks.put(request, callback);
                }
                callback.networkRequest = request;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return request;
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, NetworkCallback networkCallback, int timeoutMs, int legacyType, Handler handler) {
        CallbackHandler cbHandler = new CallbackHandler(this, handler);
        NetworkCapabilities nc = request.networkCapabilities;
        this.sendRequestForNetwork(nc, networkCallback, timeoutMs, 2, legacyType, cbHandler);
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, NetworkCallback networkCallback) {
        this.requestNetwork(request, networkCallback, this.getDefaultHandler());
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, NetworkCallback networkCallback, Handler handler) {
        int legacyType = this.inferLegacyTypeForNetworkCapabilities(request.networkCapabilities);
        CallbackHandler cbHandler = new CallbackHandler(this, handler);
        this.requestNetwork(request, networkCallback, 0, legacyType, cbHandler);
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, NetworkCallback networkCallback, int timeoutMs) {
        if (timeoutMs <= 0) {
            throw new IllegalArgumentException("Non-positive timeoutMs: " + timeoutMs);
        }
        int legacyType = this.inferLegacyTypeForNetworkCapabilities(request.networkCapabilities);
        this.requestNetwork(request, networkCallback, timeoutMs, legacyType, this.getDefaultHandler());
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, NetworkCallback networkCallback, Handler handler, int timeoutMs) {
        if (timeoutMs <= 0) {
            throw new IllegalArgumentException("Non-positive timeoutMs");
        }
        int legacyType = this.inferLegacyTypeForNetworkCapabilities(request.networkCapabilities);
        CallbackHandler cbHandler = new CallbackHandler(this, handler);
        this.requestNetwork(request, networkCallback, timeoutMs, legacyType, cbHandler);
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, PendingIntent operation) {
        this.checkPendingIntent(operation);
        try {
            this.mService.pendingRequestForNetwork(request.networkCapabilities, operation);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$releaseNetworkRequest(PendingIntent operation) {
        this.checkPendingIntent(operation);
        try {
            this.mService.releasePendingNetworkRequest(operation);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$checkPendingIntent(PendingIntent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("PendingIntent cannot be null.");
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$registerNetworkCallback(NetworkRequest request, NetworkCallback networkCallback) {
        this.registerNetworkCallback(request, networkCallback, this.getDefaultHandler());
    }

    private final void $$robo$$android_net_ConnectivityManager$registerNetworkCallback(NetworkRequest request, NetworkCallback networkCallback, Handler handler) {
        CallbackHandler cbHandler = new CallbackHandler(this, handler);
        NetworkCapabilities nc = request.networkCapabilities;
        this.sendRequestForNetwork(nc, networkCallback, 0, 1, -1, cbHandler);
    }

    private final void $$robo$$android_net_ConnectivityManager$registerNetworkCallback(NetworkRequest request, PendingIntent operation) {
        this.checkPendingIntent(operation);
        try {
            this.mService.pendingListenForNetwork(request.networkCapabilities, operation);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$registerDefaultNetworkCallback(NetworkCallback networkCallback) {
        this.registerDefaultNetworkCallback(networkCallback, this.getDefaultHandler());
    }

    private final void $$robo$$android_net_ConnectivityManager$registerDefaultNetworkCallback(NetworkCallback networkCallback, Handler handler) {
        CallbackHandler cbHandler = new CallbackHandler(this, handler);
        this.sendRequestForNetwork(null, networkCallback, 0, 2, -1, cbHandler);
    }

    private final boolean $$robo$$android_net_ConnectivityManager$requestBandwidthUpdate(Network network) {
        try {
            return this.mService.requestBandwidthUpdate(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$unregisterNetworkCallback(NetworkCallback networkCallback) {
        if (networkCallback == null || networkCallback.networkRequest == null || ((NetworkCallback)networkCallback).networkRequest.requestId == 0) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        try {
            this.mService.releaseNetworkRequest(networkCallback.networkRequest);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$unregisterNetworkCallback(PendingIntent operation) {
        this.releaseNetworkRequest(operation);
    }

    private final void $$robo$$android_net_ConnectivityManager$setAcceptUnvalidated(Network network, boolean accept, boolean always) {
        try {
            this.mService.setAcceptUnvalidated(network, accept, always);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$setAvoidUnvalidated(Network network) {
        try {
            this.mService.setAvoidUnvalidated(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$startCaptivePortalApp(Network network) {
        try {
            this.mService.startCaptivePortalApp(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$getMultipathPreference(Network network) {
        try {
            return this.mService.getMultipathPreference(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$factoryReset() {
        try {
            this.mService.factoryReset();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$bindProcessToNetwork(Network network) {
        return ConnectivityManager.setProcessDefaultNetwork(network);
    }

    @Deprecated
    private static final boolean $$robo$$android_net_ConnectivityManager$setProcessDefaultNetwork(Network network) {
        int netId;
        int n = netId = network == null ? 0 : network.netId;
        if (netId == NetworkUtils.getBoundNetworkForProcess()) {
            return true;
        }
        if (NetworkUtils.bindProcessToNetwork(netId)) {
            try {
                Proxy.setHttpProxySystemProperty(ConnectivityManager.getInstance().getDefaultProxy());
            }
            catch (SecurityException e) {
                Log.e("ConnectivityManager", "Can't set proxy properties", e);
            }
            InetAddress.clearDnsCache();
            NetworkEventDispatcher.getInstance().onNetworkConfigurationChanged();
            return true;
        }
        return false;
    }

    private final Network $$robo$$android_net_ConnectivityManager$getBoundNetworkForProcess() {
        return ConnectivityManager.getProcessDefaultNetwork();
    }

    @Deprecated
    private static final Network $$robo$$android_net_ConnectivityManager$getProcessDefaultNetwork() {
        int netId = NetworkUtils.getBoundNetworkForProcess();
        if (netId == 0) {
            return null;
        }
        return new Network(netId);
    }

    private final void $$robo$$android_net_ConnectivityManager$unsupportedStartingFrom(int version) {
        if (Process.myUid() == 1000) {
            return;
        }
        if (this.mContext.getApplicationInfo().targetSdkVersion >= version) {
            throw new UnsupportedOperationException("This method is not supported in target SDK version " + version + " and above");
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$checkLegacyRoutingApiAccess() {
        if (this.mContext.checkCallingOrSelfPermission("com.android.permission.INJECT_OMADM_SETTINGS") == 0) {
            return;
        }
        this.unsupportedStartingFrom(23);
    }

    @Deprecated
    private static final boolean $$robo$$android_net_ConnectivityManager$setProcessDefaultNetworkForHostResolution(Network network) {
        return NetworkUtils.bindProcessToNetworkForHostResolution(network == null ? 0 : network.netId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final INetworkPolicyManager $$robo$$android_net_ConnectivityManager$getNetworkPolicyManager() {
        ConnectivityManager connectivityManager = this;
        synchronized (connectivityManager) {
            if (this.mNPManager != null) {
                return this.mNPManager;
            }
            this.mNPManager = INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy"));
            return this.mNPManager;
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$getRestrictBackgroundStatus() {
        try {
            return this.getNetworkPolicyManager().getRestrictBackgroundByCaller();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final String $$robo$$android_net_ConnectivityManager$whatToString(int what) {
        return NoPreloadHolder.sMagicDecoderRing.get(what, Integer.toString(what));
    }

    static void __staticInitializer__() {
        sLegacyRequests = new HashMap();
        sLegacyTypeToTransport = new SparseIntArray();
        sLegacyTypeToTransport.put(0, 0);
        sLegacyTypeToTransport.put(12, 0);
        sLegacyTypeToTransport.put(4, 0);
        sLegacyTypeToTransport.put(10, 0);
        sLegacyTypeToTransport.put(5, 0);
        sLegacyTypeToTransport.put(11, 0);
        sLegacyTypeToTransport.put(2, 0);
        sLegacyTypeToTransport.put(3, 0);
        sLegacyTypeToTransport.put(1, 1);
        sLegacyTypeToTransport.put(13, 1);
        sLegacyTypeToTransport.put(7, 2);
        sLegacyTypeToTransport.put(9, 3);
        sLegacyTypeToCapability = new SparseIntArray();
        sLegacyTypeToCapability.put(12, 5);
        sLegacyTypeToCapability.put(4, 2);
        sLegacyTypeToCapability.put(10, 3);
        sLegacyTypeToCapability.put(11, 4);
        sLegacyTypeToCapability.put(2, 0);
        sLegacyTypeToCapability.put(3, 1);
        sLegacyTypeToCapability.put(13, 6);
        sCallbacks = new HashMap();
    }

    @Deprecated
    public static boolean isNetworkTypeValid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNetworkTypeValid", $$robo$$android_net_ConnectivityManager$isNetworkTypeValid(int ), 0, (int)n);
    }

    public static String getNetworkTypeName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkTypeName", $$robo$$android_net_ConnectivityManager$getNetworkTypeName(int ), 0, (int)n);
    }

    public static boolean isNetworkTypeMobile(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNetworkTypeMobile", $$robo$$android_net_ConnectivityManager$isNetworkTypeMobile(int ), 0, (int)n);
    }

    public static boolean isNetworkTypeWifi(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNetworkTypeWifi", $$robo$$android_net_ConnectivityManager$isNetworkTypeWifi(int ), 0, (int)n);
    }

    @Deprecated
    public void setNetworkPreference(int n) {
        InvokeDynamicSupport.bootstrap("setNetworkPreference", $$robo$$android_net_ConnectivityManager$setNetworkPreference(int ), 0, this, n);
    }

    @Deprecated
    public int getNetworkPreference() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkPreference", $$robo$$android_net_ConnectivityManager$getNetworkPreference(), 0, this);
    }

    public NetworkInfo getActiveNetworkInfo() {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkInfo", $$robo$$android_net_ConnectivityManager$getActiveNetworkInfo(), 0, this);
    }

    public Network getActiveNetwork() {
        return InvokeDynamicSupport.bootstrap("getActiveNetwork", $$robo$$android_net_ConnectivityManager$getActiveNetwork(), 0, this);
    }

    public Network getActiveNetworkForUid(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkForUid", $$robo$$android_net_ConnectivityManager$getActiveNetworkForUid(int ), 0, this, n);
    }

    public Network getActiveNetworkForUid(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkForUid", $$robo$$android_net_ConnectivityManager$getActiveNetworkForUid(int boolean ), 0, this, n, bl);
    }

    public boolean setAlwaysOnVpnPackageForUser(int n, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setAlwaysOnVpnPackageForUser", $$robo$$android_net_ConnectivityManager$setAlwaysOnVpnPackageForUser(int java.lang.String boolean ), 0, this, n, string2, bl);
    }

    public String getAlwaysOnVpnPackageForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getAlwaysOnVpnPackageForUser", $$robo$$android_net_ConnectivityManager$getAlwaysOnVpnPackageForUser(int ), 0, this, n);
    }

    public NetworkInfo getActiveNetworkInfoForUid(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkInfoForUid", $$robo$$android_net_ConnectivityManager$getActiveNetworkInfoForUid(int ), 0, this, n);
    }

    public NetworkInfo getActiveNetworkInfoForUid(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkInfoForUid", $$robo$$android_net_ConnectivityManager$getActiveNetworkInfoForUid(int boolean ), 0, this, n, bl);
    }

    @Deprecated
    public NetworkInfo getNetworkInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkInfo", $$robo$$android_net_ConnectivityManager$getNetworkInfo(int ), 0, this, n);
    }

    public NetworkInfo getNetworkInfo(Network network) {
        return InvokeDynamicSupport.bootstrap("getNetworkInfo", $$robo$$android_net_ConnectivityManager$getNetworkInfo(android.net.Network ), 0, this, network);
    }

    public NetworkInfo getNetworkInfoForUid(Network network, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getNetworkInfoForUid", $$robo$$android_net_ConnectivityManager$getNetworkInfoForUid(android.net.Network int boolean ), 0, this, network, n, bl);
    }

    @Deprecated
    public NetworkInfo[] getAllNetworkInfo() {
        return InvokeDynamicSupport.bootstrap("getAllNetworkInfo", $$robo$$android_net_ConnectivityManager$getAllNetworkInfo(), 0, this);
    }

    @Deprecated
    public Network getNetworkForType(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkForType", $$robo$$android_net_ConnectivityManager$getNetworkForType(int ), 0, this, n);
    }

    public Network[] getAllNetworks() {
        return InvokeDynamicSupport.bootstrap("getAllNetworks", $$robo$$android_net_ConnectivityManager$getAllNetworks(), 0, this);
    }

    public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getDefaultNetworkCapabilitiesForUser", $$robo$$android_net_ConnectivityManager$getDefaultNetworkCapabilitiesForUser(int ), 0, this, n);
    }

    public LinkProperties getActiveLinkProperties() {
        return InvokeDynamicSupport.bootstrap("getActiveLinkProperties", $$robo$$android_net_ConnectivityManager$getActiveLinkProperties(), 0, this);
    }

    @Deprecated
    public LinkProperties getLinkProperties(int n) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$android_net_ConnectivityManager$getLinkProperties(int ), 0, this, n);
    }

    public LinkProperties getLinkProperties(Network network) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$android_net_ConnectivityManager$getLinkProperties(android.net.Network ), 0, this, network);
    }

    public NetworkCapabilities getNetworkCapabilities(Network network) {
        return InvokeDynamicSupport.bootstrap("getNetworkCapabilities", $$robo$$android_net_ConnectivityManager$getNetworkCapabilities(android.net.Network ), 0, this, network);
    }

    public String getCaptivePortalServerUrl() {
        return InvokeDynamicSupport.bootstrap("getCaptivePortalServerUrl", $$robo$$android_net_ConnectivityManager$getCaptivePortalServerUrl(), 0, this);
    }

    @Deprecated
    public int startUsingNetworkFeature(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("startUsingNetworkFeature", $$robo$$android_net_ConnectivityManager$startUsingNetworkFeature(int java.lang.String ), 0, this, n, string2);
    }

    @Deprecated
    public int stopUsingNetworkFeature(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("stopUsingNetworkFeature", $$robo$$android_net_ConnectivityManager$stopUsingNetworkFeature(int java.lang.String ), 0, this, n, string2);
    }

    private NetworkCapabilities networkCapabilitiesForFeature(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("networkCapabilitiesForFeature", $$robo$$android_net_ConnectivityManager$networkCapabilitiesForFeature(int java.lang.String ), 0, this, n, string2);
    }

    private int inferLegacyTypeForNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (int)InvokeDynamicSupport.bootstrap("inferLegacyTypeForNetworkCapabilities", $$robo$$android_net_ConnectivityManager$inferLegacyTypeForNetworkCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private int legacyTypeForNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (int)InvokeDynamicSupport.bootstrap("legacyTypeForNetworkCapabilities", $$robo$$android_net_ConnectivityManager$legacyTypeForNetworkCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private NetworkRequest findRequestForFeature(NetworkCapabilities networkCapabilities) {
        return InvokeDynamicSupport.bootstrap("findRequestForFeature", $$robo$$android_net_ConnectivityManager$findRequestForFeature(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private void renewRequestLocked(LegacyRequest legacyRequest) {
        InvokeDynamicSupport.bootstrap("renewRequestLocked", $$robo$$android_net_ConnectivityManager$renewRequestLocked(android.net.ConnectivityManager$LegacyRequest ), 0, this, legacyRequest);
    }

    private void expireRequest(NetworkCapabilities networkCapabilities, int n) {
        InvokeDynamicSupport.bootstrap("expireRequest", $$robo$$android_net_ConnectivityManager$expireRequest(android.net.NetworkCapabilities int ), 0, this, networkCapabilities, n);
    }

    private NetworkRequest requestNetworkForFeatureLocked(NetworkCapabilities networkCapabilities) {
        return InvokeDynamicSupport.bootstrap("requestNetworkForFeatureLocked", $$robo$$android_net_ConnectivityManager$requestNetworkForFeatureLocked(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private void sendExpireMsgForFeature(NetworkCapabilities networkCapabilities, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendExpireMsgForFeature", $$robo$$android_net_ConnectivityManager$sendExpireMsgForFeature(android.net.NetworkCapabilities int int ), 0, this, networkCapabilities, n, n2);
    }

    private boolean removeRequestForFeature(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeRequestForFeature", $$robo$$android_net_ConnectivityManager$removeRequestForFeature(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public static NetworkCapabilities networkCapabilitiesForType(int n) {
        return InvokeDynamicSupport.bootstrapStatic("networkCapabilitiesForType", $$robo$$android_net_ConnectivityManager$networkCapabilitiesForType(int ), 0, (int)n);
    }

    public PacketKeepalive startNattKeepalive(Network network, int n, PacketKeepaliveCallback packetKeepaliveCallback, InetAddress inetAddress, int n2, InetAddress inetAddress2) {
        return InvokeDynamicSupport.bootstrap("startNattKeepalive", $$robo$$android_net_ConnectivityManager$startNattKeepalive(android.net.Network int android.net.ConnectivityManager$PacketKeepaliveCallback java.net.InetAddress int java.net.InetAddress ), 0, this, network, n, packetKeepaliveCallback, inetAddress, n2, inetAddress2);
    }

    @Deprecated
    public boolean requestRouteToHost(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestRouteToHost", $$robo$$android_net_ConnectivityManager$requestRouteToHost(int int ), 0, this, n, n2);
    }

    @Deprecated
    public boolean requestRouteToHostAddress(int n, InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestRouteToHostAddress", $$robo$$android_net_ConnectivityManager$requestRouteToHostAddress(int java.net.InetAddress ), 0, this, n, inetAddress);
    }

    @Deprecated
    public boolean getBackgroundDataSetting() {
        return (boolean)InvokeDynamicSupport.bootstrap("getBackgroundDataSetting", $$robo$$android_net_ConnectivityManager$getBackgroundDataSetting(), 0, this);
    }

    @Deprecated
    public void setBackgroundDataSetting(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackgroundDataSetting", $$robo$$android_net_ConnectivityManager$setBackgroundDataSetting(boolean ), 0, this, bl);
    }

    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkQuotaInfo", $$robo$$android_net_ConnectivityManager$getActiveNetworkQuotaInfo(), 0, this);
    }

    @Deprecated
    public boolean getMobileDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMobileDataEnabled", $$robo$$android_net_ConnectivityManager$getMobileDataEnabled(), 0, this);
    }

    private INetworkManagementService getNetworkManagementService() {
        return InvokeDynamicSupport.bootstrap("getNetworkManagementService", $$robo$$android_net_ConnectivityManager$getNetworkManagementService(), 0, this);
    }

    public void addDefaultNetworkActiveListener(OnNetworkActiveListener onNetworkActiveListener) {
        InvokeDynamicSupport.bootstrap("addDefaultNetworkActiveListener", $$robo$$android_net_ConnectivityManager$addDefaultNetworkActiveListener(android.net.ConnectivityManager$OnNetworkActiveListener ), 0, this, onNetworkActiveListener);
    }

    public void removeDefaultNetworkActiveListener(OnNetworkActiveListener onNetworkActiveListener) {
        InvokeDynamicSupport.bootstrap("removeDefaultNetworkActiveListener", $$robo$$android_net_ConnectivityManager$removeDefaultNetworkActiveListener(android.net.ConnectivityManager$OnNetworkActiveListener ), 0, this, onNetworkActiveListener);
    }

    public boolean isDefaultNetworkActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultNetworkActive", $$robo$$android_net_ConnectivityManager$isDefaultNetworkActive(), 0, this);
    }

    private void __constructor__(Context context, IConnectivityManager iConnectivityManager) {
        this.$$robo$$android_net_ConnectivityManager$__constructor__(context, iConnectivityManager);
    }

    public ConnectivityManager(Context context, IConnectivityManager iConnectivityManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager$__constructor__(android.content.Context android.net.IConnectivityManager ), 0, this, context, iConnectivityManager);
    }

    public static ConnectivityManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_net_ConnectivityManager$from(android.content.Context ), 0, (Context)context);
    }

    public static boolean checkChangePermission(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkChangePermission", $$robo$$android_net_ConnectivityManager$checkChangePermission(android.content.Context ), 0, (Context)context);
    }

    public static void enforceChangePermission(Context context) {
        InvokeDynamicSupport.bootstrapStatic("enforceChangePermission", $$robo$$android_net_ConnectivityManager$enforceChangePermission(android.content.Context ), 0, (Context)context);
    }

    public static void enforceTetherChangePermission(Context context) {
        InvokeDynamicSupport.bootstrapStatic("enforceTetherChangePermission", $$robo$$android_net_ConnectivityManager$enforceTetherChangePermission(android.content.Context ), 0, (Context)context);
    }

    @Deprecated
    static ConnectivityManager getInstanceOrNull() {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceOrNull", $$robo$$android_net_ConnectivityManager$getInstanceOrNull(), 0);
    }

    @Deprecated
    private static ConnectivityManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_net_ConnectivityManager$getInstance(), 0);
    }

    public String[] getTetherableIfaces() {
        return InvokeDynamicSupport.bootstrap("getTetherableIfaces", $$robo$$android_net_ConnectivityManager$getTetherableIfaces(), 0, this);
    }

    public String[] getTetheredIfaces() {
        return InvokeDynamicSupport.bootstrap("getTetheredIfaces", $$robo$$android_net_ConnectivityManager$getTetheredIfaces(), 0, this);
    }

    public String[] getTetheringErroredIfaces() {
        return InvokeDynamicSupport.bootstrap("getTetheringErroredIfaces", $$robo$$android_net_ConnectivityManager$getTetheringErroredIfaces(), 0, this);
    }

    public String[] getTetheredDhcpRanges() {
        return InvokeDynamicSupport.bootstrap("getTetheredDhcpRanges", $$robo$$android_net_ConnectivityManager$getTetheredDhcpRanges(), 0, this);
    }

    public int tether(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("tether", $$robo$$android_net_ConnectivityManager$tether(java.lang.String ), 0, this, string2);
    }

    public int untether(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("untether", $$robo$$android_net_ConnectivityManager$untether(java.lang.String ), 0, this, string2);
    }

    public boolean isTetheringSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTetheringSupported", $$robo$$android_net_ConnectivityManager$isTetheringSupported(), 0, this);
    }

    public void startTethering(int n, boolean bl, OnStartTetheringCallback onStartTetheringCallback) {
        InvokeDynamicSupport.bootstrap("startTethering", $$robo$$android_net_ConnectivityManager$startTethering(int boolean android.net.ConnectivityManager$OnStartTetheringCallback ), 0, this, n, bl, onStartTetheringCallback);
    }

    public void startTethering(int n, boolean bl, OnStartTetheringCallback onStartTetheringCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("startTethering", $$robo$$android_net_ConnectivityManager$startTethering(int boolean android.net.ConnectivityManager$OnStartTetheringCallback android.os.Handler ), 0, this, n, bl, onStartTetheringCallback, handler);
    }

    public void stopTethering(int n) {
        InvokeDynamicSupport.bootstrap("stopTethering", $$robo$$android_net_ConnectivityManager$stopTethering(int ), 0, this, n);
    }

    public String[] getTetherableUsbRegexs() {
        return InvokeDynamicSupport.bootstrap("getTetherableUsbRegexs", $$robo$$android_net_ConnectivityManager$getTetherableUsbRegexs(), 0, this);
    }

    public String[] getTetherableWifiRegexs() {
        return InvokeDynamicSupport.bootstrap("getTetherableWifiRegexs", $$robo$$android_net_ConnectivityManager$getTetherableWifiRegexs(), 0, this);
    }

    public String[] getTetherableBluetoothRegexs() {
        return InvokeDynamicSupport.bootstrap("getTetherableBluetoothRegexs", $$robo$$android_net_ConnectivityManager$getTetherableBluetoothRegexs(), 0, this);
    }

    public int setUsbTethering(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setUsbTethering", $$robo$$android_net_ConnectivityManager$setUsbTethering(boolean ), 0, this, bl);
    }

    public int getLastTetherError(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getLastTetherError", $$robo$$android_net_ConnectivityManager$getLastTetherError(java.lang.String ), 0, this, string2);
    }

    public void reportInetCondition(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportInetCondition", $$robo$$android_net_ConnectivityManager$reportInetCondition(int int ), 0, this, n, n2);
    }

    @Deprecated
    public void reportBadNetwork(Network network) {
        InvokeDynamicSupport.bootstrap("reportBadNetwork", $$robo$$android_net_ConnectivityManager$reportBadNetwork(android.net.Network ), 0, this, network);
    }

    public void reportNetworkConnectivity(Network network, boolean bl) {
        InvokeDynamicSupport.bootstrap("reportNetworkConnectivity", $$robo$$android_net_ConnectivityManager$reportNetworkConnectivity(android.net.Network boolean ), 0, this, network, bl);
    }

    public void setGlobalProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setGlobalProxy", $$robo$$android_net_ConnectivityManager$setGlobalProxy(android.net.ProxyInfo ), 0, this, proxyInfo);
    }

    public ProxyInfo getGlobalProxy() {
        return InvokeDynamicSupport.bootstrap("getGlobalProxy", $$robo$$android_net_ConnectivityManager$getGlobalProxy(), 0, this);
    }

    public ProxyInfo getProxyForNetwork(Network network) {
        return InvokeDynamicSupport.bootstrap("getProxyForNetwork", $$robo$$android_net_ConnectivityManager$getProxyForNetwork(android.net.Network ), 0, this, network);
    }

    public ProxyInfo getDefaultProxy() {
        return InvokeDynamicSupport.bootstrap("getDefaultProxy", $$robo$$android_net_ConnectivityManager$getDefaultProxy(), 0, this);
    }

    public boolean isNetworkSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkSupported", $$robo$$android_net_ConnectivityManager$isNetworkSupported(int ), 0, this, n);
    }

    public boolean isActiveNetworkMetered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveNetworkMetered", $$robo$$android_net_ConnectivityManager$isActiveNetworkMetered(), 0, this);
    }

    public boolean updateLockdownVpn() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateLockdownVpn", $$robo$$android_net_ConnectivityManager$updateLockdownVpn(), 0, this);
    }

    public int checkMobileProvisioning(int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkMobileProvisioning", $$robo$$android_net_ConnectivityManager$checkMobileProvisioning(int ), 0, this, n);
    }

    public String getMobileProvisioningUrl() {
        return InvokeDynamicSupport.bootstrap("getMobileProvisioningUrl", $$robo$$android_net_ConnectivityManager$getMobileProvisioningUrl(), 0, this);
    }

    @Deprecated
    public void setProvisioningNotificationVisible(boolean bl, int n, String string2) {
        InvokeDynamicSupport.bootstrap("setProvisioningNotificationVisible", $$robo$$android_net_ConnectivityManager$setProvisioningNotificationVisible(boolean int java.lang.String ), 0, this, bl, n, string2);
    }

    public void setAirplaneMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAirplaneMode", $$robo$$android_net_ConnectivityManager$setAirplaneMode(boolean ), 0, this, bl);
    }

    public void registerNetworkFactory(Messenger messenger, String string2) {
        InvokeDynamicSupport.bootstrap("registerNetworkFactory", $$robo$$android_net_ConnectivityManager$registerNetworkFactory(android.os.Messenger java.lang.String ), 0, this, messenger, string2);
    }

    public void unregisterNetworkFactory(Messenger messenger) {
        InvokeDynamicSupport.bootstrap("unregisterNetworkFactory", $$robo$$android_net_ConnectivityManager$unregisterNetworkFactory(android.os.Messenger ), 0, this, messenger);
    }

    public int registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int n, NetworkMisc networkMisc) {
        return (int)InvokeDynamicSupport.bootstrap("registerNetworkAgent", $$robo$$android_net_ConnectivityManager$registerNetworkAgent(android.os.Messenger android.net.NetworkInfo android.net.LinkProperties android.net.NetworkCapabilities int android.net.NetworkMisc ), 0, this, messenger, networkInfo, linkProperties, networkCapabilities, n, networkMisc);
    }

    public static String getCallbackName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCallbackName", $$robo$$android_net_ConnectivityManager$getCallbackName(int ), 0, (int)n);
    }

    private CallbackHandler getDefaultHandler() {
        return InvokeDynamicSupport.bootstrap("getDefaultHandler", $$robo$$android_net_ConnectivityManager$getDefaultHandler(), 0, this);
    }

    private NetworkRequest sendRequestForNetwork(NetworkCapabilities networkCapabilities, NetworkCallback networkCallback, int n, int n2, int n3, CallbackHandler callbackHandler) {
        return InvokeDynamicSupport.bootstrap("sendRequestForNetwork", $$robo$$android_net_ConnectivityManager$sendRequestForNetwork(android.net.NetworkCapabilities android.net.ConnectivityManager$NetworkCallback int int int android.net.ConnectivityManager$CallbackHandler ), 0, this, networkCapabilities, networkCallback, n, n2, n3, callbackHandler);
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback, int n, int n2, Handler handler) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback int int android.os.Handler ), 0, this, networkRequest, networkCallback, n, n2, handler);
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback ), 0, this, networkRequest, networkCallback);
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback android.os.Handler ), 0, this, networkRequest, networkCallback, handler);
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback, int n) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback int ), 0, this, networkRequest, networkCallback, n);
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback, Handler handler, int n) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback android.os.Handler int ), 0, this, networkRequest, networkCallback, handler, n);
    }

    public void requestNetwork(NetworkRequest networkRequest, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.app.PendingIntent ), 0, this, networkRequest, pendingIntent);
    }

    public void releaseNetworkRequest(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("releaseNetworkRequest", $$robo$$android_net_ConnectivityManager$releaseNetworkRequest(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private void checkPendingIntent(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("checkPendingIntent", $$robo$$android_net_ConnectivityManager$checkPendingIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void registerNetworkCallback(NetworkRequest networkRequest, NetworkCallback networkCallback) {
        InvokeDynamicSupport.bootstrap("registerNetworkCallback", $$robo$$android_net_ConnectivityManager$registerNetworkCallback(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback ), 0, this, networkRequest, networkCallback);
    }

    public void registerNetworkCallback(NetworkRequest networkRequest, NetworkCallback networkCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerNetworkCallback", $$robo$$android_net_ConnectivityManager$registerNetworkCallback(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback android.os.Handler ), 0, this, networkRequest, networkCallback, handler);
    }

    public void registerNetworkCallback(NetworkRequest networkRequest, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("registerNetworkCallback", $$robo$$android_net_ConnectivityManager$registerNetworkCallback(android.net.NetworkRequest android.app.PendingIntent ), 0, this, networkRequest, pendingIntent);
    }

    public void registerDefaultNetworkCallback(NetworkCallback networkCallback) {
        InvokeDynamicSupport.bootstrap("registerDefaultNetworkCallback", $$robo$$android_net_ConnectivityManager$registerDefaultNetworkCallback(android.net.ConnectivityManager$NetworkCallback ), 0, this, networkCallback);
    }

    public void registerDefaultNetworkCallback(NetworkCallback networkCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerDefaultNetworkCallback", $$robo$$android_net_ConnectivityManager$registerDefaultNetworkCallback(android.net.ConnectivityManager$NetworkCallback android.os.Handler ), 0, this, networkCallback, handler);
    }

    public boolean requestBandwidthUpdate(Network network) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestBandwidthUpdate", $$robo$$android_net_ConnectivityManager$requestBandwidthUpdate(android.net.Network ), 0, this, network);
    }

    public void unregisterNetworkCallback(NetworkCallback networkCallback) {
        InvokeDynamicSupport.bootstrap("unregisterNetworkCallback", $$robo$$android_net_ConnectivityManager$unregisterNetworkCallback(android.net.ConnectivityManager$NetworkCallback ), 0, this, networkCallback);
    }

    public void unregisterNetworkCallback(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("unregisterNetworkCallback", $$robo$$android_net_ConnectivityManager$unregisterNetworkCallback(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void setAcceptUnvalidated(Network network, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setAcceptUnvalidated", $$robo$$android_net_ConnectivityManager$setAcceptUnvalidated(android.net.Network boolean boolean ), 0, this, network, bl, bl2);
    }

    public void setAvoidUnvalidated(Network network) {
        InvokeDynamicSupport.bootstrap("setAvoidUnvalidated", $$robo$$android_net_ConnectivityManager$setAvoidUnvalidated(android.net.Network ), 0, this, network);
    }

    public void startCaptivePortalApp(Network network) {
        InvokeDynamicSupport.bootstrap("startCaptivePortalApp", $$robo$$android_net_ConnectivityManager$startCaptivePortalApp(android.net.Network ), 0, this, network);
    }

    public int getMultipathPreference(Network network) {
        return (int)InvokeDynamicSupport.bootstrap("getMultipathPreference", $$robo$$android_net_ConnectivityManager$getMultipathPreference(android.net.Network ), 0, this, network);
    }

    public void factoryReset() {
        InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_net_ConnectivityManager$factoryReset(), 0, this);
    }

    public boolean bindProcessToNetwork(Network network) {
        return (boolean)InvokeDynamicSupport.bootstrap("bindProcessToNetwork", $$robo$$android_net_ConnectivityManager$bindProcessToNetwork(android.net.Network ), 0, this, network);
    }

    @Deprecated
    public static boolean setProcessDefaultNetwork(Network network) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setProcessDefaultNetwork", $$robo$$android_net_ConnectivityManager$setProcessDefaultNetwork(android.net.Network ), 0, (Network)network);
    }

    public Network getBoundNetworkForProcess() {
        return InvokeDynamicSupport.bootstrap("getBoundNetworkForProcess", $$robo$$android_net_ConnectivityManager$getBoundNetworkForProcess(), 0, this);
    }

    @Deprecated
    public static Network getProcessDefaultNetwork() {
        return InvokeDynamicSupport.bootstrapStatic("getProcessDefaultNetwork", $$robo$$android_net_ConnectivityManager$getProcessDefaultNetwork(), 0);
    }

    private void unsupportedStartingFrom(int n) {
        InvokeDynamicSupport.bootstrap("unsupportedStartingFrom", $$robo$$android_net_ConnectivityManager$unsupportedStartingFrom(int ), 0, this, n);
    }

    private void checkLegacyRoutingApiAccess() {
        InvokeDynamicSupport.bootstrap("checkLegacyRoutingApiAccess", $$robo$$android_net_ConnectivityManager$checkLegacyRoutingApiAccess(), 0, this);
    }

    @Deprecated
    public static boolean setProcessDefaultNetworkForHostResolution(Network network) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setProcessDefaultNetworkForHostResolution", $$robo$$android_net_ConnectivityManager$setProcessDefaultNetworkForHostResolution(android.net.Network ), 0, (Network)network);
    }

    private INetworkPolicyManager getNetworkPolicyManager() {
        return InvokeDynamicSupport.bootstrap("getNetworkPolicyManager", $$robo$$android_net_ConnectivityManager$getNetworkPolicyManager(), 0, this);
    }

    public int getRestrictBackgroundStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getRestrictBackgroundStatus", $$robo$$android_net_ConnectivityManager$getRestrictBackgroundStatus(), 0, this);
    }

    private static String whatToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("whatToString", $$robo$$android_net_ConnectivityManager$whatToString(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(ConnectivityManager.class);
    }

    public /* synthetic */ ConnectivityManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectivityManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NoPreloadHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static SparseArray<String> sMagicDecoderRing;

        private void $$robo$$android_net_ConnectivityManager_NoPreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            sMagicDecoderRing = MessageUtils.findMessageNames(new Class[]{ConnectivityManager.class}, new String[]{"CALLBACK_"});
        }

        private void __constructor__() {
            this.$$robo$$android_net_ConnectivityManager_NoPreloadHolder$__constructor__();
        }

        private NoPreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_NoPreloadHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NoPreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=false, value={1L, 2L, 3L})
    public static @interface RestrictBackgroundStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L, 4L})
    public static @interface MultipathPreference {
    }

    private class CallbackHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "ConnectivityManager.CallbackHandler";
        private static boolean DBG = false;
        /* synthetic */ ConnectivityManager this$0;

        private void $$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(ConnectivityManager connectivityManager, Looper looper) {
        }

        private void $$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(ConnectivityManager connectivityManager, Handler handler) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_ConnectivityManager_CallbackHandler$handleMessage(Message message) {
            NetworkRequest request = this.getObject(message, NetworkRequest.class);
            Network network = this.getObject(message, Network.class);
            switch (message.what) {
                case 524289: {
                    NetworkCallback callback = this.getCallback(request, "PRECHECK");
                    if (callback == null) break;
                    callback.onPreCheck(network);
                    break;
                }
                case 524290: {
                    NetworkCallback callback = this.getCallback(request, "AVAILABLE");
                    if (callback == null) break;
                    callback.onAvailable(network);
                    break;
                }
                case 524291: {
                    NetworkCallback callback = this.getCallback(request, "LOSING");
                    if (callback == null) break;
                    callback.onLosing(network, message.arg1);
                    break;
                }
                case 524292: {
                    NetworkCallback callback = this.getCallback(request, "LOST");
                    if (callback == null) break;
                    callback.onLost(network);
                    break;
                }
                case 524293: {
                    NetworkCallback callback = this.getCallback(request, "UNAVAIL");
                    if (callback == null) break;
                    callback.onUnavailable();
                    break;
                }
                case 524294: {
                    NetworkCallback callback = this.getCallback(request, "CAP_CHANGED");
                    if (callback == null) break;
                    NetworkCapabilities cap = this.getObject(message, NetworkCapabilities.class);
                    callback.onCapabilitiesChanged(network, cap);
                    break;
                }
                case 524295: {
                    NetworkCallback callback = this.getCallback(request, "IP_CHANGED");
                    if (callback == null) break;
                    LinkProperties lp = this.getObject(message, LinkProperties.class);
                    callback.onLinkPropertiesChanged(network, lp);
                    break;
                }
                case 524299: {
                    NetworkCallback callback = this.getCallback(request, "SUSPENDED");
                    if (callback == null) break;
                    callback.onNetworkSuspended(network);
                    break;
                }
                case 524300: {
                    NetworkCallback callback = this.getCallback(request, "RESUMED");
                    if (callback == null) break;
                    callback.onNetworkResumed(network);
                    break;
                }
                case 524296: {
                    NetworkCallback callback;
                    HashMap hashMap = sCallbacks;
                    synchronized (hashMap) {
                        callback = (NetworkCallback)sCallbacks.remove(request);
                    }
                    if (callback != null) break;
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for RELEASED message");
                    break;
                }
                case 524297: {
                    break;
                }
                case 524298: {
                    this.this$0.expireRequest((NetworkCapabilities)message.obj, message.arg1);
                }
            }
        }

        private final <T> T $$robo$$android_net_ConnectivityManager_CallbackHandler$getObject(Message msg, Class<T> c) {
            return msg.getData().getParcelable(c.getSimpleName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final NetworkCallback $$robo$$android_net_ConnectivityManager_CallbackHandler$getCallback(NetworkRequest req, String name) {
            NetworkCallback callback;
            HashMap hashMap = sCallbacks;
            synchronized (hashMap) {
                callback = (NetworkCallback)sCallbacks.get(req);
            }
            if (callback == null) {
                Log.e("ConnectivityManager.CallbackHandler", "callback not found for " + name + " message");
            }
            return callback;
        }

        private void __constructor__(ConnectivityManager connectivityManager, Looper looper) {
            this.$$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(connectivityManager, looper);
        }

        CallbackHandler(ConnectivityManager connectivityManager, Looper looper) {
            this.this$0 = connectivityManager;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(android.net.ConnectivityManager android.os.Looper ), 0, this, connectivityManager, looper);
        }

        private void __constructor__(ConnectivityManager connectivityManager, Handler handler) {
            this.$$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(connectivityManager, handler);
        }

        CallbackHandler(ConnectivityManager connectivityManager, Handler handler) {
            this(connectivityManager, handler.getLooper());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(android.net.ConnectivityManager android.os.Handler ), 0, this, connectivityManager, handler);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_ConnectivityManager_CallbackHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private <T> T getObject(Message message, Class<T> clazz) {
            return (T)InvokeDynamicSupport.bootstrap("getObject", $$robo$$android_net_ConnectivityManager_CallbackHandler$getObject(android.os.Message java.lang.Class<T> ), 0, this, message, clazz);
        }

        private NetworkCallback getCallback(NetworkRequest networkRequest, String string2) {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_net_ConnectivityManager_CallbackHandler$getCallback(android.net.NetworkRequest java.lang.String ), 0, this, networkRequest, string2);
        }

        public /* synthetic */ CallbackHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NetworkCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NetworkRequest networkRequest;

        private void $$robo$$android_net_ConnectivityManager_NetworkCallback$__constructor__() {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onPreCheck(Network network) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onAvailable(Network network) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onLosing(Network network, int maxMsToLive) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onLost(Network network) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onUnavailable() {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onNetworkSuspended(Network network) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onNetworkResumed(Network network) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ConnectivityManager_NetworkCallback$__constructor__();
        }

        public NetworkCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_NetworkCallback$__constructor__(), 0, this);
        }

        public void onPreCheck(Network network) {
            InvokeDynamicSupport.bootstrap("onPreCheck", $$robo$$android_net_ConnectivityManager_NetworkCallback$onPreCheck(android.net.Network ), 0, this, network);
        }

        public void onAvailable(Network network) {
            InvokeDynamicSupport.bootstrap("onAvailable", $$robo$$android_net_ConnectivityManager_NetworkCallback$onAvailable(android.net.Network ), 0, this, network);
        }

        public void onLosing(Network network, int n) {
            InvokeDynamicSupport.bootstrap("onLosing", $$robo$$android_net_ConnectivityManager_NetworkCallback$onLosing(android.net.Network int ), 0, this, network, n);
        }

        public void onLost(Network network) {
            InvokeDynamicSupport.bootstrap("onLost", $$robo$$android_net_ConnectivityManager_NetworkCallback$onLost(android.net.Network ), 0, this, network);
        }

        public void onUnavailable() {
            InvokeDynamicSupport.bootstrap("onUnavailable", $$robo$$android_net_ConnectivityManager_NetworkCallback$onUnavailable(), 0, this);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            InvokeDynamicSupport.bootstrap("onCapabilitiesChanged", $$robo$$android_net_ConnectivityManager_NetworkCallback$onCapabilitiesChanged(android.net.Network android.net.NetworkCapabilities ), 0, this, network, networkCapabilities);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onLinkPropertiesChanged", $$robo$$android_net_ConnectivityManager_NetworkCallback$onLinkPropertiesChanged(android.net.Network android.net.LinkProperties ), 0, this, network, linkProperties);
        }

        public void onNetworkSuspended(Network network) {
            InvokeDynamicSupport.bootstrap("onNetworkSuspended", $$robo$$android_net_ConnectivityManager_NetworkCallback$onNetworkSuspended(android.net.Network ), 0, this, network);
        }

        public void onNetworkResumed(Network network) {
            InvokeDynamicSupport.bootstrap("onNetworkResumed", $$robo$$android_net_ConnectivityManager_NetworkCallback$onNetworkResumed(android.net.Network ), 0, this, network);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class OnStartTetheringCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_ConnectivityManager_OnStartTetheringCallback$__constructor__() {
        }

        private final void $$robo$$android_net_ConnectivityManager_OnStartTetheringCallback$onTetheringStarted() {
        }

        private final void $$robo$$android_net_ConnectivityManager_OnStartTetheringCallback$onTetheringFailed() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ConnectivityManager_OnStartTetheringCallback$__constructor__();
        }

        public OnStartTetheringCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_OnStartTetheringCallback$__constructor__(), 0, this);
        }

        public void onTetheringStarted() {
            InvokeDynamicSupport.bootstrap("onTetheringStarted", $$robo$$android_net_ConnectivityManager_OnStartTetheringCallback$onTetheringStarted(), 0, this);
        }

        public void onTetheringFailed() {
            InvokeDynamicSupport.bootstrap("onTetheringFailed", $$robo$$android_net_ConnectivityManager_OnStartTetheringCallback$onTetheringFailed(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnStartTetheringCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnNetworkActiveListener
    extends InstrumentedInterface {
        public void onNetworkActive();
    }

    public class PacketKeepalive
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "PacketKeepalive";
        public static int SUCCESS = 0;
        public static int NO_KEEPALIVE = -1;
        public static int BINDER_DIED = -10;
        public static int ERROR_INVALID_NETWORK = -20;
        public static int ERROR_INVALID_IP_ADDRESS = -21;
        public static int ERROR_INVALID_PORT = -22;
        public static int ERROR_INVALID_LENGTH = -23;
        public static int ERROR_INVALID_INTERVAL = -24;
        public static int ERROR_HARDWARE_UNSUPPORTED = -30;
        public static int ERROR_HARDWARE_ERROR = -31;
        public static int NATT_PORT = 4500;
        private Network mNetwork;
        private PacketKeepaliveCallback mCallback;
        private Looper mLooper;
        private Messenger mMessenger;
        private volatile Integer mSlot;
        /* synthetic */ ConnectivityManager this$0;

        private final void $$robo$$android_net_ConnectivityManager_PacketKeepalive$stopLooper() {
            this.mLooper.quit();
        }

        private final void $$robo$$android_net_ConnectivityManager_PacketKeepalive$stop() {
            try {
                this.this$0.mService.stopKeepalive(this.mNetwork, this.mSlot);
            }
            catch (RemoteException e) {
                Log.e("PacketKeepalive", "Error stopping packet keepalive: ", e);
                this.stopLooper();
            }
        }

        private void $$robo$$android_net_ConnectivityManager_PacketKeepalive$__constructor__(ConnectivityManager this$0, Network network, PacketKeepaliveCallback callback) {
            Preconditions.checkNotNull(network, "network cannot be null");
            Preconditions.checkNotNull(callback, "callback cannot be null");
            this.mNetwork = network;
            this.mCallback = callback;
            HandlerThread thread = new HandlerThread("PacketKeepalive");
            thread.start();
            this.mLooper = thread.getLooper();
            this.mMessenger = new Messenger((Handler)new ShadowedObject(this, this.mLooper, this$0){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ConnectivityManager val$this$0;
                /* synthetic */ PacketKeepalive this$1;

                private void $$robo$$android_net_ConnectivityManager_PacketKeepalive_1$__constructor__(PacketKeepalive this$1, Looper looper, ConnectivityManager connectivityManager) {
                }

                private final void $$robo$$android_net_ConnectivityManager_PacketKeepalive_1$handleMessage(Message message) {
                    switch (message.what) {
                        case 528397: {
                            int error = message.arg2;
                            try {
                                if (error == 0) {
                                    if (this.this$1.mSlot == null) {
                                        this.this$1.mSlot = message.arg1;
                                        this.this$1.mCallback.onStarted();
                                        break;
                                    }
                                    this.this$1.mSlot = null;
                                    this.this$1.stopLooper();
                                    this.this$1.mCallback.onStopped();
                                    break;
                                }
                                this.this$1.stopLooper();
                                this.this$1.mCallback.onError(error);
                            }
                            catch (Exception e) {
                                Log.e("PacketKeepalive", "Exception in keepalive callback(" + error + ")", e);
                            }
                            break;
                        }
                        default: {
                            Log.e("PacketKeepalive", "Unhandled message " + Integer.toHexString(message.what));
                        }
                    }
                }

                private void __constructor__(PacketKeepalive packetKeepalive, Looper looper, ConnectivityManager connectivityManager) {
                    this.$$robo$$android_net_ConnectivityManager_PacketKeepalive_1$__constructor__(packetKeepalive, looper, connectivityManager);
                }
                {
                    this.this$1 = packetKeepalive;
                    this.val$this$0 = connectivityManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_PacketKeepalive_1$__constructor__(android.net.ConnectivityManager$PacketKeepalive android.os.Looper android.net.ConnectivityManager ), 0, this, packetKeepalive, looper, connectivityManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_ConnectivityManager_PacketKeepalive_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private /* synthetic */ void $$robo$$android_net_ConnectivityManager_PacketKeepalive$__constructor__(ConnectivityManager x0, Network x1, PacketKeepaliveCallback x2, 1 x3) {
        }

        void stopLooper() {
            InvokeDynamicSupport.bootstrap("stopLooper", $$robo$$android_net_ConnectivityManager_PacketKeepalive$stopLooper(), 0, this);
        }

        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_ConnectivityManager_PacketKeepalive$stop(), 0, this);
        }

        private void __constructor__(ConnectivityManager connectivityManager, Network network, PacketKeepaliveCallback packetKeepaliveCallback) {
            this.$$robo$$android_net_ConnectivityManager_PacketKeepalive$__constructor__(connectivityManager, network, packetKeepaliveCallback);
        }

        private PacketKeepalive(ConnectivityManager connectivityManager, Network network, PacketKeepaliveCallback packetKeepaliveCallback) {
            this.this$0 = connectivityManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_PacketKeepalive$__constructor__(android.net.ConnectivityManager android.net.Network android.net.ConnectivityManager$PacketKeepaliveCallback ), 0, this, connectivityManager, network, packetKeepaliveCallback);
        }

        private /* synthetic */ void __constructor__(ConnectivityManager connectivityManager, Network network, PacketKeepaliveCallback packetKeepaliveCallback, 1 var4_4) {
            this.$$robo$$android_net_ConnectivityManager_PacketKeepalive$__constructor__(connectivityManager, network, packetKeepaliveCallback, var4_4);
        }

        public /* synthetic */ PacketKeepalive() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PacketKeepalive)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PacketKeepaliveCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$__constructor__() {
        }

        private final void $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$onStarted() {
        }

        private final void $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$onStopped() {
        }

        private final void $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$onError(int error) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$__constructor__();
        }

        public PacketKeepaliveCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$__constructor__(), 0, this);
        }

        public void onStarted() {
            InvokeDynamicSupport.bootstrap("onStarted", $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$onStarted(), 0, this);
        }

        public void onStopped() {
            InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$onStopped(), 0, this);
        }

        public void onError(int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_net_ConnectivityManager_PacketKeepaliveCallback$onError(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PacketKeepaliveCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LegacyRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        NetworkCapabilities networkCapabilities;
        NetworkRequest networkRequest;
        int expireSequenceNumber;
        Network currentNetwork;
        int delay;
        NetworkCallback networkCallback;

        private void $$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__() {
            this.delay = -1;
            this.networkCallback = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LegacyRequest this$0;

                private void $$robo$$android_net_ConnectivityManager_LegacyRequest_1$__constructor__(LegacyRequest this$0) {
                }

                private final void $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onAvailable(Network network) {
                    this.this$0.currentNetwork = network;
                    Log.d("ConnectivityManager", "startUsingNetworkFeature got Network:" + network);
                    ConnectivityManager.setProcessDefaultNetworkForHostResolution(network);
                }

                private final void $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onLost(Network network) {
                    if (network.equals(this.this$0.currentNetwork)) {
                        this.this$0.clearDnsBinding();
                    }
                    Log.d("ConnectivityManager", "startUsingNetworkFeature lost Network:" + network);
                }

                private void __constructor__(LegacyRequest legacyRequest) {
                    this.$$robo$$android_net_ConnectivityManager_LegacyRequest_1$__constructor__(legacyRequest);
                }
                {
                    this.this$0 = legacyRequest;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_LegacyRequest_1$__constructor__(android.net.ConnectivityManager$LegacyRequest ), 0, this, legacyRequest);
                }

                @Override
                public void onAvailable(Network network) {
                    InvokeDynamicSupport.bootstrap("onAvailable", $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onAvailable(android.net.Network ), 0, this, network);
                }

                @Override
                public void onLost(Network network) {
                    InvokeDynamicSupport.bootstrap("onLost", $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onLost(android.net.Network ), 0, this, network);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_net_ConnectivityManager_LegacyRequest$clearDnsBinding() {
            if (this.currentNetwork != null) {
                this.currentNetwork = null;
                ConnectivityManager.setProcessDefaultNetworkForHostResolution(null);
            }
        }

        private /* synthetic */ void $$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__();
        }

        private LegacyRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__(), 0, this);
        }

        private void clearDnsBinding() {
            InvokeDynamicSupport.bootstrap("clearDnsBinding", $$robo$$android_net_ConnectivityManager_LegacyRequest$clearDnsBinding(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

