/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.BroadcastReceiver;
import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.media.MediaScanner;
import android.mtp.MtpPropertyGroup;
import android.mtp.MtpPropertyList;
import android.mtp.MtpServer;
import android.mtp.MtpStorage;
import android.net.Uri;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MtpDatabase
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MtpDatabase";
    private Context mContext;
    private String mPackageName;
    private ContentProviderClient mMediaProvider;
    private String mVolumeName;
    private Uri mObjectsUri;
    private MediaScanner mMediaScanner;
    private AtomicBoolean mClosed;
    private CloseGuard mCloseGuard;
    private String mMediaStoragePath;
    private String[] mSubDirectories;
    private String mSubDirectoriesWhere;
    private String[] mSubDirectoriesWhereArgs;
    private HashMap<String, MtpStorage> mStorageMap;
    private HashMap<Integer, MtpPropertyGroup> mPropertyGroupsByProperty;
    private HashMap<Integer, MtpPropertyGroup> mPropertyGroupsByFormat;
    private boolean mDatabaseModified;
    private SharedPreferences mDeviceProperties;
    private static int DEVICE_PROPERTIES_DATABASE_VERSION = 1;
    private static String[] ID_PROJECTION;
    private static String[] PATH_PROJECTION;
    private static String[] FORMAT_PROJECTION;
    private static String[] PATH_FORMAT_PROJECTION;
    private static String[] OBJECT_INFO_PROJECTION;
    private static String ID_WHERE = "_id=?";
    private static String PATH_WHERE = "_data=?";
    private static String STORAGE_WHERE = "storage_id=?";
    private static String FORMAT_WHERE = "format=?";
    private static String PARENT_WHERE = "parent=?";
    private static String STORAGE_FORMAT_WHERE = "storage_id=? AND format=?";
    private static String STORAGE_PARENT_WHERE = "storage_id=? AND parent=?";
    private static String FORMAT_PARENT_WHERE = "format=? AND parent=?";
    private static String STORAGE_FORMAT_PARENT_WHERE = "storage_id=? AND format=? AND parent=?";
    private MtpServer mServer;
    private int mBatteryLevel;
    private int mBatteryScale;
    private int mDeviceType;
    private BroadcastReceiver mBatteryReceiver;
    static int[] FILE_PROPERTIES;
    static int[] AUDIO_PROPERTIES;
    static int[] VIDEO_PROPERTIES;
    static int[] IMAGE_PROPERTIES;
    private long mNativeContext;

    private void $$robo$$android_mtp_MtpDatabase$__constructor__(Context context, String volumeName, String storagePath, String[] subDirectories) {
        this.mClosed = new AtomicBoolean();
        this.mCloseGuard = CloseGuard.get();
        this.mStorageMap = new HashMap();
        this.mPropertyGroupsByProperty = new HashMap();
        this.mPropertyGroupsByFormat = new HashMap();
        this.mBatteryReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MtpDatabase this$0;

            private void $$robo$$android_mtp_MtpDatabase_1$__constructor__(MtpDatabase this$0) {
            }

            private final void $$robo$$android_mtp_MtpDatabase_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.intent.action.BATTERY_CHANGED")) {
                    this.this$0.mBatteryScale = intent.getIntExtra("scale", 0);
                    int newLevel = intent.getIntExtra("level", 0);
                    if (newLevel != this.this$0.mBatteryLevel) {
                        this.this$0.mBatteryLevel = newLevel;
                        if (this.this$0.mServer != null) {
                            this.this$0.mServer.sendDevicePropertyChanged(20481);
                        }
                    }
                }
            }

            private void __constructor__(MtpDatabase mtpDatabase) {
                this.$$robo$$android_mtp_MtpDatabase_1$__constructor__(mtpDatabase);
            }
            {
                this.this$0 = mtpDatabase;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpDatabase_1$__constructor__(android.mtp.MtpDatabase ), 0, this, mtpDatabase);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_mtp_MtpDatabase_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.native_setup();
        this.mContext = context;
        this.mPackageName = context.getPackageName();
        this.mMediaProvider = context.getContentResolver().acquireContentProviderClient("media");
        this.mVolumeName = volumeName;
        this.mMediaStoragePath = storagePath;
        this.mObjectsUri = MediaStore.Files.getMtpObjectsUri(volumeName);
        this.mMediaScanner = new MediaScanner(context, this.mVolumeName);
        this.mSubDirectories = subDirectories;
        if (subDirectories != null) {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            int count = subDirectories.length;
            for (i = 0; i < count; ++i) {
                builder.append("_data=? OR _data LIKE ?");
                if (i == count - 1) continue;
                builder.append(" OR ");
            }
            builder.append(")");
            this.mSubDirectoriesWhere = builder.toString();
            this.mSubDirectoriesWhereArgs = new String[count * 2];
            int j = 0;
            for (i = 0; i < count; ++i) {
                String path = subDirectories[i];
                this.mSubDirectoriesWhereArgs[j++] = path;
                this.mSubDirectoriesWhereArgs[j++] = path + "/%";
            }
        }
        this.initDeviceProperties(context);
        this.mDeviceType = SystemProperties.getInt("sys.usb.mtp.device_type", 0);
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_mtp_MtpDatabase$setServer(MtpServer server) {
        this.mServer = server;
        try {
            this.mContext.unregisterReceiver(this.mBatteryReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (server != null) {
            this.mContext.registerReceiver(this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }

    private final void $$robo$$android_mtp_MtpDatabase$close() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.mMediaScanner.close();
            this.mMediaProvider.close();
            this.native_finalize();
        }
    }

    private final void $$robo$$android_mtp_MtpDatabase$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_mtp_MtpDatabase$addStorage(MtpStorage storage) {
        this.mStorageMap.put(storage.getPath(), storage);
    }

    private final void $$robo$$android_mtp_MtpDatabase$removeStorage(MtpStorage storage) {
        this.mStorageMap.remove(storage.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_mtp_MtpDatabase$initDeviceProperties(Context context) {
        String devicePropertiesName = "device-properties";
        this.mDeviceProperties = context.getSharedPreferences("device-properties", 0);
        File databaseFile = context.getDatabasePath("device-properties");
        if (databaseFile.exists()) {
            SQLiteDatabase db = null;
            Cursor c = null;
            try {
                db = context.openOrCreateDatabase("device-properties", 0, null);
                if (db != null && (c = db.query("properties", new String[]{"_id", "code", "value"}, null, null, null, null, null)) != null) {
                    SharedPreferences.Editor e = this.mDeviceProperties.edit();
                    while (c.moveToNext()) {
                        String name = c.getString(1);
                        String value = c.getString(2);
                        e.putString(name, value);
                    }
                    e.commit();
                }
            }
            catch (Exception e) {
                Log.e("MtpDatabase", "failed to migrate device properties", e);
            }
            finally {
                if (c != null) {
                    c.close();
                }
                if (db != null) {
                    db.close();
                }
            }
            context.deleteDatabase("device-properties");
        }
    }

    private final boolean $$robo$$android_mtp_MtpDatabase$inStorageSubDirectory(String path) {
        if (this.mSubDirectories == null) {
            return true;
        }
        if (path == null) {
            return false;
        }
        boolean allowed = false;
        int pathLength = path.length();
        for (int i = 0; i < this.mSubDirectories.length && !allowed; ++i) {
            String subdir = this.mSubDirectories[i];
            int subdirLength = subdir.length();
            if (subdirLength >= pathLength || path.charAt(subdirLength) != '/' || !path.startsWith(subdir)) continue;
            allowed = true;
        }
        return allowed;
    }

    private final boolean $$robo$$android_mtp_MtpDatabase$isStorageSubDirectory(String path) {
        if (this.mSubDirectories == null) {
            return false;
        }
        for (int i = 0; i < this.mSubDirectories.length; ++i) {
            if (!path.equals(this.mSubDirectories[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_mtp_MtpDatabase$inStorageRoot(String path) {
        try {
            File f = new File(path);
            String canonical = f.getCanonicalPath();
            for (String root : this.mStorageMap.keySet()) {
                if (!canonical.startsWith(root)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_mtp_MtpDatabase$beginSendObject(String path, int format, int parent, int storageId, long size, long modified) {
        if (!this.inStorageRoot(path)) {
            Log.e("MtpDatabase", "attempt to put file outside of storage area: " + path);
            return -1;
        }
        if (!this.inStorageSubDirectory(path)) {
            return -1;
        }
        if (path != null) {
            try (Cursor c = null;){
                c = this.mMediaProvider.query(this.mObjectsUri, ID_PROJECTION, "_data=?", new String[]{path}, null, null);
                if (c != null && c.getCount() > 0) {
                    Log.w("MtpDatabase", "file already exists in beginSendObject: " + path);
                    int n = -1;
                    return n;
                }
            }
        }
        this.mDatabaseModified = true;
        ContentValues values = new ContentValues();
        values.put("_data", path);
        values.put("format", format);
        values.put("parent", parent);
        values.put("storage_id", storageId);
        values.put("_size", size);
        values.put("date_modified", modified);
        try {
            Uri uri = this.mMediaProvider.insert(this.mObjectsUri, values);
            if (uri != null) {
                return Integer.parseInt(uri.getPathSegments().get(2));
            }
            return -1;
        }
        catch (RemoteException e) {
            Log.e("MtpDatabase", "RemoteException in beginSendObject", e);
            return -1;
        }
    }

    private final void $$robo$$android_mtp_MtpDatabase$endSendObject(String path, int handle, int format, boolean succeeded) {
        if (succeeded) {
            if (format == 47621) {
                String name = path;
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash >= 0) {
                    name = name.substring(lastSlash + 1);
                }
                if (name.endsWith(".pla")) {
                    name = name.substring(0, name.length() - 4);
                }
                ContentValues values = new ContentValues(1);
                values.put("_data", path);
                values.put("name", name);
                values.put("format", format);
                values.put("date_modified", (long)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") / 1000L));
                values.put("media_scanner_new_object_id", handle);
                try {
                    Uri uri = this.mMediaProvider.insert(MediaStore.Audio.Playlists.EXTERNAL_CONTENT_URI, values);
                }
                catch (RemoteException e) {
                    Log.e("MtpDatabase", "RemoteException in endSendObject", e);
                }
            } else {
                this.mMediaScanner.scanMtpFile(path, handle, format);
            }
        } else {
            this.deleteFile(handle);
        }
    }

    private final Cursor $$robo$$android_mtp_MtpDatabase$createObjectQuery(int storageID, int format, int parent) throws RemoteException {
        String[] whereArgs;
        String where;
        if (storageID == -1) {
            if (format == 0) {
                if (parent == 0) {
                    where = null;
                    whereArgs = null;
                } else {
                    if (parent == -1) {
                        parent = 0;
                    }
                    where = "parent=?";
                    whereArgs = new String[]{Integer.toString(parent)};
                }
            } else if (parent == 0) {
                where = "format=?";
                whereArgs = new String[]{Integer.toString(format)};
            } else {
                if (parent == -1) {
                    parent = 0;
                }
                where = "format=? AND parent=?";
                whereArgs = new String[]{Integer.toString(format), Integer.toString(parent)};
            }
        } else if (format == 0) {
            if (parent == 0) {
                where = "storage_id=?";
                whereArgs = new String[]{Integer.toString(storageID)};
            } else {
                if (parent == -1) {
                    parent = 0;
                }
                where = "storage_id=? AND parent=?";
                whereArgs = new String[]{Integer.toString(storageID), Integer.toString(parent)};
            }
        } else if (parent == 0) {
            where = "storage_id=? AND format=?";
            whereArgs = new String[]{Integer.toString(storageID), Integer.toString(format)};
        } else {
            if (parent == -1) {
                parent = 0;
            }
            where = "storage_id=? AND format=? AND parent=?";
            whereArgs = new String[]{Integer.toString(storageID), Integer.toString(format), Integer.toString(parent)};
        }
        if (this.mSubDirectoriesWhere != null) {
            if (where == null) {
                where = this.mSubDirectoriesWhere;
                whereArgs = this.mSubDirectoriesWhereArgs;
            } else {
                int i;
                where = where + " AND " + this.mSubDirectoriesWhere;
                String[] newWhereArgs = new String[whereArgs.length + this.mSubDirectoriesWhereArgs.length];
                for (i = 0; i < whereArgs.length; ++i) {
                    newWhereArgs[i] = whereArgs[i];
                }
                for (int j = 0; j < this.mSubDirectoriesWhereArgs.length; ++j) {
                    newWhereArgs[i] = this.mSubDirectoriesWhereArgs[j];
                    ++i;
                }
                whereArgs = newWhereArgs;
            }
        }
        return this.mMediaProvider.query(this.mObjectsUri, ID_PROJECTION, where, whereArgs, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_mtp_MtpDatabase$getObjectList(int storageID, int format, int parent) {
        try (Cursor c = null;){
            c = this.createObjectQuery(storageID, format, parent);
            if (c == null) {
                int[] nArray = null;
                return nArray;
            }
            int count = c.getCount();
            if (count > 0) {
                int[] result = new int[count];
                for (int i = 0; i < count; ++i) {
                    c.moveToNext();
                    result[i] = c.getInt(0);
                }
                int[] nArray = result;
                return nArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_mtp_MtpDatabase$getNumObjects(int storageID, int format, int parent) {
        try (Cursor c = null;){
            c = this.createObjectQuery(storageID, format, parent);
            if (c != null) {
                int n = c.getCount();
                return n;
            }
        }
        return -1;
    }

    private final int[] $$robo$$android_mtp_MtpDatabase$getSupportedPlaybackFormats() {
        return new int[]{12288, 12289, 12292, 12293, 12296, 12297, 12299, 14337, 14338, 14340, 14343, 14344, 14347, 14349, 47361, 47362, 47363, 47490, 47491, 47492, 47621, 47632, 47633, 47636, 47746, 47366, 14353};
    }

    private final int[] $$robo$$android_mtp_MtpDatabase$getSupportedCaptureFormats() {
        return null;
    }

    private final int[] $$robo$$android_mtp_MtpDatabase$getSupportedObjectProperties(int format) {
        switch (format) {
            case 12296: 
            case 12297: 
            case 47361: 
            case 47362: 
            case 47363: {
                return AUDIO_PROPERTIES;
            }
            case 12299: 
            case 47489: 
            case 47492: {
                return VIDEO_PROPERTIES;
            }
            case 14337: 
            case 14340: 
            case 14343: 
            case 14347: 
            case 14353: {
                return IMAGE_PROPERTIES;
            }
        }
        return FILE_PROPERTIES;
    }

    private final int[] $$robo$$android_mtp_MtpDatabase$getSupportedDeviceProperties() {
        return new int[]{54273, 54274, 20483, 20481, 54279};
    }

    private final MtpPropertyList $$robo$$android_mtp_MtpDatabase$getObjectPropertyList(int handle, int format, int property, int groupCode, int depth) {
        MtpPropertyGroup propertyGroup;
        if (groupCode != 0) {
            return new MtpPropertyList(0, 43015);
        }
        if (property == -1) {
            if (format == 0 && handle != 0 && handle != -1) {
                format = this.getObjectFormat(handle);
            }
            if ((propertyGroup = this.mPropertyGroupsByFormat.get(format)) == null) {
                int[] propertyList = this.getSupportedObjectProperties(format);
                propertyGroup = new MtpPropertyGroup(this, this.mMediaProvider, this.mVolumeName, propertyList);
                this.mPropertyGroupsByFormat.put(format, propertyGroup);
            }
        } else {
            propertyGroup = this.mPropertyGroupsByProperty.get(property);
            if (propertyGroup == null) {
                int[] propertyList = new int[]{property};
                propertyGroup = new MtpPropertyGroup(this, this.mMediaProvider, this.mVolumeName, propertyList);
                this.mPropertyGroupsByProperty.put(property, propertyGroup);
            }
        }
        return propertyGroup.getPropertyList(handle, format, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_mtp_MtpDatabase$renameFile(int handle, String newName) {
        Cursor c = null;
        String path = null;
        String[] whereArgs = new String[]{Integer.toString(handle)};
        try {
            c = this.mMediaProvider.query(this.mObjectsUri, PATH_PROJECTION, "_id=?", whereArgs, null, null);
            if (c != null && c.moveToNext()) {
                path = c.getString(1);
            }
        }
        catch (RemoteException e) {
            Log.e("MtpDatabase", "RemoteException in getObjectFilePath", e);
            int n = 8194;
            return n;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        if (path == null) {
            return 8201;
        }
        if (this.isStorageSubDirectory(path)) {
            return 8205;
        }
        File oldFile = new File(path);
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash <= 1) {
            return 8194;
        }
        String newPath = path.substring(0, lastSlash + 1) + newName;
        File newFile = new File(newPath);
        boolean success = oldFile.renameTo(newFile);
        if (!success) {
            Log.w("MtpDatabase", "renaming " + path + " to " + newPath + " failed");
            return 8194;
        }
        ContentValues values = new ContentValues();
        values.put("_data", newPath);
        int updated = 0;
        try {
            updated = this.mMediaProvider.update(this.mObjectsUri, values, "_id=?", whereArgs);
        }
        catch (RemoteException e) {
            Log.e("MtpDatabase", "RemoteException in mMediaProvider.update", e);
        }
        if (updated == 0) {
            Log.e("MtpDatabase", "Unable to update path for " + path + " to " + newPath);
            newFile.renameTo(oldFile);
            return 8194;
        }
        if (newFile.isDirectory()) {
            if (oldFile.getName().startsWith(".") && !newPath.startsWith(".")) {
                try {
                    this.mMediaProvider.call("unhide", newPath, null);
                }
                catch (RemoteException e) {
                    Log.e("MtpDatabase", "failed to unhide/rescan for " + newPath);
                }
            }
        } else if (oldFile.getName().toLowerCase(Locale.US).equals(".nomedia") && !newPath.toLowerCase(Locale.US).equals(".nomedia")) {
            try {
                this.mMediaProvider.call("unhide", oldFile.getParent(), null);
            }
            catch (RemoteException e) {
                Log.e("MtpDatabase", "failed to unhide/rescan for " + newPath);
            }
        }
        return 8193;
    }

    private final int $$robo$$android_mtp_MtpDatabase$setObjectProperty(int handle, int property, long intValue, String stringValue) {
        switch (property) {
            case 56327: {
                return this.renameFile(handle, stringValue);
            }
        }
        return 43018;
    }

    private final int $$robo$$android_mtp_MtpDatabase$getDeviceProperty(int property, long[] outIntValue, char[] outStringValue) {
        switch (property) {
            case 54273: 
            case 54274: {
                String value = this.mDeviceProperties.getString(Integer.toString(property), "");
                int length = value.length();
                if (length > 255) {
                    length = 255;
                }
                value.getChars(0, length, outStringValue, 0);
                outStringValue[length] = '\u0000';
                return 8193;
            }
            case 20483: {
                Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
                int width = display.getMaximumSizeDimension();
                int height = display.getMaximumSizeDimension();
                String imageSize = Integer.toString(width) + "x" + Integer.toString(height);
                imageSize.getChars(0, imageSize.length(), outStringValue, 0);
                outStringValue[imageSize.length()] = '\u0000';
                return 8193;
            }
            case 54279: {
                outIntValue[0] = this.mDeviceType;
                return 8193;
            }
        }
        return 8202;
    }

    private final int $$robo$$android_mtp_MtpDatabase$setDeviceProperty(int property, long intValue, String stringValue) {
        switch (property) {
            case 54273: 
            case 54274: {
                SharedPreferences.Editor e = this.mDeviceProperties.edit();
                e.putString(Integer.toString(property), stringValue);
                return e.commit() ? 8193 : 8194;
            }
        }
        return 8202;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_mtp_MtpDatabase$getObjectInfo(int handle, int[] outStorageFormatParent, char[] outName, long[] outCreatedModified) {
        try (Cursor c = null;){
            c = this.mMediaProvider.query(this.mObjectsUri, OBJECT_INFO_PROJECTION, "_id=?", new String[]{Integer.toString(handle)}, null, null);
            if (c != null && c.moveToNext()) {
                outStorageFormatParent[0] = c.getInt(1);
                outStorageFormatParent[1] = c.getInt(2);
                outStorageFormatParent[2] = c.getInt(3);
                String path = c.getString(4);
                int lastSlash = path.lastIndexOf(47);
                int start = lastSlash >= 0 ? lastSlash + 1 : 0;
                int end = path.length();
                if (end - start > 255) {
                    end = start + 255;
                }
                path.getChars(start, end, outName, 0);
                outName[end - start] = '\u0000';
                outCreatedModified[0] = c.getLong(5);
                outCreatedModified[1] = c.getLong(6);
                if (outCreatedModified[0] == 0L) {
                    outCreatedModified[0] = outCreatedModified[1];
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_mtp_MtpDatabase$getObjectFilePath(int handle, char[] outFilePath, long[] outFileLengthFormat) {
        if (handle == 0) {
            this.mMediaStoragePath.getChars(0, this.mMediaStoragePath.length(), outFilePath, 0);
            outFilePath[this.mMediaStoragePath.length()] = '\u0000';
            outFileLengthFormat[0] = 0L;
            outFileLengthFormat[1] = 12289L;
            return 8193;
        }
        try (Cursor c = null;){
            c = this.mMediaProvider.query(this.mObjectsUri, PATH_FORMAT_PROJECTION, "_id=?", new String[]{Integer.toString(handle)}, null, null);
            if (c != null && c.moveToNext()) {
                String path = c.getString(1);
                path.getChars(0, path.length(), outFilePath, 0);
                outFilePath[path.length()] = '\u0000';
                outFileLengthFormat[0] = new File(path).length();
                outFileLengthFormat[1] = c.getLong(2);
                int n = 8193;
                return n;
            }
            int path = 8201;
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_mtp_MtpDatabase$getObjectFormat(int handle) {
        try (Cursor c = null;){
            c = this.mMediaProvider.query(this.mObjectsUri, FORMAT_PROJECTION, "_id=?", new String[]{Integer.toString(handle)}, null, null);
            if (c != null && c.moveToNext()) {
                int n = c.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_mtp_MtpDatabase$deleteFile(int handle) {
        int n;
        this.mDatabaseModified = true;
        String path = null;
        int format = 0;
        try (Cursor c = null;){
            Uri uri;
            c = this.mMediaProvider.query(this.mObjectsUri, PATH_FORMAT_PROJECTION, "_id=?", new String[]{Integer.toString(handle)}, null, null);
            if (c == null || !c.moveToNext()) {
                int n2 = 8201;
                return n2;
            }
            path = c.getString(1);
            format = c.getInt(2);
            if (path == null || format == 0) {
                int n3 = 8194;
                return n3;
            }
            if (this.isStorageSubDirectory(path)) {
                int n4 = 8205;
                return n4;
            }
            if (format == 12289) {
                uri = MediaStore.Files.getMtpObjectsUri(this.mVolumeName);
                n = this.mMediaProvider.delete(uri, "_data LIKE ?1 AND lower(substr(_data,1,?2))=lower(?3)", new String[]{path + "/%", Integer.toString(path.length() + 1), path + "/"});
            }
            if (this.mMediaProvider.delete(uri = MediaStore.Files.getMtpObjectsUri(this.mVolumeName, handle), null, null) > 0) {
                if (format != 12289 && path.toLowerCase(Locale.US).endsWith("/.nomedia")) {
                    try {
                        String parentPath = path.substring(0, path.lastIndexOf("/"));
                        this.mMediaProvider.call("unhide", parentPath, null);
                    }
                    catch (RemoteException e) {
                        Log.e("MtpDatabase", "failed to unhide/rescan for " + path);
                    }
                }
                n = 8193;
                return n;
            }
            n = 8201;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_mtp_MtpDatabase$getObjectReferences(int handle) {
        Uri uri = MediaStore.Files.getMtpReferencesUri(this.mVolumeName, handle);
        try (Cursor c = null;){
            c = this.mMediaProvider.query(uri, ID_PROJECTION, null, null, null, null);
            if (c == null) {
                int[] nArray = null;
                return nArray;
            }
            int count = c.getCount();
            if (count > 0) {
                int[] result = new int[count];
                for (int i = 0; i < count; ++i) {
                    c.moveToNext();
                    result[i] = c.getInt(0);
                }
                int[] nArray = result;
                return nArray;
            }
        }
        return null;
    }

    private final int $$robo$$android_mtp_MtpDatabase$setObjectReferences(int handle, int[] references) {
        this.mDatabaseModified = true;
        Uri uri = MediaStore.Files.getMtpReferencesUri(this.mVolumeName, handle);
        int count = references.length;
        ContentValues[] valuesList = new ContentValues[count];
        for (int i = 0; i < count; ++i) {
            ContentValues values = new ContentValues();
            values.put("_id", references[i]);
            valuesList[i] = values;
        }
        try {
            if (this.mMediaProvider.bulkInsert(uri, valuesList) > 0) {
                return 8193;
            }
        }
        catch (RemoteException e) {
            Log.e("MtpDatabase", "RemoteException in setObjectReferences", e);
        }
        return 8194;
    }

    private final void $$robo$$android_mtp_MtpDatabase$sessionStarted() {
        this.mDatabaseModified = false;
    }

    private final void $$robo$$android_mtp_MtpDatabase$sessionEnded() {
        if (this.mDatabaseModified) {
            this.mContext.sendBroadcast(new Intent("android.provider.action.MTP_SESSION_END"));
            this.mDatabaseModified = false;
        }
    }

    private final void $$robo$$android_mtp_MtpDatabase$native_setup() {
    }

    private final void $$robo$$android_mtp_MtpDatabase$native_finalize() {
    }

    static void __staticInitializer__() {
        ID_PROJECTION = new String[]{"_id"};
        PATH_PROJECTION = new String[]{"_id", "_data"};
        FORMAT_PROJECTION = new String[]{"_id", "format"};
        PATH_FORMAT_PROJECTION = new String[]{"_id", "_data", "format"};
        OBJECT_INFO_PROJECTION = new String[]{"_id", "storage_id", "format", "parent", "_data", "date_added", "date_modified"};
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        FILE_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398};
        AUDIO_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56390, 56474, 56475, 56459, 56473, 56457, 56460, 56470, 56985, 56978, 56986, 56980, 56979};
        VIDEO_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56390, 56474, 56457, 56392};
        IMAGE_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56392};
    }

    private void __constructor__(Context context, String string2, String string3, String[] stringArray) {
        this.$$robo$$android_mtp_MtpDatabase$__constructor__(context, string2, string3, stringArray);
    }

    public MtpDatabase(Context context, String string2, String string3, String[] stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpDatabase$__constructor__(android.content.Context java.lang.String java.lang.String java.lang.String[] ), 0, this, context, string2, string3, stringArray);
    }

    public void setServer(MtpServer mtpServer) {
        InvokeDynamicSupport.bootstrap("setServer", $$robo$$android_mtp_MtpDatabase$setServer(android.mtp.MtpServer ), 0, this, mtpServer);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_mtp_MtpDatabase$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_mtp_MtpDatabase$finalize(), 0, this);
    }

    public void addStorage(MtpStorage mtpStorage) {
        InvokeDynamicSupport.bootstrap("addStorage", $$robo$$android_mtp_MtpDatabase$addStorage(android.mtp.MtpStorage ), 0, this, mtpStorage);
    }

    public void removeStorage(MtpStorage mtpStorage) {
        InvokeDynamicSupport.bootstrap("removeStorage", $$robo$$android_mtp_MtpDatabase$removeStorage(android.mtp.MtpStorage ), 0, this, mtpStorage);
    }

    private void initDeviceProperties(Context context) {
        InvokeDynamicSupport.bootstrap("initDeviceProperties", $$robo$$android_mtp_MtpDatabase$initDeviceProperties(android.content.Context ), 0, this, context);
    }

    private boolean inStorageSubDirectory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("inStorageSubDirectory", $$robo$$android_mtp_MtpDatabase$inStorageSubDirectory(java.lang.String ), 0, this, string2);
    }

    private boolean isStorageSubDirectory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStorageSubDirectory", $$robo$$android_mtp_MtpDatabase$isStorageSubDirectory(java.lang.String ), 0, this, string2);
    }

    private boolean inStorageRoot(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("inStorageRoot", $$robo$$android_mtp_MtpDatabase$inStorageRoot(java.lang.String ), 0, this, string2);
    }

    private int beginSendObject(String string2, int n, int n2, int n3, long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrap("beginSendObject", $$robo$$android_mtp_MtpDatabase$beginSendObject(java.lang.String int int int long long ), 0, this, string2, n, n2, n3, l, l2);
    }

    private void endSendObject(String string2, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("endSendObject", $$robo$$android_mtp_MtpDatabase$endSendObject(java.lang.String int int boolean ), 0, this, string2, n, n2, bl);
    }

    private Cursor createObjectQuery(int n, int n2, int n3) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("createObjectQuery", $$robo$$android_mtp_MtpDatabase$createObjectQuery(int int int ), 0, this, n, n2, n3);
    }

    private int[] getObjectList(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("getObjectList", $$robo$$android_mtp_MtpDatabase$getObjectList(int int int ), 0, this, n, n2, n3);
    }

    private int getNumObjects(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getNumObjects", $$robo$$android_mtp_MtpDatabase$getNumObjects(int int int ), 0, this, n, n2, n3);
    }

    private int[] getSupportedPlaybackFormats() {
        return InvokeDynamicSupport.bootstrap("getSupportedPlaybackFormats", $$robo$$android_mtp_MtpDatabase$getSupportedPlaybackFormats(), 0, this);
    }

    private int[] getSupportedCaptureFormats() {
        return InvokeDynamicSupport.bootstrap("getSupportedCaptureFormats", $$robo$$android_mtp_MtpDatabase$getSupportedCaptureFormats(), 0, this);
    }

    private int[] getSupportedObjectProperties(int n) {
        return InvokeDynamicSupport.bootstrap("getSupportedObjectProperties", $$robo$$android_mtp_MtpDatabase$getSupportedObjectProperties(int ), 0, this, n);
    }

    private int[] getSupportedDeviceProperties() {
        return InvokeDynamicSupport.bootstrap("getSupportedDeviceProperties", $$robo$$android_mtp_MtpDatabase$getSupportedDeviceProperties(), 0, this);
    }

    private MtpPropertyList getObjectPropertyList(int n, int n2, int n3, int n4, int n5) {
        return InvokeDynamicSupport.bootstrap("getObjectPropertyList", $$robo$$android_mtp_MtpDatabase$getObjectPropertyList(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    private int renameFile(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("renameFile", $$robo$$android_mtp_MtpDatabase$renameFile(int java.lang.String ), 0, this, n, string2);
    }

    private int setObjectProperty(int n, int n2, long l, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("setObjectProperty", $$robo$$android_mtp_MtpDatabase$setObjectProperty(int int long java.lang.String ), 0, this, n, n2, l, string2);
    }

    private int getDeviceProperty(int n, long[] lArray, char[] cArray) {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceProperty", $$robo$$android_mtp_MtpDatabase$getDeviceProperty(int long[] char[] ), 0, this, n, lArray, cArray);
    }

    private int setDeviceProperty(int n, long l, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("setDeviceProperty", $$robo$$android_mtp_MtpDatabase$setDeviceProperty(int long java.lang.String ), 0, this, n, l, string2);
    }

    private boolean getObjectInfo(int n, int[] nArray, char[] cArray, long[] lArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("getObjectInfo", $$robo$$android_mtp_MtpDatabase$getObjectInfo(int int[] char[] long[] ), 0, this, n, nArray, cArray, lArray);
    }

    private int getObjectFilePath(int n, char[] cArray, long[] lArray) {
        return (int)InvokeDynamicSupport.bootstrap("getObjectFilePath", $$robo$$android_mtp_MtpDatabase$getObjectFilePath(int char[] long[] ), 0, this, n, cArray, lArray);
    }

    private int getObjectFormat(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getObjectFormat", $$robo$$android_mtp_MtpDatabase$getObjectFormat(int ), 0, this, n);
    }

    private int deleteFile(int n) {
        return (int)InvokeDynamicSupport.bootstrap("deleteFile", $$robo$$android_mtp_MtpDatabase$deleteFile(int ), 0, this, n);
    }

    private int[] getObjectReferences(int n) {
        return InvokeDynamicSupport.bootstrap("getObjectReferences", $$robo$$android_mtp_MtpDatabase$getObjectReferences(int ), 0, this, n);
    }

    private int setObjectReferences(int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("setObjectReferences", $$robo$$android_mtp_MtpDatabase$setObjectReferences(int int[] ), 0, this, n, nArray);
    }

    private void sessionStarted() {
        InvokeDynamicSupport.bootstrap("sessionStarted", $$robo$$android_mtp_MtpDatabase$sessionStarted(), 0, this);
    }

    private void sessionEnded() {
        InvokeDynamicSupport.bootstrap("sessionEnded", $$robo$$android_mtp_MtpDatabase$sessionEnded(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding();

    private void native_setup() {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_mtp_MtpDatabase$native_setup(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_mtp_MtpDatabase$native_finalize(), 1, this);
    }

    static {
        RobolectricInternals.classInitializing(MtpDatabase.class);
    }

    public /* synthetic */ MtpDatabase() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpDatabase)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

