/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.IntDef;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TvInputInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "TvInputInfo";
    public static int TYPE_TUNER = 0;
    public static int TYPE_OTHER = 1000;
    public static int TYPE_COMPOSITE = 1001;
    public static int TYPE_SVIDEO = 1002;
    public static int TYPE_SCART = 1003;
    public static int TYPE_COMPONENT = 1004;
    public static int TYPE_VGA = 1005;
    public static int TYPE_DVI = 1006;
    public static int TYPE_HDMI = 1007;
    public static int TYPE_DISPLAY_PORT = 1008;
    public static String EXTRA_INPUT_ID = "android.media.tv.extra.INPUT_ID";
    private ResolveInfo mService;
    private String mId;
    private int mType;
    private boolean mIsHardwareInput;
    private Uri mIconUri;
    private CharSequence mLabel;
    private int mLabelResId;
    private Icon mIcon;
    private Icon mIconStandby;
    private Icon mIconDisconnected;
    private String mSetupActivity;
    private boolean mCanRecord;
    private int mTunerCount;
    private HdmiDeviceInfo mHdmiDeviceInfo;
    private boolean mIsConnectedToHdmiSwitch;
    private String mParentId;
    private Bundle mExtras;
    public static Parcelable.Creator<TvInputInfo> CREATOR;

    @Deprecated
    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service, HdmiDeviceInfo hdmiDeviceInfo, String parentId, String label, Uri iconUri) throws XmlPullParserException, IOException {
        TvInputInfo info = new Builder(context, service).setHdmiDeviceInfo(hdmiDeviceInfo).setParentId(parentId).setLabel(label).build();
        info.mIconUri = iconUri;
        return info;
    }

    @Deprecated
    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service, HdmiDeviceInfo hdmiDeviceInfo, String parentId, int labelRes, Icon icon) throws XmlPullParserException, IOException {
        return new Builder(context, service).setHdmiDeviceInfo(hdmiDeviceInfo).setParentId(parentId).setLabel(labelRes).setIcon(icon).build();
    }

    @Deprecated
    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service, TvInputHardwareInfo hardwareInfo, String label, Uri iconUri) throws XmlPullParserException, IOException {
        TvInputInfo info = new Builder(context, service).setTvInputHardwareInfo(hardwareInfo).setLabel(label).build();
        info.mIconUri = iconUri;
        return info;
    }

    @Deprecated
    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service, TvInputHardwareInfo hardwareInfo, int labelRes, Icon icon) throws XmlPullParserException, IOException {
        return new Builder(context, service).setTvInputHardwareInfo(hardwareInfo).setLabel(labelRes).setIcon(icon).build();
    }

    private void $$robo$$android_media_tv_TvInputInfo$__constructor__(ResolveInfo service, String id2, int type, boolean isHardwareInput, CharSequence label, int labelResId, Icon icon, Icon iconStandby, Icon iconDisconnected, String setupActivity, boolean canRecord, int tunerCount, HdmiDeviceInfo hdmiDeviceInfo, boolean isConnectedToHdmiSwitch, String parentId, Bundle extras) {
        this.mService = service;
        this.mId = id2;
        this.mType = type;
        this.mIsHardwareInput = isHardwareInput;
        this.mLabel = label;
        this.mLabelResId = labelResId;
        this.mIcon = icon;
        this.mIconStandby = iconStandby;
        this.mIconDisconnected = iconDisconnected;
        this.mSetupActivity = setupActivity;
        this.mCanRecord = canRecord;
        this.mTunerCount = tunerCount;
        this.mHdmiDeviceInfo = hdmiDeviceInfo;
        this.mIsConnectedToHdmiSwitch = isConnectedToHdmiSwitch;
        this.mParentId = parentId;
        this.mExtras = extras;
    }

    private final String $$robo$$android_media_tv_TvInputInfo$getId() {
        return this.mId;
    }

    private final String $$robo$$android_media_tv_TvInputInfo$getParentId() {
        return this.mParentId;
    }

    private final ServiceInfo $$robo$$android_media_tv_TvInputInfo$getServiceInfo() {
        return this.mService.serviceInfo;
    }

    private final ComponentName $$robo$$android_media_tv_TvInputInfo$getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    private final Intent $$robo$$android_media_tv_TvInputInfo$createSetupIntent() {
        if (!TextUtils.isEmpty(this.mSetupActivity)) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mService.serviceInfo.packageName, this.mSetupActivity);
            intent.putExtra("android.media.tv.extra.INPUT_ID", this.getId());
            return intent;
        }
        return null;
    }

    @Deprecated
    private final Intent $$robo$$android_media_tv_TvInputInfo$createSettingsIntent() {
        return null;
    }

    private final int $$robo$$android_media_tv_TvInputInfo$getType() {
        return this.mType;
    }

    private final int $$robo$$android_media_tv_TvInputInfo$getTunerCount() {
        return this.mTunerCount;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$canRecord() {
        return this.mCanRecord;
    }

    private final Bundle $$robo$$android_media_tv_TvInputInfo$getExtras() {
        return this.mExtras;
    }

    private final HdmiDeviceInfo $$robo$$android_media_tv_TvInputInfo$getHdmiDeviceInfo() {
        if (this.mType == 1007) {
            return this.mHdmiDeviceInfo;
        }
        return null;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$isPassthroughInput() {
        return this.mType != 0;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$isHardwareInput() {
        return this.mIsHardwareInput;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$isConnectedToHdmiSwitch() {
        return this.mIsConnectedToHdmiSwitch;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$isHidden(Context context) {
        return TvInputSettings.isHidden(context, this.mId, UserHandle.myUserId());
    }

    private final CharSequence $$robo$$android_media_tv_TvInputInfo$loadLabel(Context context) {
        if (this.mLabelResId != 0) {
            return context.getPackageManager().getText(this.mService.serviceInfo.packageName, this.mLabelResId, null);
        }
        if (!TextUtils.isEmpty(this.mLabel)) {
            return this.mLabel;
        }
        return this.mService.loadLabel(context.getPackageManager());
    }

    private final CharSequence $$robo$$android_media_tv_TvInputInfo$loadCustomLabel(Context context) {
        return TvInputSettings.getCustomLabel(context, this.mId, UserHandle.myUserId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Drawable $$robo$$android_media_tv_TvInputInfo$loadIcon(Context context) {
        if (this.mIcon != null) {
            return this.mIcon.loadDrawable(context);
        }
        if (this.mIconUri == null) return this.loadServiceIcon(context);
        try (InputStream is = context.getContentResolver().openInputStream(this.mIconUri);){
            Drawable drawable3 = Drawable.createFromStream(is, null);
            if (drawable3 == null) return this.loadServiceIcon(context);
            Drawable drawable2 = drawable3;
            return drawable2;
        }
        catch (IOException e) {
            Log.w("TvInputInfo", "Loading the default icon due to a failure on loading " + this.mIconUri, e);
        }
        return this.loadServiceIcon(context);
    }

    private final Drawable $$robo$$android_media_tv_TvInputInfo$loadIcon(Context context, int state) {
        if (state == 0) {
            return this.loadIcon(context);
        }
        if (state == 1) {
            if (this.mIconStandby != null) {
                return this.mIconStandby.loadDrawable(context);
            }
        } else if (state == 2) {
            if (this.mIconDisconnected != null) {
                return this.mIconDisconnected.loadDrawable(context);
            }
        } else {
            throw new IllegalArgumentException("Unknown state: " + state);
        }
        return null;
    }

    private final int $$robo$$android_media_tv_TvInputInfo$describeContents() {
        return 0;
    }

    private final int $$robo$$android_media_tv_TvInputInfo$hashCode() {
        return this.mId.hashCode();
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TvInputInfo)) {
            return false;
        }
        TvInputInfo obj = (TvInputInfo)o;
        return Objects.equals(this.mService, obj.mService) && TextUtils.equals(this.mId, obj.mId) && this.mType == obj.mType && this.mIsHardwareInput == obj.mIsHardwareInput && TextUtils.equals(this.mLabel, obj.mLabel) && Objects.equals(this.mIconUri, obj.mIconUri) && this.mLabelResId == obj.mLabelResId && Objects.equals(this.mIcon, obj.mIcon) && Objects.equals(this.mIconStandby, obj.mIconStandby) && Objects.equals(this.mIconDisconnected, obj.mIconDisconnected) && TextUtils.equals(this.mSetupActivity, obj.mSetupActivity) && this.mCanRecord == obj.mCanRecord && this.mTunerCount == obj.mTunerCount && Objects.equals(this.mHdmiDeviceInfo, obj.mHdmiDeviceInfo) && this.mIsConnectedToHdmiSwitch == obj.mIsConnectedToHdmiSwitch && TextUtils.equals(this.mParentId, obj.mParentId) && Objects.equals(this.mExtras, obj.mExtras);
    }

    private final String $$robo$$android_media_tv_TvInputInfo$toString() {
        return "TvInputInfo{id=" + this.mId + ", pkg=" + this.mService.serviceInfo.packageName + ", service=" + this.mService.serviceInfo.name + "}";
    }

    private final void $$robo$$android_media_tv_TvInputInfo$writeToParcel(Parcel dest, int flags) {
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mId);
        dest.writeInt(this.mType);
        dest.writeByte(this.mIsHardwareInput ? (byte)1 : 0);
        TextUtils.writeToParcel(this.mLabel, dest, flags);
        dest.writeParcelable(this.mIconUri, flags);
        dest.writeInt(this.mLabelResId);
        dest.writeParcelable(this.mIcon, flags);
        dest.writeParcelable(this.mIconStandby, flags);
        dest.writeParcelable(this.mIconDisconnected, flags);
        dest.writeString(this.mSetupActivity);
        dest.writeByte(this.mCanRecord ? (byte)1 : 0);
        dest.writeInt(this.mTunerCount);
        dest.writeParcelable(this.mHdmiDeviceInfo, flags);
        dest.writeByte(this.mIsConnectedToHdmiSwitch ? (byte)1 : 0);
        dest.writeString(this.mParentId);
        dest.writeBundle(this.mExtras);
    }

    private final Drawable $$robo$$android_media_tv_TvInputInfo$loadServiceIcon(Context context) {
        if (this.mService.serviceInfo.icon == 0 && this.mService.serviceInfo.applicationInfo.icon == 0) {
            return null;
        }
        return this.mService.serviceInfo.loadIcon(context.getPackageManager());
    }

    private void $$robo$$android_media_tv_TvInputInfo$__constructor__(Parcel in) {
        this.mService = ResolveInfo.CREATOR.createFromParcel(in);
        this.mId = in.readString();
        this.mType = in.readInt();
        this.mIsHardwareInput = in.readByte() == 1;
        this.mLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mIconUri = (Uri)in.readParcelable(null);
        this.mLabelResId = in.readInt();
        this.mIcon = (Icon)in.readParcelable(null);
        this.mIconStandby = (Icon)in.readParcelable(null);
        this.mIconDisconnected = (Icon)in.readParcelable(null);
        this.mSetupActivity = in.readString();
        this.mCanRecord = in.readByte() == 1;
        this.mTunerCount = in.readInt();
        this.mHdmiDeviceInfo = (HdmiDeviceInfo)in.readParcelable(null);
        this.mIsConnectedToHdmiSwitch = in.readByte() == 1;
        this.mParentId = in.readString();
        this.mExtras = in.readBundle();
    }

    private /* synthetic */ void $$robo$$android_media_tv_TvInputInfo$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_media_tv_TvInputInfo$__constructor__(ResolveInfo x0, String x1, int x2, boolean x3, CharSequence x4, int x5, Icon x6, Icon x7, Icon x8, String x9, boolean x10, int x11, HdmiDeviceInfo x12, boolean x13, String x14, Bundle x15, 1 x16) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<TvInputInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_tv_TvInputInfo_1$__constructor__() {
            }

            private final TvInputInfo $$robo$$android_media_tv_TvInputInfo_1$createFromParcel(Parcel in) {
                return new TvInputInfo(in);
            }

            private final TvInputInfo[] $$robo$$android_media_tv_TvInputInfo_1$newArray(int size) {
                return new TvInputInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_tv_TvInputInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo_1$__constructor__(), 0, this);
            }

            @Override
            public TvInputInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_tv_TvInputInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public TvInputInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_tv_TvInputInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    @Deprecated
    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, HdmiDeviceInfo hdmiDeviceInfo, String string2, String string3, Uri uri) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo android.hardware.hdmi.HdmiDeviceInfo java.lang.String java.lang.String android.net.Uri ), 0, (Context)context, (ResolveInfo)resolveInfo, (HdmiDeviceInfo)hdmiDeviceInfo, (String)string2, (String)string3, (Uri)uri);
    }

    @Deprecated
    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, HdmiDeviceInfo hdmiDeviceInfo, String string2, int n, Icon icon) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo android.hardware.hdmi.HdmiDeviceInfo java.lang.String int android.graphics.drawable.Icon ), 0, (Context)context, (ResolveInfo)resolveInfo, (HdmiDeviceInfo)hdmiDeviceInfo, (String)string2, (int)n, (Icon)icon);
    }

    @Deprecated
    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, TvInputHardwareInfo tvInputHardwareInfo, String string2, Uri uri) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo android.media.tv.TvInputHardwareInfo java.lang.String android.net.Uri ), 0, (Context)context, (ResolveInfo)resolveInfo, (TvInputHardwareInfo)tvInputHardwareInfo, (String)string2, (Uri)uri);
    }

    @Deprecated
    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, TvInputHardwareInfo tvInputHardwareInfo, int n, Icon icon) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo android.media.tv.TvInputHardwareInfo int android.graphics.drawable.Icon ), 0, (Context)context, (ResolveInfo)resolveInfo, (TvInputHardwareInfo)tvInputHardwareInfo, (int)n, (Icon)icon);
    }

    private void __constructor__(ResolveInfo resolveInfo, String string2, int n, boolean bl, CharSequence charSequence, int n2, Icon icon, Icon icon2, Icon icon3, String string3, boolean bl2, int n3, HdmiDeviceInfo hdmiDeviceInfo, boolean bl3, String string4, Bundle bundle) {
        this.$$robo$$android_media_tv_TvInputInfo$__constructor__(resolveInfo, string2, n, bl, charSequence, n2, icon, icon2, icon3, string3, bl2, n3, hdmiDeviceInfo, bl3, string4, bundle);
    }

    private TvInputInfo(ResolveInfo resolveInfo, String string2, int n, boolean bl, CharSequence charSequence, int n2, Icon icon, Icon icon2, Icon icon3, String string3, boolean bl2, int n3, HdmiDeviceInfo hdmiDeviceInfo, boolean bl3, String string4, Bundle bundle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo$__constructor__(android.content.pm.ResolveInfo java.lang.String int boolean java.lang.CharSequence int android.graphics.drawable.Icon android.graphics.drawable.Icon android.graphics.drawable.Icon java.lang.String boolean int android.hardware.hdmi.HdmiDeviceInfo boolean java.lang.String android.os.Bundle ), 0, this, resolveInfo, string2, n, bl, charSequence, n2, icon, icon2, icon3, string3, bl2, n3, hdmiDeviceInfo, bl3, string4, bundle);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_media_tv_TvInputInfo$getId(), 0, this);
    }

    public String getParentId() {
        return InvokeDynamicSupport.bootstrap("getParentId", $$robo$$android_media_tv_TvInputInfo$getParentId(), 0, this);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_media_tv_TvInputInfo$getServiceInfo(), 0, this);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_media_tv_TvInputInfo$getComponent(), 0, this);
    }

    public Intent createSetupIntent() {
        return InvokeDynamicSupport.bootstrap("createSetupIntent", $$robo$$android_media_tv_TvInputInfo$createSetupIntent(), 0, this);
    }

    @Deprecated
    public Intent createSettingsIntent() {
        return InvokeDynamicSupport.bootstrap("createSettingsIntent", $$robo$$android_media_tv_TvInputInfo$createSettingsIntent(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_media_tv_TvInputInfo$getType(), 0, this);
    }

    public int getTunerCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTunerCount", $$robo$$android_media_tv_TvInputInfo$getTunerCount(), 0, this);
    }

    public boolean canRecord() {
        return (boolean)InvokeDynamicSupport.bootstrap("canRecord", $$robo$$android_media_tv_TvInputInfo$canRecord(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_media_tv_TvInputInfo$getExtras(), 0, this);
    }

    public HdmiDeviceInfo getHdmiDeviceInfo() {
        return InvokeDynamicSupport.bootstrap("getHdmiDeviceInfo", $$robo$$android_media_tv_TvInputInfo$getHdmiDeviceInfo(), 0, this);
    }

    public boolean isPassthroughInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPassthroughInput", $$robo$$android_media_tv_TvInputInfo$isPassthroughInput(), 0, this);
    }

    public boolean isHardwareInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareInput", $$robo$$android_media_tv_TvInputInfo$isHardwareInput(), 0, this);
    }

    public boolean isConnectedToHdmiSwitch() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectedToHdmiSwitch", $$robo$$android_media_tv_TvInputInfo$isConnectedToHdmiSwitch(), 0, this);
    }

    public boolean isHidden(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHidden", $$robo$$android_media_tv_TvInputInfo$isHidden(android.content.Context ), 0, this, context);
    }

    public CharSequence loadLabel(Context context) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_media_tv_TvInputInfo$loadLabel(android.content.Context ), 0, this, context);
    }

    public CharSequence loadCustomLabel(Context context) {
        return InvokeDynamicSupport.bootstrap("loadCustomLabel", $$robo$$android_media_tv_TvInputInfo$loadCustomLabel(android.content.Context ), 0, this, context);
    }

    public Drawable loadIcon(Context context) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_media_tv_TvInputInfo$loadIcon(android.content.Context ), 0, this, context);
    }

    public Drawable loadIcon(Context context, int n) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_media_tv_TvInputInfo$loadIcon(android.content.Context int ), 0, this, context, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_tv_TvInputInfo$describeContents(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_tv_TvInputInfo$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_tv_TvInputInfo$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_tv_TvInputInfo$toString(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_tv_TvInputInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private Drawable loadServiceIcon(Context context) {
        return InvokeDynamicSupport.bootstrap("loadServiceIcon", $$robo$$android_media_tv_TvInputInfo$loadServiceIcon(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_tv_TvInputInfo$__constructor__(parcel);
    }

    private TvInputInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_tv_TvInputInfo$__constructor__(parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(ResolveInfo resolveInfo, String string2, int n, boolean bl, CharSequence charSequence, int n2, Icon icon, Icon icon2, Icon icon3, String string3, boolean bl2, int n3, HdmiDeviceInfo hdmiDeviceInfo, boolean bl3, String string4, Bundle bundle, 1 var17_17) {
        this.$$robo$$android_media_tv_TvInputInfo$__constructor__(resolveInfo, string2, n, bl, charSequence, n2, icon, icon2, icon3, string3, bl2, n3, hdmiDeviceInfo, bl3, string4, bundle, var17_17);
    }

    static {
        RobolectricInternals.classInitializing(TvInputInfo.class);
    }

    public /* synthetic */ TvInputInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TvInputSettings
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TV_INPUT_SEPARATOR = ":";
        private static String CUSTOM_NAME_SEPARATOR = ",";

        private void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$__constructor__() {
        }

        private static final boolean $$robo$$android_media_tv_TvInputInfo_TvInputSettings$isHidden(Context context, String inputId, int userId) {
            return TvInputSettings.getHiddenTvInputIds(context, userId).contains(inputId);
        }

        private static final String $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabel(Context context, String inputId, int userId) {
            return TvInputSettings.getCustomLabels(context, userId).get(inputId);
        }

        private static final Set<String> $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getHiddenTvInputIds(Context context, int userId) {
            String[] ids;
            String hiddenIdsString = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", userId);
            HashSet<String> set = new HashSet<String>();
            if (TextUtils.isEmpty(hiddenIdsString)) {
                return set;
            }
            for (String id2 : ids = hiddenIdsString.split(":")) {
                set.add(Uri.decode(id2));
            }
            return set;
        }

        private static final Map<String, String> $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabels(Context context, int userId) {
            String[] pairs;
            String labelsString = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_custom_labels", userId);
            HashMap<String, String> map = new HashMap<String, String>();
            if (TextUtils.isEmpty(labelsString)) {
                return map;
            }
            for (String pairString : pairs = labelsString.split(":")) {
                String[] pair = pairString.split(",");
                map.put(Uri.decode(pair[0]), Uri.decode(pair[1]));
            }
            return map;
        }

        private static final void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putHiddenTvInputs(Context context, Set<String> hiddenInputIds, int userId) {
            StringBuilder builder = new StringBuilder();
            boolean firstItem = true;
            for (String inputId : hiddenInputIds) {
                TvInputSettings.ensureValidField(inputId);
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(":");
                }
                builder.append(Uri.encode(inputId));
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", builder.toString(), userId);
            TvInputManager tm = (TvInputManager)context.getSystemService("tv_input");
            for (String inputId : hiddenInputIds) {
                TvInputInfo info = tm.getTvInputInfo(inputId);
                if (info == null) continue;
                tm.updateTvInputInfo(info);
            }
        }

        private static final void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putCustomLabels(Context context, Map<String, String> customLabels, int userId) {
            StringBuilder builder = new StringBuilder();
            boolean firstItem = true;
            for (Map.Entry<String, String> entry : customLabels.entrySet()) {
                TvInputSettings.ensureValidField(entry.getKey());
                TvInputSettings.ensureValidField(entry.getValue());
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(":");
                }
                builder.append(Uri.encode(entry.getKey()));
                builder.append(",");
                builder.append(Uri.encode(entry.getValue()));
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_custom_labels", builder.toString(), userId);
            TvInputManager tm = (TvInputManager)context.getSystemService("tv_input");
            for (String inputId : customLabels.keySet()) {
                TvInputInfo info = tm.getTvInputInfo(inputId);
                if (info == null) continue;
                tm.updateTvInputInfo(info);
            }
        }

        private static final void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$ensureValidField(String value) {
            if (TextUtils.isEmpty(value)) {
                throw new IllegalArgumentException(value + " should not empty ");
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvInputInfo_TvInputSettings$__constructor__();
        }

        private TvInputSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$__constructor__(), 0, this);
        }

        private static boolean isHidden(Context context, String string2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isHidden", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$isHidden(android.content.Context java.lang.String int ), 0, (Context)context, (String)string2, (int)n);
        }

        private static String getCustomLabel(Context context, String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getCustomLabel", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabel(android.content.Context java.lang.String int ), 0, (Context)context, (String)string2, (int)n);
        }

        public static Set<String> getHiddenTvInputIds(Context context, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getHiddenTvInputIds", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getHiddenTvInputIds(android.content.Context int ), 0, (Context)context, (int)n);
        }

        public static Map<String, String> getCustomLabels(Context context, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getCustomLabels", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabels(android.content.Context int ), 0, (Context)context, (int)n);
        }

        public static void putHiddenTvInputs(Context context, Set<String> set, int n) {
            InvokeDynamicSupport.bootstrapStatic("putHiddenTvInputs", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putHiddenTvInputs(android.content.Context java.util.Set<java.lang.String> int ), 0, (Context)context, set, (int)n);
        }

        public static void putCustomLabels(Context context, Map<String, String> map, int n) {
            InvokeDynamicSupport.bootstrapStatic("putCustomLabels", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putCustomLabels(android.content.Context java.util.Map<java.lang.String, java.lang.String> int ), 0, (Context)context, map, (int)n);
        }

        private static void ensureValidField(String string2) {
            InvokeDynamicSupport.bootstrapStatic("ensureValidField", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$ensureValidField(java.lang.String ), 0, (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int LENGTH_HDMI_PHYSICAL_ADDRESS = 4;
        private static int LENGTH_HDMI_DEVICE_ID = 2;
        private static String XML_START_TAG_NAME = "tv-input";
        private static String DELIMITER_INFO_IN_ID = "/";
        private static String PREFIX_HDMI_DEVICE = "HDMI";
        private static String PREFIX_HARDWARE_DEVICE = "HW";
        private static SparseIntArray sHardwareTypeToTvInputType;
        private Context mContext;
        private ResolveInfo mResolveInfo;
        private CharSequence mLabel;
        private int mLabelResId;
        private Icon mIcon;
        private Icon mIconStandby;
        private Icon mIconDisconnected;
        private String mSetupActivity;
        private Boolean mCanRecord;
        private Integer mTunerCount;
        private TvInputHardwareInfo mTvInputHardwareInfo;
        private HdmiDeviceInfo mHdmiDeviceInfo;
        private String mParentId;
        private Bundle mExtras;

        private void $$robo$$android_media_tv_TvInputInfo_Builder$__constructor__(Context context, ComponentName component) {
            if (context == null) {
                throw new IllegalArgumentException("context cannot be null.");
            }
            Intent intent = new Intent("android.media.tv.TvInputService").setComponent(component);
            this.mResolveInfo = context.getPackageManager().resolveService(intent, 132);
            if (this.mResolveInfo == null) {
                throw new IllegalArgumentException("Invalid component. Can't find the service.");
            }
            this.mContext = context;
        }

        private void $$robo$$android_media_tv_TvInputInfo_Builder$__constructor__(Context context, ResolveInfo resolveInfo) {
            if (context == null) {
                throw new IllegalArgumentException("context cannot be null");
            }
            if (resolveInfo == null) {
                throw new IllegalArgumentException("resolveInfo cannot be null");
            }
            this.mContext = context;
            this.mResolveInfo = resolveInfo;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setIcon(Icon icon) {
            this.mIcon = icon;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setIcon(Icon icon, int state) {
            if (state == 0) {
                this.mIcon = icon;
            } else if (state == 1) {
                this.mIconStandby = icon;
            } else if (state == 2) {
                this.mIconDisconnected = icon;
            } else {
                throw new IllegalArgumentException("Unknown state: " + state);
            }
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setLabel(CharSequence label) {
            if (this.mLabelResId != 0) {
                throw new IllegalStateException("Resource ID for label is already set.");
            }
            this.mLabel = label;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setLabel(int resId) {
            if (this.mLabel != null) {
                throw new IllegalStateException("Label text is already set.");
            }
            this.mLabelResId = resId;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setHdmiDeviceInfo(HdmiDeviceInfo hdmiDeviceInfo) {
            if (this.mTvInputHardwareInfo != null) {
                Log.w("TvInputInfo", "TvInputHardwareInfo will not be used to build this TvInputInfo");
                this.mTvInputHardwareInfo = null;
            }
            this.mHdmiDeviceInfo = hdmiDeviceInfo;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setParentId(String parentId) {
            this.mParentId = parentId;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setTvInputHardwareInfo(TvInputHardwareInfo tvInputHardwareInfo) {
            if (this.mHdmiDeviceInfo != null) {
                Log.w("TvInputInfo", "mHdmiDeviceInfo will not be used to build this TvInputInfo");
                this.mHdmiDeviceInfo = null;
            }
            this.mTvInputHardwareInfo = tvInputHardwareInfo;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setTunerCount(int tunerCount) {
            this.mTunerCount = tunerCount;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setCanRecord(boolean canRecord) {
            this.mCanRecord = canRecord;
            return this;
        }

        private final Builder $$robo$$android_media_tv_TvInputInfo_Builder$setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        private final TvInputInfo $$robo$$android_media_tv_TvInputInfo_Builder$build() {
            int type;
            String id2;
            ComponentName componentName = new ComponentName(this.mResolveInfo.serviceInfo.packageName, this.mResolveInfo.serviceInfo.name);
            boolean isHardwareInput = false;
            boolean isConnectedToHdmiSwitch = false;
            if (this.mHdmiDeviceInfo != null) {
                id2 = Builder.generateInputId(componentName, this.mHdmiDeviceInfo);
                type = 1007;
                isHardwareInput = true;
                isConnectedToHdmiSwitch = (this.mHdmiDeviceInfo.getPhysicalAddress() & 0xFFF) != 0;
            } else if (this.mTvInputHardwareInfo != null) {
                id2 = Builder.generateInputId(componentName, this.mTvInputHardwareInfo);
                type = sHardwareTypeToTvInputType.get(this.mTvInputHardwareInfo.getType(), 0);
                isHardwareInput = true;
            } else {
                id2 = Builder.generateInputId(componentName);
                type = 0;
            }
            this.parseServiceMetadata(type);
            return new TvInputInfo(this.mResolveInfo, id2, type, isHardwareInput, this.mLabel, this.mLabelResId, this.mIcon, this.mIconStandby, this.mIconDisconnected, this.mSetupActivity, this.mCanRecord == null ? false : this.mCanRecord, this.mTunerCount == null ? 0 : this.mTunerCount, this.mHdmiDeviceInfo, isConnectedToHdmiSwitch, this.mParentId, this.mExtras);
        }

        private static final String $$robo$$android_media_tv_TvInputInfo_Builder$generateInputId(ComponentName name) {
            return name.flattenToShortString();
        }

        private static final String $$robo$$android_media_tv_TvInputInfo_Builder$generateInputId(ComponentName name, HdmiDeviceInfo hdmiDeviceInfo) {
            String format = "/HDMI%04X%02X";
            return name.flattenToShortString() + String.format(Locale.ENGLISH, format, hdmiDeviceInfo.getPhysicalAddress(), hdmiDeviceInfo.getId());
        }

        private static final String $$robo$$android_media_tv_TvInputInfo_Builder$generateInputId(ComponentName name, TvInputHardwareInfo tvInputHardwareInfo) {
            return name.flattenToShortString() + "/" + "HW" + tvInputHardwareInfo.getDeviceId();
        }

        private final void $$robo$$android_media_tv_TvInputInfo_Builder$parseServiceMetadata(int inputType) {
            ServiceInfo si = this.mResolveInfo.serviceInfo;
            PackageManager pm = this.mContext.getPackageManager();
            try (XmlResourceParser parser = si.loadXmlMetaData(pm, "android.media.tv.input");){
                int type;
                if (parser == null) {
                    throw new IllegalStateException("No android.media.tv.input meta-data found for " + si.name);
                }
                Resources res = pm.getResourcesForApplication(si.applicationInfo);
                AttributeSet attrs = Xml.asAttributeSet(parser);
                while ((type = parser.next()) != 1 && type != 2) {
                }
                String nodeName = parser.getName();
                if (!"tv-input".equals(nodeName)) {
                    throw new IllegalStateException("Meta-data does not start with tv-input tag for " + si.name);
                }
                TypedArray sa = res.obtainAttributes(attrs, R.styleable.TvInputService);
                this.mSetupActivity = sa.getString(1);
                if (this.mCanRecord == null) {
                    this.mCanRecord = sa.getBoolean(2, false);
                }
                if (this.mTunerCount == null && inputType == 0) {
                    this.mTunerCount = sa.getInt(3, 1);
                }
                sa.recycle();
            }
            catch (IOException | XmlPullParserException e) {
                throw new IllegalStateException("Failed reading meta-data for " + si.packageName, e);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalStateException("No resources found for " + si.packageName, e);
            }
        }

        static void __staticInitializer__() {
            sHardwareTypeToTvInputType = new SparseIntArray();
            sHardwareTypeToTvInputType.put(1, 1000);
            sHardwareTypeToTvInputType.put(2, 0);
            sHardwareTypeToTvInputType.put(3, 1001);
            sHardwareTypeToTvInputType.put(4, 1002);
            sHardwareTypeToTvInputType.put(5, 1003);
            sHardwareTypeToTvInputType.put(6, 1004);
            sHardwareTypeToTvInputType.put(7, 1005);
            sHardwareTypeToTvInputType.put(8, 1006);
            sHardwareTypeToTvInputType.put(9, 1007);
            sHardwareTypeToTvInputType.put(10, 1008);
        }

        private void __constructor__(Context context, ComponentName componentName) {
            this.$$robo$$android_media_tv_TvInputInfo_Builder$__constructor__(context, componentName);
        }

        public Builder(Context context, ComponentName componentName) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo_Builder$__constructor__(android.content.Context android.content.ComponentName ), 0, this, context, componentName);
        }

        private void __constructor__(Context context, ResolveInfo resolveInfo) {
            this.$$robo$$android_media_tv_TvInputInfo_Builder$__constructor__(context, resolveInfo);
        }

        public Builder(Context context, ResolveInfo resolveInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo_Builder$__constructor__(android.content.Context android.content.pm.ResolveInfo ), 0, this, context, resolveInfo);
        }

        public Builder setIcon(Icon icon) {
            return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_media_tv_TvInputInfo_Builder$setIcon(android.graphics.drawable.Icon ), 0, this, icon);
        }

        public Builder setIcon(Icon icon, int n) {
            return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_media_tv_TvInputInfo_Builder$setIcon(android.graphics.drawable.Icon int ), 0, this, icon, n);
        }

        public Builder setLabel(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_media_tv_TvInputInfo_Builder$setLabel(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setLabel(int n) {
            return InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_media_tv_TvInputInfo_Builder$setLabel(int ), 0, this, n);
        }

        public Builder setHdmiDeviceInfo(HdmiDeviceInfo hdmiDeviceInfo) {
            return InvokeDynamicSupport.bootstrap("setHdmiDeviceInfo", $$robo$$android_media_tv_TvInputInfo_Builder$setHdmiDeviceInfo(android.hardware.hdmi.HdmiDeviceInfo ), 0, this, hdmiDeviceInfo);
        }

        public Builder setParentId(String string2) {
            return InvokeDynamicSupport.bootstrap("setParentId", $$robo$$android_media_tv_TvInputInfo_Builder$setParentId(java.lang.String ), 0, this, string2);
        }

        public Builder setTvInputHardwareInfo(TvInputHardwareInfo tvInputHardwareInfo) {
            return InvokeDynamicSupport.bootstrap("setTvInputHardwareInfo", $$robo$$android_media_tv_TvInputInfo_Builder$setTvInputHardwareInfo(android.media.tv.TvInputHardwareInfo ), 0, this, tvInputHardwareInfo);
        }

        public Builder setTunerCount(int n) {
            return InvokeDynamicSupport.bootstrap("setTunerCount", $$robo$$android_media_tv_TvInputInfo_Builder$setTunerCount(int ), 0, this, n);
        }

        public Builder setCanRecord(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setCanRecord", $$robo$$android_media_tv_TvInputInfo_Builder$setCanRecord(boolean ), 0, this, bl);
        }

        public Builder setExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_media_tv_TvInputInfo_Builder$setExtras(android.os.Bundle ), 0, this, bundle);
        }

        public TvInputInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_tv_TvInputInfo_Builder$build(), 0, this);
        }

        private static String generateInputId(ComponentName componentName) {
            return InvokeDynamicSupport.bootstrapStatic("generateInputId", $$robo$$android_media_tv_TvInputInfo_Builder$generateInputId(android.content.ComponentName ), 0, (ComponentName)componentName);
        }

        private static String generateInputId(ComponentName componentName, HdmiDeviceInfo hdmiDeviceInfo) {
            return InvokeDynamicSupport.bootstrapStatic("generateInputId", $$robo$$android_media_tv_TvInputInfo_Builder$generateInputId(android.content.ComponentName android.hardware.hdmi.HdmiDeviceInfo ), 0, (ComponentName)componentName, (HdmiDeviceInfo)hdmiDeviceInfo);
        }

        private static String generateInputId(ComponentName componentName, TvInputHardwareInfo tvInputHardwareInfo) {
            return InvokeDynamicSupport.bootstrapStatic("generateInputId", $$robo$$android_media_tv_TvInputInfo_Builder$generateInputId(android.content.ComponentName android.media.tv.TvInputHardwareInfo ), 0, (ComponentName)componentName, (TvInputHardwareInfo)tvInputHardwareInfo);
        }

        private void parseServiceMetadata(int n) {
            InvokeDynamicSupport.bootstrap("parseServiceMetadata", $$robo$$android_media_tv_TvInputInfo_Builder$parseServiceMetadata(int ), 0, this, n);
        }

        static {
            RobolectricInternals.classInitializing(Builder.class);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1000L, 1001L, 1002L, 1003L, 1004L, 1005L, 1006L, 1007L, 1008L})
    public static @interface Type {
    }
}

