/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.content.Context;
import android.content.Intent;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionManager;
import android.media.projection.IMediaProjectionWatcherCallback;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaProjectionManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaProjectionManager";
    public static String EXTRA_APP_TOKEN = "android.media.projection.extra.EXTRA_APP_TOKEN";
    public static String EXTRA_MEDIA_PROJECTION = "android.media.projection.extra.EXTRA_MEDIA_PROJECTION";
    public static int TYPE_SCREEN_CAPTURE = 0;
    public static int TYPE_MIRRORING = 1;
    public static int TYPE_PRESENTATION = 2;
    private Context mContext;
    private Map<Callback, CallbackDelegate> mCallbacks;
    private IMediaProjectionManager mService;

    private void $$robo$$android_media_projection_MediaProjectionManager$__constructor__(Context context) {
        this.mContext = context;
        IBinder b = ServiceManager.getService("media_projection");
        this.mService = IMediaProjectionManager.Stub.asInterface(b);
        this.mCallbacks = new ArrayMap<Callback, CallbackDelegate>();
    }

    private final Intent $$robo$$android_media_projection_MediaProjectionManager$createScreenCaptureIntent() {
        Intent i = new Intent();
        i.setClassName("com.android.systemui", "com.android.systemui.media.MediaProjectionPermissionActivity");
        return i;
    }

    private final MediaProjection $$robo$$android_media_projection_MediaProjectionManager$getMediaProjection(int resultCode, Intent resultData) {
        if (resultCode != -1 || resultData == null) {
            return null;
        }
        IBinder projection = resultData.getIBinderExtra("android.media.projection.extra.EXTRA_MEDIA_PROJECTION");
        if (projection == null) {
            return null;
        }
        return new MediaProjection(this.mContext, IMediaProjection.Stub.asInterface(projection));
    }

    private final MediaProjectionInfo $$robo$$android_media_projection_MediaProjectionManager$getActiveProjectionInfo() {
        try {
            return this.mService.getActiveProjectionInfo();
        }
        catch (RemoteException e) {
            Log.e("MediaProjectionManager", "Unable to get the active projection info", e);
            return null;
        }
    }

    private final void $$robo$$android_media_projection_MediaProjectionManager$stopActiveProjection() {
        try {
            this.mService.stopActiveProjection();
        }
        catch (RemoteException e) {
            Log.e("MediaProjectionManager", "Unable to stop the currently active media projection", e);
        }
    }

    private final void $$robo$$android_media_projection_MediaProjectionManager$addCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CallbackDelegate delegate = new CallbackDelegate(callback, handler);
        this.mCallbacks.put(callback, delegate);
        try {
            this.mService.addCallback(delegate);
        }
        catch (RemoteException e) {
            Log.e("MediaProjectionManager", "Unable to add callbacks to MediaProjection service", e);
        }
    }

    private final void $$robo$$android_media_projection_MediaProjectionManager$removeCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CallbackDelegate delegate = this.mCallbacks.remove(callback);
        try {
            if (delegate != null) {
                this.mService.removeCallback(delegate);
            }
        }
        catch (RemoteException e) {
            Log.e("MediaProjectionManager", "Unable to add callbacks to MediaProjection service", e);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_projection_MediaProjectionManager$__constructor__(context);
    }

    public MediaProjectionManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjectionManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public Intent createScreenCaptureIntent() {
        return InvokeDynamicSupport.bootstrap("createScreenCaptureIntent", $$robo$$android_media_projection_MediaProjectionManager$createScreenCaptureIntent(), 0, this);
    }

    public MediaProjection getMediaProjection(int n, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getMediaProjection", $$robo$$android_media_projection_MediaProjectionManager$getMediaProjection(int android.content.Intent ), 0, this, n, intent);
    }

    public MediaProjectionInfo getActiveProjectionInfo() {
        return InvokeDynamicSupport.bootstrap("getActiveProjectionInfo", $$robo$$android_media_projection_MediaProjectionManager$getActiveProjectionInfo(), 0, this);
    }

    public void stopActiveProjection() {
        InvokeDynamicSupport.bootstrap("stopActiveProjection", $$robo$$android_media_projection_MediaProjectionManager$stopActiveProjection(), 0, this);
    }

    public void addCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("addCallback", $$robo$$android_media_projection_MediaProjectionManager$addCallback(android.media.projection.MediaProjectionManager$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void removeCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$android_media_projection_MediaProjectionManager$removeCallback(android.media.projection.MediaProjectionManager$Callback ), 0, this, callback);
    }

    public /* synthetic */ MediaProjectionManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaProjectionManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CallbackDelegate
    extends IMediaProjectionWatcherCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Callback mCallback;
        private Handler mHandler;

        private void $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate$__constructor__(Callback callback, Handler handler) {
            this.mCallback = callback;
            if (handler == null) {
                handler = new Handler();
            }
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate$onStart(MediaProjectionInfo info) {
            this.mHandler.post(new Runnable(this, info){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ MediaProjectionInfo val$info;
                /* synthetic */ CallbackDelegate this$0;

                private void $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_1$__constructor__(CallbackDelegate this$0, MediaProjectionInfo mediaProjectionInfo) {
                }

                private final void $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_1$run() {
                    this.this$0.mCallback.onStart(this.val$info);
                }

                private void __constructor__(CallbackDelegate callbackDelegate, MediaProjectionInfo mediaProjectionInfo) {
                    this.$$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_1$__constructor__(callbackDelegate, mediaProjectionInfo);
                }
                {
                    this.this$0 = callbackDelegate;
                    this.val$info = mediaProjectionInfo;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_1$__constructor__(android.media.projection.MediaProjectionManager$CallbackDelegate android.media.projection.MediaProjectionInfo ), 0, this, callbackDelegate, mediaProjectionInfo);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate$onStop(MediaProjectionInfo info) {
            this.mHandler.post(new Runnable(this, info){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ MediaProjectionInfo val$info;
                /* synthetic */ CallbackDelegate this$0;

                private void $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_2$__constructor__(CallbackDelegate this$0, MediaProjectionInfo mediaProjectionInfo) {
                }

                private final void $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_2$run() {
                    this.this$0.mCallback.onStop(this.val$info);
                }

                private void __constructor__(CallbackDelegate callbackDelegate, MediaProjectionInfo mediaProjectionInfo) {
                    this.$$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_2$__constructor__(callbackDelegate, mediaProjectionInfo);
                }
                {
                    this.this$0 = callbackDelegate;
                    this.val$info = mediaProjectionInfo;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_2$__constructor__(android.media.projection.MediaProjectionManager$CallbackDelegate android.media.projection.MediaProjectionInfo ), 0, this, callbackDelegate, mediaProjectionInfo);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(Callback callback, Handler handler) {
            this.$$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate$__constructor__(callback, handler);
        }

        public CallbackDelegate(Callback callback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate$__constructor__(android.media.projection.MediaProjectionManager$Callback android.os.Handler ), 0, this, callback, handler);
        }

        @Override
        public void onStart(MediaProjectionInfo mediaProjectionInfo) {
            InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate$onStart(android.media.projection.MediaProjectionInfo ), 0, this, mediaProjectionInfo);
        }

        @Override
        public void onStop(MediaProjectionInfo mediaProjectionInfo) {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_projection_MediaProjectionManager_CallbackDelegate$onStop(android.media.projection.MediaProjectionInfo ), 0, this, mediaProjectionInfo);
        }

        public /* synthetic */ CallbackDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_projection_MediaProjectionManager_Callback$__constructor__() {
        }

        public abstract void onStart(MediaProjectionInfo var1);

        public abstract void onStop(MediaProjectionInfo var1);

        private void __constructor__() {
            this.$$robo$$android_media_projection_MediaProjectionManager_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjectionManager_Callback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

