/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.annotation.IntDef;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringTokenizer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Virtualizer
extends AudioEffect
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Virtualizer";
    private static boolean DEBUG = false;
    public static int PARAM_STRENGTH_SUPPORTED = 0;
    public static int PARAM_STRENGTH = 1;
    public static int PARAM_VIRTUAL_SPEAKER_ANGLES = 2;
    public static int PARAM_FORCE_VIRTUALIZATION_MODE = 3;
    public static int PARAM_VIRTUALIZATION_MODE = 4;
    private boolean mStrengthSupported;
    private OnParameterChangeListener mParamListener;
    private BaseParameterListener mBaseParamListener;
    private Object mParamListenerLock;
    public static int VIRTUALIZATION_MODE_OFF = 0;
    public static int VIRTUALIZATION_MODE_AUTO = 1;
    public static int VIRTUALIZATION_MODE_BINAURAL = 2;
    public static int VIRTUALIZATION_MODE_TRANSAURAL = 3;

    private void $$robo$$android_media_audiofx_Virtualizer$__constructor__(int priority, int audioSession) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.mStrengthSupported = false;
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = new Object();
        if (audioSession == 0) {
            Log.w("Virtualizer", "WARNING: attaching a Virtualizer to global output mix is deprecated!");
        }
        int[] value = new int[1];
        this.checkStatus(this.getParameter(0, value));
        this.mStrengthSupported = value[0] != 0;
    }

    private final boolean $$robo$$android_media_audiofx_Virtualizer$getStrengthSupported() {
        return this.mStrengthSupported;
    }

    private final void $$robo$$android_media_audiofx_Virtualizer$setStrength(short strength) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, strength));
    }

    private final short $$robo$$android_media_audiofx_Virtualizer$getRoundedStrength() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] value = new short[1];
        this.checkStatus(this.getParameter(1, value));
        return value[0];
    }

    private final boolean $$robo$$android_media_audiofx_Virtualizer$getAnglesInt(int inputChannelMask, int deviceType, int[] angles) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (inputChannelMask == 0) {
            throw new IllegalArgumentException("Virtualizer: illegal CHANNEL_INVALID channel mask");
        }
        int channelMask = inputChannelMask == 1 ? 12 : inputChannelMask;
        int nbChannels = AudioFormat.channelCountFromOutChannelMask(channelMask);
        if (angles != null && angles.length < nbChannels * 3) {
            Log.e("Virtualizer", "Size of array for angles cannot accomodate number of channels in mask (" + nbChannels + ")");
            throw new IllegalArgumentException("Virtualizer: array for channel / angle pairs is too small: is " + angles.length + ", should be " + nbChannels * 3);
        }
        ByteBuffer paramsConverter = ByteBuffer.allocate(12);
        paramsConverter.order(ByteOrder.nativeOrder());
        paramsConverter.putInt(2);
        paramsConverter.putInt(AudioFormat.convertChannelOutMaskToNativeMask(channelMask));
        paramsConverter.putInt(AudioDeviceInfo.convertDeviceTypeToInternalDevice(deviceType));
        byte[] result = new byte[nbChannels * 4 * 3];
        int status = this.getParameter(paramsConverter.array(), result);
        if (status >= 0) {
            if (angles != null) {
                ByteBuffer resultConverter = ByteBuffer.wrap(result);
                resultConverter.order(ByteOrder.nativeOrder());
                for (int i = 0; i < nbChannels; ++i) {
                    angles[3 * i] = AudioFormat.convertNativeChannelMaskToOutMask(resultConverter.getInt(i * 4 * 3));
                    angles[3 * i + 1] = resultConverter.getInt(i * 4 * 3 + 4);
                    angles[3 * i + 2] = resultConverter.getInt(i * 4 * 3 + 8);
                }
            }
            return true;
        }
        if (status == -4) {
            return false;
        }
        this.checkStatus(status);
        Log.e("Virtualizer", "unexpected status code " + status + " after getParameter(PARAM_VIRTUAL_SPEAKER_ANGLES)");
        return false;
    }

    private static final int $$robo$$android_media_audiofx_Virtualizer$getDeviceForModeQuery(int virtualizationMode) throws IllegalArgumentException {
        switch (virtualizationMode) {
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Virtualizer: illegal virtualization mode " + virtualizationMode);
    }

    private static final int $$robo$$android_media_audiofx_Virtualizer$getDeviceForModeForce(int virtualizationMode) throws IllegalArgumentException {
        if (virtualizationMode == 1) {
            return 0;
        }
        return Virtualizer.getDeviceForModeQuery(virtualizationMode);
    }

    private static final int $$robo$$android_media_audiofx_Virtualizer$deviceToMode(int deviceType) {
        switch (deviceType) {
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 22: {
                return 2;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                return 3;
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_media_audiofx_Virtualizer$canVirtualize(int inputChannelMask, int virtualizationMode) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return this.getAnglesInt(inputChannelMask, Virtualizer.getDeviceForModeQuery(virtualizationMode), null);
    }

    private final boolean $$robo$$android_media_audiofx_Virtualizer$getSpeakerAngles(int inputChannelMask, int virtualizationMode, int[] angles) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (angles == null) {
            throw new IllegalArgumentException("Virtualizer: illegal null channel / angle array");
        }
        return this.getAnglesInt(inputChannelMask, Virtualizer.getDeviceForModeQuery(virtualizationMode), angles);
    }

    private final boolean $$robo$$android_media_audiofx_Virtualizer$forceVirtualizationMode(int virtualizationMode) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int deviceType = Virtualizer.getDeviceForModeForce(virtualizationMode);
        int internalDevice = AudioDeviceInfo.convertDeviceTypeToInternalDevice(deviceType);
        int status = this.setParameter(3, internalDevice);
        if (status >= 0) {
            return true;
        }
        if (status == -4) {
            return false;
        }
        this.checkStatus(status);
        Log.e("Virtualizer", "unexpected status code " + status + " after setParameter(PARAM_FORCE_VIRTUALIZATION_MODE)");
        return false;
    }

    private final int $$robo$$android_media_audiofx_Virtualizer$getVirtualizationMode() throws IllegalStateException, UnsupportedOperationException {
        int[] value = new int[1];
        int status = this.getParameter(4, value);
        if (status >= 0) {
            return Virtualizer.deviceToMode(AudioDeviceInfo.convertInternalDeviceToDeviceType(value[0]));
        }
        if (status == -4) {
            return 0;
        }
        this.checkStatus(status);
        Log.e("Virtualizer", "unexpected status code " + status + " after getParameter(PARAM_VIRTUALIZATION_MODE)");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_Virtualizer$setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = listener;
                this.mBaseParamListener = new BaseParameterListener(this);
                super.setParameterListener(this.mBaseParamListener);
            }
        }
    }

    private final Settings $$robo$$android_media_audiofx_Virtualizer$getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        short[] value = new short[1];
        this.checkStatus(this.getParameter(1, value));
        settings.strength = value[0];
        return settings;
    }

    private final void $$robo$$android_media_audiofx_Virtualizer$setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, settings.strength));
    }

    private void __constructor__(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.$$robo$$android_media_audiofx_Virtualizer$__constructor__(n, n2);
    }

    public Virtualizer(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_VIRTUALIZER, EFFECT_TYPE_NULL, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Virtualizer$__constructor__(int int ), 0, this, n, n2);
    }

    public boolean getStrengthSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("getStrengthSupported", $$robo$$android_media_audiofx_Virtualizer$getStrengthSupported(), 0, this);
    }

    public void setStrength(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("setStrength", $$robo$$android_media_audiofx_Virtualizer$setStrength(short ), 0, this, s);
    }

    public short getRoundedStrength() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (short)InvokeDynamicSupport.bootstrap("getRoundedStrength", $$robo$$android_media_audiofx_Virtualizer$getRoundedStrength(), 0, this);
    }

    private boolean getAnglesInt(int n, int n2, int[] nArray) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (boolean)InvokeDynamicSupport.bootstrap("getAnglesInt", $$robo$$android_media_audiofx_Virtualizer$getAnglesInt(int int int[] ), 0, this, n, n2, nArray);
    }

    private static int getDeviceForModeQuery(int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDeviceForModeQuery", $$robo$$android_media_audiofx_Virtualizer$getDeviceForModeQuery(int ), 0, (int)n);
    }

    private static int getDeviceForModeForce(int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDeviceForModeForce", $$robo$$android_media_audiofx_Virtualizer$getDeviceForModeForce(int ), 0, (int)n);
    }

    private static int deviceToMode(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("deviceToMode", $$robo$$android_media_audiofx_Virtualizer$deviceToMode(int ), 0, (int)n);
    }

    public boolean canVirtualize(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (boolean)InvokeDynamicSupport.bootstrap("canVirtualize", $$robo$$android_media_audiofx_Virtualizer$canVirtualize(int int ), 0, this, n, n2);
    }

    public boolean getSpeakerAngles(int n, int n2, int[] nArray) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (boolean)InvokeDynamicSupport.bootstrap("getSpeakerAngles", $$robo$$android_media_audiofx_Virtualizer$getSpeakerAngles(int int int[] ), 0, this, n, n2, nArray);
    }

    public boolean forceVirtualizationMode(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (boolean)InvokeDynamicSupport.bootstrap("forceVirtualizationMode", $$robo$$android_media_audiofx_Virtualizer$forceVirtualizationMode(int ), 0, this, n);
    }

    public int getVirtualizationMode() throws IllegalStateException, UnsupportedOperationException {
        return (int)InvokeDynamicSupport.bootstrap("getVirtualizationMode", $$robo$$android_media_audiofx_Virtualizer$getVirtualizationMode(), 0, this);
    }

    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        InvokeDynamicSupport.bootstrap("setParameterListener", $$robo$$android_media_audiofx_Virtualizer$setParameterListener(android.media.audiofx.Virtualizer$OnParameterChangeListener ), 0, this, onParameterChangeListener);
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return InvokeDynamicSupport.bootstrap("getProperties", $$robo$$android_media_audiofx_Virtualizer$getProperties(), 0, this);
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("setProperties", $$robo$$android_media_audiofx_Virtualizer$setProperties(android.media.audiofx.Virtualizer$Settings ), 0, this, settings);
    }

    public /* synthetic */ Virtualizer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Virtualizer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Settings
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public short strength;

        private void $$robo$$android_media_audiofx_Virtualizer_Settings$__constructor__() {
        }

        private void $$robo$$android_media_audiofx_Virtualizer_Settings$__constructor__(String settings) {
            StringTokenizer st = new StringTokenizer(settings, "=;");
            int tokens = st.countTokens();
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals("Virtualizer")) {
                throw new IllegalArgumentException("invalid settings for Virtualizer: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("strength")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.strength = Short.parseShort(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        private final String $$robo$$android_media_audiofx_Virtualizer_Settings$toString() {
            String str = new String("Virtualizer;strength=" + Short.toString(this.strength));
            return str;
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiofx_Virtualizer_Settings$__constructor__();
        }

        public Settings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Virtualizer_Settings$__constructor__(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_audiofx_Virtualizer_Settings$__constructor__(string2);
        }

        public Settings(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Virtualizer_Settings$__constructor__(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_Virtualizer_Settings$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Settings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Virtualizer this$0;

        private void $$robo$$android_media_audiofx_Virtualizer_BaseParameterListener$__constructor__(Virtualizer virtualizer) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_audiofx_Virtualizer_BaseParameterListener$onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            OnParameterChangeListener l = null;
            Object object = this.this$0.mParamListenerLock;
            synchronized (object) {
                if (this.this$0.mParamListener != null) {
                    l = this.this$0.mParamListener;
                }
            }
            if (l != null) {
                int p = -1;
                short v = -1;
                if (param.length == 4) {
                    p = AudioEffect.byteArrayToInt(param, 0);
                }
                if (value.length == 2) {
                    v = AudioEffect.byteArrayToShort(value, 0);
                }
                if (p != -1 && v != -1) {
                    l.onParameterChange(this.this$0, status, p, v);
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_audiofx_Virtualizer_BaseParameterListener$__constructor__(Virtualizer x0, 1 x1) {
        }

        private void __constructor__(Virtualizer virtualizer) {
            this.$$robo$$android_media_audiofx_Virtualizer_BaseParameterListener$__constructor__(virtualizer);
        }

        private BaseParameterListener(Virtualizer virtualizer) {
            this.this$0 = virtualizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Virtualizer_BaseParameterListener$__constructor__(android.media.audiofx.Virtualizer ), 0, this, virtualizer);
        }

        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            InvokeDynamicSupport.bootstrap("onParameterChange", $$robo$$android_media_audiofx_Virtualizer_BaseParameterListener$onParameterChange(android.media.audiofx.AudioEffect int byte[] byte[] ), 0, this, audioEffect, n, byArray, byArray2);
        }

        private /* synthetic */ void __constructor__(Virtualizer virtualizer, 1 var2_2) {
            this.$$robo$$android_media_audiofx_Virtualizer_BaseParameterListener$__constructor__(virtualizer, var2_2);
        }

        public /* synthetic */ BaseParameterListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseParameterListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnParameterChangeListener
    extends InstrumentedInterface {
        public void onParameterChange(Virtualizer var1, int var2, int var3, short var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 3L})
    public static @interface ForceVirtualizationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={2L, 3L})
    public static @interface VirtualizationMode {
    }
}

