/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.WebVttParser;
import android.util.Log;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Tokenizer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Tokenizer";
    private TokenizerPhase mPhase;
    private TokenizerPhase mDataTokenizer;
    private TokenizerPhase mTagTokenizer;
    private OnTokenListener mListener;
    private String mLine;
    private int mHandledLen;

    private void $$robo$$android_media_Tokenizer$__constructor__(OnTokenListener listener) {
        this.mDataTokenizer = new DataTokenizer(this);
        this.mTagTokenizer = new TagTokenizer(this);
        this.reset();
        this.mListener = listener;
    }

    private final void $$robo$$android_media_Tokenizer$reset() {
        this.mPhase = this.mDataTokenizer.start();
    }

    private final void $$robo$$android_media_Tokenizer$tokenize(String s) {
        this.mHandledLen = 0;
        this.mLine = s;
        while (this.mHandledLen < this.mLine.length()) {
            this.mPhase.tokenize();
        }
        if (!(this.mPhase instanceof TagTokenizer)) {
            this.mListener.onLineEnd();
        }
    }

    private void __constructor__(OnTokenListener onTokenListener) {
        this.$$robo$$android_media_Tokenizer$__constructor__(onTokenListener);
    }

    Tokenizer(OnTokenListener onTokenListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Tokenizer$__constructor__(android.media.Tokenizer$OnTokenListener ), 0, this, onTokenListener);
    }

    void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_Tokenizer$reset(), 0, this);
    }

    void tokenize(String string2) {
        InvokeDynamicSupport.bootstrap("tokenize", $$robo$$android_media_Tokenizer$tokenize(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ Tokenizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Tokenizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface OnTokenListener
    extends InstrumentedInterface {
        public void onData(String var1);

        public void onStart(String var1, String[] var2, String var3);

        public void onEnd(String var1);

        public void onTimeStamp(long var1);

        public void onLineEnd();
    }

    public class TagTokenizer
    implements TokenizerPhase,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mAtAnnotation;
        private String mName;
        private String mAnnotation;
        /* synthetic */ Tokenizer this$0;

        private void $$robo$$android_media_Tokenizer_TagTokenizer$__constructor__(Tokenizer this$0) {
        }

        private final TokenizerPhase $$robo$$android_media_Tokenizer_TagTokenizer$start() {
            this.mAnnotation = "";
            this.mName = "";
            this.mAtAnnotation = false;
            return this;
        }

        private final void $$robo$$android_media_Tokenizer_TagTokenizer$tokenize() {
            if (!this.mAtAnnotation) {
                this.this$0.mHandledLen++;
            }
            if (this.this$0.mHandledLen < this.this$0.mLine.length()) {
                String[] parts = this.mAtAnnotation || this.this$0.mLine.charAt(this.this$0.mHandledLen) == '/' ? this.this$0.mLine.substring(this.this$0.mHandledLen).split(">") : this.this$0.mLine.substring(this.this$0.mHandledLen).split("[\t\f >]");
                String part = this.this$0.mLine.substring(this.this$0.mHandledLen, this.this$0.mHandledLen + parts[0].length());
                this.this$0.mHandledLen = this.this$0.mHandledLen + parts[0].length();
                if (this.mAtAnnotation) {
                    this.mAnnotation = this.mAnnotation + " " + part;
                } else {
                    this.mName = part;
                }
            }
            this.mAtAnnotation = true;
            if (this.this$0.mHandledLen < this.this$0.mLine.length() && this.this$0.mLine.charAt(this.this$0.mHandledLen) == '>') {
                this.yield_tag();
                this.this$0.mPhase = this.this$0.mDataTokenizer.start();
                this.this$0.mHandledLen++;
            }
        }

        private final void $$robo$$android_media_Tokenizer_TagTokenizer$yield_tag() {
            if (this.mName.startsWith("/")) {
                this.this$0.mListener.onEnd(this.mName.substring(1));
            } else if (this.mName.length() > 0 && Character.isDigit(this.mName.charAt(0))) {
                try {
                    long timestampMs = WebVttParser.parseTimestampMs(this.mName);
                    this.this$0.mListener.onTimeStamp(timestampMs);
                }
                catch (NumberFormatException e) {
                    Log.d("Tokenizer", "invalid timestamp tag: <" + this.mName + ">");
                }
            } else {
                this.mAnnotation = this.mAnnotation.replaceAll("\\s+", " ");
                if (this.mAnnotation.startsWith(" ")) {
                    this.mAnnotation = this.mAnnotation.substring(1);
                }
                if (this.mAnnotation.endsWith(" ")) {
                    this.mAnnotation = this.mAnnotation.substring(0, this.mAnnotation.length() - 1);
                }
                String[] classes = null;
                int dotAt = this.mName.indexOf(46);
                if (dotAt >= 0) {
                    classes = this.mName.substring(dotAt + 1).split("\\.");
                    this.mName = this.mName.substring(0, dotAt);
                }
                this.this$0.mListener.onStart(this.mName, classes, this.mAnnotation);
            }
        }

        private void __constructor__(Tokenizer tokenizer) {
            this.$$robo$$android_media_Tokenizer_TagTokenizer$__constructor__(tokenizer);
        }

        TagTokenizer(Tokenizer tokenizer) {
            this.this$0 = tokenizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Tokenizer_TagTokenizer$__constructor__(android.media.Tokenizer ), 0, this, tokenizer);
        }

        @Override
        public TokenizerPhase start() {
            return InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_Tokenizer_TagTokenizer$start(), 0, this);
        }

        @Override
        public void tokenize() {
            InvokeDynamicSupport.bootstrap("tokenize", $$robo$$android_media_Tokenizer_TagTokenizer$tokenize(), 0, this);
        }

        private void yield_tag() {
            InvokeDynamicSupport.bootstrap("yield_tag", $$robo$$android_media_Tokenizer_TagTokenizer$yield_tag(), 0, this);
        }

        public /* synthetic */ TagTokenizer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TagTokenizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DataTokenizer
    implements TokenizerPhase,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private StringBuilder mData;
        /* synthetic */ Tokenizer this$0;

        private void $$robo$$android_media_Tokenizer_DataTokenizer$__constructor__(Tokenizer this$0) {
        }

        private final TokenizerPhase $$robo$$android_media_Tokenizer_DataTokenizer$start() {
            this.mData = new StringBuilder();
            return this;
        }

        private final boolean $$robo$$android_media_Tokenizer_DataTokenizer$replaceEscape(String escape, String replacement, int pos) {
            if (this.this$0.mLine.startsWith(escape, pos)) {
                this.mData.append(this.this$0.mLine.substring(this.this$0.mHandledLen, pos));
                this.mData.append(replacement);
                this.this$0.mHandledLen = pos + escape.length();
                pos = this.this$0.mHandledLen - 1;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_media_Tokenizer_DataTokenizer$tokenize() {
            int end = this.this$0.mLine.length();
            for (int pos = this.this$0.mHandledLen; pos < this.this$0.mLine.length(); ++pos) {
                if (this.this$0.mLine.charAt(pos) == '&') {
                    if (this.replaceEscape("&amp;", "&", pos) || this.replaceEscape("&lt;", "<", pos) || this.replaceEscape("&gt;", ">", pos) || this.replaceEscape("&lrm;", "\u200e", pos) || this.replaceEscape("&rlm;", "\u200f", pos) || !this.replaceEscape("&nbsp;", "\u00a0", pos)) continue;
                    continue;
                }
                if (this.this$0.mLine.charAt(pos) != '<') continue;
                end = pos;
                this.this$0.mPhase = this.this$0.mTagTokenizer.start();
                break;
            }
            this.mData.append(this.this$0.mLine.substring(this.this$0.mHandledLen, end));
            this.this$0.mListener.onData(this.mData.toString());
            this.mData.delete(0, this.mData.length());
            this.this$0.mHandledLen = end;
        }

        private void __constructor__(Tokenizer tokenizer) {
            this.$$robo$$android_media_Tokenizer_DataTokenizer$__constructor__(tokenizer);
        }

        DataTokenizer(Tokenizer tokenizer) {
            this.this$0 = tokenizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Tokenizer_DataTokenizer$__constructor__(android.media.Tokenizer ), 0, this, tokenizer);
        }

        @Override
        public TokenizerPhase start() {
            return InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_Tokenizer_DataTokenizer$start(), 0, this);
        }

        private boolean replaceEscape(String string2, String string3, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("replaceEscape", $$robo$$android_media_Tokenizer_DataTokenizer$replaceEscape(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
        }

        @Override
        public void tokenize() {
            InvokeDynamicSupport.bootstrap("tokenize", $$robo$$android_media_Tokenizer_DataTokenizer$tokenize(), 0, this);
        }

        public /* synthetic */ DataTokenizer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataTokenizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface TokenizerPhase
    extends InstrumentedInterface {
        public TokenizerPhase start();

        public void tokenize();
    }
}

