/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String MIMETYPE_VIDEO_VP8 = "video/x-vnd.on2.vp8";
    public static String MIMETYPE_VIDEO_VP9 = "video/x-vnd.on2.vp9";
    public static String MIMETYPE_VIDEO_AVC = "video/avc";
    public static String MIMETYPE_VIDEO_HEVC = "video/hevc";
    public static String MIMETYPE_VIDEO_MPEG4 = "video/mp4v-es";
    public static String MIMETYPE_VIDEO_H263 = "video/3gpp";
    public static String MIMETYPE_VIDEO_MPEG2 = "video/mpeg2";
    public static String MIMETYPE_VIDEO_RAW = "video/raw";
    public static String MIMETYPE_VIDEO_DOLBY_VISION = "video/dolby-vision";
    public static String MIMETYPE_VIDEO_SCRAMBLED = "video/scrambled";
    public static String MIMETYPE_AUDIO_AMR_NB = "audio/3gpp";
    public static String MIMETYPE_AUDIO_AMR_WB = "audio/amr-wb";
    public static String MIMETYPE_AUDIO_MPEG = "audio/mpeg";
    public static String MIMETYPE_AUDIO_AAC = "audio/mp4a-latm";
    public static String MIMETYPE_AUDIO_QCELP = "audio/qcelp";
    public static String MIMETYPE_AUDIO_VORBIS = "audio/vorbis";
    public static String MIMETYPE_AUDIO_OPUS = "audio/opus";
    public static String MIMETYPE_AUDIO_G711_ALAW = "audio/g711-alaw";
    public static String MIMETYPE_AUDIO_G711_MLAW = "audio/g711-mlaw";
    public static String MIMETYPE_AUDIO_RAW = "audio/raw";
    public static String MIMETYPE_AUDIO_FLAC = "audio/flac";
    public static String MIMETYPE_AUDIO_MSGSM = "audio/gsm";
    public static String MIMETYPE_AUDIO_AC3 = "audio/ac3";
    public static String MIMETYPE_AUDIO_EAC3 = "audio/eac3";
    public static String MIMETYPE_AUDIO_SCRAMBLED = "audio/scrambled";
    public static String MIMETYPE_TEXT_VTT = "text/vtt";
    public static String MIMETYPE_TEXT_CEA_608 = "text/cea-608";
    private Map<String, Object> mMap;
    public static String KEY_MIME = "mime";
    public static String KEY_LANGUAGE = "language";
    public static String KEY_SAMPLE_RATE = "sample-rate";
    public static String KEY_CHANNEL_COUNT = "channel-count";
    public static String KEY_WIDTH = "width";
    public static String KEY_HEIGHT = "height";
    public static String KEY_MAX_WIDTH = "max-width";
    public static String KEY_MAX_HEIGHT = "max-height";
    public static String KEY_MAX_INPUT_SIZE = "max-input-size";
    public static String KEY_BIT_RATE = "bitrate";
    public static String KEY_MAX_BIT_RATE = "max-bitrate";
    public static String KEY_COLOR_FORMAT = "color-format";
    public static String KEY_FRAME_RATE = "frame-rate";
    public static String KEY_PCM_ENCODING = "pcm-encoding";
    public static String KEY_CAPTURE_RATE = "capture-rate";
    public static String KEY_I_FRAME_INTERVAL = "i-frame-interval";
    public static String KEY_INTRA_REFRESH_PERIOD = "intra-refresh-period";
    public static String KEY_TEMPORAL_LAYERING = "ts-schema";
    public static String KEY_STRIDE = "stride";
    public static String KEY_SLICE_HEIGHT = "slice-height";
    public static String KEY_REPEAT_PREVIOUS_FRAME_AFTER = "repeat-previous-frame-after";
    public static String KEY_PUSH_BLANK_BUFFERS_ON_STOP = "push-blank-buffers-on-shutdown";
    public static String KEY_DURATION = "durationUs";
    public static String KEY_IS_ADTS = "is-adts";
    public static String KEY_CHANNEL_MASK = "channel-mask";
    public static String KEY_AAC_PROFILE = "aac-profile";
    public static String KEY_AAC_SBR_MODE = "aac-sbr-mode";
    public static String KEY_AAC_MAX_OUTPUT_CHANNEL_COUNT = "aac-max-output-channel_count";
    public static String KEY_AAC_DRC_TARGET_REFERENCE_LEVEL = "aac-target-ref-level";
    public static String KEY_AAC_ENCODED_TARGET_LEVEL = "aac-encoded-target-level";
    public static String KEY_AAC_DRC_BOOST_FACTOR = "aac-drc-boost-level";
    public static String KEY_AAC_DRC_ATTENUATION_FACTOR = "aac-drc-cut-level";
    public static String KEY_AAC_DRC_HEAVY_COMPRESSION = "aac-drc-heavy-compression";
    public static String KEY_FLAC_COMPRESSION_LEVEL = "flac-compression-level";
    public static String KEY_COMPLEXITY = "complexity";
    public static String KEY_QUALITY = "quality";
    public static String KEY_PRIORITY = "priority";
    public static String KEY_OPERATING_RATE = "operating-rate";
    public static String KEY_PROFILE = "profile";
    public static String KEY_LEVEL = "level";
    public static String KEY_LATENCY = "latency";
    public static String KEY_ROTATION = "rotation-degrees";
    public static String KEY_BITRATE_MODE = "bitrate-mode";
    public static String KEY_AUDIO_SESSION_ID = "audio-session-id";
    public static String KEY_IS_AUTOSELECT = "is-autoselect";
    public static String KEY_IS_DEFAULT = "is-default";
    public static String KEY_IS_FORCED_SUBTITLE = "is-forced-subtitle";
    public static String KEY_IS_TIMED_TEXT = "is-timed-text";
    public static String KEY_COLOR_STANDARD = "color-standard";
    public static int COLOR_STANDARD_BT709 = 1;
    public static int COLOR_STANDARD_BT601_PAL = 2;
    public static int COLOR_STANDARD_BT601_NTSC = 4;
    public static int COLOR_STANDARD_BT2020 = 6;
    public static String KEY_COLOR_TRANSFER = "color-transfer";
    public static int COLOR_TRANSFER_LINEAR = 1;
    public static int COLOR_TRANSFER_SDR_VIDEO = 3;
    public static int COLOR_TRANSFER_ST2084 = 6;
    public static int COLOR_TRANSFER_HLG = 7;
    public static String KEY_COLOR_RANGE = "color-range";
    public static int COLOR_RANGE_LIMITED = 2;
    public static int COLOR_RANGE_FULL = 1;
    public static String KEY_HDR_STATIC_INFO = "hdr-static-info";
    public static String KEY_TRACK_ID = "track-id";
    public static String KEY_CA_SYSTEM_ID = "ca-system-id";
    public static String KEY_CA_SESSION_ID = "ca-session-id";
    public static String KEY_FEATURE_ = "feature-";

    private void $$robo$$android_media_MediaFormat$__constructor__(Map<String, Object> map) {
        this.mMap = map;
    }

    private void $$robo$$android_media_MediaFormat$__constructor__() {
        this.mMap = new HashMap<String, Object>();
    }

    private final Map<String, Object> $$robo$$android_media_MediaFormat$getMap() {
        return this.mMap;
    }

    private final boolean $$robo$$android_media_MediaFormat$containsKey(String name) {
        return this.mMap.containsKey(name);
    }

    private final int $$robo$$android_media_MediaFormat$getInteger(String name) {
        return (Integer)this.mMap.get(name);
    }

    private final int $$robo$$android_media_MediaFormat$getInteger(String name, int defaultValue) {
        try {
            return this.getInteger(name);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return defaultValue;
    }

    private final long $$robo$$android_media_MediaFormat$getLong(String name) {
        return (Long)this.mMap.get(name);
    }

    private final float $$robo$$android_media_MediaFormat$getFloat(String name) {
        return ((Float)this.mMap.get(name)).floatValue();
    }

    private final String $$robo$$android_media_MediaFormat$getString(String name) {
        return (String)this.mMap.get(name);
    }

    private final ByteBuffer $$robo$$android_media_MediaFormat$getByteBuffer(String name) {
        return (ByteBuffer)this.mMap.get(name);
    }

    private final boolean $$robo$$android_media_MediaFormat$getFeatureEnabled(String feature) {
        Integer enabled = (Integer)this.mMap.get("feature-" + feature);
        if (enabled == null) {
            throw new IllegalArgumentException("feature is not specified");
        }
        return enabled != 0;
    }

    private final void $$robo$$android_media_MediaFormat$setInteger(String name, int value) {
        this.mMap.put(name, value);
    }

    private final void $$robo$$android_media_MediaFormat$setLong(String name, long value) {
        this.mMap.put(name, value);
    }

    private final void $$robo$$android_media_MediaFormat$setFloat(String name, float value) {
        this.mMap.put(name, new Float(value));
    }

    private final void $$robo$$android_media_MediaFormat$setString(String name, String value) {
        this.mMap.put(name, value);
    }

    private final void $$robo$$android_media_MediaFormat$setByteBuffer(String name, ByteBuffer bytes) {
        this.mMap.put(name, bytes);
    }

    private final void $$robo$$android_media_MediaFormat$setFeatureEnabled(String feature, boolean enabled) {
        this.setInteger("feature-" + feature, enabled ? 1 : 0);
    }

    private static final MediaFormat $$robo$$android_media_MediaFormat$createAudioFormat(String mime, int sampleRate, int channelCount) {
        MediaFormat format = new MediaFormat();
        format.setString("mime", mime);
        format.setInteger("sample-rate", sampleRate);
        format.setInteger("channel-count", channelCount);
        return format;
    }

    private static final MediaFormat $$robo$$android_media_MediaFormat$createSubtitleFormat(String mime, String language) {
        MediaFormat format = new MediaFormat();
        format.setString("mime", mime);
        format.setString("language", language);
        return format;
    }

    private static final MediaFormat $$robo$$android_media_MediaFormat$createVideoFormat(String mime, int width, int height) {
        MediaFormat format = new MediaFormat();
        format.setString("mime", mime);
        format.setInteger("width", width);
        format.setInteger("height", height);
        return format;
    }

    private final String $$robo$$android_media_MediaFormat$toString() {
        return this.mMap.toString();
    }

    private void __constructor__(Map<String, Object> map) {
        this.$$robo$$android_media_MediaFormat$__constructor__(map);
    }

    MediaFormat(Map<String, Object> map) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFormat$__constructor__(java.util.Map<java.lang.String, java.lang.Object> ), 0, this, map);
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaFormat$__constructor__();
    }

    public MediaFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFormat$__constructor__(), 0, this);
    }

    Map<String, Object> getMap() {
        return InvokeDynamicSupport.bootstrap("getMap", $$robo$$android_media_MediaFormat$getMap(), 0, this);
    }

    public boolean containsKey(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsKey", $$robo$$android_media_MediaFormat$containsKey(java.lang.String ), 0, this, string2);
    }

    public int getInteger(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getInteger", $$robo$$android_media_MediaFormat$getInteger(java.lang.String ), 0, this, string2);
    }

    public int getInteger(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getInteger", $$robo$$android_media_MediaFormat$getInteger(java.lang.String int ), 0, this, string2, n);
    }

    public long getLong(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_media_MediaFormat$getLong(java.lang.String ), 0, this, string2);
    }

    public float getFloat(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_media_MediaFormat$getFloat(java.lang.String ), 0, this, string2);
    }

    public String getString(String string2) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_media_MediaFormat$getString(java.lang.String ), 0, this, string2);
    }

    public ByteBuffer getByteBuffer(String string2) {
        return InvokeDynamicSupport.bootstrap("getByteBuffer", $$robo$$android_media_MediaFormat$getByteBuffer(java.lang.String ), 0, this, string2);
    }

    public boolean getFeatureEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getFeatureEnabled", $$robo$$android_media_MediaFormat$getFeatureEnabled(java.lang.String ), 0, this, string2);
    }

    public void setInteger(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setInteger", $$robo$$android_media_MediaFormat$setInteger(java.lang.String int ), 0, this, string2, n);
    }

    public void setLong(String string2, long l) {
        InvokeDynamicSupport.bootstrap("setLong", $$robo$$android_media_MediaFormat$setLong(java.lang.String long ), 0, this, string2, l);
    }

    public void setFloat(String string2, float f) {
        InvokeDynamicSupport.bootstrap("setFloat", $$robo$$android_media_MediaFormat$setFloat(java.lang.String float ), 0, this, string2, f);
    }

    public void setString(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setString", $$robo$$android_media_MediaFormat$setString(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setByteBuffer(String string2, ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("setByteBuffer", $$robo$$android_media_MediaFormat$setByteBuffer(java.lang.String java.nio.ByteBuffer ), 0, this, string2, byteBuffer);
    }

    public void setFeatureEnabled(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setFeatureEnabled", $$robo$$android_media_MediaFormat$setFeatureEnabled(java.lang.String boolean ), 0, this, string2, bl);
    }

    public static MediaFormat createAudioFormat(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createAudioFormat", $$robo$$android_media_MediaFormat$createAudioFormat(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    public static MediaFormat createSubtitleFormat(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("createSubtitleFormat", $$robo$$android_media_MediaFormat$createSubtitleFormat(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static MediaFormat createVideoFormat(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createVideoFormat", $$robo$$android_media_MediaFormat$createVideoFormat(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaFormat$toString(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaFormat)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={2L, 1L})
    public static @interface ColorRange {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 3L, 6L, 7L})
    public static @interface ColorTransfer {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 4L, 6L})
    public static @interface ColorStandard {
    }
}

