/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.AudioManager;
import android.os.Handler;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AudioFocusRequest
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static AudioAttributes FOCUS_DEFAULT_ATTR;
    private AudioManager.OnAudioFocusChangeListener mFocusListener;
    private Handler mListenerHandler;
    private AudioAttributes mAttr;
    private int mFocusGain;
    private int mFlags;

    private void $$robo$$android_media_AudioFocusRequest$__constructor__(AudioManager.OnAudioFocusChangeListener listener, Handler handler, AudioAttributes attr2, int focusGain, int flags) {
        this.mFocusListener = listener;
        this.mListenerHandler = handler;
        this.mFocusGain = focusGain;
        this.mAttr = attr2;
        this.mFlags = flags;
    }

    private static final boolean $$robo$$android_media_AudioFocusRequest$isValidFocusGain(int focusGain) {
        switch (focusGain) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private final AudioManager.OnAudioFocusChangeListener $$robo$$android_media_AudioFocusRequest$getOnAudioFocusChangeListener() {
        return this.mFocusListener;
    }

    private final Handler $$robo$$android_media_AudioFocusRequest$getOnAudioFocusChangeListenerHandler() {
        return this.mListenerHandler;
    }

    private final AudioAttributes $$robo$$android_media_AudioFocusRequest$getAudioAttributes() {
        return this.mAttr;
    }

    private final int $$robo$$android_media_AudioFocusRequest$getFocusGain() {
        return this.mFocusGain;
    }

    private final boolean $$robo$$android_media_AudioFocusRequest$willPauseWhenDucked() {
        return (this.mFlags & 2) == 2;
    }

    private final boolean $$robo$$android_media_AudioFocusRequest$acceptsDelayedFocusGain() {
        return (this.mFlags & 1) == 1;
    }

    private final boolean $$robo$$android_media_AudioFocusRequest$locksFocus() {
        return (this.mFlags & 4) == 4;
    }

    private final int $$robo$$android_media_AudioFocusRequest$getFlags() {
        return this.mFlags;
    }

    private /* synthetic */ void $$robo$$android_media_AudioFocusRequest$__constructor__(AudioManager.OnAudioFocusChangeListener x0, Handler x1, AudioAttributes x2, int x3, int x4, 1 x5) {
    }

    static void __staticInitializer__() {
        FOCUS_DEFAULT_ATTR = new AudioAttributes.Builder().setUsage(1).build();
    }

    private void __constructor__(AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Handler handler, AudioAttributes audioAttributes, int n, int n2) {
        this.$$robo$$android_media_AudioFocusRequest$__constructor__(onAudioFocusChangeListener, handler, audioAttributes, n, n2);
    }

    private AudioFocusRequest(AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Handler handler, AudioAttributes audioAttributes, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFocusRequest$__constructor__(android.media.AudioManager$OnAudioFocusChangeListener android.os.Handler android.media.AudioAttributes int int ), 0, this, onAudioFocusChangeListener, handler, audioAttributes, n, n2);
    }

    static boolean isValidFocusGain(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidFocusGain", $$robo$$android_media_AudioFocusRequest$isValidFocusGain(int ), 0, (int)n);
    }

    public AudioManager.OnAudioFocusChangeListener getOnAudioFocusChangeListener() {
        return InvokeDynamicSupport.bootstrap("getOnAudioFocusChangeListener", $$robo$$android_media_AudioFocusRequest$getOnAudioFocusChangeListener(), 0, this);
    }

    public Handler getOnAudioFocusChangeListenerHandler() {
        return InvokeDynamicSupport.bootstrap("getOnAudioFocusChangeListenerHandler", $$robo$$android_media_AudioFocusRequest$getOnAudioFocusChangeListenerHandler(), 0, this);
    }

    public AudioAttributes getAudioAttributes() {
        return InvokeDynamicSupport.bootstrap("getAudioAttributes", $$robo$$android_media_AudioFocusRequest$getAudioAttributes(), 0, this);
    }

    public int getFocusGain() {
        return (int)InvokeDynamicSupport.bootstrap("getFocusGain", $$robo$$android_media_AudioFocusRequest$getFocusGain(), 0, this);
    }

    public boolean willPauseWhenDucked() {
        return (boolean)InvokeDynamicSupport.bootstrap("willPauseWhenDucked", $$robo$$android_media_AudioFocusRequest$willPauseWhenDucked(), 0, this);
    }

    public boolean acceptsDelayedFocusGain() {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptsDelayedFocusGain", $$robo$$android_media_AudioFocusRequest$acceptsDelayedFocusGain(), 0, this);
    }

    public boolean locksFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("locksFocus", $$robo$$android_media_AudioFocusRequest$locksFocus(), 0, this);
    }

    int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_media_AudioFocusRequest$getFlags(), 0, this);
    }

    private /* synthetic */ void __constructor__(AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Handler handler, AudioAttributes audioAttributes, int n, int n2, 1 var6_6) {
        this.$$robo$$android_media_AudioFocusRequest$__constructor__(onAudioFocusChangeListener, handler, audioAttributes, n, n2, var6_6);
    }

    static {
        RobolectricInternals.classInitializing(AudioFocusRequest.class);
    }

    public /* synthetic */ AudioFocusRequest() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioFocusRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AudioManager.OnAudioFocusChangeListener mFocusListener;
        private Handler mListenerHandler;
        private AudioAttributes mAttr;
        private int mFocusGain;
        private boolean mPausesOnDuck;
        private boolean mDelayedFocus;
        private boolean mFocusLocked;

        private void $$robo$$android_media_AudioFocusRequest_Builder$__constructor__(int focusGain) {
            this.mAttr = FOCUS_DEFAULT_ATTR;
            this.mPausesOnDuck = false;
            this.mDelayedFocus = false;
            this.mFocusLocked = false;
            this.setFocusGain(focusGain);
        }

        private void $$robo$$android_media_AudioFocusRequest_Builder$__constructor__(AudioFocusRequest requestToCopy) {
            this.mAttr = FOCUS_DEFAULT_ATTR;
            this.mPausesOnDuck = false;
            this.mDelayedFocus = false;
            this.mFocusLocked = false;
            if (requestToCopy == null) {
                throw new IllegalArgumentException("Illegal null AudioFocusRequest");
            }
            this.mAttr = requestToCopy.mAttr;
            this.mFocusListener = requestToCopy.mFocusListener;
            this.mListenerHandler = requestToCopy.mListenerHandler;
            this.mFocusGain = requestToCopy.mFocusGain;
            this.mPausesOnDuck = requestToCopy.willPauseWhenDucked();
            this.mDelayedFocus = requestToCopy.acceptsDelayedFocusGain();
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setFocusGain(int focusGain) {
            if (!AudioFocusRequest.isValidFocusGain(focusGain)) {
                throw new IllegalArgumentException("Illegal audio focus gain type " + focusGain);
            }
            this.mFocusGain = focusGain;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setOnAudioFocusChangeListener(AudioManager.OnAudioFocusChangeListener listener) {
            if (listener == null) {
                throw new NullPointerException("Illegal null focus listener");
            }
            this.mFocusListener = listener;
            this.mListenerHandler = null;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setOnAudioFocusChangeListenerInt(AudioManager.OnAudioFocusChangeListener listener, Handler handler) {
            this.mFocusListener = listener;
            this.mListenerHandler = handler;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setOnAudioFocusChangeListener(AudioManager.OnAudioFocusChangeListener listener, Handler handler) {
            if (listener == null || handler == null) {
                throw new NullPointerException("Illegal null focus listener or handler");
            }
            this.mFocusListener = listener;
            this.mListenerHandler = handler;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setAudioAttributes(AudioAttributes attributes) {
            if (attributes == null) {
                throw new NullPointerException("Illegal null AudioAttributes");
            }
            this.mAttr = attributes;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setWillPauseWhenDucked(boolean pauseOnDuck) {
            this.mPausesOnDuck = pauseOnDuck;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setAcceptsDelayedFocusGain(boolean acceptsDelayedFocusGain) {
            this.mDelayedFocus = acceptsDelayedFocusGain;
            return this;
        }

        private final Builder $$robo$$android_media_AudioFocusRequest_Builder$setLocksFocus(boolean focusLocked) {
            this.mFocusLocked = focusLocked;
            return this;
        }

        private final AudioFocusRequest $$robo$$android_media_AudioFocusRequest_Builder$build() {
            if ((this.mDelayedFocus || this.mPausesOnDuck) && this.mFocusListener == null) {
                throw new IllegalStateException("Can't use delayed focus or pause on duck without a listener");
            }
            int flags = 0 | (this.mDelayedFocus ? 1 : 0) | (this.mPausesOnDuck ? 2 : 0) | (this.mFocusLocked ? 4 : 0);
            return new AudioFocusRequest(this.mFocusListener, this.mListenerHandler, this.mAttr, this.mFocusGain, flags);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_media_AudioFocusRequest_Builder$__constructor__(n);
        }

        public Builder(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFocusRequest_Builder$__constructor__(int ), 0, this, n);
        }

        private void __constructor__(AudioFocusRequest audioFocusRequest) {
            this.$$robo$$android_media_AudioFocusRequest_Builder$__constructor__(audioFocusRequest);
        }

        public Builder(AudioFocusRequest audioFocusRequest) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioFocusRequest_Builder$__constructor__(android.media.AudioFocusRequest ), 0, this, audioFocusRequest);
        }

        public Builder setFocusGain(int n) {
            return InvokeDynamicSupport.bootstrap("setFocusGain", $$robo$$android_media_AudioFocusRequest_Builder$setFocusGain(int ), 0, this, n);
        }

        public Builder setOnAudioFocusChangeListener(AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener) {
            return InvokeDynamicSupport.bootstrap("setOnAudioFocusChangeListener", $$robo$$android_media_AudioFocusRequest_Builder$setOnAudioFocusChangeListener(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
        }

        Builder setOnAudioFocusChangeListenerInt(AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Handler handler) {
            return InvokeDynamicSupport.bootstrap("setOnAudioFocusChangeListenerInt", $$robo$$android_media_AudioFocusRequest_Builder$setOnAudioFocusChangeListenerInt(android.media.AudioManager$OnAudioFocusChangeListener android.os.Handler ), 0, this, onAudioFocusChangeListener, handler);
        }

        public Builder setOnAudioFocusChangeListener(AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Handler handler) {
            return InvokeDynamicSupport.bootstrap("setOnAudioFocusChangeListener", $$robo$$android_media_AudioFocusRequest_Builder$setOnAudioFocusChangeListener(android.media.AudioManager$OnAudioFocusChangeListener android.os.Handler ), 0, this, onAudioFocusChangeListener, handler);
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes) {
            return InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_AudioFocusRequest_Builder$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
        }

        public Builder setWillPauseWhenDucked(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setWillPauseWhenDucked", $$robo$$android_media_AudioFocusRequest_Builder$setWillPauseWhenDucked(boolean ), 0, this, bl);
        }

        public Builder setAcceptsDelayedFocusGain(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setAcceptsDelayedFocusGain", $$robo$$android_media_AudioFocusRequest_Builder$setAcceptsDelayedFocusGain(boolean ), 0, this, bl);
        }

        public Builder setLocksFocus(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setLocksFocus", $$robo$$android_media_AudioFocusRequest_Builder$setLocksFocus(boolean ), 0, this, bl);
        }

        public AudioFocusRequest build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_AudioFocusRequest_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

