/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AudioAttributes
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AudioAttributes";
    public static int CONTENT_TYPE_UNKNOWN = 0;
    public static int CONTENT_TYPE_SPEECH = 1;
    public static int CONTENT_TYPE_MUSIC = 2;
    public static int CONTENT_TYPE_MOVIE = 3;
    public static int CONTENT_TYPE_SONIFICATION = 4;
    public static int USAGE_UNKNOWN = 0;
    public static int USAGE_MEDIA = 1;
    public static int USAGE_VOICE_COMMUNICATION = 2;
    public static int USAGE_VOICE_COMMUNICATION_SIGNALLING = 3;
    public static int USAGE_ALARM = 4;
    public static int USAGE_NOTIFICATION = 5;
    public static int USAGE_NOTIFICATION_RINGTONE = 6;
    public static int USAGE_NOTIFICATION_COMMUNICATION_REQUEST = 7;
    public static int USAGE_NOTIFICATION_COMMUNICATION_INSTANT = 8;
    public static int USAGE_NOTIFICATION_COMMUNICATION_DELAYED = 9;
    public static int USAGE_NOTIFICATION_EVENT = 10;
    public static int USAGE_ASSISTANCE_ACCESSIBILITY = 11;
    public static int USAGE_ASSISTANCE_NAVIGATION_GUIDANCE = 12;
    public static int USAGE_ASSISTANCE_SONIFICATION = 13;
    public static int USAGE_GAME = 14;
    public static int USAGE_VIRTUAL_SOURCE = 15;
    public static int USAGE_ASSISTANT = 16;
    public static int SUPPRESSIBLE_NOTIFICATION = 1;
    public static int SUPPRESSIBLE_CALL = 2;
    public static int SUPPRESSIBLE_NEVER = 3;
    public static SparseIntArray SUPPRESSIBLE_USAGES;
    public static int[] SDK_USAGES;
    public static int FLAG_AUDIBILITY_ENFORCED = 1;
    public static int FLAG_SECURE = 2;
    public static int FLAG_SCO = 4;
    public static int FLAG_BEACON = 8;
    public static int FLAG_HW_AV_SYNC = 16;
    public static int FLAG_HW_HOTWORD = 32;
    public static int FLAG_BYPASS_INTERRUPTION_POLICY = 64;
    public static int FLAG_BYPASS_MUTE = 128;
    public static int FLAG_LOW_LATENCY = 256;
    public static int FLAG_DEEP_BUFFER = 512;
    private static int FLAG_ALL = 1023;
    private static int FLAG_ALL_PUBLIC = 273;
    private int mUsage;
    private int mContentType;
    private int mSource;
    private int mFlags;
    private HashSet<String> mTags;
    private String mFormattedTags;
    private Bundle mBundle;
    public static int FLATTEN_TAGS = 1;
    private static int ATTR_PARCEL_IS_NULL_BUNDLE = -1977;
    private static int ATTR_PARCEL_IS_VALID_BUNDLE = 1980;
    private static int ALL_PARCEL_FLAGS = 1;
    public static Parcelable.Creator<AudioAttributes> CREATOR;

    private void $$robo$$android_media_AudioAttributes$__constructor__() {
        this.mUsage = 0;
        this.mContentType = 0;
        this.mSource = -1;
        this.mFlags = 0;
    }

    private final int $$robo$$android_media_AudioAttributes$getContentType() {
        return this.mContentType;
    }

    private final int $$robo$$android_media_AudioAttributes$getUsage() {
        return this.mUsage;
    }

    private final int $$robo$$android_media_AudioAttributes$getCapturePreset() {
        return this.mSource;
    }

    private final int $$robo$$android_media_AudioAttributes$getFlags() {
        return this.mFlags & 0x111;
    }

    private final int $$robo$$android_media_AudioAttributes$getAllFlags() {
        return this.mFlags & 0x3FF;
    }

    private final Bundle $$robo$$android_media_AudioAttributes$getBundle() {
        if (this.mBundle == null) {
            return this.mBundle;
        }
        return new Bundle(this.mBundle);
    }

    private final Set<String> $$robo$$android_media_AudioAttributes$getTags() {
        return Collections.unmodifiableSet(this.mTags);
    }

    private final int $$robo$$android_media_AudioAttributes$describeContents() {
        return 0;
    }

    private final void $$robo$$android_media_AudioAttributes$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mUsage);
        dest.writeInt(this.mContentType);
        dest.writeInt(this.mSource);
        dest.writeInt(this.mFlags);
        dest.writeInt(flags & 1);
        if ((flags & 1) == 0) {
            String[] tagsArray = new String[this.mTags.size()];
            this.mTags.toArray(tagsArray);
            dest.writeStringArray(tagsArray);
        } else if ((flags & 1) == 1) {
            dest.writeString(this.mFormattedTags);
        }
        if (this.mBundle == null) {
            dest.writeInt(-1977);
        } else {
            dest.writeInt(1980);
            dest.writeBundle(this.mBundle);
        }
    }

    private void $$robo$$android_media_AudioAttributes$__constructor__(Parcel in) {
        this.mUsage = 0;
        this.mContentType = 0;
        this.mSource = -1;
        this.mFlags = 0;
        this.mUsage = in.readInt();
        this.mContentType = in.readInt();
        this.mSource = in.readInt();
        this.mFlags = in.readInt();
        boolean hasFlattenedTags = (in.readInt() & 1) == 1;
        this.mTags = new HashSet();
        if (hasFlattenedTags) {
            this.mFormattedTags = new String(in.readString());
            this.mTags.add(this.mFormattedTags);
        } else {
            String[] tagsArray = in.readStringArray();
            for (int i = tagsArray.length - 1; i >= 0; --i) {
                this.mTags.add(tagsArray[i]);
            }
            this.mFormattedTags = TextUtils.join((CharSequence)";", this.mTags);
        }
        switch (in.readInt()) {
            case -1977: {
                this.mBundle = null;
                break;
            }
            case 1980: {
                this.mBundle = new Bundle(in.readBundle());
                break;
            }
            default: {
                Log.e("AudioAttributes", "Illegal value unmarshalling AudioAttributes, can't initialize bundle");
            }
        }
    }

    private final boolean $$robo$$android_media_AudioAttributes$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioAttributes that = (AudioAttributes)o;
        return this.mContentType == that.mContentType && this.mFlags == that.mFlags && this.mSource == that.mSource && this.mUsage == that.mUsage && this.mFormattedTags.equals(that.mFormattedTags);
    }

    private final int $$robo$$android_media_AudioAttributes$hashCode() {
        return Objects.hash(this.mContentType, this.mFlags, this.mSource, this.mUsage, this.mFormattedTags, this.mBundle);
    }

    private final String $$robo$$android_media_AudioAttributes$toString() {
        return new String("AudioAttributes: usage=" + this.mUsage + " content=" + this.mContentType + " flags=0x" + Integer.toHexString(this.mFlags).toUpperCase() + " tags=" + this.mFormattedTags + " bundle=" + (this.mBundle == null ? "null" : this.mBundle.toString()));
    }

    private final String $$robo$$android_media_AudioAttributes$usageToString() {
        return AudioAttributes.usageToString(this.mUsage);
    }

    private static final String $$robo$$android_media_AudioAttributes$usageToString(int usage) {
        switch (usage) {
            case 0: {
                return new String("USAGE_UNKNOWN");
            }
            case 1: {
                return new String("USAGE_MEDIA");
            }
            case 2: {
                return new String("USAGE_VOICE_COMMUNICATION");
            }
            case 3: {
                return new String("USAGE_VOICE_COMMUNICATION_SIGNALLING");
            }
            case 4: {
                return new String("USAGE_ALARM");
            }
            case 5: {
                return new String("USAGE_NOTIFICATION");
            }
            case 6: {
                return new String("USAGE_NOTIFICATION_RINGTONE");
            }
            case 7: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_REQUEST");
            }
            case 8: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_INSTANT");
            }
            case 9: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_DELAYED");
            }
            case 10: {
                return new String("USAGE_NOTIFICATION_EVENT");
            }
            case 11: {
                return new String("USAGE_ASSISTANCE_ACCESSIBILITY");
            }
            case 12: {
                return new String("USAGE_ASSISTANCE_NAVIGATION_GUIDANCE");
            }
            case 13: {
                return new String("USAGE_ASSISTANCE_SONIFICATION");
            }
            case 14: {
                return new String("USAGE_GAME");
            }
            case 16: {
                return new String("USAGE_ASSISTANT");
            }
        }
        return new String("unknown usage " + usage);
    }

    private static final int $$robo$$android_media_AudioAttributes$usageForStreamType(int streamType) {
        switch (streamType) {
            case 0: {
                return 2;
            }
            case 1: 
            case 7: {
                return 13;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 10: {
                return 11;
            }
        }
        return 0;
    }

    private final int $$robo$$android_media_AudioAttributes$getVolumeControlStream() {
        return AudioAttributes.toVolumeStreamType(true, this);
    }

    private static final int $$robo$$android_media_AudioAttributes$toLegacyStreamType(AudioAttributes aa) {
        return AudioAttributes.toVolumeStreamType(false, aa);
    }

    private static final int $$robo$$android_media_AudioAttributes$toVolumeStreamType(boolean fromGetVolumeControlStream, AudioAttributes aa) {
        if ((aa.getFlags() & 1) == 1) {
            return fromGetVolumeControlStream ? 1 : 7;
        }
        if ((aa.getFlags() & 4) == 4) {
            return fromGetVolumeControlStream ? 0 : 6;
        }
        switch (aa.getUsage()) {
            case 1: 
            case 12: 
            case 14: 
            case 16: {
                return 3;
            }
            case 13: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return fromGetVolumeControlStream ? 0 : 8;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 5;
            }
            case 11: {
                return 10;
            }
            case 0: {
                return fromGetVolumeControlStream ? Integer.MIN_VALUE : 3;
            }
        }
        if (fromGetVolumeControlStream) {
            throw new IllegalArgumentException("Unknown usage value " + aa.getUsage() + " in audio attributes");
        }
        return 3;
    }

    private /* synthetic */ void $$robo$$android_media_AudioAttributes$__constructor__(1 x0) {
    }

    private /* synthetic */ void $$robo$$android_media_AudioAttributes$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        SUPPRESSIBLE_USAGES = new SparseIntArray();
        SUPPRESSIBLE_USAGES.put(5, 1);
        SUPPRESSIBLE_USAGES.put(6, 2);
        SUPPRESSIBLE_USAGES.put(7, 2);
        SUPPRESSIBLE_USAGES.put(8, 1);
        SUPPRESSIBLE_USAGES.put(9, 1);
        SUPPRESSIBLE_USAGES.put(10, 1);
        SUPPRESSIBLE_USAGES.put(11, 3);
        SDK_USAGES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        CREATOR = new Parcelable.Creator<AudioAttributes>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_AudioAttributes_1$__constructor__() {
            }

            private final AudioAttributes $$robo$$android_media_AudioAttributes_1$createFromParcel(Parcel p) {
                return new AudioAttributes(p);
            }

            private final AudioAttributes[] $$robo$$android_media_AudioAttributes_1$newArray(int size) {
                return new AudioAttributes[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_AudioAttributes_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioAttributes_1$__constructor__(), 0, this);
            }

            @Override
            public AudioAttributes createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_AudioAttributes_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AudioAttributes[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_AudioAttributes_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_media_AudioAttributes$__constructor__();
    }

    private AudioAttributes() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioAttributes$__constructor__(), 0, this);
    }

    public int getContentType() {
        return (int)InvokeDynamicSupport.bootstrap("getContentType", $$robo$$android_media_AudioAttributes$getContentType(), 0, this);
    }

    public int getUsage() {
        return (int)InvokeDynamicSupport.bootstrap("getUsage", $$robo$$android_media_AudioAttributes$getUsage(), 0, this);
    }

    public int getCapturePreset() {
        return (int)InvokeDynamicSupport.bootstrap("getCapturePreset", $$robo$$android_media_AudioAttributes$getCapturePreset(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_media_AudioAttributes$getFlags(), 0, this);
    }

    public int getAllFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getAllFlags", $$robo$$android_media_AudioAttributes$getAllFlags(), 0, this);
    }

    public Bundle getBundle() {
        return InvokeDynamicSupport.bootstrap("getBundle", $$robo$$android_media_AudioAttributes$getBundle(), 0, this);
    }

    public Set<String> getTags() {
        return InvokeDynamicSupport.bootstrap("getTags", $$robo$$android_media_AudioAttributes$getTags(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_AudioAttributes$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_AudioAttributes$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_AudioAttributes$__constructor__(parcel);
    }

    private AudioAttributes(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioAttributes$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_AudioAttributes$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_AudioAttributes$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_AudioAttributes$toString(), 0, this);
    }

    public String usageToString() {
        return InvokeDynamicSupport.bootstrap("usageToString", $$robo$$android_media_AudioAttributes$usageToString(), 0, this);
    }

    public static String usageToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("usageToString", $$robo$$android_media_AudioAttributes$usageToString(int ), 0, (int)n);
    }

    private static int usageForStreamType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("usageForStreamType", $$robo$$android_media_AudioAttributes$usageForStreamType(int ), 0, (int)n);
    }

    public int getVolumeControlStream() {
        return (int)InvokeDynamicSupport.bootstrap("getVolumeControlStream", $$robo$$android_media_AudioAttributes$getVolumeControlStream(), 0, this);
    }

    public static int toLegacyStreamType(AudioAttributes audioAttributes) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toLegacyStreamType", $$robo$$android_media_AudioAttributes$toLegacyStreamType(android.media.AudioAttributes ), 0, (AudioAttributes)audioAttributes);
    }

    private static int toVolumeStreamType(boolean bl, AudioAttributes audioAttributes) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toVolumeStreamType", $$robo$$android_media_AudioAttributes$toVolumeStreamType(boolean android.media.AudioAttributes ), 0, (boolean)bl, (AudioAttributes)audioAttributes);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_media_AudioAttributes$__constructor__(var1_1);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_AudioAttributes$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AudioAttributes.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioAttributes)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L})
    public static @interface AttributeContentType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 16L})
    public static @interface AttributeUsage {
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mUsage;
        private int mContentType;
        private int mSource;
        private int mFlags;
        private HashSet<String> mTags;
        private Bundle mBundle;

        private void $$robo$$android_media_AudioAttributes_Builder$__constructor__() {
            this.mUsage = 0;
            this.mContentType = 0;
            this.mSource = -1;
            this.mFlags = 0;
            this.mTags = new HashSet();
        }

        private void $$robo$$android_media_AudioAttributes_Builder$__constructor__(AudioAttributes aa) {
            this.mUsage = 0;
            this.mContentType = 0;
            this.mSource = -1;
            this.mFlags = 0;
            this.mTags = new HashSet();
            this.mUsage = aa.mUsage;
            this.mContentType = aa.mContentType;
            this.mFlags = aa.mFlags;
            this.mTags = (HashSet)aa.mTags.clone();
        }

        private final AudioAttributes $$robo$$android_media_AudioAttributes_Builder$build() {
            AudioAttributes aa = new AudioAttributes();
            aa.mContentType = this.mContentType;
            aa.mUsage = this.mUsage;
            aa.mSource = this.mSource;
            aa.mFlags = this.mFlags;
            aa.mTags = (HashSet)this.mTags.clone();
            aa.mFormattedTags = TextUtils.join((CharSequence)";", this.mTags);
            if (this.mBundle != null) {
                aa.mBundle = new Bundle(this.mBundle);
            }
            return aa;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$setUsage(int usage) {
            switch (usage) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.mUsage = usage;
                    break;
                }
                default: {
                    this.mUsage = 0;
                }
            }
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$setContentType(int contentType) {
            switch (contentType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.mContentType = contentType;
                    break;
                }
                default: {
                    this.mUsage = 0;
                }
            }
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$setFlags(int flags) {
            this.mFlags |= (flags &= 0x3FF);
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$replaceFlags(int flags) {
            this.mFlags = flags & 0x3FF;
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$addBundle(Bundle bundle) {
            if (bundle == null) {
                throw new IllegalArgumentException("Illegal null bundle");
            }
            if (this.mBundle == null) {
                this.mBundle = new Bundle(bundle);
            } else {
                this.mBundle.putAll(bundle);
            }
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$addTag(String tag) {
            this.mTags.add(tag);
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$setLegacyStreamType(int streamType) {
            if (streamType == 10) {
                throw new IllegalArgumentException("STREAM_ACCESSIBILITY is not a legacy stream type that was used for audio playback");
            }
            return this.setInternalLegacyStreamType(streamType);
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$setInternalLegacyStreamType(int streamType) {
            switch (streamType) {
                case 0: {
                    this.mContentType = 1;
                    break;
                }
                case 7: {
                    this.mFlags |= 1;
                }
                case 1: {
                    this.mContentType = 4;
                    break;
                }
                case 2: {
                    this.mContentType = 4;
                    break;
                }
                case 3: {
                    this.mContentType = 2;
                    break;
                }
                case 4: {
                    this.mContentType = 4;
                    break;
                }
                case 5: {
                    this.mContentType = 4;
                    break;
                }
                case 6: {
                    this.mContentType = 1;
                    this.mFlags |= 4;
                    break;
                }
                case 8: {
                    this.mContentType = 4;
                    break;
                }
                case 9: {
                    this.mContentType = 4;
                    break;
                }
                case 10: {
                    this.mContentType = 1;
                    break;
                }
                default: {
                    Log.e("AudioAttributes", "Invalid stream type " + streamType + " for AudioAttributes");
                }
            }
            this.mUsage = AudioAttributes.usageForStreamType(streamType);
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$setCapturePreset(int preset) {
            switch (preset) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    this.mSource = preset;
                    break;
                }
                default: {
                    Log.e("AudioAttributes", "Invalid capture preset " + preset + " for AudioAttributes");
                }
            }
            return this;
        }

        private final Builder $$robo$$android_media_AudioAttributes_Builder$setInternalCapturePreset(int preset) {
            if (preset == 1999 || preset == 8 || preset == 1998) {
                this.mSource = preset;
            } else {
                this.setCapturePreset(preset);
            }
            return this;
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioAttributes_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioAttributes_Builder$__constructor__(), 0, this);
        }

        private void __constructor__(AudioAttributes audioAttributes) {
            this.$$robo$$android_media_AudioAttributes_Builder$__constructor__(audioAttributes);
        }

        public Builder(AudioAttributes audioAttributes) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioAttributes_Builder$__constructor__(android.media.AudioAttributes ), 0, this, audioAttributes);
        }

        public AudioAttributes build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_AudioAttributes_Builder$build(), 0, this);
        }

        public Builder setUsage(int n) {
            return InvokeDynamicSupport.bootstrap("setUsage", $$robo$$android_media_AudioAttributes_Builder$setUsage(int ), 0, this, n);
        }

        public Builder setContentType(int n) {
            return InvokeDynamicSupport.bootstrap("setContentType", $$robo$$android_media_AudioAttributes_Builder$setContentType(int ), 0, this, n);
        }

        public Builder setFlags(int n) {
            return InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_media_AudioAttributes_Builder$setFlags(int ), 0, this, n);
        }

        public Builder replaceFlags(int n) {
            return InvokeDynamicSupport.bootstrap("replaceFlags", $$robo$$android_media_AudioAttributes_Builder$replaceFlags(int ), 0, this, n);
        }

        public Builder addBundle(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("addBundle", $$robo$$android_media_AudioAttributes_Builder$addBundle(android.os.Bundle ), 0, this, bundle);
        }

        public Builder addTag(String string2) {
            return InvokeDynamicSupport.bootstrap("addTag", $$robo$$android_media_AudioAttributes_Builder$addTag(java.lang.String ), 0, this, string2);
        }

        public Builder setLegacyStreamType(int n) {
            return InvokeDynamicSupport.bootstrap("setLegacyStreamType", $$robo$$android_media_AudioAttributes_Builder$setLegacyStreamType(int ), 0, this, n);
        }

        public Builder setInternalLegacyStreamType(int n) {
            return InvokeDynamicSupport.bootstrap("setInternalLegacyStreamType", $$robo$$android_media_AudioAttributes_Builder$setInternalLegacyStreamType(int ), 0, this, n);
        }

        public Builder setCapturePreset(int n) {
            return InvokeDynamicSupport.bootstrap("setCapturePreset", $$robo$$android_media_AudioAttributes_Builder$setCapturePreset(int ), 0, this, n);
        }

        public Builder setInternalCapturePreset(int n) {
            return InvokeDynamicSupport.bootstrap("setInternalCapturePreset", $$robo$$android_media_AudioAttributes_Builder$setInternalCapturePreset(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

