/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.IBinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.WindowManager;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SoftInputWindow
extends Dialog
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    String mName;
    Callback mCallback;
    KeyEvent.Callback mKeyEventCallback;
    KeyEvent.DispatcherState mDispatcherState;
    int mWindowType;
    int mGravity;
    boolean mTakesFocus;
    private Rect mBounds;

    private final void $$robo$$android_inputmethodservice_SoftInputWindow$setToken(IBinder token) {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.token = token;
        this.getWindow().setAttributes(lp);
    }

    private void $$robo$$android_inputmethodservice_SoftInputWindow$__constructor__(Context context, String name, int theme, Callback callback, KeyEvent.Callback keyEventCallback, KeyEvent.DispatcherState dispatcherState, int windowType, int gravity, boolean takesFocus) {
        this.mBounds = new Rect();
        this.mName = name;
        this.mCallback = callback;
        this.mKeyEventCallback = keyEventCallback;
        this.mDispatcherState = dispatcherState;
        this.mWindowType = windowType;
        this.mGravity = gravity;
        this.mTakesFocus = takesFocus;
        this.initDockWindow();
    }

    private final void $$robo$$android_inputmethodservice_SoftInputWindow$onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.mDispatcherState.reset();
    }

    private final boolean $$robo$$android_inputmethodservice_SoftInputWindow$dispatchTouchEvent(MotionEvent ev) {
        this.getWindow().getDecorView().getHitRect(this.mBounds);
        if (ev.isWithinBoundsNoHistory(this.mBounds.left, this.mBounds.top, this.mBounds.right - 1, this.mBounds.bottom - 1)) {
            return super.dispatchTouchEvent(ev);
        }
        MotionEvent temp = ev.clampNoHistory(this.mBounds.left, this.mBounds.top, this.mBounds.right - 1, this.mBounds.bottom - 1);
        boolean handled = super.dispatchTouchEvent(temp);
        temp.recycle();
        return handled;
    }

    private final void $$robo$$android_inputmethodservice_SoftInputWindow$setGravity(int gravity) {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.gravity = gravity;
        this.updateWidthHeight(lp);
        this.getWindow().setAttributes(lp);
    }

    private final int $$robo$$android_inputmethodservice_SoftInputWindow$getGravity() {
        return this.getWindow().getAttributes().gravity;
    }

    private final void $$robo$$android_inputmethodservice_SoftInputWindow$updateWidthHeight(WindowManager.LayoutParams lp) {
        if (lp.gravity == 48 || lp.gravity == 80) {
            lp.width = -1;
            lp.height = -2;
        } else {
            lp.width = -2;
            lp.height = -1;
        }
    }

    private final boolean $$robo$$android_inputmethodservice_SoftInputWindow$onKeyDown(int keyCode, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyDown(keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private final boolean $$robo$$android_inputmethodservice_SoftInputWindow$onKeyLongPress(int keyCode, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyLongPress(keyCode, event)) {
            return true;
        }
        return super.onKeyLongPress(keyCode, event);
    }

    private final boolean $$robo$$android_inputmethodservice_SoftInputWindow$onKeyUp(int keyCode, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyUp(keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private final boolean $$robo$$android_inputmethodservice_SoftInputWindow$onKeyMultiple(int keyCode, int count, KeyEvent event) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyMultiple(keyCode, count, event)) {
            return true;
        }
        return super.onKeyMultiple(keyCode, count, event);
    }

    private final void $$robo$$android_inputmethodservice_SoftInputWindow$onBackPressed() {
        if (this.mCallback != null) {
            this.mCallback.onBackPressed();
        } else {
            super.onBackPressed();
        }
    }

    private final void $$robo$$android_inputmethodservice_SoftInputWindow$initDockWindow() {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.type = this.mWindowType;
        lp.setTitle(this.mName);
        lp.gravity = this.mGravity;
        this.updateWidthHeight(lp);
        this.getWindow().setAttributes(lp);
        int windowSetFlags = 256;
        int windowModFlags = 266;
        if (!this.mTakesFocus) {
            windowSetFlags |= 8;
        } else {
            windowSetFlags |= 0x20;
            windowModFlags |= 0x20;
        }
        this.getWindow().setFlags(windowSetFlags, windowModFlags);
    }

    public void setToken(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setToken", $$robo$$android_inputmethodservice_SoftInputWindow$setToken(android.os.IBinder ), 0, this, iBinder);
    }

    private void __constructor__(Context context, String string2, int n, Callback callback, KeyEvent.Callback callback2, KeyEvent.DispatcherState dispatcherState, int n2, int n3, boolean bl) {
        this.$$robo$$android_inputmethodservice_SoftInputWindow$__constructor__(context, string2, n, callback, callback2, dispatcherState, n2, n3, bl);
    }

    public SoftInputWindow(Context context, String string2, int n, Callback callback, KeyEvent.Callback callback2, KeyEvent.DispatcherState dispatcherState, int n2, int n3, boolean bl) {
        super(context, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_SoftInputWindow$__constructor__(android.content.Context java.lang.String int android.inputmethodservice.SoftInputWindow$Callback android.view.KeyEvent$Callback android.view.KeyEvent$DispatcherState int int boolean ), 0, this, context, string2, n, callback, callback2, dispatcherState, n2, n3, bl);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_inputmethodservice_SoftInputWindow$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_inputmethodservice_SoftInputWindow$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_inputmethodservice_SoftInputWindow$setGravity(int ), 0, this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_inputmethodservice_SoftInputWindow$getGravity(), 0, this);
    }

    private void updateWidthHeight(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("updateWidthHeight", $$robo$$android_inputmethodservice_SoftInputWindow$updateWidthHeight(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_inputmethodservice_SoftInputWindow$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyLongPress", $$robo$$android_inputmethodservice_SoftInputWindow$onKeyLongPress(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_inputmethodservice_SoftInputWindow$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_inputmethodservice_SoftInputWindow$onKeyMultiple(int int android.view.KeyEvent ), 0, this, n, n2, keyEvent);
    }

    @Override
    public void onBackPressed() {
        InvokeDynamicSupport.bootstrap("onBackPressed", $$robo$$android_inputmethodservice_SoftInputWindow$onBackPressed(), 0, this);
    }

    private void initDockWindow() {
        InvokeDynamicSupport.bootstrap("initDockWindow", $$robo$$android_inputmethodservice_SoftInputWindow$initDockWindow(), 0, this);
    }

    public /* synthetic */ SoftInputWindow() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoftInputWindow)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void onBackPressed();
    }
}

