/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.Grego;
import android.icu.util.AnnualTimeZoneRule;
import android.icu.util.BasicTimeZone;
import android.icu.util.InitialTimeZoneRule;
import android.icu.util.TimeZone;
import android.icu.util.TimeZoneRule;
import android.icu.util.TimeZoneTransition;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RuleBasedTimeZone
extends BasicTimeZone
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 7580833058949327935L;
    private InitialTimeZoneRule initialRule;
    private List<TimeZoneRule> historicRules;
    private AnnualTimeZoneRule[] finalRules;
    private transient List<TimeZoneTransition> historicTransitions;
    private transient boolean upToDate;
    private volatile transient boolean isFrozen;

    private void $$robo$$android_icu_util_RuleBasedTimeZone$__constructor__(String id2, InitialTimeZoneRule initialRule) {
        this.isFrozen = false;
        this.initialRule = initialRule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_icu_util_RuleBasedTimeZone$addTransitionRule(TimeZoneRule rule) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen RuleBasedTimeZone instance.");
        }
        if (!rule.isTransitionRule()) {
            throw new IllegalArgumentException("Rule must be a transition rule");
        }
        if (rule instanceof AnnualTimeZoneRule && ((AnnualTimeZoneRule)rule).getEndYear() == Integer.MAX_VALUE) {
            if (this.finalRules == null) {
                this.finalRules = new AnnualTimeZoneRule[2];
                this.finalRules[0] = (AnnualTimeZoneRule)rule;
            } else {
                if (this.finalRules[1] != null) throw new IllegalStateException("Too many final rules");
                this.finalRules[1] = (AnnualTimeZoneRule)rule;
            }
        } else {
            if (this.historicRules == null) {
                this.historicRules = new ArrayList<TimeZoneRule>();
            }
            this.historicRules.add(rule);
        }
        this.upToDate = false;
    }

    private final int $$robo$$android_icu_util_RuleBasedTimeZone$getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        if (era == 0) {
            year = 1 - year;
        }
        long time = Grego.fieldsToDay(year, month, day) * 86400000L + (long)milliseconds;
        int[] offsets = new int[2];
        this.getOffset(time, true, 3, 1, offsets);
        return offsets[0] + offsets[1];
    }

    private final void $$robo$$android_icu_util_RuleBasedTimeZone$getOffset(long time, boolean local, int[] offsets) {
        this.getOffset(time, local, 4, 12, offsets);
    }

    @Deprecated
    private final void $$robo$$android_icu_util_RuleBasedTimeZone$getOffsetFromLocal(long date, int nonExistingTimeOpt, int duplicatedTimeOpt, int[] offsets) {
        this.getOffset(date, true, nonExistingTimeOpt, duplicatedTimeOpt, offsets);
    }

    private final int $$robo$$android_icu_util_RuleBasedTimeZone$getRawOffset() {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        int[] offsets = new int[2];
        this.getOffset((long)now, false, offsets);
        return offsets[0];
    }

    private final boolean $$robo$$android_icu_util_RuleBasedTimeZone$inDaylightTime(Date date) {
        int[] offsets = new int[2];
        this.getOffset(date.getTime(), false, offsets);
        return offsets[1] != 0;
    }

    private final void $$robo$$android_icu_util_RuleBasedTimeZone$setRawOffset(int offsetMillis) {
        throw new UnsupportedOperationException("setRawOffset in RuleBasedTimeZone is not supported.");
    }

    private final boolean $$robo$$android_icu_util_RuleBasedTimeZone$useDaylightTime() {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        int[] offsets = new int[2];
        this.getOffset((long)now, false, offsets);
        if (offsets[1] != 0) {
            return true;
        }
        TimeZoneTransition tt = this.getNextTransition((long)now, false);
        return tt != null && tt.getTo().getDSTSavings() != 0;
    }

    private final boolean $$robo$$android_icu_util_RuleBasedTimeZone$observesDaylightTime() {
        TimeZoneTransition tt;
        BitSet checkFinals;
        Object time = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        int[] offsets = new int[2];
        this.getOffset((long)time, false, offsets);
        if (offsets[1] != 0) {
            return true;
        }
        BitSet bitSet = checkFinals = this.finalRules == null ? null : new BitSet(this.finalRules.length);
        while ((tt = this.getNextTransition((long)time, false)) != null) {
            TimeZoneRule toRule = tt.getTo();
            if (toRule.getDSTSavings() != 0) {
                return true;
            }
            if (checkFinals != null) {
                for (int i = 0; i < this.finalRules.length; ++i) {
                    if (!this.finalRules[i].equals(toRule)) continue;
                    checkFinals.set(i);
                }
                if (checkFinals.cardinality() == this.finalRules.length) break;
            }
            time = tt.getTime();
        }
        return false;
    }

    private final boolean $$robo$$android_icu_util_RuleBasedTimeZone$hasSameRules(TimeZone other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuleBasedTimeZone)) {
            return false;
        }
        RuleBasedTimeZone otherRBTZ = (RuleBasedTimeZone)other;
        if (!this.initialRule.isEquivalentTo(otherRBTZ.initialRule)) {
            return false;
        }
        if (this.finalRules != null && otherRBTZ.finalRules != null) {
            for (int i = 0; i < this.finalRules.length; ++i) {
                if (this.finalRules[i] == null && otherRBTZ.finalRules[i] == null || this.finalRules[i] != null && otherRBTZ.finalRules[i] != null && this.finalRules[i].isEquivalentTo(otherRBTZ.finalRules[i])) continue;
                return false;
            }
        } else if (this.finalRules != null || otherRBTZ.finalRules != null) {
            return false;
        }
        if (this.historicRules != null && otherRBTZ.historicRules != null) {
            if (this.historicRules.size() != otherRBTZ.historicRules.size()) {
                return false;
            }
            for (TimeZoneRule rule : this.historicRules) {
                boolean foundSameRule = false;
                for (TimeZoneRule orule : otherRBTZ.historicRules) {
                    if (!rule.isEquivalentTo(orule)) continue;
                    foundSameRule = true;
                    break;
                }
                if (foundSameRule) continue;
                return false;
            }
        } else if (this.historicRules != null || otherRBTZ.historicRules != null) {
            return false;
        }
        return true;
    }

    private final TimeZoneRule[] $$robo$$android_icu_util_RuleBasedTimeZone$getTimeZoneRules() {
        int size = 1;
        if (this.historicRules != null) {
            size += this.historicRules.size();
        }
        if (this.finalRules != null) {
            size = this.finalRules[1] != null ? (size += 2) : ++size;
        }
        TimeZoneRule[] rules = new TimeZoneRule[size];
        rules[0] = this.initialRule;
        if (this.historicRules != null) {
            for (int idx = 1; idx < this.historicRules.size() + 1; ++idx) {
                rules[idx] = this.historicRules.get(idx - 1);
            }
        }
        if (this.finalRules != null) {
            rules[idx++] = this.finalRules[0];
            if (this.finalRules[1] != null) {
                rules[idx] = this.finalRules[1];
            }
        }
        return rules;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final TimeZoneTransition $$robo$$android_icu_util_RuleBasedTimeZone$getNextTransition(long base, boolean inclusive) {
        TimeZoneTransition result;
        this.complete();
        if (this.historicTransitions == null) {
            return null;
        }
        boolean isFinal = false;
        TimeZoneTransition tzt = this.historicTransitions.get(0);
        long tt = tzt.getTime();
        if (tt > base || inclusive && tt == base) {
            result = tzt;
        } else {
            int idx = this.historicTransitions.size() - 1;
            tzt = this.historicTransitions.get(idx);
            tt = tzt.getTime();
            if (inclusive && tt == base) {
                result = tzt;
            } else if (tt <= base) {
                if (this.finalRules == null) return null;
                Date start0 = this.finalRules[0].getNextStart(base, this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), inclusive);
                Date start1 = this.finalRules[1].getNextStart(base, this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), inclusive);
                tzt = start1.after(start0) ? new TimeZoneTransition(start0.getTime(), this.finalRules[1], this.finalRules[0]) : new TimeZoneTransition(start1.getTime(), this.finalRules[0], this.finalRules[1]);
                result = tzt;
                isFinal = true;
            } else {
                --idx;
                TimeZoneTransition prev = tzt;
                while (idx > 0 && (tt = (tzt = this.historicTransitions.get(idx)).getTime()) >= base && (inclusive || tt != base)) {
                    --idx;
                    prev = tzt;
                }
                result = prev;
            }
        }
        TimeZoneRule from = result.getFrom();
        TimeZoneRule to = result.getTo();
        if (from.getRawOffset() != to.getRawOffset()) return result;
        if (from.getDSTSavings() != to.getDSTSavings()) return result;
        if (!isFinal) return this.getNextTransition(result.getTime(), false);
        return null;
    }

    private final TimeZoneTransition $$robo$$android_icu_util_RuleBasedTimeZone$getPreviousTransition(long base, boolean inclusive) {
        TimeZoneTransition result;
        this.complete();
        if (this.historicTransitions == null) {
            return null;
        }
        TimeZoneTransition tzt = this.historicTransitions.get(0);
        long tt = tzt.getTime();
        if (inclusive && tt == base) {
            result = tzt;
        } else {
            if (tt >= base) {
                return null;
            }
            int idx = this.historicTransitions.size() - 1;
            tzt = this.historicTransitions.get(idx);
            tt = tzt.getTime();
            if (inclusive && tt == base) {
                result = tzt;
            } else if (tt < base) {
                if (this.finalRules != null) {
                    Date start0 = this.finalRules[0].getPreviousStart(base, this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), inclusive);
                    Date start1 = this.finalRules[1].getPreviousStart(base, this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), inclusive);
                    tzt = start1.before(start0) ? new TimeZoneTransition(start0.getTime(), this.finalRules[1], this.finalRules[0]) : new TimeZoneTransition(start1.getTime(), this.finalRules[0], this.finalRules[1]);
                }
                result = tzt;
            } else {
                --idx;
                while (!(idx < 0 || (tt = (tzt = this.historicTransitions.get(idx)).getTime()) < base || inclusive && tt == base)) {
                    --idx;
                }
                result = tzt;
            }
        }
        TimeZoneRule from = result.getFrom();
        TimeZoneRule to = result.getTo();
        if (from.getRawOffset() == to.getRawOffset() && from.getDSTSavings() == to.getDSTSavings()) {
            result = this.getPreviousTransition(result.getTime(), false);
        }
        return result;
    }

    private final Object $$robo$$android_icu_util_RuleBasedTimeZone$clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    private final void $$robo$$android_icu_util_RuleBasedTimeZone$complete() {
        if (this.upToDate) {
            return;
        }
        if (this.finalRules != null && this.finalRules[1] == null) {
            throw new IllegalStateException("Incomplete final rules");
        }
        if (this.historicRules != null || this.finalRules != null) {
            InitialTimeZoneRule curRule = this.initialRule;
            long lastTransitionTime = -184303902528000000L;
            if (this.historicRules != null) {
                BitSet done = new BitSet(this.historicRules.size());
                while (true) {
                    long tt;
                    Date d;
                    int i;
                    int curStdOffset = curRule.getRawOffset();
                    int curDstSavings = curRule.getDSTSavings();
                    long nextTransitionTime = 183882168921600000L;
                    TimeZoneRule nextRule = null;
                    for (i = 0; i < this.historicRules.size(); ++i) {
                        if (done.get(i)) continue;
                        TimeZoneRule r = this.historicRules.get(i);
                        d = r.getNextStart(lastTransitionTime, curStdOffset, curDstSavings, false);
                        if (d == null) {
                            done.set(i);
                            continue;
                        }
                        if (r == curRule || r.getName().equals(curRule.getName()) && r.getRawOffset() == curRule.getRawOffset() && r.getDSTSavings() == curRule.getDSTSavings() || (tt = d.getTime()) >= nextTransitionTime) continue;
                        nextTransitionTime = tt;
                        nextRule = r;
                    }
                    if (nextRule == null) {
                        boolean bDoneAll = true;
                        for (int j = 0; j < this.historicRules.size(); ++j) {
                            if (done.get(j)) continue;
                            bDoneAll = false;
                            break;
                        }
                        if (bDoneAll) break;
                    }
                    if (this.finalRules != null) {
                        for (i = 0; i < 2; ++i) {
                            if (this.finalRules[i] == curRule || (d = this.finalRules[i].getNextStart(lastTransitionTime, curStdOffset, curDstSavings, false)) == null || (tt = d.getTime()) >= nextTransitionTime) continue;
                            nextTransitionTime = tt;
                            nextRule = this.finalRules[i];
                        }
                    }
                    if (nextRule == null) break;
                    if (this.historicTransitions == null) {
                        this.historicTransitions = new ArrayList<TimeZoneTransition>();
                    }
                    this.historicTransitions.add(new TimeZoneTransition(nextTransitionTime, curRule, nextRule));
                    lastTransitionTime = nextTransitionTime;
                    curRule = nextRule;
                }
            }
            if (this.finalRules != null) {
                if (this.historicTransitions == null) {
                    this.historicTransitions = new ArrayList<TimeZoneTransition>();
                }
                Date d0 = this.finalRules[0].getNextStart(lastTransitionTime, curRule.getRawOffset(), curRule.getDSTSavings(), false);
                Date d1 = this.finalRules[1].getNextStart(lastTransitionTime, curRule.getRawOffset(), curRule.getDSTSavings(), false);
                if (d1.after(d0)) {
                    this.historicTransitions.add(new TimeZoneTransition(d0.getTime(), curRule, this.finalRules[0]));
                    d1 = this.finalRules[1].getNextStart(d0.getTime(), this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), false);
                    this.historicTransitions.add(new TimeZoneTransition(d1.getTime(), this.finalRules[0], this.finalRules[1]));
                } else {
                    this.historicTransitions.add(new TimeZoneTransition(d1.getTime(), curRule, this.finalRules[1]));
                    d0 = this.finalRules[0].getNextStart(d1.getTime(), this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), false);
                    this.historicTransitions.add(new TimeZoneTransition(d0.getTime(), this.finalRules[1], this.finalRules[0]));
                }
            }
        }
        this.upToDate = true;
    }

    private final void $$robo$$android_icu_util_RuleBasedTimeZone$getOffset(long time, boolean local, int NonExistingTimeOpt, int DuplicatedTimeOpt, int[] offsets) {
        this.complete();
        TimeZoneRule rule = null;
        if (this.historicTransitions == null) {
            rule = this.initialRule;
        } else {
            long tstart = RuleBasedTimeZone.getTransitionTime(this.historicTransitions.get(0), local, NonExistingTimeOpt, DuplicatedTimeOpt);
            if (time < tstart) {
                rule = this.initialRule;
            } else {
                int idx = this.historicTransitions.size() - 1;
                long tend = RuleBasedTimeZone.getTransitionTime(this.historicTransitions.get(idx), local, NonExistingTimeOpt, DuplicatedTimeOpt);
                if (time > tend) {
                    if (this.finalRules != null) {
                        rule = this.findRuleInFinal(time, local, NonExistingTimeOpt, DuplicatedTimeOpt);
                    }
                    if (rule == null) {
                        rule = this.historicTransitions.get(idx).getTo();
                    }
                } else {
                    while (idx >= 0 && time < RuleBasedTimeZone.getTransitionTime(this.historicTransitions.get(idx), local, NonExistingTimeOpt, DuplicatedTimeOpt)) {
                        --idx;
                    }
                    rule = this.historicTransitions.get(idx).getTo();
                }
            }
        }
        offsets[0] = rule.getRawOffset();
        offsets[1] = rule.getDSTSavings();
    }

    private final TimeZoneRule $$robo$$android_icu_util_RuleBasedTimeZone$findRuleInFinal(long time, boolean local, int NonExistingTimeOpt, int DuplicatedTimeOpt) {
        int localDelta;
        if (this.finalRules == null || this.finalRules.length != 2 || this.finalRules[0] == null || this.finalRules[1] == null) {
            return null;
        }
        long base = time;
        if (local) {
            localDelta = RuleBasedTimeZone.getLocalDelta(this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), NonExistingTimeOpt, DuplicatedTimeOpt);
            base -= (long)localDelta;
        }
        Date start0 = this.finalRules[0].getPreviousStart(base, this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), true);
        base = time;
        if (local) {
            localDelta = RuleBasedTimeZone.getLocalDelta(this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), this.finalRules[1].getRawOffset(), this.finalRules[1].getDSTSavings(), NonExistingTimeOpt, DuplicatedTimeOpt);
            base -= (long)localDelta;
        }
        Date start1 = this.finalRules[1].getPreviousStart(base, this.finalRules[0].getRawOffset(), this.finalRules[0].getDSTSavings(), true);
        if (start0 == null || start1 == null) {
            if (start0 != null) {
                return this.finalRules[0];
            }
            if (start1 != null) {
                return this.finalRules[1];
            }
            return null;
        }
        return start0.after(start1) ? this.finalRules[0] : this.finalRules[1];
    }

    private static final long $$robo$$android_icu_util_RuleBasedTimeZone$getTransitionTime(TimeZoneTransition tzt, boolean local, int NonExistingTimeOpt, int DuplicatedTimeOpt) {
        long time = tzt.getTime();
        if (local) {
            time += (long)RuleBasedTimeZone.getLocalDelta(tzt.getFrom().getRawOffset(), tzt.getFrom().getDSTSavings(), tzt.getTo().getRawOffset(), tzt.getTo().getDSTSavings(), NonExistingTimeOpt, DuplicatedTimeOpt);
        }
        return time;
    }

    private static final int $$robo$$android_icu_util_RuleBasedTimeZone$getLocalDelta(int rawBefore, int dstBefore, int rawAfter, int dstAfter, int NonExistingTimeOpt, int DuplicatedTimeOpt) {
        boolean stdToDst;
        int delta = 0;
        int offsetBefore = rawBefore + dstBefore;
        int offsetAfter = rawAfter + dstAfter;
        boolean dstToStd = dstBefore != 0 && dstAfter == 0;
        boolean bl = stdToDst = dstBefore == 0 && dstAfter != 0;
        delta = offsetAfter - offsetBefore >= 0 ? ((NonExistingTimeOpt & 3) == 1 && dstToStd || (NonExistingTimeOpt & 3) == 3 && stdToDst ? offsetBefore : ((NonExistingTimeOpt & 3) == 1 && stdToDst || (NonExistingTimeOpt & 3) == 3 && dstToStd ? offsetAfter : ((NonExistingTimeOpt & 0xC) == 12 ? offsetBefore : offsetAfter))) : ((DuplicatedTimeOpt & 3) == 1 && dstToStd || (DuplicatedTimeOpt & 3) == 3 && stdToDst ? offsetAfter : ((DuplicatedTimeOpt & 3) == 1 && stdToDst || (DuplicatedTimeOpt & 3) == 3 && dstToStd ? offsetBefore : ((DuplicatedTimeOpt & 0xC) == 4 ? offsetBefore : offsetAfter)));
        return delta;
    }

    private final boolean $$robo$$android_icu_util_RuleBasedTimeZone$isFrozen() {
        return this.isFrozen;
    }

    private final TimeZone $$robo$$android_icu_util_RuleBasedTimeZone$freeze() {
        this.complete();
        this.isFrozen = true;
        return this;
    }

    private final TimeZone $$robo$$android_icu_util_RuleBasedTimeZone$cloneAsThawed() {
        RuleBasedTimeZone tz = (RuleBasedTimeZone)super.cloneAsThawed();
        if (this.historicRules != null) {
            tz.historicRules = new ArrayList<TimeZoneRule>(this.historicRules);
        }
        if (this.finalRules != null) {
            tz.finalRules = (AnnualTimeZoneRule[])this.finalRules.clone();
        }
        tz.isFrozen = false;
        return tz;
    }

    private void __constructor__(String string2, InitialTimeZoneRule initialTimeZoneRule) {
        this.$$robo$$android_icu_util_RuleBasedTimeZone$__constructor__(string2, initialTimeZoneRule);
    }

    public RuleBasedTimeZone(String string2, InitialTimeZoneRule initialTimeZoneRule) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_RuleBasedTimeZone$__constructor__(java.lang.String android.icu.util.InitialTimeZoneRule ), 0, this, string2, initialTimeZoneRule);
    }

    public void addTransitionRule(TimeZoneRule timeZoneRule) {
        InvokeDynamicSupport.bootstrap("addTransitionRule", $$robo$$android_icu_util_RuleBasedTimeZone$addTransitionRule(android.icu.util.TimeZoneRule ), 0, this, timeZoneRule);
    }

    @Override
    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_util_RuleBasedTimeZone$getOffset(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void getOffset(long l, boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_util_RuleBasedTimeZone$getOffset(long boolean int[] ), 0, this, l, bl, nArray);
    }

    @Override
    @Deprecated
    public void getOffsetFromLocal(long l, int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("getOffsetFromLocal", $$robo$$android_icu_util_RuleBasedTimeZone$getOffsetFromLocal(long int int int[] ), 0, this, l, n, n2, nArray);
    }

    @Override
    public int getRawOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getRawOffset", $$robo$$android_icu_util_RuleBasedTimeZone$getRawOffset(), 0, this);
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return (boolean)InvokeDynamicSupport.bootstrap("inDaylightTime", $$robo$$android_icu_util_RuleBasedTimeZone$inDaylightTime(java.util.Date ), 0, this, date);
    }

    @Override
    public void setRawOffset(int n) {
        InvokeDynamicSupport.bootstrap("setRawOffset", $$robo$$android_icu_util_RuleBasedTimeZone$setRawOffset(int ), 0, this, n);
    }

    @Override
    public boolean useDaylightTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("useDaylightTime", $$robo$$android_icu_util_RuleBasedTimeZone$useDaylightTime(), 0, this);
    }

    @Override
    public boolean observesDaylightTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("observesDaylightTime", $$robo$$android_icu_util_RuleBasedTimeZone$observesDaylightTime(), 0, this);
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameRules", $$robo$$android_icu_util_RuleBasedTimeZone$hasSameRules(android.icu.util.TimeZone ), 0, this, timeZone);
    }

    @Override
    public TimeZoneRule[] getTimeZoneRules() {
        return InvokeDynamicSupport.bootstrap("getTimeZoneRules", $$robo$$android_icu_util_RuleBasedTimeZone$getTimeZoneRules(), 0, this);
    }

    @Override
    public TimeZoneTransition getNextTransition(long l, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getNextTransition", $$robo$$android_icu_util_RuleBasedTimeZone$getNextTransition(long boolean ), 0, this, l, bl);
    }

    @Override
    public TimeZoneTransition getPreviousTransition(long l, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPreviousTransition", $$robo$$android_icu_util_RuleBasedTimeZone$getPreviousTransition(long boolean ), 0, this, l, bl);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_util_RuleBasedTimeZone$clone(), 0, this);
    }

    private void complete() {
        InvokeDynamicSupport.bootstrap("complete", $$robo$$android_icu_util_RuleBasedTimeZone$complete(), 0, this);
    }

    private void getOffset(long l, boolean bl, int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_util_RuleBasedTimeZone$getOffset(long boolean int int int[] ), 0, this, l, bl, n, n2, nArray);
    }

    private TimeZoneRule findRuleInFinal(long l, boolean bl, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("findRuleInFinal", $$robo$$android_icu_util_RuleBasedTimeZone$findRuleInFinal(long boolean int int ), 0, this, l, bl, n, n2);
    }

    private static long getTransitionTime(TimeZoneTransition timeZoneTransition, boolean bl, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getTransitionTime", $$robo$$android_icu_util_RuleBasedTimeZone$getTransitionTime(android.icu.util.TimeZoneTransition boolean int int ), 0, (TimeZoneTransition)timeZoneTransition, (boolean)bl, (int)n, (int)n2);
    }

    private static int getLocalDelta(int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLocalDelta", $$robo$$android_icu_util_RuleBasedTimeZone$getLocalDelta(int int int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_util_RuleBasedTimeZone$isFrozen(), 0, this);
    }

    @Override
    public TimeZone freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_util_RuleBasedTimeZone$freeze(), 0, this);
    }

    @Override
    public TimeZone cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_util_RuleBasedTimeZone$cloneAsThawed(), 0, this);
    }

    public /* synthetic */ RuleBasedTimeZone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuleBasedTimeZone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

