/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.ICUResourceBundle;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class Region
implements Comparable<Region> {
    public transient /* synthetic */ Object __robo_data__;
    private String id;
    private int code;
    private RegionType type;
    private Region containingRegion;
    private Set<Region> containedRegions;
    private List<Region> preferredValues;
    private static boolean regionDataIsLoaded;
    private static Map<String, Region> regionIDMap;
    private static Map<Integer, Region> numericCodeMap;
    private static Map<String, Region> regionAliases;
    private static ArrayList<Region> regions;
    private static ArrayList<Set<Region>> availableRegions;
    private static String UNKNOWN_REGION_ID = "ZZ";
    private static String OUTLYING_OCEANIA_REGION_ID = "QO";
    private static String WORLD_ID = "001";

    private void $$robo$$android_icu_util_Region$__constructor__() {
        this.containingRegion = null;
        this.containedRegions = new TreeSet<Region>();
        this.preferredValues = null;
    }

    private static final synchronized void $$robo$$android_icu_util_Region$loadRegionData() {
        int i;
        int i2;
        if (regionDataIsLoaded) {
            return;
        }
        regionAliases = new HashMap<String, Region>();
        regionIDMap = new HashMap<String, Region>();
        numericCodeMap = new HashMap<Integer, Region>();
        availableRegions = new ArrayList(RegionType.values().length);
        UResourceBundle metadataAlias = null;
        UResourceBundle territoryAlias = null;
        UResourceBundle codeMappings = null;
        UResourceBundle idValidity = null;
        UResourceBundle regionList = null;
        UResourceBundle regionRegular = null;
        UResourceBundle regionMacro = null;
        UResourceBundle regionUnknown = null;
        UResourceBundle worldContainment = null;
        UResourceBundle territoryContainment = null;
        UResourceBundle groupingContainment = null;
        UResourceBundle metadata = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "metadata", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        metadataAlias = metadata.get("alias");
        territoryAlias = metadataAlias.get("territory");
        UResourceBundle supplementalData = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        codeMappings = supplementalData.get("codeMappings");
        idValidity = supplementalData.get("idValidity");
        regionList = idValidity.get("region");
        regionRegular = regionList.get("regular");
        regionMacro = regionList.get("macroregion");
        regionUnknown = regionList.get("unknown");
        territoryContainment = supplementalData.get("territoryContainment");
        worldContainment = territoryContainment.get("001");
        groupingContainment = territoryContainment.get("grouping");
        String[] continentsArr = worldContainment.getStringArray();
        List<String> continents = Arrays.asList(continentsArr);
        String[] groupingArr = groupingContainment.getStringArray();
        List<String> groupings = Arrays.asList(groupingArr);
        ArrayList<String> regionCodes = new ArrayList<String>();
        ArrayList<String> allRegions = new ArrayList<String>();
        allRegions.addAll(Arrays.asList(regionRegular.getStringArray()));
        allRegions.addAll(Arrays.asList(regionMacro.getStringArray()));
        allRegions.add(regionUnknown.getString());
        for (String r : allRegions) {
            int rangeMarkerLocation = r.indexOf("~");
            if (rangeMarkerLocation > 0) {
                StringBuilder regionName = new StringBuilder(r);
                char endRange = regionName.charAt(rangeMarkerLocation + 1);
                regionName.setLength(rangeMarkerLocation);
                for (char lastChar = regionName.charAt(rangeMarkerLocation - 1); lastChar <= endRange; lastChar = (char)(lastChar + '\u0001')) {
                    String newRegion = regionName.toString();
                    regionCodes.add(newRegion);
                    regionName.setCharAt(rangeMarkerLocation - 1, lastChar);
                }
                continue;
            }
            regionCodes.add(r);
        }
        regions = new ArrayList(regionCodes.size());
        for (String id2 : regionCodes) {
            Region r = new Region();
            r.id = id2;
            r.type = RegionType.TERRITORY;
            regionIDMap.put(id2, r);
            if (id2.matches("[0-9]{3}")) {
                r.code = Integer.valueOf(id2);
                numericCodeMap.put(r.code, r);
                r.type = RegionType.SUBCONTINENT;
            } else {
                r.code = -1;
            }
            regions.add(r);
        }
        for (i2 = 0; i2 < territoryAlias.getSize(); ++i2) {
            Region r;
            UResourceBundle res = territoryAlias.get(i2);
            String aliasFrom = res.getKey();
            String aliasTo = res.get("replacement").getString();
            if (regionIDMap.containsKey(aliasTo) && !regionIDMap.containsKey(aliasFrom)) {
                regionAliases.put(aliasFrom, regionIDMap.get(aliasTo));
                continue;
            }
            if (regionIDMap.containsKey(aliasFrom)) {
                r = regionIDMap.get(aliasFrom);
            } else {
                r = new Region();
                r.id = aliasFrom;
                regionIDMap.put(aliasFrom, r);
                if (aliasFrom.matches("[0-9]{3}")) {
                    r.code = Integer.valueOf(aliasFrom);
                    numericCodeMap.put(r.code, r);
                } else {
                    r.code = -1;
                }
                regions.add(r);
            }
            r.type = RegionType.DEPRECATED;
            List<String> aliasToRegionStrings = Arrays.asList(aliasTo.split(" "));
            r.preferredValues = new ArrayList<Region>();
            for (String s : aliasToRegionStrings) {
                if (!regionIDMap.containsKey(s)) continue;
                r.preferredValues.add(regionIDMap.get(s));
            }
        }
        for (i2 = 0; i2 < codeMappings.getSize(); ++i2) {
            UResourceBundle mapping = codeMappings.get(i2);
            if (mapping.getType() != 8) continue;
            String[] codeMappingStrings = mapping.getStringArray();
            String codeMappingID = codeMappingStrings[0];
            Integer codeMappingNumber = Integer.valueOf(codeMappingStrings[1]);
            String codeMapping3Letter = codeMappingStrings[2];
            if (!regionIDMap.containsKey(codeMappingID)) continue;
            Region r = regionIDMap.get(codeMappingID);
            r.code = codeMappingNumber;
            numericCodeMap.put(r.code, r);
            regionAliases.put(codeMapping3Letter, r);
        }
        if (regionIDMap.containsKey("001")) {
            Region r = regionIDMap.get("001");
            r.type = RegionType.WORLD;
        }
        if (regionIDMap.containsKey("ZZ")) {
            Region r = regionIDMap.get("ZZ");
            r.type = RegionType.UNKNOWN;
        }
        for (String continent : continents) {
            if (!regionIDMap.containsKey(continent)) continue;
            Region r = regionIDMap.get(continent);
            r.type = RegionType.CONTINENT;
        }
        for (String grouping : groupings) {
            if (!regionIDMap.containsKey(grouping)) continue;
            Region r = regionIDMap.get(grouping);
            r.type = RegionType.GROUPING;
        }
        if (regionIDMap.containsKey("QO")) {
            Region r = regionIDMap.get("QO");
            r.type = RegionType.SUBCONTINENT;
        }
        for (i = 0; i < territoryContainment.getSize(); ++i) {
            UResourceBundle mapping = territoryContainment.get(i);
            String parent = mapping.getKey();
            if (parent.equals("containedGroupings") || parent.equals("deprecated")) continue;
            Region parentRegion = regionIDMap.get(parent);
            for (int j = 0; j < mapping.getSize(); ++j) {
                String child = mapping.getString(j);
                Region childRegion = regionIDMap.get(child);
                if (parentRegion == null || childRegion == null) continue;
                parentRegion.containedRegions.add(childRegion);
                if (parentRegion.getType() == RegionType.GROUPING) continue;
                childRegion.containingRegion = parentRegion;
            }
        }
        for (i = 0; i < RegionType.values().length; ++i) {
            availableRegions.add(new TreeSet());
        }
        for (Region ar : regions) {
            Set<Region> currentSet = availableRegions.get(ar.type.ordinal());
            currentSet.add(ar);
            availableRegions.set(ar.type.ordinal(), currentSet);
        }
        regionDataIsLoaded = true;
    }

    private static final Region $$robo$$android_icu_util_Region$getInstance(String id2) {
        if (id2 == null) {
            throw new NullPointerException();
        }
        Region.loadRegionData();
        Region r = regionIDMap.get(id2);
        if (r == null) {
            r = regionAliases.get(id2);
        }
        if (r == null) {
            throw new IllegalArgumentException("Unknown region id: " + id2);
        }
        if (r.type == RegionType.DEPRECATED && r.preferredValues.size() == 1) {
            r = r.preferredValues.get(0);
        }
        return r;
    }

    private static final Region $$robo$$android_icu_util_Region$getInstance(int code) {
        Region.loadRegionData();
        Region r = numericCodeMap.get(code);
        if (r == null) {
            String pad = "";
            if (code < 10) {
                pad = "00";
            } else if (code < 100) {
                pad = "0";
            }
            String id2 = pad + Integer.toString(code);
            r = regionAliases.get(id2);
        }
        if (r == null) {
            throw new IllegalArgumentException("Unknown region code: " + code);
        }
        if (r.type == RegionType.DEPRECATED && r.preferredValues.size() == 1) {
            r = r.preferredValues.get(0);
        }
        return r;
    }

    private static final Set<Region> $$robo$$android_icu_util_Region$getAvailable(RegionType type) {
        Region.loadRegionData();
        return Collections.unmodifiableSet(availableRegions.get(type.ordinal()));
    }

    private final Region $$robo$$android_icu_util_Region$getContainingRegion() {
        Region.loadRegionData();
        return this.containingRegion;
    }

    private final Region $$robo$$android_icu_util_Region$getContainingRegion(RegionType type) {
        Region.loadRegionData();
        if (this.containingRegion == null) {
            return null;
        }
        if (this.containingRegion.type.equals((Object)type)) {
            return this.containingRegion;
        }
        return this.containingRegion.getContainingRegion(type);
    }

    private final Set<Region> $$robo$$android_icu_util_Region$getContainedRegions() {
        Region.loadRegionData();
        return Collections.unmodifiableSet(this.containedRegions);
    }

    private final Set<Region> $$robo$$android_icu_util_Region$getContainedRegions(RegionType type) {
        Region.loadRegionData();
        TreeSet<Region> result = new TreeSet<Region>();
        Set<Region> cr = this.getContainedRegions();
        for (Region r : cr) {
            if (r.getType() == type) {
                result.add(r);
                continue;
            }
            result.addAll(r.getContainedRegions(type));
        }
        return Collections.unmodifiableSet(result);
    }

    private final List<Region> $$robo$$android_icu_util_Region$getPreferredValues() {
        Region.loadRegionData();
        if (this.type == RegionType.DEPRECATED) {
            return Collections.unmodifiableList(this.preferredValues);
        }
        return null;
    }

    private final boolean $$robo$$android_icu_util_Region$contains(Region other) {
        Region.loadRegionData();
        if (this.containedRegions.contains(other)) {
            return true;
        }
        for (Region cr : this.containedRegions) {
            if (!cr.contains(other)) continue;
            return true;
        }
        return false;
    }

    private final String $$robo$$android_icu_util_Region$toString() {
        return this.id;
    }

    private final int $$robo$$android_icu_util_Region$getNumericCode() {
        return this.code;
    }

    private final RegionType $$robo$$android_icu_util_Region$getType() {
        return this.type;
    }

    private final int $$robo$$android_icu_util_Region$compareTo(Region other) {
        return this.id.compareTo(other.id);
    }

    static void __staticInitializer__() {
        regionDataIsLoaded = false;
        regionIDMap = null;
        numericCodeMap = null;
        regionAliases = null;
        regions = null;
        availableRegions = null;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_Region$__constructor__();
    }

    private Region() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Region$__constructor__(), 0, this);
    }

    private static synchronized void loadRegionData() {
        InvokeDynamicSupport.bootstrapStatic("loadRegionData", $$robo$$android_icu_util_Region$loadRegionData(), 0);
    }

    public static Region getInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Region$getInstance(java.lang.String ), 0, (String)string2);
    }

    public static Region getInstance(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Region$getInstance(int ), 0, (int)n);
    }

    public static Set<Region> getAvailable(RegionType regionType) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailable", $$robo$$android_icu_util_Region$getAvailable(android.icu.util.Region$RegionType ), 0, (RegionType)regionType);
    }

    public Region getContainingRegion() {
        return InvokeDynamicSupport.bootstrap("getContainingRegion", $$robo$$android_icu_util_Region$getContainingRegion(), 0, this);
    }

    public Region getContainingRegion(RegionType regionType) {
        return InvokeDynamicSupport.bootstrap("getContainingRegion", $$robo$$android_icu_util_Region$getContainingRegion(android.icu.util.Region$RegionType ), 0, this, regionType);
    }

    public Set<Region> getContainedRegions() {
        return InvokeDynamicSupport.bootstrap("getContainedRegions", $$robo$$android_icu_util_Region$getContainedRegions(), 0, this);
    }

    public Set<Region> getContainedRegions(RegionType regionType) {
        return InvokeDynamicSupport.bootstrap("getContainedRegions", $$robo$$android_icu_util_Region$getContainedRegions(android.icu.util.Region$RegionType ), 0, this, regionType);
    }

    public List<Region> getPreferredValues() {
        return InvokeDynamicSupport.bootstrap("getPreferredValues", $$robo$$android_icu_util_Region$getPreferredValues(), 0, this);
    }

    public boolean contains(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_util_Region$contains(android.icu.util.Region ), 0, this, region);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_Region$toString(), 0, this);
    }

    public int getNumericCode() {
        return (int)InvokeDynamicSupport.bootstrap("getNumericCode", $$robo$$android_icu_util_Region$getNumericCode(), 0, this);
    }

    public RegionType getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_util_Region$getType(), 0, this);
    }

    @Override
    public int compareTo(Region region) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_util_Region$compareTo(android.icu.util.Region ), 0, this, region);
    }

    static {
        RobolectricInternals.classInitializing(Region.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Region)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RegionType
    extends Enum<RegionType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ RegionType UNKNOWN;
        public static /* enum */ RegionType TERRITORY;
        public static /* enum */ RegionType WORLD;
        public static /* enum */ RegionType CONTINENT;
        public static /* enum */ RegionType SUBCONTINENT;
        public static /* enum */ RegionType GROUPING;
        public static /* enum */ RegionType DEPRECATED;
        private static /* synthetic */ RegionType[] $VALUES;

        private static final RegionType[] $$robo$$android_icu_util_Region_RegionType$values() {
            return (RegionType[])$VALUES.clone();
        }

        private static final RegionType $$robo$$android_icu_util_Region_RegionType$valueOf(String name) {
            return Enum.valueOf(RegionType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_Region_RegionType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            UNKNOWN = new RegionType();
            TERRITORY = new RegionType();
            WORLD = new RegionType();
            CONTINENT = new RegionType();
            SUBCONTINENT = new RegionType();
            GROUPING = new RegionType();
            DEPRECATED = new RegionType();
            $VALUES = new RegionType[]{UNKNOWN, TERRITORY, WORLD, CONTINENT, SUBCONTINENT, GROUPING, DEPRECATED};
        }

        public static RegionType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_Region_RegionType$values(), 0);
        }

        public static RegionType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_Region_RegionType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_Region_RegionType$__constructor__(string2, n);
        }

        private RegionType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Region_RegionType$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(RegionType.class);
        }

        public /* synthetic */ RegionType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegionType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

