/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.Utility;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    public transient /* synthetic */ Object __robo_data__;
    public byte[] bytes;
    public int size;

    private void $$robo$$android_icu_util_ByteArrayWrapper$__constructor__() {
    }

    private void $$robo$$android_icu_util_ByteArrayWrapper$__constructor__(byte[] bytesToAdopt, int size) {
        if (bytesToAdopt == null && size != 0 || size < 0 || bytesToAdopt != null && size > bytesToAdopt.length) {
            throw new IndexOutOfBoundsException("illegal size: " + size);
        }
        this.bytes = bytesToAdopt;
        this.size = size;
    }

    private void $$robo$$android_icu_util_ByteArrayWrapper$__constructor__(ByteBuffer source) {
        this.size = source.limit();
        this.bytes = new byte[this.size];
        source.get(this.bytes, 0, this.size);
    }

    private final ByteArrayWrapper $$robo$$android_icu_util_ByteArrayWrapper$ensureCapacity(int capacity) {
        if (this.bytes == null || this.bytes.length < capacity) {
            byte[] newbytes = new byte[capacity];
            if (this.bytes != null) {
                ByteArrayWrapper.copyBytes(this.bytes, 0, newbytes, 0, this.size);
            }
            this.bytes = newbytes;
        }
        return this;
    }

    private final ByteArrayWrapper $$robo$$android_icu_util_ByteArrayWrapper$set(byte[] src, int start, int limit) {
        this.size = 0;
        this.append(src, start, limit);
        return this;
    }

    private final ByteArrayWrapper $$robo$$android_icu_util_ByteArrayWrapper$append(byte[] src, int start, int limit) {
        int len = limit - start;
        this.ensureCapacity(this.size + len);
        ByteArrayWrapper.copyBytes(src, start, this.bytes, this.size, len);
        this.size += len;
        return this;
    }

    private final byte[] $$robo$$android_icu_util_ByteArrayWrapper$releaseBytes() {
        byte[] result = this.bytes;
        this.bytes = null;
        this.size = 0;
        return result;
    }

    private final String $$robo$$android_icu_util_ByteArrayWrapper$toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                result.append(" ");
            }
            result.append(Utility.hex(this.bytes[i] & 0xFF, 2));
        }
        return result.toString();
    }

    private final boolean $$robo$$android_icu_util_ByteArrayWrapper$equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            ByteArrayWrapper that = (ByteArrayWrapper)other;
            if (this.size != that.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.bytes[i] == that.bytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private final int $$robo$$android_icu_util_ByteArrayWrapper$hashCode() {
        int result = this.bytes.length;
        for (int i = 0; i < this.size; ++i) {
            result = 37 * result + this.bytes[i];
        }
        return result;
    }

    private final int $$robo$$android_icu_util_ByteArrayWrapper$compareTo(ByteArrayWrapper other) {
        if (this == other) {
            return 0;
        }
        int minSize = this.size < other.size ? this.size : other.size;
        for (int i = 0; i < minSize; ++i) {
            if (this.bytes[i] == other.bytes[i]) continue;
            return (this.bytes[i] & 0xFF) - (other.bytes[i] & 0xFF);
        }
        return this.size - other.size;
    }

    private static final void $$robo$$android_icu_util_ByteArrayWrapper$copyBytes(byte[] src, int srcoff, byte[] tgt, int tgtoff, int length) {
        if (length < 64) {
            int i = srcoff;
            int n = tgtoff;
            while (--length >= 0) {
                tgt[n] = src[i];
                ++i;
                ++n;
            }
        } else {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])src, (int)srcoff, (byte[])tgt, (int)tgtoff, (int)length);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_ByteArrayWrapper$__constructor__();
    }

    public ByteArrayWrapper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ByteArrayWrapper$__constructor__(), 0, this);
    }

    private void __constructor__(byte[] byArray, int n) {
        this.$$robo$$android_icu_util_ByteArrayWrapper$__constructor__(byArray, n);
    }

    public ByteArrayWrapper(byte[] byArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ByteArrayWrapper$__constructor__(byte[] int ), 0, this, byArray, n);
    }

    private void __constructor__(ByteBuffer byteBuffer) {
        this.$$robo$$android_icu_util_ByteArrayWrapper$__constructor__(byteBuffer);
    }

    public ByteArrayWrapper(ByteBuffer byteBuffer) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ByteArrayWrapper$__constructor__(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    public ByteArrayWrapper ensureCapacity(int n) {
        return InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_icu_util_ByteArrayWrapper$ensureCapacity(int ), 0, this, n);
    }

    public ByteArrayWrapper set(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_util_ByteArrayWrapper$set(byte[] int int ), 0, this, byArray, n, n2);
    }

    public ByteArrayWrapper append(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_util_ByteArrayWrapper$append(byte[] int int ), 0, this, byArray, n, n2);
    }

    public byte[] releaseBytes() {
        return InvokeDynamicSupport.bootstrap("releaseBytes", $$robo$$android_icu_util_ByteArrayWrapper$releaseBytes(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_ByteArrayWrapper$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_ByteArrayWrapper$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_ByteArrayWrapper$hashCode(), 0, this);
    }

    @Override
    public int compareTo(ByteArrayWrapper byteArrayWrapper) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_util_ByteArrayWrapper$compareTo(android.icu.util.ByteArrayWrapper ), 0, this, byteArrayWrapper);
    }

    private static void copyBytes(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("copyBytes", $$robo$$android_icu_util_ByteArrayWrapper$copyBytes(byte[] int byte[] int int ), 0, (byte[])byArray, (int)n, (byte[])byArray2, (int)n2, (int)n3);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteArrayWrapper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

