/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Utility;
import android.icu.text.Replaceable;
import android.icu.text.RuleBasedTransliterator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeReplacer;
import android.icu.text.UnicodeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StringReplacer
implements UnicodeReplacer,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String output;
    private int cursorPos;
    private boolean hasCursor;
    private boolean isComplex;
    private RuleBasedTransliterator.Data data;

    private void $$robo$$android_icu_text_StringReplacer$__constructor__(String theOutput, int theCursorPos, RuleBasedTransliterator.Data theData) {
        this.output = theOutput;
        this.cursorPos = theCursorPos;
        this.hasCursor = true;
        this.data = theData;
        this.isComplex = true;
    }

    private void $$robo$$android_icu_text_StringReplacer$__constructor__(String theOutput, RuleBasedTransliterator.Data theData) {
        this.output = theOutput;
        this.cursorPos = 0;
        this.hasCursor = false;
        this.data = theData;
        this.isComplex = true;
    }

    private final int $$robo$$android_icu_text_StringReplacer$replace(Replaceable text, int start, int limit, int[] cursor) {
        int outLen;
        int newStart = 0;
        if (!this.isComplex) {
            text.replace(start, limit, this.output);
            outLen = this.output.length();
            newStart = this.cursorPos;
        } else {
            int tempStart;
            StringBuffer buf = new StringBuffer();
            this.isComplex = false;
            int destStart = tempStart = text.length();
            if (start > 0) {
                int len = UTF16.getCharCount(text.char32At(start - 1));
                text.copy(start - len, start, tempStart);
                destStart += len;
            } else {
                text.replace(tempStart, tempStart, "\uffff");
                ++destStart;
            }
            int destLimit = destStart;
            int tempExtra = 0;
            int oOutput = 0;
            while (oOutput < this.output.length()) {
                UnicodeReplacer r;
                int c;
                int nextIndex;
                if (oOutput == this.cursorPos) {
                    newStart = buf.length() + destLimit - destStart;
                }
                if ((nextIndex = oOutput + UTF16.getCharCount(c = UTF16.charAt(this.output, oOutput))) == this.output.length()) {
                    tempExtra = UTF16.getCharCount(text.char32At(limit));
                    text.copy(limit, limit + tempExtra, destLimit);
                }
                if ((r = this.data.lookupReplacer(c)) == null) {
                    UTF16.append(buf, c);
                } else {
                    this.isComplex = true;
                    if (buf.length() > 0) {
                        text.replace(destLimit, destLimit, buf.toString());
                        destLimit += buf.length();
                        buf.setLength(0);
                    }
                    int len = r.replace(text, destLimit, destLimit, cursor);
                    destLimit += len;
                }
                oOutput = nextIndex;
            }
            if (buf.length() > 0) {
                text.replace(destLimit, destLimit, buf.toString());
                destLimit += buf.length();
            }
            if (oOutput == this.cursorPos) {
                newStart = destLimit - destStart;
            }
            outLen = destLimit - destStart;
            text.copy(destStart, destLimit, start);
            text.replace(tempStart + outLen, destLimit + tempExtra + outLen, "");
            text.replace(start + outLen, limit + outLen, "");
        }
        if (this.hasCursor) {
            if (this.cursorPos < 0) {
                int n;
                newStart = start;
                for (n = this.cursorPos; n < 0 && newStart > 0; newStart -= UTF16.getCharCount(text.char32At(newStart - 1)), ++n) {
                }
                newStart += n;
            } else if (this.cursorPos > this.output.length()) {
                int n;
                newStart = start + outLen;
                for (n = this.cursorPos - this.output.length(); n > 0 && newStart < text.length(); newStart += UTF16.getCharCount(text.char32At(newStart)), --n) {
                }
                newStart += n;
            } else {
                newStart += start;
            }
            cursor[0] = newStart;
        }
        return outLen;
    }

    private final String $$robo$$android_icu_text_StringReplacer$toReplacerPattern(boolean escapeUnprintable) {
        StringBuffer rule = new StringBuffer();
        StringBuffer quoteBuf = new StringBuffer();
        int cursor = this.cursorPos;
        if (this.hasCursor && cursor < 0) {
            while (cursor++ < 0) {
                Utility.appendToRule(rule, 64, true, escapeUnprintable, quoteBuf);
            }
        }
        for (int i = 0; i < this.output.length(); ++i) {
            char c;
            UnicodeReplacer r;
            if (this.hasCursor && i == cursor) {
                Utility.appendToRule(rule, 124, true, escapeUnprintable, quoteBuf);
            }
            if ((r = this.data.lookupReplacer(c = this.output.charAt(i))) == null) {
                Utility.appendToRule(rule, c, false, escapeUnprintable, quoteBuf);
                continue;
            }
            StringBuffer buf = new StringBuffer(" ");
            buf.append(r.toReplacerPattern(escapeUnprintable));
            buf.append(' ');
            Utility.appendToRule(rule, buf.toString(), true, escapeUnprintable, quoteBuf);
        }
        if (this.hasCursor && cursor > this.output.length()) {
            cursor -= this.output.length();
            while (cursor-- > 0) {
                Utility.appendToRule(rule, 64, true, escapeUnprintable, quoteBuf);
            }
            Utility.appendToRule(rule, 124, true, escapeUnprintable, quoteBuf);
        }
        Utility.appendToRule(rule, -1, true, escapeUnprintable, quoteBuf);
        return rule.toString();
    }

    private final void $$robo$$android_icu_text_StringReplacer$addReplacementSetTo(UnicodeSet toUnionTo) {
        int ch;
        for (int i = 0; i < this.output.length(); i += UTF16.getCharCount(ch)) {
            ch = UTF16.charAt(this.output, i);
            UnicodeReplacer r = this.data.lookupReplacer(ch);
            if (r == null) {
                toUnionTo.add(ch);
                continue;
            }
            r.addReplacementSetTo(toUnionTo);
        }
    }

    private void __constructor__(String string2, int n, RuleBasedTransliterator.Data data) {
        this.$$robo$$android_icu_text_StringReplacer$__constructor__(string2, n, data);
    }

    public StringReplacer(String string2, int n, RuleBasedTransliterator.Data data) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringReplacer$__constructor__(java.lang.String int android.icu.text.RuleBasedTransliterator$Data ), 0, this, string2, n, data);
    }

    private void __constructor__(String string2, RuleBasedTransliterator.Data data) {
        this.$$robo$$android_icu_text_StringReplacer$__constructor__(string2, data);
    }

    public StringReplacer(String string2, RuleBasedTransliterator.Data data) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringReplacer$__constructor__(java.lang.String android.icu.text.RuleBasedTransliterator$Data ), 0, this, string2, data);
    }

    @Override
    public int replace(Replaceable replaceable, int n, int n2, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("replace", $$robo$$android_icu_text_StringReplacer$replace(android.icu.text.Replaceable int int int[] ), 0, this, replaceable, n, n2, nArray);
    }

    @Override
    public String toReplacerPattern(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toReplacerPattern", $$robo$$android_icu_text_StringReplacer$toReplacerPattern(boolean ), 0, this, bl);
    }

    @Override
    public void addReplacementSetTo(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addReplacementSetTo", $$robo$$android_icu_text_StringReplacer$addReplacementSetTo(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public /* synthetic */ StringReplacer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringReplacer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

