/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Utility;
import android.icu.text.Replaceable;
import android.icu.text.RuleBasedTransliterator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeMatcher;
import android.icu.text.UnicodeReplacer;
import android.icu.text.UnicodeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StringMatcher
implements UnicodeMatcher,
UnicodeReplacer,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String pattern;
    private int matchStart;
    private int matchLimit;
    private int segmentNumber;
    private RuleBasedTransliterator.Data data;

    private void $$robo$$android_icu_text_StringMatcher$__constructor__(String theString, int segmentNum, RuleBasedTransliterator.Data theData) {
        this.data = theData;
        this.pattern = theString;
        this.matchLimit = -1;
        this.matchStart = -1;
        this.segmentNumber = segmentNum;
    }

    private void $$robo$$android_icu_text_StringMatcher$__constructor__(String theString, int start, int limit, int segmentNum, RuleBasedTransliterator.Data theData) {
    }

    private final int $$robo$$android_icu_text_StringMatcher$matches(Replaceable text, int[] offset, int limit, boolean incremental) {
        int[] cursor = new int[]{offset[0]};
        if (limit < cursor[0]) {
            for (int i = this.pattern.length() - 1; i >= 0; --i) {
                char keyChar = this.pattern.charAt(i);
                UnicodeMatcher subm = this.data.lookupMatcher(keyChar);
                if (subm == null) {
                    if (cursor[0] > limit && keyChar == text.charAt(cursor[0])) {
                        cursor[0] = cursor[0] - 1;
                        continue;
                    }
                    return 0;
                }
                int m = subm.matches(text, cursor, limit, incremental);
                if (m == 2) continue;
                return m;
            }
            if (this.matchStart < 0) {
                this.matchStart = cursor[0] + 1;
                this.matchLimit = offset[0] + 1;
            }
        } else {
            for (int i = 0; i < this.pattern.length(); ++i) {
                if (incremental && cursor[0] == limit) {
                    return 1;
                }
                char keyChar = this.pattern.charAt(i);
                UnicodeMatcher subm = this.data.lookupMatcher(keyChar);
                if (subm == null) {
                    if (cursor[0] < limit && keyChar == text.charAt(cursor[0])) {
                        cursor[0] = cursor[0] + 1;
                        continue;
                    }
                    return 0;
                }
                int m = subm.matches(text, cursor, limit, incremental);
                if (m == 2) continue;
                return m;
            }
            this.matchStart = offset[0];
            this.matchLimit = cursor[0];
        }
        offset[0] = cursor[0];
        return 2;
    }

    private final String $$robo$$android_icu_text_StringMatcher$toPattern(boolean escapeUnprintable) {
        StringBuffer result = new StringBuffer();
        StringBuffer quoteBuf = new StringBuffer();
        if (this.segmentNumber > 0) {
            result.append('(');
        }
        for (int i = 0; i < this.pattern.length(); ++i) {
            char keyChar = this.pattern.charAt(i);
            UnicodeMatcher m = this.data.lookupMatcher(keyChar);
            if (m == null) {
                Utility.appendToRule(result, keyChar, false, escapeUnprintable, quoteBuf);
                continue;
            }
            Utility.appendToRule(result, m.toPattern(escapeUnprintable), true, escapeUnprintable, quoteBuf);
        }
        if (this.segmentNumber > 0) {
            result.append(')');
        }
        Utility.appendToRule(result, -1, true, escapeUnprintable, quoteBuf);
        return result.toString();
    }

    private final boolean $$robo$$android_icu_text_StringMatcher$matchesIndexValue(int v) {
        if (this.pattern.length() == 0) {
            return true;
        }
        int c = UTF16.charAt(this.pattern, 0);
        UnicodeMatcher m = this.data.lookupMatcher(c);
        return m == null ? (c & 0xFF) == v : m.matchesIndexValue(v);
    }

    private final void $$robo$$android_icu_text_StringMatcher$addMatchSetTo(UnicodeSet toUnionTo) {
        int ch;
        for (int i = 0; i < this.pattern.length(); i += UTF16.getCharCount(ch)) {
            ch = UTF16.charAt(this.pattern, i);
            UnicodeMatcher matcher = this.data.lookupMatcher(ch);
            if (matcher == null) {
                toUnionTo.add(ch);
                continue;
            }
            matcher.addMatchSetTo(toUnionTo);
        }
    }

    private final int $$robo$$android_icu_text_StringMatcher$replace(Replaceable text, int start, int limit, int[] cursor) {
        int outLen = 0;
        int dest = limit;
        if (this.matchStart >= 0 && this.matchStart != this.matchLimit) {
            text.copy(this.matchStart, this.matchLimit, dest);
            outLen = this.matchLimit - this.matchStart;
        }
        text.replace(start, limit, "");
        return outLen;
    }

    private final String $$robo$$android_icu_text_StringMatcher$toReplacerPattern(boolean escapeUnprintable) {
        StringBuffer rule = new StringBuffer("$");
        Utility.appendNumber(rule, this.segmentNumber, 10, 1);
        return rule.toString();
    }

    private final void $$robo$$android_icu_text_StringMatcher$resetMatch() {
        this.matchLimit = -1;
        this.matchStart = -1;
    }

    private final void $$robo$$android_icu_text_StringMatcher$addReplacementSetTo(UnicodeSet toUnionTo) {
    }

    private void __constructor__(String string2, int n, RuleBasedTransliterator.Data data) {
        this.$$robo$$android_icu_text_StringMatcher$__constructor__(string2, n, data);
    }

    public StringMatcher(String string2, int n, RuleBasedTransliterator.Data data) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringMatcher$__constructor__(java.lang.String int android.icu.text.RuleBasedTransliterator$Data ), 0, this, string2, n, data);
    }

    private void __constructor__(String string2, int n, int n2, int n3, RuleBasedTransliterator.Data data) {
        this.$$robo$$android_icu_text_StringMatcher$__constructor__(string2, n, n2, n3, data);
    }

    public StringMatcher(String string2, int n, int n2, int n3, RuleBasedTransliterator.Data data) {
        this(string2.substring(n, n2), n3, data);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringMatcher$__constructor__(java.lang.String int int int android.icu.text.RuleBasedTransliterator$Data ), 0, this, string2, n, n2, n3, data);
    }

    @Override
    public int matches(Replaceable replaceable, int[] nArray, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_StringMatcher$matches(android.icu.text.Replaceable int[] int boolean ), 0, this, replaceable, nArray, n, bl);
    }

    @Override
    public String toPattern(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toPattern", $$robo$$android_icu_text_StringMatcher$toPattern(boolean ), 0, this, bl);
    }

    @Override
    public boolean matchesIndexValue(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesIndexValue", $$robo$$android_icu_text_StringMatcher$matchesIndexValue(int ), 0, this, n);
    }

    @Override
    public void addMatchSetTo(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addMatchSetTo", $$robo$$android_icu_text_StringMatcher$addMatchSetTo(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    @Override
    public int replace(Replaceable replaceable, int n, int n2, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("replace", $$robo$$android_icu_text_StringMatcher$replace(android.icu.text.Replaceable int int int[] ), 0, this, replaceable, n, n2, nArray);
    }

    @Override
    public String toReplacerPattern(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toReplacerPattern", $$robo$$android_icu_text_StringMatcher$toReplacerPattern(boolean ), 0, this, bl);
    }

    public void resetMatch() {
        InvokeDynamicSupport.bootstrap("resetMatch", $$robo$$android_icu_text_StringMatcher$resetMatch(), 0, this);
    }

    @Override
    public void addReplacementSetTo(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addReplacementSetTo", $$robo$$android_icu_text_StringMatcher$addReplacementSetTo(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public /* synthetic */ StringMatcher() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringMatcher)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

