/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ClassLoaderUtil;
import android.icu.impl.Normalizer2Impl;
import android.icu.impl.Utility;
import android.icu.impl.coll.BOCSU;
import android.icu.impl.coll.CollationCompare;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationFastLatin;
import android.icu.impl.coll.CollationKeys;
import android.icu.impl.coll.CollationLoader;
import android.icu.impl.coll.CollationRoot;
import android.icu.impl.coll.CollationSettings;
import android.icu.impl.coll.CollationTailoring;
import android.icu.impl.coll.ContractionsAndExpansions;
import android.icu.impl.coll.FCDUTF16CollationIterator;
import android.icu.impl.coll.SharedObject;
import android.icu.impl.coll.TailoredSet;
import android.icu.impl.coll.UTF16CollationIterator;
import android.icu.text.CollationElementIterator;
import android.icu.text.CollationKey;
import android.icu.text.Collator;
import android.icu.text.RawCollationKey;
import android.icu.text.UCharacterIterator;
import android.icu.text.UnicodeSet;
import android.icu.text.UnicodeSetIterator;
import android.icu.util.ULocale;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RuleBasedCollator
extends Collator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Lock frozenLock;
    private CollationBuffer collationBuffer;
    CollationData data;
    SharedObject.Reference<CollationSettings> settings;
    CollationTailoring tailoring;
    private ULocale validLocale;
    private boolean actualLocaleIsSameAsValid;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_RuleBasedCollator$__constructor__(String rules) throws Exception {
        if (rules == null) {
            throw new IllegalArgumentException("Collation rules can not be null");
        }
        this.validLocale = ULocale.ROOT;
        this.internalBuildTailoring(rules);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$internalBuildTailoring(String rules) throws Exception {
        CollationTailoring t;
        CollationTailoring base = CollationRoot.getRoot();
        ClassLoader classLoader = ClassLoaderUtil.getClassLoader(this.getClass());
        try {
            Class<?> builderClass = classLoader.loadClass("android.icu.impl.coll.CollationBuilder");
            Object builder = builderClass.getConstructor(CollationTailoring.class).newInstance(base);
            Method parseAndBuild = builderClass.getMethod("parseAndBuild", String.class);
            t = (CollationTailoring)parseAndBuild.invoke(builder, rules);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        t.actualLocale = null;
        this.adoptTailoring(t);
    }

    private final Object $$robo$$android_icu_text_RuleBasedCollator$clone() throws CloneNotSupportedException {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_icu_text_RuleBasedCollator$initMaxExpansions() {
        CollationTailoring collationTailoring = this.tailoring;
        synchronized (collationTailoring) {
            if (this.tailoring.maxExpansions == null) {
                this.tailoring.maxExpansions = CollationElementIterator.computeMaxExpansions(this.tailoring.data);
            }
        }
    }

    private final CollationElementIterator $$robo$$android_icu_text_RuleBasedCollator$getCollationElementIterator(String source) {
        this.initMaxExpansions();
        return new CollationElementIterator(source, this);
    }

    private final CollationElementIterator $$robo$$android_icu_text_RuleBasedCollator$getCollationElementIterator(CharacterIterator source) {
        this.initMaxExpansions();
        CharacterIterator newsource = (CharacterIterator)source.clone();
        return new CollationElementIterator(newsource, this);
    }

    private final CollationElementIterator $$robo$$android_icu_text_RuleBasedCollator$getCollationElementIterator(UCharacterIterator source) {
        this.initMaxExpansions();
        return new CollationElementIterator(source, this);
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isFrozen() {
        return this.frozenLock != null;
    }

    private final Collator $$robo$$android_icu_text_RuleBasedCollator$freeze() {
        if (!this.isFrozen()) {
            this.frozenLock = new ReentrantLock();
            if (this.collationBuffer == null) {
                this.collationBuffer = new CollationBuffer(this.data);
            }
        }
        return this;
    }

    private final RuleBasedCollator $$robo$$android_icu_text_RuleBasedCollator$cloneAsThawed() {
        try {
            RuleBasedCollator result = (RuleBasedCollator)super.clone();
            result.settings = this.settings.clone();
            result.collationBuffer = null;
            result.frozenLock = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$checkNotFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen RuleBasedCollator");
        }
    }

    private final CollationSettings $$robo$$android_icu_text_RuleBasedCollator$getOwnedSettings() {
        return this.settings.copyOnWrite();
    }

    private final CollationSettings $$robo$$android_icu_text_RuleBasedCollator$getDefaultSettings() {
        return this.tailoring.settings.readOnly();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_RuleBasedCollator$setHiraganaQuaternary(boolean flag) {
        this.checkNotFrozen();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_RuleBasedCollator$setHiraganaQuaternaryDefault() {
        this.checkNotFrozen();
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setUpperCaseFirst(boolean upperfirst) {
        this.checkNotFrozen();
        if (upperfirst == this.isUpperCaseFirst()) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setCaseFirst(upperfirst ? 768 : 0);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setLowerCaseFirst(boolean lowerfirst) {
        this.checkNotFrozen();
        if (lowerfirst == this.isLowerCaseFirst()) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setCaseFirst(lowerfirst ? 512 : 0);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setCaseFirstDefault() {
        this.checkNotFrozen();
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setCaseFirstDefault(defaultSettings.options);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setAlternateHandlingDefault() {
        this.checkNotFrozen();
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setAlternateHandlingDefault(defaultSettings.options);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setCaseLevelDefault() {
        this.checkNotFrozen();
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlagDefault(1024, defaultSettings.options);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setDecompositionDefault() {
        this.checkNotFrozen();
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlagDefault(1, defaultSettings.options);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setFrenchCollationDefault() {
        this.checkNotFrozen();
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlagDefault(2048, defaultSettings.options);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setStrengthDefault() {
        this.checkNotFrozen();
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setStrengthDefault(defaultSettings.options);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setNumericCollationDefault() {
        this.checkNotFrozen();
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlagDefault(2, defaultSettings.options);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setFrenchCollation(boolean flag) {
        this.checkNotFrozen();
        if (flag == this.isFrenchCollation()) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlag(2048, flag);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setAlternateHandlingShifted(boolean shifted) {
        this.checkNotFrozen();
        if (shifted == this.isAlternateHandlingShifted()) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setAlternateHandlingShifted(shifted);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setCaseLevel(boolean flag) {
        this.checkNotFrozen();
        if (flag == this.isCaseLevel()) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlag(1024, flag);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setDecomposition(int decomposition) {
        boolean flag;
        this.checkNotFrozen();
        switch (decomposition) {
            case 16: {
                flag = false;
                break;
            }
            case 17: {
                flag = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong decomposition mode.");
            }
        }
        if (flag == this.settings.readOnly().getFlag(1)) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlag(1, flag);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setStrength(int newStrength) {
        this.checkNotFrozen();
        if (newStrength == this.getStrength()) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setStrength(newStrength);
        this.setFastLatinOptions(ownedSettings);
    }

    private final RuleBasedCollator $$robo$$android_icu_text_RuleBasedCollator$setMaxVariable(int group) {
        int value;
        if (group == -1) {
            value = -1;
        } else if (4096 <= group && group <= 4099) {
            value = group - 4096;
        } else {
            throw new IllegalArgumentException("illegal max variable group " + group);
        }
        int oldValue = this.settings.readOnly().getMaxVariable();
        if (value == oldValue) {
            return this;
        }
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (this.settings.readOnly() == defaultSettings && value < 0) {
            return this;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        if (group == -1) {
            group = 4096 + defaultSettings.getMaxVariable();
        }
        long varTop = this.data.getLastPrimaryForGroup(group);
        if (!$assertionsDisabled && varTop == 0L) {
            throw new AssertionError();
        }
        ownedSettings.setMaxVariable(value, defaultSettings.options);
        ownedSettings.variableTop = varTop;
        this.setFastLatinOptions(ownedSettings);
        return this;
    }

    private final int $$robo$$android_icu_text_RuleBasedCollator$getMaxVariable() {
        return 4096 + this.settings.readOnly().getMaxVariable();
    }

    @Deprecated
    private final int $$robo$$android_icu_text_RuleBasedCollator$setVariableTop(String varTop) {
        long ce2;
        long ce1;
        this.checkNotFrozen();
        if (varTop == null || varTop.length() == 0) {
            throw new IllegalArgumentException("Variable top argument string can not be null or zero in length.");
        }
        boolean numeric = this.settings.readOnly().isNumeric();
        if (this.settings.readOnly().dontCheckFCD()) {
            UTF16CollationIterator ci = new UTF16CollationIterator(this.data, numeric, varTop, 0);
            ce1 = ci.nextCE();
            ce2 = ci.nextCE();
        } else {
            FCDUTF16CollationIterator ci = new FCDUTF16CollationIterator(this.data, numeric, varTop, 0);
            ce1 = ci.nextCE();
            ce2 = ci.nextCE();
        }
        if (ce1 == 0x101000100L || ce2 != 0x101000100L) {
            throw new IllegalArgumentException("Variable top argument string must map to exactly one collation element");
        }
        this.internalSetVariableTop(ce1 >>> 32);
        return (int)this.settings.readOnly().variableTop;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_RuleBasedCollator$setVariableTop(int varTop) {
        this.checkNotFrozen();
        this.internalSetVariableTop((long)varTop & 0xFFFFFFFFL);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$internalSetVariableTop(long varTop) {
        if (varTop != this.settings.readOnly().variableTop) {
            int group = this.data.getGroupForPrimary(varTop);
            if (group < 4096 || 4099 < group) {
                throw new IllegalArgumentException("The variable top must be a primary weight in the space/punctuation/symbols/currency symbols range");
            }
            long v = this.data.getLastPrimaryForGroup(group);
            if (!($assertionsDisabled || v != 0L && v >= varTop)) {
                throw new AssertionError();
            }
            varTop = v;
            if (varTop != this.settings.readOnly().variableTop) {
                CollationSettings ownedSettings = this.getOwnedSettings();
                ownedSettings.setMaxVariable(group - 4096, this.getDefaultSettings().options);
                ownedSettings.variableTop = varTop;
                this.setFastLatinOptions(ownedSettings);
            }
        }
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setNumericCollation(boolean flag) {
        this.checkNotFrozen();
        if (flag == this.getNumericCollation()) {
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        ownedSettings.setFlag(2, flag);
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setReorderCodes(int ... order) {
        int length;
        this.checkNotFrozen();
        int n = length = order != null ? order.length : 0;
        if (length == 1 && order[0] == 103) {
            length = 0;
        }
        if (length == 0 ? this.settings.readOnly().reorderCodes.length == 0 : Arrays.equals(order, this.settings.readOnly().reorderCodes)) {
            return;
        }
        CollationSettings defaultSettings = this.getDefaultSettings();
        if (length == 1 && order[0] == -1) {
            if (this.settings.readOnly() != defaultSettings) {
                CollationSettings ownedSettings = this.getOwnedSettings();
                ownedSettings.copyReorderingFrom(defaultSettings);
                this.setFastLatinOptions(ownedSettings);
            }
            return;
        }
        CollationSettings ownedSettings = this.getOwnedSettings();
        if (length == 0) {
            ownedSettings.resetReordering();
        } else {
            ownedSettings.setReordering(this.data, (int[])order.clone());
        }
        this.setFastLatinOptions(ownedSettings);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setFastLatinOptions(CollationSettings ownedSettings) {
        ownedSettings.fastLatinOptions = CollationFastLatin.getOptions(this.data, ownedSettings, ownedSettings.fastLatinPrimaries);
    }

    private final String $$robo$$android_icu_text_RuleBasedCollator$getRules() {
        return this.tailoring.getRules();
    }

    private final String $$robo$$android_icu_text_RuleBasedCollator$getRules(boolean fullrules) {
        if (!fullrules) {
            return this.tailoring.getRules();
        }
        return CollationLoader.getRootRules() + this.tailoring.getRules();
    }

    private final UnicodeSet $$robo$$android_icu_text_RuleBasedCollator$getTailoredSet() {
        UnicodeSet tailored = new UnicodeSet();
        if (this.data.base != null) {
            new TailoredSet(tailored).forData(this.data);
        }
        return tailored;
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$getContractionsAndExpansions(UnicodeSet contractions, UnicodeSet expansions, boolean addPrefixes) throws Exception {
        if (contractions != null) {
            contractions.clear();
        }
        if (expansions != null) {
            expansions.clear();
        }
        new ContractionsAndExpansions(contractions, expansions, null, addPrefixes).forData(this.data);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$internalAddContractions(int c, UnicodeSet set) {
        new ContractionsAndExpansions(set, null, null, false).forCodePoint(this.data, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CollationKey $$robo$$android_icu_text_RuleBasedCollator$getCollationKey(String source) {
        if (source == null) {
            return null;
        }
        CollationBuffer buffer = null;
        try {
            buffer = this.getCollationBuffer();
            CollationKey collationKey = this.getCollationKey(source, buffer);
            return collationKey;
        }
        finally {
            this.releaseCollationBuffer(buffer);
        }
    }

    private final CollationKey $$robo$$android_icu_text_RuleBasedCollator$getCollationKey(String source, CollationBuffer buffer) {
        buffer.rawCollationKey = this.getRawCollationKey(source, buffer.rawCollationKey, buffer);
        return new CollationKey(source, buffer.rawCollationKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RawCollationKey $$robo$$android_icu_text_RuleBasedCollator$getRawCollationKey(String source, RawCollationKey key) {
        if (source == null) {
            return null;
        }
        CollationBuffer buffer = null;
        try {
            buffer = this.getCollationBuffer();
            RawCollationKey rawCollationKey = this.getRawCollationKey(source, key, buffer);
            return rawCollationKey;
        }
        finally {
            this.releaseCollationBuffer(buffer);
        }
    }

    private final RawCollationKey $$robo$$android_icu_text_RuleBasedCollator$getRawCollationKey(CharSequence source, RawCollationKey key, CollationBuffer buffer) {
        if (key == null) {
            key = new RawCollationKey(this.simpleKeyLengthEstimate(source));
        } else if (key.bytes == null) {
            key.bytes = new byte[this.simpleKeyLengthEstimate(source)];
        }
        CollationKeyByteSink sink = new CollationKeyByteSink(key);
        this.writeSortKey(source, sink, buffer);
        key.size = sink.NumberOfBytesAppended();
        return key;
    }

    private final int $$robo$$android_icu_text_RuleBasedCollator$simpleKeyLengthEstimate(CharSequence source) {
        return 2 * source.length() + 10;
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$writeSortKey(CharSequence s, CollationKeyByteSink sink, CollationBuffer buffer) {
        boolean numeric = this.settings.readOnly().isNumeric();
        if (this.settings.readOnly().dontCheckFCD()) {
            buffer.leftUTF16CollIter.setText(numeric, s, 0);
            CollationKeys.writeSortKeyUpToQuaternary(buffer.leftUTF16CollIter, this.data.compressibleBytes, this.settings.readOnly(), sink, 1, CollationKeys.SIMPLE_LEVEL_FALLBACK, true);
        } else {
            buffer.leftFCDUTF16Iter.setText(numeric, s, 0);
            CollationKeys.writeSortKeyUpToQuaternary(buffer.leftFCDUTF16Iter, this.data.compressibleBytes, this.settings.readOnly(), sink, 1, CollationKeys.SIMPLE_LEVEL_FALLBACK, true);
        }
        if (this.settings.readOnly().getStrength() == 15) {
            this.writeIdenticalLevel(s, sink);
        }
        sink.Append(0);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$writeIdenticalLevel(CharSequence s, CollationKeyByteSink sink) {
        int nfdQCYesLimit = this.data.nfcImpl.decompose(s, 0, s.length(), null);
        sink.Append(1);
        ((CollationKeyByteSink)sink).key_.size = sink.NumberOfBytesAppended();
        int prev = 0;
        if (nfdQCYesLimit != 0) {
            prev = BOCSU.writeIdenticalLevelRun(prev, s, 0, nfdQCYesLimit, sink.key_);
        }
        if (nfdQCYesLimit < s.length()) {
            int destLengthEstimate = s.length() - nfdQCYesLimit;
            StringBuilder nfd = new StringBuilder();
            this.data.nfcImpl.decompose(s, nfdQCYesLimit, s.length(), nfd, destLengthEstimate);
            BOCSU.writeIdenticalLevelRun(prev, nfd, 0, nfd.length(), sink.key_);
        }
        sink.setBufferAndAppended(((CollationKeyByteSink)sink).key_.bytes, ((CollationKeyByteSink)sink).key_.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final long[] $$robo$$android_icu_text_RuleBasedCollator$internalGetCEs(CharSequence str) {
        CollationBuffer buffer = null;
        try {
            UTF16CollationIterator iter;
            buffer = this.getCollationBuffer();
            boolean numeric = this.settings.readOnly().isNumeric();
            if (this.settings.readOnly().dontCheckFCD()) {
                buffer.leftUTF16CollIter.setText(numeric, str, 0);
                iter = buffer.leftUTF16CollIter;
            } else {
                buffer.leftFCDUTF16Iter.setText(numeric, str, 0);
                iter = buffer.leftFCDUTF16Iter;
            }
            int length = iter.fetchCEs() - 1;
            if (!($assertionsDisabled || length >= 0 && iter.getCE(length) == 0x101000100L)) {
                throw new AssertionError();
            }
            long[] ces = new long[length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])iter.getCEs(), (int)0, (long[])ces, (int)0, (int)length);
            long[] lArray = ces;
            return lArray;
        }
        finally {
            this.releaseCollationBuffer(buffer);
        }
    }

    private final int $$robo$$android_icu_text_RuleBasedCollator$getStrength() {
        return this.settings.readOnly().getStrength();
    }

    private final int $$robo$$android_icu_text_RuleBasedCollator$getDecomposition() {
        return (this.settings.readOnly().options & 1) != 0 ? 17 : 16;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isUpperCaseFirst() {
        return this.settings.readOnly().getCaseFirst() == 768;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isLowerCaseFirst() {
        return this.settings.readOnly().getCaseFirst() == 512;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isAlternateHandlingShifted() {
        return this.settings.readOnly().getAlternateHandling();
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isCaseLevel() {
        return (this.settings.readOnly().options & 0x400) != 0;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isFrenchCollation() {
        return (this.settings.readOnly().options & 0x800) != 0;
    }

    @Deprecated
    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isHiraganaQuaternary() {
        return false;
    }

    private final int $$robo$$android_icu_text_RuleBasedCollator$getVariableTop() {
        return (int)this.settings.readOnly().variableTop;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$getNumericCollation() {
        return (this.settings.readOnly().options & 2) != 0;
    }

    private final int[] $$robo$$android_icu_text_RuleBasedCollator$getReorderCodes() {
        return (int[])this.settings.readOnly().reorderCodes.clone();
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$equals(Object obj) {
        UnicodeSet otherTailored;
        boolean otherIsRoot;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RuleBasedCollator o = (RuleBasedCollator)obj;
        if (!this.settings.readOnly().equals(o.settings.readOnly())) {
            return false;
        }
        if (this.data == o.data) {
            return true;
        }
        boolean thisIsRoot = this.data.base == null;
        boolean bl = otherIsRoot = o.data.base == null;
        if (!$assertionsDisabled && thisIsRoot && otherIsRoot) {
            throw new AssertionError();
        }
        if (thisIsRoot != otherIsRoot) {
            return false;
        }
        String theseRules = this.tailoring.getRules();
        String otherRules = o.tailoring.getRules();
        if ((thisIsRoot || theseRules.length() != 0) && (otherIsRoot || otherRules.length() != 0) && theseRules.equals(otherRules)) {
            return true;
        }
        UnicodeSet thisTailored = this.getTailoredSet();
        return thisTailored.equals(otherTailored = o.getTailoredSet());
    }

    private final int $$robo$$android_icu_text_RuleBasedCollator$hashCode() {
        int h = this.settings.readOnly().hashCode();
        if (this.data.base == null) {
            return h;
        }
        UnicodeSet set = this.getTailoredSet();
        UnicodeSetIterator iter = new UnicodeSetIterator(set);
        while (iter.next() && iter.codepoint != UnicodeSetIterator.IS_STRING) {
            h ^= this.data.getCE32(iter.codepoint);
        }
        return h;
    }

    private final int $$robo$$android_icu_text_RuleBasedCollator$compare(String source, String target) {
        return this.doCompare(source, target);
    }

    private static final int $$robo$$android_icu_text_RuleBasedCollator$compareNFDIter(Normalizer2Impl nfcImpl, NFDIterator left, NFDIterator right) {
        block3: {
            while (true) {
                int rightCp;
                int leftCp;
                if ((leftCp = left.nextCodePoint()) == (rightCp = right.nextCodePoint())) {
                    if (leftCp >= 0) continue;
                    break block3;
                }
                if ((leftCp = leftCp < 0 ? -2 : (leftCp == 65534 ? -1 : left.nextDecomposedCodePoint(nfcImpl, leftCp))) < (rightCp = rightCp < 0 ? -2 : (rightCp == 65534 ? -1 : right.nextDecomposedCodePoint(nfcImpl, rightCp)))) {
                    return -1;
                }
                if (leftCp > rightCp) break;
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final int $$robo$$android_icu_text_RuleBasedCollator$doCompare(CharSequence left, CharSequence right) {
        CollationBuffer buffer;
        int fastLatinOptions;
        int result;
        if (left == right) {
            return 0;
        }
        int equalPrefixLength = 0;
        while (true) {
            if (equalPrefixLength == left.length()) {
                if (equalPrefixLength != right.length()) break;
                return 0;
            }
            if (equalPrefixLength == right.length() || left.charAt(equalPrefixLength) != right.charAt(equalPrefixLength)) break;
            ++equalPrefixLength;
        }
        CollationSettings roSettings = this.settings.readOnly();
        boolean numeric = roSettings.isNumeric();
        if (equalPrefixLength > 0 && (equalPrefixLength != left.length() && this.data.isUnsafeBackward(left.charAt(equalPrefixLength), numeric) || equalPrefixLength != right.length() && this.data.isUnsafeBackward(right.charAt(equalPrefixLength), numeric))) {
            while (--equalPrefixLength > 0 && this.data.isUnsafeBackward(left.charAt(equalPrefixLength), numeric)) {
            }
        }
        if ((result = !((fastLatinOptions = roSettings.fastLatinOptions) < 0 || equalPrefixLength != left.length() && left.charAt(equalPrefixLength) > '\u017f' || equalPrefixLength != right.length() && right.charAt(equalPrefixLength) > '\u017f') ? CollationFastLatin.compareUTF16(this.data.fastLatinTable, roSettings.fastLatinPrimaries, fastLatinOptions, left, right, equalPrefixLength) : -2) == -2) {
            buffer = null;
            try {
                buffer = this.getCollationBuffer();
                if (roSettings.dontCheckFCD()) {
                    buffer.leftUTF16CollIter.setText(numeric, left, equalPrefixLength);
                    buffer.rightUTF16CollIter.setText(numeric, right, equalPrefixLength);
                    result = CollationCompare.compareUpToQuaternary(buffer.leftUTF16CollIter, buffer.rightUTF16CollIter, roSettings);
                } else {
                    buffer.leftFCDUTF16Iter.setText(numeric, left, equalPrefixLength);
                    buffer.rightFCDUTF16Iter.setText(numeric, right, equalPrefixLength);
                    result = CollationCompare.compareUpToQuaternary(buffer.leftFCDUTF16Iter, buffer.rightFCDUTF16Iter, roSettings);
                }
            }
            finally {
                this.releaseCollationBuffer(buffer);
            }
        }
        if (result != 0 || roSettings.getStrength() < 15) {
            return result;
        }
        buffer = null;
        try {
            buffer = this.getCollationBuffer();
            Normalizer2Impl nfcImpl = this.data.nfcImpl;
            if (roSettings.dontCheckFCD()) {
                buffer.leftUTF16NFDIter.setText(left, equalPrefixLength);
                buffer.rightUTF16NFDIter.setText(right, equalPrefixLength);
                int n = RuleBasedCollator.compareNFDIter(nfcImpl, buffer.leftUTF16NFDIter, buffer.rightUTF16NFDIter);
                return n;
            }
            buffer.leftFCDUTF16NFDIter.setText(nfcImpl, left, equalPrefixLength);
            buffer.rightFCDUTF16NFDIter.setText(nfcImpl, right, equalPrefixLength);
            int n = RuleBasedCollator.compareNFDIter(nfcImpl, buffer.leftFCDUTF16NFDIter, buffer.rightFCDUTF16NFDIter);
            return n;
        }
        finally {
            this.releaseCollationBuffer(buffer);
        }
    }

    private void $$robo$$android_icu_text_RuleBasedCollator$__constructor__(CollationTailoring t, ULocale vl) {
        this.data = t.data;
        this.settings = t.settings.clone();
        this.tailoring = t;
        this.validLocale = vl;
        this.actualLocaleIsSameAsValid = false;
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$adoptTailoring(CollationTailoring t) {
        if (!($assertionsDisabled || this.settings == null && this.data == null && this.tailoring == null)) {
            throw new AssertionError();
        }
        this.data = t.data;
        this.settings = t.settings.clone();
        this.tailoring = t;
        this.validLocale = t.actualLocale;
        this.actualLocaleIsSameAsValid = false;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedCollator$isUnsafe(int c) {
        return this.data.isUnsafeBackward(c, this.settings.readOnly().isNumeric());
    }

    private final VersionInfo $$robo$$android_icu_text_RuleBasedCollator$getVersion() {
        int version = this.tailoring.version;
        int rtVersion = VersionInfo.UCOL_RUNTIME_VERSION.getMajor();
        return VersionInfo.getInstance((version >>> 24) + (rtVersion << 4) + (rtVersion >> 4), version >> 16 & 0xFF, version >> 8 & 0xFF, version & 0xFF);
    }

    private final VersionInfo $$robo$$android_icu_text_RuleBasedCollator$getUCAVersion() {
        VersionInfo v = this.getVersion();
        return VersionInfo.getInstance(v.getMinor() >> 3, v.getMinor() & 7, v.getMilli() >> 6, 0);
    }

    private final CollationBuffer $$robo$$android_icu_text_RuleBasedCollator$getCollationBuffer() {
        if (this.isFrozen()) {
            this.frozenLock.lock();
        } else if (this.collationBuffer == null) {
            this.collationBuffer = new CollationBuffer(this.data);
        }
        return this.collationBuffer;
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$releaseCollationBuffer(CollationBuffer buffer) {
        if (this.isFrozen()) {
            this.frozenLock.unlock();
        }
    }

    private final ULocale $$robo$$android_icu_text_RuleBasedCollator$getLocale(ULocale.Type type) {
        if (type == ULocale.ACTUAL_LOCALE) {
            return this.actualLocaleIsSameAsValid ? this.validLocale : this.tailoring.actualLocale;
        }
        if (type == ULocale.VALID_LOCALE) {
            return this.validLocale;
        }
        throw new IllegalArgumentException("unknown ULocale.Type " + type);
    }

    private final void $$robo$$android_icu_text_RuleBasedCollator$setLocale(ULocale valid, ULocale actual) {
        if (!$assertionsDisabled && valid == null != (actual == null)) {
            throw new AssertionError();
        }
        if (Utility.objectEquals(actual, this.tailoring.actualLocale)) {
            this.actualLocaleIsSameAsValid = false;
        } else {
            if (!$assertionsDisabled && !Utility.objectEquals(actual, valid)) {
                throw new AssertionError();
            }
            this.actualLocaleIsSameAsValid = true;
        }
        this.validLocale = valid;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !RuleBasedCollator.class.desiredAssertionStatus();
    }

    private void __constructor__(String string2) throws Exception {
        this.$$robo$$android_icu_text_RuleBasedCollator$__constructor__(string2);
    }

    public RuleBasedCollator(String string2) throws Exception {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedCollator$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void internalBuildTailoring(String string2) throws Exception {
        InvokeDynamicSupport.bootstrap("internalBuildTailoring", $$robo$$android_icu_text_RuleBasedCollator$internalBuildTailoring(java.lang.String ), 0, this, string2);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_RuleBasedCollator$clone(), 0, this);
    }

    private void initMaxExpansions() {
        InvokeDynamicSupport.bootstrap("initMaxExpansions", $$robo$$android_icu_text_RuleBasedCollator$initMaxExpansions(), 0, this);
    }

    public CollationElementIterator getCollationElementIterator(String string2) {
        return InvokeDynamicSupport.bootstrap("getCollationElementIterator", $$robo$$android_icu_text_RuleBasedCollator$getCollationElementIterator(java.lang.String ), 0, this, string2);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator characterIterator) {
        return InvokeDynamicSupport.bootstrap("getCollationElementIterator", $$robo$$android_icu_text_RuleBasedCollator$getCollationElementIterator(java.text.CharacterIterator ), 0, this, characterIterator);
    }

    public CollationElementIterator getCollationElementIterator(UCharacterIterator uCharacterIterator) {
        return InvokeDynamicSupport.bootstrap("getCollationElementIterator", $$robo$$android_icu_text_RuleBasedCollator$getCollationElementIterator(android.icu.text.UCharacterIterator ), 0, this, uCharacterIterator);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_text_RuleBasedCollator$isFrozen(), 0, this);
    }

    @Override
    public Collator freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_RuleBasedCollator$freeze(), 0, this);
    }

    @Override
    public RuleBasedCollator cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_text_RuleBasedCollator$cloneAsThawed(), 0, this);
    }

    private void checkNotFrozen() {
        InvokeDynamicSupport.bootstrap("checkNotFrozen", $$robo$$android_icu_text_RuleBasedCollator$checkNotFrozen(), 0, this);
    }

    private CollationSettings getOwnedSettings() {
        return InvokeDynamicSupport.bootstrap("getOwnedSettings", $$robo$$android_icu_text_RuleBasedCollator$getOwnedSettings(), 0, this);
    }

    private CollationSettings getDefaultSettings() {
        return InvokeDynamicSupport.bootstrap("getDefaultSettings", $$robo$$android_icu_text_RuleBasedCollator$getDefaultSettings(), 0, this);
    }

    @Deprecated
    public void setHiraganaQuaternary(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHiraganaQuaternary", $$robo$$android_icu_text_RuleBasedCollator$setHiraganaQuaternary(boolean ), 0, this, bl);
    }

    @Deprecated
    public void setHiraganaQuaternaryDefault() {
        InvokeDynamicSupport.bootstrap("setHiraganaQuaternaryDefault", $$robo$$android_icu_text_RuleBasedCollator$setHiraganaQuaternaryDefault(), 0, this);
    }

    public void setUpperCaseFirst(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUpperCaseFirst", $$robo$$android_icu_text_RuleBasedCollator$setUpperCaseFirst(boolean ), 0, this, bl);
    }

    public void setLowerCaseFirst(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLowerCaseFirst", $$robo$$android_icu_text_RuleBasedCollator$setLowerCaseFirst(boolean ), 0, this, bl);
    }

    public void setCaseFirstDefault() {
        InvokeDynamicSupport.bootstrap("setCaseFirstDefault", $$robo$$android_icu_text_RuleBasedCollator$setCaseFirstDefault(), 0, this);
    }

    public void setAlternateHandlingDefault() {
        InvokeDynamicSupport.bootstrap("setAlternateHandlingDefault", $$robo$$android_icu_text_RuleBasedCollator$setAlternateHandlingDefault(), 0, this);
    }

    public void setCaseLevelDefault() {
        InvokeDynamicSupport.bootstrap("setCaseLevelDefault", $$robo$$android_icu_text_RuleBasedCollator$setCaseLevelDefault(), 0, this);
    }

    public void setDecompositionDefault() {
        InvokeDynamicSupport.bootstrap("setDecompositionDefault", $$robo$$android_icu_text_RuleBasedCollator$setDecompositionDefault(), 0, this);
    }

    public void setFrenchCollationDefault() {
        InvokeDynamicSupport.bootstrap("setFrenchCollationDefault", $$robo$$android_icu_text_RuleBasedCollator$setFrenchCollationDefault(), 0, this);
    }

    public void setStrengthDefault() {
        InvokeDynamicSupport.bootstrap("setStrengthDefault", $$robo$$android_icu_text_RuleBasedCollator$setStrengthDefault(), 0, this);
    }

    public void setNumericCollationDefault() {
        InvokeDynamicSupport.bootstrap("setNumericCollationDefault", $$robo$$android_icu_text_RuleBasedCollator$setNumericCollationDefault(), 0, this);
    }

    public void setFrenchCollation(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFrenchCollation", $$robo$$android_icu_text_RuleBasedCollator$setFrenchCollation(boolean ), 0, this, bl);
    }

    public void setAlternateHandlingShifted(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAlternateHandlingShifted", $$robo$$android_icu_text_RuleBasedCollator$setAlternateHandlingShifted(boolean ), 0, this, bl);
    }

    public void setCaseLevel(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCaseLevel", $$robo$$android_icu_text_RuleBasedCollator$setCaseLevel(boolean ), 0, this, bl);
    }

    @Override
    public void setDecomposition(int n) {
        InvokeDynamicSupport.bootstrap("setDecomposition", $$robo$$android_icu_text_RuleBasedCollator$setDecomposition(int ), 0, this, n);
    }

    @Override
    public void setStrength(int n) {
        InvokeDynamicSupport.bootstrap("setStrength", $$robo$$android_icu_text_RuleBasedCollator$setStrength(int ), 0, this, n);
    }

    @Override
    public RuleBasedCollator setMaxVariable(int n) {
        return InvokeDynamicSupport.bootstrap("setMaxVariable", $$robo$$android_icu_text_RuleBasedCollator$setMaxVariable(int ), 0, this, n);
    }

    @Override
    public int getMaxVariable() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxVariable", $$robo$$android_icu_text_RuleBasedCollator$getMaxVariable(), 0, this);
    }

    @Override
    @Deprecated
    public int setVariableTop(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("setVariableTop", $$robo$$android_icu_text_RuleBasedCollator$setVariableTop(java.lang.String ), 0, this, string2);
    }

    @Override
    @Deprecated
    public void setVariableTop(int n) {
        InvokeDynamicSupport.bootstrap("setVariableTop", $$robo$$android_icu_text_RuleBasedCollator$setVariableTop(int ), 0, this, n);
    }

    private void internalSetVariableTop(long l) {
        InvokeDynamicSupport.bootstrap("internalSetVariableTop", $$robo$$android_icu_text_RuleBasedCollator$internalSetVariableTop(long ), 0, this, l);
    }

    public void setNumericCollation(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNumericCollation", $$robo$$android_icu_text_RuleBasedCollator$setNumericCollation(boolean ), 0, this, bl);
    }

    @Override
    public void setReorderCodes(int ... nArray) {
        InvokeDynamicSupport.bootstrap("setReorderCodes", $$robo$$android_icu_text_RuleBasedCollator$setReorderCodes(int[] ), 0, this, nArray);
    }

    private void setFastLatinOptions(CollationSettings collationSettings) {
        InvokeDynamicSupport.bootstrap("setFastLatinOptions", $$robo$$android_icu_text_RuleBasedCollator$setFastLatinOptions(android.icu.impl.coll.CollationSettings ), 0, this, collationSettings);
    }

    public String getRules() {
        return InvokeDynamicSupport.bootstrap("getRules", $$robo$$android_icu_text_RuleBasedCollator$getRules(), 0, this);
    }

    public String getRules(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getRules", $$robo$$android_icu_text_RuleBasedCollator$getRules(boolean ), 0, this, bl);
    }

    @Override
    public UnicodeSet getTailoredSet() {
        return InvokeDynamicSupport.bootstrap("getTailoredSet", $$robo$$android_icu_text_RuleBasedCollator$getTailoredSet(), 0, this);
    }

    public void getContractionsAndExpansions(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, boolean bl) throws Exception {
        InvokeDynamicSupport.bootstrap("getContractionsAndExpansions", $$robo$$android_icu_text_RuleBasedCollator$getContractionsAndExpansions(android.icu.text.UnicodeSet android.icu.text.UnicodeSet boolean ), 0, this, unicodeSet, unicodeSet2, bl);
    }

    void internalAddContractions(int n, UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("internalAddContractions", $$robo$$android_icu_text_RuleBasedCollator$internalAddContractions(int android.icu.text.UnicodeSet ), 0, this, n, unicodeSet);
    }

    @Override
    public CollationKey getCollationKey(String string2) {
        return InvokeDynamicSupport.bootstrap("getCollationKey", $$robo$$android_icu_text_RuleBasedCollator$getCollationKey(java.lang.String ), 0, this, string2);
    }

    private CollationKey getCollationKey(String string2, CollationBuffer collationBuffer) {
        return InvokeDynamicSupport.bootstrap("getCollationKey", $$robo$$android_icu_text_RuleBasedCollator$getCollationKey(java.lang.String android.icu.text.RuleBasedCollator$CollationBuffer ), 0, this, string2, collationBuffer);
    }

    @Override
    public RawCollationKey getRawCollationKey(String string2, RawCollationKey rawCollationKey) {
        return InvokeDynamicSupport.bootstrap("getRawCollationKey", $$robo$$android_icu_text_RuleBasedCollator$getRawCollationKey(java.lang.String android.icu.text.RawCollationKey ), 0, this, string2, rawCollationKey);
    }

    private RawCollationKey getRawCollationKey(CharSequence charSequence, RawCollationKey rawCollationKey, CollationBuffer collationBuffer) {
        return InvokeDynamicSupport.bootstrap("getRawCollationKey", $$robo$$android_icu_text_RuleBasedCollator$getRawCollationKey(java.lang.CharSequence android.icu.text.RawCollationKey android.icu.text.RuleBasedCollator$CollationBuffer ), 0, this, charSequence, rawCollationKey, collationBuffer);
    }

    private int simpleKeyLengthEstimate(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrap("simpleKeyLengthEstimate", $$robo$$android_icu_text_RuleBasedCollator$simpleKeyLengthEstimate(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void writeSortKey(CharSequence charSequence, CollationKeyByteSink collationKeyByteSink, CollationBuffer collationBuffer) {
        InvokeDynamicSupport.bootstrap("writeSortKey", $$robo$$android_icu_text_RuleBasedCollator$writeSortKey(java.lang.CharSequence android.icu.text.RuleBasedCollator$CollationKeyByteSink android.icu.text.RuleBasedCollator$CollationBuffer ), 0, this, charSequence, collationKeyByteSink, collationBuffer);
    }

    private void writeIdenticalLevel(CharSequence charSequence, CollationKeyByteSink collationKeyByteSink) {
        InvokeDynamicSupport.bootstrap("writeIdenticalLevel", $$robo$$android_icu_text_RuleBasedCollator$writeIdenticalLevel(java.lang.CharSequence android.icu.text.RuleBasedCollator$CollationKeyByteSink ), 0, this, charSequence, collationKeyByteSink);
    }

    @Deprecated
    public long[] internalGetCEs(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("internalGetCEs", $$robo$$android_icu_text_RuleBasedCollator$internalGetCEs(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public int getStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getStrength", $$robo$$android_icu_text_RuleBasedCollator$getStrength(), 0, this);
    }

    @Override
    public int getDecomposition() {
        return (int)InvokeDynamicSupport.bootstrap("getDecomposition", $$robo$$android_icu_text_RuleBasedCollator$getDecomposition(), 0, this);
    }

    public boolean isUpperCaseFirst() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUpperCaseFirst", $$robo$$android_icu_text_RuleBasedCollator$isUpperCaseFirst(), 0, this);
    }

    public boolean isLowerCaseFirst() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLowerCaseFirst", $$robo$$android_icu_text_RuleBasedCollator$isLowerCaseFirst(), 0, this);
    }

    public boolean isAlternateHandlingShifted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlternateHandlingShifted", $$robo$$android_icu_text_RuleBasedCollator$isAlternateHandlingShifted(), 0, this);
    }

    public boolean isCaseLevel() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCaseLevel", $$robo$$android_icu_text_RuleBasedCollator$isCaseLevel(), 0, this);
    }

    public boolean isFrenchCollation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrenchCollation", $$robo$$android_icu_text_RuleBasedCollator$isFrenchCollation(), 0, this);
    }

    @Deprecated
    public boolean isHiraganaQuaternary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHiraganaQuaternary", $$robo$$android_icu_text_RuleBasedCollator$isHiraganaQuaternary(), 0, this);
    }

    @Override
    public int getVariableTop() {
        return (int)InvokeDynamicSupport.bootstrap("getVariableTop", $$robo$$android_icu_text_RuleBasedCollator$getVariableTop(), 0, this);
    }

    public boolean getNumericCollation() {
        return (boolean)InvokeDynamicSupport.bootstrap("getNumericCollation", $$robo$$android_icu_text_RuleBasedCollator$getNumericCollation(), 0, this);
    }

    @Override
    public int[] getReorderCodes() {
        return InvokeDynamicSupport.bootstrap("getReorderCodes", $$robo$$android_icu_text_RuleBasedCollator$getReorderCodes(), 0, this);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_RuleBasedCollator$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_RuleBasedCollator$hashCode(), 0, this);
    }

    @Override
    public int compare(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_text_RuleBasedCollator$compare(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private static int compareNFDIter(Normalizer2Impl normalizer2Impl, NFDIterator nFDIterator, NFDIterator nFDIterator2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareNFDIter", $$robo$$android_icu_text_RuleBasedCollator$compareNFDIter(android.icu.impl.Normalizer2Impl android.icu.text.RuleBasedCollator$NFDIterator android.icu.text.RuleBasedCollator$NFDIterator ), 0, (Normalizer2Impl)normalizer2Impl, (NFDIterator)nFDIterator, (NFDIterator)nFDIterator2);
    }

    @Override
    @Deprecated
    protected int doCompare(CharSequence charSequence, CharSequence charSequence2) {
        return (int)InvokeDynamicSupport.bootstrap("doCompare", $$robo$$android_icu_text_RuleBasedCollator$doCompare(java.lang.CharSequence java.lang.CharSequence ), 0, this, charSequence, charSequence2);
    }

    private void __constructor__(CollationTailoring collationTailoring, ULocale uLocale) {
        this.$$robo$$android_icu_text_RuleBasedCollator$__constructor__(collationTailoring, uLocale);
    }

    RuleBasedCollator(CollationTailoring collationTailoring, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedCollator$__constructor__(android.icu.impl.coll.CollationTailoring android.icu.util.ULocale ), 0, this, collationTailoring, uLocale);
    }

    private void adoptTailoring(CollationTailoring collationTailoring) {
        InvokeDynamicSupport.bootstrap("adoptTailoring", $$robo$$android_icu_text_RuleBasedCollator$adoptTailoring(android.icu.impl.coll.CollationTailoring ), 0, this, collationTailoring);
    }

    boolean isUnsafe(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnsafe", $$robo$$android_icu_text_RuleBasedCollator$isUnsafe(int ), 0, this, n);
    }

    @Override
    public VersionInfo getVersion() {
        return InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_icu_text_RuleBasedCollator$getVersion(), 0, this);
    }

    @Override
    public VersionInfo getUCAVersion() {
        return InvokeDynamicSupport.bootstrap("getUCAVersion", $$robo$$android_icu_text_RuleBasedCollator$getUCAVersion(), 0, this);
    }

    private CollationBuffer getCollationBuffer() {
        return InvokeDynamicSupport.bootstrap("getCollationBuffer", $$robo$$android_icu_text_RuleBasedCollator$getCollationBuffer(), 0, this);
    }

    private void releaseCollationBuffer(CollationBuffer collationBuffer) {
        InvokeDynamicSupport.bootstrap("releaseCollationBuffer", $$robo$$android_icu_text_RuleBasedCollator$releaseCollationBuffer(android.icu.text.RuleBasedCollator$CollationBuffer ), 0, this, collationBuffer);
    }

    @Override
    public ULocale getLocale(ULocale.Type type) {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_RuleBasedCollator$getLocale(android.icu.util.ULocale$Type ), 0, this, type);
    }

    @Override
    void setLocale(ULocale uLocale, ULocale uLocale2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_RuleBasedCollator$setLocale(android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2);
    }

    static {
        RobolectricInternals.classInitializing(RuleBasedCollator.class);
    }

    public /* synthetic */ RuleBasedCollator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuleBasedCollator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CollationBuffer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        UTF16CollationIterator leftUTF16CollIter;
        UTF16CollationIterator rightUTF16CollIter;
        FCDUTF16CollationIterator leftFCDUTF16Iter;
        FCDUTF16CollationIterator rightFCDUTF16Iter;
        UTF16NFDIterator leftUTF16NFDIter;
        UTF16NFDIterator rightUTF16NFDIter;
        FCDUTF16NFDIterator leftFCDUTF16NFDIter;
        FCDUTF16NFDIterator rightFCDUTF16NFDIter;
        RawCollationKey rawCollationKey;

        private void $$robo$$android_icu_text_RuleBasedCollator_CollationBuffer$__constructor__(CollationData data) {
            this.leftUTF16CollIter = new UTF16CollationIterator(data);
            this.rightUTF16CollIter = new UTF16CollationIterator(data);
            this.leftFCDUTF16Iter = new FCDUTF16CollationIterator(data);
            this.rightFCDUTF16Iter = new FCDUTF16CollationIterator(data);
            this.leftUTF16NFDIter = new UTF16NFDIterator();
            this.rightUTF16NFDIter = new UTF16NFDIterator();
            this.leftFCDUTF16NFDIter = new FCDUTF16NFDIterator();
            this.rightFCDUTF16NFDIter = new FCDUTF16NFDIterator();
        }

        private /* synthetic */ void $$robo$$android_icu_text_RuleBasedCollator_CollationBuffer$__constructor__(CollationData x0, 1 x1) {
        }

        private void __constructor__(CollationData collationData) {
            this.$$robo$$android_icu_text_RuleBasedCollator_CollationBuffer$__constructor__(collationData);
        }

        private CollationBuffer(CollationData collationData) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedCollator_CollationBuffer$__constructor__(android.icu.impl.coll.CollationData ), 0, this, collationData);
        }

        private /* synthetic */ void __constructor__(CollationData collationData, 1 var2_2) {
            this.$$robo$$android_icu_text_RuleBasedCollator_CollationBuffer$__constructor__(collationData, var2_2);
        }

        public /* synthetic */ CollationBuffer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationBuffer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FCDUTF16NFDIterator
    extends UTF16NFDIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private StringBuilder str;

        private void $$robo$$android_icu_text_RuleBasedCollator_FCDUTF16NFDIterator$__constructor__() {
        }

        private final void $$robo$$android_icu_text_RuleBasedCollator_FCDUTF16NFDIterator$setText(Normalizer2Impl nfcImpl, CharSequence seq, int start) {
            this.reset();
            int spanLimit = nfcImpl.makeFCD(seq, start, seq.length(), null);
            if (spanLimit == seq.length()) {
                this.s = seq;
                this.pos = start;
            } else {
                if (this.str == null) {
                    this.str = new StringBuilder();
                } else {
                    this.str.setLength(0);
                }
                this.str.append(seq, start, spanLimit);
                Normalizer2Impl.ReorderingBuffer buffer = new Normalizer2Impl.ReorderingBuffer(nfcImpl, this.str, seq.length() - start);
                nfcImpl.makeFCD(seq, spanLimit, seq.length(), buffer);
                this.s = this.str;
                this.pos = 0;
            }
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_RuleBasedCollator_FCDUTF16NFDIterator$__constructor__();
        }

        FCDUTF16NFDIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedCollator_FCDUTF16NFDIterator$__constructor__(), 0, this);
        }

        void setText(Normalizer2Impl normalizer2Impl, CharSequence charSequence, int n) {
            InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_RuleBasedCollator_FCDUTF16NFDIterator$setText(android.icu.impl.Normalizer2Impl java.lang.CharSequence int ), 0, this, normalizer2Impl, charSequence, n);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FCDUTF16NFDIterator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class UTF16NFDIterator
    extends NFDIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected CharSequence s;
        protected int pos;

        private void $$robo$$android_icu_text_RuleBasedCollator_UTF16NFDIterator$__constructor__() {
        }

        private final void $$robo$$android_icu_text_RuleBasedCollator_UTF16NFDIterator$setText(CharSequence seq, int start) {
            this.reset();
            this.s = seq;
            this.pos = start;
        }

        private final int $$robo$$android_icu_text_RuleBasedCollator_UTF16NFDIterator$nextRawCodePoint() {
            if (this.pos == this.s.length()) {
                return -1;
            }
            int c = Character.codePointAt(this.s, this.pos);
            this.pos += Character.charCount(c);
            return c;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_RuleBasedCollator_UTF16NFDIterator$__constructor__();
        }

        UTF16NFDIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedCollator_UTF16NFDIterator$__constructor__(), 0, this);
        }

        void setText(CharSequence charSequence, int n) {
            InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_RuleBasedCollator_UTF16NFDIterator$setText(java.lang.CharSequence int ), 0, this, charSequence, n);
        }

        @Override
        protected int nextRawCodePoint() {
            return (int)InvokeDynamicSupport.bootstrap("nextRawCodePoint", $$robo$$android_icu_text_RuleBasedCollator_UTF16NFDIterator$nextRawCodePoint(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UTF16NFDIterator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class NFDIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String decomp;
        private int index;

        private void $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$__constructor__() {
        }

        private final void $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$reset() {
            this.index = -1;
        }

        private final int $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$nextCodePoint() {
            if (this.index >= 0) {
                if (this.index == this.decomp.length()) {
                    this.index = -1;
                } else {
                    int c = Character.codePointAt(this.decomp, this.index);
                    this.index += Character.charCount(c);
                    return c;
                }
            }
            return this.nextRawCodePoint();
        }

        private final int $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$nextDecomposedCodePoint(Normalizer2Impl nfcImpl, int c) {
            if (this.index >= 0) {
                return c;
            }
            this.decomp = nfcImpl.getDecomposition(c);
            if (this.decomp == null) {
                return c;
            }
            c = Character.codePointAt(this.decomp, 0);
            this.index = Character.charCount(c);
            return c;
        }

        protected abstract int nextRawCodePoint();

        private void __constructor__() {
            this.$$robo$$android_icu_text_RuleBasedCollator_NFDIterator$__constructor__();
        }

        NFDIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$__constructor__(), 0, this);
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$reset(), 0, this);
        }

        int nextCodePoint() {
            return (int)InvokeDynamicSupport.bootstrap("nextCodePoint", $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$nextCodePoint(), 0, this);
        }

        int nextDecomposedCodePoint(Normalizer2Impl normalizer2Impl, int n) {
            return (int)InvokeDynamicSupport.bootstrap("nextDecomposedCodePoint", $$robo$$android_icu_text_RuleBasedCollator_NFDIterator$nextDecomposedCodePoint(android.icu.impl.Normalizer2Impl int ), 0, this, normalizer2Impl, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFDIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CollationKeyByteSink
    extends CollationKeys.SortKeyByteSink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private RawCollationKey key_;

        private void $$robo$$android_icu_text_RuleBasedCollator_CollationKeyByteSink$__constructor__(RawCollationKey key) {
            this.key_ = key;
        }

        private final void $$robo$$android_icu_text_RuleBasedCollator_CollationKeyByteSink$AppendBeyondCapacity(byte[] bytes, int start, int n, int length) {
            if (this.Resize(n, length)) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])bytes, (int)start, (byte[])this.buffer_, (int)length, (int)n);
            }
        }

        private final boolean $$robo$$android_icu_text_RuleBasedCollator_CollationKeyByteSink$Resize(int appendCapacity, int length) {
            int newCapacity = 2 * this.buffer_.length;
            int altCapacity = length + 2 * appendCapacity;
            if (newCapacity < altCapacity) {
                newCapacity = altCapacity;
            }
            if (newCapacity < 200) {
                newCapacity = 200;
            }
            byte[] newBytes = new byte[newCapacity];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.buffer_, (int)0, (byte[])newBytes, (int)0, (int)length);
            this.key_.bytes = newBytes;
            this.buffer_ = newBytes;
            return true;
        }

        private void __constructor__(RawCollationKey rawCollationKey) {
            this.$$robo$$android_icu_text_RuleBasedCollator_CollationKeyByteSink$__constructor__(rawCollationKey);
        }

        CollationKeyByteSink(RawCollationKey rawCollationKey) {
            super(rawCollationKey.bytes);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedCollator_CollationKeyByteSink$__constructor__(android.icu.text.RawCollationKey ), 0, this, rawCollationKey);
        }

        @Override
        protected void AppendBeyondCapacity(byte[] byArray, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("AppendBeyondCapacity", $$robo$$android_icu_text_RuleBasedCollator_CollationKeyByteSink$AppendBeyondCapacity(byte[] int int int ), 0, this, byArray, n, n2, n3);
        }

        @Override
        protected boolean Resize(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("Resize", $$robo$$android_icu_text_RuleBasedCollator_CollationKeyByteSink$Resize(int int ), 0, this, n, n2);
        }

        public /* synthetic */ CollationKeyByteSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationKeyByteSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

