/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.math.BigDecimal;
import android.icu.text.CompactDecimalDataCache;
import android.icu.text.DecimalFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NumberFormat;
import android.icu.text.PluralRules;
import android.icu.util.Currency;
import android.icu.util.CurrencyAmount;
import android.icu.util.Output;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CompactDecimalFormat
extends DecimalFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 4716293295276629682L;
    private static CompactDecimalDataCache cache;
    private Map<String, DecimalFormat.Unit[]> units;
    private Map<String, DecimalFormat.Unit[]> currencyUnits;
    private long[] divisor;
    private long[] currencyDivisor;
    private Map<String, DecimalFormat.Unit> pluralToCurrencyAffixes;
    private CompactStyle style;
    private PluralRules pluralRules;
    private static Pattern UNESCAPE_QUOTE;

    private static final CompactDecimalFormat $$robo$$android_icu_text_CompactDecimalFormat$getInstance(ULocale locale, CompactStyle style2) {
        return new CompactDecimalFormat(locale, style2);
    }

    private static final CompactDecimalFormat $$robo$$android_icu_text_CompactDecimalFormat$getInstance(Locale locale, CompactStyle style2) {
        return new CompactDecimalFormat(ULocale.forLocale(locale), style2);
    }

    private void $$robo$$android_icu_text_CompactDecimalFormat$__constructor__(ULocale locale, CompactStyle style2) {
        this.pluralRules = PluralRules.forLocale(locale);
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(locale);
        CompactDecimalDataCache.Data data = this.getData(locale, style2);
        CompactDecimalDataCache.Data currencyData = this.getCurrencyData(locale);
        this.units = data.units;
        this.divisor = data.divisors;
        this.currencyUnits = currencyData.units;
        this.currencyDivisor = currencyData.divisors;
        this.style = style2;
        this.pluralToCurrencyAffixes = null;
        this.finishInit(style2, format.toPattern(), format.getDecimalFormatSymbols());
    }

    @Deprecated
    private void $$robo$$android_icu_text_CompactDecimalFormat$__constructor__(String pattern, DecimalFormatSymbols formatSymbols, CompactStyle style2, PluralRules pluralRules, long[] divisor, Map<String, String[][]> pluralAffixes, Map<String, String[]> currencyAffixes, Collection<String> debugCreationErrors) {
        this.pluralRules = pluralRules;
        this.units = this.otherPluralVariant(pluralAffixes, divisor, debugCreationErrors);
        this.currencyUnits = this.otherPluralVariant(pluralAffixes, divisor, debugCreationErrors);
        if (!pluralRules.getKeywords().equals(this.units.keySet())) {
            debugCreationErrors.add("Missmatch in pluralCategories, should be: " + pluralRules.getKeywords() + ", was actually " + this.units.keySet());
        }
        this.divisor = (long[])divisor.clone();
        this.currencyDivisor = (long[])divisor.clone();
        if (currencyAffixes == null) {
            this.pluralToCurrencyAffixes = null;
        } else {
            this.pluralToCurrencyAffixes = new HashMap<String, DecimalFormat.Unit>();
            for (Map.Entry<String, String[]> s : currencyAffixes.entrySet()) {
                String[] pair = s.getValue();
                this.pluralToCurrencyAffixes.put(s.getKey(), new DecimalFormat.Unit(pair[0], pair[1]));
            }
        }
        this.finishInit(style2, pattern, formatSymbols);
    }

    private final void $$robo$$android_icu_text_CompactDecimalFormat$finishInit(CompactStyle style2, String pattern, DecimalFormatSymbols formatSymbols) {
        this.applyPattern(pattern);
        this.setDecimalFormatSymbols(formatSymbols);
        this.setMaximumSignificantDigits(2);
        this.setSignificantDigitsUsed(true);
        if (style2 == CompactStyle.SHORT) {
            this.setGroupingUsed(false);
        }
        this.setCurrency(null);
    }

    private final boolean $$robo$$android_icu_text_CompactDecimalFormat$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompactDecimalFormat other = (CompactDecimalFormat)obj;
        return this.mapsAreEqual(this.units, other.units) && Arrays.equals(this.divisor, other.divisor) && (this.pluralToCurrencyAffixes == other.pluralToCurrencyAffixes || this.pluralToCurrencyAffixes != null && this.pluralToCurrencyAffixes.equals(other.pluralToCurrencyAffixes)) && this.pluralRules.equals(other.pluralRules);
    }

    private final boolean $$robo$$android_icu_text_CompactDecimalFormat$mapsAreEqual(Map<String, DecimalFormat.Unit[]> lhs, Map<String, DecimalFormat.Unit[]> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (Map.Entry<String, DecimalFormat.Unit[]> entry : lhs.entrySet()) {
            Object[] value = rhs.get(entry.getKey());
            if (value != null && Arrays.equals(entry.getValue(), value)) continue;
            return false;
        }
        return true;
    }

    private final StringBuffer $$robo$$android_icu_text_CompactDecimalFormat$format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number, null, toAppendTo, pos);
    }

    private final AttributedCharacterIterator $$robo$$android_icu_text_CompactDecimalFormat$formatToCharacterIterator(Object obj) {
        if (!(obj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        Number number = (Number)obj;
        Amount amount = this.toAmount(number.doubleValue(), null, null);
        return super.formatToCharacterIterator(amount.getQty(), amount.getUnit());
    }

    private final StringBuffer $$robo$$android_icu_text_CompactDecimalFormat$format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    private final StringBuffer $$robo$$android_icu_text_CompactDecimalFormat$format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    private final StringBuffer $$robo$$android_icu_text_CompactDecimalFormat$format(java.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    private final StringBuffer $$robo$$android_icu_text_CompactDecimalFormat$format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    @Deprecated
    private final StringBuffer $$robo$$android_icu_text_CompactDecimalFormat$format(CurrencyAmount currAmt, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(currAmt.getNumber().doubleValue(), currAmt.getCurrency(), toAppendTo, pos);
    }

    private final Number $$robo$$android_icu_text_CompactDecimalFormat$parse(String text, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$android_icu_text_CompactDecimalFormat$writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    private final void $$robo$$android_icu_text_CompactDecimalFormat$readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final StringBuffer $$robo$$android_icu_text_CompactDecimalFormat$format(double number, Currency curr, StringBuffer toAppendTo, FieldPosition pos) {
        if (curr != null && this.style == CompactStyle.LONG) {
            throw new UnsupportedOperationException("CompactDecimalFormat does not support LONG style for currency.");
        }
        Output<DecimalFormat.Unit> currencyUnit = new Output<DecimalFormat.Unit>();
        Amount amount = this.toAmount(number, curr, currencyUnit);
        DecimalFormat.Unit unit = amount.getUnit();
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        if (currencyUnit.value != null) {
            ((DecimalFormat.Unit)currencyUnit.value).writePrefix(prefix);
        }
        unit.writePrefix(prefix);
        unit.writeSuffix(suffix);
        if (currencyUnit.value != null) {
            ((DecimalFormat.Unit)currencyUnit.value).writeSuffix(suffix);
        }
        if (curr == null) {
            toAppendTo.append(CompactDecimalFormat.escape(prefix.toString()));
            super.format(amount.getQty(), toAppendTo, pos);
            toAppendTo.append(CompactDecimalFormat.escape(suffix.toString()));
        } else {
            CompactDecimalFormat compactDecimalFormat = this;
            synchronized (compactDecimalFormat) {
                String originalPattern = this.toPattern();
                Currency originalCurrency = this.getCurrency();
                StringBuffer newPattern = new StringBuffer();
                int semicolonPos = originalPattern.indexOf(59);
                newPattern.append(prefix);
                if (semicolonPos != -1) {
                    newPattern.append(originalPattern, 0, semicolonPos);
                    newPattern.append(suffix);
                    newPattern.append(';');
                    newPattern.append(prefix);
                }
                newPattern.append(originalPattern, semicolonPos + 1, originalPattern.length());
                newPattern.append(suffix);
                this.setCurrency(curr);
                this.applyPattern(newPattern.toString());
                super.format(amount.getQty(), toAppendTo, pos);
                this.setCurrency(originalCurrency);
                this.applyPattern(originalPattern);
            }
        }
        return toAppendTo;
    }

    private static final String $$robo$$android_icu_text_CompactDecimalFormat$escape(String string2) {
        if (string2.indexOf(39) >= 0) {
            return UNESCAPE_QUOTE.matcher(string2).replaceAll("$1");
        }
        return string2;
    }

    private final Amount $$robo$$android_icu_text_CompactDecimalFormat$toAmount(double number, Currency curr, Output<DecimalFormat.Unit> currencyUnit) {
        int base;
        boolean negative = this.isNumberNegative(number);
        int n = base = (number = this.adjustNumberAsInFormatting(number)) <= 1.0 ? 0 : (int)Math.log10(number);
        if (base >= 15) {
            base = 14;
        }
        number = curr != null ? (number /= (double)this.currencyDivisor[base]) : (number /= (double)this.divisor[base]);
        String pluralVariant = this.getPluralForm(this.getFixedDecimal(number, this.toDigitList(number)));
        if (this.pluralToCurrencyAffixes != null && currencyUnit != null) {
            currencyUnit.value = this.pluralToCurrencyAffixes.get(pluralVariant);
        }
        if (negative) {
            number = -number;
        }
        if (curr != null) {
            return new Amount(number, CompactDecimalDataCache.getUnit(this.currencyUnits, pluralVariant, base));
        }
        return new Amount(number, CompactDecimalDataCache.getUnit(this.units, pluralVariant, base));
    }

    private final void $$robo$$android_icu_text_CompactDecimalFormat$recordError(Collection<String> creationErrors, String errorMessage) {
        if (creationErrors == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        creationErrors.add(errorMessage);
    }

    private final Map<String, DecimalFormat.Unit[]> $$robo$$android_icu_text_CompactDecimalFormat$otherPluralVariant(Map<String, String[][]> pluralCategoryToPower10ToAffix, long[] divisor, Collection<String> debugCreationErrors) {
        if (divisor.length < 15) {
            this.recordError(debugCreationErrors, "Must have at least 15 prefix items.");
        }
        long oldDivisor = 0L;
        for (int i = 0; i < divisor.length; ++i) {
            long roundTrip;
            int log = (int)Math.log10(divisor[i]);
            if (log > i) {
                this.recordError(debugCreationErrors, "Divisor[" + i + "] must be less than or equal to 10^" + i + ", but is: " + divisor[i]);
            }
            if ((roundTrip = (long)Math.pow(10.0, log)) != divisor[i]) {
                this.recordError(debugCreationErrors, "Divisor[" + i + "] must be a power of 10, but is: " + divisor[i]);
            }
            if (divisor[i] < oldDivisor) {
                this.recordError(debugCreationErrors, "Bad divisor, the divisor for 10E" + i + "(" + divisor[i] + ") is less than the divisor for the divisor for 10E" + (i - 1) + "(" + oldDivisor + ")");
            }
            oldDivisor = divisor[i];
        }
        HashMap<String, DecimalFormat.Unit[]> result = new HashMap<String, DecimalFormat.Unit[]>();
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        String[][] defaultPower10ToAffix = pluralCategoryToPower10ToAffix.get("other");
        for (Map.Entry<String, String[][]> pluralCategoryAndPower10ToAffix : pluralCategoryToPower10ToAffix.entrySet()) {
            String pluralCategory = pluralCategoryAndPower10ToAffix.getKey();
            String[][] power10ToAffix = pluralCategoryAndPower10ToAffix.getValue();
            if (power10ToAffix.length != divisor.length) {
                this.recordError(debugCreationErrors, "Prefixes & suffixes must be present for all divisors " + pluralCategory);
            }
            DecimalFormat.Unit[] units = new DecimalFormat.Unit[power10ToAffix.length];
            for (int i = 0; i < power10ToAffix.length; ++i) {
                String[] pair = power10ToAffix[i];
                if (pair == null) {
                    pair = defaultPower10ToAffix[i];
                }
                if (pair.length != 2 || pair[0] == null || pair[1] == null) {
                    this.recordError(debugCreationErrors, "Prefix or suffix is null for " + pluralCategory + ", " + i + ", " + Arrays.asList(pair));
                    continue;
                }
                int log = (int)Math.log10(divisor[i]);
                String key = pair[0] + "\uffff" + pair[1] + "\uffff" + (i - log);
                Integer old = (Integer)seen.get(key);
                if (old == null) {
                    seen.put(key, i);
                } else if (old != i) {
                    this.recordError(debugCreationErrors, "Collision between values for " + i + " and " + old + " for [prefix/suffix/index-log(divisor)" + key.replace('\uffff', ';'));
                }
                units[i] = new DecimalFormat.Unit(pair[0], pair[1]);
            }
            result.put(pluralCategory, units);
        }
        return result;
    }

    private final String $$robo$$android_icu_text_CompactDecimalFormat$getPluralForm(PluralRules.FixedDecimal fixedDecimal) {
        if (this.pluralRules == null) {
            return "other";
        }
        return this.pluralRules.select(fixedDecimal);
    }

    private final CompactDecimalDataCache.Data $$robo$$android_icu_text_CompactDecimalFormat$getData(ULocale locale, CompactStyle style2) {
        CompactDecimalDataCache.DataBundle bundle = cache.get(locale);
        switch (1.$SwitchMap$android$icu$text$CompactDecimalFormat$CompactStyle[style2.ordinal()]) {
            case 1: {
                return bundle.shortData;
            }
            case 2: {
                return bundle.longData;
            }
        }
        return bundle.shortData;
    }

    private final CompactDecimalDataCache.Data $$robo$$android_icu_text_CompactDecimalFormat$getCurrencyData(ULocale locale) {
        CompactDecimalDataCache.DataBundle bundle = cache.get(locale);
        return bundle.shortCurrencyData;
    }

    static void __staticInitializer__() {
        cache = new CompactDecimalDataCache();
        UNESCAPE_QUOTE = Pattern.compile("((?<!'))'");
    }

    public static CompactDecimalFormat getInstance(ULocale uLocale, CompactStyle compactStyle) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_CompactDecimalFormat$getInstance(android.icu.util.ULocale android.icu.text.CompactDecimalFormat$CompactStyle ), 0, (ULocale)uLocale, (CompactStyle)compactStyle);
    }

    public static CompactDecimalFormat getInstance(Locale locale, CompactStyle compactStyle) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_CompactDecimalFormat$getInstance(java.util.Locale android.icu.text.CompactDecimalFormat$CompactStyle ), 0, (Locale)locale, (CompactStyle)compactStyle);
    }

    private void __constructor__(ULocale uLocale, CompactStyle compactStyle) {
        this.$$robo$$android_icu_text_CompactDecimalFormat$__constructor__(uLocale, compactStyle);
    }

    CompactDecimalFormat(ULocale uLocale, CompactStyle compactStyle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalFormat$__constructor__(android.icu.util.ULocale android.icu.text.CompactDecimalFormat$CompactStyle ), 0, this, uLocale, compactStyle);
    }

    private void __constructor__(String string2, DecimalFormatSymbols decimalFormatSymbols, CompactStyle compactStyle, PluralRules pluralRules, long[] lArray, Map<String, String[][]> map, Map<String, String[]> map2, Collection<String> collection) {
        this.$$robo$$android_icu_text_CompactDecimalFormat$__constructor__(string2, decimalFormatSymbols, compactStyle, pluralRules, lArray, map, map2, collection);
    }

    public CompactDecimalFormat(String string2, DecimalFormatSymbols decimalFormatSymbols, CompactStyle compactStyle, PluralRules pluralRules, long[] lArray, Map<String, String[][]> map, Map<String, String[]> map2, Collection<String> collection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalFormat$__constructor__(java.lang.String android.icu.text.DecimalFormatSymbols android.icu.text.CompactDecimalFormat$CompactStyle android.icu.text.PluralRules long[] java.util.Map<java.lang.String, java.lang.String[][]> java.util.Map<java.lang.String, java.lang.String[]> java.util.Collection<java.lang.String> ), 0, this, string2, decimalFormatSymbols, compactStyle, pluralRules, lArray, map, map2, collection);
    }

    private void finishInit(CompactStyle compactStyle, String string2, DecimalFormatSymbols decimalFormatSymbols) {
        InvokeDynamicSupport.bootstrap("finishInit", $$robo$$android_icu_text_CompactDecimalFormat$finishInit(android.icu.text.CompactDecimalFormat$CompactStyle java.lang.String android.icu.text.DecimalFormatSymbols ), 0, this, compactStyle, string2, decimalFormatSymbols);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_CompactDecimalFormat$equals(java.lang.Object ), 0, this, object);
    }

    private boolean mapsAreEqual(Map<String, DecimalFormat.Unit[]> map, Map<String, DecimalFormat.Unit[]> map2) {
        return (boolean)InvokeDynamicSupport.bootstrap("mapsAreEqual", $$robo$$android_icu_text_CompactDecimalFormat$mapsAreEqual(java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, this, map, map2);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_CompactDecimalFormat$format(double java.lang.StringBuffer java.text.FieldPosition ), 0, this, d, stringBuffer, fieldPosition);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return InvokeDynamicSupport.bootstrap("formatToCharacterIterator", $$robo$$android_icu_text_CompactDecimalFormat$formatToCharacterIterator(java.lang.Object ), 0, this, object);
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_CompactDecimalFormat$format(long java.lang.StringBuffer java.text.FieldPosition ), 0, this, l, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_CompactDecimalFormat$format(java.math.BigInteger java.lang.StringBuffer java.text.FieldPosition ), 0, this, bigInteger, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(java.math.BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_CompactDecimalFormat$format(java.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), 0, this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_CompactDecimalFormat$format(android.icu.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), 0, this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    @Deprecated
    public StringBuffer format(CurrencyAmount currencyAmount, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_CompactDecimalFormat$format(android.icu.util.CurrencyAmount java.lang.StringBuffer java.text.FieldPosition ), 0, this, currencyAmount, stringBuffer, fieldPosition);
    }

    @Override
    public Number parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_CompactDecimalFormat$parse(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_CompactDecimalFormat$writeObject(java.io.ObjectOutputStream ), 0, this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_CompactDecimalFormat$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    private StringBuffer format(double d, Currency currency, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_CompactDecimalFormat$format(double android.icu.util.Currency java.lang.StringBuffer java.text.FieldPosition ), 0, this, d, currency, stringBuffer, fieldPosition);
    }

    private static String escape(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("escape", $$robo$$android_icu_text_CompactDecimalFormat$escape(java.lang.String ), 0, (String)string2);
    }

    private Amount toAmount(double d, Currency currency, Output<DecimalFormat.Unit> output) {
        return InvokeDynamicSupport.bootstrap("toAmount", $$robo$$android_icu_text_CompactDecimalFormat$toAmount(double android.icu.util.Currency android.icu.util.Output<android.icu.text.DecimalFormat$Unit> ), 0, this, d, currency, output);
    }

    private void recordError(Collection<String> collection, String string2) {
        InvokeDynamicSupport.bootstrap("recordError", $$robo$$android_icu_text_CompactDecimalFormat$recordError(java.util.Collection<java.lang.String> java.lang.String ), 0, this, collection, string2);
    }

    private Map<String, DecimalFormat.Unit[]> otherPluralVariant(Map<String, String[][]> map, long[] lArray, Collection<String> collection) {
        return InvokeDynamicSupport.bootstrap("otherPluralVariant", $$robo$$android_icu_text_CompactDecimalFormat$otherPluralVariant(java.util.Map<java.lang.String, java.lang.String[][]> long[] java.util.Collection<java.lang.String> ), 0, this, map, lArray, collection);
    }

    private String getPluralForm(PluralRules.FixedDecimal fixedDecimal) {
        return InvokeDynamicSupport.bootstrap("getPluralForm", $$robo$$android_icu_text_CompactDecimalFormat$getPluralForm(android.icu.text.PluralRules$FixedDecimal ), 0, this, fixedDecimal);
    }

    private CompactDecimalDataCache.Data getData(ULocale uLocale, CompactStyle compactStyle) {
        return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_icu_text_CompactDecimalFormat$getData(android.icu.util.ULocale android.icu.text.CompactDecimalFormat$CompactStyle ), 0, this, uLocale, compactStyle);
    }

    private CompactDecimalDataCache.Data getCurrencyData(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getCurrencyData", $$robo$$android_icu_text_CompactDecimalFormat$getCurrencyData(android.icu.util.ULocale ), 0, this, uLocale);
    }

    static {
        RobolectricInternals.classInitializing(CompactDecimalFormat.class);
    }

    public /* synthetic */ CompactDecimalFormat() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactDecimalFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Amount
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private double qty;
        private DecimalFormat.Unit unit;

        private void $$robo$$android_icu_text_CompactDecimalFormat_Amount$__constructor__(double qty, DecimalFormat.Unit unit) {
            this.qty = qty;
            this.unit = unit;
        }

        private final double $$robo$$android_icu_text_CompactDecimalFormat_Amount$getQty() {
            return this.qty;
        }

        private final DecimalFormat.Unit $$robo$$android_icu_text_CompactDecimalFormat_Amount$getUnit() {
            return this.unit;
        }

        private void __constructor__(double d, DecimalFormat.Unit unit) {
            this.$$robo$$android_icu_text_CompactDecimalFormat_Amount$__constructor__(d, unit);
        }

        public Amount(double d, DecimalFormat.Unit unit) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalFormat_Amount$__constructor__(double android.icu.text.DecimalFormat$Unit ), 0, this, d, unit);
        }

        public double getQty() {
            return (double)InvokeDynamicSupport.bootstrap("getQty", $$robo$$android_icu_text_CompactDecimalFormat_Amount$getQty(), 0, this);
        }

        public DecimalFormat.Unit getUnit() {
            return InvokeDynamicSupport.bootstrap("getUnit", $$robo$$android_icu_text_CompactDecimalFormat_Amount$getUnit(), 0, this);
        }

        public /* synthetic */ Amount() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Amount)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CompactStyle
    extends Enum<CompactStyle> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ CompactStyle SHORT;
        public static /* enum */ CompactStyle LONG;
        private static /* synthetic */ CompactStyle[] $VALUES;

        private static final CompactStyle[] $$robo$$android_icu_text_CompactDecimalFormat_CompactStyle$values() {
            return (CompactStyle[])$VALUES.clone();
        }

        private static final CompactStyle $$robo$$android_icu_text_CompactDecimalFormat_CompactStyle$valueOf(String name) {
            return Enum.valueOf(CompactStyle.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_CompactDecimalFormat_CompactStyle$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            SHORT = new CompactStyle();
            LONG = new CompactStyle();
            $VALUES = new CompactStyle[]{SHORT, LONG};
        }

        public static CompactStyle[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_CompactDecimalFormat_CompactStyle$values(), 0);
        }

        public static CompactStyle valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_CompactDecimalFormat_CompactStyle$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_CompactDecimalFormat_CompactStyle$__constructor__(string2, n);
        }

        private CompactStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalFormat_CompactStyle$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(CompactStyle.class);
        }

        public /* synthetic */ CompactStyle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactStyle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

