/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.CharsetMatch;
import android.icu.text.CharsetRecog_2022;
import android.icu.text.CharsetRecog_UTF8;
import android.icu.text.CharsetRecog_Unicode;
import android.icu.text.CharsetRecog_mbcs;
import android.icu.text.CharsetRecog_sbcs;
import android.icu.text.CharsetRecognizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CharsetDetector
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int kBufSize = 8000;
    byte[] fInputBytes;
    int fInputLen;
    short[] fByteStats;
    boolean fC1Bytes;
    String fDeclaredEncoding;
    byte[] fRawInput;
    int fRawLength;
    InputStream fInputStream;
    private boolean fStripTags;
    private boolean[] fEnabledRecognizers;
    private static List<CSRecognizerInfo> ALL_CS_RECOGNIZERS;

    private void $$robo$$android_icu_text_CharsetDetector$__constructor__() {
        this.fInputBytes = new byte[8000];
        this.fByteStats = new short[256];
        this.fC1Bytes = false;
        this.fStripTags = false;
    }

    private final CharsetDetector $$robo$$android_icu_text_CharsetDetector$setDeclaredEncoding(String encoding) {
        this.fDeclaredEncoding = encoding;
        return this;
    }

    private final CharsetDetector $$robo$$android_icu_text_CharsetDetector$setText(byte[] in) {
        this.fRawInput = in;
        this.fRawLength = in.length;
        return this;
    }

    private final CharsetDetector $$robo$$android_icu_text_CharsetDetector$setText(InputStream in) throws IOException {
        int bytesRead;
        this.fInputStream = in;
        this.fInputStream.mark(8000);
        this.fRawInput = new byte[8000];
        this.fRawLength = 0;
        for (int remainingLength = 8000; remainingLength > 0 && (bytesRead = this.fInputStream.read(this.fRawInput, this.fRawLength, remainingLength)) > 0; remainingLength -= bytesRead) {
            this.fRawLength += bytesRead;
        }
        this.fInputStream.reset();
        return this;
    }

    private final CharsetMatch $$robo$$android_icu_text_CharsetDetector$detect() {
        CharsetMatch[] matches = this.detectAll();
        if (matches == null || matches.length == 0) {
            return null;
        }
        return matches[0];
    }

    private final CharsetMatch[] $$robo$$android_icu_text_CharsetDetector$detectAll() {
        ArrayList<CharsetMatch> matches = new ArrayList<CharsetMatch>();
        this.MungeInput();
        for (int i = 0; i < ALL_CS_RECOGNIZERS.size(); ++i) {
            CharsetMatch m;
            boolean active;
            CSRecognizerInfo rcinfo = ALL_CS_RECOGNIZERS.get(i);
            boolean bl = active = this.fEnabledRecognizers != null ? this.fEnabledRecognizers[i] : rcinfo.isDefaultEnabled;
            if (!active || (m = rcinfo.recognizer.match(this)) == null) continue;
            matches.add(m);
        }
        Collections.sort(matches);
        Collections.reverse(matches);
        CharsetMatch[] resultArray = new CharsetMatch[matches.size()];
        resultArray = matches.toArray(resultArray);
        return resultArray;
    }

    private final Reader $$robo$$android_icu_text_CharsetDetector$getReader(InputStream in, String declaredEncoding) {
        this.fDeclaredEncoding = declaredEncoding;
        try {
            this.setText(in);
            CharsetMatch match = this.detect();
            if (match == null) {
                return null;
            }
            return match.getReader();
        }
        catch (IOException e) {
            return null;
        }
    }

    private final String $$robo$$android_icu_text_CharsetDetector$getString(byte[] in, String declaredEncoding) {
        this.fDeclaredEncoding = declaredEncoding;
        try {
            this.setText(in);
            CharsetMatch match = this.detect();
            if (match == null) {
                return null;
            }
            return match.getString(-1);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static final String[] $$robo$$android_icu_text_CharsetDetector$getAllDetectableCharsets() {
        String[] allCharsetNames = new String[ALL_CS_RECOGNIZERS.size()];
        for (int i = 0; i < allCharsetNames.length; ++i) {
            allCharsetNames[i] = CharsetDetector.ALL_CS_RECOGNIZERS.get((int)i).recognizer.getName();
        }
        return allCharsetNames;
    }

    private final boolean $$robo$$android_icu_text_CharsetDetector$inputFilterEnabled() {
        return this.fStripTags;
    }

    private final boolean $$robo$$android_icu_text_CharsetDetector$enableInputFilter(boolean filter) {
        boolean previous = this.fStripTags;
        this.fStripTags = filter;
        return previous;
    }

    private final void $$robo$$android_icu_text_CharsetDetector$MungeInput() {
        int srci = 0;
        int dsti = 0;
        boolean inMarkup = false;
        int openTags = 0;
        int badTags = 0;
        if (this.fStripTags) {
            for (srci = 0; srci < this.fRawLength && dsti < this.fInputBytes.length; ++srci) {
                byte b = this.fRawInput[srci];
                if (b == 60) {
                    if (inMarkup) {
                        ++badTags;
                    }
                    inMarkup = true;
                    ++openTags;
                }
                if (!inMarkup) {
                    this.fInputBytes[dsti++] = b;
                }
                if (b != 62) continue;
                inMarkup = false;
            }
            this.fInputLen = dsti;
        }
        if (openTags < 5 || openTags / 5 < badTags || this.fInputLen < 100 && this.fRawLength > 600) {
            int limit = this.fRawLength;
            if (limit > 8000) {
                limit = 8000;
            }
            for (srci = 0; srci < limit; ++srci) {
                this.fInputBytes[srci] = this.fRawInput[srci];
            }
            this.fInputLen = srci;
        }
        Arrays.fill(this.fByteStats, (short)0);
        for (srci = 0; srci < this.fInputLen; ++srci) {
            int val;
            int n = val = this.fInputBytes[srci] & 0xFF;
            this.fByteStats[n] = (short)(this.fByteStats[n] + 1);
        }
        this.fC1Bytes = false;
        for (int i = 128; i <= 159; ++i) {
            if (this.fByteStats[i] == 0) continue;
            this.fC1Bytes = true;
            break;
        }
    }

    @Deprecated
    private final String[] $$robo$$android_icu_text_CharsetDetector$getDetectableCharsets() {
        ArrayList<String> csnames = new ArrayList<String>(ALL_CS_RECOGNIZERS.size());
        for (int i = 0; i < ALL_CS_RECOGNIZERS.size(); ++i) {
            boolean active;
            CSRecognizerInfo rcinfo = ALL_CS_RECOGNIZERS.get(i);
            boolean bl = active = this.fEnabledRecognizers == null ? rcinfo.isDefaultEnabled : this.fEnabledRecognizers[i];
            if (!active) continue;
            csnames.add(rcinfo.recognizer.getName());
        }
        return csnames.toArray(new String[csnames.size()]);
    }

    @Deprecated
    private final CharsetDetector $$robo$$android_icu_text_CharsetDetector$setDetectableCharset(String encoding, boolean enabled) {
        int i;
        int modIdx = -1;
        boolean isDefaultVal = false;
        for (i = 0; i < ALL_CS_RECOGNIZERS.size(); ++i) {
            CSRecognizerInfo csrinfo = ALL_CS_RECOGNIZERS.get(i);
            if (!csrinfo.recognizer.getName().equals(encoding)) continue;
            modIdx = i;
            isDefaultVal = csrinfo.isDefaultEnabled == enabled;
            break;
        }
        if (modIdx < 0) {
            throw new IllegalArgumentException("Invalid encoding: \"" + encoding + "\"");
        }
        if (this.fEnabledRecognizers == null && !isDefaultVal) {
            this.fEnabledRecognizers = new boolean[ALL_CS_RECOGNIZERS.size()];
            for (i = 0; i < ALL_CS_RECOGNIZERS.size(); ++i) {
                this.fEnabledRecognizers[i] = CharsetDetector.ALL_CS_RECOGNIZERS.get((int)i).isDefaultEnabled;
            }
        }
        if (this.fEnabledRecognizers != null) {
            this.fEnabledRecognizers[modIdx] = enabled;
        }
        return this;
    }

    static void __staticInitializer__() {
        ArrayList<CSRecognizerInfo> list = new ArrayList<CSRecognizerInfo>();
        list.add(new CSRecognizerInfo(new CharsetRecog_UTF8(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_16_BE(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_16_LE(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_32_BE(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_32_LE(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_sjis(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_2022.CharsetRecog_2022JP(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_2022.CharsetRecog_2022CN(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_2022.CharsetRecog_2022KR(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_gb_18030(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_euc.CharsetRecog_euc_jp(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_euc.CharsetRecog_euc_kr(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_big5(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_1(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_2(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_5_ru(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_6_ar(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_7_el(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_8_I_he(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_8_he(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_windows_1251(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_windows_1256(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_KOI8_R(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_9_tr(), true));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM424_he_rtl(), false));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM424_he_ltr(), false));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM420_ar_rtl(), false));
        list.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM420_ar_ltr(), false));
        ALL_CS_RECOGNIZERS = Collections.unmodifiableList(list);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_CharsetDetector$__constructor__();
    }

    public CharsetDetector() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetDetector$__constructor__(), 0, this);
    }

    public CharsetDetector setDeclaredEncoding(String string2) {
        return InvokeDynamicSupport.bootstrap("setDeclaredEncoding", $$robo$$android_icu_text_CharsetDetector$setDeclaredEncoding(java.lang.String ), 0, this, string2);
    }

    public CharsetDetector setText(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_CharsetDetector$setText(byte[] ), 0, this, byArray);
    }

    public CharsetDetector setText(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_CharsetDetector$setText(java.io.InputStream ), 0, this, inputStream);
    }

    public CharsetMatch detect() {
        return InvokeDynamicSupport.bootstrap("detect", $$robo$$android_icu_text_CharsetDetector$detect(), 0, this);
    }

    public CharsetMatch[] detectAll() {
        return InvokeDynamicSupport.bootstrap("detectAll", $$robo$$android_icu_text_CharsetDetector$detectAll(), 0, this);
    }

    public Reader getReader(InputStream inputStream, String string2) {
        return InvokeDynamicSupport.bootstrap("getReader", $$robo$$android_icu_text_CharsetDetector$getReader(java.io.InputStream java.lang.String ), 0, this, inputStream, string2);
    }

    public String getString(byte[] byArray, String string2) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_icu_text_CharsetDetector$getString(byte[] java.lang.String ), 0, this, byArray, string2);
    }

    public static String[] getAllDetectableCharsets() {
        return InvokeDynamicSupport.bootstrapStatic("getAllDetectableCharsets", $$robo$$android_icu_text_CharsetDetector$getAllDetectableCharsets(), 0);
    }

    public boolean inputFilterEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("inputFilterEnabled", $$robo$$android_icu_text_CharsetDetector$inputFilterEnabled(), 0, this);
    }

    public boolean enableInputFilter(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableInputFilter", $$robo$$android_icu_text_CharsetDetector$enableInputFilter(boolean ), 0, this, bl);
    }

    private void MungeInput() {
        InvokeDynamicSupport.bootstrap("MungeInput", $$robo$$android_icu_text_CharsetDetector$MungeInput(), 0, this);
    }

    @Deprecated
    public String[] getDetectableCharsets() {
        return InvokeDynamicSupport.bootstrap("getDetectableCharsets", $$robo$$android_icu_text_CharsetDetector$getDetectableCharsets(), 0, this);
    }

    @Deprecated
    public CharsetDetector setDetectableCharset(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("setDetectableCharset", $$robo$$android_icu_text_CharsetDetector$setDetectableCharset(java.lang.String boolean ), 0, this, string2, bl);
    }

    static {
        RobolectricInternals.classInitializing(CharsetDetector.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsetDetector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CSRecognizerInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CharsetRecognizer recognizer;
        boolean isDefaultEnabled;

        private void $$robo$$android_icu_text_CharsetDetector_CSRecognizerInfo$__constructor__(CharsetRecognizer recognizer, boolean isDefaultEnabled) {
            this.recognizer = recognizer;
            this.isDefaultEnabled = isDefaultEnabled;
        }

        private void __constructor__(CharsetRecognizer charsetRecognizer, boolean bl) {
            this.$$robo$$android_icu_text_CharsetDetector_CSRecognizerInfo$__constructor__(charsetRecognizer, bl);
        }

        CSRecognizerInfo(CharsetRecognizer charsetRecognizer, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetDetector_CSRecognizerInfo$__constructor__(android.icu.text.CharsetRecognizer boolean ), 0, this, charsetRecognizer, bl);
        }

        public /* synthetic */ CSRecognizerInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CSRecognizerInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

