/*
 * Decompiled with CFR 0.152.
 */
package android.icu.lang;

import android.icu.impl.CaseMapImpl;
import android.icu.impl.IllegalIcuArgumentException;
import android.icu.impl.Trie2;
import android.icu.impl.UBiDiProps;
import android.icu.impl.UCaseProps;
import android.icu.impl.UCharacterName;
import android.icu.impl.UCharacterProperty;
import android.icu.impl.UCharacterUtility;
import android.icu.impl.UPropertyAliases;
import android.icu.lang.UCharacterEnums;
import android.icu.lang.UCharacterNameIterator;
import android.icu.text.BreakIterator;
import android.icu.text.Edits;
import android.icu.text.Normalizer2;
import android.icu.util.RangeValueIterator;
import android.icu.util.ULocale;
import android.icu.util.ValueIterator;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UCharacter
implements UCharacterEnums.ECharacterCategory,
UCharacterEnums.ECharacterDirection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int MIN_VALUE = 0;
    public static int MAX_VALUE = 0x10FFFF;
    public static int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static int REPLACEMENT_CHAR = 65533;
    public static double NO_NUMERIC_VALUE = -1.23456789E8;
    public static int MIN_RADIX = 2;
    public static int MAX_RADIX = 36;
    public static int TITLECASE_NO_LOWERCASE = 256;
    public static int TITLECASE_NO_BREAK_ADJUSTMENT = 512;
    private static int BREAK_MASK = 560;
    public static int FOLD_CASE_DEFAULT = 0;
    public static int FOLD_CASE_EXCLUDE_SPECIAL_I = 1;
    public static char MIN_HIGH_SURROGATE = '\ud800';
    public static char MAX_HIGH_SURROGATE = '\udbff';
    public static char MIN_LOW_SURROGATE = '\udc00';
    public static char MAX_LOW_SURROGATE = '\udfff';
    public static char MIN_SURROGATE = '\ud800';
    public static char MAX_SURROGATE = '\udfff';
    public static int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static int MAX_CODE_POINT = 0x10FFFF;
    public static int MIN_CODE_POINT = 0;
    private static int LAST_CHAR_MASK_ = 65535;
    private static int NO_BREAK_SPACE_ = 160;
    private static int FIGURE_SPACE_ = 8199;
    private static int NARROW_NO_BREAK_SPACE_ = 8239;
    private static int IDEOGRAPHIC_NUMBER_ZERO_ = 12295;
    private static int CJK_IDEOGRAPH_FIRST_ = 19968;
    private static int CJK_IDEOGRAPH_SECOND_ = 20108;
    private static int CJK_IDEOGRAPH_THIRD_ = 19977;
    private static int CJK_IDEOGRAPH_FOURTH_ = 22235;
    private static int CJK_IDEOGRAPH_FIFTH_ = 20116;
    private static int CJK_IDEOGRAPH_SIXTH_ = 20845;
    private static int CJK_IDEOGRAPH_SEVENTH_ = 19971;
    private static int CJK_IDEOGRAPH_EIGHTH_ = 20843;
    private static int CJK_IDEOGRAPH_NINETH_ = 20061;
    private static int APPLICATION_PROGRAM_COMMAND_ = 159;
    private static int UNIT_SEPARATOR_ = 31;
    private static int DELETE_ = 127;
    private static int CJK_IDEOGRAPH_COMPLEX_ZERO_ = 38646;
    private static int CJK_IDEOGRAPH_COMPLEX_ONE_ = 22777;
    private static int CJK_IDEOGRAPH_COMPLEX_TWO_ = 36019;
    private static int CJK_IDEOGRAPH_COMPLEX_THREE_ = 21443;
    private static int CJK_IDEOGRAPH_COMPLEX_FOUR_ = 32902;
    private static int CJK_IDEOGRAPH_COMPLEX_FIVE_ = 20237;
    private static int CJK_IDEOGRAPH_COMPLEX_SIX_ = 38520;
    private static int CJK_IDEOGRAPH_COMPLEX_SEVEN_ = 26578;
    private static int CJK_IDEOGRAPH_COMPLEX_EIGHT_ = 25420;
    private static int CJK_IDEOGRAPH_COMPLEX_NINE_ = 29590;
    private static int CJK_IDEOGRAPH_TEN_ = 21313;
    private static int CJK_IDEOGRAPH_COMPLEX_TEN_ = 25342;
    private static int CJK_IDEOGRAPH_HUNDRED_ = 30334;
    private static int CJK_IDEOGRAPH_COMPLEX_HUNDRED_ = 20336;
    private static int CJK_IDEOGRAPH_THOUSAND_ = 21315;
    private static int CJK_IDEOGRAPH_COMPLEX_THOUSAND_ = 20191;
    private static int CJK_IDEOGRAPH_TEN_THOUSAND_ = 33356;
    private static int CJK_IDEOGRAPH_HUNDRED_MILLION_ = 20740;

    private static final int $$robo$$android_icu_lang_UCharacter$digit(int ch, int radix) {
        if (2 <= radix && radix <= 36) {
            int value = UCharacter.digit(ch);
            if (value < 0) {
                value = UCharacterProperty.getEuropeanDigit(ch);
            }
            return value < radix ? value : -1;
        }
        return -1;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$digit(int ch) {
        return UCharacterProperty.INSTANCE.digit(ch);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getNumericValue(int ch) {
        return UCharacterProperty.INSTANCE.getNumericValue(ch);
    }

    private static final double $$robo$$android_icu_lang_UCharacter$getUnicodeNumericValue(int ch) {
        return UCharacterProperty.INSTANCE.getUnicodeNumericValue(ch);
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_lang_UCharacter$isSpace(int ch) {
        return ch <= 32 && (ch == 32 || ch == 9 || ch == 10 || ch == 12 || ch == 13);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getType(int ch) {
        return UCharacterProperty.INSTANCE.getType(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isDefined(int ch) {
        return UCharacter.getType(ch) != 0;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isDigit(int ch) {
        return UCharacter.getType(ch) == 9;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isISOControl(int ch) {
        return ch >= 0 && ch <= 159 && (ch <= 31 || ch >= 127);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isLetter(int ch) {
        return (1 << UCharacter.getType(ch) & 0x3E) != 0;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isLetterOrDigit(int ch) {
        return (1 << UCharacter.getType(ch) & 0x23E) != 0;
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_lang_UCharacter$isJavaLetter(int cp) {
        return UCharacter.isJavaIdentifierStart(cp);
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_lang_UCharacter$isJavaLetterOrDigit(int cp) {
        return UCharacter.isJavaIdentifierPart(cp);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isJavaIdentifierStart(int cp) {
        return Character.isJavaIdentifierStart((char)cp);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isJavaIdentifierPart(int cp) {
        return Character.isJavaIdentifierPart((char)cp);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isLowerCase(int ch) {
        return UCharacter.getType(ch) == 2;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isWhitespace(int ch) {
        return (1 << UCharacter.getType(ch) & 0x7000) != 0 && ch != 160 && ch != 8199 && ch != 8239 || ch >= 9 && ch <= 13 || ch >= 28 && ch <= 31;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isSpaceChar(int ch) {
        return (1 << UCharacter.getType(ch) & 0x7000) != 0;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isTitleCase(int ch) {
        return UCharacter.getType(ch) == 3;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isUnicodeIdentifierPart(int ch) {
        return (1 << UCharacter.getType(ch) & 0x40077E) != 0 || UCharacter.isIdentifierIgnorable(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isUnicodeIdentifierStart(int ch) {
        return (1 << UCharacter.getType(ch) & 0x43E) != 0;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isIdentifierIgnorable(int ch) {
        if (ch <= 159) {
            return !(!UCharacter.isISOControl(ch) || ch >= 9 && ch <= 13 || ch >= 28 && ch <= 31);
        }
        return UCharacter.getType(ch) == 16;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isUpperCase(int ch) {
        return UCharacter.getType(ch) == 1;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$toLowerCase(int ch) {
        return UCaseProps.INSTANCE.tolower(ch);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toString(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            return null;
        }
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        return new String(Character.toChars(ch));
    }

    private static final int $$robo$$android_icu_lang_UCharacter$toTitleCase(int ch) {
        return UCaseProps.INSTANCE.totitle(ch);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$toUpperCase(int ch) {
        return UCaseProps.INSTANCE.toupper(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isSupplementary(int ch) {
        return ch >= 65536 && ch <= 0x10FFFF;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isBMP(int ch) {
        return ch >= 0 && ch <= 65535;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isPrintable(int ch) {
        int cat = UCharacter.getType(ch);
        return cat != 0 && cat != 15 && cat != 16 && cat != 17 && cat != 18 && cat != 0;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isBaseForm(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 9 || cat == 11 || cat == 10 || cat == 1 || cat == 2 || cat == 3 || cat == 4 || cat == 5 || cat == 6 || cat == 7 || cat == 8;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getDirection(int ch) {
        return UBiDiProps.INSTANCE.getClass(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isMirrored(int ch) {
        return UBiDiProps.INSTANCE.isMirrored(ch);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getMirror(int ch) {
        return UBiDiProps.INSTANCE.getMirror(ch);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getBidiPairedBracket(int c) {
        return UBiDiProps.INSTANCE.getPairedBracket(c);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCombiningClass(int ch) {
        return Normalizer2.getNFDInstance().getCombiningClass(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isLegal(int ch) {
        if (ch < 0) {
            return false;
        }
        if (ch < 55296) {
            return true;
        }
        if (ch <= 57343) {
            return false;
        }
        if (UCharacterUtility.isNonCharacter(ch)) {
            return false;
        }
        return ch <= 0x10FFFF;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isLegal(String str) {
        int codepoint;
        int size = str.length();
        for (int i = 0; i < size; i += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(i);
            if (UCharacter.isLegal(codepoint)) continue;
            return false;
        }
        return true;
    }

    private static final VersionInfo $$robo$$android_icu_lang_UCharacter$getUnicodeVersion() {
        return UCharacterProperty.INSTANCE.m_unicodeVersion_;
    }

    private static final String $$robo$$android_icu_lang_UCharacter$getName(int ch) {
        return UCharacterName.INSTANCE.getName(ch, 0);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$getName(String s, String separator) {
        int cp;
        if (s.length() == 1) {
            return UCharacter.getName(s.charAt(0));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(UCharacter.getName(cp));
        }
        return sb.toString();
    }

    @Deprecated
    private static final String $$robo$$android_icu_lang_UCharacter$getName1_0(int ch) {
        return null;
    }

    private static final String $$robo$$android_icu_lang_UCharacter$getExtendedName(int ch) {
        return UCharacterName.INSTANCE.getName(ch, 2);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$getNameAlias(int ch) {
        return UCharacterName.INSTANCE.getName(ch, 3);
    }

    @Deprecated
    private static final String $$robo$$android_icu_lang_UCharacter$getISOComment(int ch) {
        return null;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCharFromName(String name) {
        return UCharacterName.INSTANCE.getCharFromName(0, name);
    }

    @Deprecated
    private static final int $$robo$$android_icu_lang_UCharacter$getCharFromName1_0(String name) {
        return -1;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCharFromExtendedName(String name) {
        return UCharacterName.INSTANCE.getCharFromName(2, name);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCharFromNameAlias(String name) {
        return UCharacterName.INSTANCE.getCharFromName(3, name);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$getPropertyName(int property, int nameChoice) {
        return UPropertyAliases.INSTANCE.getPropertyName(property, nameChoice);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getPropertyEnum(CharSequence propertyAlias) {
        int propEnum = UPropertyAliases.INSTANCE.getPropertyEnum(propertyAlias);
        if (propEnum == -1) {
            throw new IllegalIcuArgumentException("Invalid name: " + propertyAlias);
        }
        return propEnum;
    }

    private static final String $$robo$$android_icu_lang_UCharacter$getPropertyValueName(int property, int value, int nameChoice) {
        if ((property == 4098 || property == 4112 || property == 4113) && value >= UCharacter.getIntPropertyMinValue(4098) && value <= UCharacter.getIntPropertyMaxValue(4098) && nameChoice >= 0 && nameChoice < 2) {
            try {
                return UPropertyAliases.INSTANCE.getPropertyValueName(property, value, nameChoice);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return UPropertyAliases.INSTANCE.getPropertyValueName(property, value, nameChoice);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getPropertyValueEnum(int property, CharSequence valueAlias) {
        int propEnum = UPropertyAliases.INSTANCE.getPropertyValueEnum(property, valueAlias);
        if (propEnum == -1) {
            throw new IllegalIcuArgumentException("Invalid name: " + valueAlias);
        }
        return propEnum;
    }

    @Deprecated
    private static final int $$robo$$android_icu_lang_UCharacter$getPropertyValueEnumNoThrow(int property, CharSequence valueAlias) {
        return UPropertyAliases.INSTANCE.getPropertyValueEnumNoThrow(property, valueAlias);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCodePoint(char lead, char trail) {
        if (Character.isSurrogatePair(lead, trail)) {
            return Character.toCodePoint(lead, trail);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCodePoint(char char16) {
        if (UCharacter.isLegal(char16)) {
            return char16;
        }
        throw new IllegalArgumentException("Illegal codepoint");
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toUpperCase(String str) {
        return UCharacter.toUpperCase(UCharacter.getDefaultCaseLocale(), str);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toLowerCase(String str) {
        return UCharacter.toLowerCase(UCharacter.getDefaultCaseLocale(), str);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toTitleCase(String str, BreakIterator breakiter) {
        return UCharacter.toTitleCase(Locale.getDefault(), str, breakiter, 0);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getDefaultCaseLocale() {
        return UCaseProps.getCaseLocale(Locale.getDefault());
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCaseLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return UCaseProps.getCaseLocale(locale);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getCaseLocale(ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return UCaseProps.getCaseLocale(locale);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toLowerCase(int caseLocale, String str) {
        if (str.length() <= 100) {
            if (str.isEmpty()) {
                return str;
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.toLower(caseLocale, 16384, str, new StringBuilder(), edits);
            return UCharacter.applyEdits(str, replacementChars, edits);
        }
        return CaseMapImpl.toLower(caseLocale, 0, str, new StringBuilder(str.length()), null).toString();
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toUpperCase(int caseLocale, String str) {
        if (str.length() <= 100) {
            if (str.isEmpty()) {
                return str;
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.toUpper(caseLocale, 16384, str, new StringBuilder(), edits);
            return UCharacter.applyEdits(str, replacementChars, edits);
        }
        return CaseMapImpl.toUpper(caseLocale, 0, str, new StringBuilder(str.length()), null).toString();
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toTitleCase(int caseLocale, int options, BreakIterator titleIter, String str) {
        if (str.length() <= 100) {
            if (str.isEmpty()) {
                return str;
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.toTitle(caseLocale, options | 0x4000, titleIter, str, new StringBuilder(), edits);
            return UCharacter.applyEdits(str, replacementChars, edits);
        }
        return CaseMapImpl.toTitle(caseLocale, options, titleIter, str, new StringBuilder(str.length()), null).toString();
    }

    private static final String $$robo$$android_icu_lang_UCharacter$applyEdits(String str, StringBuilder replacementChars, Edits edits) {
        if (!edits.hasChanges()) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length() + edits.lengthDelta());
        Edits.Iterator ei = edits.getCoarseIterator();
        while (ei.next()) {
            int i;
            if (ei.hasChange()) {
                i = ei.replacementIndex();
                result.append(replacementChars, i, i + ei.newLength());
                continue;
            }
            i = ei.sourceIndex();
            result.append(str, i, i + ei.oldLength());
        }
        return result.toString();
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toUpperCase(Locale locale, String str) {
        return UCharacter.toUpperCase(UCharacter.getCaseLocale(locale), str);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toUpperCase(ULocale locale, String str) {
        return UCharacter.toUpperCase(UCharacter.getCaseLocale(locale), str);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toLowerCase(Locale locale, String str) {
        return UCharacter.toLowerCase(UCharacter.getCaseLocale(locale), str);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toLowerCase(ULocale locale, String str) {
        return UCharacter.toLowerCase(UCharacter.getCaseLocale(locale), str);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toTitleCase(Locale locale, String str, BreakIterator breakiter) {
        return UCharacter.toTitleCase(locale, str, breakiter, 0);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toTitleCase(ULocale locale, String str, BreakIterator titleIter) {
        return UCharacter.toTitleCase(locale, str, titleIter, 0);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toTitleCase(ULocale locale, String str, BreakIterator titleIter, int options) {
        if (titleIter == null) {
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            titleIter = BreakIterator.getWordInstance(locale);
        }
        titleIter.setText(str);
        return UCharacter.toTitleCase(UCharacter.getCaseLocale(locale), options, titleIter, str);
    }

    @Deprecated
    private static final String $$robo$$android_icu_lang_UCharacter$toTitleFirst(ULocale locale, String str) {
        int propertyMask;
        int c = 0;
        for (int i = 0; i < str.length() && ((propertyMask = UCharacter.getIntPropertyValue(c = UCharacter.codePointAt(str, i), 8192)) & 0x230) == 0; i += UCharacter.charCount(c)) {
            int startOfSuffix;
            if (UCaseProps.INSTANCE.getType(c) == 0) continue;
            String substring = str.substring(i, i + UCharacter.charCount(c));
            String titled = UCharacter.toTitleCase(locale, substring, BreakIterator.getSentenceInstance(locale), 0);
            if (titled.codePointAt(0) == c) break;
            StringBuilder result = new StringBuilder(str.length()).append(str, 0, i);
            if (c == 105 && locale.getLanguage().equals("nl") && i < str.length() && str.charAt(i + 1) == 'j') {
                result.append("IJ");
                startOfSuffix = 2;
            } else {
                result.append(titled);
                startOfSuffix = i + UCharacter.charCount(c);
            }
            return result.append(str, startOfSuffix, str.length()).toString();
        }
        return str;
    }

    private static final String $$robo$$android_icu_lang_UCharacter$toTitleCase(Locale locale, String str, BreakIterator titleIter, int options) {
        if (titleIter == null) {
            titleIter = BreakIterator.getWordInstance(locale);
        }
        titleIter.setText(str);
        return UCharacter.toTitleCase(UCharacter.getCaseLocale(locale), options, titleIter, str);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$foldCase(int ch, boolean defaultmapping) {
        return UCharacter.foldCase(ch, defaultmapping ? 0 : 1);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$foldCase(String str, boolean defaultmapping) {
        return UCharacter.foldCase(str, defaultmapping ? 0 : 1);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$foldCase(int ch, int options) {
        return UCaseProps.INSTANCE.fold(ch, options);
    }

    private static final String $$robo$$android_icu_lang_UCharacter$foldCase(String str, int options) {
        if (str.length() <= 100) {
            if (str.isEmpty()) {
                return str;
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.fold(options | 0x4000, str, new StringBuilder(), edits);
            return UCharacter.applyEdits(str, replacementChars, edits);
        }
        return CaseMapImpl.fold(options, str, new StringBuilder(str.length()), null).toString();
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getHanNumericValue(int ch) {
        switch (ch) {
            case 12295: 
            case 38646: {
                return 0;
            }
            case 19968: 
            case 22777: {
                return 1;
            }
            case 20108: 
            case 36019: {
                return 2;
            }
            case 19977: 
            case 21443: {
                return 3;
            }
            case 22235: 
            case 32902: {
                return 4;
            }
            case 20116: 
            case 20237: {
                return 5;
            }
            case 20845: 
            case 38520: {
                return 6;
            }
            case 19971: 
            case 26578: {
                return 7;
            }
            case 20843: 
            case 25420: {
                return 8;
            }
            case 20061: 
            case 29590: {
                return 9;
            }
            case 21313: 
            case 25342: {
                return 10;
            }
            case 20336: 
            case 30334: {
                return 100;
            }
            case 20191: 
            case 21315: {
                return 1000;
            }
            case 33356: {
                return 10000;
            }
            case 20740: {
                return 100000000;
            }
        }
        return -1;
    }

    private static final RangeValueIterator $$robo$$android_icu_lang_UCharacter$getTypeIterator() {
        return new UCharacterTypeIterator();
    }

    private static final ValueIterator $$robo$$android_icu_lang_UCharacter$getNameIterator() {
        return new UCharacterNameIterator(UCharacterName.INSTANCE, 0);
    }

    @Deprecated
    private static final ValueIterator $$robo$$android_icu_lang_UCharacter$getName1_0Iterator() {
        return new DummyValueIterator();
    }

    private static final ValueIterator $$robo$$android_icu_lang_UCharacter$getExtendedNameIterator() {
        return new UCharacterNameIterator(UCharacterName.INSTANCE, 2);
    }

    private static final VersionInfo $$robo$$android_icu_lang_UCharacter$getAge(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return UCharacterProperty.INSTANCE.getAge(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$hasBinaryProperty(int ch, int property) {
        return UCharacterProperty.INSTANCE.hasBinaryProperty(ch, property);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isUAlphabetic(int ch) {
        return UCharacter.hasBinaryProperty(ch, 0);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isULowercase(int ch) {
        return UCharacter.hasBinaryProperty(ch, 22);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isUUppercase(int ch) {
        return UCharacter.hasBinaryProperty(ch, 30);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isUWhiteSpace(int ch) {
        return UCharacter.hasBinaryProperty(ch, 31);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getIntPropertyValue(int ch, int type) {
        return UCharacterProperty.INSTANCE.getIntPropertyValue(ch, type);
    }

    @Deprecated
    private static final String $$robo$$android_icu_lang_UCharacter$getStringPropertyValue(int propertyEnum, int codepoint, int nameChoice) {
        if (propertyEnum >= 0 && propertyEnum < 61 || propertyEnum >= 4096 && propertyEnum < 4118) {
            return UCharacter.getPropertyValueName(propertyEnum, UCharacter.getIntPropertyValue(codepoint, propertyEnum), nameChoice);
        }
        if (propertyEnum == 12288) {
            return String.valueOf(UCharacter.getUnicodeNumericValue(codepoint));
        }
        switch (propertyEnum) {
            case 16384: {
                return UCharacter.getAge(codepoint).toString();
            }
            case 16387: {
                return UCharacter.getISOComment(codepoint);
            }
            case 16385: {
                return UCharacter.toString(UCharacter.getMirror(codepoint));
            }
            case 16386: {
                return UCharacter.toString(UCharacter.foldCase(codepoint, true));
            }
            case 16388: {
                return UCharacter.toString(UCharacter.toLowerCase(codepoint));
            }
            case 16389: {
                return UCharacter.getName(codepoint);
            }
            case 16390: {
                return UCharacter.toString(UCharacter.foldCase(codepoint, true));
            }
            case 16391: {
                return UCharacter.toString(UCharacter.toLowerCase(codepoint));
            }
            case 16392: {
                return UCharacter.toString(UCharacter.toTitleCase(codepoint));
            }
            case 16393: {
                return UCharacter.toString(UCharacter.toUpperCase(codepoint));
            }
            case 16394: {
                return UCharacter.toString(UCharacter.toTitleCase(codepoint));
            }
            case 16395: {
                return UCharacter.getName1_0(codepoint);
            }
            case 16396: {
                return UCharacter.toString(UCharacter.toUpperCase(codepoint));
            }
        }
        throw new IllegalArgumentException("Illegal Property Enum");
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getIntPropertyMinValue(int type) {
        return 0;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$getIntPropertyMaxValue(int type) {
        return UCharacterProperty.INSTANCE.getIntPropertyMaxValue(type);
    }

    private static final char $$robo$$android_icu_lang_UCharacter$forDigit(int digit, int radix) {
        return Character.forDigit(digit, radix);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isValidCodePoint(int cp) {
        return cp >= 0 && cp <= 0x10FFFF;
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isSupplementaryCodePoint(int cp) {
        return Character.isSupplementaryCodePoint(cp);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isHighSurrogate(char ch) {
        return Character.isHighSurrogate(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isLowSurrogate(char ch) {
        return Character.isLowSurrogate(ch);
    }

    private static final boolean $$robo$$android_icu_lang_UCharacter$isSurrogatePair(char high, char low) {
        return Character.isSurrogatePair(high, low);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$charCount(int cp) {
        return Character.charCount(cp);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$toCodePoint(char high, char low) {
        return Character.toCodePoint(high, low);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointAt(CharSequence seq, int index) {
        char c2;
        char c1;
        if (UCharacter.isHighSurrogate(c1 = seq.charAt(index++)) && index < seq.length() && UCharacter.isLowSurrogate(c2 = seq.charAt(index))) {
            return UCharacter.toCodePoint(c1, c2);
        }
        return c1;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointAt(char[] text, int index) {
        char c2;
        char c1;
        if (UCharacter.isHighSurrogate(c1 = text[index++]) && index < text.length && UCharacter.isLowSurrogate(c2 = text[index])) {
            return UCharacter.toCodePoint(c1, c2);
        }
        return c1;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointAt(char[] text, int index, int limit) {
        char c2;
        char c1;
        if (index >= limit || limit > text.length) {
            throw new IndexOutOfBoundsException();
        }
        if (UCharacter.isHighSurrogate(c1 = text[index++]) && index < limit && UCharacter.isLowSurrogate(c2 = text[index])) {
            return UCharacter.toCodePoint(c1, c2);
        }
        return c1;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointBefore(CharSequence seq, int index) {
        char c1;
        char c2;
        if (UCharacter.isLowSurrogate(c2 = seq.charAt(--index)) && index > 0 && UCharacter.isHighSurrogate(c1 = seq.charAt(--index))) {
            return UCharacter.toCodePoint(c1, c2);
        }
        return c2;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointBefore(char[] text, int index) {
        char c1;
        char c2;
        if (UCharacter.isLowSurrogate(c2 = text[--index]) && index > 0 && UCharacter.isHighSurrogate(c1 = text[--index])) {
            return UCharacter.toCodePoint(c1, c2);
        }
        return c2;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointBefore(char[] text, int index, int limit) {
        char c1;
        char c2;
        if (index <= limit || limit < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (UCharacter.isLowSurrogate(c2 = text[--index]) && index > limit && UCharacter.isHighSurrogate(c1 = text[--index])) {
            return UCharacter.toCodePoint(c1, c2);
        }
        return c2;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$toChars(int cp, char[] dst, int dstIndex) {
        return Character.toChars(cp, dst, dstIndex);
    }

    private static final char[] $$robo$$android_icu_lang_UCharacter$toChars(int cp) {
        return Character.toChars(cp);
    }

    private static final byte $$robo$$android_icu_lang_UCharacter$getDirectionality(int cp) {
        return (byte)UCharacter.getDirection(cp);
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointCount(CharSequence text, int start, int limit) {
        if (start < 0 || limit < start || limit > text.length()) {
            throw new IndexOutOfBoundsException("start (" + start + ") or limit (" + limit + ") invalid or out of range 0, " + text.length());
        }
        int len = limit - start;
        block0: while (limit > start) {
            char ch = text.charAt(--limit);
            while (ch >= '\udc00' && ch <= '\udfff' && limit > start) {
                if ((ch = text.charAt(--limit)) < '\ud800' || ch > '\udbff') continue;
                --len;
                continue block0;
            }
        }
        return len;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$codePointCount(char[] text, int start, int limit) {
        if (start < 0 || limit < start || limit > text.length) {
            throw new IndexOutOfBoundsException("start (" + start + ") or limit (" + limit + ") invalid or out of range 0, " + text.length);
        }
        int len = limit - start;
        block0: while (limit > start) {
            char ch = text[--limit];
            while (ch >= '\udc00' && ch <= '\udfff' && limit > start) {
                if ((ch = text[--limit]) < '\ud800' || ch > '\udbff') continue;
                --len;
                continue block0;
            }
        }
        return len;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$offsetByCodePoints(CharSequence text, int index, int codePointOffset) {
        if (index < 0 || index > text.length()) {
            throw new IndexOutOfBoundsException("index ( " + index + ") out of range 0, " + text.length());
        }
        if (codePointOffset < 0) {
            while (++codePointOffset <= 0) {
                char ch = text.charAt(--index);
                while (ch >= '\udc00' && ch <= '\udfff' && index > 0) {
                    if ((ch = text.charAt(--index)) >= '\ud800' && ch <= '\udbff' || ++codePointOffset <= 0) continue;
                    return index + 1;
                }
            }
        } else {
            int limit = text.length();
            while (--codePointOffset >= 0) {
                char ch = text.charAt(index++);
                while (ch >= '\ud800' && ch <= '\udbff' && index < limit) {
                    if ((ch = text.charAt(index++)) >= '\udc00' && ch <= '\udfff' || --codePointOffset >= 0) continue;
                    return index - 1;
                }
            }
        }
        return index;
    }

    private static final int $$robo$$android_icu_lang_UCharacter$offsetByCodePoints(char[] text, int start, int count, int index, int codePointOffset) {
        int limit = start + count;
        if (start < 0 || limit < start || limit > text.length || index < start || index > limit) {
            throw new IndexOutOfBoundsException("index ( " + index + ") out of range " + start + ", " + limit + " in array 0, " + text.length);
        }
        if (codePointOffset < 0) {
            while (++codePointOffset <= 0) {
                char ch = text[--index];
                if (index < start) {
                    throw new IndexOutOfBoundsException("index ( " + index + ") < start (" + start + ")");
                }
                while (ch >= '\udc00' && ch <= '\udfff' && index > start) {
                    if ((ch = text[--index]) >= '\ud800' && ch <= '\udbff' || ++codePointOffset <= 0) continue;
                    return index + 1;
                }
            }
        } else {
            while (--codePointOffset >= 0) {
                char ch = text[index++];
                if (index > limit) {
                    throw new IndexOutOfBoundsException("index ( " + index + ") > limit (" + limit + ")");
                }
                while (ch >= '\ud800' && ch <= '\udbff' && index < limit) {
                    if ((ch = text[index++]) >= '\udc00' && ch <= '\udfff' || --codePointOffset >= 0) continue;
                    return index - 1;
                }
            }
        }
        return index;
    }

    private void $$robo$$android_icu_lang_UCharacter$__constructor__() {
    }

    public static int digit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("digit", $$robo$$android_icu_lang_UCharacter$digit(int int ), 0, (int)n, (int)n2);
    }

    public static int digit(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("digit", $$robo$$android_icu_lang_UCharacter$digit(int ), 0, (int)n);
    }

    public static int getNumericValue(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNumericValue", $$robo$$android_icu_lang_UCharacter$getNumericValue(int ), 0, (int)n);
    }

    public static double getUnicodeNumericValue(int n) {
        return (double)InvokeDynamicSupport.bootstrapStatic("getUnicodeNumericValue", $$robo$$android_icu_lang_UCharacter$getUnicodeNumericValue(int ), 0, (int)n);
    }

    @Deprecated
    public static boolean isSpace(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSpace", $$robo$$android_icu_lang_UCharacter$isSpace(int ), 0, (int)n);
    }

    public static int getType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getType", $$robo$$android_icu_lang_UCharacter$getType(int ), 0, (int)n);
    }

    public static boolean isDefined(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDefined", $$robo$$android_icu_lang_UCharacter$isDefined(int ), 0, (int)n);
    }

    public static boolean isDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDigit", $$robo$$android_icu_lang_UCharacter$isDigit(int ), 0, (int)n);
    }

    public static boolean isISOControl(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isISOControl", $$robo$$android_icu_lang_UCharacter$isISOControl(int ), 0, (int)n);
    }

    public static boolean isLetter(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLetter", $$robo$$android_icu_lang_UCharacter$isLetter(int ), 0, (int)n);
    }

    public static boolean isLetterOrDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLetterOrDigit", $$robo$$android_icu_lang_UCharacter$isLetterOrDigit(int ), 0, (int)n);
    }

    @Deprecated
    public static boolean isJavaLetter(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJavaLetter", $$robo$$android_icu_lang_UCharacter$isJavaLetter(int ), 0, (int)n);
    }

    @Deprecated
    public static boolean isJavaLetterOrDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJavaLetterOrDigit", $$robo$$android_icu_lang_UCharacter$isJavaLetterOrDigit(int ), 0, (int)n);
    }

    public static boolean isJavaIdentifierStart(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJavaIdentifierStart", $$robo$$android_icu_lang_UCharacter$isJavaIdentifierStart(int ), 0, (int)n);
    }

    public static boolean isJavaIdentifierPart(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJavaIdentifierPart", $$robo$$android_icu_lang_UCharacter$isJavaIdentifierPart(int ), 0, (int)n);
    }

    public static boolean isLowerCase(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLowerCase", $$robo$$android_icu_lang_UCharacter$isLowerCase(int ), 0, (int)n);
    }

    public static boolean isWhitespace(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWhitespace", $$robo$$android_icu_lang_UCharacter$isWhitespace(int ), 0, (int)n);
    }

    public static boolean isSpaceChar(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSpaceChar", $$robo$$android_icu_lang_UCharacter$isSpaceChar(int ), 0, (int)n);
    }

    public static boolean isTitleCase(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTitleCase", $$robo$$android_icu_lang_UCharacter$isTitleCase(int ), 0, (int)n);
    }

    public static boolean isUnicodeIdentifierPart(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUnicodeIdentifierPart", $$robo$$android_icu_lang_UCharacter$isUnicodeIdentifierPart(int ), 0, (int)n);
    }

    public static boolean isUnicodeIdentifierStart(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUnicodeIdentifierStart", $$robo$$android_icu_lang_UCharacter$isUnicodeIdentifierStart(int ), 0, (int)n);
    }

    public static boolean isIdentifierIgnorable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIdentifierIgnorable", $$robo$$android_icu_lang_UCharacter$isIdentifierIgnorable(int ), 0, (int)n);
    }

    public static boolean isUpperCase(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUpperCase", $$robo$$android_icu_lang_UCharacter$isUpperCase(int ), 0, (int)n);
    }

    public static int toLowerCase(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$android_icu_lang_UCharacter$toLowerCase(int ), 0, (int)n);
    }

    public static String toString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$android_icu_lang_UCharacter$toString(int ), 0, (int)n);
    }

    public static int toTitleCase(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toTitleCase", $$robo$$android_icu_lang_UCharacter$toTitleCase(int ), 0, (int)n);
    }

    public static int toUpperCase(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toUpperCase", $$robo$$android_icu_lang_UCharacter$toUpperCase(int ), 0, (int)n);
    }

    public static boolean isSupplementary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupplementary", $$robo$$android_icu_lang_UCharacter$isSupplementary(int ), 0, (int)n);
    }

    public static boolean isBMP(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBMP", $$robo$$android_icu_lang_UCharacter$isBMP(int ), 0, (int)n);
    }

    public static boolean isPrintable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrintable", $$robo$$android_icu_lang_UCharacter$isPrintable(int ), 0, (int)n);
    }

    public static boolean isBaseForm(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBaseForm", $$robo$$android_icu_lang_UCharacter$isBaseForm(int ), 0, (int)n);
    }

    public static int getDirection(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDirection", $$robo$$android_icu_lang_UCharacter$getDirection(int ), 0, (int)n);
    }

    public static boolean isMirrored(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMirrored", $$robo$$android_icu_lang_UCharacter$isMirrored(int ), 0, (int)n);
    }

    public static int getMirror(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMirror", $$robo$$android_icu_lang_UCharacter$getMirror(int ), 0, (int)n);
    }

    public static int getBidiPairedBracket(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBidiPairedBracket", $$robo$$android_icu_lang_UCharacter$getBidiPairedBracket(int ), 0, (int)n);
    }

    public static int getCombiningClass(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCombiningClass", $$robo$$android_icu_lang_UCharacter$getCombiningClass(int ), 0, (int)n);
    }

    public static boolean isLegal(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLegal", $$robo$$android_icu_lang_UCharacter$isLegal(int ), 0, (int)n);
    }

    public static boolean isLegal(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLegal", $$robo$$android_icu_lang_UCharacter$isLegal(java.lang.String ), 0, (String)string2);
    }

    public static VersionInfo getUnicodeVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getUnicodeVersion", $$robo$$android_icu_lang_UCharacter$getUnicodeVersion(), 0);
    }

    public static String getName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getName", $$robo$$android_icu_lang_UCharacter$getName(int ), 0, (int)n);
    }

    public static String getName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getName", $$robo$$android_icu_lang_UCharacter$getName(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    @Deprecated
    public static String getName1_0(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getName1_0", $$robo$$android_icu_lang_UCharacter$getName1_0(int ), 0, (int)n);
    }

    public static String getExtendedName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getExtendedName", $$robo$$android_icu_lang_UCharacter$getExtendedName(int ), 0, (int)n);
    }

    public static String getNameAlias(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNameAlias", $$robo$$android_icu_lang_UCharacter$getNameAlias(int ), 0, (int)n);
    }

    @Deprecated
    public static String getISOComment(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getISOComment", $$robo$$android_icu_lang_UCharacter$getISOComment(int ), 0, (int)n);
    }

    public static int getCharFromName(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCharFromName", $$robo$$android_icu_lang_UCharacter$getCharFromName(java.lang.String ), 0, (String)string2);
    }

    @Deprecated
    public static int getCharFromName1_0(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCharFromName1_0", $$robo$$android_icu_lang_UCharacter$getCharFromName1_0(java.lang.String ), 0, (String)string2);
    }

    public static int getCharFromExtendedName(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCharFromExtendedName", $$robo$$android_icu_lang_UCharacter$getCharFromExtendedName(java.lang.String ), 0, (String)string2);
    }

    public static int getCharFromNameAlias(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCharFromNameAlias", $$robo$$android_icu_lang_UCharacter$getCharFromNameAlias(java.lang.String ), 0, (String)string2);
    }

    public static String getPropertyName(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getPropertyName", $$robo$$android_icu_lang_UCharacter$getPropertyName(int int ), 0, (int)n, (int)n2);
    }

    public static int getPropertyEnum(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPropertyEnum", $$robo$$android_icu_lang_UCharacter$getPropertyEnum(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static String getPropertyValueName(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("getPropertyValueName", $$robo$$android_icu_lang_UCharacter$getPropertyValueName(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public static int getPropertyValueEnum(int n, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPropertyValueEnum", $$robo$$android_icu_lang_UCharacter$getPropertyValueEnum(int java.lang.CharSequence ), 0, (int)n, (CharSequence)charSequence);
    }

    @Deprecated
    public static int getPropertyValueEnumNoThrow(int n, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPropertyValueEnumNoThrow", $$robo$$android_icu_lang_UCharacter$getPropertyValueEnumNoThrow(int java.lang.CharSequence ), 0, (int)n, (CharSequence)charSequence);
    }

    public static int getCodePoint(char c, char c2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCodePoint", $$robo$$android_icu_lang_UCharacter$getCodePoint(char char ), 0, (char)c, (char)c2);
    }

    public static int getCodePoint(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCodePoint", $$robo$$android_icu_lang_UCharacter$getCodePoint(char ), 0, (char)c);
    }

    public static String toUpperCase(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toUpperCase", $$robo$$android_icu_lang_UCharacter$toUpperCase(java.lang.String ), 0, (String)string2);
    }

    public static String toLowerCase(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$android_icu_lang_UCharacter$toLowerCase(java.lang.String ), 0, (String)string2);
    }

    public static String toTitleCase(String string2, BreakIterator breakIterator) {
        return InvokeDynamicSupport.bootstrapStatic("toTitleCase", $$robo$$android_icu_lang_UCharacter$toTitleCase(java.lang.String android.icu.text.BreakIterator ), 0, (String)string2, (BreakIterator)breakIterator);
    }

    private static int getDefaultCaseLocale() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultCaseLocale", $$robo$$android_icu_lang_UCharacter$getDefaultCaseLocale(), 0);
    }

    private static int getCaseLocale(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCaseLocale", $$robo$$android_icu_lang_UCharacter$getCaseLocale(java.util.Locale ), 0, (Locale)locale);
    }

    private static int getCaseLocale(ULocale uLocale) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCaseLocale", $$robo$$android_icu_lang_UCharacter$getCaseLocale(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static String toLowerCase(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$android_icu_lang_UCharacter$toLowerCase(int java.lang.String ), 0, (int)n, (String)string2);
    }

    private static String toUpperCase(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toUpperCase", $$robo$$android_icu_lang_UCharacter$toUpperCase(int java.lang.String ), 0, (int)n, (String)string2);
    }

    private static String toTitleCase(int n, int n2, BreakIterator breakIterator, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toTitleCase", $$robo$$android_icu_lang_UCharacter$toTitleCase(int int android.icu.text.BreakIterator java.lang.String ), 0, (int)n, (int)n2, (BreakIterator)breakIterator, (String)string2);
    }

    private static String applyEdits(String string2, StringBuilder stringBuilder, Edits edits) {
        return InvokeDynamicSupport.bootstrapStatic("applyEdits", $$robo$$android_icu_lang_UCharacter$applyEdits(java.lang.String java.lang.StringBuilder android.icu.text.Edits ), 0, (String)string2, (StringBuilder)stringBuilder, (Edits)edits);
    }

    public static String toUpperCase(Locale locale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toUpperCase", $$robo$$android_icu_lang_UCharacter$toUpperCase(java.util.Locale java.lang.String ), 0, (Locale)locale, (String)string2);
    }

    public static String toUpperCase(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toUpperCase", $$robo$$android_icu_lang_UCharacter$toUpperCase(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
    }

    public static String toLowerCase(Locale locale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$android_icu_lang_UCharacter$toLowerCase(java.util.Locale java.lang.String ), 0, (Locale)locale, (String)string2);
    }

    public static String toLowerCase(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$android_icu_lang_UCharacter$toLowerCase(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
    }

    public static String toTitleCase(Locale locale, String string2, BreakIterator breakIterator) {
        return InvokeDynamicSupport.bootstrapStatic("toTitleCase", $$robo$$android_icu_lang_UCharacter$toTitleCase(java.util.Locale java.lang.String android.icu.text.BreakIterator ), 0, (Locale)locale, (String)string2, (BreakIterator)breakIterator);
    }

    public static String toTitleCase(ULocale uLocale, String string2, BreakIterator breakIterator) {
        return InvokeDynamicSupport.bootstrapStatic("toTitleCase", $$robo$$android_icu_lang_UCharacter$toTitleCase(android.icu.util.ULocale java.lang.String android.icu.text.BreakIterator ), 0, (ULocale)uLocale, (String)string2, (BreakIterator)breakIterator);
    }

    public static String toTitleCase(ULocale uLocale, String string2, BreakIterator breakIterator, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toTitleCase", $$robo$$android_icu_lang_UCharacter$toTitleCase(android.icu.util.ULocale java.lang.String android.icu.text.BreakIterator int ), 0, (ULocale)uLocale, (String)string2, (BreakIterator)breakIterator, (int)n);
    }

    @Deprecated
    public static String toTitleFirst(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toTitleFirst", $$robo$$android_icu_lang_UCharacter$toTitleFirst(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
    }

    public static String toTitleCase(Locale locale, String string2, BreakIterator breakIterator, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toTitleCase", $$robo$$android_icu_lang_UCharacter$toTitleCase(java.util.Locale java.lang.String android.icu.text.BreakIterator int ), 0, (Locale)locale, (String)string2, (BreakIterator)breakIterator, (int)n);
    }

    public static int foldCase(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("foldCase", $$robo$$android_icu_lang_UCharacter$foldCase(int boolean ), 0, (int)n, (boolean)bl);
    }

    public static String foldCase(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("foldCase", $$robo$$android_icu_lang_UCharacter$foldCase(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    public static int foldCase(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("foldCase", $$robo$$android_icu_lang_UCharacter$foldCase(int int ), 0, (int)n, (int)n2);
    }

    public static String foldCase(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("foldCase", $$robo$$android_icu_lang_UCharacter$foldCase(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static int getHanNumericValue(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getHanNumericValue", $$robo$$android_icu_lang_UCharacter$getHanNumericValue(int ), 0, (int)n);
    }

    public static RangeValueIterator getTypeIterator() {
        return InvokeDynamicSupport.bootstrapStatic("getTypeIterator", $$robo$$android_icu_lang_UCharacter$getTypeIterator(), 0);
    }

    public static ValueIterator getNameIterator() {
        return InvokeDynamicSupport.bootstrapStatic("getNameIterator", $$robo$$android_icu_lang_UCharacter$getNameIterator(), 0);
    }

    @Deprecated
    public static ValueIterator getName1_0Iterator() {
        return InvokeDynamicSupport.bootstrapStatic("getName1_0Iterator", $$robo$$android_icu_lang_UCharacter$getName1_0Iterator(), 0);
    }

    public static ValueIterator getExtendedNameIterator() {
        return InvokeDynamicSupport.bootstrapStatic("getExtendedNameIterator", $$robo$$android_icu_lang_UCharacter$getExtendedNameIterator(), 0);
    }

    public static VersionInfo getAge(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAge", $$robo$$android_icu_lang_UCharacter$getAge(int ), 0, (int)n);
    }

    public static boolean hasBinaryProperty(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasBinaryProperty", $$robo$$android_icu_lang_UCharacter$hasBinaryProperty(int int ), 0, (int)n, (int)n2);
    }

    public static boolean isUAlphabetic(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUAlphabetic", $$robo$$android_icu_lang_UCharacter$isUAlphabetic(int ), 0, (int)n);
    }

    public static boolean isULowercase(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isULowercase", $$robo$$android_icu_lang_UCharacter$isULowercase(int ), 0, (int)n);
    }

    public static boolean isUUppercase(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUUppercase", $$robo$$android_icu_lang_UCharacter$isUUppercase(int ), 0, (int)n);
    }

    public static boolean isUWhiteSpace(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUWhiteSpace", $$robo$$android_icu_lang_UCharacter$isUWhiteSpace(int ), 0, (int)n);
    }

    public static int getIntPropertyValue(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntPropertyValue", $$robo$$android_icu_lang_UCharacter$getIntPropertyValue(int int ), 0, (int)n, (int)n2);
    }

    @Deprecated
    public static String getStringPropertyValue(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("getStringPropertyValue", $$robo$$android_icu_lang_UCharacter$getStringPropertyValue(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public static int getIntPropertyMinValue(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntPropertyMinValue", $$robo$$android_icu_lang_UCharacter$getIntPropertyMinValue(int ), 0, (int)n);
    }

    public static int getIntPropertyMaxValue(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntPropertyMaxValue", $$robo$$android_icu_lang_UCharacter$getIntPropertyMaxValue(int ), 0, (int)n);
    }

    public static char forDigit(int n, int n2) {
        return (char)InvokeDynamicSupport.bootstrapStatic("forDigit", $$robo$$android_icu_lang_UCharacter$forDigit(int int ), 0, (int)n, (int)n2);
    }

    public static boolean isValidCodePoint(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidCodePoint", $$robo$$android_icu_lang_UCharacter$isValidCodePoint(int ), 0, (int)n);
    }

    public static boolean isSupplementaryCodePoint(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupplementaryCodePoint", $$robo$$android_icu_lang_UCharacter$isSupplementaryCodePoint(int ), 0, (int)n);
    }

    public static boolean isHighSurrogate(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isHighSurrogate", $$robo$$android_icu_lang_UCharacter$isHighSurrogate(char ), 0, (char)c);
    }

    public static boolean isLowSurrogate(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLowSurrogate", $$robo$$android_icu_lang_UCharacter$isLowSurrogate(char ), 0, (char)c);
    }

    public static boolean isSurrogatePair(char c, char c2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSurrogatePair", $$robo$$android_icu_lang_UCharacter$isSurrogatePair(char char ), 0, (char)c, (char)c2);
    }

    public static int charCount(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("charCount", $$robo$$android_icu_lang_UCharacter$charCount(int ), 0, (int)n);
    }

    public static int toCodePoint(char c, char c2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toCodePoint", $$robo$$android_icu_lang_UCharacter$toCodePoint(char char ), 0, (char)c, (char)c2);
    }

    public static int codePointAt(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointAt", $$robo$$android_icu_lang_UCharacter$codePointAt(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    public static int codePointAt(char[] cArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointAt", $$robo$$android_icu_lang_UCharacter$codePointAt(char[] int ), 0, (char[])cArray, (int)n);
    }

    public static int codePointAt(char[] cArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointAt", $$robo$$android_icu_lang_UCharacter$codePointAt(char[] int int ), 0, (char[])cArray, (int)n, (int)n2);
    }

    public static int codePointBefore(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointBefore", $$robo$$android_icu_lang_UCharacter$codePointBefore(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    public static int codePointBefore(char[] cArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointBefore", $$robo$$android_icu_lang_UCharacter$codePointBefore(char[] int ), 0, (char[])cArray, (int)n);
    }

    public static int codePointBefore(char[] cArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointBefore", $$robo$$android_icu_lang_UCharacter$codePointBefore(char[] int int ), 0, (char[])cArray, (int)n, (int)n2);
    }

    public static int toChars(int n, char[] cArray, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toChars", $$robo$$android_icu_lang_UCharacter$toChars(int char[] int ), 0, (int)n, (char[])cArray, (int)n2);
    }

    public static char[] toChars(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toChars", $$robo$$android_icu_lang_UCharacter$toChars(int ), 0, (int)n);
    }

    public static byte getDirectionality(int n) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("getDirectionality", $$robo$$android_icu_lang_UCharacter$getDirectionality(int ), 0, (int)n);
    }

    public static int codePointCount(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointCount", $$robo$$android_icu_lang_UCharacter$codePointCount(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    public static int codePointCount(char[] cArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointCount", $$robo$$android_icu_lang_UCharacter$codePointCount(char[] int int ), 0, (char[])cArray, (int)n, (int)n2);
    }

    public static int offsetByCodePoints(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("offsetByCodePoints", $$robo$$android_icu_lang_UCharacter$offsetByCodePoints(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    public static int offsetByCodePoints(char[] cArray, int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("offsetByCodePoints", $$robo$$android_icu_lang_UCharacter$offsetByCodePoints(char[] int int int int ), 0, (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_lang_UCharacter$__constructor__();
    }

    private UCharacter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_lang_UCharacter$__constructor__(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UCharacter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DummyValueIterator
    implements ValueIterator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_lang_UCharacter_DummyValueIterator$__constructor__() {
        }

        private final boolean $$robo$$android_icu_lang_UCharacter_DummyValueIterator$next(ValueIterator.Element element) {
            return false;
        }

        private final void $$robo$$android_icu_lang_UCharacter_DummyValueIterator$reset() {
        }

        private final void $$robo$$android_icu_lang_UCharacter_DummyValueIterator$setRange(int start, int limit) {
        }

        private /* synthetic */ void $$robo$$android_icu_lang_UCharacter_DummyValueIterator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_lang_UCharacter_DummyValueIterator$__constructor__();
        }

        private DummyValueIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_lang_UCharacter_DummyValueIterator$__constructor__(), 0, this);
        }

        @Override
        public boolean next(ValueIterator.Element element) {
            return (boolean)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_lang_UCharacter_DummyValueIterator$next(android.icu.util.ValueIterator$Element ), 0, this, element);
        }

        @Override
        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_lang_UCharacter_DummyValueIterator$reset(), 0, this);
        }

        @Override
        public void setRange(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setRange", $$robo$$android_icu_lang_UCharacter_DummyValueIterator$setRange(int int ), 0, this, n, n2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_lang_UCharacter_DummyValueIterator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DummyValueIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class UCharacterTypeIterator
    implements RangeValueIterator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Iterator<Trie2.Range> trieIterator;
        private Trie2.Range range;
        private static MaskType MASK_TYPE;

        private void $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator$__constructor__() {
            this.reset();
        }

        private final boolean $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator$next(RangeValueIterator.Element element) {
            if (this.trieIterator.hasNext()) {
                this.range = this.trieIterator.next();
                if (!this.range.leadSurrogate) {
                    element.start = this.range.startCodePoint;
                    element.limit = this.range.endCodePoint + 1;
                    element.value = this.range.value;
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator$reset() {
            this.trieIterator = UCharacterProperty.INSTANCE.m_trie_.iterator(MASK_TYPE);
        }

        static void __staticInitializer__() {
            MASK_TYPE = new MaskType();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator$__constructor__();
        }

        UCharacterTypeIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator$__constructor__(), 0, this);
        }

        @Override
        public boolean next(RangeValueIterator.Element element) {
            return (boolean)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator$next(android.icu.util.RangeValueIterator$Element ), 0, this, element);
        }

        @Override
        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator$reset(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(UCharacterTypeIterator.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UCharacterTypeIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class MaskType
        implements Trie2.ValueMapper,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator_MaskType$__constructor__() {
            }

            private final int $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator_MaskType$map(int value) {
                return value & 0x1F;
            }

            private /* synthetic */ void $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator_MaskType$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator_MaskType$__constructor__();
            }

            private MaskType() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator_MaskType$__constructor__(), 0, this);
            }

            @Override
            public int map(int n) {
                return (int)InvokeDynamicSupport.bootstrap("map", $$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator_MaskType$map(int ), 0, this, n);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_icu_lang_UCharacter_UCharacterTypeIterator_MaskType$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MaskType)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static interface BidiPairedBracketType
    extends InstrumentedInterface {
        public static final int NONE = 0;
        public static final int OPEN = 1;
        public static final int CLOSE = 2;
        @Deprecated
        public static final int COUNT = 3;
    }

    public static interface HangulSyllableType
    extends InstrumentedInterface {
        public static final int NOT_APPLICABLE = 0;
        public static final int LEADING_JAMO = 1;
        public static final int VOWEL_JAMO = 2;
        public static final int TRAILING_JAMO = 3;
        public static final int LV_SYLLABLE = 4;
        public static final int LVT_SYLLABLE = 5;
        @Deprecated
        public static final int COUNT = 6;
    }

    public static interface NumericType
    extends InstrumentedInterface {
        public static final int NONE = 0;
        public static final int DECIMAL = 1;
        public static final int DIGIT = 2;
        public static final int NUMERIC = 3;
        @Deprecated
        public static final int COUNT = 4;
    }

    public static interface LineBreak
    extends InstrumentedInterface {
        public static final int UNKNOWN = 0;
        public static final int AMBIGUOUS = 1;
        public static final int ALPHABETIC = 2;
        public static final int BREAK_BOTH = 3;
        public static final int BREAK_AFTER = 4;
        public static final int BREAK_BEFORE = 5;
        public static final int MANDATORY_BREAK = 6;
        public static final int CONTINGENT_BREAK = 7;
        public static final int CLOSE_PUNCTUATION = 8;
        public static final int COMBINING_MARK = 9;
        public static final int CARRIAGE_RETURN = 10;
        public static final int EXCLAMATION = 11;
        public static final int GLUE = 12;
        public static final int HYPHEN = 13;
        public static final int IDEOGRAPHIC = 14;
        public static final int INSEPERABLE = 15;
        public static final int INSEPARABLE = 15;
        public static final int INFIX_NUMERIC = 16;
        public static final int LINE_FEED = 17;
        public static final int NONSTARTER = 18;
        public static final int NUMERIC = 19;
        public static final int OPEN_PUNCTUATION = 20;
        public static final int POSTFIX_NUMERIC = 21;
        public static final int PREFIX_NUMERIC = 22;
        public static final int QUOTATION = 23;
        public static final int COMPLEX_CONTEXT = 24;
        public static final int SURROGATE = 25;
        public static final int SPACE = 26;
        public static final int BREAK_SYMBOLS = 27;
        public static final int ZWSPACE = 28;
        public static final int NEXT_LINE = 29;
        public static final int WORD_JOINER = 30;
        public static final int H2 = 31;
        public static final int H3 = 32;
        public static final int JL = 33;
        public static final int JT = 34;
        public static final int JV = 35;
        public static final int CLOSE_PARENTHESIS = 36;
        public static final int CONDITIONAL_JAPANESE_STARTER = 37;
        public static final int HEBREW_LETTER = 38;
        public static final int REGIONAL_INDICATOR = 39;
        public static final int E_BASE = 40;
        public static final int E_MODIFIER = 41;
        public static final int ZWJ = 42;
        @Deprecated
        public static final int COUNT = 43;
    }

    public static interface SentenceBreak
    extends InstrumentedInterface {
        public static final int OTHER = 0;
        public static final int ATERM = 1;
        public static final int CLOSE = 2;
        public static final int FORMAT = 3;
        public static final int LOWER = 4;
        public static final int NUMERIC = 5;
        public static final int OLETTER = 6;
        public static final int SEP = 7;
        public static final int SP = 8;
        public static final int STERM = 9;
        public static final int UPPER = 10;
        public static final int CR = 11;
        public static final int EXTEND = 12;
        public static final int LF = 13;
        public static final int SCONTINUE = 14;
        @Deprecated
        public static final int COUNT = 15;
    }

    public static interface WordBreak
    extends InstrumentedInterface {
        public static final int OTHER = 0;
        public static final int ALETTER = 1;
        public static final int FORMAT = 2;
        public static final int KATAKANA = 3;
        public static final int MIDLETTER = 4;
        public static final int MIDNUM = 5;
        public static final int NUMERIC = 6;
        public static final int EXTENDNUMLET = 7;
        public static final int CR = 8;
        public static final int EXTEND = 9;
        public static final int LF = 10;
        public static final int MIDNUMLET = 11;
        public static final int NEWLINE = 12;
        public static final int REGIONAL_INDICATOR = 13;
        public static final int HEBREW_LETTER = 14;
        public static final int SINGLE_QUOTE = 15;
        public static final int DOUBLE_QUOTE = 16;
        public static final int E_BASE = 17;
        public static final int E_BASE_GAZ = 18;
        public static final int E_MODIFIER = 19;
        public static final int GLUE_AFTER_ZWJ = 20;
        public static final int ZWJ = 21;
        @Deprecated
        public static final int COUNT = 22;
    }

    public static interface GraphemeClusterBreak
    extends InstrumentedInterface {
        public static final int OTHER = 0;
        public static final int CONTROL = 1;
        public static final int CR = 2;
        public static final int EXTEND = 3;
        public static final int L = 4;
        public static final int LF = 5;
        public static final int LV = 6;
        public static final int LVT = 7;
        public static final int T = 8;
        public static final int V = 9;
        public static final int SPACING_MARK = 10;
        public static final int PREPEND = 11;
        public static final int REGIONAL_INDICATOR = 12;
        public static final int E_BASE = 13;
        public static final int E_BASE_GAZ = 14;
        public static final int E_MODIFIER = 15;
        public static final int GLUE_AFTER_ZWJ = 16;
        public static final int ZWJ = 17;
        @Deprecated
        public static final int COUNT = 18;
    }

    public static interface JoiningGroup
    extends InstrumentedInterface {
        public static final int NO_JOINING_GROUP = 0;
        public static final int AIN = 1;
        public static final int ALAPH = 2;
        public static final int ALEF = 3;
        public static final int BEH = 4;
        public static final int BETH = 5;
        public static final int DAL = 6;
        public static final int DALATH_RISH = 7;
        public static final int E = 8;
        public static final int FEH = 9;
        public static final int FINAL_SEMKATH = 10;
        public static final int GAF = 11;
        public static final int GAMAL = 12;
        public static final int HAH = 13;
        public static final int TEH_MARBUTA_GOAL = 14;
        public static final int HAMZA_ON_HEH_GOAL = 14;
        public static final int HE = 15;
        public static final int HEH = 16;
        public static final int HEH_GOAL = 17;
        public static final int HETH = 18;
        public static final int KAF = 19;
        public static final int KAPH = 20;
        public static final int KNOTTED_HEH = 21;
        public static final int LAM = 22;
        public static final int LAMADH = 23;
        public static final int MEEM = 24;
        public static final int MIM = 25;
        public static final int NOON = 26;
        public static final int NUN = 27;
        public static final int PE = 28;
        public static final int QAF = 29;
        public static final int QAPH = 30;
        public static final int REH = 31;
        public static final int REVERSED_PE = 32;
        public static final int SAD = 33;
        public static final int SADHE = 34;
        public static final int SEEN = 35;
        public static final int SEMKATH = 36;
        public static final int SHIN = 37;
        public static final int SWASH_KAF = 38;
        public static final int SYRIAC_WAW = 39;
        public static final int TAH = 40;
        public static final int TAW = 41;
        public static final int TEH_MARBUTA = 42;
        public static final int TETH = 43;
        public static final int WAW = 44;
        public static final int YEH = 45;
        public static final int YEH_BARREE = 46;
        public static final int YEH_WITH_TAIL = 47;
        public static final int YUDH = 48;
        public static final int YUDH_HE = 49;
        public static final int ZAIN = 50;
        public static final int FE = 51;
        public static final int KHAPH = 52;
        public static final int ZHAIN = 53;
        public static final int BURUSHASKI_YEH_BARREE = 54;
        public static final int FARSI_YEH = 55;
        public static final int NYA = 56;
        public static final int ROHINGYA_YEH = 57;
        public static final int MANICHAEAN_ALEPH = 58;
        public static final int MANICHAEAN_AYIN = 59;
        public static final int MANICHAEAN_BETH = 60;
        public static final int MANICHAEAN_DALETH = 61;
        public static final int MANICHAEAN_DHAMEDH = 62;
        public static final int MANICHAEAN_FIVE = 63;
        public static final int MANICHAEAN_GIMEL = 64;
        public static final int MANICHAEAN_HETH = 65;
        public static final int MANICHAEAN_HUNDRED = 66;
        public static final int MANICHAEAN_KAPH = 67;
        public static final int MANICHAEAN_LAMEDH = 68;
        public static final int MANICHAEAN_MEM = 69;
        public static final int MANICHAEAN_NUN = 70;
        public static final int MANICHAEAN_ONE = 71;
        public static final int MANICHAEAN_PE = 72;
        public static final int MANICHAEAN_QOPH = 73;
        public static final int MANICHAEAN_RESH = 74;
        public static final int MANICHAEAN_SADHE = 75;
        public static final int MANICHAEAN_SAMEKH = 76;
        public static final int MANICHAEAN_TAW = 77;
        public static final int MANICHAEAN_TEN = 78;
        public static final int MANICHAEAN_TETH = 79;
        public static final int MANICHAEAN_THAMEDH = 80;
        public static final int MANICHAEAN_TWENTY = 81;
        public static final int MANICHAEAN_WAW = 82;
        public static final int MANICHAEAN_YODH = 83;
        public static final int MANICHAEAN_ZAYIN = 84;
        public static final int STRAIGHT_WAW = 85;
        public static final int AFRICAN_FEH = 86;
        public static final int AFRICAN_NOON = 87;
        public static final int AFRICAN_QAF = 88;
        @Deprecated
        public static final int COUNT = 89;
    }

    public static interface JoiningType
    extends InstrumentedInterface {
        public static final int NON_JOINING = 0;
        public static final int JOIN_CAUSING = 1;
        public static final int DUAL_JOINING = 2;
        public static final int LEFT_JOINING = 3;
        public static final int RIGHT_JOINING = 4;
        public static final int TRANSPARENT = 5;
        @Deprecated
        public static final int COUNT = 6;
    }

    public static interface DecompositionType
    extends InstrumentedInterface {
        public static final int NONE = 0;
        public static final int CANONICAL = 1;
        public static final int COMPAT = 2;
        public static final int CIRCLE = 3;
        public static final int FINAL = 4;
        public static final int FONT = 5;
        public static final int FRACTION = 6;
        public static final int INITIAL = 7;
        public static final int ISOLATED = 8;
        public static final int MEDIAL = 9;
        public static final int NARROW = 10;
        public static final int NOBREAK = 11;
        public static final int SMALL = 12;
        public static final int SQUARE = 13;
        public static final int SUB = 14;
        public static final int SUPER = 15;
        public static final int VERTICAL = 16;
        public static final int WIDE = 17;
        @Deprecated
        public static final int COUNT = 18;
    }

    public static interface EastAsianWidth
    extends InstrumentedInterface {
        public static final int NEUTRAL = 0;
        public static final int AMBIGUOUS = 1;
        public static final int HALFWIDTH = 2;
        public static final int FULLWIDTH = 3;
        public static final int NARROW = 4;
        public static final int WIDE = 5;
        @Deprecated
        public static final int COUNT = 6;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class UnicodeBlock
    extends Character.Subset
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int INVALID_CODE_ID = -1;
        public static int BASIC_LATIN_ID = 1;
        public static int LATIN_1_SUPPLEMENT_ID = 2;
        public static int LATIN_EXTENDED_A_ID = 3;
        public static int LATIN_EXTENDED_B_ID = 4;
        public static int IPA_EXTENSIONS_ID = 5;
        public static int SPACING_MODIFIER_LETTERS_ID = 6;
        public static int COMBINING_DIACRITICAL_MARKS_ID = 7;
        public static int GREEK_ID = 8;
        public static int CYRILLIC_ID = 9;
        public static int ARMENIAN_ID = 10;
        public static int HEBREW_ID = 11;
        public static int ARABIC_ID = 12;
        public static int SYRIAC_ID = 13;
        public static int THAANA_ID = 14;
        public static int DEVANAGARI_ID = 15;
        public static int BENGALI_ID = 16;
        public static int GURMUKHI_ID = 17;
        public static int GUJARATI_ID = 18;
        public static int ORIYA_ID = 19;
        public static int TAMIL_ID = 20;
        public static int TELUGU_ID = 21;
        public static int KANNADA_ID = 22;
        public static int MALAYALAM_ID = 23;
        public static int SINHALA_ID = 24;
        public static int THAI_ID = 25;
        public static int LAO_ID = 26;
        public static int TIBETAN_ID = 27;
        public static int MYANMAR_ID = 28;
        public static int GEORGIAN_ID = 29;
        public static int HANGUL_JAMO_ID = 30;
        public static int ETHIOPIC_ID = 31;
        public static int CHEROKEE_ID = 32;
        public static int UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_ID = 33;
        public static int OGHAM_ID = 34;
        public static int RUNIC_ID = 35;
        public static int KHMER_ID = 36;
        public static int MONGOLIAN_ID = 37;
        public static int LATIN_EXTENDED_ADDITIONAL_ID = 38;
        public static int GREEK_EXTENDED_ID = 39;
        public static int GENERAL_PUNCTUATION_ID = 40;
        public static int SUPERSCRIPTS_AND_SUBSCRIPTS_ID = 41;
        public static int CURRENCY_SYMBOLS_ID = 42;
        public static int COMBINING_MARKS_FOR_SYMBOLS_ID = 43;
        public static int LETTERLIKE_SYMBOLS_ID = 44;
        public static int NUMBER_FORMS_ID = 45;
        public static int ARROWS_ID = 46;
        public static int MATHEMATICAL_OPERATORS_ID = 47;
        public static int MISCELLANEOUS_TECHNICAL_ID = 48;
        public static int CONTROL_PICTURES_ID = 49;
        public static int OPTICAL_CHARACTER_RECOGNITION_ID = 50;
        public static int ENCLOSED_ALPHANUMERICS_ID = 51;
        public static int BOX_DRAWING_ID = 52;
        public static int BLOCK_ELEMENTS_ID = 53;
        public static int GEOMETRIC_SHAPES_ID = 54;
        public static int MISCELLANEOUS_SYMBOLS_ID = 55;
        public static int DINGBATS_ID = 56;
        public static int BRAILLE_PATTERNS_ID = 57;
        public static int CJK_RADICALS_SUPPLEMENT_ID = 58;
        public static int KANGXI_RADICALS_ID = 59;
        public static int IDEOGRAPHIC_DESCRIPTION_CHARACTERS_ID = 60;
        public static int CJK_SYMBOLS_AND_PUNCTUATION_ID = 61;
        public static int HIRAGANA_ID = 62;
        public static int KATAKANA_ID = 63;
        public static int BOPOMOFO_ID = 64;
        public static int HANGUL_COMPATIBILITY_JAMO_ID = 65;
        public static int KANBUN_ID = 66;
        public static int BOPOMOFO_EXTENDED_ID = 67;
        public static int ENCLOSED_CJK_LETTERS_AND_MONTHS_ID = 68;
        public static int CJK_COMPATIBILITY_ID = 69;
        public static int CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A_ID = 70;
        public static int CJK_UNIFIED_IDEOGRAPHS_ID = 71;
        public static int YI_SYLLABLES_ID = 72;
        public static int YI_RADICALS_ID = 73;
        public static int HANGUL_SYLLABLES_ID = 74;
        public static int HIGH_SURROGATES_ID = 75;
        public static int HIGH_PRIVATE_USE_SURROGATES_ID = 76;
        public static int LOW_SURROGATES_ID = 77;
        public static int PRIVATE_USE_AREA_ID = 78;
        public static int PRIVATE_USE_ID = 78;
        public static int CJK_COMPATIBILITY_IDEOGRAPHS_ID = 79;
        public static int ALPHABETIC_PRESENTATION_FORMS_ID = 80;
        public static int ARABIC_PRESENTATION_FORMS_A_ID = 81;
        public static int COMBINING_HALF_MARKS_ID = 82;
        public static int CJK_COMPATIBILITY_FORMS_ID = 83;
        public static int SMALL_FORM_VARIANTS_ID = 84;
        public static int ARABIC_PRESENTATION_FORMS_B_ID = 85;
        public static int SPECIALS_ID = 86;
        public static int HALFWIDTH_AND_FULLWIDTH_FORMS_ID = 87;
        public static int OLD_ITALIC_ID = 88;
        public static int GOTHIC_ID = 89;
        public static int DESERET_ID = 90;
        public static int BYZANTINE_MUSICAL_SYMBOLS_ID = 91;
        public static int MUSICAL_SYMBOLS_ID = 92;
        public static int MATHEMATICAL_ALPHANUMERIC_SYMBOLS_ID = 93;
        public static int CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B_ID = 94;
        public static int CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT_ID = 95;
        public static int TAGS_ID = 96;
        public static int CYRILLIC_SUPPLEMENTARY_ID = 97;
        public static int CYRILLIC_SUPPLEMENT_ID = 97;
        public static int TAGALOG_ID = 98;
        public static int HANUNOO_ID = 99;
        public static int BUHID_ID = 100;
        public static int TAGBANWA_ID = 101;
        public static int MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_ID = 102;
        public static int SUPPLEMENTAL_ARROWS_A_ID = 103;
        public static int SUPPLEMENTAL_ARROWS_B_ID = 104;
        public static int MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_ID = 105;
        public static int SUPPLEMENTAL_MATHEMATICAL_OPERATORS_ID = 106;
        public static int KATAKANA_PHONETIC_EXTENSIONS_ID = 107;
        public static int VARIATION_SELECTORS_ID = 108;
        public static int SUPPLEMENTARY_PRIVATE_USE_AREA_A_ID = 109;
        public static int SUPPLEMENTARY_PRIVATE_USE_AREA_B_ID = 110;
        public static int LIMBU_ID = 111;
        public static int TAI_LE_ID = 112;
        public static int KHMER_SYMBOLS_ID = 113;
        public static int PHONETIC_EXTENSIONS_ID = 114;
        public static int MISCELLANEOUS_SYMBOLS_AND_ARROWS_ID = 115;
        public static int YIJING_HEXAGRAM_SYMBOLS_ID = 116;
        public static int LINEAR_B_SYLLABARY_ID = 117;
        public static int LINEAR_B_IDEOGRAMS_ID = 118;
        public static int AEGEAN_NUMBERS_ID = 119;
        public static int UGARITIC_ID = 120;
        public static int SHAVIAN_ID = 121;
        public static int OSMANYA_ID = 122;
        public static int CYPRIOT_SYLLABARY_ID = 123;
        public static int TAI_XUAN_JING_SYMBOLS_ID = 124;
        public static int VARIATION_SELECTORS_SUPPLEMENT_ID = 125;
        public static int ANCIENT_GREEK_MUSICAL_NOTATION_ID = 126;
        public static int ANCIENT_GREEK_NUMBERS_ID = 127;
        public static int ARABIC_SUPPLEMENT_ID = 128;
        public static int BUGINESE_ID = 129;
        public static int CJK_STROKES_ID = 130;
        public static int COMBINING_DIACRITICAL_MARKS_SUPPLEMENT_ID = 131;
        public static int COPTIC_ID = 132;
        public static int ETHIOPIC_EXTENDED_ID = 133;
        public static int ETHIOPIC_SUPPLEMENT_ID = 134;
        public static int GEORGIAN_SUPPLEMENT_ID = 135;
        public static int GLAGOLITIC_ID = 136;
        public static int KHAROSHTHI_ID = 137;
        public static int MODIFIER_TONE_LETTERS_ID = 138;
        public static int NEW_TAI_LUE_ID = 139;
        public static int OLD_PERSIAN_ID = 140;
        public static int PHONETIC_EXTENSIONS_SUPPLEMENT_ID = 141;
        public static int SUPPLEMENTAL_PUNCTUATION_ID = 142;
        public static int SYLOTI_NAGRI_ID = 143;
        public static int TIFINAGH_ID = 144;
        public static int VERTICAL_FORMS_ID = 145;
        public static int NKO_ID = 146;
        public static int BALINESE_ID = 147;
        public static int LATIN_EXTENDED_C_ID = 148;
        public static int LATIN_EXTENDED_D_ID = 149;
        public static int PHAGS_PA_ID = 150;
        public static int PHOENICIAN_ID = 151;
        public static int CUNEIFORM_ID = 152;
        public static int CUNEIFORM_NUMBERS_AND_PUNCTUATION_ID = 153;
        public static int COUNTING_ROD_NUMERALS_ID = 154;
        public static int SUNDANESE_ID = 155;
        public static int LEPCHA_ID = 156;
        public static int OL_CHIKI_ID = 157;
        public static int CYRILLIC_EXTENDED_A_ID = 158;
        public static int VAI_ID = 159;
        public static int CYRILLIC_EXTENDED_B_ID = 160;
        public static int SAURASHTRA_ID = 161;
        public static int KAYAH_LI_ID = 162;
        public static int REJANG_ID = 163;
        public static int CHAM_ID = 164;
        public static int ANCIENT_SYMBOLS_ID = 165;
        public static int PHAISTOS_DISC_ID = 166;
        public static int LYCIAN_ID = 167;
        public static int CARIAN_ID = 168;
        public static int LYDIAN_ID = 169;
        public static int MAHJONG_TILES_ID = 170;
        public static int DOMINO_TILES_ID = 171;
        public static int SAMARITAN_ID = 172;
        public static int UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_ID = 173;
        public static int TAI_THAM_ID = 174;
        public static int VEDIC_EXTENSIONS_ID = 175;
        public static int LISU_ID = 176;
        public static int BAMUM_ID = 177;
        public static int COMMON_INDIC_NUMBER_FORMS_ID = 178;
        public static int DEVANAGARI_EXTENDED_ID = 179;
        public static int HANGUL_JAMO_EXTENDED_A_ID = 180;
        public static int JAVANESE_ID = 181;
        public static int MYANMAR_EXTENDED_A_ID = 182;
        public static int TAI_VIET_ID = 183;
        public static int MEETEI_MAYEK_ID = 184;
        public static int HANGUL_JAMO_EXTENDED_B_ID = 185;
        public static int IMPERIAL_ARAMAIC_ID = 186;
        public static int OLD_SOUTH_ARABIAN_ID = 187;
        public static int AVESTAN_ID = 188;
        public static int INSCRIPTIONAL_PARTHIAN_ID = 189;
        public static int INSCRIPTIONAL_PAHLAVI_ID = 190;
        public static int OLD_TURKIC_ID = 191;
        public static int RUMI_NUMERAL_SYMBOLS_ID = 192;
        public static int KAITHI_ID = 193;
        public static int EGYPTIAN_HIEROGLYPHS_ID = 194;
        public static int ENCLOSED_ALPHANUMERIC_SUPPLEMENT_ID = 195;
        public static int ENCLOSED_IDEOGRAPHIC_SUPPLEMENT_ID = 196;
        public static int CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C_ID = 197;
        public static int MANDAIC_ID = 198;
        public static int BATAK_ID = 199;
        public static int ETHIOPIC_EXTENDED_A_ID = 200;
        public static int BRAHMI_ID = 201;
        public static int BAMUM_SUPPLEMENT_ID = 202;
        public static int KANA_SUPPLEMENT_ID = 203;
        public static int PLAYING_CARDS_ID = 204;
        public static int MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS_ID = 205;
        public static int EMOTICONS_ID = 206;
        public static int TRANSPORT_AND_MAP_SYMBOLS_ID = 207;
        public static int ALCHEMICAL_SYMBOLS_ID = 208;
        public static int CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D_ID = 209;
        public static int ARABIC_EXTENDED_A_ID = 210;
        public static int ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS_ID = 211;
        public static int CHAKMA_ID = 212;
        public static int MEETEI_MAYEK_EXTENSIONS_ID = 213;
        public static int MEROITIC_CURSIVE_ID = 214;
        public static int MEROITIC_HIEROGLYPHS_ID = 215;
        public static int MIAO_ID = 216;
        public static int SHARADA_ID = 217;
        public static int SORA_SOMPENG_ID = 218;
        public static int SUNDANESE_SUPPLEMENT_ID = 219;
        public static int TAKRI_ID = 220;
        public static int BASSA_VAH_ID = 221;
        public static int CAUCASIAN_ALBANIAN_ID = 222;
        public static int COPTIC_EPACT_NUMBERS_ID = 223;
        public static int COMBINING_DIACRITICAL_MARKS_EXTENDED_ID = 224;
        public static int DUPLOYAN_ID = 225;
        public static int ELBASAN_ID = 226;
        public static int GEOMETRIC_SHAPES_EXTENDED_ID = 227;
        public static int GRANTHA_ID = 228;
        public static int KHOJKI_ID = 229;
        public static int KHUDAWADI_ID = 230;
        public static int LATIN_EXTENDED_E_ID = 231;
        public static int LINEAR_A_ID = 232;
        public static int MAHAJANI_ID = 233;
        public static int MANICHAEAN_ID = 234;
        public static int MENDE_KIKAKUI_ID = 235;
        public static int MODI_ID = 236;
        public static int MRO_ID = 237;
        public static int MYANMAR_EXTENDED_B_ID = 238;
        public static int NABATAEAN_ID = 239;
        public static int OLD_NORTH_ARABIAN_ID = 240;
        public static int OLD_PERMIC_ID = 241;
        public static int ORNAMENTAL_DINGBATS_ID = 242;
        public static int PAHAWH_HMONG_ID = 243;
        public static int PALMYRENE_ID = 244;
        public static int PAU_CIN_HAU_ID = 245;
        public static int PSALTER_PAHLAVI_ID = 246;
        public static int SHORTHAND_FORMAT_CONTROLS_ID = 247;
        public static int SIDDHAM_ID = 248;
        public static int SINHALA_ARCHAIC_NUMBERS_ID = 249;
        public static int SUPPLEMENTAL_ARROWS_C_ID = 250;
        public static int TIRHUTA_ID = 251;
        public static int WARANG_CITI_ID = 252;
        public static int AHOM_ID = 253;
        public static int ANATOLIAN_HIEROGLYPHS_ID = 254;
        public static int CHEROKEE_SUPPLEMENT_ID = 255;
        public static int CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E_ID = 256;
        public static int EARLY_DYNASTIC_CUNEIFORM_ID = 257;
        public static int HATRAN_ID = 258;
        public static int MULTANI_ID = 259;
        public static int OLD_HUNGARIAN_ID = 260;
        public static int SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS_ID = 261;
        public static int SUTTON_SIGNWRITING_ID = 262;
        public static int ADLAM_ID = 263;
        public static int BHAIKSUKI_ID = 264;
        public static int CYRILLIC_EXTENDED_C_ID = 265;
        public static int GLAGOLITIC_SUPPLEMENT_ID = 266;
        public static int IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION_ID = 267;
        public static int MARCHEN_ID = 268;
        public static int MONGOLIAN_SUPPLEMENT_ID = 269;
        public static int NEWA_ID = 270;
        public static int OSAGE_ID = 271;
        public static int TANGUT_ID = 272;
        public static int TANGUT_COMPONENTS_ID = 273;
        @Deprecated
        public static int COUNT = 274;
        private static UnicodeBlock[] BLOCKS_;
        public static UnicodeBlock NO_BLOCK;
        public static UnicodeBlock BASIC_LATIN;
        public static UnicodeBlock LATIN_1_SUPPLEMENT;
        public static UnicodeBlock LATIN_EXTENDED_A;
        public static UnicodeBlock LATIN_EXTENDED_B;
        public static UnicodeBlock IPA_EXTENSIONS;
        public static UnicodeBlock SPACING_MODIFIER_LETTERS;
        public static UnicodeBlock COMBINING_DIACRITICAL_MARKS;
        public static UnicodeBlock GREEK;
        public static UnicodeBlock CYRILLIC;
        public static UnicodeBlock ARMENIAN;
        public static UnicodeBlock HEBREW;
        public static UnicodeBlock ARABIC;
        public static UnicodeBlock SYRIAC;
        public static UnicodeBlock THAANA;
        public static UnicodeBlock DEVANAGARI;
        public static UnicodeBlock BENGALI;
        public static UnicodeBlock GURMUKHI;
        public static UnicodeBlock GUJARATI;
        public static UnicodeBlock ORIYA;
        public static UnicodeBlock TAMIL;
        public static UnicodeBlock TELUGU;
        public static UnicodeBlock KANNADA;
        public static UnicodeBlock MALAYALAM;
        public static UnicodeBlock SINHALA;
        public static UnicodeBlock THAI;
        public static UnicodeBlock LAO;
        public static UnicodeBlock TIBETAN;
        public static UnicodeBlock MYANMAR;
        public static UnicodeBlock GEORGIAN;
        public static UnicodeBlock HANGUL_JAMO;
        public static UnicodeBlock ETHIOPIC;
        public static UnicodeBlock CHEROKEE;
        public static UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS;
        public static UnicodeBlock OGHAM;
        public static UnicodeBlock RUNIC;
        public static UnicodeBlock KHMER;
        public static UnicodeBlock MONGOLIAN;
        public static UnicodeBlock LATIN_EXTENDED_ADDITIONAL;
        public static UnicodeBlock GREEK_EXTENDED;
        public static UnicodeBlock GENERAL_PUNCTUATION;
        public static UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS;
        public static UnicodeBlock CURRENCY_SYMBOLS;
        public static UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS;
        public static UnicodeBlock LETTERLIKE_SYMBOLS;
        public static UnicodeBlock NUMBER_FORMS;
        public static UnicodeBlock ARROWS;
        public static UnicodeBlock MATHEMATICAL_OPERATORS;
        public static UnicodeBlock MISCELLANEOUS_TECHNICAL;
        public static UnicodeBlock CONTROL_PICTURES;
        public static UnicodeBlock OPTICAL_CHARACTER_RECOGNITION;
        public static UnicodeBlock ENCLOSED_ALPHANUMERICS;
        public static UnicodeBlock BOX_DRAWING;
        public static UnicodeBlock BLOCK_ELEMENTS;
        public static UnicodeBlock GEOMETRIC_SHAPES;
        public static UnicodeBlock MISCELLANEOUS_SYMBOLS;
        public static UnicodeBlock DINGBATS;
        public static UnicodeBlock BRAILLE_PATTERNS;
        public static UnicodeBlock CJK_RADICALS_SUPPLEMENT;
        public static UnicodeBlock KANGXI_RADICALS;
        public static UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS;
        public static UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION;
        public static UnicodeBlock HIRAGANA;
        public static UnicodeBlock KATAKANA;
        public static UnicodeBlock BOPOMOFO;
        public static UnicodeBlock HANGUL_COMPATIBILITY_JAMO;
        public static UnicodeBlock KANBUN;
        public static UnicodeBlock BOPOMOFO_EXTENDED;
        public static UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS;
        public static UnicodeBlock CJK_COMPATIBILITY;
        public static UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A;
        public static UnicodeBlock CJK_UNIFIED_IDEOGRAPHS;
        public static UnicodeBlock YI_SYLLABLES;
        public static UnicodeBlock YI_RADICALS;
        public static UnicodeBlock HANGUL_SYLLABLES;
        public static UnicodeBlock HIGH_SURROGATES;
        public static UnicodeBlock HIGH_PRIVATE_USE_SURROGATES;
        public static UnicodeBlock LOW_SURROGATES;
        public static UnicodeBlock PRIVATE_USE_AREA;
        public static UnicodeBlock PRIVATE_USE;
        public static UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS;
        public static UnicodeBlock ALPHABETIC_PRESENTATION_FORMS;
        public static UnicodeBlock ARABIC_PRESENTATION_FORMS_A;
        public static UnicodeBlock COMBINING_HALF_MARKS;
        public static UnicodeBlock CJK_COMPATIBILITY_FORMS;
        public static UnicodeBlock SMALL_FORM_VARIANTS;
        public static UnicodeBlock ARABIC_PRESENTATION_FORMS_B;
        public static UnicodeBlock SPECIALS;
        public static UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS;
        public static UnicodeBlock OLD_ITALIC;
        public static UnicodeBlock GOTHIC;
        public static UnicodeBlock DESERET;
        public static UnicodeBlock BYZANTINE_MUSICAL_SYMBOLS;
        public static UnicodeBlock MUSICAL_SYMBOLS;
        public static UnicodeBlock MATHEMATICAL_ALPHANUMERIC_SYMBOLS;
        public static UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B;
        public static UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT;
        public static UnicodeBlock TAGS;
        public static UnicodeBlock CYRILLIC_SUPPLEMENTARY;
        public static UnicodeBlock CYRILLIC_SUPPLEMENT;
        public static UnicodeBlock TAGALOG;
        public static UnicodeBlock HANUNOO;
        public static UnicodeBlock BUHID;
        public static UnicodeBlock TAGBANWA;
        public static UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A;
        public static UnicodeBlock SUPPLEMENTAL_ARROWS_A;
        public static UnicodeBlock SUPPLEMENTAL_ARROWS_B;
        public static UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B;
        public static UnicodeBlock SUPPLEMENTAL_MATHEMATICAL_OPERATORS;
        public static UnicodeBlock KATAKANA_PHONETIC_EXTENSIONS;
        public static UnicodeBlock VARIATION_SELECTORS;
        public static UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_A;
        public static UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_B;
        public static UnicodeBlock LIMBU;
        public static UnicodeBlock TAI_LE;
        public static UnicodeBlock KHMER_SYMBOLS;
        public static UnicodeBlock PHONETIC_EXTENSIONS;
        public static UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_ARROWS;
        public static UnicodeBlock YIJING_HEXAGRAM_SYMBOLS;
        public static UnicodeBlock LINEAR_B_SYLLABARY;
        public static UnicodeBlock LINEAR_B_IDEOGRAMS;
        public static UnicodeBlock AEGEAN_NUMBERS;
        public static UnicodeBlock UGARITIC;
        public static UnicodeBlock SHAVIAN;
        public static UnicodeBlock OSMANYA;
        public static UnicodeBlock CYPRIOT_SYLLABARY;
        public static UnicodeBlock TAI_XUAN_JING_SYMBOLS;
        public static UnicodeBlock VARIATION_SELECTORS_SUPPLEMENT;
        public static UnicodeBlock ANCIENT_GREEK_MUSICAL_NOTATION;
        public static UnicodeBlock ANCIENT_GREEK_NUMBERS;
        public static UnicodeBlock ARABIC_SUPPLEMENT;
        public static UnicodeBlock BUGINESE;
        public static UnicodeBlock CJK_STROKES;
        public static UnicodeBlock COMBINING_DIACRITICAL_MARKS_SUPPLEMENT;
        public static UnicodeBlock COPTIC;
        public static UnicodeBlock ETHIOPIC_EXTENDED;
        public static UnicodeBlock ETHIOPIC_SUPPLEMENT;
        public static UnicodeBlock GEORGIAN_SUPPLEMENT;
        public static UnicodeBlock GLAGOLITIC;
        public static UnicodeBlock KHAROSHTHI;
        public static UnicodeBlock MODIFIER_TONE_LETTERS;
        public static UnicodeBlock NEW_TAI_LUE;
        public static UnicodeBlock OLD_PERSIAN;
        public static UnicodeBlock PHONETIC_EXTENSIONS_SUPPLEMENT;
        public static UnicodeBlock SUPPLEMENTAL_PUNCTUATION;
        public static UnicodeBlock SYLOTI_NAGRI;
        public static UnicodeBlock TIFINAGH;
        public static UnicodeBlock VERTICAL_FORMS;
        public static UnicodeBlock NKO;
        public static UnicodeBlock BALINESE;
        public static UnicodeBlock LATIN_EXTENDED_C;
        public static UnicodeBlock LATIN_EXTENDED_D;
        public static UnicodeBlock PHAGS_PA;
        public static UnicodeBlock PHOENICIAN;
        public static UnicodeBlock CUNEIFORM;
        public static UnicodeBlock CUNEIFORM_NUMBERS_AND_PUNCTUATION;
        public static UnicodeBlock COUNTING_ROD_NUMERALS;
        public static UnicodeBlock SUNDANESE;
        public static UnicodeBlock LEPCHA;
        public static UnicodeBlock OL_CHIKI;
        public static UnicodeBlock CYRILLIC_EXTENDED_A;
        public static UnicodeBlock VAI;
        public static UnicodeBlock CYRILLIC_EXTENDED_B;
        public static UnicodeBlock SAURASHTRA;
        public static UnicodeBlock KAYAH_LI;
        public static UnicodeBlock REJANG;
        public static UnicodeBlock CHAM;
        public static UnicodeBlock ANCIENT_SYMBOLS;
        public static UnicodeBlock PHAISTOS_DISC;
        public static UnicodeBlock LYCIAN;
        public static UnicodeBlock CARIAN;
        public static UnicodeBlock LYDIAN;
        public static UnicodeBlock MAHJONG_TILES;
        public static UnicodeBlock DOMINO_TILES;
        public static UnicodeBlock SAMARITAN;
        public static UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED;
        public static UnicodeBlock TAI_THAM;
        public static UnicodeBlock VEDIC_EXTENSIONS;
        public static UnicodeBlock LISU;
        public static UnicodeBlock BAMUM;
        public static UnicodeBlock COMMON_INDIC_NUMBER_FORMS;
        public static UnicodeBlock DEVANAGARI_EXTENDED;
        public static UnicodeBlock HANGUL_JAMO_EXTENDED_A;
        public static UnicodeBlock JAVANESE;
        public static UnicodeBlock MYANMAR_EXTENDED_A;
        public static UnicodeBlock TAI_VIET;
        public static UnicodeBlock MEETEI_MAYEK;
        public static UnicodeBlock HANGUL_JAMO_EXTENDED_B;
        public static UnicodeBlock IMPERIAL_ARAMAIC;
        public static UnicodeBlock OLD_SOUTH_ARABIAN;
        public static UnicodeBlock AVESTAN;
        public static UnicodeBlock INSCRIPTIONAL_PARTHIAN;
        public static UnicodeBlock INSCRIPTIONAL_PAHLAVI;
        public static UnicodeBlock OLD_TURKIC;
        public static UnicodeBlock RUMI_NUMERAL_SYMBOLS;
        public static UnicodeBlock KAITHI;
        public static UnicodeBlock EGYPTIAN_HIEROGLYPHS;
        public static UnicodeBlock ENCLOSED_ALPHANUMERIC_SUPPLEMENT;
        public static UnicodeBlock ENCLOSED_IDEOGRAPHIC_SUPPLEMENT;
        public static UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C;
        public static UnicodeBlock MANDAIC;
        public static UnicodeBlock BATAK;
        public static UnicodeBlock ETHIOPIC_EXTENDED_A;
        public static UnicodeBlock BRAHMI;
        public static UnicodeBlock BAMUM_SUPPLEMENT;
        public static UnicodeBlock KANA_SUPPLEMENT;
        public static UnicodeBlock PLAYING_CARDS;
        public static UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS;
        public static UnicodeBlock EMOTICONS;
        public static UnicodeBlock TRANSPORT_AND_MAP_SYMBOLS;
        public static UnicodeBlock ALCHEMICAL_SYMBOLS;
        public static UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D;
        public static UnicodeBlock ARABIC_EXTENDED_A;
        public static UnicodeBlock ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS;
        public static UnicodeBlock CHAKMA;
        public static UnicodeBlock MEETEI_MAYEK_EXTENSIONS;
        public static UnicodeBlock MEROITIC_CURSIVE;
        public static UnicodeBlock MEROITIC_HIEROGLYPHS;
        public static UnicodeBlock MIAO;
        public static UnicodeBlock SHARADA;
        public static UnicodeBlock SORA_SOMPENG;
        public static UnicodeBlock SUNDANESE_SUPPLEMENT;
        public static UnicodeBlock TAKRI;
        public static UnicodeBlock BASSA_VAH;
        public static UnicodeBlock CAUCASIAN_ALBANIAN;
        public static UnicodeBlock COPTIC_EPACT_NUMBERS;
        public static UnicodeBlock COMBINING_DIACRITICAL_MARKS_EXTENDED;
        public static UnicodeBlock DUPLOYAN;
        public static UnicodeBlock ELBASAN;
        public static UnicodeBlock GEOMETRIC_SHAPES_EXTENDED;
        public static UnicodeBlock GRANTHA;
        public static UnicodeBlock KHOJKI;
        public static UnicodeBlock KHUDAWADI;
        public static UnicodeBlock LATIN_EXTENDED_E;
        public static UnicodeBlock LINEAR_A;
        public static UnicodeBlock MAHAJANI;
        public static UnicodeBlock MANICHAEAN;
        public static UnicodeBlock MENDE_KIKAKUI;
        public static UnicodeBlock MODI;
        public static UnicodeBlock MRO;
        public static UnicodeBlock MYANMAR_EXTENDED_B;
        public static UnicodeBlock NABATAEAN;
        public static UnicodeBlock OLD_NORTH_ARABIAN;
        public static UnicodeBlock OLD_PERMIC;
        public static UnicodeBlock ORNAMENTAL_DINGBATS;
        public static UnicodeBlock PAHAWH_HMONG;
        public static UnicodeBlock PALMYRENE;
        public static UnicodeBlock PAU_CIN_HAU;
        public static UnicodeBlock PSALTER_PAHLAVI;
        public static UnicodeBlock SHORTHAND_FORMAT_CONTROLS;
        public static UnicodeBlock SIDDHAM;
        public static UnicodeBlock SINHALA_ARCHAIC_NUMBERS;
        public static UnicodeBlock SUPPLEMENTAL_ARROWS_C;
        public static UnicodeBlock TIRHUTA;
        public static UnicodeBlock WARANG_CITI;
        public static UnicodeBlock AHOM;
        public static UnicodeBlock ANATOLIAN_HIEROGLYPHS;
        public static UnicodeBlock CHEROKEE_SUPPLEMENT;
        public static UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E;
        public static UnicodeBlock EARLY_DYNASTIC_CUNEIFORM;
        public static UnicodeBlock HATRAN;
        public static UnicodeBlock MULTANI;
        public static UnicodeBlock OLD_HUNGARIAN;
        public static UnicodeBlock SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS;
        public static UnicodeBlock SUTTON_SIGNWRITING;
        public static UnicodeBlock ADLAM;
        public static UnicodeBlock BHAIKSUKI;
        public static UnicodeBlock CYRILLIC_EXTENDED_C;
        public static UnicodeBlock GLAGOLITIC_SUPPLEMENT;
        public static UnicodeBlock IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION;
        public static UnicodeBlock MARCHEN;
        public static UnicodeBlock MONGOLIAN_SUPPLEMENT;
        public static UnicodeBlock NEWA;
        public static UnicodeBlock OSAGE;
        public static UnicodeBlock TANGUT;
        public static UnicodeBlock TANGUT_COMPONENTS;
        public static UnicodeBlock INVALID_CODE;
        private static SoftReference<Map<String, UnicodeBlock>> mref;
        private int m_id_;

        private static final UnicodeBlock $$robo$$android_icu_lang_UCharacter_UnicodeBlock$getInstance(int id2) {
            if (id2 >= 0 && id2 < BLOCKS_.length) {
                return BLOCKS_[id2];
            }
            return INVALID_CODE;
        }

        private static final UnicodeBlock $$robo$$android_icu_lang_UCharacter_UnicodeBlock$of(int ch) {
            if (ch > 0x10FFFF) {
                return INVALID_CODE;
            }
            return UnicodeBlock.getInstance(UCharacterProperty.INSTANCE.getIntPropertyValue(ch, 4097));
        }

        private static final UnicodeBlock $$robo$$android_icu_lang_UCharacter_UnicodeBlock$forName(String blockName) {
            UnicodeBlock b;
            Map<String, UnicodeBlock> m = null;
            if (mref != null) {
                m = mref.get();
            }
            if (m == null) {
                m = new HashMap<String, UnicodeBlock>(BLOCKS_.length);
                for (int i = 0; i < BLOCKS_.length; ++i) {
                    UnicodeBlock b2 = BLOCKS_[i];
                    String name = UnicodeBlock.trimBlockName(UCharacter.getPropertyValueName(4097, b2.getID(), 1));
                    m.put(name, b2);
                }
                mref = new SoftReference<Map<String, UnicodeBlock>>(m);
            }
            if ((b = m.get(UnicodeBlock.trimBlockName(blockName))) == null) {
                throw new IllegalArgumentException();
            }
            return b;
        }

        private static final String $$robo$$android_icu_lang_UCharacter_UnicodeBlock$trimBlockName(String name) {
            String upper = name.toUpperCase(Locale.ENGLISH);
            StringBuilder result = new StringBuilder(upper.length());
            for (int i = 0; i < upper.length(); ++i) {
                char c = upper.charAt(i);
                if (c == ' ' || c == '_' || c == '-') continue;
                result.append(c);
            }
            return result.toString();
        }

        private final int $$robo$$android_icu_lang_UCharacter_UnicodeBlock$getID() {
            return this.m_id_;
        }

        private void $$robo$$android_icu_lang_UCharacter_UnicodeBlock$__constructor__(String name, int id2) {
            this.m_id_ = id2;
            if (id2 >= 0) {
                UnicodeBlock.BLOCKS_[id2] = this;
            }
        }

        static void __staticInitializer__() {
            BLOCKS_ = new UnicodeBlock[274];
            NO_BLOCK = new UnicodeBlock("NO_BLOCK", 0);
            BASIC_LATIN = new UnicodeBlock("BASIC_LATIN", 1);
            LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT", 2);
            LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A", 3);
            LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B", 4);
            IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS", 5);
            SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS", 6);
            COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS", 7);
            GREEK = new UnicodeBlock("GREEK", 8);
            CYRILLIC = new UnicodeBlock("CYRILLIC", 9);
            ARMENIAN = new UnicodeBlock("ARMENIAN", 10);
            HEBREW = new UnicodeBlock("HEBREW", 11);
            ARABIC = new UnicodeBlock("ARABIC", 12);
            SYRIAC = new UnicodeBlock("SYRIAC", 13);
            THAANA = new UnicodeBlock("THAANA", 14);
            DEVANAGARI = new UnicodeBlock("DEVANAGARI", 15);
            BENGALI = new UnicodeBlock("BENGALI", 16);
            GURMUKHI = new UnicodeBlock("GURMUKHI", 17);
            GUJARATI = new UnicodeBlock("GUJARATI", 18);
            ORIYA = new UnicodeBlock("ORIYA", 19);
            TAMIL = new UnicodeBlock("TAMIL", 20);
            TELUGU = new UnicodeBlock("TELUGU", 21);
            KANNADA = new UnicodeBlock("KANNADA", 22);
            MALAYALAM = new UnicodeBlock("MALAYALAM", 23);
            SINHALA = new UnicodeBlock("SINHALA", 24);
            THAI = new UnicodeBlock("THAI", 25);
            LAO = new UnicodeBlock("LAO", 26);
            TIBETAN = new UnicodeBlock("TIBETAN", 27);
            MYANMAR = new UnicodeBlock("MYANMAR", 28);
            GEORGIAN = new UnicodeBlock("GEORGIAN", 29);
            HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO", 30);
            ETHIOPIC = new UnicodeBlock("ETHIOPIC", 31);
            CHEROKEE = new UnicodeBlock("CHEROKEE", 32);
            UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", 33);
            OGHAM = new UnicodeBlock("OGHAM", 34);
            RUNIC = new UnicodeBlock("RUNIC", 35);
            KHMER = new UnicodeBlock("KHMER", 36);
            MONGOLIAN = new UnicodeBlock("MONGOLIAN", 37);
            LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL", 38);
            GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED", 39);
            GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION", 40);
            SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS", 41);
            CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS", 42);
            COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS", 43);
            LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS", 44);
            NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS", 45);
            ARROWS = new UnicodeBlock("ARROWS", 46);
            MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS", 47);
            MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL", 48);
            CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES", 49);
            OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION", 50);
            ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS", 51);
            BOX_DRAWING = new UnicodeBlock("BOX_DRAWING", 52);
            BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS", 53);
            GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES", 54);
            MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS", 55);
            DINGBATS = new UnicodeBlock("DINGBATS", 56);
            BRAILLE_PATTERNS = new UnicodeBlock("BRAILLE_PATTERNS", 57);
            CJK_RADICALS_SUPPLEMENT = new UnicodeBlock("CJK_RADICALS_SUPPLEMENT", 58);
            KANGXI_RADICALS = new UnicodeBlock("KANGXI_RADICALS", 59);
            IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock("IDEOGRAPHIC_DESCRIPTION_CHARACTERS", 60);
            CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION", 61);
            HIRAGANA = new UnicodeBlock("HIRAGANA", 62);
            KATAKANA = new UnicodeBlock("KATAKANA", 63);
            BOPOMOFO = new UnicodeBlock("BOPOMOFO", 64);
            HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO", 65);
            KANBUN = new UnicodeBlock("KANBUN", 66);
            BOPOMOFO_EXTENDED = new UnicodeBlock("BOPOMOFO_EXTENDED", 67);
            ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS", 68);
            CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY", 69);
            CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", 70);
            CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS", 71);
            YI_SYLLABLES = new UnicodeBlock("YI_SYLLABLES", 72);
            YI_RADICALS = new UnicodeBlock("YI_RADICALS", 73);
            HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES", 74);
            HIGH_SURROGATES = new UnicodeBlock("HIGH_SURROGATES", 75);
            HIGH_PRIVATE_USE_SURROGATES = new UnicodeBlock("HIGH_PRIVATE_USE_SURROGATES", 76);
            LOW_SURROGATES = new UnicodeBlock("LOW_SURROGATES", 77);
            PRIVATE_USE = PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA", 78);
            CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS", 79);
            ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS", 80);
            ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A", 81);
            COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS", 82);
            CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS", 83);
            SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS", 84);
            ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B", 85);
            SPECIALS = new UnicodeBlock("SPECIALS", 86);
            HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS", 87);
            OLD_ITALIC = new UnicodeBlock("OLD_ITALIC", 88);
            GOTHIC = new UnicodeBlock("GOTHIC", 89);
            DESERET = new UnicodeBlock("DESERET", 90);
            BYZANTINE_MUSICAL_SYMBOLS = new UnicodeBlock("BYZANTINE_MUSICAL_SYMBOLS", 91);
            MUSICAL_SYMBOLS = new UnicodeBlock("MUSICAL_SYMBOLS", 92);
            MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeBlock("MATHEMATICAL_ALPHANUMERIC_SYMBOLS", 93);
            CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", 94);
            CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", 95);
            TAGS = new UnicodeBlock("TAGS", 96);
            CYRILLIC_SUPPLEMENTARY = new UnicodeBlock("CYRILLIC_SUPPLEMENTARY", 97);
            CYRILLIC_SUPPLEMENT = new UnicodeBlock("CYRILLIC_SUPPLEMENT", 97);
            TAGALOG = new UnicodeBlock("TAGALOG", 98);
            HANUNOO = new UnicodeBlock("HANUNOO", 99);
            BUHID = new UnicodeBlock("BUHID", 100);
            TAGBANWA = new UnicodeBlock("TAGBANWA", 101);
            MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", 102);
            SUPPLEMENTAL_ARROWS_A = new UnicodeBlock("SUPPLEMENTAL_ARROWS_A", 103);
            SUPPLEMENTAL_ARROWS_B = new UnicodeBlock("SUPPLEMENTAL_ARROWS_B", 104);
            MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", 105);
            SUPPLEMENTAL_MATHEMATICAL_OPERATORS = new UnicodeBlock("SUPPLEMENTAL_MATHEMATICAL_OPERATORS", 106);
            KATAKANA_PHONETIC_EXTENSIONS = new UnicodeBlock("KATAKANA_PHONETIC_EXTENSIONS", 107);
            VARIATION_SELECTORS = new UnicodeBlock("VARIATION_SELECTORS", 108);
            SUPPLEMENTARY_PRIVATE_USE_AREA_A = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_A", 109);
            SUPPLEMENTARY_PRIVATE_USE_AREA_B = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_B", 110);
            LIMBU = new UnicodeBlock("LIMBU", 111);
            TAI_LE = new UnicodeBlock("TAI_LE", 112);
            KHMER_SYMBOLS = new UnicodeBlock("KHMER_SYMBOLS", 113);
            PHONETIC_EXTENSIONS = new UnicodeBlock("PHONETIC_EXTENSIONS", 114);
            MISCELLANEOUS_SYMBOLS_AND_ARROWS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS_AND_ARROWS", 115);
            YIJING_HEXAGRAM_SYMBOLS = new UnicodeBlock("YIJING_HEXAGRAM_SYMBOLS", 116);
            LINEAR_B_SYLLABARY = new UnicodeBlock("LINEAR_B_SYLLABARY", 117);
            LINEAR_B_IDEOGRAMS = new UnicodeBlock("LINEAR_B_IDEOGRAMS", 118);
            AEGEAN_NUMBERS = new UnicodeBlock("AEGEAN_NUMBERS", 119);
            UGARITIC = new UnicodeBlock("UGARITIC", 120);
            SHAVIAN = new UnicodeBlock("SHAVIAN", 121);
            OSMANYA = new UnicodeBlock("OSMANYA", 122);
            CYPRIOT_SYLLABARY = new UnicodeBlock("CYPRIOT_SYLLABARY", 123);
            TAI_XUAN_JING_SYMBOLS = new UnicodeBlock("TAI_XUAN_JING_SYMBOLS", 124);
            VARIATION_SELECTORS_SUPPLEMENT = new UnicodeBlock("VARIATION_SELECTORS_SUPPLEMENT", 125);
            ANCIENT_GREEK_MUSICAL_NOTATION = new UnicodeBlock("ANCIENT_GREEK_MUSICAL_NOTATION", 126);
            ANCIENT_GREEK_NUMBERS = new UnicodeBlock("ANCIENT_GREEK_NUMBERS", 127);
            ARABIC_SUPPLEMENT = new UnicodeBlock("ARABIC_SUPPLEMENT", 128);
            BUGINESE = new UnicodeBlock("BUGINESE", 129);
            CJK_STROKES = new UnicodeBlock("CJK_STROKES", 130);
            COMBINING_DIACRITICAL_MARKS_SUPPLEMENT = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS_SUPPLEMENT", 131);
            COPTIC = new UnicodeBlock("COPTIC", 132);
            ETHIOPIC_EXTENDED = new UnicodeBlock("ETHIOPIC_EXTENDED", 133);
            ETHIOPIC_SUPPLEMENT = new UnicodeBlock("ETHIOPIC_SUPPLEMENT", 134);
            GEORGIAN_SUPPLEMENT = new UnicodeBlock("GEORGIAN_SUPPLEMENT", 135);
            GLAGOLITIC = new UnicodeBlock("GLAGOLITIC", 136);
            KHAROSHTHI = new UnicodeBlock("KHAROSHTHI", 137);
            MODIFIER_TONE_LETTERS = new UnicodeBlock("MODIFIER_TONE_LETTERS", 138);
            NEW_TAI_LUE = new UnicodeBlock("NEW_TAI_LUE", 139);
            OLD_PERSIAN = new UnicodeBlock("OLD_PERSIAN", 140);
            PHONETIC_EXTENSIONS_SUPPLEMENT = new UnicodeBlock("PHONETIC_EXTENSIONS_SUPPLEMENT", 141);
            SUPPLEMENTAL_PUNCTUATION = new UnicodeBlock("SUPPLEMENTAL_PUNCTUATION", 142);
            SYLOTI_NAGRI = new UnicodeBlock("SYLOTI_NAGRI", 143);
            TIFINAGH = new UnicodeBlock("TIFINAGH", 144);
            VERTICAL_FORMS = new UnicodeBlock("VERTICAL_FORMS", 145);
            NKO = new UnicodeBlock("NKO", 146);
            BALINESE = new UnicodeBlock("BALINESE", 147);
            LATIN_EXTENDED_C = new UnicodeBlock("LATIN_EXTENDED_C", 148);
            LATIN_EXTENDED_D = new UnicodeBlock("LATIN_EXTENDED_D", 149);
            PHAGS_PA = new UnicodeBlock("PHAGS_PA", 150);
            PHOENICIAN = new UnicodeBlock("PHOENICIAN", 151);
            CUNEIFORM = new UnicodeBlock("CUNEIFORM", 152);
            CUNEIFORM_NUMBERS_AND_PUNCTUATION = new UnicodeBlock("CUNEIFORM_NUMBERS_AND_PUNCTUATION", 153);
            COUNTING_ROD_NUMERALS = new UnicodeBlock("COUNTING_ROD_NUMERALS", 154);
            SUNDANESE = new UnicodeBlock("SUNDANESE", 155);
            LEPCHA = new UnicodeBlock("LEPCHA", 156);
            OL_CHIKI = new UnicodeBlock("OL_CHIKI", 157);
            CYRILLIC_EXTENDED_A = new UnicodeBlock("CYRILLIC_EXTENDED_A", 158);
            VAI = new UnicodeBlock("VAI", 159);
            CYRILLIC_EXTENDED_B = new UnicodeBlock("CYRILLIC_EXTENDED_B", 160);
            SAURASHTRA = new UnicodeBlock("SAURASHTRA", 161);
            KAYAH_LI = new UnicodeBlock("KAYAH_LI", 162);
            REJANG = new UnicodeBlock("REJANG", 163);
            CHAM = new UnicodeBlock("CHAM", 164);
            ANCIENT_SYMBOLS = new UnicodeBlock("ANCIENT_SYMBOLS", 165);
            PHAISTOS_DISC = new UnicodeBlock("PHAISTOS_DISC", 166);
            LYCIAN = new UnicodeBlock("LYCIAN", 167);
            CARIAN = new UnicodeBlock("CARIAN", 168);
            LYDIAN = new UnicodeBlock("LYDIAN", 169);
            MAHJONG_TILES = new UnicodeBlock("MAHJONG_TILES", 170);
            DOMINO_TILES = new UnicodeBlock("DOMINO_TILES", 171);
            SAMARITAN = new UnicodeBlock("SAMARITAN", 172);
            UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED", 173);
            TAI_THAM = new UnicodeBlock("TAI_THAM", 174);
            VEDIC_EXTENSIONS = new UnicodeBlock("VEDIC_EXTENSIONS", 175);
            LISU = new UnicodeBlock("LISU", 176);
            BAMUM = new UnicodeBlock("BAMUM", 177);
            COMMON_INDIC_NUMBER_FORMS = new UnicodeBlock("COMMON_INDIC_NUMBER_FORMS", 178);
            DEVANAGARI_EXTENDED = new UnicodeBlock("DEVANAGARI_EXTENDED", 179);
            HANGUL_JAMO_EXTENDED_A = new UnicodeBlock("HANGUL_JAMO_EXTENDED_A", 180);
            JAVANESE = new UnicodeBlock("JAVANESE", 181);
            MYANMAR_EXTENDED_A = new UnicodeBlock("MYANMAR_EXTENDED_A", 182);
            TAI_VIET = new UnicodeBlock("TAI_VIET", 183);
            MEETEI_MAYEK = new UnicodeBlock("MEETEI_MAYEK", 184);
            HANGUL_JAMO_EXTENDED_B = new UnicodeBlock("HANGUL_JAMO_EXTENDED_B", 185);
            IMPERIAL_ARAMAIC = new UnicodeBlock("IMPERIAL_ARAMAIC", 186);
            OLD_SOUTH_ARABIAN = new UnicodeBlock("OLD_SOUTH_ARABIAN", 187);
            AVESTAN = new UnicodeBlock("AVESTAN", 188);
            INSCRIPTIONAL_PARTHIAN = new UnicodeBlock("INSCRIPTIONAL_PARTHIAN", 189);
            INSCRIPTIONAL_PAHLAVI = new UnicodeBlock("INSCRIPTIONAL_PAHLAVI", 190);
            OLD_TURKIC = new UnicodeBlock("OLD_TURKIC", 191);
            RUMI_NUMERAL_SYMBOLS = new UnicodeBlock("RUMI_NUMERAL_SYMBOLS", 192);
            KAITHI = new UnicodeBlock("KAITHI", 193);
            EGYPTIAN_HIEROGLYPHS = new UnicodeBlock("EGYPTIAN_HIEROGLYPHS", 194);
            ENCLOSED_ALPHANUMERIC_SUPPLEMENT = new UnicodeBlock("ENCLOSED_ALPHANUMERIC_SUPPLEMENT", 195);
            ENCLOSED_IDEOGRAPHIC_SUPPLEMENT = new UnicodeBlock("ENCLOSED_IDEOGRAPHIC_SUPPLEMENT", 196);
            CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C", 197);
            MANDAIC = new UnicodeBlock("MANDAIC", 198);
            BATAK = new UnicodeBlock("BATAK", 199);
            ETHIOPIC_EXTENDED_A = new UnicodeBlock("ETHIOPIC_EXTENDED_A", 200);
            BRAHMI = new UnicodeBlock("BRAHMI", 201);
            BAMUM_SUPPLEMENT = new UnicodeBlock("BAMUM_SUPPLEMENT", 202);
            KANA_SUPPLEMENT = new UnicodeBlock("KANA_SUPPLEMENT", 203);
            PLAYING_CARDS = new UnicodeBlock("PLAYING_CARDS", 204);
            MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS", 205);
            EMOTICONS = new UnicodeBlock("EMOTICONS", 206);
            TRANSPORT_AND_MAP_SYMBOLS = new UnicodeBlock("TRANSPORT_AND_MAP_SYMBOLS", 207);
            ALCHEMICAL_SYMBOLS = new UnicodeBlock("ALCHEMICAL_SYMBOLS", 208);
            CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D", 209);
            ARABIC_EXTENDED_A = new UnicodeBlock("ARABIC_EXTENDED_A", 210);
            ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS = new UnicodeBlock("ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS", 211);
            CHAKMA = new UnicodeBlock("CHAKMA", 212);
            MEETEI_MAYEK_EXTENSIONS = new UnicodeBlock("MEETEI_MAYEK_EXTENSIONS", 213);
            MEROITIC_CURSIVE = new UnicodeBlock("MEROITIC_CURSIVE", 214);
            MEROITIC_HIEROGLYPHS = new UnicodeBlock("MEROITIC_HIEROGLYPHS", 215);
            MIAO = new UnicodeBlock("MIAO", 216);
            SHARADA = new UnicodeBlock("SHARADA", 217);
            SORA_SOMPENG = new UnicodeBlock("SORA_SOMPENG", 218);
            SUNDANESE_SUPPLEMENT = new UnicodeBlock("SUNDANESE_SUPPLEMENT", 219);
            TAKRI = new UnicodeBlock("TAKRI", 220);
            BASSA_VAH = new UnicodeBlock("BASSA_VAH", 221);
            CAUCASIAN_ALBANIAN = new UnicodeBlock("CAUCASIAN_ALBANIAN", 222);
            COPTIC_EPACT_NUMBERS = new UnicodeBlock("COPTIC_EPACT_NUMBERS", 223);
            COMBINING_DIACRITICAL_MARKS_EXTENDED = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS_EXTENDED", 224);
            DUPLOYAN = new UnicodeBlock("DUPLOYAN", 225);
            ELBASAN = new UnicodeBlock("ELBASAN", 226);
            GEOMETRIC_SHAPES_EXTENDED = new UnicodeBlock("GEOMETRIC_SHAPES_EXTENDED", 227);
            GRANTHA = new UnicodeBlock("GRANTHA", 228);
            KHOJKI = new UnicodeBlock("KHOJKI", 229);
            KHUDAWADI = new UnicodeBlock("KHUDAWADI", 230);
            LATIN_EXTENDED_E = new UnicodeBlock("LATIN_EXTENDED_E", 231);
            LINEAR_A = new UnicodeBlock("LINEAR_A", 232);
            MAHAJANI = new UnicodeBlock("MAHAJANI", 233);
            MANICHAEAN = new UnicodeBlock("MANICHAEAN", 234);
            MENDE_KIKAKUI = new UnicodeBlock("MENDE_KIKAKUI", 235);
            MODI = new UnicodeBlock("MODI", 236);
            MRO = new UnicodeBlock("MRO", 237);
            MYANMAR_EXTENDED_B = new UnicodeBlock("MYANMAR_EXTENDED_B", 238);
            NABATAEAN = new UnicodeBlock("NABATAEAN", 239);
            OLD_NORTH_ARABIAN = new UnicodeBlock("OLD_NORTH_ARABIAN", 240);
            OLD_PERMIC = new UnicodeBlock("OLD_PERMIC", 241);
            ORNAMENTAL_DINGBATS = new UnicodeBlock("ORNAMENTAL_DINGBATS", 242);
            PAHAWH_HMONG = new UnicodeBlock("PAHAWH_HMONG", 243);
            PALMYRENE = new UnicodeBlock("PALMYRENE", 244);
            PAU_CIN_HAU = new UnicodeBlock("PAU_CIN_HAU", 245);
            PSALTER_PAHLAVI = new UnicodeBlock("PSALTER_PAHLAVI", 246);
            SHORTHAND_FORMAT_CONTROLS = new UnicodeBlock("SHORTHAND_FORMAT_CONTROLS", 247);
            SIDDHAM = new UnicodeBlock("SIDDHAM", 248);
            SINHALA_ARCHAIC_NUMBERS = new UnicodeBlock("SINHALA_ARCHAIC_NUMBERS", 249);
            SUPPLEMENTAL_ARROWS_C = new UnicodeBlock("SUPPLEMENTAL_ARROWS_C", 250);
            TIRHUTA = new UnicodeBlock("TIRHUTA", 251);
            WARANG_CITI = new UnicodeBlock("WARANG_CITI", 252);
            AHOM = new UnicodeBlock("AHOM", 253);
            ANATOLIAN_HIEROGLYPHS = new UnicodeBlock("ANATOLIAN_HIEROGLYPHS", 254);
            CHEROKEE_SUPPLEMENT = new UnicodeBlock("CHEROKEE_SUPPLEMENT", 255);
            CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E", 256);
            EARLY_DYNASTIC_CUNEIFORM = new UnicodeBlock("EARLY_DYNASTIC_CUNEIFORM", 257);
            HATRAN = new UnicodeBlock("HATRAN", 258);
            MULTANI = new UnicodeBlock("MULTANI", 259);
            OLD_HUNGARIAN = new UnicodeBlock("OLD_HUNGARIAN", 260);
            SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS = new UnicodeBlock("SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS", 261);
            SUTTON_SIGNWRITING = new UnicodeBlock("SUTTON_SIGNWRITING", 262);
            ADLAM = new UnicodeBlock("ADLAM", 263);
            BHAIKSUKI = new UnicodeBlock("BHAIKSUKI", 264);
            CYRILLIC_EXTENDED_C = new UnicodeBlock("CYRILLIC_EXTENDED_C", 265);
            GLAGOLITIC_SUPPLEMENT = new UnicodeBlock("GLAGOLITIC_SUPPLEMENT", 266);
            IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION", 267);
            MARCHEN = new UnicodeBlock("MARCHEN", 268);
            MONGOLIAN_SUPPLEMENT = new UnicodeBlock("MONGOLIAN_SUPPLEMENT", 269);
            NEWA = new UnicodeBlock("NEWA", 270);
            OSAGE = new UnicodeBlock("OSAGE", 271);
            TANGUT = new UnicodeBlock("TANGUT", 272);
            TANGUT_COMPONENTS = new UnicodeBlock("TANGUT_COMPONENTS", 273);
            INVALID_CODE = new UnicodeBlock("INVALID_CODE", -1);
            for (int blockId = 0; blockId < 274; ++blockId) {
                if (BLOCKS_[blockId] != null) continue;
                throw new IllegalStateException("UnicodeBlock.BLOCKS_[" + blockId + "] not initialized");
            }
        }

        public static UnicodeBlock getInstance(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_lang_UCharacter_UnicodeBlock$getInstance(int ), 0, (int)n);
        }

        public static UnicodeBlock of(int n) {
            return InvokeDynamicSupport.bootstrapStatic("of", $$robo$$android_icu_lang_UCharacter_UnicodeBlock$of(int ), 0, (int)n);
        }

        public static UnicodeBlock forName(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("forName", $$robo$$android_icu_lang_UCharacter_UnicodeBlock$forName(java.lang.String ), 0, (String)string2);
        }

        private static String trimBlockName(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("trimBlockName", $$robo$$android_icu_lang_UCharacter_UnicodeBlock$trimBlockName(java.lang.String ), 0, (String)string2);
        }

        public int getID() {
            return (int)InvokeDynamicSupport.bootstrap("getID", $$robo$$android_icu_lang_UCharacter_UnicodeBlock$getID(), 0, this);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_lang_UCharacter_UnicodeBlock$__constructor__(string2, n);
        }

        private UnicodeBlock(String string2, int n) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_lang_UCharacter_UnicodeBlock$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(UnicodeBlock.class);
        }

        public /* synthetic */ UnicodeBlock() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnicodeBlock)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

