/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.locale;

import android.icu.impl.locale.AsciiUtil;
import android.icu.impl.locale.LocaleObjectCache;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BaseLocale
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean JDKIMPL = false;
    public static String SEP = "_";
    private static Cache CACHE;
    public static BaseLocale ROOT;
    private String _language;
    private String _script;
    private String _region;
    private String _variant;
    private volatile transient int _hash;

    private void $$robo$$android_icu_impl_locale_BaseLocale$__constructor__(String language, String script, String region, String variant) {
        this._language = "";
        this._script = "";
        this._region = "";
        this._variant = "";
        this._hash = 0;
        if (language != null) {
            this._language = AsciiUtil.toLowerString(language).intern();
        }
        if (script != null) {
            this._script = AsciiUtil.toTitleString(script).intern();
        }
        if (region != null) {
            this._region = AsciiUtil.toUpperString(region).intern();
        }
        if (variant != null) {
            this._variant = AsciiUtil.toUpperString(variant).intern();
        }
    }

    private static final BaseLocale $$robo$$android_icu_impl_locale_BaseLocale$getInstance(String language, String script, String region, String variant) {
        Key key = new Key(language, script, region, variant);
        BaseLocale baseLocale = (BaseLocale)CACHE.get(key);
        return baseLocale;
    }

    private final String $$robo$$android_icu_impl_locale_BaseLocale$getLanguage() {
        return this._language;
    }

    private final String $$robo$$android_icu_impl_locale_BaseLocale$getScript() {
        return this._script;
    }

    private final String $$robo$$android_icu_impl_locale_BaseLocale$getRegion() {
        return this._region;
    }

    private final String $$robo$$android_icu_impl_locale_BaseLocale$getVariant() {
        return this._variant;
    }

    private final boolean $$robo$$android_icu_impl_locale_BaseLocale$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseLocale)) {
            return false;
        }
        BaseLocale other = (BaseLocale)obj;
        return this.hashCode() == other.hashCode() && this._language.equals(other._language) && this._script.equals(other._script) && this._region.equals(other._region) && this._variant.equals(other._variant);
    }

    private final String $$robo$$android_icu_impl_locale_BaseLocale$toString() {
        StringBuilder buf = new StringBuilder();
        if (this._language.length() > 0) {
            buf.append("language=");
            buf.append(this._language);
        }
        if (this._script.length() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("script=");
            buf.append(this._script);
        }
        if (this._region.length() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("region=");
            buf.append(this._region);
        }
        if (this._variant.length() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("variant=");
            buf.append(this._variant);
        }
        return buf.toString();
    }

    private final int $$robo$$android_icu_impl_locale_BaseLocale$hashCode() {
        int h = this._hash;
        if (h == 0) {
            int i;
            for (i = 0; i < this._language.length(); ++i) {
                h = 31 * h + this._language.charAt(i);
            }
            for (i = 0; i < this._script.length(); ++i) {
                h = 31 * h + this._script.charAt(i);
            }
            for (i = 0; i < this._region.length(); ++i) {
                h = 31 * h + this._region.charAt(i);
            }
            for (i = 0; i < this._variant.length(); ++i) {
                h = 31 * h + this._variant.charAt(i);
            }
            this._hash = h;
        }
        return h;
    }

    private /* synthetic */ void $$robo$$android_icu_impl_locale_BaseLocale$__constructor__(String x0, String x1, String x2, String x3, 1 x4) {
    }

    static void __staticInitializer__() {
        CACHE = new Cache();
        ROOT = BaseLocale.getInstance("", "", "", "");
    }

    private void __constructor__(String string2, String string3, String string4, String string5) {
        this.$$robo$$android_icu_impl_locale_BaseLocale$__constructor__(string2, string3, string4, string5);
    }

    private BaseLocale(String string2, String string3, String string4, String string5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_BaseLocale$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5);
    }

    public static BaseLocale getInstance(String string2, String string3, String string4, String string5) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_impl_locale_BaseLocale$getInstance(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    public String getLanguage() {
        return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_icu_impl_locale_BaseLocale$getLanguage(), 0, this);
    }

    public String getScript() {
        return InvokeDynamicSupport.bootstrap("getScript", $$robo$$android_icu_impl_locale_BaseLocale$getScript(), 0, this);
    }

    public String getRegion() {
        return InvokeDynamicSupport.bootstrap("getRegion", $$robo$$android_icu_impl_locale_BaseLocale$getRegion(), 0, this);
    }

    public String getVariant() {
        return InvokeDynamicSupport.bootstrap("getVariant", $$robo$$android_icu_impl_locale_BaseLocale$getVariant(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_locale_BaseLocale$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_BaseLocale$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_locale_BaseLocale$hashCode(), 0, this);
    }

    private /* synthetic */ void __constructor__(String string2, String string3, String string4, String string5, 1 var5_5) {
        this.$$robo$$android_icu_impl_locale_BaseLocale$__constructor__(string2, string3, string4, string5, var5_5);
    }

    static {
        RobolectricInternals.classInitializing(BaseLocale.class);
    }

    public /* synthetic */ BaseLocale() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseLocale)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Cache
    extends LocaleObjectCache<Key, BaseLocale> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_locale_BaseLocale_Cache$__constructor__() {
        }

        private final Key $$robo$$android_icu_impl_locale_BaseLocale_Cache$normalizeKey(Key key) {
            return Key.normalize(key);
        }

        private final BaseLocale $$robo$$android_icu_impl_locale_BaseLocale_Cache$createObject(Key key) {
            return new BaseLocale(key._lang, key._scrt, key._regn, key._vart);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_BaseLocale_Cache$__constructor__();
        }

        public Cache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_BaseLocale_Cache$__constructor__(), 0, this);
        }

        @Override
        protected Key normalizeKey(Key key) {
            return InvokeDynamicSupport.bootstrap("normalizeKey", $$robo$$android_icu_impl_locale_BaseLocale_Cache$normalizeKey(android.icu.impl.locale.BaseLocale$Key ), 0, this, key);
        }

        @Override
        protected BaseLocale createObject(Key key) {
            return InvokeDynamicSupport.bootstrap("createObject", $$robo$$android_icu_impl_locale_BaseLocale_Cache$createObject(android.icu.impl.locale.BaseLocale$Key ), 0, this, key);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Key
    implements Comparable<Key> {
        public transient /* synthetic */ Object __robo_data__;
        private String _lang;
        private String _scrt;
        private String _regn;
        private String _vart;
        private volatile int _hash;

        private void $$robo$$android_icu_impl_locale_BaseLocale_Key$__constructor__(String language, String script, String region, String variant) {
            this._lang = "";
            this._scrt = "";
            this._regn = "";
            this._vart = "";
            if (language != null) {
                this._lang = language;
            }
            if (script != null) {
                this._scrt = script;
            }
            if (region != null) {
                this._regn = region;
            }
            if (variant != null) {
                this._vart = variant;
            }
        }

        private final boolean $$robo$$android_icu_impl_locale_BaseLocale_Key$equals(Object obj) {
            return this == obj || obj instanceof Key && AsciiUtil.caseIgnoreMatch(((Key)obj)._lang, this._lang) && AsciiUtil.caseIgnoreMatch(((Key)obj)._scrt, this._scrt) && AsciiUtil.caseIgnoreMatch(((Key)obj)._regn, this._regn) && AsciiUtil.caseIgnoreMatch(((Key)obj)._vart, this._vart);
        }

        private final int $$robo$$android_icu_impl_locale_BaseLocale_Key$compareTo(Key other) {
            int res = AsciiUtil.caseIgnoreCompare(this._lang, other._lang);
            if (res == 0 && (res = AsciiUtil.caseIgnoreCompare(this._scrt, other._scrt)) == 0 && (res = AsciiUtil.caseIgnoreCompare(this._regn, other._regn)) == 0) {
                res = AsciiUtil.caseIgnoreCompare(this._vart, other._vart);
            }
            return res;
        }

        private final int $$robo$$android_icu_impl_locale_BaseLocale_Key$hashCode() {
            int h = this._hash;
            if (h == 0) {
                int i;
                for (i = 0; i < this._lang.length(); ++i) {
                    h = 31 * h + AsciiUtil.toLower(this._lang.charAt(i));
                }
                for (i = 0; i < this._scrt.length(); ++i) {
                    h = 31 * h + AsciiUtil.toLower(this._scrt.charAt(i));
                }
                for (i = 0; i < this._regn.length(); ++i) {
                    h = 31 * h + AsciiUtil.toLower(this._regn.charAt(i));
                }
                for (i = 0; i < this._vart.length(); ++i) {
                    h = 31 * h + AsciiUtil.toLower(this._vart.charAt(i));
                }
                this._hash = h;
            }
            return h;
        }

        private static final Key $$robo$$android_icu_impl_locale_BaseLocale_Key$normalize(Key key) {
            String lang = AsciiUtil.toLowerString(key._lang).intern();
            String scrt = AsciiUtil.toTitleString(key._scrt).intern();
            String regn = AsciiUtil.toUpperString(key._regn).intern();
            String vart = AsciiUtil.toUpperString(key._vart).intern();
            return new Key(lang, scrt, regn, vart);
        }

        private void __constructor__(String string2, String string3, String string4, String string5) {
            this.$$robo$$android_icu_impl_locale_BaseLocale_Key$__constructor__(string2, string3, string4, string5);
        }

        public Key(String string2, String string3, String string4, String string5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_BaseLocale_Key$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_locale_BaseLocale_Key$equals(java.lang.Object ), 0, this, object);
        }

        @Override
        public int compareTo(Key key) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_impl_locale_BaseLocale_Key$compareTo(android.icu.impl.locale.BaseLocale$Key ), 0, this, key);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_locale_BaseLocale_Key$hashCode(), 0, this);
        }

        public static Key normalize(Key key) {
            return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_impl_locale_BaseLocale_Key$normalize(android.icu.impl.locale.BaseLocale$Key ), 0, (Key)key);
        }

        public /* synthetic */ Key() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Key)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

