/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.UCharacterName;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UCharacterNameReader
implements ICUBinary.Authenticate,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ByteBuffer m_byteBuffer_;
    private static int GROUP_INFO_SIZE_ = 3;
    private int m_tokenstringindex_;
    private int m_groupindex_;
    private int m_groupstringindex_;
    private int m_algnamesindex_;
    private static int ALG_INFO_SIZE_ = 12;
    private static int DATA_FORMAT_ID_ = 1970168173;

    private final boolean $$robo$$android_icu_impl_UCharacterNameReader$isDataVersionAcceptable(byte[] version) {
        return version[0] == 1;
    }

    private void $$robo$$android_icu_impl_UCharacterNameReader$__constructor__(ByteBuffer bytes) throws IOException {
        ICUBinary.readHeader(bytes, 1970168173, this);
        this.m_byteBuffer_ = bytes;
    }

    private final void $$robo$$android_icu_impl_UCharacterNameReader$read(UCharacterName data) throws IOException {
        this.m_tokenstringindex_ = this.m_byteBuffer_.getInt();
        this.m_groupindex_ = this.m_byteBuffer_.getInt();
        this.m_groupstringindex_ = this.m_byteBuffer_.getInt();
        this.m_algnamesindex_ = this.m_byteBuffer_.getInt();
        int count = this.m_byteBuffer_.getChar();
        char[] token = ICUBinary.getChars(this.m_byteBuffer_, count, 0);
        int size = this.m_groupindex_ - this.m_tokenstringindex_;
        byte[] tokenstr = new byte[size];
        this.m_byteBuffer_.get(tokenstr);
        data.setToken(token, tokenstr);
        count = this.m_byteBuffer_.getChar();
        data.setGroupCountSize(count, 3);
        char[] group = ICUBinary.getChars(this.m_byteBuffer_, count *= 3, 0);
        size = this.m_algnamesindex_ - this.m_groupstringindex_;
        byte[] groupstring = new byte[size];
        this.m_byteBuffer_.get(groupstring);
        data.setGroup(group, groupstring);
        count = this.m_byteBuffer_.getInt();
        UCharacterName.AlgorithmName[] alg = new UCharacterName.AlgorithmName[count];
        for (int i = 0; i < count; ++i) {
            UCharacterName.AlgorithmName an = this.readAlg();
            if (an == null) {
                throw new IOException("unames.icu read error: Algorithmic names creation error");
            }
            alg[i] = an;
        }
        data.setAlgorithm(alg);
    }

    private final boolean $$robo$$android_icu_impl_UCharacterNameReader$authenticate(byte[] dataformatid, byte[] dataformatversion) {
        return Arrays.equals(ICUBinary.getVersionByteArrayFromCompactInt(1970168173), dataformatid) && this.isDataVersionAcceptable(dataformatversion);
    }

    private final UCharacterName.AlgorithmName $$robo$$android_icu_impl_UCharacterNameReader$readAlg() throws IOException {
        byte variant;
        byte type;
        int rangeend;
        UCharacterName.AlgorithmName result = new UCharacterName.AlgorithmName();
        int rangestart = this.m_byteBuffer_.getInt();
        if (!result.setInfo(rangestart, rangeend = this.m_byteBuffer_.getInt(), type = this.m_byteBuffer_.get(), variant = this.m_byteBuffer_.get())) {
            return null;
        }
        int size = this.m_byteBuffer_.getChar();
        if (type == 1) {
            char[] factor = ICUBinary.getChars(this.m_byteBuffer_, variant, 0);
            result.setFactor(factor);
            size -= variant << 1;
        }
        StringBuilder prefix = new StringBuilder();
        char c = (char)(this.m_byteBuffer_.get() & 0xFF);
        while (c != '\u0000') {
            prefix.append(c);
            c = (char)(this.m_byteBuffer_.get() & 0xFF);
        }
        result.setPrefix(prefix.toString());
        if ((size -= 12 + prefix.length() + 1) > 0) {
            byte[] string2 = new byte[size];
            this.m_byteBuffer_.get(string2);
            result.setFactorString(string2);
        }
        return result;
    }

    @Override
    public boolean isDataVersionAcceptable(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_UCharacterNameReader$isDataVersionAcceptable(byte[] ), 0, this, byArray);
    }

    private void __constructor__(ByteBuffer byteBuffer) throws IOException {
        this.$$robo$$android_icu_impl_UCharacterNameReader$__constructor__(byteBuffer);
    }

    protected UCharacterNameReader(ByteBuffer byteBuffer) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UCharacterNameReader$__constructor__(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    protected void read(UCharacterName uCharacterName) throws IOException {
        InvokeDynamicSupport.bootstrap("read", $$robo$$android_icu_impl_UCharacterNameReader$read(android.icu.impl.UCharacterName ), 0, this, uCharacterName);
    }

    protected boolean authenticate(byte[] byArray, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_icu_impl_UCharacterNameReader$authenticate(byte[] byte[] ), 0, this, byArray, byArray2);
    }

    private UCharacterName.AlgorithmName readAlg() throws IOException {
        return InvokeDynamicSupport.bootstrap("readAlg", $$robo$$android_icu_impl_UCharacterNameReader$readAlg(), 0, this);
    }

    public /* synthetic */ UCharacterNameReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UCharacterNameReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

