/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.TextTrieMap;
import android.icu.impl.TimeZoneNamesImpl;
import android.icu.text.TimeZoneNames;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TZDBTimeZoneNames
extends TimeZoneNames
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 1L;
    private static ConcurrentHashMap<String, TZDBNames> TZDB_NAMES_MAP;
    private static volatile TextTrieMap<TZDBNameInfo> TZDB_NAMES_TRIE;
    private static ICUResourceBundle ZONESTRINGS;
    private ULocale _locale;
    private volatile transient String _region;

    private void $$robo$$android_icu_impl_TZDBTimeZoneNames$__constructor__(ULocale loc) {
        this._locale = loc;
    }

    private final Set<String> $$robo$$android_icu_impl_TZDBTimeZoneNames$getAvailableMetaZoneIDs() {
        return TimeZoneNamesImpl._getAvailableMetaZoneIDs();
    }

    private final Set<String> $$robo$$android_icu_impl_TZDBTimeZoneNames$getAvailableMetaZoneIDs(String tzID) {
        return TimeZoneNamesImpl._getAvailableMetaZoneIDs(tzID);
    }

    private final String $$robo$$android_icu_impl_TZDBTimeZoneNames$getMetaZoneID(String tzID, long date) {
        return TimeZoneNamesImpl._getMetaZoneID(tzID, date);
    }

    private final String $$robo$$android_icu_impl_TZDBTimeZoneNames$getReferenceZoneID(String mzID, String region) {
        return TimeZoneNamesImpl._getReferenceZoneID(mzID, region);
    }

    private final String $$robo$$android_icu_impl_TZDBTimeZoneNames$getMetaZoneDisplayName(String mzID, TimeZoneNames.NameType type) {
        if (mzID == null || mzID.length() == 0 || type != TimeZoneNames.NameType.SHORT_STANDARD && type != TimeZoneNames.NameType.SHORT_DAYLIGHT) {
            return null;
        }
        return TZDBTimeZoneNames.getMetaZoneNames(mzID).getName(type);
    }

    private final String $$robo$$android_icu_impl_TZDBTimeZoneNames$getTimeZoneDisplayName(String tzID, TimeZoneNames.NameType type) {
        return null;
    }

    private final Collection<TimeZoneNames.MatchInfo> $$robo$$android_icu_impl_TZDBTimeZoneNames$find(CharSequence text, int start, EnumSet<TimeZoneNames.NameType> nameTypes) {
        if (text == null || text.length() == 0 || start < 0 || start >= text.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        TZDBTimeZoneNames.prepareFind();
        TZDBNameSearchHandler handler = new TZDBNameSearchHandler(nameTypes, this.getTargetRegion());
        TZDB_NAMES_TRIE.find(text, start, (TextTrieMap.ResultHandler<TZDBNameInfo>)handler);
        return handler.getMatches();
    }

    private static final TZDBNames $$robo$$android_icu_impl_TZDBTimeZoneNames$getMetaZoneNames(String mzID) {
        TZDBNames names = TZDB_NAMES_MAP.get(mzID);
        if (names == null) {
            names = TZDBNames.getInstance(ZONESTRINGS, "meta:" + mzID);
            TZDBNames tmpNames = TZDB_NAMES_MAP.putIfAbsent(mzID = mzID.intern(), names);
            names = tmpNames == null ? names : tmpNames;
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void $$robo$$android_icu_impl_TZDBTimeZoneNames$prepareFind() {
        if (TZDB_NAMES_TRIE != null) return;
        Class<TZDBTimeZoneNames> clazz = TZDBTimeZoneNames.class;
        synchronized (TZDBTimeZoneNames.class) {
            if (TZDB_NAMES_TRIE != null) return;
            TextTrieMap<TZDBNameInfo> trie = new TextTrieMap<TZDBNameInfo>(true);
            Set<String> mzIDs = TimeZoneNamesImpl._getAvailableMetaZoneIDs();
            for (String mzID : mzIDs) {
                boolean ambiguousType;
                TZDBNames names = TZDBTimeZoneNames.getMetaZoneNames(mzID);
                String std = names.getName(TimeZoneNames.NameType.SHORT_STANDARD);
                String dst = names.getName(TimeZoneNames.NameType.SHORT_DAYLIGHT);
                if (std == null && dst == null) continue;
                String[] parseRegions = names.getParseRegions();
                mzID = mzID.intern();
                boolean bl = ambiguousType = std != null && dst != null && std.equals(dst);
                if (std != null) {
                    TZDBNameInfo stdInf = new TZDBNameInfo(mzID, TimeZoneNames.NameType.SHORT_STANDARD, ambiguousType, parseRegions);
                    trie.put(std, stdInf);
                }
                if (dst == null) continue;
                TZDBNameInfo dstInf = new TZDBNameInfo(mzID, TimeZoneNames.NameType.SHORT_DAYLIGHT, ambiguousType, parseRegions);
                trie.put(dst, dstInf);
            }
            TZDB_NAMES_TRIE = trie;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private final String $$robo$$android_icu_impl_TZDBTimeZoneNames$getTargetRegion() {
        if (this._region == null) {
            ULocale tmp;
            String region = this._locale.getCountry();
            if (region.length() == 0 && (region = (tmp = ULocale.addLikelySubtags(this._locale)).getCountry()).length() == 0) {
                region = "001";
            }
            this._region = region;
        }
        return this._region;
    }

    static void __staticInitializer__() {
        TZDB_NAMES_MAP = new ConcurrentHashMap();
        TZDB_NAMES_TRIE = null;
        UResourceBundle bundle = ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/zone", "tzdbNames");
        ZONESTRINGS = (ICUResourceBundle)bundle.get("zoneStrings");
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_impl_TZDBTimeZoneNames$__constructor__(uLocale);
    }

    public TZDBTimeZoneNames(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TZDBTimeZoneNames$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Override
    public Set<String> getAvailableMetaZoneIDs() {
        return InvokeDynamicSupport.bootstrap("getAvailableMetaZoneIDs", $$robo$$android_icu_impl_TZDBTimeZoneNames$getAvailableMetaZoneIDs(), 0, this);
    }

    @Override
    public Set<String> getAvailableMetaZoneIDs(String string2) {
        return InvokeDynamicSupport.bootstrap("getAvailableMetaZoneIDs", $$robo$$android_icu_impl_TZDBTimeZoneNames$getAvailableMetaZoneIDs(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getMetaZoneID(String string2, long l) {
        return InvokeDynamicSupport.bootstrap("getMetaZoneID", $$robo$$android_icu_impl_TZDBTimeZoneNames$getMetaZoneID(java.lang.String long ), 0, this, string2, l);
    }

    @Override
    public String getReferenceZoneID(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getReferenceZoneID", $$robo$$android_icu_impl_TZDBTimeZoneNames$getReferenceZoneID(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public String getMetaZoneDisplayName(String string2, TimeZoneNames.NameType nameType) {
        return InvokeDynamicSupport.bootstrap("getMetaZoneDisplayName", $$robo$$android_icu_impl_TZDBTimeZoneNames$getMetaZoneDisplayName(java.lang.String android.icu.text.TimeZoneNames$NameType ), 0, this, string2, nameType);
    }

    @Override
    public String getTimeZoneDisplayName(String string2, TimeZoneNames.NameType nameType) {
        return InvokeDynamicSupport.bootstrap("getTimeZoneDisplayName", $$robo$$android_icu_impl_TZDBTimeZoneNames$getTimeZoneDisplayName(java.lang.String android.icu.text.TimeZoneNames$NameType ), 0, this, string2, nameType);
    }

    @Override
    public Collection<TimeZoneNames.MatchInfo> find(CharSequence charSequence, int n, EnumSet<TimeZoneNames.NameType> enumSet) {
        return InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_impl_TZDBTimeZoneNames$find(java.lang.CharSequence int java.util.EnumSet<android.icu.text.TimeZoneNames$NameType> ), 0, this, charSequence, n, enumSet);
    }

    private static TZDBNames getMetaZoneNames(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getMetaZoneNames", $$robo$$android_icu_impl_TZDBTimeZoneNames$getMetaZoneNames(java.lang.String ), 0, (String)string2);
    }

    private static void prepareFind() {
        InvokeDynamicSupport.bootstrapStatic("prepareFind", $$robo$$android_icu_impl_TZDBTimeZoneNames$prepareFind(), 0);
    }

    private String getTargetRegion() {
        return InvokeDynamicSupport.bootstrap("getTargetRegion", $$robo$$android_icu_impl_TZDBTimeZoneNames$getTargetRegion(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TZDBTimeZoneNames.class);
    }

    public /* synthetic */ TZDBTimeZoneNames() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TZDBTimeZoneNames)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TZDBNameSearchHandler
    implements TextTrieMap.ResultHandler<TZDBNameInfo> {
        public transient /* synthetic */ Object __robo_data__;
        private EnumSet<TimeZoneNames.NameType> _nameTypes;
        private Collection<TimeZoneNames.MatchInfo> _matches;
        private String _region;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameSearchHandler$__constructor__(EnumSet<TimeZoneNames.NameType> nameTypes, String region) {
            this._nameTypes = nameTypes;
            if (!$assertionsDisabled && region == null) {
                throw new AssertionError();
            }
            this._region = region;
        }

        private final boolean $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameSearchHandler$handlePrefixMatch(int matchLength, Iterator<TZDBNameInfo> values) {
            TZDBNameInfo match = null;
            TZDBNameInfo defaultRegionMatch = null;
            while (values.hasNext()) {
                TZDBNameInfo ninfo = values.next();
                if (this._nameTypes != null && !this._nameTypes.contains((Object)ninfo.type)) continue;
                if (ninfo.parseRegions == null) {
                    if (defaultRegionMatch != null) continue;
                    match = defaultRegionMatch = ninfo;
                    continue;
                }
                boolean matchRegion = false;
                for (String region : ninfo.parseRegions) {
                    if (!this._region.equals(region)) continue;
                    match = ninfo;
                    matchRegion = true;
                    break;
                }
                if (matchRegion) break;
                if (match != null) continue;
                match = ninfo;
            }
            if (match != null) {
                TimeZoneNames.NameType ntype = match.type;
                if (match.ambiguousType && (ntype == TimeZoneNames.NameType.SHORT_STANDARD || ntype == TimeZoneNames.NameType.SHORT_DAYLIGHT) && this._nameTypes.contains((Object)TimeZoneNames.NameType.SHORT_STANDARD) && this._nameTypes.contains((Object)TimeZoneNames.NameType.SHORT_DAYLIGHT)) {
                    ntype = TimeZoneNames.NameType.SHORT_GENERIC;
                }
                TimeZoneNames.MatchInfo minfo = new TimeZoneNames.MatchInfo(ntype, null, match.mzID, matchLength);
                if (this._matches == null) {
                    this._matches = new LinkedList<TimeZoneNames.MatchInfo>();
                }
                this._matches.add(minfo);
            }
            return true;
        }

        private final Collection<TimeZoneNames.MatchInfo> $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameSearchHandler$getMatches() {
            if (this._matches == null) {
                return Collections.emptyList();
            }
            return this._matches;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !TZDBTimeZoneNames.class.desiredAssertionStatus();
        }

        private void __constructor__(EnumSet<TimeZoneNames.NameType> enumSet, String string2) {
            this.$$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameSearchHandler$__constructor__(enumSet, string2);
        }

        TZDBNameSearchHandler(EnumSet<TimeZoneNames.NameType> enumSet, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameSearchHandler$__constructor__(java.util.EnumSet<android.icu.text.TimeZoneNames$NameType> java.lang.String ), 0, this, enumSet, string2);
        }

        @Override
        public boolean handlePrefixMatch(int n, Iterator<TZDBNameInfo> iterator) {
            return (boolean)InvokeDynamicSupport.bootstrap("handlePrefixMatch", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameSearchHandler$handlePrefixMatch(int java.util.Iterator<android.icu.impl.TZDBTimeZoneNames$TZDBNameInfo> ), 0, this, n, iterator);
        }

        public Collection<TimeZoneNames.MatchInfo> getMatches() {
            return InvokeDynamicSupport.bootstrap("getMatches", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameSearchHandler$getMatches(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(TZDBNameSearchHandler.class);
        }

        public /* synthetic */ TZDBNameSearchHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TZDBNameSearchHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class TZDBNameInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mzID;
        TimeZoneNames.NameType type;
        boolean ambiguousType;
        String[] parseRegions;

        private void $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameInfo$__constructor__(String mzID, TimeZoneNames.NameType type, boolean ambiguousType, String[] parseRegions) {
            this.mzID = mzID;
            this.type = type;
            this.ambiguousType = ambiguousType;
            this.parseRegions = parseRegions;
        }

        private void __constructor__(String string2, TimeZoneNames.NameType nameType, boolean bl, String[] stringArray) {
            this.$$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameInfo$__constructor__(string2, nameType, bl, stringArray);
        }

        TZDBNameInfo(String string2, TimeZoneNames.NameType nameType, boolean bl, String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNameInfo$__constructor__(java.lang.String android.icu.text.TimeZoneNames$NameType boolean java.lang.String[] ), 0, this, string2, nameType, bl, stringArray);
        }

        public /* synthetic */ TZDBNameInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TZDBNameInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class TZDBNames
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static TZDBNames EMPTY_TZDBNAMES;
        private String[] _names;
        private String[] _parseRegions;
        private static String[] KEYS;

        private void $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$__constructor__(String[] names, String[] parseRegions) {
            this._names = names;
            this._parseRegions = parseRegions;
        }

        private static final TZDBNames $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$getInstance(ICUResourceBundle zoneStrings, String key) {
            if (zoneStrings == null || key == null || key.length() == 0) {
                return EMPTY_TZDBNAMES;
            }
            ICUResourceBundle table = null;
            try {
                table = (ICUResourceBundle)zoneStrings.get(key);
            }
            catch (MissingResourceException e) {
                return EMPTY_TZDBNAMES;
            }
            boolean isEmpty = true;
            String[] names = new String[KEYS.length];
            for (int i = 0; i < names.length; ++i) {
                try {
                    names[i] = table.getString(KEYS[i]);
                    isEmpty = false;
                    continue;
                }
                catch (MissingResourceException e) {
                    names[i] = null;
                }
            }
            if (isEmpty) {
                return EMPTY_TZDBNAMES;
            }
            String[] parseRegions = null;
            try {
                ICUResourceBundle regionsRes = (ICUResourceBundle)table.get("parseRegions");
                if (regionsRes.getType() == 0) {
                    parseRegions = new String[]{regionsRes.getString()};
                } else if (regionsRes.getType() == 8) {
                    parseRegions = regionsRes.getStringArray();
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return new TZDBNames(names, parseRegions);
        }

        private final String $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$getName(TimeZoneNames.NameType type) {
            if (this._names == null) {
                return null;
            }
            String name = null;
            switch (1.$SwitchMap$android$icu$text$TimeZoneNames$NameType[type.ordinal()]) {
                case 1: {
                    name = this._names[0];
                    break;
                }
                case 2: {
                    name = this._names[1];
                }
            }
            return name;
        }

        private final String[] $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$getParseRegions() {
            return this._parseRegions;
        }

        static void __staticInitializer__() {
            EMPTY_TZDBNAMES = new TZDBNames(null, null);
            KEYS = new String[]{"ss", "sd"};
        }

        private void __constructor__(String[] stringArray, String[] stringArray2) {
            this.$$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$__constructor__(stringArray, stringArray2);
        }

        private TZDBNames(String[] stringArray, String[] stringArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$__constructor__(java.lang.String[] java.lang.String[] ), 0, this, stringArray, stringArray2);
        }

        static TZDBNames getInstance(ICUResourceBundle iCUResourceBundle, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$getInstance(android.icu.impl.ICUResourceBundle java.lang.String ), 0, (ICUResourceBundle)iCUResourceBundle, (String)string2);
        }

        String getName(TimeZoneNames.NameType nameType) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$getName(android.icu.text.TimeZoneNames$NameType ), 0, this, nameType);
        }

        String[] getParseRegions() {
            return InvokeDynamicSupport.bootstrap("getParseRegions", $$robo$$android_icu_impl_TZDBTimeZoneNames_TZDBNames$getParseRegions(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(TZDBNames.class);
        }

        public /* synthetic */ TZDBNames() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TZDBNames)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

