/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.Utility;
import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PatternTokenizer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private UnicodeSet ignorableCharacters;
    private UnicodeSet syntaxCharacters;
    private UnicodeSet extraQuotingCharacters;
    private UnicodeSet escapeCharacters;
    private boolean usingSlash;
    private boolean usingQuote;
    private transient UnicodeSet needingQuoteCharacters;
    private int start;
    private int limit;
    private String pattern;
    public static char SINGLE_QUOTE = '\'';
    public static char BACK_SLASH = '\\';
    private static int NO_QUOTE;
    private static int IN_QUOTE;
    public static int DONE = 0;
    public static int SYNTAX = 1;
    public static int LITERAL = 2;
    public static int BROKEN_QUOTE = 3;
    public static int BROKEN_ESCAPE = 4;
    public static int UNKNOWN = 5;
    private static int AFTER_QUOTE = -1;
    private static int NONE = 0;
    private static int START_QUOTE = 1;
    private static int NORMAL_QUOTE = 2;
    private static int SLASH_START = 3;
    private static int HEX = 4;

    private void $$robo$$android_icu_impl_PatternTokenizer$__constructor__() {
        this.ignorableCharacters = new UnicodeSet();
        this.syntaxCharacters = new UnicodeSet();
        this.extraQuotingCharacters = new UnicodeSet();
        this.escapeCharacters = new UnicodeSet();
        this.usingSlash = false;
        this.usingQuote = false;
        this.needingQuoteCharacters = null;
    }

    private final UnicodeSet $$robo$$android_icu_impl_PatternTokenizer$getIgnorableCharacters() {
        return (UnicodeSet)this.ignorableCharacters.clone();
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setIgnorableCharacters(UnicodeSet ignorableCharacters) {
        this.ignorableCharacters = (UnicodeSet)ignorableCharacters.clone();
        this.needingQuoteCharacters = null;
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_impl_PatternTokenizer$getSyntaxCharacters() {
        return (UnicodeSet)this.syntaxCharacters.clone();
    }

    private final UnicodeSet $$robo$$android_icu_impl_PatternTokenizer$getExtraQuotingCharacters() {
        return (UnicodeSet)this.extraQuotingCharacters.clone();
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setSyntaxCharacters(UnicodeSet syntaxCharacters) {
        this.syntaxCharacters = (UnicodeSet)syntaxCharacters.clone();
        this.needingQuoteCharacters = null;
        return this;
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setExtraQuotingCharacters(UnicodeSet syntaxCharacters) {
        this.extraQuotingCharacters = (UnicodeSet)syntaxCharacters.clone();
        this.needingQuoteCharacters = null;
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_impl_PatternTokenizer$getEscapeCharacters() {
        return (UnicodeSet)this.escapeCharacters.clone();
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setEscapeCharacters(UnicodeSet escapeCharacters) {
        this.escapeCharacters = (UnicodeSet)escapeCharacters.clone();
        return this;
    }

    private final boolean $$robo$$android_icu_impl_PatternTokenizer$isUsingQuote() {
        return this.usingQuote;
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setUsingQuote(boolean usingQuote) {
        this.usingQuote = usingQuote;
        this.needingQuoteCharacters = null;
        return this;
    }

    private final boolean $$robo$$android_icu_impl_PatternTokenizer$isUsingSlash() {
        return this.usingSlash;
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setUsingSlash(boolean usingSlash) {
        this.usingSlash = usingSlash;
        this.needingQuoteCharacters = null;
        return this;
    }

    private final int $$robo$$android_icu_impl_PatternTokenizer$getLimit() {
        return this.limit;
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    private final int $$robo$$android_icu_impl_PatternTokenizer$getStart() {
        return this.start;
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setStart(int start) {
        this.start = start;
        return this;
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setPattern(CharSequence pattern) {
        return this.setPattern(pattern.toString());
    }

    private final PatternTokenizer $$robo$$android_icu_impl_PatternTokenizer$setPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Inconsistent arguments");
        }
        this.start = 0;
        this.limit = pattern.length();
        this.pattern = pattern;
        return this;
    }

    private final String $$robo$$android_icu_impl_PatternTokenizer$quoteLiteral(CharSequence string2) {
        return this.quoteLiteral(string2.toString());
    }

    private final String $$robo$$android_icu_impl_PatternTokenizer$quoteLiteral(String string2) {
        int cp;
        if (this.needingQuoteCharacters == null) {
            this.needingQuoteCharacters = new UnicodeSet().addAll(this.syntaxCharacters).addAll(this.ignorableCharacters).addAll(this.extraQuotingCharacters);
            if (this.usingSlash) {
                this.needingQuoteCharacters.add(92);
            }
            if (this.usingQuote) {
                this.needingQuoteCharacters.add(39);
            }
        }
        StringBuffer result = new StringBuffer();
        int quotedChar = NO_QUOTE;
        for (int i = 0; i < string2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(string2, i);
            if (this.escapeCharacters.contains(cp)) {
                if (quotedChar == IN_QUOTE) {
                    result.append('\'');
                    quotedChar = NO_QUOTE;
                }
                this.appendEscaped(result, cp);
                continue;
            }
            if (this.needingQuoteCharacters.contains(cp)) {
                if (quotedChar == IN_QUOTE) {
                    UTF16.append(result, cp);
                    if (!this.usingQuote || cp != 39) continue;
                    result.append('\'');
                    continue;
                }
                if (this.usingSlash) {
                    result.append('\\');
                    UTF16.append(result, cp);
                    continue;
                }
                if (this.usingQuote) {
                    if (cp == 39) {
                        result.append('\'');
                        result.append('\'');
                        continue;
                    }
                    result.append('\'');
                    UTF16.append(result, cp);
                    quotedChar = IN_QUOTE;
                    continue;
                }
                this.appendEscaped(result, cp);
                continue;
            }
            if (quotedChar == IN_QUOTE) {
                result.append('\'');
                quotedChar = NO_QUOTE;
            }
            UTF16.append(result, cp);
        }
        if (quotedChar == IN_QUOTE) {
            result.append('\'');
        }
        return result.toString();
    }

    private final void $$robo$$android_icu_impl_PatternTokenizer$appendEscaped(StringBuffer result, int cp) {
        if (cp <= 65535) {
            result.append("\\u").append(Utility.hex(cp, 4));
        } else {
            result.append("\\U").append(Utility.hex(cp, 8));
        }
    }

    private final String $$robo$$android_icu_impl_PatternTokenizer$normalize() {
        int oldStart = this.start;
        StringBuffer result = new StringBuffer();
        StringBuffer buffer = new StringBuffer();
        while (true) {
            buffer.setLength(0);
            int status = this.next(buffer);
            if (status == 0) {
                this.start = oldStart;
                return result.toString();
            }
            if (status != 1) {
                result.append(this.quoteLiteral(buffer));
                continue;
            }
            result.append(buffer);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int $$robo$$android_icu_impl_PatternTokenizer$next(StringBuffer buffer) {
        int cp;
        if (this.start >= this.limit) {
            return 0;
        }
        int status = 5;
        int lastQuote = 5;
        int quoteStatus = 0;
        int hexCount = 0;
        int hexValue = 0;
        block21: for (int i = this.start; i < this.limit; i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(this.pattern, i);
            switch (quoteStatus) {
                case 3: {
                    switch (cp) {
                        case 117: {
                            quoteStatus = 4;
                            hexCount = 4;
                            hexValue = 0;
                            continue block21;
                        }
                        case 85: {
                            quoteStatus = 4;
                            hexCount = 8;
                            hexValue = 0;
                            continue block21;
                        }
                        default: {
                            if (this.usingSlash) {
                                UTF16.append(buffer, cp);
                                quoteStatus = 0;
                                continue block21;
                            }
                            buffer.append('\\');
                            quoteStatus = 0;
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    hexValue <<= 4;
                    hexValue += cp;
                    switch (cp) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            hexValue -= 48;
                            break;
                        }
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            hexValue -= 87;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: {
                            hexValue -= 55;
                            break;
                        }
                        default: {
                            this.start = i;
                            return 4;
                        }
                    }
                    if (--hexCount != 0) continue block21;
                    quoteStatus = 0;
                    UTF16.append(buffer, hexValue);
                    continue block21;
                }
                case -1: {
                    if (cp == lastQuote) {
                        UTF16.append(buffer, cp);
                        quoteStatus = 2;
                        continue block21;
                    }
                    quoteStatus = 0;
                    break;
                }
                case 1: {
                    if (cp == lastQuote) {
                        UTF16.append(buffer, cp);
                        quoteStatus = 0;
                        continue block21;
                    }
                    UTF16.append(buffer, cp);
                    quoteStatus = 2;
                    continue block21;
                }
                case 2: {
                    if (cp == lastQuote) {
                        quoteStatus = -1;
                        continue block21;
                    }
                    UTF16.append(buffer, cp);
                    continue block21;
                }
            }
            if (this.ignorableCharacters.contains(cp)) continue;
            if (this.syntaxCharacters.contains(cp)) {
                if (status == 5) {
                    UTF16.append(buffer, cp);
                    this.start = i + UTF16.getCharCount(cp);
                    return 1;
                }
                this.start = i;
                return status;
            }
            status = 2;
            if (cp == 92) {
                quoteStatus = 3;
                continue;
            }
            if (this.usingQuote && cp == 39) {
                lastQuote = cp;
                quoteStatus = 1;
                continue;
            }
            UTF16.append(buffer, cp);
        }
        this.start = this.limit;
        switch (quoteStatus) {
            case 4: {
                return 4;
            }
            case 3: {
                if (this.usingSlash) {
                    return 4;
                }
                buffer.append('\\');
                return status;
            }
            case 1: 
            case 2: {
                return 3;
            }
        }
        return status;
    }

    static void __staticInitializer__() {
        NO_QUOTE = -1;
        IN_QUOTE = -2;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_PatternTokenizer$__constructor__();
    }

    public PatternTokenizer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_PatternTokenizer$__constructor__(), 0, this);
    }

    public UnicodeSet getIgnorableCharacters() {
        return InvokeDynamicSupport.bootstrap("getIgnorableCharacters", $$robo$$android_icu_impl_PatternTokenizer$getIgnorableCharacters(), 0, this);
    }

    public PatternTokenizer setIgnorableCharacters(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("setIgnorableCharacters", $$robo$$android_icu_impl_PatternTokenizer$setIgnorableCharacters(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public UnicodeSet getSyntaxCharacters() {
        return InvokeDynamicSupport.bootstrap("getSyntaxCharacters", $$robo$$android_icu_impl_PatternTokenizer$getSyntaxCharacters(), 0, this);
    }

    public UnicodeSet getExtraQuotingCharacters() {
        return InvokeDynamicSupport.bootstrap("getExtraQuotingCharacters", $$robo$$android_icu_impl_PatternTokenizer$getExtraQuotingCharacters(), 0, this);
    }

    public PatternTokenizer setSyntaxCharacters(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("setSyntaxCharacters", $$robo$$android_icu_impl_PatternTokenizer$setSyntaxCharacters(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public PatternTokenizer setExtraQuotingCharacters(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("setExtraQuotingCharacters", $$robo$$android_icu_impl_PatternTokenizer$setExtraQuotingCharacters(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public UnicodeSet getEscapeCharacters() {
        return InvokeDynamicSupport.bootstrap("getEscapeCharacters", $$robo$$android_icu_impl_PatternTokenizer$getEscapeCharacters(), 0, this);
    }

    public PatternTokenizer setEscapeCharacters(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("setEscapeCharacters", $$robo$$android_icu_impl_PatternTokenizer$setEscapeCharacters(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public boolean isUsingQuote() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsingQuote", $$robo$$android_icu_impl_PatternTokenizer$isUsingQuote(), 0, this);
    }

    public PatternTokenizer setUsingQuote(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setUsingQuote", $$robo$$android_icu_impl_PatternTokenizer$setUsingQuote(boolean ), 0, this, bl);
    }

    public boolean isUsingSlash() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsingSlash", $$robo$$android_icu_impl_PatternTokenizer$isUsingSlash(), 0, this);
    }

    public PatternTokenizer setUsingSlash(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setUsingSlash", $$robo$$android_icu_impl_PatternTokenizer$setUsingSlash(boolean ), 0, this, bl);
    }

    public int getLimit() {
        return (int)InvokeDynamicSupport.bootstrap("getLimit", $$robo$$android_icu_impl_PatternTokenizer$getLimit(), 0, this);
    }

    public PatternTokenizer setLimit(int n) {
        return InvokeDynamicSupport.bootstrap("setLimit", $$robo$$android_icu_impl_PatternTokenizer$setLimit(int ), 0, this, n);
    }

    public int getStart() {
        return (int)InvokeDynamicSupport.bootstrap("getStart", $$robo$$android_icu_impl_PatternTokenizer$getStart(), 0, this);
    }

    public PatternTokenizer setStart(int n) {
        return InvokeDynamicSupport.bootstrap("setStart", $$robo$$android_icu_impl_PatternTokenizer$setStart(int ), 0, this, n);
    }

    public PatternTokenizer setPattern(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setPattern", $$robo$$android_icu_impl_PatternTokenizer$setPattern(java.lang.CharSequence ), 0, this, charSequence);
    }

    public PatternTokenizer setPattern(String string2) {
        return InvokeDynamicSupport.bootstrap("setPattern", $$robo$$android_icu_impl_PatternTokenizer$setPattern(java.lang.String ), 0, this, string2);
    }

    public String quoteLiteral(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("quoteLiteral", $$robo$$android_icu_impl_PatternTokenizer$quoteLiteral(java.lang.CharSequence ), 0, this, charSequence);
    }

    public String quoteLiteral(String string2) {
        return InvokeDynamicSupport.bootstrap("quoteLiteral", $$robo$$android_icu_impl_PatternTokenizer$quoteLiteral(java.lang.String ), 0, this, string2);
    }

    private void appendEscaped(StringBuffer stringBuffer, int n) {
        InvokeDynamicSupport.bootstrap("appendEscaped", $$robo$$android_icu_impl_PatternTokenizer$appendEscaped(java.lang.StringBuffer int ), 0, this, stringBuffer, n);
    }

    public String normalize() {
        return InvokeDynamicSupport.bootstrap("normalize", $$robo$$android_icu_impl_PatternTokenizer$normalize(), 0, this);
    }

    public int next(StringBuffer stringBuffer) {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_PatternTokenizer$next(java.lang.StringBuffer ), 0, this, stringBuffer);
    }

    static {
        RobolectricInternals.classInitializing(PatternTokenizer.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternTokenizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

