/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class KeyphraseEnrollmentInfo
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "KeyphraseEnrollmentInfo";
    private static String VOICE_KEYPHRASE_META_DATA = "android.voice_enrollment";
    public static String ACTION_MANAGE_VOICE_KEYPHRASES = "com.android.intent.action.MANAGE_VOICE_KEYPHRASES";
    public static String EXTRA_VOICE_KEYPHRASE_ACTION = "com.android.intent.extra.VOICE_KEYPHRASE_ACTION";
    public static String EXTRA_VOICE_KEYPHRASE_HINT_TEXT = "com.android.intent.extra.VOICE_KEYPHRASE_HINT_TEXT";
    public static String EXTRA_VOICE_KEYPHRASE_LOCALE = "com.android.intent.extra.VOICE_KEYPHRASE_LOCALE";
    private KeyphraseMetadata[] mKeyphrases;
    private Map<KeyphraseMetadata, String> mKeyphrasePackageMap;
    private String mParseError;

    private void $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$__constructor__(PackageManager pm) {
        List<ResolveInfo> ris = pm.queryIntentActivities(new Intent("com.android.intent.action.MANAGE_VOICE_KEYPHRASES"), 65536);
        if (ris == null || ris.isEmpty()) {
            this.mParseError = "No enrollment applications found";
            this.mKeyphrasePackageMap = Collections.emptyMap();
            this.mKeyphrases = null;
            return;
        }
        LinkedList<String> parseErrors = new LinkedList<String>();
        this.mKeyphrasePackageMap = new HashMap<KeyphraseMetadata, String>();
        for (ResolveInfo ri : ris) {
            try {
                ApplicationInfo ai = pm.getApplicationInfo(ri.activityInfo.packageName, 128);
                if ((ai.privateFlags & 8) == 0) {
                    Slog.w("KeyphraseEnrollmentInfo", ai.packageName + "is not a privileged system app");
                    continue;
                }
                if (!"android.permission.MANAGE_VOICE_KEYPHRASES".equals(ai.permission)) {
                    Slog.w("KeyphraseEnrollmentInfo", ai.packageName + " does not require MANAGE_VOICE_KEYPHRASES");
                    continue;
                }
                KeyphraseMetadata metadata = this.getKeyphraseMetadataFromApplicationInfo(pm, ai, parseErrors);
                if (metadata == null) continue;
                this.mKeyphrasePackageMap.put(metadata, ai.packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                String error = "error parsing voice enrollment meta-data for " + ri.activityInfo.packageName;
                parseErrors.add(error + ": " + e);
                Slog.w("KeyphraseEnrollmentInfo", error, e);
            }
        }
        if (this.mKeyphrasePackageMap.isEmpty()) {
            String error = "No suitable enrollment application found";
            parseErrors.add(error);
            Slog.w("KeyphraseEnrollmentInfo", error);
            this.mKeyphrases = null;
        } else {
            this.mKeyphrases = this.mKeyphrasePackageMap.keySet().toArray(new KeyphraseMetadata[this.mKeyphrasePackageMap.size()]);
        }
        if (!parseErrors.isEmpty()) {
            this.mParseError = TextUtils.join((CharSequence)"\n", parseErrors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyphraseMetadata $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseMetadataFromApplicationInfo(PackageManager pm, ApplicationInfo ai, List<String> parseErrors) {
        String error;
        XmlResourceParser parser = null;
        String packageName = ai.packageName;
        KeyphraseMetadata keyphraseMetadata = null;
        try {
            int type;
            parser = ai.loadXmlMetaData(pm, "android.voice_enrollment");
            if (parser == null) {
                String error2 = "No android.voice_enrollment meta-data for " + packageName;
                parseErrors.add(error2);
                Slog.w("KeyphraseEnrollmentInfo", error2);
                KeyphraseMetadata keyphraseMetadata2 = null;
                return keyphraseMetadata2;
            }
            Resources res = pm.getResourcesForApplication(ai);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"voice-enrollment-application".equals(nodeName)) {
                String error3 = "Meta-data does not start with voice-enrollment-application tag for " + packageName;
                parseErrors.add(error3);
                Slog.w("KeyphraseEnrollmentInfo", error3);
                KeyphraseMetadata keyphraseMetadata3 = null;
                return keyphraseMetadata3;
            }
            TypedArray array2 = res.obtainAttributes(attrs, R.styleable.VoiceEnrollmentApplication);
            keyphraseMetadata = this.getKeyphraseFromTypedArray(array2, packageName, parseErrors);
            array2.recycle();
        }
        catch (XmlPullParserException e) {
            error = "Error parsing keyphrase enrollment meta-data for " + packageName;
            parseErrors.add(error + ": " + e);
            Slog.w("KeyphraseEnrollmentInfo", error, e);
        }
        catch (IOException e) {
            error = "Error parsing keyphrase enrollment meta-data for " + packageName;
            parseErrors.add(error + ": " + e);
            Slog.w("KeyphraseEnrollmentInfo", error, e);
        }
        catch (PackageManager.NameNotFoundException e) {
            error = "Error parsing keyphrase enrollment meta-data for " + packageName;
            parseErrors.add(error + ": " + e);
            Slog.w("KeyphraseEnrollmentInfo", error, e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        return keyphraseMetadata;
    }

    private final KeyphraseMetadata $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseFromTypedArray(TypedArray array2, String packageName, List<String> parseErrors) {
        int recognitionModes;
        int searchKeyphraseId = array2.getInt(0, -1);
        if (searchKeyphraseId <= 0) {
            String error = "No valid searchKeyphraseId specified in meta-data for " + packageName;
            parseErrors.add(error);
            Slog.w("KeyphraseEnrollmentInfo", error);
            return null;
        }
        String searchKeyphrase = array2.getString(1);
        if (searchKeyphrase == null) {
            String error = "No valid searchKeyphrase specified in meta-data for " + packageName;
            parseErrors.add(error);
            Slog.w("KeyphraseEnrollmentInfo", error);
            return null;
        }
        String searchKeyphraseSupportedLocales = array2.getString(2);
        if (searchKeyphraseSupportedLocales == null) {
            String error = "No valid searchKeyphraseSupportedLocales specified in meta-data for " + packageName;
            parseErrors.add(error);
            Slog.w("KeyphraseEnrollmentInfo", error);
            return null;
        }
        ArraySet<Locale> locales = new ArraySet<Locale>();
        if (!TextUtils.isEmpty(searchKeyphraseSupportedLocales)) {
            try {
                String[] supportedLocalesDelimited = searchKeyphraseSupportedLocales.split(",");
                for (int i = 0; i < supportedLocalesDelimited.length; ++i) {
                    locales.add(Locale.forLanguageTag(supportedLocalesDelimited[i]));
                }
            }
            catch (Exception ex) {
                String error = "Error reading searchKeyphraseSupportedLocales from meta-data for " + packageName;
                parseErrors.add(error);
                Slog.w("KeyphraseEnrollmentInfo", error);
                return null;
            }
        }
        if ((recognitionModes = array2.getInt(3, -1)) < 0) {
            String error = "No valid searchKeyphraseRecognitionFlags specified in meta-data for " + packageName;
            parseErrors.add(error);
            Slog.w("KeyphraseEnrollmentInfo", error);
            return null;
        }
        return new KeyphraseMetadata(searchKeyphraseId, searchKeyphrase, locales, recognitionModes);
    }

    private final String $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getParseError() {
        return this.mParseError;
    }

    private final KeyphraseMetadata[] $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$listKeyphraseMetadata() {
        return this.mKeyphrases;
    }

    private final Intent $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getManageKeyphraseIntent(int action, String keyphrase, Locale locale) {
        if (this.mKeyphrasePackageMap == null || this.mKeyphrasePackageMap.isEmpty()) {
            Slog.w("KeyphraseEnrollmentInfo", "No enrollment application exists");
            return null;
        }
        KeyphraseMetadata keyphraseMetadata = this.getKeyphraseMetadata(keyphrase, locale);
        if (keyphraseMetadata != null) {
            Intent intent = new Intent("com.android.intent.action.MANAGE_VOICE_KEYPHRASES").setPackage(this.mKeyphrasePackageMap.get(keyphraseMetadata)).putExtra("com.android.intent.extra.VOICE_KEYPHRASE_HINT_TEXT", keyphrase).putExtra("com.android.intent.extra.VOICE_KEYPHRASE_LOCALE", locale.toLanguageTag()).putExtra("com.android.intent.extra.VOICE_KEYPHRASE_ACTION", action);
            return intent;
        }
        return null;
    }

    private final KeyphraseMetadata $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseMetadata(String keyphrase, Locale locale) {
        if (this.mKeyphrases != null && this.mKeyphrases.length > 0) {
            for (KeyphraseMetadata keyphraseMetadata : this.mKeyphrases) {
                if (!keyphraseMetadata.supportsPhrase(keyphrase) || !keyphraseMetadata.supportsLocale(locale)) continue;
                return keyphraseMetadata;
            }
        }
        Slog.w("KeyphraseEnrollmentInfo", "No Enrollment application supports the given keyphrase/locale");
        return null;
    }

    private final String $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$toString() {
        return "KeyphraseEnrollmentInfo [Keyphrases=" + this.mKeyphrasePackageMap.toString() + ", ParseError=" + this.mParseError + "]";
    }

    private void __constructor__(PackageManager packageManager) {
        this.$$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$__constructor__(packageManager);
    }

    public KeyphraseEnrollmentInfo(PackageManager packageManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$__constructor__(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    private KeyphraseMetadata getKeyphraseMetadataFromApplicationInfo(PackageManager packageManager, ApplicationInfo applicationInfo, List<String> list) {
        return InvokeDynamicSupport.bootstrap("getKeyphraseMetadataFromApplicationInfo", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseMetadataFromApplicationInfo(android.content.pm.PackageManager android.content.pm.ApplicationInfo java.util.List<java.lang.String> ), 0, this, packageManager, applicationInfo, list);
    }

    private KeyphraseMetadata getKeyphraseFromTypedArray(TypedArray typedArray, String string2, List<String> list) {
        return InvokeDynamicSupport.bootstrap("getKeyphraseFromTypedArray", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseFromTypedArray(android.content.res.TypedArray java.lang.String java.util.List<java.lang.String> ), 0, this, typedArray, string2, list);
    }

    public String getParseError() {
        return InvokeDynamicSupport.bootstrap("getParseError", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getParseError(), 0, this);
    }

    public KeyphraseMetadata[] listKeyphraseMetadata() {
        return InvokeDynamicSupport.bootstrap("listKeyphraseMetadata", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$listKeyphraseMetadata(), 0, this);
    }

    public Intent getManageKeyphraseIntent(int n, String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getManageKeyphraseIntent", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getManageKeyphraseIntent(int java.lang.String java.util.Locale ), 0, this, n, string2, locale);
    }

    public KeyphraseMetadata getKeyphraseMetadata(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getKeyphraseMetadata", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseMetadata(java.lang.String java.util.Locale ), 0, this, string2, locale);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$toString(), 0, this);
    }

    public /* synthetic */ KeyphraseEnrollmentInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyphraseEnrollmentInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

