/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class HdmiRecordSources
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "HdmiRecordSources";
    private static int RECORD_SOURCE_TYPE_OWN_SOURCE = 1;
    private static int RECORD_SOURCE_TYPE_DIGITAL_SERVICE = 2;
    private static int RECORD_SOURCE_TYPE_ANALOGUE_SERVICE = 3;
    private static int RECORD_SOURCE_TYPE_EXTERNAL_PLUG = 4;
    private static int RECORD_SOURCE_TYPE_EXTERNAL_PHYSICAL_ADDRESS = 5;
    public static int DIGITAL_BROADCAST_TYPE_ARIB = 0;
    public static int DIGITAL_BROADCAST_TYPE_ATSC = 1;
    public static int DIGITAL_BROADCAST_TYPE_DVB = 2;
    public static int DIGITAL_BROADCAST_TYPE_ARIB_BS = 8;
    public static int DIGITAL_BROADCAST_TYPE_ARIB_CS = 9;
    public static int DIGITAL_BROADCAST_TYPE_ARIB_T = 10;
    public static int DIGITAL_BROADCAST_TYPE_ATSC_CABLE = 16;
    public static int DIGITAL_BROADCAST_TYPE_ATSC_SATELLITE = 17;
    public static int DIGITAL_BROADCAST_TYPE_ATSC_TERRESTRIAL = 18;
    public static int DIGITAL_BROADCAST_TYPE_DVB_C = 24;
    public static int DIGITAL_BROADCAST_TYPE_DVB_S = 25;
    public static int DIGITAL_BROADCAST_TYPE_DVB_S2 = 26;
    public static int DIGITAL_BROADCAST_TYPE_DVB_T = 27;
    private static int CHANNEL_NUMBER_FORMAT_1_PART = 1;
    private static int CHANNEL_NUMBER_FORMAT_2_PART = 2;
    public static int ANALOGUE_BROADCAST_TYPE_CABLE = 0;
    public static int ANALOGUE_BROADCAST_TYPE_SATELLITE = 1;
    public static int ANALOGUE_BROADCAST_TYPE_TERRESTRIAL = 2;
    public static int BROADCAST_SYSTEM_PAL_BG = 0;
    public static int BROADCAST_SYSTEM_SECAM_LP = 1;
    public static int BROADCAST_SYSTEM_PAL_M = 2;
    public static int BROADCAST_SYSTEM_NTSC_M = 3;
    public static int BROADCAST_SYSTEM_PAL_I = 4;
    public static int BROADCAST_SYSTEM_SECAM_DK = 5;
    public static int BROADCAST_SYSTEM_SECAM_BG = 6;
    public static int BROADCAST_SYSTEM_SECAM_L = 7;
    public static int BROADCAST_SYSTEM_PAL_DK = 8;
    public static int BROADCAST_SYSTEM_PAL_OTHER_SYSTEM = 31;

    private void $$robo$$android_hardware_hdmi_HdmiRecordSources$__constructor__() {
    }

    private static final OwnSource $$robo$$android_hardware_hdmi_HdmiRecordSources$ofOwnSource() {
        return new OwnSource();
    }

    private static final DigitalServiceSource $$robo$$android_hardware_hdmi_HdmiRecordSources$ofDigitalChannelId(int broadcastSystem, DigitalChannelData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (broadcastSystem) {
            case 0: 
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new DigitalServiceSource(1, broadcastSystem, data);
            }
        }
        Log.w("HdmiRecordSources", "Invalid broadcast type:" + broadcastSystem);
        throw new IllegalArgumentException("Invalid broadcast system value:" + broadcastSystem);
    }

    private static final DigitalServiceSource $$robo$$android_hardware_hdmi_HdmiRecordSources$ofArib(int aribType, AribData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (aribType) {
            case 0: 
            case 8: 
            case 9: 
            case 10: {
                return new DigitalServiceSource(0, aribType, data);
            }
        }
        Log.w("HdmiRecordSources", "Invalid ARIB type:" + aribType);
        throw new IllegalArgumentException("type should not be null.");
    }

    private static final DigitalServiceSource $$robo$$android_hardware_hdmi_HdmiRecordSources$ofAtsc(int atscType, AtscData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (atscType) {
            case 1: 
            case 16: 
            case 17: 
            case 18: {
                return new DigitalServiceSource(0, atscType, data);
            }
        }
        Log.w("HdmiRecordSources", "Invalid ATSC type:" + atscType);
        throw new IllegalArgumentException("Invalid ATSC type:" + atscType);
    }

    private static final DigitalServiceSource $$robo$$android_hardware_hdmi_HdmiRecordSources$ofDvb(int dvbType, DvbData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (dvbType) {
            case 2: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new DigitalServiceSource(0, dvbType, data);
            }
        }
        Log.w("HdmiRecordSources", "Invalid DVB type:" + dvbType);
        throw new IllegalArgumentException("Invalid DVB type:" + dvbType);
    }

    private static final AnalogueServiceSource $$robo$$android_hardware_hdmi_HdmiRecordSources$ofAnalogue(int broadcastType, int frequency, int broadcastSystem) {
        if (broadcastType < 0 || broadcastType > 2) {
            Log.w("HdmiRecordSources", "Invalid Broadcast type:" + broadcastType);
            throw new IllegalArgumentException("Invalid Broadcast type:" + broadcastType);
        }
        if (frequency < 0 || frequency > 65535) {
            Log.w("HdmiRecordSources", "Invalid frequency value[0x0000-0xFFFF]:" + frequency);
            throw new IllegalArgumentException("Invalid frequency value[0x0000-0xFFFF]:" + frequency);
        }
        if (broadcastSystem < 0 || broadcastSystem > 31) {
            Log.w("HdmiRecordSources", "Invalid Broadcast system:" + broadcastSystem);
            throw new IllegalArgumentException("Invalid Broadcast system:" + broadcastSystem);
        }
        return new AnalogueServiceSource(broadcastType, frequency, broadcastSystem);
    }

    private static final ExternalPlugData $$robo$$android_hardware_hdmi_HdmiRecordSources$ofExternalPlug(int plugNumber) {
        if (plugNumber < 1 || plugNumber > 255) {
            Log.w("HdmiRecordSources", "Invalid plug number[1-255]" + plugNumber);
            throw new IllegalArgumentException("Invalid plug number[1-255]" + plugNumber);
        }
        return new ExternalPlugData(plugNumber);
    }

    private static final ExternalPhysicalAddress $$robo$$android_hardware_hdmi_HdmiRecordSources$ofExternalPhysicalAddress(int physicalAddress) {
        if ((physicalAddress & 0xFFFF0000) != 0) {
            Log.w("HdmiRecordSources", "Invalid physical address:" + physicalAddress);
            throw new IllegalArgumentException("Invalid physical address:" + physicalAddress);
        }
        return new ExternalPhysicalAddress(physicalAddress);
    }

    private static final int $$robo$$android_hardware_hdmi_HdmiRecordSources$threeFieldsToSixBytes(int first, int second, int third, byte[] data, int index) {
        HdmiRecordSources.shortToByteArray((short)first, data, index);
        HdmiRecordSources.shortToByteArray((short)second, data, index + 2);
        HdmiRecordSources.shortToByteArray((short)third, data, index + 4);
        return 6;
    }

    private static final int $$robo$$android_hardware_hdmi_HdmiRecordSources$shortToByteArray(short value, byte[] byteArray, int index) {
        byteArray[index] = (byte)(value >>> 8 & 0xFF);
        byteArray[index + 1] = (byte)(value & 0xFF);
        return 2;
    }

    private static final boolean $$robo$$android_hardware_hdmi_HdmiRecordSources$checkRecordSource(byte[] recordSource) {
        if (recordSource == null || recordSource.length == 0) {
            return false;
        }
        byte recordSourceType = recordSource[0];
        int extraDataSize = recordSource.length - 1;
        switch (recordSourceType) {
            case 1: {
                return extraDataSize == 0;
            }
            case 2: {
                return extraDataSize == 7;
            }
            case 3: {
                return extraDataSize == 4;
            }
            case 4: {
                return extraDataSize == 1;
            }
            case 5: {
                return extraDataSize == 2;
            }
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_hdmi_HdmiRecordSources$__constructor__();
    }

    private HdmiRecordSources() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources$__constructor__(), 0, this);
    }

    public static OwnSource ofOwnSource() {
        return InvokeDynamicSupport.bootstrapStatic("ofOwnSource", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofOwnSource(), 0);
    }

    public static DigitalServiceSource ofDigitalChannelId(int n, DigitalChannelData digitalChannelData) {
        return InvokeDynamicSupport.bootstrapStatic("ofDigitalChannelId", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofDigitalChannelId(int android.hardware.hdmi.HdmiRecordSources$DigitalChannelData ), 0, (int)n, (DigitalChannelData)digitalChannelData);
    }

    public static DigitalServiceSource ofArib(int n, AribData aribData) {
        return InvokeDynamicSupport.bootstrapStatic("ofArib", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofArib(int android.hardware.hdmi.HdmiRecordSources$AribData ), 0, (int)n, (AribData)aribData);
    }

    public static DigitalServiceSource ofAtsc(int n, AtscData atscData) {
        return InvokeDynamicSupport.bootstrapStatic("ofAtsc", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofAtsc(int android.hardware.hdmi.HdmiRecordSources$AtscData ), 0, (int)n, (AtscData)atscData);
    }

    public static DigitalServiceSource ofDvb(int n, DvbData dvbData) {
        return InvokeDynamicSupport.bootstrapStatic("ofDvb", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofDvb(int android.hardware.hdmi.HdmiRecordSources$DvbData ), 0, (int)n, (DvbData)dvbData);
    }

    public static AnalogueServiceSource ofAnalogue(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("ofAnalogue", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofAnalogue(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public static ExternalPlugData ofExternalPlug(int n) {
        return InvokeDynamicSupport.bootstrapStatic("ofExternalPlug", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofExternalPlug(int ), 0, (int)n);
    }

    public static ExternalPhysicalAddress ofExternalPhysicalAddress(int n) {
        return InvokeDynamicSupport.bootstrapStatic("ofExternalPhysicalAddress", $$robo$$android_hardware_hdmi_HdmiRecordSources$ofExternalPhysicalAddress(int ), 0, (int)n);
    }

    private static int threeFieldsToSixBytes(int n, int n2, int n3, byte[] byArray, int n4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("threeFieldsToSixBytes", $$robo$$android_hardware_hdmi_HdmiRecordSources$threeFieldsToSixBytes(int int int byte[] int ), 0, (int)n, (int)n2, (int)n3, (byte[])byArray, (int)n4);
    }

    private static int shortToByteArray(short s, byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("shortToByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources$shortToByteArray(short byte[] int ), 0, (short)s, (byte[])byArray, (int)n);
    }

    public static boolean checkRecordSource(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkRecordSource", $$robo$$android_hardware_hdmi_HdmiRecordSources$checkRecordSource(byte[] ), 0, (byte[])byArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdmiRecordSources)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ExternalPhysicalAddress
    extends RecordSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int EXTRA_DATA_SIZE = 2;
        private int mPhysicalAddress;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPhysicalAddress$__constructor__(int physicalAddress) {
            this.mPhysicalAddress = physicalAddress;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPhysicalAddress$extraParamToByteArray(byte[] data, int index) {
            HdmiRecordSources.shortToByteArray((short)this.mPhysicalAddress, data, index);
            return 2;
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPhysicalAddress$__constructor__(int x0, 1 x1) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPhysicalAddress$__constructor__(n);
        }

        private ExternalPhysicalAddress(int n) {
            super(5, 2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPhysicalAddress$__constructor__(int ), 0, this, n);
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("extraParamToByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPhysicalAddress$extraParamToByteArray(byte[] int ), 0, this, byArray, n);
        }

        private /* synthetic */ void __constructor__(int n, 1 var2_2) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPhysicalAddress$__constructor__(n, var2_2);
        }

        public /* synthetic */ ExternalPhysicalAddress() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalPhysicalAddress)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ExternalPlugData
    extends RecordSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int EXTRA_DATA_SIZE = 1;
        private int mPlugNumber;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPlugData$__constructor__(int plugNumber) {
            this.mPlugNumber = plugNumber;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPlugData$extraParamToByteArray(byte[] data, int index) {
            data[index] = (byte)this.mPlugNumber;
            return 1;
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPlugData$__constructor__(int x0, 1 x1) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPlugData$__constructor__(n);
        }

        private ExternalPlugData(int n) {
            super(4, 1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPlugData$__constructor__(int ), 0, this, n);
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("extraParamToByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPlugData$extraParamToByteArray(byte[] int ), 0, this, byArray, n);
        }

        private /* synthetic */ void __constructor__(int n, 1 var2_2) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_ExternalPlugData$__constructor__(n, var2_2);
        }

        public /* synthetic */ ExternalPlugData() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalPlugData)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AnalogueServiceSource
    extends RecordSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int EXTRA_DATA_SIZE = 4;
        private int mBroadcastType;
        private int mFrequency;
        private int mBroadcastSystem;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_AnalogueServiceSource$__constructor__(int broadcastType, int frequency, int broadcastSystem) {
            this.mBroadcastType = broadcastType;
            this.mFrequency = frequency;
            this.mBroadcastSystem = broadcastSystem;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_AnalogueServiceSource$extraParamToByteArray(byte[] data, int index) {
            data[index] = (byte)this.mBroadcastType;
            HdmiRecordSources.shortToByteArray((short)this.mFrequency, data, index + 1);
            data[index + 3] = (byte)this.mBroadcastSystem;
            return 4;
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiRecordSources_AnalogueServiceSource$__constructor__(int x0, int x1, int x2, 1 x3) {
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_AnalogueServiceSource$__constructor__(n, n2, n3);
        }

        private AnalogueServiceSource(int n, int n2, int n3) {
            super(3, 4);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_AnalogueServiceSource$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("extraParamToByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_AnalogueServiceSource$extraParamToByteArray(byte[] int ), 0, this, byArray, n);
        }

        private /* synthetic */ void __constructor__(int n, int n2, int n3, 1 var4_4) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_AnalogueServiceSource$__constructor__(n, n2, n3, var4_4);
        }

        public /* synthetic */ AnalogueServiceSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnalogueServiceSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DigitalServiceSource
    extends RecordSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DIGITAL_SERVICE_IDENTIFIED_BY_DIGITAL_ID = 0;
        private static int DIGITAL_SERVICE_IDENTIFIED_BY_CHANNEL = 1;
        static int EXTRA_DATA_SIZE = 7;
        private int mIdentificationMethod;
        private int mBroadcastSystem;
        private DigitalServiceIdentification mIdentification;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalServiceSource$__constructor__(int identificatinoMethod, int broadcastSystem, DigitalServiceIdentification identification) {
            this.mIdentificationMethod = identificatinoMethod;
            this.mBroadcastSystem = broadcastSystem;
            this.mIdentification = identification;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalServiceSource$extraParamToByteArray(byte[] data, int index) {
            data[index] = (byte)(this.mIdentificationMethod << 7 | this.mBroadcastSystem & 0x7F);
            this.mIdentification.toByteArray(data, index + 1);
            return 7;
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalServiceSource$__constructor__(int x0, int x1, DigitalServiceIdentification x2, 1 x3) {
        }

        private void __constructor__(int n, int n2, DigitalServiceIdentification digitalServiceIdentification) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalServiceSource$__constructor__(n, n2, digitalServiceIdentification);
        }

        private DigitalServiceSource(int n, int n2, DigitalServiceIdentification digitalServiceIdentification) {
            super(2, 7);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalServiceSource$__constructor__(int int android.hardware.hdmi.HdmiRecordSources$DigitalServiceIdentification ), 0, this, n, n2, digitalServiceIdentification);
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("extraParamToByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalServiceSource$extraParamToByteArray(byte[] int ), 0, this, byArray, n);
        }

        private /* synthetic */ void __constructor__(int n, int n2, DigitalServiceIdentification digitalServiceIdentification, 1 var4_4) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalServiceSource$__constructor__(n, n2, digitalServiceIdentification, var4_4);
        }

        public /* synthetic */ DigitalServiceSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DigitalServiceSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DigitalChannelData
    implements DigitalServiceIdentification,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ChannelIdentifier mChannelIdentifier;

        private static final DigitalChannelData $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$ofTwoNumbers(int majorNumber, int minorNumber) {
            return new DigitalChannelData(new ChannelIdentifier(2, majorNumber, minorNumber));
        }

        private static final DigitalChannelData $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$ofOneNumber(int number) {
            return new DigitalChannelData(new ChannelIdentifier(1, 0, number));
        }

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$__constructor__(ChannelIdentifier id2) {
            this.mChannelIdentifier = id2;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$toByteArray(byte[] data, int index) {
            this.mChannelIdentifier.toByteArray(data, index);
            data[index + 4] = 0;
            data[index + 5] = 0;
            return 6;
        }

        public static DigitalChannelData ofTwoNumbers(int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("ofTwoNumbers", $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$ofTwoNumbers(int int ), 0, (int)n, (int)n2);
        }

        public static DigitalChannelData ofOneNumber(int n) {
            return InvokeDynamicSupport.bootstrapStatic("ofOneNumber", $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$ofOneNumber(int ), 0, (int)n);
        }

        private void __constructor__(ChannelIdentifier channelIdentifier) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$__constructor__(channelIdentifier);
        }

        private DigitalChannelData(ChannelIdentifier channelIdentifier) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$__constructor__(android.hardware.hdmi.HdmiRecordSources$ChannelIdentifier ), 0, this, channelIdentifier);
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_DigitalChannelData$toByteArray(byte[] int ), 0, this, byArray, n);
        }

        public /* synthetic */ DigitalChannelData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DigitalChannelData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ChannelIdentifier
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mChannelNumberFormat;
        private int mMajorChannelNumber;
        private int mMinorChannelNumber;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_ChannelIdentifier$__constructor__(int format, int majorNumber, int minorNumer) {
            this.mChannelNumberFormat = format;
            this.mMajorChannelNumber = majorNumber;
            this.mMinorChannelNumber = minorNumer;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_ChannelIdentifier$toByteArray(byte[] data, int index) {
            data[index] = (byte)(this.mChannelNumberFormat << 2 | this.mMajorChannelNumber >>> 8 & 3);
            data[index + 1] = (byte)(this.mMajorChannelNumber & 0xFF);
            HdmiRecordSources.shortToByteArray((short)this.mMinorChannelNumber, data, index + 2);
            return 4;
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiRecordSources_ChannelIdentifier$__constructor__(int x0, int x1, int x2, 1 x3) {
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_ChannelIdentifier$__constructor__(n, n2, n3);
        }

        private ChannelIdentifier(int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_ChannelIdentifier$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        private int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_ChannelIdentifier$toByteArray(byte[] int ), 0, this, byArray, n);
        }

        private /* synthetic */ void __constructor__(int n, int n2, int n3, 1 var4_4) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_ChannelIdentifier$__constructor__(n, n2, n3, var4_4);
        }

        public /* synthetic */ ChannelIdentifier() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChannelIdentifier)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DvbData
    implements DigitalServiceIdentification,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTransportStreamId;
        private int mServiceId;
        private int mOriginalNetworkId;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_DvbData$__constructor__(int transportStreamId, int serviceId, int originalNetworkId) {
            this.mTransportStreamId = transportStreamId;
            this.mServiceId = serviceId;
            this.mOriginalNetworkId = originalNetworkId;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_DvbData$toByteArray(byte[] data, int index) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mServiceId, this.mOriginalNetworkId, data, index);
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_DvbData$__constructor__(n, n2, n3);
        }

        public DvbData(int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_DvbData$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_DvbData$toByteArray(byte[] int ), 0, this, byArray, n);
        }

        public /* synthetic */ DvbData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DvbData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AtscData
    implements DigitalServiceIdentification,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTransportStreamId;
        private int mProgramNumber;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_AtscData$__constructor__(int transportStreamId, int programNumber) {
            this.mTransportStreamId = transportStreamId;
            this.mProgramNumber = programNumber;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_AtscData$toByteArray(byte[] data, int index) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mProgramNumber, 0, data, index);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_AtscData$__constructor__(n, n2);
        }

        public AtscData(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_AtscData$__constructor__(int int ), 0, this, n, n2);
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_AtscData$toByteArray(byte[] int ), 0, this, byArray, n);
        }

        public /* synthetic */ AtscData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AtscData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AribData
    implements DigitalServiceIdentification,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTransportStreamId;
        private int mServiceId;
        private int mOriginalNetworkId;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_AribData$__constructor__(int transportStreamId, int serviceId, int originalNetworkId) {
            this.mTransportStreamId = transportStreamId;
            this.mServiceId = serviceId;
            this.mOriginalNetworkId = originalNetworkId;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_AribData$toByteArray(byte[] data, int index) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mServiceId, this.mOriginalNetworkId, data, index);
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_AribData$__constructor__(n, n2, n3);
        }

        public AribData(int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_AribData$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_AribData$toByteArray(byte[] int ), 0, this, byArray, n);
        }

        public /* synthetic */ AribData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AribData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface DigitalServiceIdentification
    extends InstrumentedInterface {
        public int toByteArray(byte[] var1, int var2);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class OwnSource
    extends RecordSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int EXTRA_DATA_SIZE = 0;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_OwnSource$__constructor__() {
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_OwnSource$extraParamToByteArray(byte[] data, int index) {
            return 0;
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiRecordSources_OwnSource$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_OwnSource$__constructor__();
        }

        private OwnSource() {
            super(1, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_OwnSource$__constructor__(), 0, this);
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("extraParamToByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_OwnSource$extraParamToByteArray(byte[] int ), 0, this, byArray, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_OwnSource$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OwnSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class RecordSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mSourceType;
        int mExtraDataSize;

        private void $$robo$$android_hardware_hdmi_HdmiRecordSources_RecordSource$__constructor__(int sourceType, int extraDataSize) {
            this.mSourceType = sourceType;
            this.mExtraDataSize = extraDataSize;
        }

        abstract int extraParamToByteArray(byte[] var1, int var2);

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_RecordSource$getDataSize(boolean includeType) {
            return includeType ? this.mExtraDataSize + 1 : this.mExtraDataSize;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiRecordSources_RecordSource$toByteArray(boolean includeType, byte[] data, int index) {
            if (includeType) {
                data[index++] = (byte)this.mSourceType;
            }
            this.extraParamToByteArray(data, index);
            return this.getDataSize(includeType);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_hardware_hdmi_HdmiRecordSources_RecordSource$__constructor__(n, n2);
        }

        RecordSource(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiRecordSources_RecordSource$__constructor__(int int ), 0, this, n, n2);
        }

        int getDataSize(boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getDataSize", $$robo$$android_hardware_hdmi_HdmiRecordSources_RecordSource$getDataSize(boolean ), 0, this, bl);
        }

        int toByteArray(boolean bl, byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiRecordSources_RecordSource$toByteArray(boolean byte[] int ), 0, this, bl, byArray, n);
        }

        public /* synthetic */ RecordSource() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecordSource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

