/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.RequestHolder;
import android.util.Log;
import android.util.MutableLong;
import android.util.Pair;
import android.view.Surface;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CaptureCollector
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CaptureCollector";
    private static boolean DEBUG = false;
    private static int FLAG_RECEIVED_JPEG = 1;
    private static int FLAG_RECEIVED_JPEG_TS = 2;
    private static int FLAG_RECEIVED_PREVIEW = 4;
    private static int FLAG_RECEIVED_PREVIEW_TS = 8;
    private static int FLAG_RECEIVED_ALL_JPEG = 3;
    private static int FLAG_RECEIVED_ALL_PREVIEW = 12;
    private static int MAX_JPEGS_IN_FLIGHT = 1;
    private TreeSet<CaptureHolder> mActiveRequests;
    private ArrayDeque<CaptureHolder> mJpegCaptureQueue;
    private ArrayDeque<CaptureHolder> mJpegProduceQueue;
    private ArrayDeque<CaptureHolder> mPreviewCaptureQueue;
    private ArrayDeque<CaptureHolder> mPreviewProduceQueue;
    private ArrayList<CaptureHolder> mCompletedRequests;
    private ReentrantLock mLock;
    private Condition mIsEmpty;
    private Condition mPreviewsEmpty;
    private Condition mNotFull;
    private CameraDeviceState mDeviceState;
    private int mInFlight;
    private int mInFlightPreviews;
    private int mMaxInFlight;

    private void $$robo$$android_hardware_camera2_legacy_CaptureCollector$__constructor__(int maxInFlight, CameraDeviceState deviceState) {
        this.mCompletedRequests = new ArrayList();
        this.mLock = new ReentrantLock();
        this.mInFlight = 0;
        this.mInFlightPreviews = 0;
        this.mMaxInFlight = maxInFlight;
        this.mJpegCaptureQueue = new ArrayDeque(1);
        this.mJpegProduceQueue = new ArrayDeque(1);
        this.mPreviewCaptureQueue = new ArrayDeque(this.mMaxInFlight);
        this.mPreviewProduceQueue = new ArrayDeque(this.mMaxInFlight);
        this.mActiveRequests = new TreeSet();
        this.mIsEmpty = this.mLock.newCondition();
        this.mNotFull = this.mLock.newCondition();
        this.mPreviewsEmpty = this.mLock.newCondition();
        this.mDeviceState = deviceState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector$queueRequest(RequestHolder holder, LegacyRequest legacy, long timeout, TimeUnit unit) throws InterruptedException {
        CaptureHolder h = new CaptureHolder(this, holder, legacy);
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            if (!h.needsJpeg && !h.needsPreview) {
                throw new IllegalStateException("Request must target at least one output surface!");
            }
            if (h.needsJpeg) {
                while (this.mInFlight > 0) {
                    if (nanos <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    nanos = this.mIsEmpty.awaitNanos(nanos);
                }
                this.mJpegCaptureQueue.add(h);
                this.mJpegProduceQueue.add(h);
            }
            if (h.needsPreview) {
                while (this.mInFlight >= this.mMaxInFlight) {
                    if (nanos <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    nanos = this.mNotFull.awaitNanos(nanos);
                }
                this.mPreviewCaptureQueue.add(h);
                this.mPreviewProduceQueue.add(h);
                ++this.mInFlightPreviews;
            }
            this.mActiveRequests.add(h);
            ++this.mInFlight;
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector$waitForEmpty(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            while (this.mInFlight > 0) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.mIsEmpty.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector$waitForPreviewsEmpty(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            while (this.mInFlightPreviews > 0) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.mPreviewsEmpty.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector$waitForRequestCompleted(RequestHolder holder, long timeout, TimeUnit unit, MutableLong timestamp) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            while (!this.removeRequestIfCompleted(holder, timestamp)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.mNotFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector$removeRequestIfCompleted(RequestHolder holder, MutableLong timestamp) {
        int i = 0;
        for (CaptureHolder h : this.mCompletedRequests) {
            if (h.mRequest.equals(holder)) {
                timestamp.value = h.mTimestamp;
                this.mCompletedRequests.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RequestHolder $$robo$$android_hardware_camera2_legacy_CaptureCollector$jpegCaptured(long timestamp) {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            CaptureHolder h = this.mJpegCaptureQueue.poll();
            if (h == null) {
                Log.w("CaptureCollector", "jpegCaptured called with no jpeg request on queue!");
                RequestHolder requestHolder = null;
                return requestHolder;
            }
            h.setJpegTimestamp(timestamp);
            RequestHolder requestHolder = h.mRequest;
            return requestHolder;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<RequestHolder, Long> $$robo$$android_hardware_camera2_legacy_CaptureCollector$jpegProduced() {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            CaptureHolder h = this.mJpegProduceQueue.poll();
            if (h == null) {
                Log.w("CaptureCollector", "jpegProduced called with no jpeg request on queue!");
                Pair<RequestHolder, Long> pair = null;
                return pair;
            }
            h.setJpegProduced();
            Pair<RequestHolder, Long> pair = new Pair<RequestHolder, Long>(h.mRequest, h.mTimestamp);
            return pair;
        }
        finally {
            lock.unlock();
        }
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector$hasPendingPreviewCaptures() {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            boolean bl = !this.mPreviewCaptureQueue.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<RequestHolder, Long> $$robo$$android_hardware_camera2_legacy_CaptureCollector$previewCaptured(long timestamp) {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            CaptureHolder h = this.mPreviewCaptureQueue.poll();
            if (h == null) {
                Pair<RequestHolder, Long> pair = null;
                return pair;
            }
            h.setPreviewTimestamp(timestamp);
            Pair<RequestHolder, Long> pair = new Pair<RequestHolder, Long>(h.mRequest, h.mTimestamp);
            return pair;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RequestHolder $$robo$$android_hardware_camera2_legacy_CaptureCollector$previewProduced() {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            CaptureHolder h = this.mPreviewProduceQueue.poll();
            if (h == null) {
                Log.w("CaptureCollector", "previewProduced called with no preview request on queue!");
                RequestHolder requestHolder = null;
                return requestHolder;
            }
            h.setPreviewProduced();
            RequestHolder requestHolder = h.mRequest;
            return requestHolder;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector$failNextPreview() {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            CaptureHolder h;
            CaptureHolder h1 = this.mPreviewCaptureQueue.peek();
            CaptureHolder h2 = this.mPreviewProduceQueue.peek();
            CaptureHolder captureHolder = h1 == null ? h2 : (h2 == null ? h1 : (h = h1.compareTo(h2) <= 0 ? h1 : h2));
            if (h != null) {
                this.mPreviewCaptureQueue.remove(h);
                this.mPreviewProduceQueue.remove(h);
                this.mActiveRequests.remove(h);
                h.setPreviewFailed();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector$failNextJpeg() {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            CaptureHolder h;
            CaptureHolder h1 = this.mJpegCaptureQueue.peek();
            CaptureHolder h2 = this.mJpegProduceQueue.peek();
            CaptureHolder captureHolder = h1 == null ? h2 : (h2 == null ? h1 : (h = h1.compareTo(h2) <= 0 ? h1 : h2));
            if (h != null) {
                this.mJpegCaptureQueue.remove(h);
                this.mJpegProduceQueue.remove(h);
                this.mActiveRequests.remove(h);
                h.setJpegFailed();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector$failAll() {
        ReentrantLock lock = this.mLock;
        lock.lock();
        try {
            CaptureHolder h;
            while ((h = this.mActiveRequests.pollFirst()) != null) {
                h.setPreviewFailed();
                h.setJpegFailed();
            }
            this.mPreviewCaptureQueue.clear();
            this.mPreviewProduceQueue.clear();
            this.mJpegCaptureQueue.clear();
            this.mJpegProduceQueue.clear();
        }
        finally {
            lock.unlock();
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector$onPreviewCompleted() {
        --this.mInFlightPreviews;
        if (this.mInFlightPreviews < 0) {
            throw new IllegalStateException("More preview captures completed than requests queued.");
        }
        if (this.mInFlightPreviews == 0) {
            this.mPreviewsEmpty.signalAll();
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector$onRequestCompleted(CaptureHolder capture) {
        RequestHolder request = capture.mRequest;
        --this.mInFlight;
        if (this.mInFlight < 0) {
            throw new IllegalStateException("More captures completed than requests queued.");
        }
        this.mCompletedRequests.add(capture);
        this.mActiveRequests.remove(capture);
        this.mNotFull.signalAll();
        if (this.mInFlight == 0) {
            this.mIsEmpty.signalAll();
        }
    }

    private void __constructor__(int n, CameraDeviceState cameraDeviceState) {
        this.$$robo$$android_hardware_camera2_legacy_CaptureCollector$__constructor__(n, cameraDeviceState);
    }

    public CaptureCollector(int n, CameraDeviceState cameraDeviceState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CaptureCollector$__constructor__(int android.hardware.camera2.legacy.CameraDeviceState ), 0, this, n, cameraDeviceState);
    }

    public boolean queueRequest(RequestHolder requestHolder, LegacyRequest legacyRequest, long l, TimeUnit timeUnit) throws InterruptedException {
        return (boolean)InvokeDynamicSupport.bootstrap("queueRequest", $$robo$$android_hardware_camera2_legacy_CaptureCollector$queueRequest(android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.legacy.LegacyRequest long java.util.concurrent.TimeUnit ), 0, this, requestHolder, legacyRequest, l, timeUnit);
    }

    public boolean waitForEmpty(long l, TimeUnit timeUnit) throws InterruptedException {
        return (boolean)InvokeDynamicSupport.bootstrap("waitForEmpty", $$robo$$android_hardware_camera2_legacy_CaptureCollector$waitForEmpty(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
    }

    public boolean waitForPreviewsEmpty(long l, TimeUnit timeUnit) throws InterruptedException {
        return (boolean)InvokeDynamicSupport.bootstrap("waitForPreviewsEmpty", $$robo$$android_hardware_camera2_legacy_CaptureCollector$waitForPreviewsEmpty(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
    }

    public boolean waitForRequestCompleted(RequestHolder requestHolder, long l, TimeUnit timeUnit, MutableLong mutableLong) throws InterruptedException {
        return (boolean)InvokeDynamicSupport.bootstrap("waitForRequestCompleted", $$robo$$android_hardware_camera2_legacy_CaptureCollector$waitForRequestCompleted(android.hardware.camera2.legacy.RequestHolder long java.util.concurrent.TimeUnit android.util.MutableLong ), 0, this, requestHolder, l, timeUnit, mutableLong);
    }

    private boolean removeRequestIfCompleted(RequestHolder requestHolder, MutableLong mutableLong) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeRequestIfCompleted", $$robo$$android_hardware_camera2_legacy_CaptureCollector$removeRequestIfCompleted(android.hardware.camera2.legacy.RequestHolder android.util.MutableLong ), 0, this, requestHolder, mutableLong);
    }

    public RequestHolder jpegCaptured(long l) {
        return InvokeDynamicSupport.bootstrap("jpegCaptured", $$robo$$android_hardware_camera2_legacy_CaptureCollector$jpegCaptured(long ), 0, this, l);
    }

    public Pair<RequestHolder, Long> jpegProduced() {
        return InvokeDynamicSupport.bootstrap("jpegProduced", $$robo$$android_hardware_camera2_legacy_CaptureCollector$jpegProduced(), 0, this);
    }

    public boolean hasPendingPreviewCaptures() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPendingPreviewCaptures", $$robo$$android_hardware_camera2_legacy_CaptureCollector$hasPendingPreviewCaptures(), 0, this);
    }

    public Pair<RequestHolder, Long> previewCaptured(long l) {
        return InvokeDynamicSupport.bootstrap("previewCaptured", $$robo$$android_hardware_camera2_legacy_CaptureCollector$previewCaptured(long ), 0, this, l);
    }

    public RequestHolder previewProduced() {
        return InvokeDynamicSupport.bootstrap("previewProduced", $$robo$$android_hardware_camera2_legacy_CaptureCollector$previewProduced(), 0, this);
    }

    public void failNextPreview() {
        InvokeDynamicSupport.bootstrap("failNextPreview", $$robo$$android_hardware_camera2_legacy_CaptureCollector$failNextPreview(), 0, this);
    }

    public void failNextJpeg() {
        InvokeDynamicSupport.bootstrap("failNextJpeg", $$robo$$android_hardware_camera2_legacy_CaptureCollector$failNextJpeg(), 0, this);
    }

    public void failAll() {
        InvokeDynamicSupport.bootstrap("failAll", $$robo$$android_hardware_camera2_legacy_CaptureCollector$failAll(), 0, this);
    }

    private void onPreviewCompleted() {
        InvokeDynamicSupport.bootstrap("onPreviewCompleted", $$robo$$android_hardware_camera2_legacy_CaptureCollector$onPreviewCompleted(), 0, this);
    }

    private void onRequestCompleted(CaptureHolder captureHolder) {
        InvokeDynamicSupport.bootstrap("onRequestCompleted", $$robo$$android_hardware_camera2_legacy_CaptureCollector$onRequestCompleted(android.hardware.camera2.legacy.CaptureCollector$CaptureHolder ), 0, this, captureHolder);
    }

    public /* synthetic */ CaptureCollector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptureCollector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CaptureHolder
    implements Comparable<CaptureHolder> {
        public transient /* synthetic */ Object __robo_data__;
        private RequestHolder mRequest;
        private LegacyRequest mLegacy;
        public boolean needsJpeg;
        public boolean needsPreview;
        private long mTimestamp;
        private int mReceivedFlags;
        private boolean mHasStarted;
        private boolean mFailedJpeg;
        private boolean mFailedPreview;
        private boolean mCompleted;
        private boolean mPreviewCompleted;
        /* synthetic */ CaptureCollector this$0;

        private void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$__constructor__(CaptureCollector captureCollector, RequestHolder request, LegacyRequest legacyHolder) {
            this.mTimestamp = 0L;
            this.mReceivedFlags = 0;
            this.mHasStarted = false;
            this.mFailedJpeg = false;
            this.mFailedPreview = false;
            this.mCompleted = false;
            this.mPreviewCompleted = false;
            this.mRequest = request;
            this.mLegacy = legacyHolder;
            this.needsJpeg = request.hasJpegTargets();
            this.needsPreview = request.hasPreviewTargets();
        }

        private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$isPreviewCompleted() {
            return (this.mReceivedFlags & 0xC) == 12;
        }

        private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$isJpegCompleted() {
            return (this.mReceivedFlags & 3) == 3;
        }

        private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$isCompleted() {
            return this.needsJpeg == this.isJpegCompleted() && this.needsPreview == this.isPreviewCompleted();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$tryComplete() {
            if (!this.mPreviewCompleted && this.needsPreview && this.isPreviewCompleted()) {
                this.this$0.onPreviewCompleted();
                this.mPreviewCompleted = true;
            }
            if (this.isCompleted() && !this.mCompleted) {
                if (this.mFailedPreview || this.mFailedJpeg) {
                    if (!this.mHasStarted) {
                        this.mRequest.failRequest();
                        this.this$0.mDeviceState.setCaptureStart(this.mRequest, this.mTimestamp, 3);
                    } else {
                        for (Surface targetSurface : this.mRequest.getRequest().getTargets()) {
                            try {
                                if (this.mRequest.jpegType(targetSurface)) {
                                    if (!this.mFailedJpeg) continue;
                                    this.this$0.mDeviceState.setCaptureResult(this.mRequest, null, 5, targetSurface);
                                    continue;
                                }
                                if (!this.mFailedPreview) continue;
                                this.this$0.mDeviceState.setCaptureResult(this.mRequest, null, 5, targetSurface);
                            }
                            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                                Log.e("CaptureCollector", "Unexpected exception when querying Surface: " + e);
                            }
                        }
                    }
                }
                this.this$0.onRequestCompleted(this);
                this.mCompleted = true;
            }
        }

        private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setJpegTimestamp(long timestamp) {
            if (!this.needsJpeg) {
                throw new IllegalStateException("setJpegTimestamp called for capture with no jpeg targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setJpegTimestamp called on already completed request.");
            }
            this.mReceivedFlags |= 2;
            if (this.mTimestamp == 0L) {
                this.mTimestamp = timestamp;
            }
            if (!this.mHasStarted) {
                this.mHasStarted = true;
                this.this$0.mDeviceState.setCaptureStart(this.mRequest, this.mTimestamp, -1);
            }
            this.tryComplete();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setJpegProduced() {
            if (!this.needsJpeg) {
                throw new IllegalStateException("setJpegProduced called for capture with no jpeg targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setJpegProduced called on already completed request.");
            }
            this.mReceivedFlags |= 1;
            this.tryComplete();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setJpegFailed() {
            if (!this.needsJpeg || this.isJpegCompleted()) {
                return;
            }
            this.mFailedJpeg = true;
            this.mReceivedFlags |= 1;
            this.mReceivedFlags |= 2;
            this.tryComplete();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setPreviewTimestamp(long timestamp) {
            if (!this.needsPreview) {
                throw new IllegalStateException("setPreviewTimestamp called for capture with no preview targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setPreviewTimestamp called on already completed request.");
            }
            this.mReceivedFlags |= 8;
            if (this.mTimestamp == 0L) {
                this.mTimestamp = timestamp;
            }
            if (!this.needsJpeg && !this.mHasStarted) {
                this.mHasStarted = true;
                this.this$0.mDeviceState.setCaptureStart(this.mRequest, this.mTimestamp, -1);
            }
            this.tryComplete();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setPreviewProduced() {
            if (!this.needsPreview) {
                throw new IllegalStateException("setPreviewProduced called for capture with no preview targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setPreviewProduced called on already completed request.");
            }
            this.mReceivedFlags |= 4;
            this.tryComplete();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setPreviewFailed() {
            if (!this.needsPreview || this.isPreviewCompleted()) {
                return;
            }
            this.mFailedPreview = true;
            this.mReceivedFlags |= 4;
            this.mReceivedFlags |= 8;
            this.tryComplete();
        }

        private final int $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$compareTo(CaptureHolder captureHolder) {
            return this.mRequest.getFrameNumber() > captureHolder.mRequest.getFrameNumber() ? 1 : (this.mRequest.getFrameNumber() == captureHolder.mRequest.getFrameNumber() ? 0 : -1);
        }

        private final boolean $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$equals(Object o) {
            return o instanceof CaptureHolder && this.compareTo((CaptureHolder)o) == 0;
        }

        private void __constructor__(CaptureCollector captureCollector, RequestHolder requestHolder, LegacyRequest legacyRequest) {
            this.$$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$__constructor__(captureCollector, requestHolder, legacyRequest);
        }

        public CaptureHolder(CaptureCollector captureCollector, RequestHolder requestHolder, LegacyRequest legacyRequest) {
            this.this$0 = captureCollector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$__constructor__(android.hardware.camera2.legacy.CaptureCollector android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.legacy.LegacyRequest ), 0, this, captureCollector, requestHolder, legacyRequest);
        }

        public boolean isPreviewCompleted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPreviewCompleted", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$isPreviewCompleted(), 0, this);
        }

        public boolean isJpegCompleted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isJpegCompleted", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$isJpegCompleted(), 0, this);
        }

        public boolean isCompleted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isCompleted", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$isCompleted(), 0, this);
        }

        public void tryComplete() {
            InvokeDynamicSupport.bootstrap("tryComplete", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$tryComplete(), 0, this);
        }

        public void setJpegTimestamp(long l) {
            InvokeDynamicSupport.bootstrap("setJpegTimestamp", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setJpegTimestamp(long ), 0, this, l);
        }

        public void setJpegProduced() {
            InvokeDynamicSupport.bootstrap("setJpegProduced", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setJpegProduced(), 0, this);
        }

        public void setJpegFailed() {
            InvokeDynamicSupport.bootstrap("setJpegFailed", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setJpegFailed(), 0, this);
        }

        public void setPreviewTimestamp(long l) {
            InvokeDynamicSupport.bootstrap("setPreviewTimestamp", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setPreviewTimestamp(long ), 0, this, l);
        }

        public void setPreviewProduced() {
            InvokeDynamicSupport.bootstrap("setPreviewProduced", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setPreviewProduced(), 0, this);
        }

        public void setPreviewFailed() {
            InvokeDynamicSupport.bootstrap("setPreviewFailed", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$setPreviewFailed(), 0, this);
        }

        @Override
        public int compareTo(CaptureHolder captureHolder) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$compareTo(android.hardware.camera2.legacy.CaptureCollector$CaptureHolder ), 0, this, captureHolder);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_legacy_CaptureCollector_CaptureHolder$equals(java.lang.Object ), 0, this, object);
        }

        public /* synthetic */ CaptureHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptureHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

