/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import java.util.GregorianCalendar;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GeomagneticField
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private float mX;
    private float mY;
    private float mZ;
    private float mGcLatitudeRad;
    private float mGcLongitudeRad;
    private float mGcRadiusKm;
    private static float EARTH_SEMI_MAJOR_AXIS_KM = 6378.137f;
    private static float EARTH_SEMI_MINOR_AXIS_KM = 6356.7524f;
    private static float EARTH_REFERENCE_RADIUS_KM = 6371.2f;
    private static float[][] G_COEFF;
    private static float[][] H_COEFF;
    private static float[][] DELTA_G;
    private static float[][] DELTA_H;
    private static long BASE_TIME;
    private static float[][] SCHMIDT_QUASI_NORM_FACTORS;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_hardware_GeomagneticField$__constructor__(float gdLatitudeDeg, float gdLongitudeDeg, float altitudeMeters, long timeMillis) {
        int MAX_N = G_COEFF.length;
        gdLatitudeDeg = Math.min(89.99999f, Math.max(-89.99999f, gdLatitudeDeg));
        this.computeGeocentricCoordinates(gdLatitudeDeg, gdLongitudeDeg, altitudeMeters);
        if (!$assertionsDisabled && G_COEFF.length != H_COEFF.length) {
            throw new AssertionError();
        }
        LegendreTable legendre = new LegendreTable(MAX_N - 1, (float)(1.5707963267948966 - (double)this.mGcLatitudeRad));
        float[] relativeRadiusPower = new float[MAX_N + 2];
        relativeRadiusPower[0] = 1.0f;
        relativeRadiusPower[1] = 6371.2f / this.mGcRadiusKm;
        for (int i = 2; i < relativeRadiusPower.length; ++i) {
            relativeRadiusPower[i] = relativeRadiusPower[i - 1] * relativeRadiusPower[1];
        }
        float[] sinMLon = new float[MAX_N];
        float[] cosMLon = new float[MAX_N];
        sinMLon[0] = 0.0f;
        cosMLon[0] = 1.0f;
        sinMLon[1] = (float)Math.sin(this.mGcLongitudeRad);
        cosMLon[1] = (float)Math.cos(this.mGcLongitudeRad);
        for (int m = 2; m < MAX_N; ++m) {
            int x = m >> 1;
            sinMLon[m] = sinMLon[m - x] * cosMLon[x] + cosMLon[m - x] * sinMLon[x];
            cosMLon[m] = cosMLon[m - x] * cosMLon[x] - sinMLon[m - x] * sinMLon[x];
        }
        float inverseCosLatitude = 1.0f / (float)Math.cos(this.mGcLatitudeRad);
        float yearsSinceBase = (float)(timeMillis - BASE_TIME) / 3.1536E10f;
        float gcX = 0.0f;
        float gcY = 0.0f;
        float gcZ = 0.0f;
        for (int n = 1; n < MAX_N; ++n) {
            for (int m = 0; m <= n; ++m) {
                float g = G_COEFF[n][m] + yearsSinceBase * DELTA_G[n][m];
                float h = H_COEFF[n][m] + yearsSinceBase * DELTA_H[n][m];
                gcX += relativeRadiusPower[n + 2] * (g * cosMLon[m] + h * sinMLon[m]) * legendre.mPDeriv[n][m] * SCHMIDT_QUASI_NORM_FACTORS[n][m];
                gcY += relativeRadiusPower[n + 2] * (float)m * (g * sinMLon[m] - h * cosMLon[m]) * legendre.mP[n][m] * SCHMIDT_QUASI_NORM_FACTORS[n][m] * inverseCosLatitude;
                gcZ -= (float)(n + 1) * relativeRadiusPower[n + 2] * (g * cosMLon[m] + h * sinMLon[m]) * legendre.mP[n][m] * SCHMIDT_QUASI_NORM_FACTORS[n][m];
            }
        }
        double latDiffRad = Math.toRadians(gdLatitudeDeg) - (double)this.mGcLatitudeRad;
        this.mX = (float)((double)gcX * Math.cos(latDiffRad) + (double)gcZ * Math.sin(latDiffRad));
        this.mY = gcY;
        this.mZ = (float)((double)(-gcX) * Math.sin(latDiffRad) + (double)gcZ * Math.cos(latDiffRad));
    }

    private final float $$robo$$android_hardware_GeomagneticField$getX() {
        return this.mX;
    }

    private final float $$robo$$android_hardware_GeomagneticField$getY() {
        return this.mY;
    }

    private final float $$robo$$android_hardware_GeomagneticField$getZ() {
        return this.mZ;
    }

    private final float $$robo$$android_hardware_GeomagneticField$getDeclination() {
        return (float)Math.toDegrees(Math.atan2(this.mY, this.mX));
    }

    private final float $$robo$$android_hardware_GeomagneticField$getInclination() {
        return (float)Math.toDegrees(Math.atan2(this.mZ, this.getHorizontalStrength()));
    }

    private final float $$robo$$android_hardware_GeomagneticField$getHorizontalStrength() {
        return (float)Math.hypot(this.mX, this.mY);
    }

    private final float $$robo$$android_hardware_GeomagneticField$getFieldStrength() {
        return (float)Math.sqrt(this.mX * this.mX + this.mY * this.mY + this.mZ * this.mZ);
    }

    private final void $$robo$$android_hardware_GeomagneticField$computeGeocentricCoordinates(float gdLatitudeDeg, float gdLongitudeDeg, float altitudeMeters) {
        float altitudeKm = altitudeMeters / 1000.0f;
        float a2 = 4.0680636E7f;
        float b2 = 4.04083E7f;
        double gdLatRad = Math.toRadians(gdLatitudeDeg);
        float clat = (float)Math.cos(gdLatRad);
        float slat = (float)Math.sin(gdLatRad);
        float tlat = slat / clat;
        float latRad = (float)Math.sqrt(a2 * clat * clat + b2 * slat * slat);
        this.mGcLatitudeRad = (float)Math.atan(tlat * (latRad * altitudeKm + b2) / (latRad * altitudeKm + a2));
        this.mGcLongitudeRad = (float)Math.toRadians(gdLongitudeDeg);
        float radSq = altitudeKm * altitudeKm + 2.0f * altitudeKm * (float)Math.sqrt(a2 * clat * clat + b2 * slat * slat) + (a2 * a2 * clat * clat + b2 * b2 * slat * slat) / (a2 * clat * clat + b2 * slat * slat);
        this.mGcRadiusKm = (float)Math.sqrt(radSq);
    }

    private static final float[][] $$robo$$android_hardware_GeomagneticField$computeSchmidtQuasiNormFactors(int maxN) {
        float[][] schmidtQuasiNorm = new float[maxN + 1][];
        schmidtQuasiNorm[0] = new float[]{1.0f};
        for (int n = 1; n <= maxN; ++n) {
            schmidtQuasiNorm[n] = new float[n + 1];
            schmidtQuasiNorm[n][0] = schmidtQuasiNorm[n - 1][0] * (float)(2 * n - 1) / (float)n;
            for (int m = 1; m <= n; ++m) {
                schmidtQuasiNorm[n][m] = schmidtQuasiNorm[n][m - 1] * (float)Math.sqrt((float)((n - m + 1) * (m == 1 ? 2 : 1)) / (float)(n + m));
            }
        }
        return schmidtQuasiNorm;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !GeomagneticField.class.desiredAssertionStatus();
        G_COEFF = new float[][]{{0.0f}, {-29496.6f, -1586.3f}, {-2396.6f, 3026.1f, 1668.6f}, {1340.1f, -2326.2f, 1231.9f, 634.0f}, {912.6f, 808.9f, 166.7f, -357.1f, 89.4f}, {-230.9f, 357.2f, 200.3f, -141.1f, -163.0f, -7.8f}, {72.8f, 68.6f, 76.0f, -141.4f, -22.8f, 13.2f, -77.9f}, {80.5f, -75.1f, -4.7f, 45.3f, 13.9f, 10.4f, 1.7f, 4.9f}, {24.4f, 8.1f, -14.5f, -5.6f, -19.3f, 11.5f, 10.9f, -14.1f, -3.7f}, {5.4f, 9.4f, 3.4f, -5.2f, 3.1f, -12.4f, -0.7f, 8.4f, -8.5f, -10.1f}, {-2.0f, -6.3f, 0.9f, -1.1f, -0.2f, 2.5f, -0.3f, 2.2f, 3.1f, -1.0f, -2.8f}, {3.0f, -1.5f, -2.1f, 1.7f, -0.5f, 0.5f, -0.8f, 0.4f, 1.8f, 0.1f, 0.7f, 3.8f}, {-2.2f, -0.2f, 0.3f, 1.0f, -0.6f, 0.9f, -0.1f, 0.5f, -0.4f, -0.4f, 0.2f, -0.8f, 0.0f}};
        H_COEFF = new float[][]{{0.0f}, {0.0f, 4944.4f}, {0.0f, -2707.7f, -576.1f}, {0.0f, -160.2f, 251.9f, -536.6f}, {0.0f, 286.4f, -211.2f, 164.3f, -309.1f}, {0.0f, 44.6f, 188.9f, -118.2f, 0.0f, 100.9f}, {0.0f, -20.8f, 44.1f, 61.5f, -66.3f, 3.1f, 55.0f}, {0.0f, -57.9f, -21.1f, 6.5f, 24.9f, 7.0f, -27.7f, -3.3f}, {0.0f, 11.0f, -20.0f, 11.9f, -17.4f, 16.7f, 7.0f, -10.8f, 1.7f}, {0.0f, -20.5f, 11.5f, 12.8f, -7.2f, -7.4f, 8.0f, 2.1f, -6.1f, 7.0f}, {0.0f, 2.8f, -0.1f, 4.7f, 4.4f, -7.2f, -1.0f, -3.9f, -2.0f, -2.0f, -8.3f}, {0.0f, 0.2f, 1.7f, -0.6f, -1.8f, 0.9f, -0.4f, -2.5f, -1.3f, -2.1f, -1.9f, -1.8f}, {0.0f, -0.9f, 0.3f, 2.1f, -2.5f, 0.5f, 0.6f, 0.0f, 0.1f, 0.3f, -0.9f, -0.2f, 0.9f}};
        DELTA_G = new float[][]{{0.0f}, {11.6f, 16.5f}, {-12.1f, -4.4f, 1.9f}, {0.4f, -4.1f, -2.9f, -7.7f}, {-1.8f, 2.3f, -8.7f, 4.6f, -2.1f}, {-1.0f, 0.6f, -1.8f, -1.0f, 0.9f, 1.0f}, {-0.2f, -0.2f, -0.1f, 2.0f, -1.7f, -0.3f, 1.7f}, {0.1f, -0.1f, -0.6f, 1.3f, 0.4f, 0.3f, -0.7f, 0.6f}, {-0.1f, 0.1f, -0.6f, 0.2f, -0.2f, 0.3f, 0.3f, -0.6f, 0.2f}, {0.0f, -0.1f, 0.0f, 0.3f, -0.4f, -0.3f, 0.1f, -0.1f, -0.4f, -0.2f}, {0.0f, 0.0f, -0.1f, 0.2f, 0.0f, -0.1f, -0.2f, 0.0f, -0.1f, -0.2f, -0.2f}, {0.0f, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.1f, 0.0f}, {0.0f, 0.0f, 0.1f, 0.1f, -0.1f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.1f, 0.1f}};
        DELTA_H = new float[][]{{0.0f}, {0.0f, -25.9f}, {0.0f, -22.5f, -11.8f}, {0.0f, 7.3f, -3.9f, -2.6f}, {0.0f, 1.1f, 2.7f, 3.9f, -0.8f}, {0.0f, 0.4f, 1.8f, 1.2f, 4.0f, -0.6f}, {0.0f, -0.2f, -2.1f, -0.4f, -0.6f, 0.5f, 0.9f}, {0.0f, 0.7f, 0.3f, -0.1f, -0.1f, -0.8f, -0.3f, 0.3f}, {0.0f, -0.1f, 0.2f, 0.4f, 0.4f, 0.1f, -0.1f, 0.4f, 0.3f}, {0.0f, 0.0f, -0.2f, 0.0f, -0.1f, 0.1f, 0.0f, -0.2f, 0.3f, 0.2f}, {0.0f, 0.1f, -0.1f, 0.0f, -0.1f, -0.1f, 0.0f, -0.1f, -0.2f, 0.0f, -0.1f}, {0.0f, 0.0f, 0.1f, 0.0f, 0.1f, 0.0f, 0.1f, 0.0f, -0.1f, -0.1f, 0.0f, -0.1f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
        BASE_TIME = new GregorianCalendar(2010, 1, 1).getTimeInMillis();
        SCHMIDT_QUASI_NORM_FACTORS = GeomagneticField.computeSchmidtQuasiNormFactors(G_COEFF.length);
    }

    private void __constructor__(float f, float f2, float f3, long l) {
        this.$$robo$$android_hardware_GeomagneticField$__constructor__(f, f2, f3, l);
    }

    public GeomagneticField(float f, float f2, float f3, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_GeomagneticField$__constructor__(float float float long ), 0, this, f, f2, f3, l);
    }

    public float getX() {
        return (float)InvokeDynamicSupport.bootstrap("getX", $$robo$$android_hardware_GeomagneticField$getX(), 0, this);
    }

    public float getY() {
        return (float)InvokeDynamicSupport.bootstrap("getY", $$robo$$android_hardware_GeomagneticField$getY(), 0, this);
    }

    public float getZ() {
        return (float)InvokeDynamicSupport.bootstrap("getZ", $$robo$$android_hardware_GeomagneticField$getZ(), 0, this);
    }

    public float getDeclination() {
        return (float)InvokeDynamicSupport.bootstrap("getDeclination", $$robo$$android_hardware_GeomagneticField$getDeclination(), 0, this);
    }

    public float getInclination() {
        return (float)InvokeDynamicSupport.bootstrap("getInclination", $$robo$$android_hardware_GeomagneticField$getInclination(), 0, this);
    }

    public float getHorizontalStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getHorizontalStrength", $$robo$$android_hardware_GeomagneticField$getHorizontalStrength(), 0, this);
    }

    public float getFieldStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getFieldStrength", $$robo$$android_hardware_GeomagneticField$getFieldStrength(), 0, this);
    }

    private void computeGeocentricCoordinates(float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("computeGeocentricCoordinates", $$robo$$android_hardware_GeomagneticField$computeGeocentricCoordinates(float float float ), 0, this, f, f2, f3);
    }

    private static float[][] computeSchmidtQuasiNormFactors(int n) {
        return InvokeDynamicSupport.bootstrapStatic("computeSchmidtQuasiNormFactors", $$robo$$android_hardware_GeomagneticField$computeSchmidtQuasiNormFactors(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(GeomagneticField.class);
    }

    public /* synthetic */ GeomagneticField() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GeomagneticField)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class LegendreTable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public float[][] mP;
        public float[][] mPDeriv;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_hardware_GeomagneticField_LegendreTable$__constructor__(int maxN, float thetaRad) {
            float cos = (float)Math.cos(thetaRad);
            float sin = (float)Math.sin(thetaRad);
            this.mP = new float[maxN + 1][];
            this.mPDeriv = new float[maxN + 1][];
            this.mP[0] = new float[]{1.0f};
            this.mPDeriv[0] = new float[]{0.0f};
            for (int n = 1; n <= maxN; ++n) {
                this.mP[n] = new float[n + 1];
                this.mPDeriv[n] = new float[n + 1];
                for (int m = 0; m <= n; ++m) {
                    if (n == m) {
                        this.mP[n][m] = sin * this.mP[n - 1][m - 1];
                        this.mPDeriv[n][m] = cos * this.mP[n - 1][m - 1] + sin * this.mPDeriv[n - 1][m - 1];
                        continue;
                    }
                    if (n == 1 || m == n - 1) {
                        this.mP[n][m] = cos * this.mP[n - 1][m];
                        this.mPDeriv[n][m] = -sin * this.mP[n - 1][m] + cos * this.mPDeriv[n - 1][m];
                        continue;
                    }
                    if (!($assertionsDisabled || n > 1 && m < n - 1)) {
                        throw new AssertionError();
                    }
                    float k = (float)((n - 1) * (n - 1) - m * m) / (float)((2 * n - 1) * (2 * n - 3));
                    this.mP[n][m] = cos * this.mP[n - 1][m] - k * this.mP[n - 2][m];
                    this.mPDeriv[n][m] = -sin * this.mP[n - 1][m] + cos * this.mPDeriv[n - 1][m] - k * this.mPDeriv[n - 2][m];
                }
            }
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !GeomagneticField.class.desiredAssertionStatus();
        }

        private void __constructor__(int n, float f) {
            this.$$robo$$android_hardware_GeomagneticField_LegendreTable$__constructor__(n, f);
        }

        public LegendreTable(int n, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_GeomagneticField_LegendreTable$__constructor__(int float ), 0, this, n, f);
        }

        static {
            RobolectricInternals.classInitializing(LegendreTable.class);
        }

        public /* synthetic */ LegendreTable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegendreTable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

