/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class FontVariationAxis
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mTag;
    private String mTagString;
    private float mStyleValue;
    private static Pattern TAG_PATTERN;
    private static Pattern STYLE_VALUE_PATTERN;

    private void $$robo$$android_graphics_fonts_FontVariationAxis$__constructor__(String tagString, float styleValue) {
        if (!FontVariationAxis.isValidTag(tagString)) {
            throw new IllegalArgumentException("Illegal tag pattern: " + tagString);
        }
        this.mTag = FontVariationAxis.makeTag(tagString);
        this.mTagString = tagString;
        this.mStyleValue = styleValue;
    }

    private final int $$robo$$android_graphics_fonts_FontVariationAxis$getOpenTypeTagValue() {
        return this.mTag;
    }

    private final String $$robo$$android_graphics_fonts_FontVariationAxis$getTag() {
        return this.mTagString;
    }

    private final float $$robo$$android_graphics_fonts_FontVariationAxis$getStyleValue() {
        return this.mStyleValue;
    }

    private final String $$robo$$android_graphics_fonts_FontVariationAxis$toString() {
        return "'" + this.mTagString + "' " + Float.toString(this.mStyleValue);
    }

    private static final boolean $$robo$$android_graphics_fonts_FontVariationAxis$isValidTag(String tagString) {
        return tagString != null && TAG_PATTERN.matcher(tagString).matches();
    }

    private static final boolean $$robo$$android_graphics_fonts_FontVariationAxis$isValidValueFormat(String valueString) {
        return valueString != null && STYLE_VALUE_PATTERN.matcher(valueString).matches();
    }

    private static final int $$robo$$android_graphics_fonts_FontVariationAxis$makeTag(String tagString) {
        char c1 = tagString.charAt(0);
        char c2 = tagString.charAt(1);
        char c3 = tagString.charAt(2);
        char c4 = tagString.charAt(3);
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private static final FontVariationAxis[] $$robo$$android_graphics_fonts_FontVariationAxis$fromFontVariationSettings(String settings) {
        if (settings == null || settings.isEmpty()) {
            return null;
        }
        ArrayList<FontVariationAxis> axisList = new ArrayList<FontVariationAxis>();
        int length = settings.length();
        for (int i = 0; i < length; ++i) {
            float value;
            char c = settings.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != '\'' && c != '\"' || length < i + 6 || settings.charAt(i + 5) != c) {
                throw new IllegalArgumentException("Tag should be wrapped with double or single quote: " + settings);
            }
            String tagString = settings.substring(i + 1, i + 5);
            int endOfValueString = settings.indexOf(44, i += 6);
            if (endOfValueString == -1) {
                endOfValueString = length;
            }
            try {
                value = Float.parseFloat(settings.substring(i, endOfValueString));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse float string: " + e.getMessage());
            }
            axisList.add(new FontVariationAxis(tagString, value));
            i = endOfValueString;
        }
        if (axisList.isEmpty()) {
            return null;
        }
        return axisList.toArray(new FontVariationAxis[0]);
    }

    private static final String $$robo$$android_graphics_fonts_FontVariationAxis$toFontVariationSettings(FontVariationAxis[] axes) {
        if (axes == null || axes.length == 0) {
            return "";
        }
        return TextUtils.join((CharSequence)",", axes);
    }

    static void __staticInitializer__() {
        TAG_PATTERN = Pattern.compile("[ -~]{4}");
        STYLE_VALUE_PATTERN = Pattern.compile("-?(([0-9]+(\\.[0-9]+)?)|(\\.[0-9]+))");
    }

    private void __constructor__(String string2, float f) {
        this.$$robo$$android_graphics_fonts_FontVariationAxis$__constructor__(string2, f);
    }

    public FontVariationAxis(String string2, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_fonts_FontVariationAxis$__constructor__(java.lang.String float ), 0, this, string2, f);
    }

    public int getOpenTypeTagValue() {
        return (int)InvokeDynamicSupport.bootstrap("getOpenTypeTagValue", $$robo$$android_graphics_fonts_FontVariationAxis$getOpenTypeTagValue(), 0, this);
    }

    public String getTag() {
        return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_graphics_fonts_FontVariationAxis$getTag(), 0, this);
    }

    public float getStyleValue() {
        return (float)InvokeDynamicSupport.bootstrap("getStyleValue", $$robo$$android_graphics_fonts_FontVariationAxis$getStyleValue(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_graphics_fonts_FontVariationAxis$toString(), 0, this);
    }

    private static boolean isValidTag(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidTag", $$robo$$android_graphics_fonts_FontVariationAxis$isValidTag(java.lang.String ), 0, (String)string2);
    }

    private static boolean isValidValueFormat(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidValueFormat", $$robo$$android_graphics_fonts_FontVariationAxis$isValidValueFormat(java.lang.String ), 0, (String)string2);
    }

    public static int makeTag(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("makeTag", $$robo$$android_graphics_fonts_FontVariationAxis$makeTag(java.lang.String ), 0, (String)string2);
    }

    public static FontVariationAxis[] fromFontVariationSettings(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromFontVariationSettings", $$robo$$android_graphics_fonts_FontVariationAxis$fromFontVariationSettings(java.lang.String ), 0, (String)string2);
    }

    public static String toFontVariationSettings(FontVariationAxis[] fontVariationAxisArray) {
        return InvokeDynamicSupport.bootstrapStatic("toFontVariationSettings", $$robo$$android_graphics_fonts_FontVariationAxis$toFontVariationSettings(android.graphics.fonts.FontVariationAxis[] ), 0, (FontVariationAxis[])fontVariationAxisArray);
    }

    static {
        RobolectricInternals.classInitializing(FontVariationAxis.class);
    }

    public /* synthetic */ FontVariationAxis() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontVariationAxis)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

