/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScaleDrawable
extends DrawableWrapper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_LEVEL = 10000;
    private Rect mTmpRect;
    private ScaleState mState;

    private void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(Drawable drawable2, int gravity, float scaleWidth, float scaleHeight) {
        this.mState.mGravity = gravity;
        this.mState.mScaleWidth = scaleWidth;
        this.mState.mScaleHeight = scaleHeight;
        this.setDrawable(drawable2);
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = ScaleDrawable.obtainAttributes(r, theme, attrs, R.styleable.ScaleDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_ScaleDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        ScaleState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ScaleDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                ScaleDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        this.updateLocalState();
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <scale> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$updateStateFromTypedArray(TypedArray a) {
        ScaleState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        ScaleState.access$002(state, a.extractThemeAttrs());
        state.mScaleWidth = ScaleDrawable.getPercent(a, 1, state.mScaleWidth);
        state.mScaleHeight = ScaleDrawable.getPercent(a, 2, state.mScaleHeight);
        state.mGravity = a.getInt(3, state.mGravity);
        state.mUseIntrinsicSizeAsMin = a.getBoolean(4, state.mUseIntrinsicSizeAsMin);
        state.mInitialLevel = a.getInt(5, state.mInitialLevel);
    }

    private static final float $$robo$$android_graphics_drawable_ScaleDrawable$getPercent(TypedArray a, int index, float defaultValue) {
        int type = a.getType(index);
        if (type == 6 || type == 0) {
            return a.getFraction(index, 1, 1, defaultValue);
        }
        String s = a.getString(index);
        if (s != null && s.endsWith("%")) {
            String f = s.substring(0, s.length() - 1);
            return Float.parseFloat(f) / 100.0f;
        }
        return defaultValue;
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$draw(Canvas canvas) {
        Drawable d = this.getDrawable();
        if (d != null && d.getLevel() != 0) {
            d.draw(canvas);
        }
    }

    private final int $$robo$$android_graphics_drawable_ScaleDrawable$getOpacity() {
        Drawable d = this.getDrawable();
        if (d.getLevel() == 0) {
            return -2;
        }
        int opacity = d.getOpacity();
        if (opacity == -1 && d.getLevel() < 10000) {
            return -3;
        }
        return opacity;
    }

    private final boolean $$robo$$android_graphics_drawable_ScaleDrawable$onLevelChange(int level) {
        super.onLevelChange(level);
        this.onBoundsChange(this.getBounds());
        this.invalidateSelf();
        return true;
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$onBoundsChange(Rect bounds) {
        Drawable d = this.getDrawable();
        Rect r = this.mTmpRect;
        boolean min = this.mState.mUseIntrinsicSizeAsMin;
        int level = this.getLevel();
        int w = bounds.width();
        if (this.mState.mScaleWidth > 0.0f) {
            int iw = min ? d.getIntrinsicWidth() : 0;
            w -= (int)((float)((w - iw) * (10000 - level)) * this.mState.mScaleWidth / 10000.0f);
        }
        int h = bounds.height();
        if (this.mState.mScaleHeight > 0.0f) {
            int ih = min ? d.getIntrinsicHeight() : 0;
            h -= (int)((float)((h - ih) * (10000 - level)) * this.mState.mScaleHeight / 10000.0f);
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mState.mGravity, w, h, bounds, r, layoutDirection);
        if (w > 0 && h > 0) {
            d.setBounds(r.left, r.top, r.right, r.bottom);
        }
    }

    private final DrawableWrapper.DrawableWrapperState $$robo$$android_graphics_drawable_ScaleDrawable$mutateConstantState() {
        this.mState = new ScaleState(this.mState, null);
        return this.mState;
    }

    private void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(ScaleState state, Resources res) {
        this.mTmpRect = new Rect();
        this.mState = state;
        this.updateLocalState();
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$updateLocalState() {
        this.setLevel(this.mState.mInitialLevel);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(ScaleState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__();
    }

    ScaleDrawable() {
        this(new ScaleState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Drawable drawable2, int n, float f, float f2) {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(drawable2, n, f, f2);
    }

    public ScaleDrawable(Drawable drawable2, int n, float f, float f2) {
        this(new ScaleState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(android.graphics.drawable.Drawable int float float ), 0, this, drawable2, n, f, f2);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_ScaleDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_ScaleDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_ScaleDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_ScaleDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private static float getPercent(TypedArray typedArray, int n, float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getPercent", $$robo$$android_graphics_drawable_ScaleDrawable$getPercent(android.content.res.TypedArray int float ), 0, (TypedArray)typedArray, (int)n, (float)f);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_ScaleDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_ScaleDrawable$getOpacity(), 0, this);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_ScaleDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_ScaleDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        return InvokeDynamicSupport.bootstrap("mutateConstantState", $$robo$$android_graphics_drawable_ScaleDrawable$mutateConstantState(), 0, this);
    }

    private void __constructor__(ScaleState scaleState, Resources resources) {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(scaleState, resources);
    }

    private ScaleDrawable(ScaleState scaleState, Resources resources) {
        super(scaleState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(android.graphics.drawable.ScaleDrawable$ScaleState android.content.res.Resources ), 0, this, scaleState, resources);
    }

    private void updateLocalState() {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_ScaleDrawable$updateLocalState(), 0, this);
    }

    private /* synthetic */ void __constructor__(ScaleState scaleState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(scaleState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScaleDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ScaleState
    extends DrawableWrapper.DrawableWrapperState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static float DO_NOT_SCALE = -1.0f;
        private int[] mThemeAttrs;
        float mScaleWidth;
        float mScaleHeight;
        int mGravity;
        boolean mUseIntrinsicSizeAsMin;
        int mInitialLevel;

        private void $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$__constructor__(ScaleState orig, Resources res) {
            this.mScaleWidth = -1.0f;
            this.mScaleHeight = -1.0f;
            this.mGravity = 3;
            this.mUseIntrinsicSizeAsMin = false;
            this.mInitialLevel = 0;
            if (orig != null) {
                this.mScaleWidth = orig.mScaleWidth;
                this.mScaleHeight = orig.mScaleHeight;
                this.mGravity = orig.mGravity;
                this.mUseIntrinsicSizeAsMin = orig.mUseIntrinsicSizeAsMin;
                this.mInitialLevel = orig.mInitialLevel;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$newDrawable(Resources res) {
            return new ScaleDrawable(this, res);
        }

        static /* synthetic */ int[] access$002(ScaleState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(ScaleState scaleState, Resources resources) {
            this.$$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$__constructor__(scaleState, resources);
        }

        ScaleState(ScaleState scaleState, Resources resources) {
            super(scaleState, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$__constructor__(android.graphics.drawable.ScaleDrawable$ScaleState android.content.res.Resources ), 0, this, scaleState, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        public /* synthetic */ ScaleState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScaleState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

