/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Icon
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Icon";
    public static int TYPE_BITMAP = 1;
    public static int TYPE_RESOURCE = 2;
    public static int TYPE_DATA = 3;
    public static int TYPE_URI = 4;
    public static int TYPE_ADAPTIVE_BITMAP = 5;
    private static int VERSION_STREAM_SERIALIZER = 1;
    private int mType;
    private ColorStateList mTintList;
    static PorterDuff.Mode DEFAULT_TINT_MODE;
    private PorterDuff.Mode mTintMode;
    private Object mObj1;
    private String mString1;
    private int mInt1;
    private int mInt2;
    public static int MIN_ASHMEM_ICON_SIZE = 131072;
    public static Parcelable.Creator<Icon> CREATOR;

    private final int $$robo$$android_graphics_drawable_Icon$getType() {
        return this.mType;
    }

    private final Bitmap $$robo$$android_graphics_drawable_Icon$getBitmap() {
        if (this.mType != 1 && this.mType != 5) {
            throw new IllegalStateException("called getBitmap() on " + this);
        }
        return (Bitmap)this.mObj1;
    }

    private final void $$robo$$android_graphics_drawable_Icon$setBitmap(Bitmap b) {
        this.mObj1 = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_graphics_drawable_Icon$getDataLength() {
        if (this.mType != 3) {
            throw new IllegalStateException("called getDataLength() on " + this);
        }
        Icon icon = this;
        synchronized (icon) {
            return this.mInt1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_graphics_drawable_Icon$getDataOffset() {
        if (this.mType != 3) {
            throw new IllegalStateException("called getDataOffset() on " + this);
        }
        Icon icon = this;
        synchronized (icon) {
            return this.mInt2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] $$robo$$android_graphics_drawable_Icon$getDataBytes() {
        if (this.mType != 3) {
            throw new IllegalStateException("called getDataBytes() on " + this);
        }
        Icon icon = this;
        synchronized (icon) {
            return (byte[])this.mObj1;
        }
    }

    private final Resources $$robo$$android_graphics_drawable_Icon$getResources() {
        if (this.mType != 2) {
            throw new IllegalStateException("called getResources() on " + this);
        }
        return (Resources)this.mObj1;
    }

    private final String $$robo$$android_graphics_drawable_Icon$getResPackage() {
        if (this.mType != 2) {
            throw new IllegalStateException("called getResPackage() on " + this);
        }
        return this.mString1;
    }

    private final int $$robo$$android_graphics_drawable_Icon$getResId() {
        if (this.mType != 2) {
            throw new IllegalStateException("called getResId() on " + this);
        }
        return this.mInt1;
    }

    private final String $$robo$$android_graphics_drawable_Icon$getUriString() {
        if (this.mType != 4) {
            throw new IllegalStateException("called getUriString() on " + this);
        }
        return this.mString1;
    }

    private final Uri $$robo$$android_graphics_drawable_Icon$getUri() {
        return Uri.parse(this.getUriString());
    }

    private static final String $$robo$$android_graphics_drawable_Icon$typeToString(int x) {
        switch (x) {
            case 1: {
                return "BITMAP";
            }
            case 5: {
                return "BITMAP_MASKABLE";
            }
            case 3: {
                return "DATA";
            }
            case 2: {
                return "RESOURCE";
            }
            case 4: {
                return "URI";
            }
        }
        return "UNKNOWN";
    }

    private final void $$robo$$android_graphics_drawable_Icon$loadDrawableAsync(Context context, Message andThen) {
        if (andThen.getTarget() == null) {
            throw new IllegalArgumentException("callback message must have a target handler");
        }
        new LoadDrawableTask(this, context, andThen).runAsync();
    }

    private final void $$robo$$android_graphics_drawable_Icon$loadDrawableAsync(Context context, OnDrawableLoadedListener listener, Handler handler) {
        new LoadDrawableTask(this, context, handler, listener).runAsync();
    }

    private final Drawable $$robo$$android_graphics_drawable_Icon$loadDrawable(Context context) {
        Drawable result = this.loadDrawableInner(context);
        if (result != null && (this.mTintList != null || this.mTintMode != DEFAULT_TINT_MODE)) {
            result.mutate();
            result.setTintList(this.mTintList);
            result.setTintMode(this.mTintMode);
        }
        return result;
    }

    private final Drawable $$robo$$android_graphics_drawable_Icon$loadDrawableInner(Context context) {
        switch (this.mType) {
            case 1: {
                return new BitmapDrawable(context.getResources(), this.getBitmap());
            }
            case 5: {
                return new AdaptiveIconDrawable(null, new BitmapDrawable(context.getResources(), this.getBitmap()));
            }
            case 2: {
                if (this.getResources() == null) {
                    String resPackage = this.getResPackage();
                    if (TextUtils.isEmpty(resPackage)) {
                        resPackage = context.getPackageName();
                    }
                    if ("android".equals(resPackage)) {
                        this.mObj1 = Resources.getSystem();
                    } else {
                        PackageManager pm = context.getPackageManager();
                        try {
                            ApplicationInfo ai = pm.getApplicationInfo(resPackage, 8192);
                            if (ai == null) break;
                            this.mObj1 = pm.getResourcesForApplication(ai);
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            Log.e("Icon", String.format("Unable to find pkg=%s for icon %s", resPackage, this), e);
                            break;
                        }
                    }
                }
                try {
                    return this.getResources().getDrawable(this.getResId(), context.getTheme());
                }
                catch (RuntimeException e) {
                    Log.e("Icon", String.format("Unable to load resource 0x%08x from pkg=%s", this.getResId(), this.getResPackage()), e);
                    break;
                }
            }
            case 3: {
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeByteArray(this.getDataBytes(), this.getDataOffset(), this.getDataLength()));
            }
            case 4: {
                Uri uri = this.getUri();
                String scheme = uri.getScheme();
                InputStream is = null;
                if ("content".equals(scheme) || "file".equals(scheme)) {
                    try {
                        is = context.getContentResolver().openInputStream(uri);
                    }
                    catch (Exception e) {
                        Log.w("Icon", "Unable to load image from URI: " + uri, e);
                    }
                } else {
                    try {
                        is = new FileInputStream(new File(this.mString1));
                    }
                    catch (FileNotFoundException e) {
                        Log.w("Icon", "Unable to load image from path: " + uri, e);
                    }
                }
                if (is == null) break;
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeStream(is));
            }
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_Icon$loadDrawableAsUser(Context context, int userId) {
        if (this.mType == 2) {
            String resPackage = this.getResPackage();
            if (TextUtils.isEmpty(resPackage)) {
                resPackage = context.getPackageName();
            }
            if (this.getResources() == null && !this.getResPackage().equals("android")) {
                PackageManager pm = context.getPackageManager();
                try {
                    this.mObj1 = pm.getResourcesForApplicationAsUser(resPackage, userId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e("Icon", String.format("Unable to find pkg=%s user=%d", this.getResPackage(), userId), e);
                }
            }
        }
        return this.loadDrawable(context);
    }

    private final void $$robo$$android_graphics_drawable_Icon$convertToAshmem() {
        if ((this.mType == 1 || this.mType == 5) && this.getBitmap().isMutable() && this.getBitmap().getAllocationByteCount() >= 131072) {
            this.setBitmap(this.getBitmap().createAshmemBitmap());
        }
    }

    private final void $$robo$$android_graphics_drawable_Icon$writeToStream(OutputStream stream) throws IOException {
        DataOutputStream dataStream = new DataOutputStream(stream);
        dataStream.writeInt(1);
        dataStream.writeByte(this.mType);
        switch (this.mType) {
            case 1: 
            case 5: {
                this.getBitmap().compress(Bitmap.CompressFormat.PNG, 100, dataStream);
                break;
            }
            case 3: {
                dataStream.writeInt(this.getDataLength());
                dataStream.write(this.getDataBytes(), this.getDataOffset(), this.getDataLength());
                break;
            }
            case 2: {
                dataStream.writeUTF(this.getResPackage());
                dataStream.writeInt(this.getResId());
                break;
            }
            case 4: {
                dataStream.writeUTF(this.getUriString());
            }
        }
    }

    private void $$robo$$android_graphics_drawable_Icon$__constructor__(int mType) {
        this.mTintMode = DEFAULT_TINT_MODE;
        this.mType = mType;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createFromStream(InputStream stream) throws IOException {
        DataInputStream inputStream = new DataInputStream(stream);
        int version = inputStream.readInt();
        if (version >= 1) {
            byte type = inputStream.readByte();
            switch (type) {
                case 1: {
                    return Icon.createWithBitmap(BitmapFactory.decodeStream(inputStream));
                }
                case 5: {
                    return Icon.createWithAdaptiveBitmap(BitmapFactory.decodeStream(inputStream));
                }
                case 3: {
                    int length = inputStream.readInt();
                    byte[] data = new byte[length];
                    inputStream.read(data, 0, length);
                    return Icon.createWithData(data, 0, length);
                }
                case 2: {
                    String packageName = inputStream.readUTF();
                    int resId = inputStream.readInt();
                    return Icon.createWithResource(packageName, resId);
                }
                case 4: {
                    String uriOrPath = inputStream.readUTF();
                    return Icon.createWithContentUri(uriOrPath);
                }
            }
        }
        return null;
    }

    private final boolean $$robo$$android_graphics_drawable_Icon$sameAs(Icon otherIcon) {
        if (otherIcon == this) {
            return true;
        }
        if (this.mType != otherIcon.getType()) {
            return false;
        }
        switch (this.mType) {
            case 1: 
            case 5: {
                return this.getBitmap() == otherIcon.getBitmap();
            }
            case 3: {
                return this.getDataLength() == otherIcon.getDataLength() && this.getDataOffset() == otherIcon.getDataOffset() && this.getDataBytes() == otherIcon.getDataBytes();
            }
            case 2: {
                return this.getResId() == otherIcon.getResId() && Objects.equals(this.getResPackage(), otherIcon.getResPackage());
            }
            case 4: {
                return Objects.equals(this.getUriString(), otherIcon.getUriString());
            }
        }
        return false;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithResource(Context context, int resId) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        Icon rep = new Icon(2);
        rep.mInt1 = resId;
        rep.mString1 = context.getPackageName();
        return rep;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithResource(Resources res, int resId) {
        if (res == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        Icon rep = new Icon(2);
        rep.mInt1 = resId;
        rep.mString1 = res.getResourcePackageName(resId);
        return rep;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithResource(String resPackage, int resId) {
        if (resPackage == null) {
            throw new IllegalArgumentException("Resource package name must not be null.");
        }
        Icon rep = new Icon(2);
        rep.mInt1 = resId;
        rep.mString1 = resPackage;
        return rep;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        Icon rep = new Icon(1);
        rep.setBitmap(bits);
        return rep;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithAdaptiveBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        Icon rep = new Icon(5);
        rep.setBitmap(bits);
        return rep;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithData(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        Icon rep = new Icon(3);
        rep.mObj1 = data;
        rep.mInt1 = length;
        rep.mInt2 = offset;
        return rep;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithContentUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        Icon rep = new Icon(4);
        rep.mString1 = uri;
        return rep;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithContentUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        Icon rep = new Icon(4);
        rep.mString1 = uri.toString();
        return rep;
    }

    private final Icon $$robo$$android_graphics_drawable_Icon$setTint(int tint) {
        return this.setTintList(ColorStateList.valueOf(tint));
    }

    private final Icon $$robo$$android_graphics_drawable_Icon$setTintList(ColorStateList tintList) {
        this.mTintList = tintList;
        return this;
    }

    private final Icon $$robo$$android_graphics_drawable_Icon$setTintMode(PorterDuff.Mode mode) {
        this.mTintMode = mode;
        return this;
    }

    private final boolean $$robo$$android_graphics_drawable_Icon$hasTint() {
        return this.mTintList != null || this.mTintMode != DEFAULT_TINT_MODE;
    }

    private static final Icon $$robo$$android_graphics_drawable_Icon$createWithFilePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        Icon rep = new Icon(4);
        rep.mString1 = path;
        return rep;
    }

    private final String $$robo$$android_graphics_drawable_Icon$toString() {
        StringBuilder sb = new StringBuilder("Icon(typ=").append(Icon.typeToString(this.mType));
        switch (this.mType) {
            case 1: 
            case 5: {
                sb.append(" size=").append(this.getBitmap().getWidth()).append("x").append(this.getBitmap().getHeight());
                break;
            }
            case 2: {
                sb.append(" pkg=").append(this.getResPackage()).append(" id=").append(String.format("0x%08x", this.getResId()));
                break;
            }
            case 3: {
                sb.append(" len=").append(this.getDataLength());
                if (this.getDataOffset() == 0) break;
                sb.append(" off=").append(this.getDataOffset());
                break;
            }
            case 4: {
                sb.append(" uri=").append(this.getUriString());
            }
        }
        if (this.mTintList != null) {
            sb.append(" tint=");
            String sep = "";
            for (int c : this.mTintList.getColors()) {
                sb.append(String.format("%s0x%08x", sep, c));
                sep = "|";
            }
        }
        if (this.mTintMode != DEFAULT_TINT_MODE) {
            sb.append(" mode=").append((Object)this.mTintMode);
        }
        sb.append(")");
        return sb.toString();
    }

    private final int $$robo$$android_graphics_drawable_Icon$describeContents() {
        return this.mType == 1 || this.mType == 5 || this.mType == 3 ? 1 : 0;
    }

    private void $$robo$$android_graphics_drawable_Icon$__constructor__(Parcel in) {
        switch (this.mType) {
            case 1: 
            case 5: {
                Bitmap bits = Bitmap.CREATOR.createFromParcel(in);
                this.mObj1 = bits;
                break;
            }
            case 2: {
                String pkg = in.readString();
                int resId = in.readInt();
                this.mString1 = pkg;
                this.mInt1 = resId;
                break;
            }
            case 3: {
                int len = in.readInt();
                byte[] a = in.readBlob();
                if (len != a.length) {
                    throw new RuntimeException("internal unparceling error: blob length (" + a.length + ") != expected length (" + len + ")");
                }
                this.mInt1 = len;
                this.mObj1 = a;
                break;
            }
            case 4: {
                String uri;
                this.mString1 = uri = in.readString();
                break;
            }
            default: {
                throw new RuntimeException("invalid " + this.getClass().getSimpleName() + " type in parcel: " + this.mType);
            }
        }
        if (in.readInt() == 1) {
            this.mTintList = ColorStateList.CREATOR.createFromParcel(in);
        }
        this.mTintMode = PorterDuff.intToMode(in.readInt());
    }

    private final void $$robo$$android_graphics_drawable_Icon$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        switch (this.mType) {
            case 1: 
            case 5: {
                Bitmap bits = this.getBitmap();
                this.getBitmap().writeToParcel(dest, flags);
                break;
            }
            case 2: {
                dest.writeString(this.getResPackage());
                dest.writeInt(this.getResId());
                break;
            }
            case 3: {
                dest.writeInt(this.getDataLength());
                dest.writeBlob(this.getDataBytes(), this.getDataOffset(), this.getDataLength());
                break;
            }
            case 4: {
                dest.writeString(this.getUriString());
            }
        }
        if (this.mTintList == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mTintList.writeToParcel(dest, flags);
        }
        dest.writeInt(PorterDuff.modeToInt(this.mTintMode));
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_Icon$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        DEFAULT_TINT_MODE = Drawable.DEFAULT_TINT_MODE;
        CREATOR = new Parcelable.Creator<Icon>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_Icon_1$__constructor__() {
            }

            private final Icon $$robo$$android_graphics_drawable_Icon_1$createFromParcel(Parcel in) {
                return new Icon(in);
            }

            private final Icon[] $$robo$$android_graphics_drawable_Icon_1$newArray(int size) {
                return new Icon[size];
            }

            private void __constructor__() {
                this.$$robo$$android_graphics_drawable_Icon_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Icon_1$__constructor__(), 0, this);
            }

            @Override
            public Icon createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_graphics_drawable_Icon_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Icon[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_graphics_drawable_Icon_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_graphics_drawable_Icon$getType(), 0, this);
    }

    public Bitmap getBitmap() {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_graphics_drawable_Icon$getBitmap(), 0, this);
    }

    private void setBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_graphics_drawable_Icon$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public int getDataLength() {
        return (int)InvokeDynamicSupport.bootstrap("getDataLength", $$robo$$android_graphics_drawable_Icon$getDataLength(), 0, this);
    }

    public int getDataOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getDataOffset", $$robo$$android_graphics_drawable_Icon$getDataOffset(), 0, this);
    }

    public byte[] getDataBytes() {
        return InvokeDynamicSupport.bootstrap("getDataBytes", $$robo$$android_graphics_drawable_Icon$getDataBytes(), 0, this);
    }

    public Resources getResources() {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_graphics_drawable_Icon$getResources(), 0, this);
    }

    public String getResPackage() {
        return InvokeDynamicSupport.bootstrap("getResPackage", $$robo$$android_graphics_drawable_Icon$getResPackage(), 0, this);
    }

    public int getResId() {
        return (int)InvokeDynamicSupport.bootstrap("getResId", $$robo$$android_graphics_drawable_Icon$getResId(), 0, this);
    }

    public String getUriString() {
        return InvokeDynamicSupport.bootstrap("getUriString", $$robo$$android_graphics_drawable_Icon$getUriString(), 0, this);
    }

    public Uri getUri() {
        return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_graphics_drawable_Icon$getUri(), 0, this);
    }

    private static String typeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("typeToString", $$robo$$android_graphics_drawable_Icon$typeToString(int ), 0, (int)n);
    }

    public void loadDrawableAsync(Context context, Message message) {
        InvokeDynamicSupport.bootstrap("loadDrawableAsync", $$robo$$android_graphics_drawable_Icon$loadDrawableAsync(android.content.Context android.os.Message ), 0, this, context, message);
    }

    public void loadDrawableAsync(Context context, OnDrawableLoadedListener onDrawableLoadedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("loadDrawableAsync", $$robo$$android_graphics_drawable_Icon$loadDrawableAsync(android.content.Context android.graphics.drawable.Icon$OnDrawableLoadedListener android.os.Handler ), 0, this, context, onDrawableLoadedListener, handler);
    }

    public Drawable loadDrawable(Context context) {
        return InvokeDynamicSupport.bootstrap("loadDrawable", $$robo$$android_graphics_drawable_Icon$loadDrawable(android.content.Context ), 0, this, context);
    }

    private Drawable loadDrawableInner(Context context) {
        return InvokeDynamicSupport.bootstrap("loadDrawableInner", $$robo$$android_graphics_drawable_Icon$loadDrawableInner(android.content.Context ), 0, this, context);
    }

    public Drawable loadDrawableAsUser(Context context, int n) {
        return InvokeDynamicSupport.bootstrap("loadDrawableAsUser", $$robo$$android_graphics_drawable_Icon$loadDrawableAsUser(android.content.Context int ), 0, this, context, n);
    }

    public void convertToAshmem() {
        InvokeDynamicSupport.bootstrap("convertToAshmem", $$robo$$android_graphics_drawable_Icon$convertToAshmem(), 0, this);
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeToStream", $$robo$$android_graphics_drawable_Icon$writeToStream(java.io.OutputStream ), 0, this, outputStream);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_graphics_drawable_Icon$__constructor__(n);
    }

    private Icon(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Icon$__constructor__(int ), 0, this, n);
    }

    public static Icon createFromStream(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromStream", $$robo$$android_graphics_drawable_Icon$createFromStream(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public boolean sameAs(Icon icon) {
        return (boolean)InvokeDynamicSupport.bootstrap("sameAs", $$robo$$android_graphics_drawable_Icon$sameAs(android.graphics.drawable.Icon ), 0, this, icon);
    }

    public static Icon createWithResource(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createWithResource", $$robo$$android_graphics_drawable_Icon$createWithResource(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static Icon createWithResource(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createWithResource", $$robo$$android_graphics_drawable_Icon$createWithResource(android.content.res.Resources int ), 0, (Resources)resources, (int)n);
    }

    public static Icon createWithResource(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createWithResource", $$robo$$android_graphics_drawable_Icon$createWithResource(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static Icon createWithBitmap(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("createWithBitmap", $$robo$$android_graphics_drawable_Icon$createWithBitmap(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    public static Icon createWithAdaptiveBitmap(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("createWithAdaptiveBitmap", $$robo$$android_graphics_drawable_Icon$createWithAdaptiveBitmap(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    public static Icon createWithData(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createWithData", $$robo$$android_graphics_drawable_Icon$createWithData(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    public static Icon createWithContentUri(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createWithContentUri", $$robo$$android_graphics_drawable_Icon$createWithContentUri(java.lang.String ), 0, (String)string2);
    }

    public static Icon createWithContentUri(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("createWithContentUri", $$robo$$android_graphics_drawable_Icon$createWithContentUri(android.net.Uri ), 0, (Uri)uri);
    }

    public Icon setTint(int n) {
        return InvokeDynamicSupport.bootstrap("setTint", $$robo$$android_graphics_drawable_Icon$setTint(int ), 0, this, n);
    }

    public Icon setTintList(ColorStateList colorStateList) {
        return InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_Icon$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public Icon setTintMode(PorterDuff.Mode mode) {
        return InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_Icon$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public boolean hasTint() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTint", $$robo$$android_graphics_drawable_Icon$hasTint(), 0, this);
    }

    public static Icon createWithFilePath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createWithFilePath", $$robo$$android_graphics_drawable_Icon$createWithFilePath(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_graphics_drawable_Icon$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_graphics_drawable_Icon$describeContents(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_graphics_drawable_Icon$__constructor__(parcel);
    }

    private Icon(Parcel parcel) {
        this(parcel.readInt());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Icon$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_graphics_drawable_Icon$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_graphics_drawable_Icon$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(Icon.class);
    }

    public /* synthetic */ Icon() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Icon)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class LoadDrawableTask
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Context mContext;
        Message mMessage;
        /* synthetic */ Icon this$0;

        private void $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$__constructor__(Icon icon, Context context, Handler handler, OnDrawableLoadedListener listener) {
            this.mContext = context;
            this.mMessage = Message.obtain(handler, new Runnable(this, icon, listener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Icon val$this$0;
                /* synthetic */ OnDrawableLoadedListener val$listener;
                /* synthetic */ LoadDrawableTask this$1;

                private void $$robo$$android_graphics_drawable_Icon_LoadDrawableTask_1$__constructor__(LoadDrawableTask this$1, Icon icon, OnDrawableLoadedListener onDrawableLoadedListener) {
                }

                private final void $$robo$$android_graphics_drawable_Icon_LoadDrawableTask_1$run() {
                    this.val$listener.onDrawableLoaded((Drawable)this.this$1.mMessage.obj);
                }

                private void __constructor__(LoadDrawableTask loadDrawableTask, Icon icon, OnDrawableLoadedListener onDrawableLoadedListener) {
                    this.$$robo$$android_graphics_drawable_Icon_LoadDrawableTask_1$__constructor__(loadDrawableTask, icon, onDrawableLoadedListener);
                }
                {
                    this.this$1 = loadDrawableTask;
                    this.val$this$0 = icon;
                    this.val$listener = onDrawableLoadedListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Icon_LoadDrawableTask_1$__constructor__(android.graphics.drawable.Icon$LoadDrawableTask android.graphics.drawable.Icon android.graphics.drawable.Icon$OnDrawableLoadedListener ), 0, this, loadDrawableTask, icon, onDrawableLoadedListener);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_graphics_drawable_Icon_LoadDrawableTask_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$__constructor__(Icon icon, Context context, Message message) {
            this.mContext = context;
            this.mMessage = message;
        }

        private final void $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$run() {
            this.mMessage.obj = this.this$0.loadDrawable(this.mContext);
            this.mMessage.sendToTarget();
        }

        private final void $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$runAsync() {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(this);
        }

        private void __constructor__(Icon icon, Context context, Handler handler, OnDrawableLoadedListener onDrawableLoadedListener) {
            this.$$robo$$android_graphics_drawable_Icon_LoadDrawableTask$__constructor__(icon, context, handler, onDrawableLoadedListener);
        }

        public LoadDrawableTask(Icon icon, Context context, Handler handler, OnDrawableLoadedListener onDrawableLoadedListener) {
            this.this$0 = icon;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$__constructor__(android.graphics.drawable.Icon android.content.Context android.os.Handler android.graphics.drawable.Icon$OnDrawableLoadedListener ), 0, this, icon, context, handler, onDrawableLoadedListener);
        }

        private void __constructor__(Icon icon, Context context, Message message) {
            this.$$robo$$android_graphics_drawable_Icon_LoadDrawableTask$__constructor__(icon, context, message);
        }

        public LoadDrawableTask(Icon icon, Context context, Message message) {
            this.this$0 = icon;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$__constructor__(android.graphics.drawable.Icon android.content.Context android.os.Message ), 0, this, icon, context, message);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$run(), 0, this);
        }

        public void runAsync() {
            InvokeDynamicSupport.bootstrap("runAsync", $$robo$$android_graphics_drawable_Icon_LoadDrawableTask$runAsync(), 0, this);
        }

        public /* synthetic */ LoadDrawableTask() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadDrawableTask)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnDrawableLoadedListener
    extends InstrumentedInterface {
        public void onDrawableLoaded(Drawable var1);
    }
}

