/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.ActivityThread;
import android.app.Application;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.Log;
import android.util.LongArray;
import android.util.PathParser;
import android.util.Property;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.RenderNodeAnimatorSetHelper;
import com.android.internal.R;
import com.android.internal.util.VirtualRefBasePtr;
import dalvik.annotation.optimization.FastNative;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedVectorDrawable
extends Drawable
implements Animatable2,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "AnimatedVectorDrawable";
    private static String ANIMATED_VECTOR = "animated-vector";
    private static String TARGET = "target";
    private static boolean DBG_ANIMATION_VECTOR_DRAWABLE = false;
    private VectorDrawableAnimator mAnimatorSet;
    private Resources mRes;
    private AnimatedVectorDrawableState mAnimatedVectorState;
    private AnimatorSet mAnimatorSetFromXml;
    private boolean mMutated;
    private ArrayList<Animatable2.AnimationCallback> mAnimationCallbacks;
    private Animator.AnimatorListener mAnimatorListener;
    private Drawable.Callback mCallback;

    private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(AnimatedVectorDrawableState state, Resources res) {
        this.mAnimatorSetFromXml = null;
        this.mAnimationCallbacks = null;
        this.mAnimatorListener = null;
        this.mCallback = new Drawable.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AnimatedVectorDrawable this$0;

            private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$__constructor__(AnimatedVectorDrawable this$0) {
            }

            private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$invalidateDrawable(Drawable who) {
                this.this$0.invalidateSelf();
            }

            private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$scheduleDrawable(Drawable who, Runnable what, long when) {
                this.this$0.scheduleSelf(what, when);
            }

            private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$unscheduleDrawable(Drawable who, Runnable what) {
                this.this$0.unscheduleSelf(what);
            }

            private void __constructor__(AnimatedVectorDrawable animatedVectorDrawable) {
                this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$__constructor__(animatedVectorDrawable);
            }
            {
                this.this$0 = animatedVectorDrawable;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$__constructor__(android.graphics.drawable.AnimatedVectorDrawable ), 0, this, animatedVectorDrawable);
            }

            @Override
            public void invalidateDrawable(Drawable drawable2) {
                InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
            }

            @Override
            public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
                InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
            }

            @Override
            public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
                InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_1$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(state, this.mCallback, res);
        this.mAnimatorSet = new VectorDrawableAnimatorRT(this);
        this.mRes = res;
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimatedVectorDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimatedVectorState = new AnimatedVectorDrawableState(this.mAnimatedVectorState, this.mCallback, this.mRes);
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$clearMutated() {
        super.clearMutated();
        if (this.mAnimatedVectorState.mVectorDrawable != null) {
            this.mAnimatedVectorState.mVectorDrawable.clearMutated();
        }
        this.mMutated = false;
    }

    private static final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$shouldIgnoreInvalidAnimation() {
        Application app = ActivityThread.currentApplication();
        if (app == null || app.getApplicationInfo() == null) {
            return true;
        }
        return app.getApplicationInfo().targetSdkVersion < 24;
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getConstantState() {
        this.mAnimatedVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mAnimatedVectorState;
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mAnimatedVectorState.getChangingConfigurations();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$draw(Canvas canvas) {
        if (!canvas.isHardwareAccelerated() && this.mAnimatorSet instanceof VectorDrawableAnimatorRT && !this.mAnimatorSet.isRunning() && ((VectorDrawableAnimatorRT)this.mAnimatorSet).mPendingAnimationActions.size() > 0) {
            this.fallbackOntoUI();
        }
        this.mAnimatorSet.onDraw(canvas);
        this.mAnimatedVectorState.mVectorDrawable.draw(canvas);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onBoundsChange(Rect bounds) {
        this.mAnimatedVectorState.mVectorDrawable.setBounds(bounds);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onStateChange(int[] state) {
        return this.mAnimatedVectorState.mVectorDrawable.setState(state);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onLevelChange(int level) {
        return this.mAnimatedVectorState.mVectorDrawable.setLevel(level);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onLayoutDirectionChanged(int layoutDirection) {
        return this.mAnimatedVectorState.mVectorDrawable.setLayoutDirection(layoutDirection);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getAlpha() {
        return this.mAnimatedVectorState.mVectorDrawable.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setAlpha(int alpha) {
        this.mAnimatedVectorState.mVectorDrawable.setAlpha(alpha);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mAnimatedVectorState.mVectorDrawable.setColorFilter(colorFilter);
    }

    private final ColorFilter $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getColorFilter() {
        return this.mAnimatedVectorState.mVectorDrawable.getColorFilter();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintList(ColorStateList tint) {
        this.mAnimatedVectorState.mVectorDrawable.setTintList(tint);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspot(float x, float y) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspot(x, y);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspotBounds(left, top, right, bottom);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mAnimatedVectorState.mVectorDrawable.setTintMode(tintMode);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setVisible(boolean visible, boolean restart) {
        if (this.mAnimatorSet.isInfinite() && this.mAnimatorSet.isStarted()) {
            if (visible) {
                this.mAnimatorSet.resume();
            } else {
                this.mAnimatorSet.pause();
            }
        }
        this.mAnimatedVectorState.mVectorDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isStateful() {
        return this.mAnimatedVectorState.mVectorDrawable.isStateful();
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOpacity() {
        return -3;
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicWidth() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicWidth();
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicHeight() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicHeight();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOutline(Outline outline) {
        this.mAnimatedVectorState.mVectorDrawable.getOutline(outline);
    }

    private final Insets $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOpticalInsets() {
        return this.mAnimatedVectorState.mVectorDrawable.getOpticalInsets();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$inflate(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        AnimatedVectorDrawableState state = this.mAnimatedVectorState;
        int eventType = parser.getEventType();
        float pathErrorScale = 1.0f;
        int innerDepth = parser.getDepth() + 1;
        while (eventType != 1 && (parser.getDepth() >= innerDepth || eventType != 3)) {
            if (eventType == 2) {
                TypedArray a;
                String tagName = parser.getName();
                if ("animated-vector".equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.AnimatedVectorDrawable);
                    int drawableRes = a.getResourceId(0, 0);
                    if (drawableRes != 0) {
                        VectorDrawable vectorDrawable = (VectorDrawable)res.getDrawable(drawableRes, theme).mutate();
                        vectorDrawable.setAllowCaching(false);
                        vectorDrawable.setCallback(this.mCallback);
                        pathErrorScale = vectorDrawable.getPixelSize();
                        if (state.mVectorDrawable != null) {
                            state.mVectorDrawable.setCallback(null);
                        }
                        state.mVectorDrawable = vectorDrawable;
                    }
                    a.recycle();
                } else if ("target".equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.AnimatedVectorDrawableTarget);
                    String target = a.getString(0);
                    int animResId = a.getResourceId(1, 0);
                    if (animResId != 0) {
                        if (theme != null) {
                            Animator animator2 = AnimatorInflater.loadAnimator(res, theme, animResId, pathErrorScale);
                            AnimatedVectorDrawable.updateAnimatorProperty(animator2, target, state.mVectorDrawable, state.mShouldIgnoreInvalidAnim);
                            state.addTargetAnimator(target, animator2);
                        } else {
                            state.addPendingAnimator(animResId, pathErrorScale, target);
                        }
                    }
                    a.recycle();
                }
            }
            eventType = parser.next();
        }
        this.mRes = state.mPendingAnims == null ? null : res;
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$updateAnimatorProperty(Animator animator2, String targetName, VectorDrawable vectorDrawable, boolean ignoreInvalidAnim) {
        block7: {
            block6: {
                if (!(animator2 instanceof ObjectAnimator)) break block6;
                PropertyValuesHolder[] holders = ((ObjectAnimator)animator2).getValues();
                for (int i = 0; i < holders.length; ++i) {
                    PropertyValuesHolder pvh = holders[i];
                    String propertyName = pvh.getPropertyName();
                    Object targetNameObj = vectorDrawable.getTargetByName(targetName);
                    Property property = null;
                    if (targetNameObj instanceof VectorDrawable.VObject) {
                        property = ((VectorDrawable.VObject)targetNameObj).getProperty(propertyName);
                    } else if (targetNameObj instanceof VectorDrawable.VectorDrawableState) {
                        property = ((VectorDrawable.VectorDrawableState)targetNameObj).getProperty(propertyName);
                    }
                    if (property == null) continue;
                    if (AnimatedVectorDrawable.containsSameValueType(pvh, property)) {
                        pvh.setProperty(property);
                        continue;
                    }
                    if (ignoreInvalidAnim) continue;
                    throw new RuntimeException("Wrong valueType for Property: " + propertyName + ".  Expected type: " + property.getType().toString() + ". Actual type defined in resources: " + pvh.getValueType().toString());
                }
                break block7;
            }
            if (!(animator2 instanceof AnimatorSet)) break block7;
            for (Animator anim2 : ((AnimatorSet)animator2).getChildAnimations()) {
                AnimatedVectorDrawable.updateAnimatorProperty(anim2, targetName, vectorDrawable, ignoreInvalidAnim);
            }
        }
    }

    private static final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$containsSameValueType(PropertyValuesHolder holder, Property property) {
        Class type1 = holder.getValueType();
        Class type2 = property.getType();
        if (type1 == Float.TYPE || type1 == Float.class) {
            return type2 == Float.TYPE || type2 == Float.class;
        }
        if (type1 == Integer.TYPE || type1 == Integer.class) {
            return type2 == Integer.TYPE || type2 == Integer.class;
        }
        return type1 == type2;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$forceAnimationOnUI() {
        if (this.mAnimatorSet instanceof VectorDrawableAnimatorRT) {
            VectorDrawableAnimatorRT animator2 = (VectorDrawableAnimatorRT)this.mAnimatorSet;
            if (animator2.isRunning()) {
                throw new UnsupportedOperationException("Cannot force Animated Vector Drawable to run on UI thread when the animation has started on RenderThread.");
            }
            this.fallbackOntoUI();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$fallbackOntoUI() {
        if (this.mAnimatorSet instanceof VectorDrawableAnimatorRT) {
            VectorDrawableAnimatorRT oldAnim = (VectorDrawableAnimatorRT)this.mAnimatorSet;
            this.mAnimatorSet = new VectorDrawableAnimatorUI(this);
            if (this.mAnimatorSetFromXml != null) {
                this.mAnimatorSet.init(this.mAnimatorSetFromXml);
            }
            if (oldAnim.mListener != null) {
                this.mAnimatorSet.setListener(oldAnim.mListener);
            }
            oldAnim.transferPendingActions(this.mAnimatorSet);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canApplyTheme() {
        return this.mAnimatedVectorState != null && this.mAnimatedVectorState.canApplyTheme() || super.canApplyTheme();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        VectorDrawable vectorDrawable = this.mAnimatedVectorState.mVectorDrawable;
        if (vectorDrawable != null && vectorDrawable.canApplyTheme()) {
            vectorDrawable.applyTheme(t);
        }
        if (t != null) {
            this.mAnimatedVectorState.inflatePendingAnimators(t.getResources(), t);
        }
        if (this.mAnimatedVectorState.mPendingAnims == null) {
            this.mRes = null;
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isRunning() {
        return this.mAnimatorSet.isRunning();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$reset() {
        this.ensureAnimatorSet();
        this.mAnimatorSet.reset();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$start() {
        this.ensureAnimatorSet();
        this.mAnimatorSet.start();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$ensureAnimatorSet() {
        if (this.mAnimatorSetFromXml == null) {
            this.mAnimatorSetFromXml = new AnimatorSet();
            this.mAnimatedVectorState.prepareLocalAnimators(this.mAnimatorSetFromXml, this.mRes);
            this.mAnimatorSet.init(this.mAnimatorSetFromXml);
            this.mRes = null;
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$stop() {
        this.mAnimatorSet.end();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$reverse() {
        this.ensureAnimatorSet();
        if (!this.canReverse()) {
            Log.w("AnimatedVectorDrawable", "AnimatedVectorDrawable can't reverse()");
            return;
        }
        this.mAnimatorSet.reverse();
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canReverse() {
        return this.mAnimatorSet.canReverse();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$registerAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null) {
            return;
        }
        if (this.mAnimationCallbacks == null) {
            this.mAnimationCallbacks = new ArrayList();
        }
        this.mAnimationCallbacks.add(callback);
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AnimatedVectorDrawable this$0;

                private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_2$__constructor__(AnimatedVectorDrawable this$0) {
                }

                private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_2$onAnimationStart(Animator animation) {
                    ArrayList tmpCallbacks = new ArrayList(this.this$0.mAnimationCallbacks);
                    int size = tmpCallbacks.size();
                    for (int i = 0; i < size; ++i) {
                        ((Animatable2.AnimationCallback)tmpCallbacks.get(i)).onAnimationStart(this.this$0);
                    }
                }

                private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_2$onAnimationEnd(Animator animation) {
                    ArrayList tmpCallbacks = new ArrayList(this.this$0.mAnimationCallbacks);
                    int size = tmpCallbacks.size();
                    for (int i = 0; i < size; ++i) {
                        ((Animatable2.AnimationCallback)tmpCallbacks.get(i)).onAnimationEnd(this.this$0);
                    }
                }

                private void __constructor__(AnimatedVectorDrawable animatedVectorDrawable) {
                    this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable_2$__constructor__(animatedVectorDrawable);
                }
                {
                    this.this$0 = animatedVectorDrawable;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_2$__constructor__(android.graphics.drawable.AnimatedVectorDrawable ), 0, this, animatedVectorDrawable);
                }

                @Override
                public void onAnimationStart(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_2$onAnimationStart(android.animation.Animator ), 0, this, animator2);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        this.mAnimatorSet.setListener(this.mAnimatorListener);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$removeAnimatorSetListener() {
        if (this.mAnimatorListener != null) {
            this.mAnimatorSet.removeListener(this.mAnimatorListener);
            this.mAnimatorListener = null;
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$unregisterAnimationCallback(Animatable2.AnimationCallback callback) {
        if (this.mAnimationCallbacks == null || callback == null) {
            return false;
        }
        boolean removed = this.mAnimationCallbacks.remove(callback);
        if (this.mAnimationCallbacks.size() == 0) {
            this.removeAnimatorSetListener();
        }
        return removed;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$clearAnimationCallbacks() {
        this.removeAnimatorSetListener();
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.mAnimationCallbacks.clear();
    }

    private static final long $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreateAnimatorSet() {
        return 0L;
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nSetVectorDrawableTarget(long l, long l2) {
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nAddAnimator(long l, long l2, long l3, long l4, long l5, int n, int n2) {
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nSetPropertyHolderData(long l, float[] fArray, int n) {
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nSetPropertyHolderData(long l, int[] nArray, int n) {
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nStart(long l, VectorDrawableAnimatorRT vectorDrawableAnimatorRT, int n) {
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nReverse(long l, VectorDrawableAnimatorRT vectorDrawableAnimatorRT, int n) {
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreateGroupPropertyHolder(long l, int n, float f, float f2) {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreatePathDataPropertyHolder(long l, long l2, long l3) {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreatePathColorPropertyHolder(long l, int n, int n2, int n3) {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreatePathPropertyHolder(long l, int n, float f, float f2) {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreateRootAlphaPropertyHolder(long l, float f, float f2) {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nEnd(long l) {
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nReset(long l) {
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(AnimatedVectorDrawableState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__();
    }

    public AnimatedVectorDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(AnimatedVectorDrawableState animatedVectorDrawableState, Resources resources) {
        this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(animatedVectorDrawableState, resources);
    }

    private AnimatedVectorDrawable(AnimatedVectorDrawableState animatedVectorDrawableState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(android.graphics.drawable.AnimatedVectorDrawable$AnimatedVectorDrawableState android.content.res.Resources ), 0, this, animatedVectorDrawableState, resources);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$mutate(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$clearMutated(), 0, this);
    }

    private static boolean shouldIgnoreInvalidAnimation() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldIgnoreInvalidAnimation", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$shouldIgnoreInvalidAnimation(), 0);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getConstantState(), 0, this);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    public boolean onLayoutDirectionChanged(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLayoutDirectionChanged", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onLayoutDirectionChanged(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getColorFilter(), 0, this);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspot(float float ), 0, this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isStateful(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOpacity(), 0, this);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOpticalInsets(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private static void updateAnimatorProperty(Animator animator2, String string2, VectorDrawable vectorDrawable, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("updateAnimatorProperty", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$updateAnimatorProperty(android.animation.Animator java.lang.String android.graphics.drawable.VectorDrawable boolean ), 0, (Animator)animator2, (String)string2, (VectorDrawable)vectorDrawable, (boolean)bl);
    }

    private static boolean containsSameValueType(PropertyValuesHolder propertyValuesHolder, Property property) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsSameValueType", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$containsSameValueType(android.animation.PropertyValuesHolder android.util.Property ), 0, (PropertyValuesHolder)propertyValuesHolder, (Property)property);
    }

    public void forceAnimationOnUI() {
        InvokeDynamicSupport.bootstrap("forceAnimationOnUI", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$forceAnimationOnUI(), 0, this);
    }

    private void fallbackOntoUI() {
        InvokeDynamicSupport.bootstrap("fallbackOntoUI", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$fallbackOntoUI(), 0, this);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isRunning(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$reset(), 0, this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$start(), 0, this);
    }

    private void ensureAnimatorSet() {
        InvokeDynamicSupport.bootstrap("ensureAnimatorSet", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$ensureAnimatorSet(), 0, this);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$stop(), 0, this);
    }

    public void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$reverse(), 0, this);
    }

    public boolean canReverse() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canReverse(), 0, this);
    }

    @Override
    public void registerAnimationCallback(Animatable2.AnimationCallback animationCallback) {
        InvokeDynamicSupport.bootstrap("registerAnimationCallback", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$registerAnimationCallback(android.graphics.drawable.Animatable2$AnimationCallback ), 0, this, animationCallback);
    }

    private void removeAnimatorSetListener() {
        InvokeDynamicSupport.bootstrap("removeAnimatorSetListener", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$removeAnimatorSetListener(), 0, this);
    }

    @Override
    public boolean unregisterAnimationCallback(Animatable2.AnimationCallback animationCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterAnimationCallback", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$unregisterAnimationCallback(android.graphics.drawable.Animatable2$AnimationCallback ), 0, this, animationCallback);
    }

    @Override
    public void clearAnimationCallbacks() {
        InvokeDynamicSupport.bootstrap("clearAnimationCallbacks", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$clearAnimationCallbacks(), 0, this);
    }

    private static final native /* synthetic */ long $$robo$$nCreateAnimatorSet$nativeBinding();

    private static long nCreateAnimatorSet() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateAnimatorSet", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreateAnimatorSet(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nSetVectorDrawableTarget$nativeBinding(long var0, long var2);

    private static void nSetVectorDrawableTarget(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetVectorDrawableTarget", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nSetVectorDrawableTarget(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nAddAnimator$nativeBinding(long var0, long var2, long var4, long var6, long var8, int var10, int var11);

    private static void nAddAnimator(long l, long l2, long l3, long l4, long l5, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nAddAnimator", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nAddAnimator(long long long long long int int ), 1, (long)l, (long)l2, (long)l3, (long)l4, (long)l5, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$nSetPropertyHolderData$nativeBinding(long var0, float[] var2, int var3);

    private static void nSetPropertyHolderData(long l, float[] fArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetPropertyHolderData", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nSetPropertyHolderData(long float[] int ), 1, (long)l, (float[])fArray, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetPropertyHolderData$nativeBinding(long var0, int[] var2, int var3);

    private static void nSetPropertyHolderData(long l, int[] nArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetPropertyHolderData", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nSetPropertyHolderData(long int[] int ), 1, (long)l, (int[])nArray, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nStart$nativeBinding(long var0, VectorDrawableAnimatorRT var2, int var3);

    private static void nStart(long l, VectorDrawableAnimatorRT vectorDrawableAnimatorRT, int n) {
        InvokeDynamicSupport.bootstrapStatic("nStart", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nStart(long android.graphics.drawable.AnimatedVectorDrawable$VectorDrawableAnimatorRT int ), 1, (long)l, (VectorDrawableAnimatorRT)vectorDrawableAnimatorRT, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nReverse$nativeBinding(long var0, VectorDrawableAnimatorRT var2, int var3);

    private static void nReverse(long l, VectorDrawableAnimatorRT vectorDrawableAnimatorRT, int n) {
        InvokeDynamicSupport.bootstrapStatic("nReverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nReverse(long android.graphics.drawable.AnimatedVectorDrawable$VectorDrawableAnimatorRT int ), 1, (long)l, (VectorDrawableAnimatorRT)vectorDrawableAnimatorRT, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nCreateGroupPropertyHolder$nativeBinding(long var0, int var2, float var3, float var4);

    private static long nCreateGroupPropertyHolder(long l, int n, float f, float f2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateGroupPropertyHolder", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreateGroupPropertyHolder(long int float float ), 1, (long)l, (int)n, (float)f, (float)f2);
    }

    private static final native /* synthetic */ long $$robo$$nCreatePathDataPropertyHolder$nativeBinding(long var0, long var2, long var4);

    private static long nCreatePathDataPropertyHolder(long l, long l2, long l3) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreatePathDataPropertyHolder", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreatePathDataPropertyHolder(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ long $$robo$$nCreatePathColorPropertyHolder$nativeBinding(long var0, int var2, int var3, int var4);

    private static long nCreatePathColorPropertyHolder(long l, int n, int n2, int n3) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreatePathColorPropertyHolder", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreatePathColorPropertyHolder(long int int int ), 1, (long)l, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ long $$robo$$nCreatePathPropertyHolder$nativeBinding(long var0, int var2, float var3, float var4);

    private static long nCreatePathPropertyHolder(long l, int n, float f, float f2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreatePathPropertyHolder", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreatePathPropertyHolder(long int float float ), 1, (long)l, (int)n, (float)f, (float)f2);
    }

    private static final native /* synthetic */ long $$robo$$nCreateRootAlphaPropertyHolder$nativeBinding(long var0, float var2, float var3);

    private static long nCreateRootAlphaPropertyHolder(long l, float f, float f2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateRootAlphaPropertyHolder", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nCreateRootAlphaPropertyHolder(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$nEnd$nativeBinding(long var0);

    private static void nEnd(long l) {
        InvokeDynamicSupport.bootstrapStatic("nEnd", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nEnd(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nReset$nativeBinding(long var0);

    private static void nReset(long l) {
        InvokeDynamicSupport.bootstrapStatic("nReset", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$nReset(long ), 1, (long)l);
    }

    private /* synthetic */ void __constructor__(AnimatedVectorDrawableState animatedVectorDrawableState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(animatedVectorDrawableState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedVectorDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class VectorDrawableAnimatorRT
    implements VectorDrawableAnimator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int START_ANIMATION = 1;
        private static int REVERSE_ANIMATION = 2;
        private static int RESET_ANIMATION = 3;
        private static int END_ANIMATION = 4;
        private static int MAX_SAMPLE_POINTS = 300;
        private Animator.AnimatorListener mListener;
        private LongArray mStartDelays;
        private PropertyValuesHolder.PropertyValues mTmpValues;
        private long mSetPtr;
        private boolean mContainsSequentialAnimators;
        private boolean mStarted;
        private boolean mInitialized;
        private boolean mIsReversible;
        private boolean mIsInfinite;
        private VirtualRefBasePtr mSetRefBasePtr;
        private WeakReference<RenderNode> mLastSeenTarget;
        private int mLastListenerId;
        private IntArray mPendingAnimationActions;
        private AnimatedVectorDrawable mDrawable;

        private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$__constructor__(AnimatedVectorDrawable drawable2) {
            this.mListener = null;
            this.mStartDelays = new LongArray();
            this.mTmpValues = new PropertyValuesHolder.PropertyValues();
            this.mSetPtr = 0L;
            this.mContainsSequentialAnimators = false;
            this.mStarted = false;
            this.mInitialized = false;
            this.mIsReversible = false;
            this.mIsInfinite = false;
            this.mLastSeenTarget = null;
            this.mLastListenerId = 0;
            this.mPendingAnimationActions = new IntArray();
            this.mDrawable = drawable2;
            this.mSetPtr = AnimatedVectorDrawable.nCreateAnimatorSet();
            this.mSetRefBasePtr = new VirtualRefBasePtr(this.mSetPtr);
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$init(AnimatorSet set) {
            if (this.mInitialized) {
                throw new UnsupportedOperationException("VectorDrawableAnimator cannot be re-initialized");
            }
            this.parseAnimatorSet(set, 0L);
            long vectorDrawableTreePtr = ((AnimatedVectorDrawable)this.mDrawable).mAnimatedVectorState.mVectorDrawable.getNativeTree();
            AnimatedVectorDrawable.nSetVectorDrawableTarget(this.mSetPtr, vectorDrawableTreePtr);
            this.mInitialized = true;
            this.mIsInfinite = set.getTotalDuration() == -1L;
            this.mIsReversible = true;
            if (this.mContainsSequentialAnimators) {
                this.mIsReversible = false;
            } else {
                for (int i = 0; i < this.mStartDelays.size(); ++i) {
                    if (this.mStartDelays.get(i) <= 0L) continue;
                    this.mIsReversible = false;
                    return;
                }
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$parseAnimatorSet(AnimatorSet set, long startTime) {
            ArrayList<Animator> animators = set.getChildAnimations();
            boolean playTogether = set.shouldPlayTogether();
            for (int i = 0; i < animators.size(); ++i) {
                Animator animator2 = animators.get(i);
                if (animator2 instanceof AnimatorSet) {
                    this.parseAnimatorSet((AnimatorSet)animator2, startTime);
                } else if (animator2 instanceof ObjectAnimator) {
                    this.createRTAnimator((ObjectAnimator)animator2, startTime);
                }
                if (playTogether) continue;
                startTime += animator2.getTotalDuration();
                this.mContainsSequentialAnimators = true;
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimator(ObjectAnimator animator2, long startTime) {
            PropertyValuesHolder[] values = animator2.getValues();
            Object target = animator2.getTarget();
            if (target instanceof VectorDrawable.VGroup) {
                this.createRTAnimatorForGroup(values, animator2, (VectorDrawable.VGroup)target, startTime);
            } else if (target instanceof VectorDrawable.VPath) {
                for (int i = 0; i < values.length; ++i) {
                    values[i].getPropertyValues(this.mTmpValues);
                    if (this.mTmpValues.endValue instanceof PathParser.PathData && this.mTmpValues.propertyName.equals("pathData")) {
                        this.createRTAnimatorForPath(animator2, (VectorDrawable.VPath)target, startTime);
                        continue;
                    }
                    if (target instanceof VectorDrawable.VFullPath) {
                        this.createRTAnimatorForFullPath(animator2, (VectorDrawable.VFullPath)target, startTime);
                        continue;
                    }
                    if (this.mDrawable.mAnimatedVectorState.mShouldIgnoreInvalidAnim) continue;
                    throw new IllegalArgumentException("ClipPath only supports PathData property");
                }
            } else if (target instanceof VectorDrawable.VectorDrawableState) {
                this.createRTAnimatorForRootGroup(values, animator2, (VectorDrawable.VectorDrawableState)target, startTime);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForGroup(PropertyValuesHolder[] values, ObjectAnimator animator2, VectorDrawable.VGroup target, long startTime) {
            long nativePtr = target.getNativePtr();
            for (int i = 0; i < values.length; ++i) {
                values[i].getPropertyValues(this.mTmpValues);
                int propertyId = VectorDrawable.VGroup.getPropertyIndex(this.mTmpValues.propertyName);
                if (this.mTmpValues.type != Float.class && this.mTmpValues.type != Float.TYPE || propertyId < 0) continue;
                long propertyPtr = AnimatedVectorDrawable.nCreateGroupPropertyHolder(nativePtr, propertyId, ((Float)this.mTmpValues.startValue).floatValue(), ((Float)this.mTmpValues.endValue).floatValue());
                if (this.mTmpValues.dataSource != null) {
                    float[] dataPoints = VectorDrawableAnimatorRT.createFloatDataPoints(this.mTmpValues.dataSource, animator2.getDuration());
                    AnimatedVectorDrawable.nSetPropertyHolderData(propertyPtr, dataPoints, dataPoints.length);
                }
                this.createNativeChildAnimator(propertyPtr, startTime, animator2);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForPath(ObjectAnimator animator2, VectorDrawable.VPath target, long startTime) {
            long nativePtr = target.getNativePtr();
            long startPathDataPtr = ((PathParser.PathData)this.mTmpValues.startValue).getNativePtr();
            long endPathDataPtr = ((PathParser.PathData)this.mTmpValues.endValue).getNativePtr();
            long propertyPtr = AnimatedVectorDrawable.nCreatePathDataPropertyHolder(nativePtr, startPathDataPtr, endPathDataPtr);
            this.createNativeChildAnimator(propertyPtr, startTime, animator2);
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForFullPath(ObjectAnimator animator2, VectorDrawable.VFullPath target, long startTime) {
            long propertyPtr;
            int propertyId = target.getPropertyIndex(this.mTmpValues.propertyName);
            long nativePtr = target.getNativePtr();
            if (this.mTmpValues.type == Float.class || this.mTmpValues.type == Float.TYPE) {
                if (propertyId < 0) {
                    if (this.mDrawable.mAnimatedVectorState.mShouldIgnoreInvalidAnim) {
                        return;
                    }
                    throw new IllegalArgumentException("Property: " + this.mTmpValues.propertyName + " is not supported for FullPath");
                }
                propertyPtr = AnimatedVectorDrawable.nCreatePathPropertyHolder(nativePtr, propertyId, ((Float)this.mTmpValues.startValue).floatValue(), ((Float)this.mTmpValues.endValue).floatValue());
                if (this.mTmpValues.dataSource != null) {
                    float[] dataPoints = VectorDrawableAnimatorRT.createFloatDataPoints(this.mTmpValues.dataSource, animator2.getDuration());
                    AnimatedVectorDrawable.nSetPropertyHolderData(propertyPtr, dataPoints, dataPoints.length);
                }
            } else if (this.mTmpValues.type == Integer.class || this.mTmpValues.type == Integer.TYPE) {
                propertyPtr = AnimatedVectorDrawable.nCreatePathColorPropertyHolder(nativePtr, propertyId, (Integer)this.mTmpValues.startValue, (Integer)this.mTmpValues.endValue);
                if (this.mTmpValues.dataSource != null) {
                    int[] dataPoints = VectorDrawableAnimatorRT.createIntDataPoints(this.mTmpValues.dataSource, animator2.getDuration());
                    AnimatedVectorDrawable.nSetPropertyHolderData(propertyPtr, dataPoints, dataPoints.length);
                }
            } else {
                if (this.mDrawable.mAnimatedVectorState.mShouldIgnoreInvalidAnim) {
                    return;
                }
                throw new UnsupportedOperationException("Unsupported type: " + this.mTmpValues.type + ". Only float, int or PathData value is supported for Paths.");
            }
            this.createNativeChildAnimator(propertyPtr, startTime, animator2);
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForRootGroup(PropertyValuesHolder[] values, ObjectAnimator animator2, VectorDrawable.VectorDrawableState target, long startTime) {
            long nativePtr = target.getNativeRenderer();
            if (!animator2.getPropertyName().equals("alpha")) {
                if (this.mDrawable.mAnimatedVectorState.mShouldIgnoreInvalidAnim) {
                    return;
                }
                throw new UnsupportedOperationException("Only alpha is supported for root group");
            }
            Float startValue = null;
            Float endValue = null;
            for (int i = 0; i < values.length; ++i) {
                values[i].getPropertyValues(this.mTmpValues);
                if (!this.mTmpValues.propertyName.equals("alpha")) continue;
                startValue = (Float)this.mTmpValues.startValue;
                endValue = (Float)this.mTmpValues.endValue;
                break;
            }
            if (startValue == null && endValue == null) {
                if (this.mDrawable.mAnimatedVectorState.mShouldIgnoreInvalidAnim) {
                    return;
                }
                throw new UnsupportedOperationException("No alpha values are specified");
            }
            long propertyPtr = AnimatedVectorDrawable.nCreateRootAlphaPropertyHolder(nativePtr, startValue.floatValue(), endValue.floatValue());
            if (this.mTmpValues.dataSource != null) {
                float[] dataPoints = VectorDrawableAnimatorRT.createFloatDataPoints(this.mTmpValues.dataSource, animator2.getDuration());
                AnimatedVectorDrawable.nSetPropertyHolderData(propertyPtr, dataPoints, dataPoints.length);
            }
            this.createNativeChildAnimator(propertyPtr, startTime, animator2);
        }

        private static final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$getFrameCount(long duration) {
            long frameIntervalNanos = Choreographer.getInstance().getFrameIntervalNanos();
            int animIntervalMs = (int)(frameIntervalNanos / 1000000L);
            int numAnimFrames = (int)Math.ceil((double)duration / (double)animIntervalMs);
            if ((numAnimFrames = Math.max(2, numAnimFrames)) > 300) {
                Log.w("AnimatedVectorDrawable", "Duration for the animation is too long :" + duration + ", the animation will subsample the keyframe or path data.");
                numAnimFrames = 300;
            }
            return numAnimFrames;
        }

        private static final float[] $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createFloatDataPoints(PropertyValuesHolder.PropertyValues.DataSource dataSource, long duration) {
            int numAnimFrames = VectorDrawableAnimatorRT.getFrameCount(duration);
            float[] values = new float[numAnimFrames];
            float lastFrame = numAnimFrames - 1;
            for (int i = 0; i < numAnimFrames; ++i) {
                float fraction2 = (float)i / lastFrame;
                values[i] = ((Float)dataSource.getValueAtFraction(fraction2)).floatValue();
            }
            return values;
        }

        private static final int[] $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createIntDataPoints(PropertyValuesHolder.PropertyValues.DataSource dataSource, long duration) {
            int numAnimFrames = VectorDrawableAnimatorRT.getFrameCount(duration);
            int[] values = new int[numAnimFrames];
            float lastFrame = numAnimFrames - 1;
            for (int i = 0; i < numAnimFrames; ++i) {
                float fraction2 = (float)i / lastFrame;
                values[i] = (Integer)dataSource.getValueAtFraction(fraction2);
            }
            return values;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createNativeChildAnimator(long propertyPtr, long extraDelay, ObjectAnimator animator2) {
            long duration = animator2.getDuration();
            int repeatCount = animator2.getRepeatCount();
            long startDelay = extraDelay + animator2.getStartDelay();
            TimeInterpolator interpolator2 = animator2.getInterpolator();
            long nativeInterpolator = RenderNodeAnimatorSetHelper.createNativeInterpolator(interpolator2, duration);
            startDelay = (long)((float)startDelay * ValueAnimator.getDurationScale());
            duration = (long)((float)duration * ValueAnimator.getDurationScale());
            this.mStartDelays.add(startDelay);
            AnimatedVectorDrawable.nAddAnimator(this.mSetPtr, propertyPtr, nativeInterpolator, startDelay, duration, repeatCount, animator2.getRepeatMode());
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$recordLastSeenTarget(DisplayListCanvas canvas) {
            RenderNode node = RenderNodeAnimatorSetHelper.getTarget(canvas);
            this.mLastSeenTarget = new WeakReference<RenderNode>(node);
            if ((this.mInitialized || this.mPendingAnimationActions.size() > 0) && this.useTarget(node)) {
                for (int i = 0; i < this.mPendingAnimationActions.size(); ++i) {
                    this.handlePendingAction(this.mPendingAnimationActions.get(i));
                }
                this.mPendingAnimationActions.clear();
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$handlePendingAction(int pendingAnimationAction) {
            if (pendingAnimationAction == 1) {
                this.startAnimation();
            } else if (pendingAnimationAction == 2) {
                this.reverseAnimation();
            } else if (pendingAnimationAction == 3) {
                this.resetAnimation();
            } else if (pendingAnimationAction == 4) {
                this.endAnimation();
            } else {
                throw new UnsupportedOperationException("Animation action " + pendingAnimationAction + "is not supported");
            }
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$useLastSeenTarget() {
            if (this.mLastSeenTarget != null) {
                RenderNode target = (RenderNode)this.mLastSeenTarget.get();
                return this.useTarget(target);
            }
            return false;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$useTarget(RenderNode target) {
            if (target != null && target.isAttached()) {
                target.registerVectorDrawableAnimator(this);
                return true;
            }
            return false;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$invalidateOwningView() {
            this.mDrawable.invalidateSelf();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$addPendingAction(int pendingAnimationAction) {
            this.invalidateOwningView();
            this.mPendingAnimationActions.add(pendingAnimationAction);
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$start() {
            if (!this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.startAnimation();
            } else {
                this.addPendingAction(1);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$end() {
            if (!this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.endAnimation();
            } else {
                this.addPendingAction(4);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$reset() {
            if (!this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.resetAnimation();
            } else {
                this.addPendingAction(3);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$reverse() {
            if (!this.mIsReversible || !this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.reverseAnimation();
            } else {
                this.addPendingAction(2);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$startAnimation() {
            this.mStarted = true;
            AnimatedVectorDrawable.nStart(this.mSetPtr, this, ++this.mLastListenerId);
            this.invalidateOwningView();
            if (this.mListener != null) {
                this.mListener.onAnimationStart(null);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$endAnimation() {
            AnimatedVectorDrawable.nEnd(this.mSetPtr);
            this.invalidateOwningView();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$resetAnimation() {
            AnimatedVectorDrawable.nReset(this.mSetPtr);
            this.invalidateOwningView();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$reverseAnimation() {
            this.mStarted = true;
            AnimatedVectorDrawable.nReverse(this.mSetPtr, this, ++this.mLastListenerId);
            this.invalidateOwningView();
            if (this.mListener != null) {
                this.mListener.onAnimationStart(null);
            }
        }

        private final long $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$getAnimatorNativePtr() {
            return this.mSetPtr;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$canReverse() {
            return this.mIsReversible;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$isStarted() {
            return this.mStarted;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$isRunning() {
            if (!this.mInitialized) {
                return false;
            }
            return this.mStarted;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$setListener(Animator.AnimatorListener listener) {
            this.mListener = listener;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$removeListener(Animator.AnimatorListener listener) {
            this.mListener = null;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$onDraw(Canvas canvas) {
            if (canvas.isHardwareAccelerated()) {
                this.recordLastSeenTarget((DisplayListCanvas)canvas);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$isInfinite() {
            return this.mIsInfinite;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$pause() {
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$resume() {
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$onAnimationEnd(int listenerId) {
            if (listenerId != this.mLastListenerId) {
                return;
            }
            this.mStarted = false;
            this.invalidateOwningView();
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(null);
            }
        }

        private static final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$callOnFinished(VectorDrawableAnimatorRT set, int id2) {
            set.onAnimationEnd(id2);
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$transferPendingActions(VectorDrawableAnimator animatorSet) {
            for (int i = 0; i < this.mPendingAnimationActions.size(); ++i) {
                int pendingAction = this.mPendingAnimationActions.get(i);
                if (pendingAction == 1) {
                    animatorSet.start();
                    continue;
                }
                if (pendingAction == 4) {
                    animatorSet.end();
                    continue;
                }
                if (pendingAction == 2) {
                    animatorSet.reverse();
                    continue;
                }
                if (pendingAction == 3) {
                    animatorSet.reset();
                    continue;
                }
                throw new UnsupportedOperationException("Animation action " + pendingAction + "is not supported");
            }
            this.mPendingAnimationActions.clear();
        }

        private void __constructor__(AnimatedVectorDrawable animatedVectorDrawable) {
            this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$__constructor__(animatedVectorDrawable);
        }

        VectorDrawableAnimatorRT(AnimatedVectorDrawable animatedVectorDrawable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$__constructor__(android.graphics.drawable.AnimatedVectorDrawable ), 0, this, animatedVectorDrawable);
        }

        @Override
        public void init(AnimatorSet animatorSet) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$init(android.animation.AnimatorSet ), 0, this, animatorSet);
        }

        private void parseAnimatorSet(AnimatorSet animatorSet, long l) {
            InvokeDynamicSupport.bootstrap("parseAnimatorSet", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$parseAnimatorSet(android.animation.AnimatorSet long ), 0, this, animatorSet, l);
        }

        private void createRTAnimator(ObjectAnimator objectAnimator, long l) {
            InvokeDynamicSupport.bootstrap("createRTAnimator", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimator(android.animation.ObjectAnimator long ), 0, this, objectAnimator, l);
        }

        private void createRTAnimatorForGroup(PropertyValuesHolder[] propertyValuesHolderArray, ObjectAnimator objectAnimator, VectorDrawable.VGroup vGroup, long l) {
            InvokeDynamicSupport.bootstrap("createRTAnimatorForGroup", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForGroup(android.animation.PropertyValuesHolder[] android.animation.ObjectAnimator android.graphics.drawable.VectorDrawable$VGroup long ), 0, this, propertyValuesHolderArray, objectAnimator, vGroup, l);
        }

        private void createRTAnimatorForPath(ObjectAnimator objectAnimator, VectorDrawable.VPath vPath, long l) {
            InvokeDynamicSupport.bootstrap("createRTAnimatorForPath", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForPath(android.animation.ObjectAnimator android.graphics.drawable.VectorDrawable$VPath long ), 0, this, objectAnimator, vPath, l);
        }

        private void createRTAnimatorForFullPath(ObjectAnimator objectAnimator, VectorDrawable.VFullPath vFullPath, long l) {
            InvokeDynamicSupport.bootstrap("createRTAnimatorForFullPath", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForFullPath(android.animation.ObjectAnimator android.graphics.drawable.VectorDrawable$VFullPath long ), 0, this, objectAnimator, vFullPath, l);
        }

        private void createRTAnimatorForRootGroup(PropertyValuesHolder[] propertyValuesHolderArray, ObjectAnimator objectAnimator, VectorDrawable.VectorDrawableState vectorDrawableState, long l) {
            InvokeDynamicSupport.bootstrap("createRTAnimatorForRootGroup", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createRTAnimatorForRootGroup(android.animation.PropertyValuesHolder[] android.animation.ObjectAnimator android.graphics.drawable.VectorDrawable$VectorDrawableState long ), 0, this, propertyValuesHolderArray, objectAnimator, vectorDrawableState, l);
        }

        private static int getFrameCount(long l) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getFrameCount", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$getFrameCount(long ), 0, (long)l);
        }

        private static float[] createFloatDataPoints(PropertyValuesHolder.PropertyValues.DataSource dataSource, long l) {
            return InvokeDynamicSupport.bootstrapStatic("createFloatDataPoints", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createFloatDataPoints(android.animation.PropertyValuesHolder$PropertyValues$DataSource long ), 0, (PropertyValuesHolder.PropertyValues.DataSource)dataSource, (long)l);
        }

        private static int[] createIntDataPoints(PropertyValuesHolder.PropertyValues.DataSource dataSource, long l) {
            return InvokeDynamicSupport.bootstrapStatic("createIntDataPoints", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createIntDataPoints(android.animation.PropertyValuesHolder$PropertyValues$DataSource long ), 0, (PropertyValuesHolder.PropertyValues.DataSource)dataSource, (long)l);
        }

        private void createNativeChildAnimator(long l, long l2, ObjectAnimator objectAnimator) {
            InvokeDynamicSupport.bootstrap("createNativeChildAnimator", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$createNativeChildAnimator(long long android.animation.ObjectAnimator ), 0, this, l, l2, objectAnimator);
        }

        protected void recordLastSeenTarget(DisplayListCanvas displayListCanvas) {
            InvokeDynamicSupport.bootstrap("recordLastSeenTarget", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$recordLastSeenTarget(android.view.DisplayListCanvas ), 0, this, displayListCanvas);
        }

        private void handlePendingAction(int n) {
            InvokeDynamicSupport.bootstrap("handlePendingAction", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$handlePendingAction(int ), 0, this, n);
        }

        private boolean useLastSeenTarget() {
            return (boolean)InvokeDynamicSupport.bootstrap("useLastSeenTarget", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$useLastSeenTarget(), 0, this);
        }

        private boolean useTarget(RenderNode renderNode) {
            return (boolean)InvokeDynamicSupport.bootstrap("useTarget", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$useTarget(android.view.RenderNode ), 0, this, renderNode);
        }

        private void invalidateOwningView() {
            InvokeDynamicSupport.bootstrap("invalidateOwningView", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$invalidateOwningView(), 0, this);
        }

        private void addPendingAction(int n) {
            InvokeDynamicSupport.bootstrap("addPendingAction", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$addPendingAction(int ), 0, this, n);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$start(), 0, this);
        }

        @Override
        public void end() {
            InvokeDynamicSupport.bootstrap("end", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$end(), 0, this);
        }

        @Override
        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$reset(), 0, this);
        }

        @Override
        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$reverse(), 0, this);
        }

        private void startAnimation() {
            InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$startAnimation(), 0, this);
        }

        private void endAnimation() {
            InvokeDynamicSupport.bootstrap("endAnimation", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$endAnimation(), 0, this);
        }

        private void resetAnimation() {
            InvokeDynamicSupport.bootstrap("resetAnimation", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$resetAnimation(), 0, this);
        }

        private void reverseAnimation() {
            InvokeDynamicSupport.bootstrap("reverseAnimation", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$reverseAnimation(), 0, this);
        }

        public long getAnimatorNativePtr() {
            return (long)InvokeDynamicSupport.bootstrap("getAnimatorNativePtr", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$getAnimatorNativePtr(), 0, this);
        }

        @Override
        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$canReverse(), 0, this);
        }

        @Override
        public boolean isStarted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$isStarted(), 0, this);
        }

        @Override
        public boolean isRunning() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$isRunning(), 0, this);
        }

        @Override
        public void setListener(Animator.AnimatorListener animatorListener) {
            InvokeDynamicSupport.bootstrap("setListener", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$setListener(android.animation.Animator$AnimatorListener ), 0, this, animatorListener);
        }

        @Override
        public void removeListener(Animator.AnimatorListener animatorListener) {
            InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$removeListener(android.animation.Animator$AnimatorListener ), 0, this, animatorListener);
        }

        @Override
        public void onDraw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$onDraw(android.graphics.Canvas ), 0, this, canvas);
        }

        @Override
        public boolean isInfinite() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInfinite", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$isInfinite(), 0, this);
        }

        @Override
        public void pause() {
            InvokeDynamicSupport.bootstrap("pause", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$pause(), 0, this);
        }

        @Override
        public void resume() {
            InvokeDynamicSupport.bootstrap("resume", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$resume(), 0, this);
        }

        private void onAnimationEnd(int n) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$onAnimationEnd(int ), 0, this, n);
        }

        private static void callOnFinished(VectorDrawableAnimatorRT vectorDrawableAnimatorRT, int n) {
            InvokeDynamicSupport.bootstrapStatic("callOnFinished", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$callOnFinished(android.graphics.drawable.AnimatedVectorDrawable$VectorDrawableAnimatorRT int ), 0, (VectorDrawableAnimatorRT)vectorDrawableAnimatorRT, (int)n);
        }

        private void transferPendingActions(VectorDrawableAnimator vectorDrawableAnimator) {
            InvokeDynamicSupport.bootstrap("transferPendingActions", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorRT$transferPendingActions(android.graphics.drawable.AnimatedVectorDrawable$VectorDrawableAnimator ), 0, this, vectorDrawableAnimator);
        }

        public /* synthetic */ VectorDrawableAnimatorRT() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VectorDrawableAnimatorRT)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VectorDrawableAnimatorUI
    implements VectorDrawableAnimator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AnimatorSet mSet;
        private Drawable mDrawable;
        private ArrayList<Animator.AnimatorListener> mListenerArray;
        private boolean mIsInfinite;

        private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$__constructor__(AnimatedVectorDrawable drawable2) {
            this.mSet = null;
            this.mListenerArray = null;
            this.mIsInfinite = false;
            this.mDrawable = drawable2;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$init(AnimatorSet set) {
            if (this.mSet != null) {
                throw new UnsupportedOperationException("VectorDrawableAnimator cannot be re-initialized");
            }
            this.mSet = set.clone();
            boolean bl = this.mIsInfinite = this.mSet.getTotalDuration() == -1L;
            if (this.mListenerArray != null && !this.mListenerArray.isEmpty()) {
                for (int i = 0; i < this.mListenerArray.size(); ++i) {
                    this.mSet.addListener(this.mListenerArray.get(i));
                }
                this.mListenerArray.clear();
                this.mListenerArray = null;
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$start() {
            if (this.mSet == null || this.mSet.isStarted()) {
                return;
            }
            this.mSet.start();
            this.invalidateOwningView();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$end() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.end();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$reset() {
            if (this.mSet == null) {
                return;
            }
            this.start();
            this.mSet.cancel();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$reverse() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.reverse();
            this.invalidateOwningView();
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$canReverse() {
            return this.mSet != null && this.mSet.canReverse();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$setListener(Animator.AnimatorListener listener) {
            if (this.mSet == null) {
                if (this.mListenerArray == null) {
                    this.mListenerArray = new ArrayList();
                }
                this.mListenerArray.add(listener);
            } else {
                this.mSet.addListener(listener);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$removeListener(Animator.AnimatorListener listener) {
            if (this.mSet == null) {
                if (this.mListenerArray == null) {
                    return;
                }
                this.mListenerArray.remove(listener);
            } else {
                this.mSet.removeListener(listener);
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$onDraw(Canvas canvas) {
            if (this.mSet != null && this.mSet.isStarted()) {
                this.invalidateOwningView();
            }
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$isStarted() {
            return this.mSet != null && this.mSet.isStarted();
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$isRunning() {
            return this.mSet != null && this.mSet.isRunning();
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$isInfinite() {
            return this.mIsInfinite;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$pause() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.pause();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$resume() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.resume();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$invalidateOwningView() {
            this.mDrawable.invalidateSelf();
        }

        private void __constructor__(AnimatedVectorDrawable animatedVectorDrawable) {
            this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$__constructor__(animatedVectorDrawable);
        }

        VectorDrawableAnimatorUI(AnimatedVectorDrawable animatedVectorDrawable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$__constructor__(android.graphics.drawable.AnimatedVectorDrawable ), 0, this, animatedVectorDrawable);
        }

        @Override
        public void init(AnimatorSet animatorSet) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$init(android.animation.AnimatorSet ), 0, this, animatorSet);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$start(), 0, this);
        }

        @Override
        public void end() {
            InvokeDynamicSupport.bootstrap("end", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$end(), 0, this);
        }

        @Override
        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$reset(), 0, this);
        }

        @Override
        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$reverse(), 0, this);
        }

        @Override
        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$canReverse(), 0, this);
        }

        @Override
        public void setListener(Animator.AnimatorListener animatorListener) {
            InvokeDynamicSupport.bootstrap("setListener", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$setListener(android.animation.Animator$AnimatorListener ), 0, this, animatorListener);
        }

        @Override
        public void removeListener(Animator.AnimatorListener animatorListener) {
            InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$removeListener(android.animation.Animator$AnimatorListener ), 0, this, animatorListener);
        }

        @Override
        public void onDraw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$onDraw(android.graphics.Canvas ), 0, this, canvas);
        }

        @Override
        public boolean isStarted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$isStarted(), 0, this);
        }

        @Override
        public boolean isRunning() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$isRunning(), 0, this);
        }

        @Override
        public boolean isInfinite() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInfinite", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$isInfinite(), 0, this);
        }

        @Override
        public void pause() {
            InvokeDynamicSupport.bootstrap("pause", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$pause(), 0, this);
        }

        @Override
        public void resume() {
            InvokeDynamicSupport.bootstrap("resume", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$resume(), 0, this);
        }

        private void invalidateOwningView() {
            InvokeDynamicSupport.bootstrap("invalidateOwningView", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_VectorDrawableAnimatorUI$invalidateOwningView(), 0, this);
        }

        public /* synthetic */ VectorDrawableAnimatorUI() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VectorDrawableAnimatorUI)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface VectorDrawableAnimator
    extends InstrumentedInterface {
        public void init(AnimatorSet var1);

        public void start();

        public void end();

        public void reset();

        public void reverse();

        public boolean canReverse();

        public void setListener(Animator.AnimatorListener var1);

        public void removeListener(Animator.AnimatorListener var1);

        public void onDraw(Canvas var1);

        public boolean isStarted();

        public boolean isRunning();

        public boolean isInfinite();

        public void pause();

        public void resume();
    }

    private static class AnimatedVectorDrawableState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mChangingConfigurations;
        VectorDrawable mVectorDrawable;
        private boolean mShouldIgnoreInvalidAnim;
        ArrayList<PendingAnimator> mPendingAnims;
        ArrayList<Animator> mAnimators;
        ArrayMap<Animator, String> mTargetNameMap;

        private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$__constructor__(AnimatedVectorDrawableState copy, Drawable.Callback owner, Resources res) {
            this.mShouldIgnoreInvalidAnim = AnimatedVectorDrawable.shouldIgnoreInvalidAnimation();
            if (copy != null) {
                this.mChangingConfigurations = copy.mChangingConfigurations;
                if (copy.mVectorDrawable != null) {
                    Drawable.ConstantState cs = copy.mVectorDrawable.getConstantState();
                    this.mVectorDrawable = res != null ? (VectorDrawable)cs.newDrawable(res) : (VectorDrawable)cs.newDrawable();
                    this.mVectorDrawable = (VectorDrawable)this.mVectorDrawable.mutate();
                    this.mVectorDrawable.setCallback(owner);
                    this.mVectorDrawable.setLayoutDirection(copy.mVectorDrawable.getLayoutDirection());
                    this.mVectorDrawable.setBounds(copy.mVectorDrawable.getBounds());
                    this.mVectorDrawable.setAllowCaching(false);
                }
                if (copy.mAnimators != null) {
                    this.mAnimators = new ArrayList<Animator>(copy.mAnimators);
                }
                if (copy.mTargetNameMap != null) {
                    this.mTargetNameMap = new ArrayMap<Animator, String>(copy.mTargetNameMap);
                }
                if (copy.mPendingAnims != null) {
                    this.mPendingAnims = new ArrayList<PendingAnimator>(copy.mPendingAnims);
                }
            } else {
                this.mVectorDrawable = new VectorDrawable();
            }
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$canApplyTheme() {
            return this.mVectorDrawable != null && this.mVectorDrawable.canApplyTheme() || this.mPendingAnims != null || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable() {
            return new AnimatedVectorDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(Resources res) {
            return new AnimatedVectorDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$addPendingAnimator(int resId, float pathErrorScale, String target) {
            if (this.mPendingAnims == null) {
                this.mPendingAnims = new ArrayList(1);
            }
            this.mPendingAnims.add(new PendingAnimator(resId, pathErrorScale, target));
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$addTargetAnimator(String targetName, Animator animator2) {
            if (this.mAnimators == null) {
                this.mAnimators = new ArrayList(1);
                this.mTargetNameMap = new ArrayMap(1);
            }
            this.mAnimators.add(animator2);
            this.mTargetNameMap.put(animator2, targetName);
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$prepareLocalAnimators(AnimatorSet animatorSet, Resources res) {
            int count;
            if (this.mPendingAnims != null) {
                if (res != null) {
                    this.inflatePendingAnimators(res, null);
                } else {
                    Log.e("AnimatedVectorDrawable", "Failed to load animators. Either the AnimatedVectorDrawable must be created using a Resources object or applyTheme() must be called with a non-null Theme object.");
                }
                this.mPendingAnims = null;
            }
            int n = count = this.mAnimators == null ? 0 : this.mAnimators.size();
            if (count > 0) {
                Animator firstAnim = this.prepareLocalAnimator(0);
                AnimatorSet.Builder builder = animatorSet.play(firstAnim);
                for (int i = 1; i < count; ++i) {
                    Animator nextAnim = this.prepareLocalAnimator(i);
                    builder.with(nextAnim);
                }
            }
        }

        private final Animator $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$prepareLocalAnimator(int index) {
            Animator animator2 = this.mAnimators.get(index);
            Object localAnimator = animator2.clone();
            String targetName = this.mTargetNameMap.get(animator2);
            Object target = this.mVectorDrawable.getTargetByName(targetName);
            if (!this.mShouldIgnoreInvalidAnim) {
                if (target == null) {
                    throw new IllegalStateException("Target with the name \"" + targetName + "\" cannot be found in the VectorDrawable to be animated.");
                }
                if (!(target instanceof VectorDrawable.VectorDrawableState) && !(target instanceof VectorDrawable.VObject)) {
                    throw new UnsupportedOperationException("Target should be either VGroup, VPath, or ConstantState, " + target.getClass() + " is not supported");
                }
            }
            ((Animator)localAnimator).setTarget(target);
            return localAnimator;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$inflatePendingAnimators(Resources res, Resources.Theme t) {
            ArrayList<PendingAnimator> pendingAnims = this.mPendingAnims;
            if (pendingAnims != null) {
                this.mPendingAnims = null;
                int count = pendingAnims.size();
                for (int i = 0; i < count; ++i) {
                    PendingAnimator pendingAnimator = pendingAnims.get(i);
                    Animator animator2 = pendingAnimator.newInstance(res, t);
                    AnimatedVectorDrawable.updateAnimatorProperty(animator2, pendingAnimator.target, this.mVectorDrawable, this.mShouldIgnoreInvalidAnim);
                    this.addTargetAnimator(pendingAnimator.target, animator2);
                }
            }
        }

        private void __constructor__(AnimatedVectorDrawableState animatedVectorDrawableState, Drawable.Callback callback, Resources resources) {
            this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$__constructor__(animatedVectorDrawableState, callback, resources);
        }

        public AnimatedVectorDrawableState(AnimatedVectorDrawableState animatedVectorDrawableState, Drawable.Callback callback, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$__constructor__(android.graphics.drawable.AnimatedVectorDrawable$AnimatedVectorDrawableState android.graphics.drawable.Drawable$Callback android.content.res.Resources ), 0, this, animatedVectorDrawableState, callback, resources);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$getChangingConfigurations(), 0, this);
        }

        public void addPendingAnimator(int n, float f, String string2) {
            InvokeDynamicSupport.bootstrap("addPendingAnimator", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$addPendingAnimator(int float java.lang.String ), 0, this, n, f, string2);
        }

        public void addTargetAnimator(String string2, Animator animator2) {
            InvokeDynamicSupport.bootstrap("addTargetAnimator", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$addTargetAnimator(java.lang.String android.animation.Animator ), 0, this, string2, animator2);
        }

        public void prepareLocalAnimators(AnimatorSet animatorSet, Resources resources) {
            InvokeDynamicSupport.bootstrap("prepareLocalAnimators", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$prepareLocalAnimators(android.animation.AnimatorSet android.content.res.Resources ), 0, this, animatorSet, resources);
        }

        private Animator prepareLocalAnimator(int n) {
            return InvokeDynamicSupport.bootstrap("prepareLocalAnimator", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$prepareLocalAnimator(int ), 0, this, n);
        }

        public void inflatePendingAnimators(Resources resources, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("inflatePendingAnimators", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$inflatePendingAnimators(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        public /* synthetic */ AnimatedVectorDrawableState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedVectorDrawableState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class PendingAnimator
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public int animResId;
            public float pathErrorScale;
            public String target;

            private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState_PendingAnimator$__constructor__(int animResId, float pathErrorScale, String target) {
                this.animResId = animResId;
                this.pathErrorScale = pathErrorScale;
                this.target = target;
            }

            private final Animator $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState_PendingAnimator$newInstance(Resources res, Resources.Theme theme) {
                return AnimatorInflater.loadAnimator(res, theme, this.animResId, this.pathErrorScale);
            }

            private void __constructor__(int n, float f, String string2) {
                this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState_PendingAnimator$__constructor__(n, f, string2);
            }

            public PendingAnimator(int n, float f, String string2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState_PendingAnimator$__constructor__(int float java.lang.String ), 0, this, n, f, string2);
            }

            public Animator newInstance(Resources resources, Resources.Theme theme) {
                return InvokeDynamicSupport.bootstrap("newInstance", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState_PendingAnimator$newInstance(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
            }

            public /* synthetic */ PendingAnimator() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PendingAnimator)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

