/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.fonts.FontVariationAxis;
import android.util.Log;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FontFamily
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public long mNativePtr;
    private long mBuilderPtr;

    private void $$robo$$android_graphics_FontFamily$__constructor__() {
        this.mBuilderPtr = FontFamily.nInitBuilder(null, 0);
    }

    private void $$robo$$android_graphics_FontFamily$__constructor__(String lang, int variant) {
        this.mBuilderPtr = FontFamily.nInitBuilder(lang, variant);
    }

    private final boolean $$robo$$android_graphics_FontFamily$freeze() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen");
        }
        this.mNativePtr = FontFamily.nCreateFamily(this.mBuilderPtr);
        this.mBuilderPtr = 0L;
        return this.mNativePtr != 0L;
    }

    private final void $$robo$$android_graphics_FontFamily$abortCreation() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen or abandoned");
        }
        FontFamily.nAbort(this.mBuilderPtr);
        this.mBuilderPtr = 0L;
    }

    private final void $$robo$$android_graphics_FontFamily$finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0L) {
                FontFamily.nUnrefFamily(this.mNativePtr);
            }
            if (this.mBuilderPtr != 0L) {
                FontFamily.nAbort(this.mBuilderPtr);
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean $$robo$$android_graphics_FontFamily$addFont(String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFont after freezing.");
        }
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            boolean bl = FontFamily.nAddFont(this.mBuilderPtr, fontBuffer, ttcIndex, weight, italic);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    private final boolean $$robo$$android_graphics_FontFamily$addFontFromBuffer(ByteBuffer font, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontWeightStyle after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontWeightStyle(this.mBuilderPtr, font, ttcIndex, weight, italic);
    }

    private final boolean $$robo$$android_graphics_FontFamily$addFontFromAssetManager(AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic, FontVariationAxis[] axes) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontFromAsset after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontFromAssetManager(this.mBuilderPtr, mgr, path, cookie, isAsset, ttcIndex, weight, isItalic);
    }

    private final void $$robo$$android_graphics_FontFamily$allowUnsupportedFont() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to allow unsupported font.");
        }
        FontFamily.nAllowUnsupportedFont(this.mBuilderPtr);
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFont(long builderPtr, ByteBuffer font, int ttcIndex) {
        return FontFamily.nAddFont(builderPtr, font, ttcIndex, -1, -1);
    }

    private static final long $$robo$$android_graphics_FontFamily$nInitBuilder(String string2, int n) {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_FontFamily$nCreateFamily(long l) {
        return 0L;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_FontFamily$nAllowUnsupportedFont(long l) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_FontFamily$nAbort(long l) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_FontFamily$nUnrefFamily(long l) {
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFont(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFontWeightStyle(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFontFromAssetManager(long l, AssetManager assetManager, String string2, int n, boolean bl, int n2, int n3, int n4) {
        return false;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_FontFamily$nAddAxisValue(long l, int n, float f) {
    }

    static void __staticInitializer__() {
        TAG = "FontFamily";
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_FontFamily$__constructor__();
    }

    public FontFamily() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontFamily$__constructor__(), 0, this);
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$android_graphics_FontFamily$__constructor__(string2, n);
    }

    public FontFamily(String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontFamily$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    public boolean freeze() {
        return (boolean)InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_graphics_FontFamily$freeze(), 0, this);
    }

    public void abortCreation() {
        InvokeDynamicSupport.bootstrap("abortCreation", $$robo$$android_graphics_FontFamily$abortCreation(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_FontFamily$finalize(), 0, this);
    }

    public boolean addFont(String string2, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("addFont", $$robo$$android_graphics_FontFamily$addFont(java.lang.String int android.graphics.fonts.FontVariationAxis[] int int ), 0, this, string2, n, fontVariationAxisArray, n2, n3);
    }

    public boolean addFontFromBuffer(ByteBuffer byteBuffer, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("addFontFromBuffer", $$robo$$android_graphics_FontFamily$addFontFromBuffer(java.nio.ByteBuffer int android.graphics.fonts.FontVariationAxis[] int int ), 0, this, byteBuffer, n, fontVariationAxisArray, n2, n3);
    }

    public boolean addFontFromAssetManager(AssetManager assetManager, String string2, int n, boolean bl, int n2, int n3, int n4, FontVariationAxis[] fontVariationAxisArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("addFontFromAssetManager", $$robo$$android_graphics_FontFamily$addFontFromAssetManager(android.content.res.AssetManager java.lang.String int boolean int int int android.graphics.fonts.FontVariationAxis[] ), 0, this, assetManager, string2, n, bl, n2, n3, n4, fontVariationAxisArray);
    }

    public void allowUnsupportedFont() {
        InvokeDynamicSupport.bootstrap("allowUnsupportedFont", $$robo$$android_graphics_FontFamily$allowUnsupportedFont(), 0, this);
    }

    private static boolean nAddFont(long l, ByteBuffer byteBuffer, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFont", $$robo$$android_graphics_FontFamily$nAddFont(long java.nio.ByteBuffer int ), 0, (long)l, (ByteBuffer)byteBuffer, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nInitBuilder$nativeBinding(String var0, int var1);

    private static long nInitBuilder(String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInitBuilder", $$robo$$android_graphics_FontFamily$nInitBuilder(java.lang.String int ), 1, (String)string2, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nCreateFamily$nativeBinding(long var0);

    private static long nCreateFamily(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateFamily", $$robo$$android_graphics_FontFamily$nCreateFamily(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nAllowUnsupportedFont$nativeBinding(long var0);

    private static void nAllowUnsupportedFont(long l) {
        InvokeDynamicSupport.bootstrapStatic("nAllowUnsupportedFont", $$robo$$android_graphics_FontFamily$nAllowUnsupportedFont(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nAbort$nativeBinding(long var0);

    private static void nAbort(long l) {
        InvokeDynamicSupport.bootstrapStatic("nAbort", $$robo$$android_graphics_FontFamily$nAbort(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nUnrefFamily$nativeBinding(long var0);

    private static void nUnrefFamily(long l) {
        InvokeDynamicSupport.bootstrapStatic("nUnrefFamily", $$robo$$android_graphics_FontFamily$nUnrefFamily(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nAddFont$nativeBinding(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static boolean nAddFont(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFont", $$robo$$android_graphics_FontFamily$nAddFont(long java.nio.ByteBuffer int int int ), 1, (long)l, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ boolean $$robo$$nAddFontWeightStyle$nativeBinding(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static boolean nAddFontWeightStyle(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFontWeightStyle", $$robo$$android_graphics_FontFamily$nAddFontWeightStyle(long java.nio.ByteBuffer int int int ), 1, (long)l, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ boolean $$robo$$nAddFontFromAssetManager$nativeBinding(long var0, AssetManager var2, String var3, int var4, boolean var5, int var6, int var7, int var8);

    private static boolean nAddFontFromAssetManager(long l, AssetManager assetManager, String string2, int n, boolean bl, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFontFromAssetManager", $$robo$$android_graphics_FontFamily$nAddFontFromAssetManager(long android.content.res.AssetManager java.lang.String int boolean int int int ), 1, (long)l, (AssetManager)assetManager, (String)string2, (int)n, (boolean)bl, (int)n2, (int)n3, (int)n4);
    }

    private static final native /* synthetic */ void $$robo$$nAddAxisValue$nativeBinding(long var0, int var2, float var3);

    private static void nAddAxisValue(long l, int n, float f) {
        InvokeDynamicSupport.bootstrapStatic("nAddAxisValue", $$robo$$android_graphics_FontFamily$nAddAxisValue(long int float ), 1, (long)l, (int)n, (float)f);
    }

    static {
        RobolectricInternals.classInitializing(FontFamily.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontFamily)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

