/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ComplexColor;
import android.content.res.ConstantState;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.MathUtils;
import android.util.SparseArray;
import android.util.StateSet;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorStateList
extends ComplexColor
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ColorStateList";
    private static int DEFAULT_COLOR = -65536;
    private static int[][] EMPTY;
    private static SparseArray<WeakReference<ColorStateList>> sCache;
    private ColorStateListFactory mFactory;
    private int[][] mThemeAttrs;
    private int mChangingConfigurations;
    private int[][] mStateSpecs;
    private int[] mColors;
    private int mDefaultColor;
    private boolean mIsOpaque;
    public static Parcelable.Creator<ColorStateList> CREATOR;

    private void $$robo$$android_content_res_ColorStateList$__constructor__() {
    }

    private void $$robo$$android_content_res_ColorStateList$__constructor__(int[][] states, int[] colors) {
        this.mStateSpecs = states;
        this.mColors = colors;
        this.onColorsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ColorStateList $$robo$$android_content_res_ColorStateList$valueOf(int color2) {
        SparseArray<WeakReference<ColorStateList>> sparseArray = sCache;
        synchronized (sparseArray) {
            int index = sCache.indexOfKey(color2);
            if (index >= 0) {
                ColorStateList cached = (ColorStateList)sCache.valueAt(index).get();
                if (cached != null) {
                    return cached;
                }
                sCache.removeAt(index);
            }
            int N = sCache.size();
            for (int i = N - 1; i >= 0; --i) {
                if (sCache.valueAt(i).get() != null) continue;
                sCache.removeAt(i);
            }
            ColorStateList csl = new ColorStateList(EMPTY, new int[]{color2});
            sCache.put(color2, new WeakReference<ColorStateList>(csl));
            return csl;
        }
    }

    private void $$robo$$android_content_res_ColorStateList$__constructor__(ColorStateList orig) {
        if (orig != null) {
            this.mChangingConfigurations = orig.mChangingConfigurations;
            this.mStateSpecs = orig.mStateSpecs;
            this.mDefaultColor = orig.mDefaultColor;
            this.mIsOpaque = orig.mIsOpaque;
            this.mThemeAttrs = (int[][])orig.mThemeAttrs.clone();
            this.mColors = (int[])orig.mColors.clone();
        }
    }

    @Deprecated
    private static final ColorStateList $$robo$$android_content_res_ColorStateList$createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        return ColorStateList.createFromXml(r, parser, null);
    }

    private static final ColorStateList $$robo$$android_content_res_ColorStateList$createFromXml(Resources r, XmlPullParser parser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet(parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return ColorStateList.createFromXmlInner(r, parser, attrs, theme);
    }

    private static final ColorStateList $$robo$$android_content_res_ColorStateList$createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        String name = parser.getName();
        if (!name.equals("selector")) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": invalid color state list tag " + name);
        }
        ColorStateList colorStateList = new ColorStateList();
        colorStateList.inflate(r, parser, attrs, theme);
        return colorStateList;
    }

    private final ColorStateList $$robo$$android_content_res_ColorStateList$withAlpha(int alpha) {
        int[] colors = new int[this.mColors.length];
        int len = colors.length;
        for (int i = 0; i < len; ++i) {
            colors[i] = this.mColors[i] & 0xFFFFFF | alpha << 24;
        }
        return new ColorStateList(this.mStateSpecs, colors);
    }

    private final void $$robo$$android_content_res_ColorStateList$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        int changingConfigurations = 0;
        int defaultColor = -65536;
        boolean hasUnresolvedAttrs = false;
        int[][] stateSpecList = ArrayUtils.newUnpaddedArray(int[].class, 20);
        Object themeAttrsList = new int[stateSpecList.length][];
        int[] colorList = new int[stateSpecList.length];
        int listSize = 0;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = Resources.obtainAttributes(r, theme, attrs, R.styleable.ColorStateListItem);
            int[] themeAttrs = a.extractThemeAttrs();
            int baseColor = a.getColor(0, -65281);
            float alphaMod = a.getFloat(1, 1.0f);
            changingConfigurations |= a.getChangingConfigurations();
            a.recycle();
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] stateSpec = new int[numAttrs];
            block4: for (int i = 0; i < numAttrs; ++i) {
                int stateResId = attrs.getAttributeNameResource(i);
                switch (stateResId) {
                    case 16843173: 
                    case 16843551: {
                        continue block4;
                    }
                    default: {
                        stateSpec[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
                    }
                }
            }
            stateSpec = StateSet.trimStateSet(stateSpec, j);
            int color2 = this.modulateColorAlpha(baseColor, alphaMod);
            if (listSize == 0 || stateSpec.length == 0) {
                defaultColor = color2;
            }
            if (themeAttrs != null) {
                hasUnresolvedAttrs = true;
            }
            colorList = GrowingArrayUtils.append(colorList, listSize, color2);
            themeAttrsList = GrowingArrayUtils.append(themeAttrsList, listSize, themeAttrs);
            stateSpecList = GrowingArrayUtils.append(stateSpecList, listSize, stateSpec);
            ++listSize;
        }
        this.mChangingConfigurations = changingConfigurations;
        this.mDefaultColor = defaultColor;
        if (hasUnresolvedAttrs) {
            this.mThemeAttrs = new int[listSize][];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)themeAttrsList, (int)0, (Object)this.mThemeAttrs, (int)0, (int)listSize);
        } else {
            this.mThemeAttrs = null;
        }
        this.mColors = new int[listSize];
        this.mStateSpecs = new int[listSize][];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])colorList, (int)0, (int[])this.mColors, (int)0, (int)listSize);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)stateSpecList, (int)0, (Object)this.mStateSpecs, (int)0, (int)listSize);
        this.onColorsChanged();
    }

    private final boolean $$robo$$android_content_res_ColorStateList$canApplyTheme() {
        return this.mThemeAttrs != null;
    }

    private final void $$robo$$android_content_res_ColorStateList$applyTheme(Resources.Theme t) {
        if (this.mThemeAttrs == null) {
            return;
        }
        boolean hasUnresolvedAttrs = false;
        int[][] themeAttrsList = this.mThemeAttrs;
        int N = themeAttrsList.length;
        for (int i = 0; i < N; ++i) {
            if (themeAttrsList[i] == null) continue;
            TypedArray a = t.resolveAttributes(themeAttrsList[i], R.styleable.ColorStateListItem);
            float defaultAlphaMod = themeAttrsList[i][0] != 0 ? (float)Color.alpha(this.mColors[i]) / 255.0f : 1.0f;
            themeAttrsList[i] = a.extractThemeAttrs(themeAttrsList[i]);
            if (themeAttrsList[i] != null) {
                hasUnresolvedAttrs = true;
            }
            int baseColor = a.getColor(0, this.mColors[i]);
            float alphaMod = a.getFloat(1, defaultAlphaMod);
            this.mColors[i] = this.modulateColorAlpha(baseColor, alphaMod);
            this.mChangingConfigurations |= a.getChangingConfigurations();
            a.recycle();
        }
        if (!hasUnresolvedAttrs) {
            this.mThemeAttrs = null;
        }
        this.onColorsChanged();
    }

    private final ColorStateList $$robo$$android_content_res_ColorStateList$obtainForTheme(Resources.Theme t) {
        if (t == null || !this.canApplyTheme()) {
            return this;
        }
        ColorStateList clone = new ColorStateList(this);
        clone.applyTheme(t);
        return clone;
    }

    private final int $$robo$$android_content_res_ColorStateList$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mChangingConfigurations;
    }

    private final int $$robo$$android_content_res_ColorStateList$modulateColorAlpha(int baseColor, float alphaMod) {
        if (alphaMod == 1.0f) {
            return baseColor;
        }
        int baseAlpha = Color.alpha(baseColor);
        int alpha = MathUtils.constrain((int)((float)baseAlpha * alphaMod + 0.5f), 0, 255);
        return baseColor & 0xFFFFFF | alpha << 24;
    }

    private final boolean $$robo$$android_content_res_ColorStateList$isStateful() {
        return this.mStateSpecs.length >= 1 && this.mStateSpecs[0].length > 0;
    }

    private final boolean $$robo$$android_content_res_ColorStateList$hasFocusStateSpecified() {
        return StateSet.containsAttribute(this.mStateSpecs, 16842908);
    }

    private final boolean $$robo$$android_content_res_ColorStateList$isOpaque() {
        return this.mIsOpaque;
    }

    private final int $$robo$$android_content_res_ColorStateList$getColorForState(int[] stateSet, int defaultColor) {
        int setLength = this.mStateSpecs.length;
        for (int i = 0; i < setLength; ++i) {
            int[] stateSpec = this.mStateSpecs[i];
            if (!StateSet.stateSetMatches(stateSpec, stateSet)) continue;
            return this.mColors[i];
        }
        return defaultColor;
    }

    private final int $$robo$$android_content_res_ColorStateList$getDefaultColor() {
        return this.mDefaultColor;
    }

    private final int[][] $$robo$$android_content_res_ColorStateList$getStates() {
        return this.mStateSpecs;
    }

    private final int[] $$robo$$android_content_res_ColorStateList$getColors() {
        return this.mColors;
    }

    private final boolean $$robo$$android_content_res_ColorStateList$hasState(int state) {
        for (int[] states : this.mStateSpecs) {
            int stateCount = states.length;
            for (int stateIndex = 0; stateIndex < stateCount; ++stateIndex) {
                if (states[stateIndex] != state && states[stateIndex] != ~state) continue;
                return true;
            }
        }
        return false;
    }

    private final String $$robo$$android_content_res_ColorStateList$toString() {
        return "ColorStateList{mThemeAttrs=" + Arrays.deepToString((Object[])this.mThemeAttrs) + "mChangingConfigurations=" + this.mChangingConfigurations + "mStateSpecs=" + Arrays.deepToString((Object[])this.mStateSpecs) + "mColors=" + Arrays.toString(this.mColors) + "mDefaultColor=" + this.mDefaultColor + '}';
    }

    private final void $$robo$$android_content_res_ColorStateList$onColorsChanged() {
        int defaultColor = -65536;
        boolean isOpaque = true;
        int[][] states = this.mStateSpecs;
        int[] colors = this.mColors;
        int N = states.length;
        if (N > 0) {
            int i;
            defaultColor = colors[0];
            for (i = N - 1; i > 0; --i) {
                if (states[i].length != 0) continue;
                defaultColor = colors[i];
                break;
            }
            for (i = 0; i < N; ++i) {
                if (Color.alpha(colors[i]) == 255) continue;
                isOpaque = false;
                break;
            }
        }
        this.mDefaultColor = defaultColor;
        this.mIsOpaque = isOpaque;
    }

    private final ConstantState<ComplexColor> $$robo$$android_content_res_ColorStateList$getConstantState() {
        if (this.mFactory == null) {
            this.mFactory = new ColorStateListFactory(this);
        }
        return this.mFactory;
    }

    private final int $$robo$$android_content_res_ColorStateList$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_res_ColorStateList$writeToParcel(Parcel dest, int flags) {
        if (this.canApplyTheme()) {
            Log.w("ColorStateList", "Wrote partially-resolved ColorStateList to parcel!");
        }
        int N = this.mStateSpecs.length;
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            dest.writeIntArray(this.mStateSpecs[i]);
        }
        dest.writeIntArray(this.mColors);
    }

    static void __staticInitializer__() {
        EMPTY = new int[][]{new int[0]};
        sCache = new SparseArray();
        CREATOR = new Parcelable.Creator<ColorStateList>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_res_ColorStateList_1$__constructor__() {
            }

            private final ColorStateList[] $$robo$$android_content_res_ColorStateList_1$newArray(int size) {
                return new ColorStateList[size];
            }

            private final ColorStateList $$robo$$android_content_res_ColorStateList_1$createFromParcel(Parcel source) {
                int N = source.readInt();
                int[][] stateSpecs = new int[N][];
                for (int i = 0; i < N; ++i) {
                    stateSpecs[i] = source.createIntArray();
                }
                int[] colors = source.createIntArray();
                return new ColorStateList(stateSpecs, colors);
            }

            private void __constructor__() {
                this.$$robo$$android_content_res_ColorStateList_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList_1$__constructor__(), 0, this);
            }

            public ColorStateList[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_res_ColorStateList_1$newArray(int ), 0, this, n);
            }

            @Override
            public ColorStateList createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_res_ColorStateList_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_ColorStateList$__constructor__();
    }

    private ColorStateList() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList$__constructor__(), 0, this);
    }

    private void __constructor__(int[][] nArray, int[] nArray2) {
        this.$$robo$$android_content_res_ColorStateList$__constructor__(nArray, nArray2);
    }

    public ColorStateList(int[][] nArray, int[] nArray2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList$__constructor__(int[][] int[] ), 0, this, nArray, nArray2);
    }

    public static ColorStateList valueOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_content_res_ColorStateList$valueOf(int ), 0, (int)n);
    }

    private void __constructor__(ColorStateList colorStateList) {
        this.$$robo$$android_content_res_ColorStateList$__constructor__(colorStateList);
    }

    private ColorStateList(ColorStateList colorStateList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList$__constructor__(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Deprecated
    public static ColorStateList createFromXml(Resources resources, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXml", $$robo$$android_content_res_ColorStateList$createFromXml(android.content.res.Resources org.xmlpull.v1.XmlPullParser ), 0, (Resources)resources, (XmlPullParser)xmlPullParser);
    }

    public static ColorStateList createFromXml(Resources resources, XmlPullParser xmlPullParser, Resources.Theme theme) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXml", $$robo$$android_content_res_ColorStateList$createFromXml(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.content.res.Resources$Theme ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (Resources.Theme)theme);
    }

    static ColorStateList createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXmlInner", $$robo$$android_content_res_ColorStateList$createFromXmlInner(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
    }

    public ColorStateList withAlpha(int n) {
        return InvokeDynamicSupport.bootstrap("withAlpha", $$robo$$android_content_res_ColorStateList$withAlpha(int ), 0, this, n);
    }

    private void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_content_res_ColorStateList$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_content_res_ColorStateList$canApplyTheme(), 0, this);
    }

    private void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_content_res_ColorStateList$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public ColorStateList obtainForTheme(Resources.Theme theme) {
        return InvokeDynamicSupport.bootstrap("obtainForTheme", $$robo$$android_content_res_ColorStateList$obtainForTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_content_res_ColorStateList$getChangingConfigurations(), 0, this);
    }

    private int modulateColorAlpha(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrap("modulateColorAlpha", $$robo$$android_content_res_ColorStateList$modulateColorAlpha(int float ), 0, this, n, f);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_content_res_ColorStateList$isStateful(), 0, this);
    }

    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_content_res_ColorStateList$hasFocusStateSpecified(), 0, this);
    }

    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_content_res_ColorStateList$isOpaque(), 0, this);
    }

    public int getColorForState(int[] nArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getColorForState", $$robo$$android_content_res_ColorStateList$getColorForState(int[] int ), 0, this, nArray, n);
    }

    @Override
    public int getDefaultColor() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultColor", $$robo$$android_content_res_ColorStateList$getDefaultColor(), 0, this);
    }

    public int[][] getStates() {
        return InvokeDynamicSupport.bootstrap("getStates", $$robo$$android_content_res_ColorStateList$getStates(), 0, this);
    }

    public int[] getColors() {
        return InvokeDynamicSupport.bootstrap("getColors", $$robo$$android_content_res_ColorStateList$getColors(), 0, this);
    }

    public boolean hasState(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasState", $$robo$$android_content_res_ColorStateList$hasState(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_res_ColorStateList$toString(), 0, this);
    }

    private void onColorsChanged() {
        InvokeDynamicSupport.bootstrap("onColorsChanged", $$robo$$android_content_res_ColorStateList$onColorsChanged(), 0, this);
    }

    @Override
    public ConstantState<ComplexColor> getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_content_res_ColorStateList$getConstantState(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_res_ColorStateList$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_res_ColorStateList$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(ColorStateList.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorStateList)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ColorStateListFactory
    extends ConstantState<ComplexColor> {
        public transient /* synthetic */ Object __robo_data__;
        private ColorStateList mSrc;

        private void $$robo$$android_content_res_ColorStateList_ColorStateListFactory$__constructor__(ColorStateList src) {
            this.mSrc = src;
        }

        private final int $$robo$$android_content_res_ColorStateList_ColorStateListFactory$getChangingConfigurations() {
            return this.mSrc.mChangingConfigurations;
        }

        private final ColorStateList $$robo$$android_content_res_ColorStateList_ColorStateListFactory$newInstance() {
            return this.mSrc;
        }

        private final ColorStateList $$robo$$android_content_res_ColorStateList_ColorStateListFactory$newInstance(Resources res, Resources.Theme theme) {
            return this.mSrc.obtainForTheme(theme);
        }

        private void __constructor__(ColorStateList colorStateList) {
            this.$$robo$$android_content_res_ColorStateList_ColorStateListFactory$__constructor__(colorStateList);
        }

        public ColorStateListFactory(ColorStateList colorStateList) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList_ColorStateListFactory$__constructor__(android.content.res.ColorStateList ), 0, this, colorStateList);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_content_res_ColorStateList_ColorStateListFactory$getChangingConfigurations(), 0, this);
        }

        @Override
        public ColorStateList newInstance() {
            return InvokeDynamicSupport.bootstrap("newInstance", $$robo$$android_content_res_ColorStateList_ColorStateListFactory$newInstance(), 0, this);
        }

        @Override
        public ColorStateList newInstance(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newInstance", $$robo$$android_content_res_ColorStateList_ColorStateListFactory$newInstance(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        public /* synthetic */ ColorStateListFactory() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorStateListFactory)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

