/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AssetFileDescriptor
implements Parcelable,
Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static long UNKNOWN_LENGTH = -1L;
    private ParcelFileDescriptor mFd;
    private long mStartOffset;
    private long mLength;
    private Bundle mExtras;
    public static Parcelable.Creator<AssetFileDescriptor> CREATOR;

    private void $$robo$$android_content_res_AssetFileDescriptor$__constructor__(ParcelFileDescriptor fd, long startOffset, long length) {
    }

    private void $$robo$$android_content_res_AssetFileDescriptor$__constructor__(ParcelFileDescriptor fd, long startOffset, long length, Bundle extras) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (length < 0L && startOffset != 0L) {
            throw new IllegalArgumentException("startOffset must be 0 when using UNKNOWN_LENGTH");
        }
        this.mFd = fd;
        this.mStartOffset = startOffset;
        this.mLength = length;
        this.mExtras = extras;
    }

    private final ParcelFileDescriptor $$robo$$android_content_res_AssetFileDescriptor$getParcelFileDescriptor() {
        return this.mFd;
    }

    private final FileDescriptor $$robo$$android_content_res_AssetFileDescriptor$getFileDescriptor() {
        return this.mFd.getFileDescriptor();
    }

    private final long $$robo$$android_content_res_AssetFileDescriptor$getStartOffset() {
        return this.mStartOffset;
    }

    private final Bundle $$robo$$android_content_res_AssetFileDescriptor$getExtras() {
        return this.mExtras;
    }

    private final long $$robo$$android_content_res_AssetFileDescriptor$getLength() {
        if (this.mLength >= 0L) {
            return this.mLength;
        }
        long len = this.mFd.getStatSize();
        return len >= 0L ? len : -1L;
    }

    private final long $$robo$$android_content_res_AssetFileDescriptor$getDeclaredLength() {
        return this.mLength;
    }

    private final void $$robo$$android_content_res_AssetFileDescriptor$close() throws IOException {
        this.mFd.close();
    }

    private final FileInputStream $$robo$$android_content_res_AssetFileDescriptor$createInputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseInputStream(this.mFd);
        }
        return new AutoCloseInputStream(this);
    }

    private final FileOutputStream $$robo$$android_content_res_AssetFileDescriptor$createOutputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseOutputStream(this.mFd);
        }
        return new AutoCloseOutputStream(this);
    }

    private final String $$robo$$android_content_res_AssetFileDescriptor$toString() {
        return "{AssetFileDescriptor: " + this.mFd + " start=" + this.mStartOffset + " len=" + this.mLength + "}";
    }

    private final int $$robo$$android_content_res_AssetFileDescriptor$describeContents() {
        return this.mFd.describeContents();
    }

    private final void $$robo$$android_content_res_AssetFileDescriptor$writeToParcel(Parcel out, int flags) {
        this.mFd.writeToParcel(out, flags);
        out.writeLong(this.mStartOffset);
        out.writeLong(this.mLength);
        if (this.mExtras != null) {
            out.writeInt(1);
            out.writeBundle(this.mExtras);
        } else {
            out.writeInt(0);
        }
    }

    private void $$robo$$android_content_res_AssetFileDescriptor$__constructor__(Parcel src) {
        this.mFd = ParcelFileDescriptor.CREATOR.createFromParcel(src);
        this.mStartOffset = src.readLong();
        this.mLength = src.readLong();
        this.mExtras = src.readInt() != 0 ? src.readBundle() : null;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AssetFileDescriptor>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_res_AssetFileDescriptor_1$__constructor__() {
            }

            private final AssetFileDescriptor $$robo$$android_content_res_AssetFileDescriptor_1$createFromParcel(Parcel in) {
                return new AssetFileDescriptor(in);
            }

            private final AssetFileDescriptor[] $$robo$$android_content_res_AssetFileDescriptor_1$newArray(int size) {
                return new AssetFileDescriptor[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_res_AssetFileDescriptor_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetFileDescriptor_1$__constructor__(), 0, this);
            }

            @Override
            public AssetFileDescriptor createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_res_AssetFileDescriptor_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AssetFileDescriptor[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_res_AssetFileDescriptor_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor, long l, long l2) {
        this.$$robo$$android_content_res_AssetFileDescriptor$__constructor__(parcelFileDescriptor, l, l2);
    }

    public AssetFileDescriptor(ParcelFileDescriptor parcelFileDescriptor, long l, long l2) {
        this(parcelFileDescriptor, l, l2, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetFileDescriptor$__constructor__(android.os.ParcelFileDescriptor long long ), 0, this, parcelFileDescriptor, l, l2);
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor, long l, long l2, Bundle bundle) {
        this.$$robo$$android_content_res_AssetFileDescriptor$__constructor__(parcelFileDescriptor, l, l2, bundle);
    }

    public AssetFileDescriptor(ParcelFileDescriptor parcelFileDescriptor, long l, long l2, Bundle bundle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetFileDescriptor$__constructor__(android.os.ParcelFileDescriptor long long android.os.Bundle ), 0, this, parcelFileDescriptor, l, l2, bundle);
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getParcelFileDescriptor", $$robo$$android_content_res_AssetFileDescriptor$getParcelFileDescriptor(), 0, this);
    }

    public FileDescriptor getFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_content_res_AssetFileDescriptor$getFileDescriptor(), 0, this);
    }

    public long getStartOffset() {
        return (long)InvokeDynamicSupport.bootstrap("getStartOffset", $$robo$$android_content_res_AssetFileDescriptor$getStartOffset(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_content_res_AssetFileDescriptor$getExtras(), 0, this);
    }

    public long getLength() {
        return (long)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_content_res_AssetFileDescriptor$getLength(), 0, this);
    }

    public long getDeclaredLength() {
        return (long)InvokeDynamicSupport.bootstrap("getDeclaredLength", $$robo$$android_content_res_AssetFileDescriptor$getDeclaredLength(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_res_AssetFileDescriptor$close(), 0, this);
    }

    public FileInputStream createInputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("createInputStream", $$robo$$android_content_res_AssetFileDescriptor$createInputStream(), 0, this);
    }

    public FileOutputStream createOutputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("createOutputStream", $$robo$$android_content_res_AssetFileDescriptor$createOutputStream(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_res_AssetFileDescriptor$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_res_AssetFileDescriptor$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_res_AssetFileDescriptor$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_res_AssetFileDescriptor$__constructor__(parcel);
    }

    AssetFileDescriptor(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetFileDescriptor$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    static {
        RobolectricInternals.classInitializing(AssetFileDescriptor.class);
    }

    public /* synthetic */ AssetFileDescriptor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssetFileDescriptor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class AutoCloseOutputStream
    extends ParcelFileDescriptor.AutoCloseOutputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mRemaining;

        private void $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$__constructor__(AssetFileDescriptor fd) throws IOException {
            if (fd.getParcelFileDescriptor().seekTo(fd.getStartOffset()) < 0L) {
                throw new IOException("Unable to seek");
            }
            this.mRemaining = (int)fd.getLength();
        }

        private final void $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$write(byte[] buffer, int offset, int count) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                super.write(buffer, offset, count);
                this.mRemaining -= (long)count;
                return;
            }
            super.write(buffer, offset, count);
        }

        private final void $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$write(byte[] buffer) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                int count = buffer.length;
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                super.write(buffer);
                this.mRemaining -= (long)count;
                return;
            }
            super.write(buffer);
        }

        private final void $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$write(int oneByte) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                super.write(oneByte);
                --this.mRemaining;
                return;
            }
            super.write(oneByte);
        }

        private void __constructor__(AssetFileDescriptor assetFileDescriptor) throws IOException {
            this.$$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$__constructor__(assetFileDescriptor);
        }

        public AutoCloseOutputStream(AssetFileDescriptor assetFileDescriptor) throws IOException {
            super(assetFileDescriptor.getParcelFileDescriptor());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$__constructor__(android.content.res.AssetFileDescriptor ), 0, this, assetFileDescriptor);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$write(byte[] ), 0, this, byArray);
        }

        @Override
        public void write(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseOutputStream$write(int ), 0, this, n);
        }

        public /* synthetic */ AutoCloseOutputStream() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutoCloseOutputStream)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AutoCloseInputStream
    extends ParcelFileDescriptor.AutoCloseInputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mRemaining;

        private void $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$__constructor__(AssetFileDescriptor fd) throws IOException {
            super.skip(fd.getStartOffset());
            this.mRemaining = (int)fd.getLength();
        }

        private final int $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$available() throws IOException {
            return this.mRemaining >= 0L ? (this.mRemaining < Integer.MAX_VALUE ? (int)this.mRemaining : Integer.MAX_VALUE) : super.available();
        }

        private final int $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$read() throws IOException {
            byte[] buffer = new byte[1];
            int result = this.read(buffer, 0, 1);
            return result == -1 ? -1 : buffer[0] & 0xFF;
        }

        private final int $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$read(byte[] buffer, int offset, int count) throws IOException {
            if (this.mRemaining >= 0L) {
                int res;
                if (this.mRemaining == 0L) {
                    return -1;
                }
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                if ((res = super.read(buffer, offset, count)) >= 0) {
                    this.mRemaining -= (long)res;
                }
                return res;
            }
            return super.read(buffer, offset, count);
        }

        private final int $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        private final long $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$skip(long count) throws IOException {
            if (this.mRemaining >= 0L) {
                long res;
                if (this.mRemaining == 0L) {
                    return -1L;
                }
                if (count > this.mRemaining) {
                    count = this.mRemaining;
                }
                if ((res = super.skip(count)) >= 0L) {
                    this.mRemaining -= res;
                }
                return res;
            }
            return super.skip(count);
        }

        private final void $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$mark(int readlimit) {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.mark(readlimit);
        }

        private final boolean $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$markSupported() {
            if (this.mRemaining >= 0L) {
                return false;
            }
            return super.markSupported();
        }

        private final synchronized void $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$reset() throws IOException {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.reset();
        }

        private void __constructor__(AssetFileDescriptor assetFileDescriptor) throws IOException {
            this.$$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$__constructor__(assetFileDescriptor);
        }

        public AutoCloseInputStream(AssetFileDescriptor assetFileDescriptor) throws IOException {
            super(assetFileDescriptor.getParcelFileDescriptor());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$__constructor__(android.content.res.AssetFileDescriptor ), 0, this, assetFileDescriptor);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$available(), 0, this);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$read(), 0, this);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$read(byte[] ), 0, this, byArray);
        }

        @Override
        public long skip(long l) throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$skip(long ), 0, this, l);
        }

        @Override
        public void mark(int n) {
            InvokeDynamicSupport.bootstrap("mark", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$mark(int ), 0, this, n);
        }

        @Override
        public boolean markSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("markSupported", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$markSupported(), 0, this);
        }

        @Override
        public synchronized void reset() throws IOException {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_content_res_AssetFileDescriptor_AutoCloseInputStream$reset(), 0, this);
        }

        public /* synthetic */ AutoCloseInputStream() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutoCloseInputStream)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

