/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FallbackCategoryProvider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FallbackCategoryProvider";
    private static ArrayMap<String, Integer> sFallbacks;

    private void $$robo$$android_content_pm_FallbackCategoryProvider$__constructor__() {
    }

    private static final void $$robo$$android_content_pm_FallbackCategoryProvider$loadFallbacks() {
        sFallbacks.clear();
        if (SystemProperties.getBoolean("fw.ignore_fb_categories", false)) {
            Log.d("FallbackCategoryProvider", "Ignoring fallback categories");
            return;
        }
        AssetManager assets = new AssetManager();
        assets.addAssetPath("/system/framework/framework-res.apk");
        Resources res = new Resources(assets, null, null);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(res.openRawResource(0x1100004)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split;
                if (line.charAt(0) == '#' || (split = line.split(",")).length != 2) continue;
                sFallbacks.put(split[0], Integer.parseInt(split[1]));
            }
            Log.d("FallbackCategoryProvider", "Found " + sFallbacks.size() + " fallback categories");
        }
        catch (IOException | NumberFormatException e) {
            Log.w("FallbackCategoryProvider", "Failed to read fallback categories", e);
        }
    }

    private static final int $$robo$$android_content_pm_FallbackCategoryProvider$getFallbackCategory(String packageName) {
        return sFallbacks.getOrDefault(packageName, -1);
    }

    static void __staticInitializer__() {
        sFallbacks = new ArrayMap();
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_FallbackCategoryProvider$__constructor__();
    }

    public FallbackCategoryProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_FallbackCategoryProvider$__constructor__(), 0, this);
    }

    public static void loadFallbacks() {
        InvokeDynamicSupport.bootstrapStatic("loadFallbacks", $$robo$$android_content_pm_FallbackCategoryProvider$loadFallbacks(), 0);
    }

    public static int getFallbackCategory(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFallbackCategory", $$robo$$android_content_pm_FallbackCategoryProvider$getFallbackCategory(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(FallbackCategoryProvider.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FallbackCategoryProvider)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

