/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ContentProviderOperation
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int TYPE_INSERT = 1;
    public static int TYPE_UPDATE = 2;
    public static int TYPE_DELETE = 3;
    public static int TYPE_ASSERT = 4;
    private int mType;
    private Uri mUri;
    private String mSelection;
    private String[] mSelectionArgs;
    private ContentValues mValues;
    private Integer mExpectedCount;
    private ContentValues mValuesBackReferences;
    private Map<Integer, Integer> mSelectionArgsBackReferences;
    private boolean mYieldAllowed;
    private static String TAG = "ContentProviderOperation";
    public static Parcelable.Creator<ContentProviderOperation> CREATOR;

    private void $$robo$$android_content_ContentProviderOperation$__constructor__(Builder builder) {
        this.mType = builder.mType;
        this.mUri = builder.mUri;
        this.mValues = builder.mValues;
        this.mSelection = builder.mSelection;
        this.mSelectionArgs = builder.mSelectionArgs;
        this.mExpectedCount = builder.mExpectedCount;
        this.mSelectionArgsBackReferences = builder.mSelectionArgsBackReferences;
        this.mValuesBackReferences = builder.mValuesBackReferences;
        this.mYieldAllowed = builder.mYieldAllowed;
    }

    private void $$robo$$android_content_ContentProviderOperation$__constructor__(Parcel source) {
        this.mType = source.readInt();
        this.mUri = Uri.CREATOR.createFromParcel(source);
        this.mValues = source.readInt() != 0 ? ContentValues.CREATOR.createFromParcel(source) : null;
        this.mSelection = source.readInt() != 0 ? source.readString() : null;
        this.mSelectionArgs = source.readInt() != 0 ? source.readStringArray() : null;
        this.mExpectedCount = source.readInt() != 0 ? Integer.valueOf(source.readInt()) : null;
        this.mValuesBackReferences = source.readInt() != 0 ? ContentValues.CREATOR.createFromParcel(source) : null;
        HashMap hashMap = this.mSelectionArgsBackReferences = source.readInt() != 0 ? new HashMap() : null;
        if (this.mSelectionArgsBackReferences != null) {
            int count = source.readInt();
            for (int i = 0; i < count; ++i) {
                this.mSelectionArgsBackReferences.put(source.readInt(), source.readInt());
            }
        }
        this.mYieldAllowed = source.readInt() != 0;
    }

    private void $$robo$$android_content_ContentProviderOperation$__constructor__(ContentProviderOperation cpo, boolean removeUserIdFromUri) {
        this.mType = cpo.mType;
        this.mUri = removeUserIdFromUri ? ContentProvider.getUriWithoutUserId(cpo.mUri) : cpo.mUri;
        this.mValues = cpo.mValues;
        this.mSelection = cpo.mSelection;
        this.mSelectionArgs = cpo.mSelectionArgs;
        this.mExpectedCount = cpo.mExpectedCount;
        this.mSelectionArgsBackReferences = cpo.mSelectionArgsBackReferences;
        this.mValuesBackReferences = cpo.mValuesBackReferences;
        this.mYieldAllowed = cpo.mYieldAllowed;
    }

    private final ContentProviderOperation $$robo$$android_content_ContentProviderOperation$getWithoutUserIdInUri() {
        if (ContentProvider.uriHasUserId(this.mUri)) {
            return new ContentProviderOperation(this, true);
        }
        return this;
    }

    private final void $$robo$$android_content_ContentProviderOperation$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        Uri.writeToParcel(dest, this.mUri);
        if (this.mValues != null) {
            dest.writeInt(1);
            this.mValues.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        if (this.mSelection != null) {
            dest.writeInt(1);
            dest.writeString(this.mSelection);
        } else {
            dest.writeInt(0);
        }
        if (this.mSelectionArgs != null) {
            dest.writeInt(1);
            dest.writeStringArray(this.mSelectionArgs);
        } else {
            dest.writeInt(0);
        }
        if (this.mExpectedCount != null) {
            dest.writeInt(1);
            dest.writeInt(this.mExpectedCount);
        } else {
            dest.writeInt(0);
        }
        if (this.mValuesBackReferences != null) {
            dest.writeInt(1);
            this.mValuesBackReferences.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        if (this.mSelectionArgsBackReferences != null) {
            dest.writeInt(1);
            dest.writeInt(this.mSelectionArgsBackReferences.size());
            for (Map.Entry<Integer, Integer> entry : this.mSelectionArgsBackReferences.entrySet()) {
                dest.writeInt(entry.getKey());
                dest.writeInt(entry.getValue());
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mYieldAllowed ? 1 : 0);
    }

    private static final Builder $$robo$$android_content_ContentProviderOperation$newInsert(Uri uri) {
        return new Builder(1, uri);
    }

    private static final Builder $$robo$$android_content_ContentProviderOperation$newUpdate(Uri uri) {
        return new Builder(2, uri);
    }

    private static final Builder $$robo$$android_content_ContentProviderOperation$newDelete(Uri uri) {
        return new Builder(3, uri);
    }

    private static final Builder $$robo$$android_content_ContentProviderOperation$newAssertQuery(Uri uri) {
        return new Builder(4, uri);
    }

    private final Uri $$robo$$android_content_ContentProviderOperation$getUri() {
        return this.mUri;
    }

    private final boolean $$robo$$android_content_ContentProviderOperation$isYieldAllowed() {
        return this.mYieldAllowed;
    }

    private final int $$robo$$android_content_ContentProviderOperation$getType() {
        return this.mType;
    }

    private final boolean $$robo$$android_content_ContentProviderOperation$isInsert() {
        return this.mType == 1;
    }

    private final boolean $$robo$$android_content_ContentProviderOperation$isDelete() {
        return this.mType == 3;
    }

    private final boolean $$robo$$android_content_ContentProviderOperation$isUpdate() {
        return this.mType == 2;
    }

    private final boolean $$robo$$android_content_ContentProviderOperation$isAssertQuery() {
        return this.mType == 4;
    }

    private final boolean $$robo$$android_content_ContentProviderOperation$isWriteOperation() {
        return this.mType == 3 || this.mType == 1 || this.mType == 2;
    }

    private final boolean $$robo$$android_content_ContentProviderOperation$isReadOperation() {
        return this.mType == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ContentProviderResult $$robo$$android_content_ContentProviderOperation$apply(ContentProvider provider, ContentProviderResult[] backRefs, int numBackRefs) throws OperationApplicationException {
        int numRows;
        ContentValues values = this.resolveValueBackReferences(backRefs, numBackRefs);
        String[] selectionArgs = this.resolveSelectionArgsBackReferences(backRefs, numBackRefs);
        if (this.mType == 1) {
            Uri newUri = provider.insert(this.mUri, values);
            if (newUri == null) {
                throw new OperationApplicationException("insert failed");
            }
            return new ContentProviderResult(newUri);
        }
        if (this.mType == 3) {
            numRows = provider.delete(this.mUri, this.mSelection, selectionArgs);
        } else if (this.mType == 2) {
            numRows = provider.update(this.mUri, values, this.mSelection, selectionArgs);
        } else {
            if (this.mType != 4) {
                Log.e("ContentProviderOperation", this.toString());
                throw new IllegalStateException("bad type, " + this.mType);
            }
            String[] projection = null;
            if (values != null) {
                ArrayList<String> projectionList = new ArrayList<String>();
                for (Map.Entry<String, Object> entry : values.valueSet()) {
                    projectionList.add(entry.getKey());
                }
                projection = projectionList.toArray(new String[projectionList.size()]);
            }
            try (Cursor cursor = provider.query(this.mUri, projection, this.mSelection, selectionArgs, null);){
                numRows = cursor.getCount();
                if (projection != null) {
                    while (cursor.moveToNext()) {
                        for (int i = 0; i < projection.length; ++i) {
                            String expectedValue;
                            String cursorValue = cursor.getString(i);
                            if (TextUtils.equals(cursorValue, expectedValue = values.getAsString(projection[i]))) continue;
                            Log.e("ContentProviderOperation", this.toString());
                            throw new OperationApplicationException("Found value " + cursorValue + " when expected " + expectedValue + " for column " + projection[i]);
                        }
                    }
                }
            }
        }
        if (this.mExpectedCount != null && this.mExpectedCount != numRows) {
            Log.e("ContentProviderOperation", this.toString());
            throw new OperationApplicationException("wrong number of rows: " + numRows);
        }
        return new ContentProviderResult(numRows);
    }

    private final ContentValues $$robo$$android_content_ContentProviderOperation$resolveValueBackReferences(ContentProviderResult[] backRefs, int numBackRefs) {
        if (this.mValuesBackReferences == null) {
            return this.mValues;
        }
        ContentValues values = this.mValues == null ? new ContentValues() : new ContentValues(this.mValues);
        for (Map.Entry<String, Object> entry : this.mValuesBackReferences.valueSet()) {
            String key = entry.getKey();
            Integer backRefIndex = this.mValuesBackReferences.getAsInteger(key);
            if (backRefIndex == null) {
                Log.e("ContentProviderOperation", this.toString());
                throw new IllegalArgumentException("values backref " + key + " is not an integer");
            }
            values.put(key, this.backRefToValue(backRefs, numBackRefs, backRefIndex));
        }
        return values;
    }

    private final String[] $$robo$$android_content_ContentProviderOperation$resolveSelectionArgsBackReferences(ContentProviderResult[] backRefs, int numBackRefs) {
        if (this.mSelectionArgsBackReferences == null) {
            return this.mSelectionArgs;
        }
        String[] newArgs = new String[this.mSelectionArgs.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mSelectionArgs, (int)0, (Object)newArgs, (int)0, (int)this.mSelectionArgs.length);
        for (Map.Entry<Integer, Integer> selectionArgBackRef : this.mSelectionArgsBackReferences.entrySet()) {
            Integer selectionArgIndex = selectionArgBackRef.getKey();
            int backRefIndex = selectionArgBackRef.getValue();
            newArgs[selectionArgIndex.intValue()] = String.valueOf(this.backRefToValue(backRefs, numBackRefs, backRefIndex));
        }
        return newArgs;
    }

    private final String $$robo$$android_content_ContentProviderOperation$toString() {
        return "mType: " + this.mType + ", mUri: " + this.mUri + ", mSelection: " + this.mSelection + ", mExpectedCount: " + this.mExpectedCount + ", mYieldAllowed: " + this.mYieldAllowed + ", mValues: " + this.mValues + ", mValuesBackReferences: " + this.mValuesBackReferences + ", mSelectionArgsBackReferences: " + this.mSelectionArgsBackReferences;
    }

    private final long $$robo$$android_content_ContentProviderOperation$backRefToValue(ContentProviderResult[] backRefs, int numBackRefs, Integer backRefIndex) {
        if (backRefIndex >= numBackRefs) {
            Log.e("ContentProviderOperation", this.toString());
            throw new ArrayIndexOutOfBoundsException("asked for back ref " + backRefIndex + " but there are only " + numBackRefs + " back refs");
        }
        ContentProviderResult backRef = backRefs[backRefIndex];
        long backRefValue = backRef.uri != null ? ContentUris.parseId(backRef.uri) : (long)backRef.count.intValue();
        return backRefValue;
    }

    private final int $$robo$$android_content_ContentProviderOperation$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_content_ContentProviderOperation$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_content_ContentProviderOperation$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ContentProviderOperation>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_ContentProviderOperation_1$__constructor__() {
            }

            private final ContentProviderOperation $$robo$$android_content_ContentProviderOperation_1$createFromParcel(Parcel source) {
                return new ContentProviderOperation(source);
            }

            private final ContentProviderOperation[] $$robo$$android_content_ContentProviderOperation_1$newArray(int size) {
                return new ContentProviderOperation[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_ContentProviderOperation_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderOperation_1$__constructor__(), 0, this);
            }

            @Override
            public ContentProviderOperation createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_ContentProviderOperation_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ContentProviderOperation[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_ContentProviderOperation_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_content_ContentProviderOperation$__constructor__(builder);
    }

    private ContentProviderOperation(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderOperation$__constructor__(android.content.ContentProviderOperation$Builder ), 0, this, builder);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_ContentProviderOperation$__constructor__(parcel);
    }

    private ContentProviderOperation(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderOperation$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(ContentProviderOperation contentProviderOperation, boolean bl) {
        this.$$robo$$android_content_ContentProviderOperation$__constructor__(contentProviderOperation, bl);
    }

    public ContentProviderOperation(ContentProviderOperation contentProviderOperation, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderOperation$__constructor__(android.content.ContentProviderOperation boolean ), 0, this, contentProviderOperation, bl);
    }

    public ContentProviderOperation getWithoutUserIdInUri() {
        return InvokeDynamicSupport.bootstrap("getWithoutUserIdInUri", $$robo$$android_content_ContentProviderOperation$getWithoutUserIdInUri(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_ContentProviderOperation$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public static Builder newInsert(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("newInsert", $$robo$$android_content_ContentProviderOperation$newInsert(android.net.Uri ), 0, (Uri)uri);
    }

    public static Builder newUpdate(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("newUpdate", $$robo$$android_content_ContentProviderOperation$newUpdate(android.net.Uri ), 0, (Uri)uri);
    }

    public static Builder newDelete(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("newDelete", $$robo$$android_content_ContentProviderOperation$newDelete(android.net.Uri ), 0, (Uri)uri);
    }

    public static Builder newAssertQuery(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("newAssertQuery", $$robo$$android_content_ContentProviderOperation$newAssertQuery(android.net.Uri ), 0, (Uri)uri);
    }

    public Uri getUri() {
        return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_content_ContentProviderOperation$getUri(), 0, this);
    }

    public boolean isYieldAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isYieldAllowed", $$robo$$android_content_ContentProviderOperation$isYieldAllowed(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_content_ContentProviderOperation$getType(), 0, this);
    }

    public boolean isInsert() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInsert", $$robo$$android_content_ContentProviderOperation$isInsert(), 0, this);
    }

    public boolean isDelete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDelete", $$robo$$android_content_ContentProviderOperation$isDelete(), 0, this);
    }

    public boolean isUpdate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUpdate", $$robo$$android_content_ContentProviderOperation$isUpdate(), 0, this);
    }

    public boolean isAssertQuery() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAssertQuery", $$robo$$android_content_ContentProviderOperation$isAssertQuery(), 0, this);
    }

    public boolean isWriteOperation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWriteOperation", $$robo$$android_content_ContentProviderOperation$isWriteOperation(), 0, this);
    }

    public boolean isReadOperation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReadOperation", $$robo$$android_content_ContentProviderOperation$isReadOperation(), 0, this);
    }

    public ContentProviderResult apply(ContentProvider contentProvider, ContentProviderResult[] contentProviderResultArray, int n) throws OperationApplicationException {
        return InvokeDynamicSupport.bootstrap("apply", $$robo$$android_content_ContentProviderOperation$apply(android.content.ContentProvider android.content.ContentProviderResult[] int ), 0, this, contentProvider, contentProviderResultArray, n);
    }

    public ContentValues resolveValueBackReferences(ContentProviderResult[] contentProviderResultArray, int n) {
        return InvokeDynamicSupport.bootstrap("resolveValueBackReferences", $$robo$$android_content_ContentProviderOperation$resolveValueBackReferences(android.content.ContentProviderResult[] int ), 0, this, contentProviderResultArray, n);
    }

    public String[] resolveSelectionArgsBackReferences(ContentProviderResult[] contentProviderResultArray, int n) {
        return InvokeDynamicSupport.bootstrap("resolveSelectionArgsBackReferences", $$robo$$android_content_ContentProviderOperation$resolveSelectionArgsBackReferences(android.content.ContentProviderResult[] int ), 0, this, contentProviderResultArray, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_ContentProviderOperation$toString(), 0, this);
    }

    private long backRefToValue(ContentProviderResult[] contentProviderResultArray, int n, Integer n2) {
        return (long)InvokeDynamicSupport.bootstrap("backRefToValue", $$robo$$android_content_ContentProviderOperation$backRefToValue(android.content.ContentProviderResult[] int java.lang.Integer ), 0, this, contentProviderResultArray, n, n2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_ContentProviderOperation$describeContents(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_ContentProviderOperation$__constructor__(parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_content_ContentProviderOperation$__constructor__(builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ContentProviderOperation.class);
    }

    public /* synthetic */ ContentProviderOperation() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentProviderOperation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mType;
        private Uri mUri;
        private String mSelection;
        private String[] mSelectionArgs;
        private ContentValues mValues;
        private Integer mExpectedCount;
        private ContentValues mValuesBackReferences;
        private Map<Integer, Integer> mSelectionArgsBackReferences;
        private boolean mYieldAllowed;

        private void $$robo$$android_content_ContentProviderOperation_Builder$__constructor__(int type, Uri uri) {
            if (uri == null) {
                throw new IllegalArgumentException("uri must not be null");
            }
            this.mType = type;
            this.mUri = uri;
        }

        private final ContentProviderOperation $$robo$$android_content_ContentProviderOperation_Builder$build() {
            if (this.mType == 2 && (this.mValues == null || this.mValues.isEmpty()) && (this.mValuesBackReferences == null || this.mValuesBackReferences.isEmpty())) {
                throw new IllegalArgumentException("Empty values");
            }
            if (this.mType == 4 && (this.mValues == null || this.mValues.isEmpty()) && (this.mValuesBackReferences == null || this.mValuesBackReferences.isEmpty()) && this.mExpectedCount == null) {
                throw new IllegalArgumentException("Empty values");
            }
            return new ContentProviderOperation(this);
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withValueBackReferences(ContentValues backReferences) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have value back-references");
            }
            this.mValuesBackReferences = backReferences;
            return this;
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withValueBackReference(String key, int previousResult) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have value back-references");
            }
            if (this.mValuesBackReferences == null) {
                this.mValuesBackReferences = new ContentValues();
            }
            this.mValuesBackReferences.put(key, previousResult);
            return this;
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withSelectionBackReference(int selectionArgIndex, int previousResult) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have selection back-references");
            }
            if (this.mSelectionArgsBackReferences == null) {
                this.mSelectionArgsBackReferences = new HashMap<Integer, Integer>();
            }
            this.mSelectionArgsBackReferences.put(selectionArgIndex, previousResult);
            return this;
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withValues(ContentValues values) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have values");
            }
            if (this.mValues == null) {
                this.mValues = new ContentValues();
            }
            this.mValues.putAll(values);
            return this;
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withValue(String key, Object value) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts and updates can have values");
            }
            if (this.mValues == null) {
                this.mValues = new ContentValues();
            }
            if (value == null) {
                this.mValues.putNull(key);
            } else if (value instanceof String) {
                this.mValues.put(key, (String)value);
            } else if (value instanceof Byte) {
                this.mValues.put(key, (Byte)value);
            } else if (value instanceof Short) {
                this.mValues.put(key, (Short)value);
            } else if (value instanceof Integer) {
                this.mValues.put(key, (Integer)value);
            } else if (value instanceof Long) {
                this.mValues.put(key, (Long)value);
            } else if (value instanceof Float) {
                this.mValues.put(key, (Float)value);
            } else if (value instanceof Double) {
                this.mValues.put(key, (Double)value);
            } else if (value instanceof Boolean) {
                this.mValues.put(key, (Boolean)value);
            } else if (value instanceof byte[]) {
                this.mValues.put(key, (byte[])value);
            } else {
                throw new IllegalArgumentException("bad value type: " + value.getClass().getName());
            }
            return this;
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withSelection(String selection, String[] selectionArgs) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have selections");
            }
            this.mSelection = selection;
            if (selectionArgs == null) {
                this.mSelectionArgs = null;
            } else {
                this.mSelectionArgs = new String[selectionArgs.length];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)selectionArgs, (int)0, (Object)this.mSelectionArgs, (int)0, (int)selectionArgs.length);
            }
            return this;
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withExpectedCount(int count) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have expected counts");
            }
            this.mExpectedCount = count;
            return this;
        }

        private final Builder $$robo$$android_content_ContentProviderOperation_Builder$withYieldAllowed(boolean yieldAllowed) {
            this.mYieldAllowed = yieldAllowed;
            return this;
        }

        private /* synthetic */ void $$robo$$android_content_ContentProviderOperation_Builder$__constructor__(int x0, Uri x1, 1 x2) {
        }

        private void __constructor__(int n, Uri uri) {
            this.$$robo$$android_content_ContentProviderOperation_Builder$__constructor__(n, uri);
        }

        private Builder(int n, Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderOperation_Builder$__constructor__(int android.net.Uri ), 0, this, n, uri);
        }

        public ContentProviderOperation build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_content_ContentProviderOperation_Builder$build(), 0, this);
        }

        public Builder withValueBackReferences(ContentValues contentValues) {
            return InvokeDynamicSupport.bootstrap("withValueBackReferences", $$robo$$android_content_ContentProviderOperation_Builder$withValueBackReferences(android.content.ContentValues ), 0, this, contentValues);
        }

        public Builder withValueBackReference(String string2, int n) {
            return InvokeDynamicSupport.bootstrap("withValueBackReference", $$robo$$android_content_ContentProviderOperation_Builder$withValueBackReference(java.lang.String int ), 0, this, string2, n);
        }

        public Builder withSelectionBackReference(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("withSelectionBackReference", $$robo$$android_content_ContentProviderOperation_Builder$withSelectionBackReference(int int ), 0, this, n, n2);
        }

        public Builder withValues(ContentValues contentValues) {
            return InvokeDynamicSupport.bootstrap("withValues", $$robo$$android_content_ContentProviderOperation_Builder$withValues(android.content.ContentValues ), 0, this, contentValues);
        }

        public Builder withValue(String string2, Object object) {
            return InvokeDynamicSupport.bootstrap("withValue", $$robo$$android_content_ContentProviderOperation_Builder$withValue(java.lang.String java.lang.Object ), 0, this, string2, object);
        }

        public Builder withSelection(String string2, String[] stringArray) {
            return InvokeDynamicSupport.bootstrap("withSelection", $$robo$$android_content_ContentProviderOperation_Builder$withSelection(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
        }

        public Builder withExpectedCount(int n) {
            return InvokeDynamicSupport.bootstrap("withExpectedCount", $$robo$$android_content_ContentProviderOperation_Builder$withExpectedCount(int ), 0, this, n);
        }

        public Builder withYieldAllowed(boolean bl) {
            return InvokeDynamicSupport.bootstrap("withYieldAllowed", $$robo$$android_content_ContentProviderOperation_Builder$withYieldAllowed(boolean ), 0, this, bl);
        }

        private /* synthetic */ void __constructor__(int n, Uri uri, 1 var3_3) {
            this.$$robo$$android_content_ContentProviderOperation_Builder$__constructor__(n, uri, var3_3);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

