/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.AppOpsManager;
import android.content.ClipDescription;
import android.content.ComponentCallbacks2;
import android.content.ContentProviderNative;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ContentProvider
implements ComponentCallbacks2,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ContentProvider";
    private Context mContext;
    private int mMyUid;
    private String mAuthority;
    private String[] mAuthorities;
    private String mReadPermission;
    private String mWritePermission;
    private PathPermission[] mPathPermissions;
    private boolean mExported;
    private boolean mNoPerms;
    private boolean mSingleUser;
    private ThreadLocal<String> mCallingPackage;
    private Transport mTransport;

    private void $$robo$$android_content_ContentProvider$__constructor__() {
        this.mContext = null;
        this.mCallingPackage = new ThreadLocal();
        this.mTransport = new Transport(this);
    }

    private void $$robo$$android_content_ContentProvider$__constructor__(Context context, String readPermission, String writePermission, PathPermission[] pathPermissions) {
        this.mContext = null;
        this.mCallingPackage = new ThreadLocal();
        this.mTransport = new Transport(this);
        this.mContext = context;
        this.mReadPermission = readPermission;
        this.mWritePermission = writePermission;
        this.mPathPermissions = pathPermissions;
    }

    private static final ContentProvider $$robo$$android_content_ContentProvider$coerceToLocalContentProvider(IContentProvider abstractInterface) {
        if (abstractInterface instanceof Transport) {
            return ((Transport)abstractInterface).getContentProvider();
        }
        return null;
    }

    private final boolean $$robo$$android_content_ContentProvider$checkUser(int pid, int uid, Context context) {
        return UserHandle.getUserId(uid) == context.getUserId() || this.mSingleUser || context.checkPermission("android.permission.INTERACT_ACROSS_USERS", pid, uid) == 0;
    }

    private final int $$robo$$android_content_ContentProvider$checkPermissionAndAppOp(String permission2, String callingPkg, IBinder callerToken) {
        if (this.getContext().checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid(), callerToken) != 0) {
            return 2;
        }
        int permOp = AppOpsManager.permissionToOpCode(permission2);
        if (permOp != -1) {
            return this.mTransport.mAppOpsManager.noteProxyOp(permOp, callingPkg);
        }
        return 0;
    }

    private final int $$robo$$android_content_ContentProvider$enforceReadPermissionInner(Uri uri, String callingPkg, IBinder callerToken) throws SecurityException {
        Uri userUri;
        Context context = this.getContext();
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        String missingPerm = null;
        int strongestMode = 0;
        if (UserHandle.isSameApp(uid, this.mMyUid)) {
            return 0;
        }
        if (this.mExported && this.checkUser(pid, uid, context)) {
            String componentPerm = this.getReadPermission();
            if (componentPerm != null) {
                int mode = this.checkPermissionAndAppOp(componentPerm, callingPkg, callerToken);
                if (mode == 0) {
                    return 0;
                }
                missingPerm = componentPerm;
                strongestMode = Math.max(strongestMode, mode);
            }
            boolean allowDefaultRead = componentPerm == null;
            PathPermission[] pps = this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                for (PathPermission pp : pps) {
                    String pathPerm = pp.getReadPermission();
                    if (pathPerm == null || !pp.match(path)) continue;
                    int mode = this.checkPermissionAndAppOp(pathPerm, callingPkg, callerToken);
                    if (mode == 0) {
                        return 0;
                    }
                    allowDefaultRead = false;
                    missingPerm = pathPerm;
                    strongestMode = Math.max(strongestMode, mode);
                }
            }
            if (allowDefaultRead) {
                return 0;
            }
        }
        int callingUserId = UserHandle.getUserId(uid);
        Uri uri2 = userUri = this.mSingleUser && !UserHandle.isSameUser(this.mMyUid, uid) ? ContentProvider.maybeAddUserId(uri, callingUserId) : uri;
        if (context.checkUriPermission(userUri, pid, uid, 1, callerToken) == 0) {
            return 0;
        }
        if (strongestMode == 1) {
            return 1;
        }
        String suffix = "android.permission.MANAGE_DOCUMENTS".equals(this.mReadPermission) ? " requires that you obtain access using ACTION_OPEN_DOCUMENT or related APIs" : (this.mExported ? " requires " + missingPerm + ", or grantUriPermission()" : " requires the provider be exported, or grantUriPermission()");
        throw new SecurityException("Permission Denial: reading " + this.getClass().getName() + " uri " + uri + " from pid=" + pid + ", uid=" + uid + suffix);
    }

    private final int $$robo$$android_content_ContentProvider$enforceWritePermissionInner(Uri uri, String callingPkg, IBinder callerToken) throws SecurityException {
        Context context = this.getContext();
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        String missingPerm = null;
        int strongestMode = 0;
        if (UserHandle.isSameApp(uid, this.mMyUid)) {
            return 0;
        }
        if (this.mExported && this.checkUser(pid, uid, context)) {
            String componentPerm = this.getWritePermission();
            if (componentPerm != null) {
                int mode = this.checkPermissionAndAppOp(componentPerm, callingPkg, callerToken);
                if (mode == 0) {
                    return 0;
                }
                missingPerm = componentPerm;
                strongestMode = Math.max(strongestMode, mode);
            }
            boolean allowDefaultWrite = componentPerm == null;
            PathPermission[] pps = this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                for (PathPermission pp : pps) {
                    String pathPerm = pp.getWritePermission();
                    if (pathPerm == null || !pp.match(path)) continue;
                    int mode = this.checkPermissionAndAppOp(pathPerm, callingPkg, callerToken);
                    if (mode == 0) {
                        return 0;
                    }
                    allowDefaultWrite = false;
                    missingPerm = pathPerm;
                    strongestMode = Math.max(strongestMode, mode);
                }
            }
            if (allowDefaultWrite) {
                return 0;
            }
        }
        if (context.checkUriPermission(uri, pid, uid, 2, callerToken) == 0) {
            return 0;
        }
        if (strongestMode == 1) {
            return 1;
        }
        String failReason = this.mExported ? " requires " + missingPerm + ", or grantUriPermission()" : " requires the provider be exported, or grantUriPermission()";
        throw new SecurityException("Permission Denial: writing " + this.getClass().getName() + " uri " + uri + " from pid=" + pid + ", uid=" + uid + failReason);
    }

    private final Context $$robo$$android_content_ContentProvider$getContext() {
        return this.mContext;
    }

    private final String $$robo$$android_content_ContentProvider$setCallingPackage(String callingPackage) {
        String original = this.mCallingPackage.get();
        this.mCallingPackage.set(callingPackage);
        return original;
    }

    private final String $$robo$$android_content_ContentProvider$getCallingPackage() {
        String pkg = this.mCallingPackage.get();
        if (pkg != null) {
            this.mTransport.mAppOpsManager.checkPackage(Binder.getCallingUid(), pkg);
        }
        return pkg;
    }

    private final void $$robo$$android_content_ContentProvider$setAuthorities(String authorities) {
        if (authorities != null) {
            if (authorities.indexOf(59) == -1) {
                this.mAuthority = authorities;
                this.mAuthorities = null;
            } else {
                this.mAuthority = null;
                this.mAuthorities = authorities.split(";");
            }
        }
    }

    private final boolean $$robo$$android_content_ContentProvider$matchesOurAuthorities(String authority) {
        if (this.mAuthority != null) {
            return this.mAuthority.equals(authority);
        }
        if (this.mAuthorities != null) {
            int length = this.mAuthorities.length;
            for (int i = 0; i < length; ++i) {
                if (!this.mAuthorities[i].equals(authority)) continue;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_content_ContentProvider$setReadPermission(String permission2) {
        this.mReadPermission = permission2;
    }

    private final String $$robo$$android_content_ContentProvider$getReadPermission() {
        return this.mReadPermission;
    }

    private final void $$robo$$android_content_ContentProvider$setWritePermission(String permission2) {
        this.mWritePermission = permission2;
    }

    private final String $$robo$$android_content_ContentProvider$getWritePermission() {
        return this.mWritePermission;
    }

    private final void $$robo$$android_content_ContentProvider$setPathPermissions(PathPermission[] permissions) {
        this.mPathPermissions = permissions;
    }

    private final PathPermission[] $$robo$$android_content_ContentProvider$getPathPermissions() {
        return this.mPathPermissions;
    }

    private final void $$robo$$android_content_ContentProvider$setAppOps(int readOp, int writeOp) {
        if (!this.mNoPerms) {
            this.mTransport.mReadOp = readOp;
            this.mTransport.mWriteOp = writeOp;
        }
    }

    private final AppOpsManager $$robo$$android_content_ContentProvider$getAppOpsManager() {
        return this.mTransport.mAppOpsManager;
    }

    public abstract boolean onCreate();

    private final void $$robo$$android_content_ContentProvider$onConfigurationChanged(Configuration newConfig) {
    }

    private final void $$robo$$android_content_ContentProvider$onLowMemory() {
    }

    private final void $$robo$$android_content_ContentProvider$onTrimMemory(int level) {
    }

    public abstract Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5);

    private final Cursor $$robo$$android_content_ContentProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder);
    }

    private final Cursor $$robo$$android_content_ContentProvider$query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        String sortClause = (queryArgs = queryArgs != null ? queryArgs : Bundle.EMPTY).getString("android:query-arg-sql-sort-order");
        if (sortClause == null && queryArgs.containsKey("android:query-arg-sort-columns")) {
            sortClause = ContentResolver.createSqlSortClause(queryArgs);
        }
        return this.query(uri, projection, queryArgs.getString("android:query-arg-sql-selection"), queryArgs.getStringArray("android:query-arg-sql-selection-args"), sortClause, cancellationSignal);
    }

    public abstract String getType(Uri var1);

    private final Uri $$robo$$android_content_ContentProvider$canonicalize(Uri url) {
        return null;
    }

    private final Uri $$robo$$android_content_ContentProvider$uncanonicalize(Uri url) {
        return url;
    }

    private final boolean $$robo$$android_content_ContentProvider$refresh(Uri uri, Bundle args, CancellationSignal cancellationSignal) {
        return false;
    }

    private final Uri $$robo$$android_content_ContentProvider$rejectInsert(Uri uri, ContentValues values) {
        return uri.buildUpon().appendPath("0").build();
    }

    public abstract Uri insert(Uri var1, ContentValues var2);

    private final int $$robo$$android_content_ContentProvider$bulkInsert(Uri uri, ContentValues[] values) {
        int numValues = values.length;
        for (int i = 0; i < numValues; ++i) {
            this.insert(uri, values[i]);
        }
        return numValues;
    }

    public abstract int delete(Uri var1, String var2, String[] var3);

    public abstract int update(Uri var1, ContentValues var2, String var3, String[] var4);

    private final ParcelFileDescriptor $$robo$$android_content_ContentProvider$openFile(Uri uri, String mode) throws FileNotFoundException {
        throw new FileNotFoundException("No files supported by provider at " + uri);
    }

    private final ParcelFileDescriptor $$robo$$android_content_ContentProvider$openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        return this.openFile(uri, mode);
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProvider$openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor fd = this.openFile(uri, mode);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProvider$openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        return this.openAssetFile(uri, mode);
    }

    private final ParcelFileDescriptor $$robo$$android_content_ContentProvider$openFileHelper(Uri uri, String mode) throws FileNotFoundException {
        int count;
        Cursor c = this.query(uri, new String[]{"_data"}, null, null, null);
        int n = count = c != null ? c.getCount() : 0;
        if (count != 1) {
            if (c != null) {
                c.close();
            }
            if (count == 0) {
                throw new FileNotFoundException("No entry for " + uri);
            }
            throw new FileNotFoundException("Multiple items at " + uri);
        }
        c.moveToFirst();
        int i = c.getColumnIndex("_data");
        String path = i >= 0 ? c.getString(i) : null;
        c.close();
        if (path == null) {
            throw new FileNotFoundException("Column _data not found.");
        }
        int modeBits = ParcelFileDescriptor.parseMode(mode);
        return ParcelFileDescriptor.open(new File(path), modeBits);
    }

    private final String[] $$robo$$android_content_ContentProvider$getStreamTypes(Uri uri, String mimeTypeFilter) {
        return null;
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProvider$openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        if ("*/*".equals(mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        String baseType = this.getType(uri);
        if (baseType != null && ClipDescription.compareMimeTypes(baseType, mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        throw new FileNotFoundException("Can't open " + uri + " as type " + mimeTypeFilter);
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProvider$openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        return this.openTypedAssetFile(uri, mimeTypeFilter, opts);
    }

    private final <T> ParcelFileDescriptor $$robo$$android_content_ContentProvider$openPipeHelper(Uri uri, String mimeType, Bundle opts, T args, PipeDataWriter<T> func) throws FileNotFoundException {
        try {
            ParcelFileDescriptor[] fds = ParcelFileDescriptor.createPipe();
            AsyncTask<Object, Object, Object> task = new AsyncTask<Object, Object, Object>(this, func, fds, uri, mimeType, opts, args){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ PipeDataWriter val$func;
                /* synthetic */ ParcelFileDescriptor[] val$fds;
                /* synthetic */ Uri val$uri;
                /* synthetic */ String val$mimeType;
                /* synthetic */ Bundle val$opts;
                /* synthetic */ Object val$args;
                /* synthetic */ ContentProvider this$0;

                private void $$robo$$android_content_ContentProvider_1$__constructor__(ContentProvider this$0, PipeDataWriter pipeDataWriter, ParcelFileDescriptor[] parcelFileDescriptorArray, Uri uri, String string2, Bundle bundle, Object object) {
                }

                private final Object $$robo$$android_content_ContentProvider_1$doInBackground(Object ... params) {
                    this.val$func.writeDataToPipe(this.val$fds[1], this.val$uri, this.val$mimeType, this.val$opts, this.val$args);
                    try {
                        this.val$fds[1].close();
                    }
                    catch (IOException e) {
                        Log.w("ContentProvider", "Failure closing pipe", e);
                    }
                    return null;
                }

                private void __constructor__(ContentProvider contentProvider, PipeDataWriter pipeDataWriter, ParcelFileDescriptor[] parcelFileDescriptorArray, Uri uri, String string2, Bundle bundle, Object object) {
                    this.$$robo$$android_content_ContentProvider_1$__constructor__(contentProvider, pipeDataWriter, parcelFileDescriptorArray, uri, string2, bundle, object);
                }
                {
                    this.this$0 = contentProvider;
                    this.val$func = pipeDataWriter;
                    this.val$fds = parcelFileDescriptorArray;
                    this.val$uri = uri;
                    this.val$mimeType = string2;
                    this.val$opts = bundle;
                    this.val$args = object;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProvider_1$__constructor__(android.content.ContentProvider android.content.ContentProvider$PipeDataWriter android.os.ParcelFileDescriptor[] android.net.Uri java.lang.String android.os.Bundle java.lang.Object ), 0, this, contentProvider, pipeDataWriter, parcelFileDescriptorArray, uri, string2, bundle, object);
                }

                @Override
                protected Object doInBackground(Object ... objectArray) {
                    return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_content_ContentProvider_1$doInBackground(java.lang.Object[] ), 0, this, objectArray);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            return fds[0];
        }
        catch (IOException e) {
            throw new FileNotFoundException("failure making pipe");
        }
    }

    private final boolean $$robo$$android_content_ContentProvider$isTemporary() {
        return false;
    }

    private final IContentProvider $$robo$$android_content_ContentProvider$getIContentProvider() {
        return this.mTransport;
    }

    private final void $$robo$$android_content_ContentProvider$attachInfoForTesting(Context context, ProviderInfo info) {
        this.attachInfo(context, info, true);
    }

    private final void $$robo$$android_content_ContentProvider$attachInfo(Context context, ProviderInfo info) {
        this.attachInfo(context, info, false);
    }

    private final void $$robo$$android_content_ContentProvider$attachInfo(Context context, ProviderInfo info, boolean testing) {
        this.mNoPerms = testing;
        if (this.mContext == null) {
            this.mContext = context;
            if (context != null) {
                this.mTransport.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
            }
            this.mMyUid = Process.myUid();
            if (info != null) {
                this.setReadPermission(info.readPermission);
                this.setWritePermission(info.writePermission);
                this.setPathPermissions(info.pathPermissions);
                this.mExported = info.exported;
                this.mSingleUser = (info.flags & 0x40000000) != 0;
                this.setAuthorities(info.authority);
            }
            this.onCreate();
        }
    }

    private final ContentProviderResult[] $$robo$$android_content_ContentProvider$applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        int numOperations = operations.size();
        ContentProviderResult[] results = new ContentProviderResult[numOperations];
        for (int i = 0; i < numOperations; ++i) {
            results[i] = operations.get(i).apply(this, results, i);
        }
        return results;
    }

    private final Bundle $$robo$$android_content_ContentProvider$call(String method, String arg, Bundle extras) {
        return null;
    }

    private final void $$robo$$android_content_ContentProvider$shutdown() {
        Log.w("ContentProvider", "implement ContentProvider shutdown() to make sure all database connections are gracefully shutdown");
    }

    private final void $$robo$$android_content_ContentProvider$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.println("nothing to dump");
    }

    private final void $$robo$$android_content_ContentProvider$validateIncomingUri(Uri uri) throws SecurityException {
        int userId;
        String auth = uri.getAuthority();
        if (!this.mSingleUser && (userId = ContentProvider.getUserIdFromAuthority(auth, -2)) != -2 && userId != this.mContext.getUserId()) {
            throw new SecurityException("trying to query a ContentProvider in user " + this.mContext.getUserId() + " with a uri belonging to user " + userId);
        }
        if (!this.matchesOurAuthorities(ContentProvider.getAuthorityWithoutUserId(auth))) {
            String message = "The authority of the uri " + uri + " does not match the one of the contentProvider: ";
            message = this.mAuthority != null ? message + this.mAuthority : message + Arrays.toString(this.mAuthorities);
            throw new SecurityException(message);
        }
    }

    private final Uri $$robo$$android_content_ContentProvider$maybeGetUriWithoutUserId(Uri uri) {
        if (this.mSingleUser) {
            return uri;
        }
        return ContentProvider.getUriWithoutUserId(uri);
    }

    private static final int $$robo$$android_content_ContentProvider$getUserIdFromAuthority(String auth, int defaultUserId) {
        if (auth == null) {
            return defaultUserId;
        }
        int end = auth.lastIndexOf(64);
        if (end == -1) {
            return defaultUserId;
        }
        String userIdString = auth.substring(0, end);
        try {
            return Integer.parseInt(userIdString);
        }
        catch (NumberFormatException e) {
            Log.w("ContentProvider", "Error parsing userId.", e);
            return -10000;
        }
    }

    private static final int $$robo$$android_content_ContentProvider$getUserIdFromAuthority(String auth) {
        return ContentProvider.getUserIdFromAuthority(auth, -2);
    }

    private static final int $$robo$$android_content_ContentProvider$getUserIdFromUri(Uri uri, int defaultUserId) {
        if (uri == null) {
            return defaultUserId;
        }
        return ContentProvider.getUserIdFromAuthority(uri.getAuthority(), defaultUserId);
    }

    private static final int $$robo$$android_content_ContentProvider$getUserIdFromUri(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, -2);
    }

    private static final String $$robo$$android_content_ContentProvider$getAuthorityWithoutUserId(String auth) {
        if (auth == null) {
            return null;
        }
        int end = auth.lastIndexOf(64);
        return auth.substring(end + 1);
    }

    private static final Uri $$robo$$android_content_ContentProvider$getUriWithoutUserId(Uri uri) {
        if (uri == null) {
            return null;
        }
        Uri.Builder builder = uri.buildUpon();
        builder.authority(ContentProvider.getAuthorityWithoutUserId(uri.getAuthority()));
        return builder.build();
    }

    private static final boolean $$robo$$android_content_ContentProvider$uriHasUserId(Uri uri) {
        if (uri == null) {
            return false;
        }
        return !TextUtils.isEmpty(uri.getUserInfo());
    }

    private static final Uri $$robo$$android_content_ContentProvider$maybeAddUserId(Uri uri, int userId) {
        if (uri == null) {
            return null;
        }
        if (userId != -2 && "content".equals(uri.getScheme()) && !ContentProvider.uriHasUserId(uri)) {
            Uri.Builder builder = uri.buildUpon();
            builder.encodedAuthority("" + userId + "@" + uri.getEncodedAuthority());
            return builder.build();
        }
        return uri;
    }

    private void __constructor__() {
        this.$$robo$$android_content_ContentProvider$__constructor__();
    }

    public ContentProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProvider$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, String string2, String string3, PathPermission[] pathPermissionArray) {
        this.$$robo$$android_content_ContentProvider$__constructor__(context, string2, string3, pathPermissionArray);
    }

    public ContentProvider(Context context, String string2, String string3, PathPermission[] pathPermissionArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProvider$__constructor__(android.content.Context java.lang.String java.lang.String android.content.pm.PathPermission[] ), 0, this, context, string2, string3, pathPermissionArray);
    }

    public static ContentProvider coerceToLocalContentProvider(IContentProvider iContentProvider) {
        return InvokeDynamicSupport.bootstrapStatic("coerceToLocalContentProvider", $$robo$$android_content_ContentProvider$coerceToLocalContentProvider(android.content.IContentProvider ), 0, (IContentProvider)iContentProvider);
    }

    boolean checkUser(int n, int n2, Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkUser", $$robo$$android_content_ContentProvider$checkUser(int int android.content.Context ), 0, this, n, n2, context);
    }

    private int checkPermissionAndAppOp(String string2, String string3, IBinder iBinder) {
        return (int)InvokeDynamicSupport.bootstrap("checkPermissionAndAppOp", $$robo$$android_content_ContentProvider$checkPermissionAndAppOp(java.lang.String java.lang.String android.os.IBinder ), 0, this, string2, string3, iBinder);
    }

    protected int enforceReadPermissionInner(Uri uri, String string2, IBinder iBinder) throws SecurityException {
        return (int)InvokeDynamicSupport.bootstrap("enforceReadPermissionInner", $$robo$$android_content_ContentProvider$enforceReadPermissionInner(android.net.Uri java.lang.String android.os.IBinder ), 0, this, uri, string2, iBinder);
    }

    protected int enforceWritePermissionInner(Uri uri, String string2, IBinder iBinder) throws SecurityException {
        return (int)InvokeDynamicSupport.bootstrap("enforceWritePermissionInner", $$robo$$android_content_ContentProvider$enforceWritePermissionInner(android.net.Uri java.lang.String android.os.IBinder ), 0, this, uri, string2, iBinder);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_content_ContentProvider$getContext(), 0, this);
    }

    private String setCallingPackage(String string2) {
        return InvokeDynamicSupport.bootstrap("setCallingPackage", $$robo$$android_content_ContentProvider$setCallingPackage(java.lang.String ), 0, this, string2);
    }

    public String getCallingPackage() {
        return InvokeDynamicSupport.bootstrap("getCallingPackage", $$robo$$android_content_ContentProvider$getCallingPackage(), 0, this);
    }

    protected void setAuthorities(String string2) {
        InvokeDynamicSupport.bootstrap("setAuthorities", $$robo$$android_content_ContentProvider$setAuthorities(java.lang.String ), 0, this, string2);
    }

    protected boolean matchesOurAuthorities(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesOurAuthorities", $$robo$$android_content_ContentProvider$matchesOurAuthorities(java.lang.String ), 0, this, string2);
    }

    protected void setReadPermission(String string2) {
        InvokeDynamicSupport.bootstrap("setReadPermission", $$robo$$android_content_ContentProvider$setReadPermission(java.lang.String ), 0, this, string2);
    }

    public String getReadPermission() {
        return InvokeDynamicSupport.bootstrap("getReadPermission", $$robo$$android_content_ContentProvider$getReadPermission(), 0, this);
    }

    protected void setWritePermission(String string2) {
        InvokeDynamicSupport.bootstrap("setWritePermission", $$robo$$android_content_ContentProvider$setWritePermission(java.lang.String ), 0, this, string2);
    }

    public String getWritePermission() {
        return InvokeDynamicSupport.bootstrap("getWritePermission", $$robo$$android_content_ContentProvider$getWritePermission(), 0, this);
    }

    protected void setPathPermissions(PathPermission[] pathPermissionArray) {
        InvokeDynamicSupport.bootstrap("setPathPermissions", $$robo$$android_content_ContentProvider$setPathPermissions(android.content.pm.PathPermission[] ), 0, this, pathPermissionArray);
    }

    public PathPermission[] getPathPermissions() {
        return InvokeDynamicSupport.bootstrap("getPathPermissions", $$robo$$android_content_ContentProvider$getPathPermissions(), 0, this);
    }

    public void setAppOps(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setAppOps", $$robo$$android_content_ContentProvider$setAppOps(int int ), 0, this, n, n2);
    }

    public AppOpsManager getAppOpsManager() {
        return InvokeDynamicSupport.bootstrap("getAppOpsManager", $$robo$$android_content_ContentProvider$getAppOpsManager(), 0, this);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_content_ContentProvider$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public void onLowMemory() {
        InvokeDynamicSupport.bootstrap("onLowMemory", $$robo$$android_content_ContentProvider$onLowMemory(), 0, this);
    }

    @Override
    public void onTrimMemory(int n) {
        InvokeDynamicSupport.bootstrap("onTrimMemory", $$robo$$android_content_ContentProvider$onTrimMemory(int ), 0, this, n);
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String android.os.CancellationSignal ), 0, this, uri, stringArray, string2, stringArray2, string3, cancellationSignal);
    }

    public Cursor query(Uri uri, String[] stringArray, Bundle bundle, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentProvider$query(android.net.Uri java.lang.String[] android.os.Bundle android.os.CancellationSignal ), 0, this, uri, stringArray, bundle, cancellationSignal);
    }

    public Uri canonicalize(Uri uri) {
        return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_content_ContentProvider$canonicalize(android.net.Uri ), 0, this, uri);
    }

    public Uri uncanonicalize(Uri uri) {
        return InvokeDynamicSupport.bootstrap("uncanonicalize", $$robo$$android_content_ContentProvider$uncanonicalize(android.net.Uri ), 0, this, uri);
    }

    public boolean refresh(Uri uri, Bundle bundle, CancellationSignal cancellationSignal) {
        return (boolean)InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_content_ContentProvider$refresh(android.net.Uri android.os.Bundle android.os.CancellationSignal ), 0, this, uri, bundle, cancellationSignal);
    }

    public Uri rejectInsert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("rejectInsert", $$robo$$android_content_ContentProvider$rejectInsert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        return (int)InvokeDynamicSupport.bootstrap("bulkInsert", $$robo$$android_content_ContentProvider$bulkInsert(android.net.Uri android.content.ContentValues[] ), 0, this, uri, contentValuesArray);
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_content_ContentProvider$openFile(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_content_ContentProvider$openFile(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_content_ContentProvider$openAssetFile(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_content_ContentProvider$openAssetFile(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    protected ParcelFileDescriptor openFileHelper(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFileHelper", $$robo$$android_content_ContentProvider$openFileHelper(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public String[] getStreamTypes(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrap("getStreamTypes", $$robo$$android_content_ContentProvider$getStreamTypes(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFile", $$robo$$android_content_ContentProvider$openTypedAssetFile(android.net.Uri java.lang.String android.os.Bundle ), 0, this, uri, string2, bundle);
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFile", $$robo$$android_content_ContentProvider$openTypedAssetFile(android.net.Uri java.lang.String android.os.Bundle android.os.CancellationSignal ), 0, this, uri, string2, bundle, cancellationSignal);
    }

    public <T> ParcelFileDescriptor openPipeHelper(Uri uri, String string2, Bundle bundle, T t, PipeDataWriter<T> pipeDataWriter) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openPipeHelper", $$robo$$android_content_ContentProvider$openPipeHelper(android.net.Uri java.lang.String android.os.Bundle T android.content.ContentProvider$PipeDataWriter<T> ), 0, this, uri, string2, bundle, t, pipeDataWriter);
    }

    protected boolean isTemporary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTemporary", $$robo$$android_content_ContentProvider$isTemporary(), 0, this);
    }

    public IContentProvider getIContentProvider() {
        return InvokeDynamicSupport.bootstrap("getIContentProvider", $$robo$$android_content_ContentProvider$getIContentProvider(), 0, this);
    }

    public void attachInfoForTesting(Context context, ProviderInfo providerInfo) {
        InvokeDynamicSupport.bootstrap("attachInfoForTesting", $$robo$$android_content_ContentProvider$attachInfoForTesting(android.content.Context android.content.pm.ProviderInfo ), 0, this, context, providerInfo);
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        InvokeDynamicSupport.bootstrap("attachInfo", $$robo$$android_content_ContentProvider$attachInfo(android.content.Context android.content.pm.ProviderInfo ), 0, this, context, providerInfo);
    }

    private void attachInfo(Context context, ProviderInfo providerInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("attachInfo", $$robo$$android_content_ContentProvider$attachInfo(android.content.Context android.content.pm.ProviderInfo boolean ), 0, this, context, providerInfo, bl);
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
        return InvokeDynamicSupport.bootstrap("applyBatch", $$robo$$android_content_ContentProvider$applyBatch(java.util.ArrayList<android.content.ContentProviderOperation> ), 0, this, arrayList);
    }

    public Bundle call(String string2, String string3, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("call", $$robo$$android_content_ContentProvider$call(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
    }

    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_content_ContentProvider$shutdown(), 0, this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_ContentProvider$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private void validateIncomingUri(Uri uri) throws SecurityException {
        InvokeDynamicSupport.bootstrap("validateIncomingUri", $$robo$$android_content_ContentProvider$validateIncomingUri(android.net.Uri ), 0, this, uri);
    }

    private Uri maybeGetUriWithoutUserId(Uri uri) {
        return InvokeDynamicSupport.bootstrap("maybeGetUriWithoutUserId", $$robo$$android_content_ContentProvider$maybeGetUriWithoutUserId(android.net.Uri ), 0, this, uri);
    }

    public static int getUserIdFromAuthority(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUserIdFromAuthority", $$robo$$android_content_ContentProvider$getUserIdFromAuthority(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static int getUserIdFromAuthority(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUserIdFromAuthority", $$robo$$android_content_ContentProvider$getUserIdFromAuthority(java.lang.String ), 0, (String)string2);
    }

    public static int getUserIdFromUri(Uri uri, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUserIdFromUri", $$robo$$android_content_ContentProvider$getUserIdFromUri(android.net.Uri int ), 0, (Uri)uri, (int)n);
    }

    public static int getUserIdFromUri(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUserIdFromUri", $$robo$$android_content_ContentProvider$getUserIdFromUri(android.net.Uri ), 0, (Uri)uri);
    }

    public static String getAuthorityWithoutUserId(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getAuthorityWithoutUserId", $$robo$$android_content_ContentProvider$getAuthorityWithoutUserId(java.lang.String ), 0, (String)string2);
    }

    public static Uri getUriWithoutUserId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getUriWithoutUserId", $$robo$$android_content_ContentProvider$getUriWithoutUserId(android.net.Uri ), 0, (Uri)uri);
    }

    public static boolean uriHasUserId(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("uriHasUserId", $$robo$$android_content_ContentProvider$uriHasUserId(android.net.Uri ), 0, (Uri)uri);
    }

    public static Uri maybeAddUserId(Uri uri, int n) {
        return InvokeDynamicSupport.bootstrapStatic("maybeAddUserId", $$robo$$android_content_ContentProvider$maybeAddUserId(android.net.Uri int ), 0, (Uri)uri, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentProvider)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface PipeDataWriter<T> {
        public void writeDataToPipe(ParcelFileDescriptor var1, Uri var2, String var3, Bundle var4, T var5);
    }

    public class Transport
    extends ContentProviderNative
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AppOpsManager mAppOpsManager;
        int mReadOp;
        int mWriteOp;
        /* synthetic */ ContentProvider this$0;

        private void $$robo$$android_content_ContentProvider_Transport$__constructor__(ContentProvider this$0) {
            this.mAppOpsManager = null;
            this.mReadOp = -1;
            this.mWriteOp = -1;
        }

        private final ContentProvider $$robo$$android_content_ContentProvider_Transport$getContentProvider() {
            return this.this$0;
        }

        private final String $$robo$$android_content_ContentProvider_Transport$getProviderName() {
            return this.getContentProvider().getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Cursor $$robo$$android_content_ContentProvider_Transport$query(String callingPkg, Uri uri, String[] projection, Bundle queryArgs, ICancellationSignal cancellationSignal) {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            if (this.enforceReadPermission(callingPkg, uri, null) != 0) {
                if (projection != null) {
                    return new MatrixCursor(projection, 0);
                }
                Cursor cursor = this.this$0.query(uri, projection, queryArgs, CancellationSignal.fromTransport(cancellationSignal));
                if (cursor == null) {
                    return null;
                }
                return new MatrixCursor(cursor.getColumnNames(), 0);
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                Cursor cursor = this.this$0.query(uri, projection, queryArgs, CancellationSignal.fromTransport(cancellationSignal));
                return cursor;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        private final String $$robo$$android_content_ContentProvider_Transport$getType(Uri uri) {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            return this.this$0.getType(uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Uri $$robo$$android_content_ContentProvider_Transport$insert(String callingPkg, Uri uri, ContentValues initialValues) {
            this.this$0.validateIncomingUri(uri);
            int userId = ContentProvider.getUserIdFromUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            if (this.enforceWritePermission(callingPkg, uri, null) != 0) {
                return this.this$0.rejectInsert(uri, initialValues);
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                Uri uri2 = ContentProvider.maybeAddUserId(this.this$0.insert(uri, initialValues), userId);
                return uri2;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_content_ContentProvider_Transport$bulkInsert(String callingPkg, Uri uri, ContentValues[] initialValues) {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            if (this.enforceWritePermission(callingPkg, uri, null) != 0) {
                return 0;
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                int n = this.this$0.bulkInsert(uri, initialValues);
                return n;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ContentProviderResult[] $$robo$$android_content_ContentProvider_Transport$applyBatch(String callingPkg, ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
            int numOperations = operations.size();
            int[] userIds = new int[numOperations];
            for (int i = 0; i < numOperations; ++i) {
                ContentProviderOperation operation = operations.get(i);
                Uri uri = operation.getUri();
                this.this$0.validateIncomingUri(uri);
                userIds[i] = ContentProvider.getUserIdFromUri(uri);
                if (userIds[i] != -2) {
                    operation = new ContentProviderOperation(operation, true);
                    operations.set(i, operation);
                }
                if (operation.isReadOperation() && this.enforceReadPermission(callingPkg, uri, null) != 0) {
                    throw new OperationApplicationException("App op not allowed", 0);
                }
                if (!operation.isWriteOperation() || this.enforceWritePermission(callingPkg, uri, null) == 0) continue;
                throw new OperationApplicationException("App op not allowed", 0);
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                ContentProviderResult[] results = this.this$0.applyBatch(operations);
                if (results != null) {
                    for (int i = 0; i < results.length; ++i) {
                        if (userIds[i] == -2) continue;
                        results[i] = new ContentProviderResult(results[i], userIds[i]);
                    }
                }
                ContentProviderResult[] contentProviderResultArray = results;
                return contentProviderResultArray;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_content_ContentProvider_Transport$delete(String callingPkg, Uri uri, String selection, String[] selectionArgs) {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            if (this.enforceWritePermission(callingPkg, uri, null) != 0) {
                return 0;
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                int n = this.this$0.delete(uri, selection, selectionArgs);
                return n;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_content_ContentProvider_Transport$update(String callingPkg, Uri uri, ContentValues values, String selection, String[] selectionArgs) {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            if (this.enforceWritePermission(callingPkg, uri, null) != 0) {
                return 0;
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                int n = this.this$0.update(uri, values, selection, selectionArgs);
                return n;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ParcelFileDescriptor $$robo$$android_content_ContentProvider_Transport$openFile(String callingPkg, Uri uri, String mode, ICancellationSignal cancellationSignal, IBinder callerToken) throws FileNotFoundException {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            this.enforceFilePermission(callingPkg, uri, mode, callerToken);
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                ParcelFileDescriptor parcelFileDescriptor = this.this$0.openFile(uri, mode, CancellationSignal.fromTransport(cancellationSignal));
                return parcelFileDescriptor;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AssetFileDescriptor $$robo$$android_content_ContentProvider_Transport$openAssetFile(String callingPkg, Uri uri, String mode, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            this.enforceFilePermission(callingPkg, uri, mode, null);
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                AssetFileDescriptor assetFileDescriptor = this.this$0.openAssetFile(uri, mode, CancellationSignal.fromTransport(cancellationSignal));
                return assetFileDescriptor;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Bundle $$robo$$android_content_ContentProvider_Transport$call(String callingPkg, String method, String arg, Bundle extras) {
            Bundle.setDefusable(extras, true);
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                Bundle bundle = this.this$0.call(method, arg, extras);
                return bundle;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        private final String[] $$robo$$android_content_ContentProvider_Transport$getStreamTypes(Uri uri, String mimeTypeFilter) {
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            return this.this$0.getStreamTypes(uri, mimeTypeFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AssetFileDescriptor $$robo$$android_content_ContentProvider_Transport$openTypedAssetFile(String callingPkg, Uri uri, String mimeType, Bundle opts, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            Bundle.setDefusable(opts, true);
            this.this$0.validateIncomingUri(uri);
            uri = this.this$0.maybeGetUriWithoutUserId(uri);
            this.enforceFilePermission(callingPkg, uri, "r", null);
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                AssetFileDescriptor assetFileDescriptor = this.this$0.openTypedAssetFile(uri, mimeType, opts, CancellationSignal.fromTransport(cancellationSignal));
                return assetFileDescriptor;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        private final ICancellationSignal $$robo$$android_content_ContentProvider_Transport$createCancellationSignal() {
            return CancellationSignal.createTransport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Uri $$robo$$android_content_ContentProvider_Transport$canonicalize(String callingPkg, Uri uri) {
            this.this$0.validateIncomingUri(uri);
            int userId = ContentProvider.getUserIdFromUri(uri);
            uri = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceReadPermission(callingPkg, uri, null) != 0) {
                return null;
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                Uri uri2 = ContentProvider.maybeAddUserId(this.this$0.canonicalize(uri), userId);
                return uri2;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Uri $$robo$$android_content_ContentProvider_Transport$uncanonicalize(String callingPkg, Uri uri) {
            this.this$0.validateIncomingUri(uri);
            int userId = ContentProvider.getUserIdFromUri(uri);
            uri = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceReadPermission(callingPkg, uri, null) != 0) {
                return null;
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                Uri uri2 = ContentProvider.maybeAddUserId(this.this$0.uncanonicalize(uri), userId);
                return uri2;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_content_ContentProvider_Transport$refresh(String callingPkg, Uri uri, Bundle args, ICancellationSignal cancellationSignal) throws RemoteException {
            this.this$0.validateIncomingUri(uri);
            uri = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceReadPermission(callingPkg, uri, null) != 0) {
                return false;
            }
            String original = this.this$0.setCallingPackage(callingPkg);
            try {
                boolean bl = this.this$0.refresh(uri, args, CancellationSignal.fromTransport(cancellationSignal));
                return bl;
            }
            finally {
                this.this$0.setCallingPackage(original);
            }
        }

        private final void $$robo$$android_content_ContentProvider_Transport$enforceFilePermission(String callingPkg, Uri uri, String mode, IBinder callerToken) throws FileNotFoundException, SecurityException {
            if (mode != null && mode.indexOf(119) != -1 ? this.enforceWritePermission(callingPkg, uri, callerToken) != 0 : this.enforceReadPermission(callingPkg, uri, callerToken) != 0) {
                throw new FileNotFoundException("App op not allowed");
            }
        }

        private final int $$robo$$android_content_ContentProvider_Transport$enforceReadPermission(String callingPkg, Uri uri, IBinder callerToken) throws SecurityException {
            int mode = this.this$0.enforceReadPermissionInner(uri, callingPkg, callerToken);
            if (mode != 0) {
                return mode;
            }
            if (this.mReadOp != -1) {
                return this.mAppOpsManager.noteProxyOp(this.mReadOp, callingPkg);
            }
            return 0;
        }

        private final int $$robo$$android_content_ContentProvider_Transport$enforceWritePermission(String callingPkg, Uri uri, IBinder callerToken) throws SecurityException {
            int mode = this.this$0.enforceWritePermissionInner(uri, callingPkg, callerToken);
            if (mode != 0) {
                return mode;
            }
            if (this.mWriteOp != -1) {
                return this.mAppOpsManager.noteProxyOp(this.mWriteOp, callingPkg);
            }
            return 0;
        }

        private void __constructor__(ContentProvider contentProvider) {
            this.$$robo$$android_content_ContentProvider_Transport$__constructor__(contentProvider);
        }

        Transport(ContentProvider contentProvider) {
            this.this$0 = contentProvider;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProvider_Transport$__constructor__(android.content.ContentProvider ), 0, this, contentProvider);
        }

        ContentProvider getContentProvider() {
            return InvokeDynamicSupport.bootstrap("getContentProvider", $$robo$$android_content_ContentProvider_Transport$getContentProvider(), 0, this);
        }

        @Override
        public String getProviderName() {
            return InvokeDynamicSupport.bootstrap("getProviderName", $$robo$$android_content_ContentProvider_Transport$getProviderName(), 0, this);
        }

        @Override
        public Cursor query(String string2, Uri uri, String[] stringArray, Bundle bundle, ICancellationSignal iCancellationSignal) {
            return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentProvider_Transport$query(java.lang.String android.net.Uri java.lang.String[] android.os.Bundle android.os.ICancellationSignal ), 0, this, string2, uri, stringArray, bundle, iCancellationSignal);
        }

        @Override
        public String getType(Uri uri) {
            return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_content_ContentProvider_Transport$getType(android.net.Uri ), 0, this, uri);
        }

        @Override
        public Uri insert(String string2, Uri uri, ContentValues contentValues) {
            return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_content_ContentProvider_Transport$insert(java.lang.String android.net.Uri android.content.ContentValues ), 0, this, string2, uri, contentValues);
        }

        @Override
        public int bulkInsert(String string2, Uri uri, ContentValues[] contentValuesArray) {
            return (int)InvokeDynamicSupport.bootstrap("bulkInsert", $$robo$$android_content_ContentProvider_Transport$bulkInsert(java.lang.String android.net.Uri android.content.ContentValues[] ), 0, this, string2, uri, contentValuesArray);
        }

        @Override
        public ContentProviderResult[] applyBatch(String string2, ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
            return InvokeDynamicSupport.bootstrap("applyBatch", $$robo$$android_content_ContentProvider_Transport$applyBatch(java.lang.String java.util.ArrayList<android.content.ContentProviderOperation> ), 0, this, string2, arrayList);
        }

        @Override
        public int delete(String string2, Uri uri, String string3, String[] stringArray) {
            return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_content_ContentProvider_Transport$delete(java.lang.String android.net.Uri java.lang.String java.lang.String[] ), 0, this, string2, uri, string3, stringArray);
        }

        @Override
        public int update(String string2, Uri uri, ContentValues contentValues, String string3, String[] stringArray) {
            return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_content_ContentProvider_Transport$update(java.lang.String android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, string2, uri, contentValues, string3, stringArray);
        }

        @Override
        public ParcelFileDescriptor openFile(String string2, Uri uri, String string3, ICancellationSignal iCancellationSignal, IBinder iBinder) throws FileNotFoundException {
            return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_content_ContentProvider_Transport$openFile(java.lang.String android.net.Uri java.lang.String android.os.ICancellationSignal android.os.IBinder ), 0, this, string2, uri, string3, iCancellationSignal, iBinder);
        }

        @Override
        public AssetFileDescriptor openAssetFile(String string2, Uri uri, String string3, ICancellationSignal iCancellationSignal) throws FileNotFoundException {
            return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_content_ContentProvider_Transport$openAssetFile(java.lang.String android.net.Uri java.lang.String android.os.ICancellationSignal ), 0, this, string2, uri, string3, iCancellationSignal);
        }

        @Override
        public Bundle call(String string2, String string3, String string4, Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("call", $$robo$$android_content_ContentProvider_Transport$call(java.lang.String java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, string4, bundle);
        }

        @Override
        public String[] getStreamTypes(Uri uri, String string2) {
            return InvokeDynamicSupport.bootstrap("getStreamTypes", $$robo$$android_content_ContentProvider_Transport$getStreamTypes(android.net.Uri java.lang.String ), 0, this, uri, string2);
        }

        @Override
        public AssetFileDescriptor openTypedAssetFile(String string2, Uri uri, String string3, Bundle bundle, ICancellationSignal iCancellationSignal) throws FileNotFoundException {
            return InvokeDynamicSupport.bootstrap("openTypedAssetFile", $$robo$$android_content_ContentProvider_Transport$openTypedAssetFile(java.lang.String android.net.Uri java.lang.String android.os.Bundle android.os.ICancellationSignal ), 0, this, string2, uri, string3, bundle, iCancellationSignal);
        }

        @Override
        public ICancellationSignal createCancellationSignal() {
            return InvokeDynamicSupport.bootstrap("createCancellationSignal", $$robo$$android_content_ContentProvider_Transport$createCancellationSignal(), 0, this);
        }

        @Override
        public Uri canonicalize(String string2, Uri uri) {
            return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_content_ContentProvider_Transport$canonicalize(java.lang.String android.net.Uri ), 0, this, string2, uri);
        }

        @Override
        public Uri uncanonicalize(String string2, Uri uri) {
            return InvokeDynamicSupport.bootstrap("uncanonicalize", $$robo$$android_content_ContentProvider_Transport$uncanonicalize(java.lang.String android.net.Uri ), 0, this, string2, uri);
        }

        @Override
        public boolean refresh(String string2, Uri uri, Bundle bundle, ICancellationSignal iCancellationSignal) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_content_ContentProvider_Transport$refresh(java.lang.String android.net.Uri android.os.Bundle android.os.ICancellationSignal ), 0, this, string2, uri, bundle, iCancellationSignal);
        }

        private void enforceFilePermission(String string2, Uri uri, String string3, IBinder iBinder) throws FileNotFoundException, SecurityException {
            InvokeDynamicSupport.bootstrap("enforceFilePermission", $$robo$$android_content_ContentProvider_Transport$enforceFilePermission(java.lang.String android.net.Uri java.lang.String android.os.IBinder ), 0, this, string2, uri, string3, iBinder);
        }

        private int enforceReadPermission(String string2, Uri uri, IBinder iBinder) throws SecurityException {
            return (int)InvokeDynamicSupport.bootstrap("enforceReadPermission", $$robo$$android_content_ContentProvider_Transport$enforceReadPermission(java.lang.String android.net.Uri android.os.IBinder ), 0, this, string2, uri, iBinder);
        }

        private int enforceWritePermission(String string2, Uri uri, IBinder iBinder) throws SecurityException {
            return (int)InvokeDynamicSupport.bootstrap("enforceWritePermission", $$robo$$android_content_ContentProvider_Transport$enforceWritePermission(java.lang.String android.net.Uri android.os.IBinder ), 0, this, string2, uri, iBinder);
        }

        public /* synthetic */ Transport() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transport)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

