/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanRecord;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ScanResult
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int DATA_COMPLETE = 0;
    public static int DATA_TRUNCATED = 2;
    public static int PHY_UNUSED = 0;
    public static int SID_NOT_PRESENT = 255;
    public static int TX_POWER_NOT_PRESENT = 127;
    public static int PERIODIC_INTERVAL_NOT_PRESENT = 0;
    private static int ET_LEGACY_MASK = 16;
    private static int ET_CONNECTABLE_MASK = 1;
    private BluetoothDevice mDevice;
    private ScanRecord mScanRecord;
    private int mRssi;
    private long mTimestampNanos;
    private int mEventType;
    private int mPrimaryPhy;
    private int mSecondaryPhy;
    private int mAdvertisingSid;
    private int mTxPower;
    private int mPeriodicAdvertisingInterval;
    public static Parcelable.Creator<ScanResult> CREATOR;

    private void $$robo$$android_bluetooth_le_ScanResult$__constructor__(BluetoothDevice device, ScanRecord scanRecord, int rssi, long timestampNanos) {
        this.mDevice = device;
        this.mScanRecord = scanRecord;
        this.mRssi = rssi;
        this.mTimestampNanos = timestampNanos;
        this.mEventType = 17;
        this.mPrimaryPhy = 1;
        this.mSecondaryPhy = 0;
        this.mAdvertisingSid = 255;
        this.mTxPower = 127;
        this.mPeriodicAdvertisingInterval = 0;
    }

    private void $$robo$$android_bluetooth_le_ScanResult$__constructor__(BluetoothDevice device, int eventType, int primaryPhy, int secondaryPhy, int advertisingSid, int txPower, int rssi, int periodicAdvertisingInterval, ScanRecord scanRecord, long timestampNanos) {
        this.mDevice = device;
        this.mEventType = eventType;
        this.mPrimaryPhy = primaryPhy;
        this.mSecondaryPhy = secondaryPhy;
        this.mAdvertisingSid = advertisingSid;
        this.mTxPower = txPower;
        this.mRssi = rssi;
        this.mPeriodicAdvertisingInterval = periodicAdvertisingInterval;
        this.mScanRecord = scanRecord;
        this.mTimestampNanos = timestampNanos;
    }

    private void $$robo$$android_bluetooth_le_ScanResult$__constructor__(Parcel in) {
        this.readFromParcel(in);
    }

    private final void $$robo$$android_bluetooth_le_ScanResult$writeToParcel(Parcel dest, int flags) {
        if (this.mDevice != null) {
            dest.writeInt(1);
            this.mDevice.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.mScanRecord != null) {
            dest.writeInt(1);
            dest.writeByteArray(this.mScanRecord.getBytes());
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mRssi);
        dest.writeLong(this.mTimestampNanos);
        dest.writeInt(this.mEventType);
        dest.writeInt(this.mPrimaryPhy);
        dest.writeInt(this.mSecondaryPhy);
        dest.writeInt(this.mAdvertisingSid);
        dest.writeInt(this.mTxPower);
        dest.writeInt(this.mPeriodicAdvertisingInterval);
    }

    private final void $$robo$$android_bluetooth_le_ScanResult$readFromParcel(Parcel in) {
        if (in.readInt() == 1) {
            this.mDevice = BluetoothDevice.CREATOR.createFromParcel(in);
        }
        if (in.readInt() == 1) {
            this.mScanRecord = ScanRecord.parseFromBytes(in.createByteArray());
        }
        this.mRssi = in.readInt();
        this.mTimestampNanos = in.readLong();
        this.mEventType = in.readInt();
        this.mPrimaryPhy = in.readInt();
        this.mSecondaryPhy = in.readInt();
        this.mAdvertisingSid = in.readInt();
        this.mTxPower = in.readInt();
        this.mPeriodicAdvertisingInterval = in.readInt();
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$describeContents() {
        return 0;
    }

    private final BluetoothDevice $$robo$$android_bluetooth_le_ScanResult$getDevice() {
        return this.mDevice;
    }

    private final ScanRecord $$robo$$android_bluetooth_le_ScanResult$getScanRecord() {
        return this.mScanRecord;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$getRssi() {
        return this.mRssi;
    }

    private final long $$robo$$android_bluetooth_le_ScanResult$getTimestampNanos() {
        return this.mTimestampNanos;
    }

    private final boolean $$robo$$android_bluetooth_le_ScanResult$isLegacy() {
        return (this.mEventType & 0x10) != 0;
    }

    private final boolean $$robo$$android_bluetooth_le_ScanResult$isConnectable() {
        return (this.mEventType & 1) != 0;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$getDataStatus() {
        return this.mEventType >> 5 & 3;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$getPrimaryPhy() {
        return this.mPrimaryPhy;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$getSecondaryPhy() {
        return this.mSecondaryPhy;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$getAdvertisingSid() {
        return this.mAdvertisingSid;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$getTxPower() {
        return this.mTxPower;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$getPeriodicAdvertisingInterval() {
        return this.mPeriodicAdvertisingInterval;
    }

    private final int $$robo$$android_bluetooth_le_ScanResult$hashCode() {
        return Objects.hash(this.mDevice, this.mRssi, this.mScanRecord, this.mTimestampNanos, this.mEventType, this.mPrimaryPhy, this.mSecondaryPhy, this.mAdvertisingSid, this.mTxPower, this.mPeriodicAdvertisingInterval);
    }

    private final boolean $$robo$$android_bluetooth_le_ScanResult$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScanResult other = (ScanResult)obj;
        return Objects.equals(this.mDevice, other.mDevice) && this.mRssi == other.mRssi && Objects.equals(this.mScanRecord, other.mScanRecord) && this.mTimestampNanos == other.mTimestampNanos && this.mEventType == other.mEventType && this.mPrimaryPhy == other.mPrimaryPhy && this.mSecondaryPhy == other.mSecondaryPhy && this.mAdvertisingSid == other.mAdvertisingSid && this.mTxPower == other.mTxPower && this.mPeriodicAdvertisingInterval == other.mPeriodicAdvertisingInterval;
    }

    private final String $$robo$$android_bluetooth_le_ScanResult$toString() {
        return "ScanResult{device=" + this.mDevice + ", scanRecord=" + Objects.toString(this.mScanRecord) + ", rssi=" + this.mRssi + ", timestampNanos=" + this.mTimestampNanos + ", eventType=" + this.mEventType + ", primaryPhy=" + this.mPrimaryPhy + ", secondaryPhy=" + this.mSecondaryPhy + ", advertisingSid=" + this.mAdvertisingSid + ", txPower=" + this.mTxPower + ", periodicAdvertisingInterval=" + this.mPeriodicAdvertisingInterval + '}';
    }

    private /* synthetic */ void $$robo$$android_bluetooth_le_ScanResult$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ScanResult>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_bluetooth_le_ScanResult_1$__constructor__() {
            }

            private final ScanResult $$robo$$android_bluetooth_le_ScanResult_1$createFromParcel(Parcel source) {
                return new ScanResult(source);
            }

            private final ScanResult[] $$robo$$android_bluetooth_le_ScanResult_1$newArray(int size) {
                return new ScanResult[size];
            }

            private void __constructor__() {
                this.$$robo$$android_bluetooth_le_ScanResult_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanResult_1$__constructor__(), 0, this);
            }

            @Override
            public ScanResult createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_bluetooth_le_ScanResult_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ScanResult[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_bluetooth_le_ScanResult_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(BluetoothDevice bluetoothDevice, ScanRecord scanRecord, int n, long l) {
        this.$$robo$$android_bluetooth_le_ScanResult$__constructor__(bluetoothDevice, scanRecord, n, l);
    }

    public ScanResult(BluetoothDevice bluetoothDevice, ScanRecord scanRecord, int n, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanResult$__constructor__(android.bluetooth.BluetoothDevice android.bluetooth.le.ScanRecord int long ), 0, this, bluetoothDevice, scanRecord, n, l);
    }

    private void __constructor__(BluetoothDevice bluetoothDevice, int n, int n2, int n3, int n4, int n5, int n6, int n7, ScanRecord scanRecord, long l) {
        this.$$robo$$android_bluetooth_le_ScanResult$__constructor__(bluetoothDevice, n, n2, n3, n4, n5, n6, n7, scanRecord, l);
    }

    public ScanResult(BluetoothDevice bluetoothDevice, int n, int n2, int n3, int n4, int n5, int n6, int n7, ScanRecord scanRecord, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanResult$__constructor__(android.bluetooth.BluetoothDevice int int int int int int int android.bluetooth.le.ScanRecord long ), 0, this, bluetoothDevice, n, n2, n3, n4, n5, n6, n7, scanRecord, l);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_bluetooth_le_ScanResult$__constructor__(parcel);
    }

    private ScanResult(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanResult$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_bluetooth_le_ScanResult$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_bluetooth_le_ScanResult$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_bluetooth_le_ScanResult$describeContents(), 0, this);
    }

    public BluetoothDevice getDevice() {
        return InvokeDynamicSupport.bootstrap("getDevice", $$robo$$android_bluetooth_le_ScanResult$getDevice(), 0, this);
    }

    public ScanRecord getScanRecord() {
        return InvokeDynamicSupport.bootstrap("getScanRecord", $$robo$$android_bluetooth_le_ScanResult$getScanRecord(), 0, this);
    }

    public int getRssi() {
        return (int)InvokeDynamicSupport.bootstrap("getRssi", $$robo$$android_bluetooth_le_ScanResult$getRssi(), 0, this);
    }

    public long getTimestampNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getTimestampNanos", $$robo$$android_bluetooth_le_ScanResult$getTimestampNanos(), 0, this);
    }

    public boolean isLegacy() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLegacy", $$robo$$android_bluetooth_le_ScanResult$isLegacy(), 0, this);
    }

    public boolean isConnectable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectable", $$robo$$android_bluetooth_le_ScanResult$isConnectable(), 0, this);
    }

    public int getDataStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getDataStatus", $$robo$$android_bluetooth_le_ScanResult$getDataStatus(), 0, this);
    }

    public int getPrimaryPhy() {
        return (int)InvokeDynamicSupport.bootstrap("getPrimaryPhy", $$robo$$android_bluetooth_le_ScanResult$getPrimaryPhy(), 0, this);
    }

    public int getSecondaryPhy() {
        return (int)InvokeDynamicSupport.bootstrap("getSecondaryPhy", $$robo$$android_bluetooth_le_ScanResult$getSecondaryPhy(), 0, this);
    }

    public int getAdvertisingSid() {
        return (int)InvokeDynamicSupport.bootstrap("getAdvertisingSid", $$robo$$android_bluetooth_le_ScanResult$getAdvertisingSid(), 0, this);
    }

    public int getTxPower() {
        return (int)InvokeDynamicSupport.bootstrap("getTxPower", $$robo$$android_bluetooth_le_ScanResult$getTxPower(), 0, this);
    }

    public int getPeriodicAdvertisingInterval() {
        return (int)InvokeDynamicSupport.bootstrap("getPeriodicAdvertisingInterval", $$robo$$android_bluetooth_le_ScanResult$getPeriodicAdvertisingInterval(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_bluetooth_le_ScanResult$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_bluetooth_le_ScanResult$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_bluetooth_le_ScanResult$toString(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_bluetooth_le_ScanResult$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ScanResult.class);
    }

    public /* synthetic */ ScanResult() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanResult)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

