/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHidDeviceAppConfiguration;
import android.bluetooth.BluetoothHidDeviceAppQosSettings;
import android.bluetooth.BluetoothHidDeviceAppSdpSettings;
import android.bluetooth.BluetoothHidDeviceCallback;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHidDeviceCallback;
import android.bluetooth.IBluetoothInputHost;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothInputHost
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.inputhost.profile.action.CONNECTION_STATE_CHANGED";
    public static byte SUBCLASS1_NONE = 0;
    public static byte SUBCLASS1_KEYBOARD = 64;
    public static byte SUBCLASS1_MOUSE = -128;
    public static byte SUBCLASS1_COMBO = -64;
    public static byte SUBCLASS2_UNCATEGORIZED = 0;
    public static byte SUBCLASS2_JOYSTICK = 1;
    public static byte SUBCLASS2_GAMEPAD = 2;
    public static byte SUBCLASS2_REMOTE_CONTROL = 3;
    public static byte SUBCLASS2_SENSING_DEVICE = 4;
    public static byte SUBCLASS2_DIGITIZER_TABLED = 5;
    public static byte SUBCLASS2_CARD_READER = 6;
    public static byte REPORT_TYPE_INPUT = 1;
    public static byte REPORT_TYPE_OUTPUT = 2;
    public static byte REPORT_TYPE_FEATURE = 3;
    public static byte ERROR_RSP_SUCCESS = 0;
    public static byte ERROR_RSP_NOT_READY = 1;
    public static byte ERROR_RSP_INVALID_RPT_ID = 2;
    public static byte ERROR_RSP_UNSUPPORTED_REQ = 3;
    public static byte ERROR_RSP_INVALID_PARAM = 4;
    public static byte ERROR_RSP_UNKNOWN = 14;
    public static byte PROTOCOL_BOOT_MODE = 0;
    public static byte PROTOCOL_REPORT_MODE = 1;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private IBluetoothInputHost mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothInputHost$__constructor__(Context context, BluetoothProfile.ServiceListener listener) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothInputHost this$0;

            private void $$robo$$android_bluetooth_BluetoothInputHost_1$__constructor__(BluetoothInputHost this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothInputHost_1$onBluetoothStateChange(boolean up) {
                Log.d(TAG, "onBluetoothStateChange: up=" + up);
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    if (!up) {
                        Log.d(TAG, "Unbinding service...");
                        if (this.this$0.mService != null) {
                            this.this$0.mService = null;
                            try {
                                this.this$0.mContext.unbindService(this.this$0.mConnection);
                            }
                            catch (IllegalArgumentException e) {
                                Log.e(TAG, "onBluetoothStateChange: could not unbind service:", e);
                            }
                        }
                    } else {
                        try {
                            if (this.this$0.mService == null) {
                                Log.d(TAG, "Binding HID Device service...");
                                this.this$0.doBind();
                            }
                        }
                        catch (IllegalStateException e) {
                            Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                        }
                        catch (SecurityException e) {
                            Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                        }
                    }
                }
            }

            private void __constructor__(BluetoothInputHost bluetoothInputHost) {
                this.$$robo$$android_bluetooth_BluetoothInputHost_1$__constructor__(bluetoothInputHost);
            }
            {
                this.this$0 = bluetoothInputHost;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothInputHost_1$__constructor__(android.bluetooth.BluetoothInputHost ), 0, this, bluetoothInputHost);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothInputHost_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothInputHost this$0;

            private void $$robo$$android_bluetooth_BluetoothInputHost_2$__constructor__(BluetoothInputHost this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothInputHost_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d(TAG, "onServiceConnected()");
                this.this$0.mService = IBluetoothInputHost.Stub.asInterface(service);
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(19, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothInputHost_2$onServiceDisconnected(ComponentName className) {
                Log.d(TAG, "onServiceDisconnected()");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(19);
                }
            }

            private void __constructor__(BluetoothInputHost bluetoothInputHost) {
                this.$$robo$$android_bluetooth_BluetoothInputHost_2$__constructor__(bluetoothInputHost);
            }
            {
                this.this$0 = bluetoothInputHost;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothInputHost_2$__constructor__(android.bluetooth.BluetoothInputHost ), 0, this, bluetoothInputHost);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothInputHost_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothInputHost_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        Log.v(TAG, "BluetoothInputHost");
        this.mContext = context;
        this.mServiceListener = listener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$doBind() {
        Intent intent = new Intent(IBluetoothInputHost.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth HID Device Service with " + intent);
            return false;
        }
        Log.d(TAG, "Bound to HID Device Service");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothInputHost$close() {
        Log.v(TAG, "close()");
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                this.mService = null;
                try {
                    this.mContext.unbindService(this.mConnection);
                }
                catch (IllegalArgumentException e) {
                    Log.e(TAG, "close: could not unbind HID Dev service: ", e);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothInputHost$getConnectedDevices() {
        Log.v(TAG, "getConnectedDevices()");
        if (this.mService != null) {
            try {
                return this.mService.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothInputHost$getDevicesMatchingConnectionStates(int[] states) {
        Log.v(TAG, "getDevicesMatchingConnectionStates(): states=" + Arrays.toString(states));
        if (this.mService != null) {
            try {
                return this.mService.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothInputHost$getConnectionState(BluetoothDevice device) {
        Log.v(TAG, "getConnectionState(): device=" + device);
        if (this.mService != null) {
            try {
                return this.mService.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$registerApp(BluetoothHidDeviceAppSdpSettings sdp, BluetoothHidDeviceAppQosSettings inQos, BluetoothHidDeviceAppQosSettings outQos, BluetoothHidDeviceCallback callback) {
        Log.v(TAG, "registerApp(): sdp=" + sdp + " inQos=" + inQos + " outQos=" + outQos + " callback=" + callback);
        boolean result = false;
        if (sdp == null || callback == null) {
            return false;
        }
        if (this.mService != null) {
            try {
                BluetoothHidDeviceAppConfiguration config = new BluetoothHidDeviceAppConfiguration();
                BluetoothHidDeviceCallbackWrapper cbw = new BluetoothHidDeviceCallbackWrapper(callback);
                result = this.mService.registerApp(config, sdp, inQos, outQos, cbw);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$unregisterApp(BluetoothHidDeviceAppConfiguration config) {
        Log.v(TAG, "unregisterApp()");
        boolean result = false;
        if (this.mService != null) {
            try {
                result = this.mService.unregisterApp(config);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$sendReport(BluetoothDevice device, int id2, byte[] data) {
        boolean result = false;
        if (this.mService != null) {
            try {
                result = this.mService.sendReport(device, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$replyReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
        Log.v(TAG, "replyReport(): device=" + device + " type=" + type + " id=" + id2);
        boolean result = false;
        if (this.mService != null) {
            try {
                result = this.mService.replyReport(device, type, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$reportError(BluetoothDevice device, byte error) {
        Log.v(TAG, "reportError(): device=" + device + " error=" + error);
        boolean result = false;
        if (this.mService != null) {
            try {
                result = this.mService.reportError(device, error);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$unplug(BluetoothDevice device) {
        Log.v(TAG, "unplug(): device=" + device);
        boolean result = false;
        if (this.mService != null) {
            try {
                result = this.mService.unplug(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$connect(BluetoothDevice device) {
        Log.v(TAG, "connect(): device=" + device);
        boolean result = false;
        if (this.mService != null) {
            try {
                result = this.mService.connect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputHost$disconnect(BluetoothDevice device) {
        Log.v(TAG, "disconnect(): device=" + device);
        boolean result = false;
        if (this.mService != null) {
            try {
                result = this.mService.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    static void __staticInitializer__() {
        TAG = BluetoothInputHost.class.getSimpleName();
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothInputHost$__constructor__(context, serviceListener);
    }

    BluetoothInputHost(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothInputHost$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothInputHost$doBind(), 0, this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothInputHost$close(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothInputHost$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothInputHost$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothInputHost$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean registerApp(BluetoothHidDeviceAppSdpSettings bluetoothHidDeviceAppSdpSettings, BluetoothHidDeviceAppQosSettings bluetoothHidDeviceAppQosSettings, BluetoothHidDeviceAppQosSettings bluetoothHidDeviceAppQosSettings2, BluetoothHidDeviceCallback bluetoothHidDeviceCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerApp", $$robo$$android_bluetooth_BluetoothInputHost$registerApp(android.bluetooth.BluetoothHidDeviceAppSdpSettings android.bluetooth.BluetoothHidDeviceAppQosSettings android.bluetooth.BluetoothHidDeviceAppQosSettings android.bluetooth.BluetoothHidDeviceCallback ), 0, this, bluetoothHidDeviceAppSdpSettings, bluetoothHidDeviceAppQosSettings, bluetoothHidDeviceAppQosSettings2, bluetoothHidDeviceCallback);
    }

    public boolean unregisterApp(BluetoothHidDeviceAppConfiguration bluetoothHidDeviceAppConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterApp", $$robo$$android_bluetooth_BluetoothInputHost$unregisterApp(android.bluetooth.BluetoothHidDeviceAppConfiguration ), 0, this, bluetoothHidDeviceAppConfiguration);
    }

    public boolean sendReport(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendReport", $$robo$$android_bluetooth_BluetoothInputHost$sendReport(android.bluetooth.BluetoothDevice int byte[] ), 0, this, bluetoothDevice, n, byArray);
    }

    public boolean replyReport(BluetoothDevice bluetoothDevice, byte by, byte by2, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("replyReport", $$robo$$android_bluetooth_BluetoothInputHost$replyReport(android.bluetooth.BluetoothDevice byte byte byte[] ), 0, this, bluetoothDevice, by, by2, byArray);
    }

    public boolean reportError(BluetoothDevice bluetoothDevice, byte by) {
        return (boolean)InvokeDynamicSupport.bootstrap("reportError", $$robo$$android_bluetooth_BluetoothInputHost$reportError(android.bluetooth.BluetoothDevice byte ), 0, this, bluetoothDevice, by);
    }

    public boolean unplug(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("unplug", $$robo$$android_bluetooth_BluetoothInputHost$unplug(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothInputHost$connect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothInputHost$disconnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothInputHost.class);
    }

    public /* synthetic */ BluetoothInputHost() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothInputHost)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BluetoothHidDeviceCallbackWrapper
    extends IBluetoothHidDeviceCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private BluetoothHidDeviceCallback mCallback;

        private void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$__constructor__(BluetoothHidDeviceCallback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onAppStatusChanged(BluetoothDevice pluggedDevice, BluetoothHidDeviceAppConfiguration config, boolean registered) {
            this.mCallback.onAppStatusChanged(pluggedDevice, config, registered);
        }

        private final void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onConnectionStateChanged(BluetoothDevice device, int state) {
            this.mCallback.onConnectionStateChanged(device, state);
        }

        private final void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            this.mCallback.onGetReport(device, type, id2, bufferSize);
        }

        private final void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            this.mCallback.onSetReport(device, type, id2, data);
        }

        private final void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onSetProtocol(BluetoothDevice device, byte protocol) {
            this.mCallback.onSetProtocol(device, protocol);
        }

        private final void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onIntrData(BluetoothDevice device, byte reportId, byte[] data) {
            this.mCallback.onIntrData(device, reportId, data);
        }

        private final void $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onVirtualCableUnplug(BluetoothDevice device) {
            this.mCallback.onVirtualCableUnplug(device);
        }

        private void __constructor__(BluetoothHidDeviceCallback bluetoothHidDeviceCallback) {
            this.$$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$__constructor__(bluetoothHidDeviceCallback);
        }

        public BluetoothHidDeviceCallbackWrapper(BluetoothHidDeviceCallback bluetoothHidDeviceCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$__constructor__(android.bluetooth.BluetoothHidDeviceCallback ), 0, this, bluetoothHidDeviceCallback);
        }

        @Override
        public void onAppStatusChanged(BluetoothDevice bluetoothDevice, BluetoothHidDeviceAppConfiguration bluetoothHidDeviceAppConfiguration, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAppStatusChanged", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onAppStatusChanged(android.bluetooth.BluetoothDevice android.bluetooth.BluetoothHidDeviceAppConfiguration boolean ), 0, this, bluetoothDevice, bluetoothHidDeviceAppConfiguration, bl);
        }

        @Override
        public void onConnectionStateChanged(BluetoothDevice bluetoothDevice, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionStateChanged", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onConnectionStateChanged(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
        }

        @Override
        public void onGetReport(BluetoothDevice bluetoothDevice, byte by, byte by2, int n) {
            InvokeDynamicSupport.bootstrap("onGetReport", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onGetReport(android.bluetooth.BluetoothDevice byte byte int ), 0, this, bluetoothDevice, by, by2, n);
        }

        @Override
        public void onSetReport(BluetoothDevice bluetoothDevice, byte by, byte by2, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onSetReport", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onSetReport(android.bluetooth.BluetoothDevice byte byte byte[] ), 0, this, bluetoothDevice, by, by2, byArray);
        }

        @Override
        public void onSetProtocol(BluetoothDevice bluetoothDevice, byte by) {
            InvokeDynamicSupport.bootstrap("onSetProtocol", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onSetProtocol(android.bluetooth.BluetoothDevice byte ), 0, this, bluetoothDevice, by);
        }

        @Override
        public void onIntrData(BluetoothDevice bluetoothDevice, byte by, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onIntrData", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onIntrData(android.bluetooth.BluetoothDevice byte byte[] ), 0, this, bluetoothDevice, by, byArray);
        }

        @Override
        public void onVirtualCableUnplug(BluetoothDevice bluetoothDevice) {
            InvokeDynamicSupport.bootstrap("onVirtualCableUnplug", $$robo$$android_bluetooth_BluetoothInputHost_BluetoothHidDeviceCallbackWrapper$onVirtualCableUnplug(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
        }

        public /* synthetic */ BluetoothHidDeviceCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHidDeviceCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

