/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHealthAppConfiguration;
import android.bluetooth.BluetoothHealthCallback;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHealth;
import android.bluetooth.IBluetoothHealthCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothHealth
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothHealth";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static int SOURCE_ROLE = 1;
    public static int SINK_ROLE = 2;
    public static int CHANNEL_TYPE_RELIABLE = 10;
    public static int CHANNEL_TYPE_STREAMING = 11;
    public static int CHANNEL_TYPE_ANY = 12;
    public static int HEALTH_OPERATION_SUCCESS = 6000;
    public static int HEALTH_OPERATION_ERROR = 6001;
    public static int HEALTH_OPERATION_INVALID_ARGS = 6002;
    public static int HEALTH_OPERATION_GENERIC_FAILURE = 6003;
    public static int HEALTH_OPERATION_NOT_FOUND = 6004;
    public static int HEALTH_OPERATION_NOT_ALLOWED = 6005;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    public static int STATE_CHANNEL_DISCONNECTED = 0;
    public static int STATE_CHANNEL_CONNECTING = 1;
    public static int STATE_CHANNEL_CONNECTED = 2;
    public static int STATE_CHANNEL_DISCONNECTING = 3;
    public static int APP_CONFIG_REGISTRATION_SUCCESS = 0;
    public static int APP_CONFIG_REGISTRATION_FAILURE = 1;
    public static int APP_CONFIG_UNREGISTRATION_SUCCESS = 2;
    public static int APP_CONFIG_UNREGISTRATION_FAILURE = 3;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private IBluetoothHealth mService;
    BluetoothAdapter mAdapter;
    private ServiceConnection mConnection;

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$registerSinkAppConfiguration(String name, int dataType, BluetoothHealthCallback callback) {
        if (!this.isEnabled() || name == null) {
            return false;
        }
        return this.registerAppConfiguration(name, dataType, 2, 12, callback);
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$registerAppConfiguration(String name, int dataType, int role, int channelType, BluetoothHealthCallback callback) {
        boolean result = false;
        if (!this.isEnabled() || !this.checkAppParam(name, role, channelType, callback)) {
            return result;
        }
        BluetoothHealthCallbackWrapper wrapper = new BluetoothHealthCallbackWrapper(callback);
        BluetoothHealthAppConfiguration config = new BluetoothHealthAppConfiguration(name, dataType, role, channelType);
        if (this.mService != null) {
            try {
                result = this.mService.registerAppConfiguration(config, wrapper);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", e.toString());
            }
        } else {
            Log.w("BluetoothHealth", "Proxy not attached to service");
            Log.d("BluetoothHealth", Log.getStackTraceString(new Throwable()));
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$unregisterAppConfiguration(BluetoothHealthAppConfiguration config) {
        boolean result = false;
        if (this.mService != null && this.isEnabled() && config != null) {
            try {
                result = this.mService.unregisterAppConfiguration(config);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", e.toString());
            }
        } else {
            Log.w("BluetoothHealth", "Proxy not attached to service");
            Log.d("BluetoothHealth", Log.getStackTraceString(new Throwable()));
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$connectChannelToSource(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device) && config != null) {
            try {
                return this.mService.connectChannelToSource(device, config);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", e.toString());
            }
        } else {
            Log.w("BluetoothHealth", "Proxy not attached to service");
            Log.d("BluetoothHealth", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$connectChannelToSink(BluetoothDevice device, BluetoothHealthAppConfiguration config, int channelType) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device) && config != null) {
            try {
                return this.mService.connectChannelToSink(device, config, channelType);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", e.toString());
            }
        } else {
            Log.w("BluetoothHealth", "Proxy not attached to service");
            Log.d("BluetoothHealth", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$disconnectChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config, int channelId) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device) && config != null) {
            try {
                return this.mService.disconnectChannel(device, config, channelId);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", e.toString());
            }
        } else {
            Log.w("BluetoothHealth", "Proxy not attached to service");
            Log.d("BluetoothHealth", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final ParcelFileDescriptor $$robo$$android_bluetooth_BluetoothHealth$getMainChannelFd(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device) && config != null) {
            try {
                return this.mService.getMainChannelFd(device, config);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", e.toString());
            }
        } else {
            Log.w("BluetoothHealth", "Proxy not attached to service");
            Log.d("BluetoothHealth", Log.getStackTraceString(new Throwable()));
        }
        return null;
    }

    private final int $$robo$$android_bluetooth_BluetoothHealth$getConnectionState(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getHealthDeviceConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", e.toString());
            }
        } else {
            Log.w("BluetoothHealth", "Proxy not attached to service");
            Log.d("BluetoothHealth", Log.getStackTraceString(new Throwable()));
        }
        return 0;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHealth$getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getConnectedHealthDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHealth", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHealth$getDevicesMatchingConnectionStates(int[] states) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getHealthDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHealth", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private void $$robo$$android_bluetooth_BluetoothHealth$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHealth this$0;

            private void $$robo$$android_bluetooth_BluetoothHealth_1$__constructor__(BluetoothHealth this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothHealth_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothHealth", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothHealth", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothHealth", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothHealth bluetoothHealth) {
                this.$$robo$$android_bluetooth_BluetoothHealth_1$__constructor__(bluetoothHealth);
            }
            {
                this.this$0 = bluetoothHealth;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHealth_1$__constructor__(android.bluetooth.BluetoothHealth ), 0, this, bluetoothHealth);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothHealth_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHealth this$0;

            private void $$robo$$android_bluetooth_BluetoothHealth_2$__constructor__(BluetoothHealth this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothHealth_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothHealth", "Proxy object connected");
                this.this$0.mService = IBluetoothHealth.Stub.asInterface(Binder.allowBlocking(service));
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(3, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothHealth_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothHealth", "Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(3);
                }
            }

            private void __constructor__(BluetoothHealth bluetoothHealth) {
                this.$$robo$$android_bluetooth_BluetoothHealth_2$__constructor__(bluetoothHealth);
            }
            {
                this.this$0 = bluetoothHealth;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHealth_2$__constructor__(android.bluetooth.BluetoothHealth ), 0, this, bluetoothHealth);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothHealth_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothHealth_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHealth", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$doBind() {
        Intent intent = new Intent(IBluetoothHealth.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothHealth", "Could not bind to Bluetooth Health Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothHealth$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothHealth", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothHealth", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$isEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.getState() == 12) {
            return true;
        }
        BluetoothHealth.log("Bluetooth is Not enabled");
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHealth$checkAppParam(String name, int role, int channelType, BluetoothHealthCallback callback) {
        if (name == null || role != 1 && role != 2 || channelType != 10 && channelType != 11 && channelType != 12 || callback == null) {
            return false;
        }
        return role != 1 || channelType != 12;
    }

    private static final void $$robo$$android_bluetooth_BluetoothHealth$log(String msg) {
        Log.d("BluetoothHealth", msg);
    }

    public boolean registerSinkAppConfiguration(String string2, int n, BluetoothHealthCallback bluetoothHealthCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerSinkAppConfiguration", $$robo$$android_bluetooth_BluetoothHealth$registerSinkAppConfiguration(java.lang.String int android.bluetooth.BluetoothHealthCallback ), 0, this, string2, n, bluetoothHealthCallback);
    }

    public boolean registerAppConfiguration(String string2, int n, int n2, int n3, BluetoothHealthCallback bluetoothHealthCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerAppConfiguration", $$robo$$android_bluetooth_BluetoothHealth$registerAppConfiguration(java.lang.String int int int android.bluetooth.BluetoothHealthCallback ), 0, this, string2, n, n2, n3, bluetoothHealthCallback);
    }

    public boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterAppConfiguration", $$robo$$android_bluetooth_BluetoothHealth$unregisterAppConfiguration(android.bluetooth.BluetoothHealthAppConfiguration ), 0, this, bluetoothHealthAppConfiguration);
    }

    public boolean connectChannelToSource(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("connectChannelToSource", $$robo$$android_bluetooth_BluetoothHealth$connectChannelToSource(android.bluetooth.BluetoothDevice android.bluetooth.BluetoothHealthAppConfiguration ), 0, this, bluetoothDevice, bluetoothHealthAppConfiguration);
    }

    public boolean connectChannelToSink(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("connectChannelToSink", $$robo$$android_bluetooth_BluetoothHealth$connectChannelToSink(android.bluetooth.BluetoothDevice android.bluetooth.BluetoothHealthAppConfiguration int ), 0, this, bluetoothDevice, bluetoothHealthAppConfiguration, n);
    }

    public boolean disconnectChannel(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnectChannel", $$robo$$android_bluetooth_BluetoothHealth$disconnectChannel(android.bluetooth.BluetoothDevice android.bluetooth.BluetoothHealthAppConfiguration int ), 0, this, bluetoothDevice, bluetoothHealthAppConfiguration, n);
    }

    public ParcelFileDescriptor getMainChannelFd(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) {
        return InvokeDynamicSupport.bootstrap("getMainChannelFd", $$robo$$android_bluetooth_BluetoothHealth$getMainChannelFd(android.bluetooth.BluetoothDevice android.bluetooth.BluetoothHealthAppConfiguration ), 0, this, bluetoothDevice, bluetoothHealthAppConfiguration);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothHealth$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothHealth$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothHealth$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothHealth$__constructor__(context, serviceListener);
    }

    BluetoothHealth(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHealth$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothHealth$doBind(), 0, this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothHealth$close(), 0, this);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothHealth$isEnabled(), 0, this);
    }

    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDevice", $$robo$$android_bluetooth_BluetoothHealth$isValidDevice(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private boolean checkAppParam(String string2, int n, int n2, BluetoothHealthCallback bluetoothHealthCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkAppParam", $$robo$$android_bluetooth_BluetoothHealth$checkAppParam(java.lang.String int int android.bluetooth.BluetoothHealthCallback ), 0, this, string2, n, n2, bluetoothHealthCallback);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothHealth$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ BluetoothHealth() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHealth)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BluetoothHealthCallbackWrapper
    extends IBluetoothHealthCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private BluetoothHealthCallback mCallback;

        private void $$robo$$android_bluetooth_BluetoothHealth_BluetoothHealthCallbackWrapper$__constructor__(BluetoothHealthCallback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_bluetooth_BluetoothHealth_BluetoothHealthCallbackWrapper$onHealthAppConfigurationStatusChange(BluetoothHealthAppConfiguration config, int status) {
            this.mCallback.onHealthAppConfigurationStatusChange(config, status);
        }

        private final void $$robo$$android_bluetooth_BluetoothHealth_BluetoothHealthCallbackWrapper$onHealthChannelStateChange(BluetoothHealthAppConfiguration config, BluetoothDevice device, int prevState, int newState, ParcelFileDescriptor fd, int channelId) {
            this.mCallback.onHealthChannelStateChange(config, device, prevState, newState, fd, channelId);
        }

        private void __constructor__(BluetoothHealthCallback bluetoothHealthCallback) {
            this.$$robo$$android_bluetooth_BluetoothHealth_BluetoothHealthCallbackWrapper$__constructor__(bluetoothHealthCallback);
        }

        public BluetoothHealthCallbackWrapper(BluetoothHealthCallback bluetoothHealthCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHealth_BluetoothHealthCallbackWrapper$__constructor__(android.bluetooth.BluetoothHealthCallback ), 0, this, bluetoothHealthCallback);
        }

        @Override
        public void onHealthAppConfigurationStatusChange(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) {
            InvokeDynamicSupport.bootstrap("onHealthAppConfigurationStatusChange", $$robo$$android_bluetooth_BluetoothHealth_BluetoothHealthCallbackWrapper$onHealthAppConfigurationStatusChange(android.bluetooth.BluetoothHealthAppConfiguration int ), 0, this, bluetoothHealthAppConfiguration, n);
        }

        @Override
        public void onHealthChannelStateChange(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, BluetoothDevice bluetoothDevice, int n, int n2, ParcelFileDescriptor parcelFileDescriptor, int n3) {
            InvokeDynamicSupport.bootstrap("onHealthChannelStateChange", $$robo$$android_bluetooth_BluetoothHealth_BluetoothHealthCallbackWrapper$onHealthChannelStateChange(android.bluetooth.BluetoothHealthAppConfiguration android.bluetooth.BluetoothDevice int int android.os.ParcelFileDescriptor int ), 0, this, bluetoothHealthAppConfiguration, bluetoothDevice, n, n2, parcelFileDescriptor, n3);
        }

        public /* synthetic */ BluetoothHealthCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHealthCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

