/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DexLoadReporter
implements BaseDexClassLoader.Reporter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DexLoadReporter";
    private static DexLoadReporter INSTANCE;
    private static boolean DEBUG = false;
    @GuardedBy(value="mDataDirs")
    private Set<String> mDataDirs;

    private void $$robo$$android_app_DexLoadReporter$__constructor__() {
        this.mDataDirs = new HashSet<String>();
    }

    private static final DexLoadReporter $$robo$$android_app_DexLoadReporter$getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_DexLoadReporter$registerAppDataDir(String packageName, String dataDir) {
        if (dataDir != null) {
            Set<String> set = this.mDataDirs;
            synchronized (set) {
                this.mDataDirs.add(dataDir);
            }
        }
    }

    private final void $$robo$$android_app_DexLoadReporter$report(List<String> dexPaths) {
        if (dexPaths.isEmpty()) {
            return;
        }
        this.notifyPackageManager(dexPaths);
        this.registerSecondaryDexForProfiling(dexPaths);
    }

    private final void $$robo$$android_app_DexLoadReporter$notifyPackageManager(List<String> dexPaths) {
        String packageName = ActivityThread.currentPackageName();
        try {
            ActivityThread.getPackageManager().notifyDexLoad(packageName, dexPaths, VMRuntime.getRuntime().vmInstructionSet());
        }
        catch (RemoteException re) {
            Slog.e("DexLoadReporter", "Failed to notify PM about dex load for package " + packageName, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(List<String> dexPaths) {
        String[] dataDirs;
        if (!SystemProperties.getBoolean("dalvik.vm.dexopt.secondary", false)) {
            return;
        }
        Set<String> set = this.mDataDirs;
        synchronized (set) {
            dataDirs = this.mDataDirs.toArray(new String[0]);
        }
        for (String dexPath : dexPaths) {
            this.registerSecondaryDexForProfiling(dexPath, dataDirs);
        }
    }

    private final void $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(String dexPath, String[] dataDirs) {
        if (!this.isSecondaryDexFile(dexPath, dataDirs)) {
            return;
        }
        File secondaryProfile = this.getSecondaryProfileFile(dexPath);
        try {
            boolean bl = secondaryProfile.createNewFile();
        }
        catch (IOException ex) {
            Slog.e("DexLoadReporter", "Failed to create profile for secondary dex " + secondaryProfile + ":" + ex.getMessage());
            return;
        }
        VMRuntime.registerAppInfo(secondaryProfile.getPath(), new String[]{dexPath});
    }

    private final boolean $$robo$$android_app_DexLoadReporter$isSecondaryDexFile(String dexPath, String[] dataDirs) {
        for (String dataDir : dataDirs) {
            if (!FileUtils.contains(dataDir, dexPath)) continue;
            return true;
        }
        return false;
    }

    private final File $$robo$$android_app_DexLoadReporter$getSecondaryProfileFile(String dexPath) {
        return new File(dexPath + ".prof");
    }

    static void __staticInitializer__() {
        INSTANCE = new DexLoadReporter();
    }

    private void __constructor__() {
        this.$$robo$$android_app_DexLoadReporter$__constructor__();
    }

    private DexLoadReporter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_DexLoadReporter$__constructor__(), 0, this);
    }

    static DexLoadReporter getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_app_DexLoadReporter$getInstance(), 0);
    }

    void registerAppDataDir(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("registerAppDataDir", $$robo$$android_app_DexLoadReporter$registerAppDataDir(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void report(List<String> list) {
        InvokeDynamicSupport.bootstrap("report", $$robo$$android_app_DexLoadReporter$report(java.util.List<java.lang.String> ), 0, this, list);
    }

    private void notifyPackageManager(List<String> list) {
        InvokeDynamicSupport.bootstrap("notifyPackageManager", $$robo$$android_app_DexLoadReporter$notifyPackageManager(java.util.List<java.lang.String> ), 0, this, list);
    }

    private void registerSecondaryDexForProfiling(List<String> list) {
        InvokeDynamicSupport.bootstrap("registerSecondaryDexForProfiling", $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(java.util.List<java.lang.String> ), 0, this, list);
    }

    private void registerSecondaryDexForProfiling(String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("registerSecondaryDexForProfiling", $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    private boolean isSecondaryDexFile(String string2, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecondaryDexFile", $$robo$$android_app_DexLoadReporter$isSecondaryDexFile(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    private File getSecondaryProfileFile(String string2) {
        return InvokeDynamicSupport.bootstrap("getSecondaryProfileFile", $$robo$$android_app_DexLoadReporter$getSecondaryProfileFile(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(DexLoadReporter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexLoadReporter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

