/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.annotation.IntDef;
import android.os.Looper;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ValueAnimator
extends Animator
implements AnimationHandler.AnimationFrameCallback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ValueAnimator";
    private static boolean DEBUG = false;
    private static float sDurationScale;
    long mStartTime;
    boolean mStartTimeCommitted;
    float mSeekFraction;
    private long mPauseTime;
    private boolean mResumed;
    private static TimeInterpolator sDefaultInterpolator;
    private boolean mReversing;
    private float mOverallFraction;
    private float mCurrentFraction;
    private long mLastFrameTime;
    private long mFirstFrameTime;
    private boolean mRunning;
    private boolean mStarted;
    private boolean mStartListenersCalled;
    boolean mInitialized;
    private boolean mAnimationEndRequested;
    private long mDuration;
    private long mStartDelay;
    private int mRepeatCount;
    private int mRepeatMode;
    private boolean mSelfPulse;
    private boolean mSuppressSelfPulseRequested;
    private TimeInterpolator mInterpolator;
    ArrayList<AnimatorUpdateListener> mUpdateListeners;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    public static int RESTART = 1;
    public static int REVERSE = 2;
    public static int INFINITE = -1;

    private static final void $$robo$$android_animation_ValueAnimator$setDurationScale(float durationScale) {
        sDurationScale = durationScale;
    }

    private static final float $$robo$$android_animation_ValueAnimator$getDurationScale() {
        return sDurationScale;
    }

    private static final boolean $$robo$$android_animation_ValueAnimator$areAnimatorsEnabled() {
        return sDurationScale != 0.0f;
    }

    private void $$robo$$android_animation_ValueAnimator$__constructor__() {
        this.mStartTime = -1L;
        this.mSeekFraction = -1.0f;
        this.mResumed = false;
        this.mOverallFraction = 0.0f;
        this.mCurrentFraction = 0.0f;
        this.mLastFrameTime = -1L;
        this.mFirstFrameTime = -1L;
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mInitialized = false;
        this.mAnimationEndRequested = false;
        this.mDuration = 300L;
        this.mStartDelay = 0L;
        this.mRepeatCount = 0;
        this.mRepeatMode = 1;
        this.mSelfPulse = true;
        this.mSuppressSelfPulseRequested = false;
        this.mInterpolator = sDefaultInterpolator;
        this.mUpdateListeners = null;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofInt(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofArgb(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        anim2.setEvaluator(ArgbEvaluator.getInstance());
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofFloat(float ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setFloatValues(values);
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setValues(values);
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofObject(TypeEvaluator evaluator, Object ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    private final void $$robo$$android_animation_ValueAnimator$setIntValues(int ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setIntValues(values);
        }
        this.mInitialized = false;
    }

    private final void $$robo$$android_animation_ValueAnimator$setFloatValues(float ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setFloatValues(values);
        }
        this.mInitialized = false;
    }

    private final void $$robo$$android_animation_ValueAnimator$setObjectValues(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setObjectValues(values);
        }
        this.mInitialized = false;
    }

    private final void $$robo$$android_animation_ValueAnimator$setValues(PropertyValuesHolder ... values) {
        int numValues = values.length;
        this.mValues = values;
        this.mValuesMap = new HashMap(numValues);
        for (int i = 0; i < numValues; ++i) {
            PropertyValuesHolder valuesHolder = values[i];
            this.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
        }
        this.mInitialized = false;
    }

    private final PropertyValuesHolder[] $$robo$$android_animation_ValueAnimator$getValues() {
        return this.mValues;
    }

    private final void $$robo$$android_animation_ValueAnimator$initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    private final ValueAnimator $$robo$$android_animation_ValueAnimator$setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDuration = duration;
        return this;
    }

    private final long $$robo$$android_animation_ValueAnimator$getScaledDuration() {
        return (long)((float)this.mDuration * sDurationScale);
    }

    private final long $$robo$$android_animation_ValueAnimator$getDuration() {
        return this.mDuration;
    }

    private final long $$robo$$android_animation_ValueAnimator$getTotalDuration() {
        if (this.mRepeatCount == -1) {
            return -1L;
        }
        return this.mStartDelay + this.mDuration * (long)(this.mRepeatCount + 1);
    }

    private final void $$robo$$android_animation_ValueAnimator$setCurrentPlayTime(long playTime) {
        float fraction2 = this.mDuration > 0L ? (float)playTime / (float)this.mDuration : 1.0f;
        this.setCurrentFraction(fraction2);
    }

    private final void $$robo$$android_animation_ValueAnimator$setCurrentFraction(float fraction2) {
        this.initAnimation();
        fraction2 = this.clampFraction(fraction2);
        this.mStartTimeCommitted = true;
        if (this.isPulsingInternal()) {
            long seekTime = (long)((float)this.getScaledDuration() * fraction2);
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            this.mStartTime = currentTime - seekTime;
        } else {
            this.mSeekFraction = fraction2;
        }
        this.mOverallFraction = fraction2;
        float currentIterationFraction = this.getCurrentIterationFraction(fraction2, this.mReversing);
        this.animateValue(currentIterationFraction);
    }

    private final int $$robo$$android_animation_ValueAnimator$getCurrentIteration(float fraction2) {
        double iteration;
        if ((double)(fraction2 = this.clampFraction(fraction2)) == (iteration = Math.floor(fraction2)) && fraction2 > 0.0f) {
            iteration -= 1.0;
        }
        return (int)iteration;
    }

    private final float $$robo$$android_animation_ValueAnimator$getCurrentIterationFraction(float fraction2, boolean inReverse) {
        fraction2 = this.clampFraction(fraction2);
        int iteration = this.getCurrentIteration(fraction2);
        float currentFraction = fraction2 - (float)iteration;
        return this.shouldPlayBackward(iteration, inReverse) ? 1.0f - currentFraction : currentFraction;
    }

    private final float $$robo$$android_animation_ValueAnimator$clampFraction(float fraction2) {
        if (fraction2 < 0.0f) {
            fraction2 = 0.0f;
        } else if (this.mRepeatCount != -1) {
            fraction2 = Math.min(fraction2, (float)(this.mRepeatCount + 1));
        }
        return fraction2;
    }

    private final boolean $$robo$$android_animation_ValueAnimator$shouldPlayBackward(int iteration, boolean inReverse) {
        if (iteration > 0 && this.mRepeatMode == 2 && (iteration < this.mRepeatCount + 1 || this.mRepeatCount == -1)) {
            if (inReverse) {
                return iteration % 2 == 0;
            }
            return iteration % 2 != 0;
        }
        return inReverse;
    }

    private final long $$robo$$android_animation_ValueAnimator$getCurrentPlayTime() {
        if (!this.mInitialized || !this.mStarted && this.mSeekFraction < 0.0f) {
            return 0L;
        }
        if (this.mSeekFraction >= 0.0f) {
            return (long)((float)this.mDuration * this.mSeekFraction);
        }
        float durationScale = sDurationScale == 0.0f ? 1.0f : sDurationScale;
        return (long)((float)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime) / durationScale);
    }

    private final long $$robo$$android_animation_ValueAnimator$getStartDelay() {
        return this.mStartDelay;
    }

    private final void $$robo$$android_animation_ValueAnimator$setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            Log.w("ValueAnimator", "Start delay should always be non-negative");
            startDelay = 0L;
        }
        this.mStartDelay = startDelay;
    }

    private static final long $$robo$$android_animation_ValueAnimator$getFrameDelay() {
        AnimationHandler.getInstance();
        return AnimationHandler.getFrameDelay();
    }

    private static final void $$robo$$android_animation_ValueAnimator$setFrameDelay(long frameDelay) {
        AnimationHandler.getInstance();
        AnimationHandler.setFrameDelay(frameDelay);
    }

    private final Object $$robo$$android_animation_ValueAnimator$getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    private final Object $$robo$$android_animation_ValueAnimator$getAnimatedValue(String propertyName) {
        PropertyValuesHolder valuesHolder = this.mValuesMap.get(propertyName);
        if (valuesHolder != null) {
            return valuesHolder.getAnimatedValue();
        }
        return null;
    }

    private final void $$robo$$android_animation_ValueAnimator$setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    private final int $$robo$$android_animation_ValueAnimator$getRepeatCount() {
        return this.mRepeatCount;
    }

    private final void $$robo$$android_animation_ValueAnimator$setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    private final int $$robo$$android_animation_ValueAnimator$getRepeatMode() {
        return this.mRepeatMode;
    }

    private final void $$robo$$android_animation_ValueAnimator$addUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    private final void $$robo$$android_animation_ValueAnimator$removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    private final void $$robo$$android_animation_ValueAnimator$removeUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$setInterpolator(TimeInterpolator value) {
        this.mInterpolator = value != null ? value : new LinearInterpolator();
    }

    private final TimeInterpolator $$robo$$android_animation_ValueAnimator$getInterpolator() {
        return this.mInterpolator;
    }

    private final void $$robo$$android_animation_ValueAnimator$setEvaluator(TypeEvaluator value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$notifyStartListeners() {
        if (this.mListeners != null && !this.mStartListenersCalled) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this, this.mReversing);
            }
        }
        this.mStartListenersCalled = true;
    }

    private final void $$robo$$android_animation_ValueAnimator$start(boolean playBackwards) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mReversing = playBackwards;
        boolean bl = this.mSelfPulse = !this.mSuppressSelfPulseRequested;
        if (playBackwards && this.mSeekFraction != -1.0f && this.mSeekFraction != 0.0f) {
            if (this.mRepeatCount == -1) {
                float fraction2 = (float)((double)this.mSeekFraction - Math.floor(this.mSeekFraction));
                this.mSeekFraction = 1.0f - fraction2;
            } else {
                this.mSeekFraction = (float)(1 + this.mRepeatCount) - this.mSeekFraction;
            }
        }
        this.mStarted = true;
        this.mPaused = false;
        this.mRunning = false;
        this.mAnimationEndRequested = false;
        this.mLastFrameTime = -1L;
        this.mFirstFrameTime = -1L;
        this.mStartTime = -1L;
        this.addAnimationCallback(0L);
        if (this.mStartDelay == 0L || this.mSeekFraction >= 0.0f || this.mReversing) {
            this.startAnimation();
            if (this.mSeekFraction == -1.0f) {
                this.setCurrentPlayTime(0L);
            } else {
                this.setCurrentFraction(this.mSeekFraction);
            }
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$startWithoutPulsing(boolean inReverse) {
        this.mSuppressSelfPulseRequested = true;
        if (inReverse) {
            this.reverse();
        } else {
            this.start();
        }
        this.mSuppressSelfPulseRequested = false;
    }

    private final void $$robo$$android_animation_ValueAnimator$start() {
        this.start(false);
    }

    private final void $$robo$$android_animation_ValueAnimator$cancel() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (this.mAnimationEndRequested) {
            return;
        }
        if ((this.mStarted || this.mRunning) && this.mListeners != null) {
            if (!this.mRunning) {
                this.notifyStartListeners();
            }
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            for (Animator.AnimatorListener listener : tmpListeners) {
                listener.onAnimationCancel(this);
            }
        }
        this.endAnimation();
    }

    private final void $$robo$$android_animation_ValueAnimator$end() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (!this.mRunning) {
            this.startAnimation();
            this.mStarted = true;
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        this.animateValue(this.shouldPlayBackward(this.mRepeatCount, this.mReversing) ? 0.0f : 1.0f);
        this.endAnimation();
    }

    private final void $$robo$$android_animation_ValueAnimator$resume() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be resumed from the same thread that the animator was started on");
        }
        if (this.mPaused && !this.mResumed) {
            this.mResumed = true;
            if (this.mPauseTime > 0L) {
                this.addAnimationCallback(0L);
            }
        }
        super.resume();
    }

    private final void $$robo$$android_animation_ValueAnimator$pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
            this.mResumed = false;
        }
    }

    private final boolean $$robo$$android_animation_ValueAnimator$isRunning() {
        return this.mRunning;
    }

    private final boolean $$robo$$android_animation_ValueAnimator$isStarted() {
        return this.mStarted;
    }

    private final void $$robo$$android_animation_ValueAnimator$reverse() {
        if (this.isPulsingInternal()) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.getScaledDuration() - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
            this.mStartTimeCommitted = true;
            this.mReversing = !this.mReversing;
        } else if (this.mStarted) {
            this.mReversing = !this.mReversing;
            this.end();
        } else {
            this.start(true);
        }
    }

    private final boolean $$robo$$android_animation_ValueAnimator$canReverse() {
        return true;
    }

    private final void $$robo$$android_animation_ValueAnimator$endAnimation() {
        boolean notify;
        if (this.mAnimationEndRequested) {
            return;
        }
        this.removeAnimationCallback();
        this.mAnimationEndRequested = true;
        this.mPaused = false;
        boolean bl = notify = (this.mStarted || this.mRunning) && this.mListeners != null;
        if (notify && !this.mRunning) {
            this.notifyStartListeners();
        }
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mLastFrameTime = -1L;
        this.mFirstFrameTime = -1L;
        this.mStartTime = -1L;
        if (notify && this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this, this.mReversing);
            }
        }
        this.mReversing = false;
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceEnd(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$startAnimation() {
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceBegin(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
        this.mAnimationEndRequested = false;
        this.initAnimation();
        this.mRunning = true;
        this.mOverallFraction = this.mSeekFraction >= 0.0f ? this.mSeekFraction : 0.0f;
        if (this.mListeners != null) {
            this.notifyStartListeners();
        }
    }

    private final boolean $$robo$$android_animation_ValueAnimator$isPulsingInternal() {
        return this.mLastFrameTime >= 0L;
    }

    private final String $$robo$$android_animation_ValueAnimator$getNameForTrace() {
        return "animator";
    }

    private final void $$robo$$android_animation_ValueAnimator$commitAnimationFrame(long frameTime) {
        if (!this.mStartTimeCommitted) {
            this.mStartTimeCommitted = true;
            long adjustment = frameTime - this.mLastFrameTime;
            if (adjustment > 0L) {
                this.mStartTime += adjustment;
            }
        }
    }

    private final boolean $$robo$$android_animation_ValueAnimator$animateBasedOnTime(long currentTime) {
        boolean done = false;
        if (this.mRunning) {
            boolean lastIterationFinished;
            long scaledDuration = this.getScaledDuration();
            float fraction2 = scaledDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)scaledDuration : 1.0f;
            float lastFraction = this.mOverallFraction;
            boolean newIteration = (int)fraction2 > (int)lastFraction;
            boolean bl = lastIterationFinished = fraction2 >= (float)(this.mRepeatCount + 1) && this.mRepeatCount != -1;
            if (scaledDuration == 0L) {
                done = true;
            } else if (newIteration && !lastIterationFinished) {
                if (this.mListeners != null) {
                    int numListeners = this.mListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                    }
                }
            } else if (lastIterationFinished) {
                done = true;
            }
            this.mOverallFraction = this.clampFraction(fraction2);
            float currentIterationFraction = this.getCurrentIterationFraction(this.mOverallFraction, this.mReversing);
            this.animateValue(currentIterationFraction);
        }
        return done;
    }

    private final void $$robo$$android_animation_ValueAnimator$animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
        if (currentPlayTime < 0L || lastPlayTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should never be negative.");
        }
        this.initAnimation();
        if (this.mRepeatCount > 0) {
            int iteration = (int)(currentPlayTime / this.mDuration);
            int lastIteration = (int)(lastPlayTime / this.mDuration);
            if ((iteration = Math.min(iteration, this.mRepeatCount)) != (lastIteration = Math.min(lastIteration, this.mRepeatCount)) && this.mListeners != null) {
                int numListeners = this.mListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                }
            }
        }
        if (this.mRepeatCount != -1 && currentPlayTime >= (long)(this.mRepeatCount + 1) * this.mDuration) {
            this.skipToEndValue(inReverse);
        } else {
            float fraction2 = (float)currentPlayTime / (float)this.mDuration;
            fraction2 = this.getCurrentIterationFraction(fraction2, inReverse);
            this.animateValue(fraction2);
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$skipToEndValue(boolean inReverse) {
        float endFraction;
        this.initAnimation();
        float f = endFraction = inReverse ? 0.0f : 1.0f;
        if (this.mRepeatCount % 2 == 1 && this.mRepeatMode == 2) {
            endFraction = 0.0f;
        }
        this.animateValue(endFraction);
    }

    private final boolean $$robo$$android_animation_ValueAnimator$isInitialized() {
        return this.mInitialized;
    }

    private final boolean $$robo$$android_animation_ValueAnimator$doAnimationFrame(long frameTime) {
        if (this.mStartTime < 0L) {
            long l = this.mStartTime = this.mReversing ? frameTime : frameTime + (long)((float)this.mStartDelay * sDurationScale);
        }
        if (this.mPaused) {
            this.mPauseTime = frameTime;
            this.removeAnimationCallback();
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mStartTime += frameTime - this.mPauseTime;
            }
        }
        if (!this.mRunning) {
            if (this.mStartTime > frameTime && this.mSeekFraction == -1.0f) {
                return false;
            }
            this.mRunning = true;
            this.startAnimation();
        }
        if (this.mLastFrameTime < 0L) {
            if (this.mSeekFraction >= 0.0f) {
                long seekTime = (long)((float)this.getScaledDuration() * this.mSeekFraction);
                this.mStartTime = frameTime - seekTime;
                this.mSeekFraction = -1.0f;
            }
            this.mStartTimeCommitted = false;
        }
        this.mLastFrameTime = frameTime;
        long currentTime = Math.max(frameTime, this.mStartTime);
        boolean finished = this.animateBasedOnTime(currentTime);
        if (finished) {
            this.endAnimation();
        }
        return finished;
    }

    private final boolean $$robo$$android_animation_ValueAnimator$pulseAnimationFrame(long frameTime) {
        if (this.mSelfPulse) {
            return false;
        }
        return this.doAnimationFrame(frameTime);
    }

    private final void $$robo$$android_animation_ValueAnimator$addOneShotCommitCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        this.getAnimationHandler().addOneShotCommitCallback(this);
    }

    private final void $$robo$$android_animation_ValueAnimator$removeAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        this.getAnimationHandler().removeCallback(this);
    }

    private final void $$robo$$android_animation_ValueAnimator$addAnimationCallback(long delay) {
        if (!this.mSelfPulse) {
            return;
        }
        this.getAnimationHandler().addAnimationFrameCallback(this, delay);
    }

    private final float $$robo$$android_animation_ValueAnimator$getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    private final void $$robo$$android_animation_ValueAnimator$animateValue(float fraction2) {
        this.mCurrentFraction = fraction2 = this.mInterpolator.getInterpolation(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].calculateValue(fraction2);
        }
        if (this.mUpdateListeners != null) {
            int numListeners = this.mUpdateListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }
    }

    private final ValueAnimator $$robo$$android_animation_ValueAnimator$clone() {
        ValueAnimator anim2 = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            anim2.mUpdateListeners = new ArrayList<AnimatorUpdateListener>(this.mUpdateListeners);
        }
        anim2.mSeekFraction = -1.0f;
        anim2.mReversing = false;
        anim2.mInitialized = false;
        anim2.mStarted = false;
        anim2.mRunning = false;
        anim2.mPaused = false;
        anim2.mResumed = false;
        anim2.mStartListenersCalled = false;
        anim2.mStartTime = -1L;
        anim2.mStartTimeCommitted = false;
        anim2.mAnimationEndRequested = false;
        anim2.mPauseTime = -1L;
        anim2.mLastFrameTime = -1L;
        anim2.mFirstFrameTime = -1L;
        anim2.mOverallFraction = 0.0f;
        anim2.mCurrentFraction = 0.0f;
        anim2.mSelfPulse = true;
        anim2.mSuppressSelfPulseRequested = false;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim2.mValues = new PropertyValuesHolder[numValues];
            anim2.mValuesMap = new HashMap(numValues);
            for (int i = 0; i < numValues; ++i) {
                Object newValuesHolder;
                anim2.mValues[i] = newValuesHolder = oldValues[i].clone();
                anim2.mValuesMap.put(((PropertyValuesHolder)newValuesHolder).getPropertyName(), (PropertyValuesHolder)newValuesHolder);
            }
        }
        return anim2;
    }

    private static final int $$robo$$android_animation_ValueAnimator$getCurrentAnimationsCount() {
        return AnimationHandler.getAnimationCount();
    }

    private final String $$robo$$android_animation_ValueAnimator$toString() {
        String returnVal = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }

    private final void $$robo$$android_animation_ValueAnimator$setAllowRunningAsynchronously(boolean mayRunAsync) {
    }

    private final AnimationHandler $$robo$$android_animation_ValueAnimator$getAnimationHandler() {
        return AnimationHandler.getInstance();
    }

    static void __staticInitializer__() {
        sDurationScale = 1.0f;
        sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    }

    public static void setDurationScale(float f) {
        InvokeDynamicSupport.bootstrapStatic("setDurationScale", $$robo$$android_animation_ValueAnimator$setDurationScale(float ), 0, (float)f);
    }

    public static float getDurationScale() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getDurationScale", $$robo$$android_animation_ValueAnimator$getDurationScale(), 0);
    }

    public static boolean areAnimatorsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areAnimatorsEnabled", $$robo$$android_animation_ValueAnimator$areAnimatorsEnabled(), 0);
    }

    private void __constructor__() {
        this.$$robo$$android_animation_ValueAnimator$__constructor__();
    }

    public ValueAnimator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_ValueAnimator$__constructor__(), 0, this);
    }

    public static ValueAnimator ofInt(int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_ValueAnimator$ofInt(int[] ), 0, (int[])nArray);
    }

    public static ValueAnimator ofArgb(int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofArgb", $$robo$$android_animation_ValueAnimator$ofArgb(int[] ), 0, (int[])nArray);
    }

    public static ValueAnimator ofFloat(float ... fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_ValueAnimator$ofFloat(float[] ), 0, (float[])fArray);
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... propertyValuesHolderArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofPropertyValuesHolder", $$robo$$android_animation_ValueAnimator$ofPropertyValuesHolder(android.animation.PropertyValuesHolder[] ), 0, (PropertyValuesHolder[])propertyValuesHolderArray);
    }

    public static ValueAnimator ofObject(TypeEvaluator typeEvaluator, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_ValueAnimator$ofObject(android.animation.TypeEvaluator java.lang.Object[] ), 0, (TypeEvaluator)typeEvaluator, (Object[])objectArray);
    }

    public void setIntValues(int ... nArray) {
        InvokeDynamicSupport.bootstrap("setIntValues", $$robo$$android_animation_ValueAnimator$setIntValues(int[] ), 0, this, nArray);
    }

    public void setFloatValues(float ... fArray) {
        InvokeDynamicSupport.bootstrap("setFloatValues", $$robo$$android_animation_ValueAnimator$setFloatValues(float[] ), 0, this, fArray);
    }

    public void setObjectValues(Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("setObjectValues", $$robo$$android_animation_ValueAnimator$setObjectValues(java.lang.Object[] ), 0, this, objectArray);
    }

    public void setValues(PropertyValuesHolder ... propertyValuesHolderArray) {
        InvokeDynamicSupport.bootstrap("setValues", $$robo$$android_animation_ValueAnimator$setValues(android.animation.PropertyValuesHolder[] ), 0, this, propertyValuesHolderArray);
    }

    public PropertyValuesHolder[] getValues() {
        return InvokeDynamicSupport.bootstrap("getValues", $$robo$$android_animation_ValueAnimator$getValues(), 0, this);
    }

    void initAnimation() {
        InvokeDynamicSupport.bootstrap("initAnimation", $$robo$$android_animation_ValueAnimator$initAnimation(), 0, this);
    }

    @Override
    public ValueAnimator setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_ValueAnimator$setDuration(long ), 0, this, l);
    }

    private long getScaledDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getScaledDuration", $$robo$$android_animation_ValueAnimator$getScaledDuration(), 0, this);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_animation_ValueAnimator$getDuration(), 0, this);
    }

    @Override
    public long getTotalDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalDuration", $$robo$$android_animation_ValueAnimator$getTotalDuration(), 0, this);
    }

    public void setCurrentPlayTime(long l) {
        InvokeDynamicSupport.bootstrap("setCurrentPlayTime", $$robo$$android_animation_ValueAnimator$setCurrentPlayTime(long ), 0, this, l);
    }

    public void setCurrentFraction(float f) {
        InvokeDynamicSupport.bootstrap("setCurrentFraction", $$robo$$android_animation_ValueAnimator$setCurrentFraction(float ), 0, this, f);
    }

    private int getCurrentIteration(float f) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentIteration", $$robo$$android_animation_ValueAnimator$getCurrentIteration(float ), 0, this, f);
    }

    private float getCurrentIterationFraction(float f, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentIterationFraction", $$robo$$android_animation_ValueAnimator$getCurrentIterationFraction(float boolean ), 0, this, f, bl);
    }

    private float clampFraction(float f) {
        return (float)InvokeDynamicSupport.bootstrap("clampFraction", $$robo$$android_animation_ValueAnimator$clampFraction(float ), 0, this, f);
    }

    private boolean shouldPlayBackward(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldPlayBackward", $$robo$$android_animation_ValueAnimator$shouldPlayBackward(int boolean ), 0, this, n, bl);
    }

    public long getCurrentPlayTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentPlayTime", $$robo$$android_animation_ValueAnimator$getCurrentPlayTime(), 0, this);
    }

    @Override
    public long getStartDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_animation_ValueAnimator$getStartDelay(), 0, this);
    }

    @Override
    public void setStartDelay(long l) {
        InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_animation_ValueAnimator$setStartDelay(long ), 0, this, l);
    }

    public static long getFrameDelay() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getFrameDelay", $$robo$$android_animation_ValueAnimator$getFrameDelay(), 0);
    }

    public static void setFrameDelay(long l) {
        InvokeDynamicSupport.bootstrapStatic("setFrameDelay", $$robo$$android_animation_ValueAnimator$setFrameDelay(long ), 0, (long)l);
    }

    public Object getAnimatedValue() {
        return InvokeDynamicSupport.bootstrap("getAnimatedValue", $$robo$$android_animation_ValueAnimator$getAnimatedValue(), 0, this);
    }

    public Object getAnimatedValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getAnimatedValue", $$robo$$android_animation_ValueAnimator$getAnimatedValue(java.lang.String ), 0, this, string2);
    }

    public void setRepeatCount(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatCount", $$robo$$android_animation_ValueAnimator$setRepeatCount(int ), 0, this, n);
    }

    public int getRepeatCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatCount", $$robo$$android_animation_ValueAnimator$getRepeatCount(), 0, this);
    }

    public void setRepeatMode(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatMode", $$robo$$android_animation_ValueAnimator$setRepeatMode(int ), 0, this, n);
    }

    public int getRepeatMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatMode", $$robo$$android_animation_ValueAnimator$getRepeatMode(), 0, this);
    }

    public void addUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        InvokeDynamicSupport.bootstrap("addUpdateListener", $$robo$$android_animation_ValueAnimator$addUpdateListener(android.animation.ValueAnimator$AnimatorUpdateListener ), 0, this, animatorUpdateListener);
    }

    public void removeAllUpdateListeners() {
        InvokeDynamicSupport.bootstrap("removeAllUpdateListeners", $$robo$$android_animation_ValueAnimator$removeAllUpdateListeners(), 0, this);
    }

    public void removeUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        InvokeDynamicSupport.bootstrap("removeUpdateListener", $$robo$$android_animation_ValueAnimator$removeUpdateListener(android.animation.ValueAnimator$AnimatorUpdateListener ), 0, this, animatorUpdateListener);
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_animation_ValueAnimator$setInterpolator(android.animation.TimeInterpolator ), 0, this, timeInterpolator);
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_animation_ValueAnimator$getInterpolator(), 0, this);
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        InvokeDynamicSupport.bootstrap("setEvaluator", $$robo$$android_animation_ValueAnimator$setEvaluator(android.animation.TypeEvaluator ), 0, this, typeEvaluator);
    }

    private void notifyStartListeners() {
        InvokeDynamicSupport.bootstrap("notifyStartListeners", $$robo$$android_animation_ValueAnimator$notifyStartListeners(), 0, this);
    }

    private void start(boolean bl) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_ValueAnimator$start(boolean ), 0, this, bl);
    }

    @Override
    void startWithoutPulsing(boolean bl) {
        InvokeDynamicSupport.bootstrap("startWithoutPulsing", $$robo$$android_animation_ValueAnimator$startWithoutPulsing(boolean ), 0, this, bl);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_ValueAnimator$start(), 0, this);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_ValueAnimator$cancel(), 0, this);
    }

    @Override
    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_animation_ValueAnimator$end(), 0, this);
    }

    @Override
    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_animation_ValueAnimator$resume(), 0, this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_animation_ValueAnimator$pause(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_animation_ValueAnimator$isRunning(), 0, this);
    }

    @Override
    public boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_animation_ValueAnimator$isStarted(), 0, this);
    }

    @Override
    public void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_animation_ValueAnimator$reverse(), 0, this);
    }

    @Override
    public boolean canReverse() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_animation_ValueAnimator$canReverse(), 0, this);
    }

    private void endAnimation() {
        InvokeDynamicSupport.bootstrap("endAnimation", $$robo$$android_animation_ValueAnimator$endAnimation(), 0, this);
    }

    private void startAnimation() {
        InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$android_animation_ValueAnimator$startAnimation(), 0, this);
    }

    private boolean isPulsingInternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPulsingInternal", $$robo$$android_animation_ValueAnimator$isPulsingInternal(), 0, this);
    }

    String getNameForTrace() {
        return InvokeDynamicSupport.bootstrap("getNameForTrace", $$robo$$android_animation_ValueAnimator$getNameForTrace(), 0, this);
    }

    @Override
    public void commitAnimationFrame(long l) {
        InvokeDynamicSupport.bootstrap("commitAnimationFrame", $$robo$$android_animation_ValueAnimator$commitAnimationFrame(long ), 0, this, l);
    }

    boolean animateBasedOnTime(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("animateBasedOnTime", $$robo$$android_animation_ValueAnimator$animateBasedOnTime(long ), 0, this, l);
    }

    @Override
    void animateBasedOnPlayTime(long l, long l2, boolean bl) {
        InvokeDynamicSupport.bootstrap("animateBasedOnPlayTime", $$robo$$android_animation_ValueAnimator$animateBasedOnPlayTime(long long boolean ), 0, this, l, l2, bl);
    }

    @Override
    void skipToEndValue(boolean bl) {
        InvokeDynamicSupport.bootstrap("skipToEndValue", $$robo$$android_animation_ValueAnimator$skipToEndValue(boolean ), 0, this, bl);
    }

    @Override
    boolean isInitialized() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInitialized", $$robo$$android_animation_ValueAnimator$isInitialized(), 0, this);
    }

    @Override
    public boolean doAnimationFrame(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("doAnimationFrame", $$robo$$android_animation_ValueAnimator$doAnimationFrame(long ), 0, this, l);
    }

    @Override
    boolean pulseAnimationFrame(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("pulseAnimationFrame", $$robo$$android_animation_ValueAnimator$pulseAnimationFrame(long ), 0, this, l);
    }

    private void addOneShotCommitCallback() {
        InvokeDynamicSupport.bootstrap("addOneShotCommitCallback", $$robo$$android_animation_ValueAnimator$addOneShotCommitCallback(), 0, this);
    }

    private void removeAnimationCallback() {
        InvokeDynamicSupport.bootstrap("removeAnimationCallback", $$robo$$android_animation_ValueAnimator$removeAnimationCallback(), 0, this);
    }

    private void addAnimationCallback(long l) {
        InvokeDynamicSupport.bootstrap("addAnimationCallback", $$robo$$android_animation_ValueAnimator$addAnimationCallback(long ), 0, this, l);
    }

    public float getAnimatedFraction() {
        return (float)InvokeDynamicSupport.bootstrap("getAnimatedFraction", $$robo$$android_animation_ValueAnimator$getAnimatedFraction(), 0, this);
    }

    void animateValue(float f) {
        InvokeDynamicSupport.bootstrap("animateValue", $$robo$$android_animation_ValueAnimator$animateValue(float ), 0, this, f);
    }

    @Override
    public ValueAnimator clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_ValueAnimator$clone(), 0, this);
    }

    public static int getCurrentAnimationsCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCurrentAnimationsCount", $$robo$$android_animation_ValueAnimator$getCurrentAnimationsCount(), 0);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_ValueAnimator$toString(), 0, this);
    }

    @Override
    public void setAllowRunningAsynchronously(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowRunningAsynchronously", $$robo$$android_animation_ValueAnimator$setAllowRunningAsynchronously(boolean ), 0, this, bl);
    }

    public AnimationHandler getAnimationHandler() {
        return InvokeDynamicSupport.bootstrap("getAnimationHandler", $$robo$$android_animation_ValueAnimator$getAnimationHandler(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ValueAnimator.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ValueAnimator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface AnimatorUpdateListener
    extends InstrumentedInterface {
        public void onAnimationUpdate(ValueAnimator var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L})
    public static @interface RepeatMode {
    }
}

