/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update2;

import android.util.Slog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import libcore.tzdata.shared2.DistroException;
import libcore.tzdata.shared2.DistroVersion;
import libcore.tzdata.shared2.FileUtils;
import libcore.tzdata.shared2.StagedDistroOperation;
import libcore.tzdata.shared2.TimeZoneDistro;
import libcore.util.TimeZoneFinder;
import libcore.util.ZoneInfoDB;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimeZoneDistroInstaller
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int INSTALL_SUCCESS = 0;
    public static int INSTALL_FAIL_BAD_DISTRO_STRUCTURE = 1;
    public static int INSTALL_FAIL_BAD_DISTRO_FORMAT_VERSION = 2;
    public static int INSTALL_FAIL_RULES_TOO_OLD = 3;
    public static int INSTALL_FAIL_VALIDATION_ERROR = 4;
    private static String STAGED_TZ_DATA_DIR_NAME = "staged";
    private static String CURRENT_TZ_DATA_DIR_NAME = "current";
    private static String WORKING_DIR_NAME = "working";
    private static String OLD_TZ_DATA_DIR_NAME = "old";
    public static String UNINSTALL_TOMBSTONE_FILE_NAME = "STAGED_UNINSTALL_TOMBSTONE";
    private String logTag;
    private File systemTzDataFile;
    private File oldStagedDataDir;
    private File stagedTzDataDir;
    private File currentTzDataDir;
    private File workingDir;

    private void $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$__constructor__(String logTag, File systemTzDataFile, File installDir) {
        this.logTag = logTag;
        this.systemTzDataFile = systemTzDataFile;
        this.oldStagedDataDir = new File(installDir, "old");
        this.stagedTzDataDir = new File(installDir, "staged");
        this.currentTzDataDir = new File(installDir, "current");
        this.workingDir = new File(installDir, "working");
    }

    private final File $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getOldStagedDataDir() {
        return this.oldStagedDataDir;
    }

    private final File $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getStagedTzDataDir() {
        return this.stagedTzDataDir;
    }

    private final File $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getCurrentTzDataDir() {
        return this.currentTzDataDir;
    }

    private final File $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getWorkingDir() {
        return this.workingDir;
    }

    private final boolean $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$install(byte[] content) throws IOException {
        int result = this.stageInstallWithErrorCode(content);
        return result == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$stageInstallWithErrorCode(byte[] content) throws IOException {
        if (this.oldStagedDataDir.exists()) {
            FileUtils.deleteRecursive(this.oldStagedDataDir);
        }
        if (this.workingDir.exists()) {
            FileUtils.deleteRecursive(this.workingDir);
        }
        Slog.i(this.logTag, "Unpacking / verifying time zone update");
        try {
            DistroVersion distroVersion;
            this.unpackDistro(content, this.workingDir);
            try {
                distroVersion = this.readDistroVersion(this.workingDir);
            }
            catch (DistroException e) {
                Slog.i(this.logTag, "Invalid distro version: " + e.getMessage());
                int n = 1;
                this.deleteBestEffort(this.oldStagedDataDir);
                this.deleteBestEffort(this.workingDir);
                return n;
            }
            if (distroVersion == null) {
                Slog.i(this.logTag, "Update not applied: Distro version could not be loaded");
                int e = 1;
                return e;
            }
            if (!DistroVersion.isCompatibleWithThisDevice(distroVersion)) {
                Slog.i(this.logTag, "Update not applied: Distro format version check failed: " + distroVersion);
                int e = 2;
                return e;
            }
            if (!this.checkDistroDataFilesExist(this.workingDir)) {
                Slog.i(this.logTag, "Update not applied: Distro is missing required data file(s)");
                int e = 1;
                return e;
            }
            if (!this.checkDistroRulesNewerThanSystem(this.systemTzDataFile, distroVersion)) {
                Slog.i(this.logTag, "Update not applied: Distro rules version check failed");
                int e = 3;
                return e;
            }
            File zoneInfoFile = new File(this.workingDir, "tzdata");
            ZoneInfoDB.TzData tzData = ZoneInfoDB.TzData.loadTzData(zoneInfoFile.getPath());
            if (tzData == null) {
                Slog.i(this.logTag, "Update not applied: " + zoneInfoFile + " could not be loaded");
                int n = 4;
                return n;
            }
            try {
                tzData.validate();
            }
            catch (IOException e) {
                Slog.i(this.logTag, "Update not applied: " + zoneInfoFile + " failed validation", e);
                int n = 4;
                this.deleteBestEffort(this.oldStagedDataDir);
                this.deleteBestEffort(this.workingDir);
                return n;
            }
            finally {
                tzData.close();
            }
            File tzLookupFile = new File(this.workingDir, "tzlookup.xml");
            if (!tzLookupFile.exists()) {
                Slog.i(this.logTag, "Update not applied: " + tzLookupFile + " does not exist");
                int n = 1;
                return n;
            }
            try {
                TimeZoneFinder timeZoneFinder = TimeZoneFinder.createInstance(tzLookupFile.getPath());
                timeZoneFinder.validate();
            }
            catch (IOException e) {
                Slog.i(this.logTag, "Update not applied: " + tzLookupFile + " failed validation", e);
                int n = 4;
                this.deleteBestEffort(this.oldStagedDataDir);
                this.deleteBestEffort(this.workingDir);
                return n;
            }
            Slog.i(this.logTag, "Applying time zone update");
            FileUtils.makeDirectoryWorldAccessible(this.workingDir);
            if (!this.stagedTzDataDir.exists()) {
                Slog.i(this.logTag, "Nothing to unstage at " + this.stagedTzDataDir);
            } else {
                Slog.i(this.logTag, "Moving " + this.stagedTzDataDir + " to " + this.oldStagedDataDir);
                FileUtils.rename(this.stagedTzDataDir, this.oldStagedDataDir);
            }
            Slog.i(this.logTag, "Moving " + this.workingDir + " to " + this.stagedTzDataDir);
            FileUtils.rename(this.workingDir, this.stagedTzDataDir);
            Slog.i(this.logTag, "Install staged: " + this.stagedTzDataDir + " successfully created");
            int n = 0;
            return n;
        }
        finally {
            this.deleteBestEffort(this.oldStagedDataDir);
            this.deleteBestEffort(this.workingDir);
        }
    }

    private final boolean $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$stageUninstall() throws IOException {
        Slog.i(this.logTag, "Uninstalling time zone update");
        if (this.oldStagedDataDir.exists()) {
            FileUtils.deleteRecursive(this.oldStagedDataDir);
        }
        if (this.workingDir.exists()) {
            FileUtils.deleteRecursive(this.workingDir);
        }
        try {
            if (!this.stagedTzDataDir.exists()) {
                Slog.i(this.logTag, "Nothing to unstage at " + this.stagedTzDataDir);
            } else {
                Slog.i(this.logTag, "Moving " + this.stagedTzDataDir + " to " + this.oldStagedDataDir);
                FileUtils.rename(this.stagedTzDataDir, this.oldStagedDataDir);
            }
            if (!this.currentTzDataDir.exists()) {
                Slog.i(this.logTag, "Nothing to uninstall at " + this.currentTzDataDir);
                boolean bl = false;
                return bl;
            }
            FileUtils.ensureDirectoriesExist(this.workingDir, true);
            FileUtils.createEmptyFile(new File(this.workingDir, "STAGED_UNINSTALL_TOMBSTONE"));
            Slog.i(this.logTag, "Moving " + this.workingDir + " to " + this.stagedTzDataDir);
            FileUtils.rename(this.workingDir, this.stagedTzDataDir);
            Slog.i(this.logTag, "Uninstall staged: " + this.stagedTzDataDir + " successfully created");
            boolean bl = true;
            return bl;
        }
        finally {
            this.deleteBestEffort(this.oldStagedDataDir);
            this.deleteBestEffort(this.workingDir);
        }
    }

    private final DistroVersion $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getInstalledDistroVersion() throws DistroException, IOException {
        if (!this.currentTzDataDir.exists()) {
            return null;
        }
        return this.readDistroVersion(this.currentTzDataDir);
    }

    private final StagedDistroOperation $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getStagedDistroOperation() throws DistroException, IOException {
        if (!this.stagedTzDataDir.exists()) {
            return null;
        }
        if (new File(this.stagedTzDataDir, "STAGED_UNINSTALL_TOMBSTONE").exists()) {
            return StagedDistroOperation.uninstall();
        }
        return StagedDistroOperation.install(this.readDistroVersion(this.stagedTzDataDir));
    }

    private final String $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getSystemRulesVersion() throws IOException {
        return this.readSystemRulesVersion(this.systemTzDataFile);
    }

    private final void $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$deleteBestEffort(File dir) {
        if (dir.exists()) {
            Slog.i(this.logTag, "Deleting " + dir);
            try {
                FileUtils.deleteRecursive(dir);
            }
            catch (IOException e) {
                Slog.w(this.logTag, "Unable to delete " + dir, e);
            }
        }
    }

    private final void $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$unpackDistro(byte[] content, File targetDir) throws IOException {
        Slog.i(this.logTag, "Unpacking update content to: " + targetDir);
        TimeZoneDistro distro = new TimeZoneDistro(content);
        distro.extractTo(targetDir);
    }

    private final boolean $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$checkDistroDataFilesExist(File unpackedContentDir) throws IOException {
        Slog.i(this.logTag, "Verifying distro contents");
        return FileUtils.filesExist(unpackedContentDir, "tzdata", "icu/icu_tzdata.dat");
    }

    private final DistroVersion $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$readDistroVersion(File distroDir) throws DistroException, IOException {
        Slog.i(this.logTag, "Reading distro format version");
        File distroVersionFile = new File(distroDir, "distro_version");
        if (!distroVersionFile.exists()) {
            throw new DistroException("No distro version file found: " + distroVersionFile);
        }
        byte[] versionBytes = FileUtils.readBytes(distroVersionFile, DistroVersion.DISTRO_VERSION_FILE_LENGTH);
        return DistroVersion.fromBytes(versionBytes);
    }

    private final boolean $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$checkDistroRulesNewerThanSystem(File systemTzDataFile, DistroVersion distroVersion) throws IOException {
        boolean canApply;
        Slog.i(this.logTag, "Reading /system rules version");
        String systemRulesVersion = this.readSystemRulesVersion(systemTzDataFile);
        String distroRulesVersion = distroVersion.rulesVersion;
        boolean bl = canApply = distroRulesVersion.compareTo(systemRulesVersion) >= 0;
        if (!canApply) {
            Slog.i(this.logTag, "Failed rules version check: distroRulesVersion=" + distroRulesVersion + ", systemRulesVersion=" + systemRulesVersion);
        } else {
            Slog.i(this.logTag, "Passed rules version check: distroRulesVersion=" + distroRulesVersion + ", systemRulesVersion=" + systemRulesVersion);
        }
        return canApply;
    }

    private final String $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$readSystemRulesVersion(File systemTzDataFile) throws IOException {
        if (!systemTzDataFile.exists()) {
            Slog.i(this.logTag, "tzdata file cannot be found in /system");
            throw new FileNotFoundException("system tzdata does not exist: " + systemTzDataFile);
        }
        return ZoneInfoDB.TzData.getRulesVersion(systemTzDataFile);
    }

    private void __constructor__(String string2, File file, File file2) {
        this.$$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$__constructor__(string2, file, file2);
    }

    public TimeZoneDistroInstaller(String string2, File file, File file2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$__constructor__(java.lang.String java.io.File java.io.File ), this, string2, file, file2);
    }

    File getOldStagedDataDir() {
        return InvokeDynamicSupport.bootstrap("getOldStagedDataDir", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getOldStagedDataDir(), this);
    }

    File getStagedTzDataDir() {
        return InvokeDynamicSupport.bootstrap("getStagedTzDataDir", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getStagedTzDataDir(), this);
    }

    File getCurrentTzDataDir() {
        return InvokeDynamicSupport.bootstrap("getCurrentTzDataDir", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getCurrentTzDataDir(), this);
    }

    File getWorkingDir() {
        return InvokeDynamicSupport.bootstrap("getWorkingDir", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getWorkingDir(), this);
    }

    public boolean install(byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("install", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$install(byte[] ), this, byArray);
    }

    public int stageInstallWithErrorCode(byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("stageInstallWithErrorCode", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$stageInstallWithErrorCode(byte[] ), this, byArray);
    }

    public boolean stageUninstall() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("stageUninstall", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$stageUninstall(), this);
    }

    public DistroVersion getInstalledDistroVersion() throws DistroException, IOException {
        return InvokeDynamicSupport.bootstrap("getInstalledDistroVersion", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getInstalledDistroVersion(), this);
    }

    public StagedDistroOperation getStagedDistroOperation() throws DistroException, IOException {
        return InvokeDynamicSupport.bootstrap("getStagedDistroOperation", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getStagedDistroOperation(), this);
    }

    public String getSystemRulesVersion() throws IOException {
        return InvokeDynamicSupport.bootstrap("getSystemRulesVersion", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$getSystemRulesVersion(), this);
    }

    private void deleteBestEffort(File file) {
        InvokeDynamicSupport.bootstrap("deleteBestEffort", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$deleteBestEffort(java.io.File ), this, file);
    }

    private void unpackDistro(byte[] byArray, File file) throws IOException {
        InvokeDynamicSupport.bootstrap("unpackDistro", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$unpackDistro(byte[] java.io.File ), this, byArray, file);
    }

    private boolean checkDistroDataFilesExist(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("checkDistroDataFilesExist", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$checkDistroDataFilesExist(java.io.File ), this, file);
    }

    private DistroVersion readDistroVersion(File file) throws DistroException, IOException {
        return InvokeDynamicSupport.bootstrap("readDistroVersion", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$readDistroVersion(java.io.File ), this, file);
    }

    private boolean checkDistroRulesNewerThanSystem(File file, DistroVersion distroVersion) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("checkDistroRulesNewerThanSystem", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$checkDistroRulesNewerThanSystem(java.io.File libcore.tzdata.shared2.DistroVersion ), this, file, distroVersion);
    }

    private String readSystemRulesVersion(File file) throws IOException {
        return InvokeDynamicSupport.bootstrap("readSystemRulesVersion", $$robo$$libcore_tzdata_update2_TimeZoneDistroInstaller$readSystemRulesVersion(java.io.File ), this, file);
    }

    public /* synthetic */ TimeZoneDistroInstaller() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneDistroInstaller)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

