/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.Handler;

public class ClassPathURLStreamHandler
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String fileUri;
    private JarFile jarFile;

    private void $$robo$$libcore_io_ClassPathURLStreamHandler$__constructor__(String jarFileName) throws IOException {
        this.jarFile = new JarFile(jarFileName);
        this.fileUri = new File(jarFileName).toURI().toString();
    }

    private final URL $$robo$$libcore_io_ClassPathURLStreamHandler$getEntryUrlOrNull(String entryName) {
        if (ClassPathURLStreamHandler.findEntryWithDirectoryFallback(this.jarFile, entryName) != null) {
            try {
                String encodedName = ParseUtil.encodePath(entryName, false);
                return new URL("jar", null, -1, this.fileUri + "!/" + encodedName, this);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid entry name", e);
            }
        }
        return null;
    }

    private final boolean $$robo$$libcore_io_ClassPathURLStreamHandler$isEntryStored(String entryName) {
        ZipEntry entry = this.jarFile.getEntry(entryName);
        return entry != null && entry.getMethod() == 0;
    }

    private final URLConnection $$robo$$libcore_io_ClassPathURLStreamHandler$openConnection(URL url) throws IOException {
        return new ClassPathURLConnection(this, url);
    }

    private final void $$robo$$libcore_io_ClassPathURLStreamHandler$close() throws IOException {
        this.jarFile.close();
    }

    private static final ZipEntry $$robo$$libcore_io_ClassPathURLStreamHandler$findEntryWithDirectoryFallback(JarFile jarFile, String entryName) {
        ZipEntry entry = jarFile.getEntry(entryName);
        if (entry == null && !entryName.endsWith("/")) {
            entry = jarFile.getEntry(entryName + "/");
        }
        return entry;
    }

    private void __constructor__(String string2) throws IOException {
        this.$$robo$$libcore_io_ClassPathURLStreamHandler$__constructor__(string2);
    }

    public ClassPathURLStreamHandler(String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_ClassPathURLStreamHandler$__constructor__(java.lang.String ), this, string2);
    }

    public URL getEntryUrlOrNull(String string2) {
        return InvokeDynamicSupport.bootstrap("getEntryUrlOrNull", $$robo$$libcore_io_ClassPathURLStreamHandler$getEntryUrlOrNull(java.lang.String ), this, string2);
    }

    public boolean isEntryStored(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEntryStored", $$robo$$libcore_io_ClassPathURLStreamHandler$isEntryStored(java.lang.String ), this, string2);
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        return InvokeDynamicSupport.bootstrap("openConnection", $$robo$$libcore_io_ClassPathURLStreamHandler$openConnection(java.net.URL ), this, uRL);
    }

    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_io_ClassPathURLStreamHandler$close(), this);
    }

    static ZipEntry findEntryWithDirectoryFallback(JarFile jarFile, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findEntryWithDirectoryFallback", $$robo$$libcore_io_ClassPathURLStreamHandler$findEntryWithDirectoryFallback(java.util.jar.JarFile java.lang.String ), (JarFile)jarFile, (String)string2);
    }

    public /* synthetic */ ClassPathURLStreamHandler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClassPathURLStreamHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ClassPathURLConnection
    extends JarURLConnection
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private JarFile connectionJarFile;
        private ZipEntry jarEntry;
        private InputStream jarInput;
        private boolean closed;
        private boolean useCachedJarFile;
        /* synthetic */ ClassPathURLStreamHandler this$0;

        private void $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$__constructor__(ClassPathURLStreamHandler classPathURLStreamHandler, URL url) throws MalformedURLException {
        }

        private final void $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$connect() throws IOException {
            if (!this.connected) {
                this.jarEntry = ClassPathURLStreamHandler.findEntryWithDirectoryFallback(this.this$0.jarFile, this.getEntryName());
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("URL does not correspond to an entry in the zip file. URL=" + this.url + ", zipfile=" + this.this$0.jarFile.getName());
                }
                this.useCachedJarFile = this.getUseCaches();
                this.connected = true;
            }
        }

        private final JarFile $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getJarFile() throws IOException {
            this.connect();
            this.connectionJarFile = this.useCachedJarFile ? this.this$0.jarFile : new JarFile(this.this$0.jarFile.getName());
            return this.connectionJarFile;
        }

        private final InputStream $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getInputStream() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("JarURLConnection InputStream has been closed");
            }
            this.connect();
            if (this.jarInput != null) {
                return this.jarInput;
            }
            this.jarInput = new ShadowedObject(this, this.this$0.jarFile.getInputStream(this.jarEntry)){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ClassPathURLConnection this$1;

                private void $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection_1$__constructor__(ClassPathURLConnection this$1, InputStream x0) {
                    this.this$1 = this$1;
                }

                private final void $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection_1$close() throws IOException {
                    super.close();
                    if (this.this$1.connectionJarFile != null && !this.this$1.useCachedJarFile) {
                        this.this$1.connectionJarFile.close();
                        this.this$1.closed = true;
                    }
                }

                private void __constructor__(ClassPathURLConnection classPathURLConnection, InputStream inputStream) {
                    this.$$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection_1$__constructor__(classPathURLConnection, inputStream);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection_1$__constructor__(libcore.io.ClassPathURLStreamHandler$ClassPathURLConnection java.io.InputStream ), this, classPathURLConnection, inputStream);
                }

                @Override
                public void close() throws IOException {
                    InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection_1$close(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            return this.jarInput;
        }

        private final String $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getContentType() {
            String cType = ClassPathURLConnection.guessContentTypeFromName(this.getEntryName());
            if (cType == null) {
                cType = "content/unknown";
            }
            return cType;
        }

        private final int $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getContentLength() {
            try {
                this.connect();
                return (int)this.getJarEntry().getSize();
            }
            catch (IOException iOException) {
                return -1;
            }
        }

        private void __constructor__(ClassPathURLStreamHandler classPathURLStreamHandler, URL uRL) throws MalformedURLException {
            this.$$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$__constructor__(classPathURLStreamHandler, uRL);
        }

        public ClassPathURLConnection(ClassPathURLStreamHandler classPathURLStreamHandler, URL uRL) throws MalformedURLException {
            this.this$0 = classPathURLStreamHandler;
            super(uRL);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$__constructor__(libcore.io.ClassPathURLStreamHandler java.net.URL ), this, classPathURLStreamHandler, uRL);
        }

        @Override
        public void connect() throws IOException {
            InvokeDynamicSupport.bootstrap("connect", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$connect(), this);
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return InvokeDynamicSupport.bootstrap("getJarFile", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getJarFile(), this);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getInputStream(), this);
        }

        @Override
        public String getContentType() {
            return InvokeDynamicSupport.bootstrap("getContentType", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getContentType(), this);
        }

        @Override
        public int getContentLength() {
            return (int)InvokeDynamicSupport.bootstrap("getContentLength", $$robo$$libcore_io_ClassPathURLStreamHandler_ClassPathURLConnection$getContentLength(), this);
        }

        public /* synthetic */ ClassPathURLConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClassPathURLConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

