/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

class BitLevel {
    private BitLevel() {
    }

    static int bitLength(BigInteger val) {
        int i;
        val.prepareJavaRepresentation();
        if (val.sign == 0) {
            return 0;
        }
        int bLength = val.numberLength << 5;
        int highDigit = val.digits[val.numberLength - 1];
        if (val.sign < 0 && (i = val.getFirstNonzeroDigit()) == val.numberLength - 1) {
            --highDigit;
        }
        return bLength -= Integer.numberOfLeadingZeros(highDigit);
    }

    static int bitCount(BigInteger val) {
        int i;
        val.prepareJavaRepresentation();
        int bCount = 0;
        if (val.sign == 0) {
            return 0;
        }
        if (val.sign > 0) {
            for (i = val.getFirstNonzeroDigit(); i < val.numberLength; ++i) {
                bCount += Integer.bitCount(val.digits[i]);
            }
        } else {
            bCount += Integer.bitCount(-val.digits[i]);
            ++i;
            while (i < val.numberLength) {
                bCount += Integer.bitCount(~val.digits[i]);
                ++i;
            }
            bCount = (val.numberLength << 5) - bCount;
        }
        return bCount;
    }

    static boolean testBit(BigInteger val, int n) {
        val.prepareJavaRepresentation();
        return (val.digits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    static boolean nonZeroDroppedBits(int numberOfBits, int[] digits) {
        int i;
        int intCount = numberOfBits >> 5;
        int bitCount = numberOfBits & 0x1F;
        for (i = 0; i < intCount && digits[i] == 0; ++i) {
        }
        return i != intCount || digits[i] << 32 - bitCount != 0;
    }

    static void shiftLeftOneBit(int[] result, int[] source, int srcLen) {
        int carry = 0;
        for (int i = 0; i < srcLen; ++i) {
            int val = source[i];
            result[i] = val << 1 | carry;
            carry = val >>> 31;
        }
        if (carry != 0) {
            result[srcLen] = carry;
        }
    }

    static BigInteger shiftLeftOneBit(BigInteger source) {
        source.prepareJavaRepresentation();
        int srcLen = source.numberLength;
        int resLen = srcLen + 1;
        int[] resDigits = new int[resLen];
        BitLevel.shiftLeftOneBit(resDigits, source.digits, srcLen);
        return new BigInteger(source.sign, resLen, resDigits);
    }

    static BigInteger shiftRight(BigInteger source, int count) {
        source.prepareJavaRepresentation();
        int intCount = count >> 5;
        count &= 0x1F;
        if (intCount >= source.numberLength) {
            return source.sign < 0 ? BigInteger.MINUS_ONE : BigInteger.ZERO;
        }
        int resLength = source.numberLength - intCount;
        int[] resDigits = new int[resLength + 1];
        BitLevel.shiftRight(resDigits, resLength, source.digits, intCount, count);
        if (source.sign < 0) {
            int i;
            for (i = 0; i < intCount && source.digits[i] == 0; ++i) {
            }
            if (i < intCount || count > 0 && source.digits[i] << 32 - count != 0) {
                for (i = 0; i < resLength && resDigits[i] == -1; ++i) {
                    resDigits[i] = 0;
                }
                if (i == resLength) {
                    ++resLength;
                }
                int n = i;
                resDigits[n] = resDigits[n] + 1;
            }
        }
        return new BigInteger(source.sign, resLength, resDigits);
    }

    static boolean shiftRight(int[] result, int resultLen, int[] source, int intCount, int count) {
        int i;
        boolean allZero = true;
        for (i = 0; i < intCount; ++i) {
            allZero &= source[i] == 0;
        }
        if (count == 0) {
            System.arraycopy((int[])source, (int)intCount, (int[])result, (int)0, (int)resultLen);
            i = resultLen;
        } else {
            int leftShiftCount = 32 - count;
            allZero &= source[i] << leftShiftCount == 0;
            for (i = 0; i < resultLen - 1; ++i) {
                result[i] = source[i + intCount] >>> count | source[i + intCount + 1] << leftShiftCount;
            }
            result[i] = source[i + intCount] >>> count;
            ++i;
        }
        return allZero;
    }

    static BigInteger flipBit(BigInteger val, int n) {
        val.prepareJavaRepresentation();
        int resSign = val.sign == 0 ? 1 : val.sign;
        int intCount = n >> 5;
        int bitN = n & 0x1F;
        int resLength = Math.max(intCount + 1, val.numberLength) + 1;
        int[] resDigits = new int[resLength];
        int bitNumber = 1 << bitN;
        System.arraycopy((int[])val.digits, (int)0, (int[])resDigits, (int)0, (int)val.numberLength);
        if (val.sign < 0) {
            if (intCount >= val.numberLength) {
                resDigits[intCount] = bitNumber;
            } else {
                int firstNonZeroDigit = val.getFirstNonzeroDigit();
                if (intCount > firstNonZeroDigit) {
                    int n2 = intCount;
                    resDigits[n2] = resDigits[n2] ^ bitNumber;
                } else if (intCount < firstNonZeroDigit) {
                    int i;
                    resDigits[intCount] = -bitNumber;
                    for (i = intCount + 1; i < firstNonZeroDigit; ++i) {
                        resDigits[i] = -1;
                    }
                    int n3 = i;
                    resDigits[n3] = resDigits[n3] - 1;
                } else {
                    int i = intCount;
                    resDigits[i] = -(-resDigits[intCount] ^ bitNumber);
                    if (resDigits[i] == 0) {
                        ++i;
                        while (resDigits[i] == -1) {
                            resDigits[i] = 0;
                            ++i;
                        }
                        int n4 = i;
                        resDigits[n4] = resDigits[n4] + 1;
                    }
                }
            }
        } else {
            int n5 = intCount;
            resDigits[n5] = resDigits[n5] ^ bitNumber;
        }
        return new BigInteger(resSign, resLength, resDigits);
    }
}

