/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.profiler.BinaryHprof;
import dalvik.system.profiler.HprofData;
import dalvik.system.profiler.PortableThreadSampler;
import dalvik.system.profiler.ThreadSampler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SamplingProfiler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Map<HprofData.StackTrace, int[]> stackTraces;
    private HprofData hprofData;
    private Timer timer;
    private Sampler sampler;
    private int depth;
    private ThreadSet threadSet;
    private int nextThreadId;
    private int nextStackTraceId;
    private int nextObjectId;
    private Thread[] currentThreads;
    private Map<Thread, Integer> threadIds;
    private HprofData.StackTrace mutableStackTrace;
    private ThreadSampler threadSampler;

    private void $$robo$$dalvik_system_profiler_SamplingProfiler$__constructor__(int depth, ThreadSet threadSet) {
        this.stackTraces = new HashMap<HprofData.StackTrace, int[]>();
        this.hprofData = new HprofData(this.stackTraces);
        this.timer = new Timer("SamplingProfiler", true);
        this.nextThreadId = 200001;
        this.nextStackTraceId = 300001;
        this.nextObjectId = 1;
        this.currentThreads = new Thread[0];
        this.threadIds = new HashMap<Thread, Integer>();
        this.mutableStackTrace = new HprofData.StackTrace();
        this.depth = depth;
        this.threadSet = threadSet;
        this.threadSampler = SamplingProfiler.findDefaultThreadSampler();
        this.threadSampler.setDepth(depth);
        this.hprofData.setFlags(BinaryHprof.ControlSettings.CPU_SAMPLING.bitmask);
        this.hprofData.setDepth(depth);
    }

    private static final ThreadSampler $$robo$$dalvik_system_profiler_SamplingProfiler$findDefaultThreadSampler() {
        if ("Dalvik Core Library".equals(System.getProperty("java.specification.name"))) {
            String className = "dalvik.system.profiler.DalvikThreadSampler";
            try {
                return (ThreadSampler)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                System.out.println("Problem creating " + className + ": " + e);
            }
        }
        return new PortableThreadSampler();
    }

    private static final ThreadSet $$robo$$dalvik_system_profiler_SamplingProfiler$newArrayThreadSet(Thread ... threads) {
        return new ArrayThreadSet(threads);
    }

    private static final ThreadSet $$robo$$dalvik_system_profiler_SamplingProfiler$newThreadGroupThreadSet(ThreadGroup threadGroup) {
        return new ThreadGroupThreadSet(threadGroup);
    }

    private final void $$robo$$dalvik_system_profiler_SamplingProfiler$start(int interval) {
        if (interval < 1) {
            throw new IllegalArgumentException("interval < 1");
        }
        if (this.sampler != null) {
            throw new IllegalStateException("profiling already started");
        }
        this.sampler = new Sampler(this, null);
        this.hprofData.setStartMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        this.timer.scheduleAtFixedRate((TimerTask)this.sampler, 0L, (long)interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$dalvik_system_profiler_SamplingProfiler$stop() {
        if (this.sampler == null) {
            return;
        }
        Sampler sampler = this.sampler;
        synchronized (sampler) {
            this.sampler.stop = true;
            while (!this.sampler.stopped) {
                try {
                    this.sampler.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.sampler = null;
    }

    private final void $$robo$$dalvik_system_profiler_SamplingProfiler$shutdown() {
        this.stop();
        this.timer.cancel();
    }

    private final HprofData $$robo$$dalvik_system_profiler_SamplingProfiler$getHprofData() {
        if (this.sampler != null) {
            throw new IllegalStateException("cannot access hprof data while sampling");
        }
        return this.hprofData;
    }

    static /* synthetic */ Thread[] access$402(SamplingProfiler x0, Thread[] x1) {
        x0.currentThreads = x1;
        return x1;
    }

    private void __constructor__(int n, ThreadSet threadSet) {
        this.$$robo$$dalvik_system_profiler_SamplingProfiler$__constructor__(n, threadSet);
    }

    public SamplingProfiler(int n, ThreadSet threadSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_SamplingProfiler$__constructor__(int dalvik.system.profiler.SamplingProfiler$ThreadSet ), this, n, threadSet);
    }

    private static ThreadSampler findDefaultThreadSampler() {
        return InvokeDynamicSupport.bootstrapStatic("findDefaultThreadSampler", $$robo$$dalvik_system_profiler_SamplingProfiler$findDefaultThreadSampler());
    }

    public static ThreadSet newArrayThreadSet(Thread ... threadArray) {
        return InvokeDynamicSupport.bootstrapStatic("newArrayThreadSet", $$robo$$dalvik_system_profiler_SamplingProfiler$newArrayThreadSet(java.lang.Thread[] ), (Thread[])threadArray);
    }

    public static ThreadSet newThreadGroupThreadSet(ThreadGroup threadGroup) {
        return InvokeDynamicSupport.bootstrapStatic("newThreadGroupThreadSet", $$robo$$dalvik_system_profiler_SamplingProfiler$newThreadGroupThreadSet(java.lang.ThreadGroup ), (ThreadGroup)threadGroup);
    }

    public void start(int n) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$dalvik_system_profiler_SamplingProfiler$start(int ), this, n);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$dalvik_system_profiler_SamplingProfiler$stop(), this);
    }

    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$dalvik_system_profiler_SamplingProfiler$shutdown(), this);
    }

    public HprofData getHprofData() {
        return InvokeDynamicSupport.bootstrap("getHprofData", $$robo$$dalvik_system_profiler_SamplingProfiler$getHprofData(), this);
    }

    public /* synthetic */ SamplingProfiler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SamplingProfiler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Sampler
    extends TimerTask
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean stop;
        private boolean stopped;
        private Thread timerThread;
        /* synthetic */ SamplingProfiler this$0;

        private void $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$__constructor__(SamplingProfiler samplingProfiler) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$run() {
            Sampler sampler = this;
            synchronized (sampler) {
                if (this.stop) {
                    this.cancel();
                    this.stopped = true;
                    this.notifyAll();
                    return;
                }
            }
            if (this.timerThread == null) {
                this.timerThread = Thread.currentThread();
            }
            Object[] newThreads = this.this$0.threadSet.threads();
            if (!Arrays.equals(this.this$0.currentThreads, newThreads)) {
                this.updateThreadHistory(this.this$0.currentThreads, (Thread[])newThreads);
                SamplingProfiler.access$402(this.this$0, (Thread[])newThreads.clone());
            }
            for (Thread thread : this.this$0.currentThreads) {
                StackTraceElement[] stackFrames;
                if (thread == null) break;
                if (thread == this.timerThread || (stackFrames = this.this$0.threadSampler.getStackTrace(thread)) == null) continue;
                this.recordStackTrace(thread, stackFrames);
            }
        }

        private final void $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$recordStackTrace(Thread thread, StackTraceElement[] stackFrames) {
            Integer threadId = (Integer)this.this$0.threadIds.get(thread);
            if (threadId == null) {
                throw new IllegalArgumentException("Unknown thread " + thread);
            }
            ((SamplingProfiler)this.this$0).mutableStackTrace.threadId = threadId;
            ((SamplingProfiler)this.this$0).mutableStackTrace.stackFrames = stackFrames;
            int[] countCell = (int[])this.this$0.stackTraces.get(this.this$0.mutableStackTrace);
            if (countCell == null) {
                countCell = new int[1];
                StackTraceElement[] stackFramesCopy = (StackTraceElement[])stackFrames.clone();
                HprofData.StackTrace stackTrace = new HprofData.StackTrace(this.this$0.nextStackTraceId++, threadId, stackFramesCopy);
                this.this$0.hprofData.addStackTrace(stackTrace, countCell);
            }
            countCell[0] = countCell[0] + 1;
        }

        private final void $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$updateThreadHistory(Thread[] oldThreads, Thread[] newThreads) {
            HashSet<Thread> n = new HashSet<Thread>(Arrays.asList(newThreads));
            HashSet<Thread> o = new HashSet<Thread>(Arrays.asList(oldThreads));
            HashSet<Thread> added = new HashSet<Thread>(n);
            added.removeAll(o);
            HashSet<Thread> removed = new HashSet<Thread>(o);
            removed.removeAll(n);
            for (Thread thread : added) {
                if (thread == null || thread == this.timerThread) continue;
                this.addStartThread(thread);
            }
            for (Thread thread : removed) {
                if (thread == null || thread == this.timerThread) continue;
                this.addEndThread(thread);
            }
        }

        private final void $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$addStartThread(Thread thread) {
            if (thread == null) {
                throw new NullPointerException("thread == null");
            }
            int threadId = this.this$0.nextThreadId++;
            Integer old = this.this$0.threadIds.put(thread, threadId);
            if (old != null) {
                throw new IllegalArgumentException("Thread already registered as " + old);
            }
            String threadName = thread.getName();
            ThreadGroup group = thread.getThreadGroup();
            String groupName = group == null ? null : group.getName();
            ThreadGroup parentGroup = group == null ? null : group.getParent();
            String parentGroupName = parentGroup == null ? null : parentGroup.getName();
            HprofData.ThreadEvent event = HprofData.ThreadEvent.start(this.this$0.nextObjectId++, threadId, threadName, groupName, parentGroupName);
            this.this$0.hprofData.addThreadEvent(event);
        }

        private final void $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$addEndThread(Thread thread) {
            if (thread == null) {
                throw new NullPointerException("thread == null");
            }
            Integer threadId = (Integer)this.this$0.threadIds.remove(thread);
            if (threadId == null) {
                throw new IllegalArgumentException("Unknown thread " + thread);
            }
            HprofData.ThreadEvent event = HprofData.ThreadEvent.end(threadId);
            this.this$0.hprofData.addThreadEvent(event);
        }

        private /* synthetic */ void $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$__constructor__(SamplingProfiler x0, 1 x1) {
        }

        private void __constructor__(SamplingProfiler samplingProfiler) {
            this.$$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$__constructor__(samplingProfiler);
        }

        public Sampler(SamplingProfiler samplingProfiler) {
            this.this$0 = samplingProfiler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$__constructor__(dalvik.system.profiler.SamplingProfiler ), this, samplingProfiler);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$run(), this);
        }

        private void recordStackTrace(Thread thread, StackTraceElement[] stackTraceElementArray) {
            InvokeDynamicSupport.bootstrap("recordStackTrace", $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$recordStackTrace(java.lang.Thread java.lang.StackTraceElement[] ), this, thread, stackTraceElementArray);
        }

        private void updateThreadHistory(Thread[] threadArray, Thread[] threadArray2) {
            InvokeDynamicSupport.bootstrap("updateThreadHistory", $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$updateThreadHistory(java.lang.Thread[] java.lang.Thread[] ), this, threadArray, threadArray2);
        }

        private void addStartThread(Thread thread) {
            InvokeDynamicSupport.bootstrap("addStartThread", $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$addStartThread(java.lang.Thread ), this, thread);
        }

        private void addEndThread(Thread thread) {
            InvokeDynamicSupport.bootstrap("addEndThread", $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$addEndThread(java.lang.Thread ), this, thread);
        }

        private /* synthetic */ void __constructor__(SamplingProfiler samplingProfiler, 1 var2_2) {
            this.$$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$__constructor__(samplingProfiler, var2_2);
        }

        public /* synthetic */ Sampler(SamplingProfiler samplingProfiler, 1 var2_2) {
            this(samplingProfiler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_SamplingProfiler_Sampler$__constructor__(dalvik.system.profiler.SamplingProfiler dalvik.system.profiler.SamplingProfiler$1 ), this, samplingProfiler, var2_2);
        }

        public /* synthetic */ Sampler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Sampler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ThreadGroupThreadSet
    implements ThreadSet,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ThreadGroup threadGroup;
        private Thread[] threads;
        private int lastThread;

        private void $$robo$$dalvik_system_profiler_SamplingProfiler_ThreadGroupThreadSet$__constructor__(ThreadGroup threadGroup) {
            if (threadGroup == null) {
                throw new NullPointerException("threadGroup == null");
            }
            this.threadGroup = threadGroup;
            this.resize();
        }

        private final void $$robo$$dalvik_system_profiler_SamplingProfiler_ThreadGroupThreadSet$resize() {
            int count = this.threadGroup.activeCount();
            this.threads = new Thread[count * 2];
            this.lastThread = 0;
        }

        private final Thread[] $$robo$$dalvik_system_profiler_SamplingProfiler_ThreadGroupThreadSet$threads() {
            int threadCount;
            while ((threadCount = this.threadGroup.enumerate(this.threads)) == this.threads.length) {
                this.resize();
            }
            if (threadCount < this.lastThread) {
                Arrays.fill(this.threads, threadCount, this.lastThread, null);
            }
            this.lastThread = threadCount;
            return this.threads;
        }

        private void __constructor__(ThreadGroup threadGroup) {
            this.$$robo$$dalvik_system_profiler_SamplingProfiler_ThreadGroupThreadSet$__constructor__(threadGroup);
        }

        public ThreadGroupThreadSet(ThreadGroup threadGroup) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_SamplingProfiler_ThreadGroupThreadSet$__constructor__(java.lang.ThreadGroup ), this, threadGroup);
        }

        private void resize() {
            InvokeDynamicSupport.bootstrap("resize", $$robo$$dalvik_system_profiler_SamplingProfiler_ThreadGroupThreadSet$resize(), this);
        }

        @Override
        public Thread[] threads() {
            return InvokeDynamicSupport.bootstrap("threads", $$robo$$dalvik_system_profiler_SamplingProfiler_ThreadGroupThreadSet$threads(), this);
        }

        public /* synthetic */ ThreadGroupThreadSet() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadGroupThreadSet)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ArrayThreadSet
    implements ThreadSet,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Thread[] threads;

        private void $$robo$$dalvik_system_profiler_SamplingProfiler_ArrayThreadSet$__constructor__(Thread ... threads) {
            if (threads == null) {
                throw new NullPointerException("threads == null");
            }
            this.threads = threads;
        }

        private final Thread[] $$robo$$dalvik_system_profiler_SamplingProfiler_ArrayThreadSet$threads() {
            return this.threads;
        }

        private void __constructor__(Thread ... threadArray) {
            this.$$robo$$dalvik_system_profiler_SamplingProfiler_ArrayThreadSet$__constructor__(threadArray);
        }

        public ArrayThreadSet(Thread ... threadArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_SamplingProfiler_ArrayThreadSet$__constructor__(java.lang.Thread[] ), this, threadArray);
        }

        @Override
        public Thread[] threads() {
            return InvokeDynamicSupport.bootstrap("threads", $$robo$$dalvik_system_profiler_SamplingProfiler_ArrayThreadSet$threads(), this);
        }

        public /* synthetic */ ArrayThreadSet() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArrayThreadSet)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ThreadSet
    extends InstrumentedInterface {
        public Thread[] threads();
    }
}

