/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class HprofData
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private long startMillis;
    private int flags;
    private int depth;
    private List<ThreadEvent> threadHistory;
    private Map<Integer, ThreadEvent> threadIdToThreadEvent;
    private Map<StackTrace, int[]> stackTraces;

    private void $$robo$$dalvik_system_profiler_HprofData$__constructor__(Map<StackTrace, int[]> stackTraces) {
        this.threadHistory = new ArrayList<ThreadEvent>();
        this.threadIdToThreadEvent = new HashMap<Integer, ThreadEvent>();
        if (stackTraces == null) {
            throw new NullPointerException("stackTraces == null");
        }
        this.stackTraces = stackTraces;
    }

    private final long $$robo$$dalvik_system_profiler_HprofData$getStartMillis() {
        return this.startMillis;
    }

    private final void $$robo$$dalvik_system_profiler_HprofData$setStartMillis(long startMillis) {
        this.startMillis = startMillis;
    }

    private final int $$robo$$dalvik_system_profiler_HprofData$getFlags() {
        return this.flags;
    }

    private final void $$robo$$dalvik_system_profiler_HprofData$setFlags(int flags) {
        this.flags = flags;
    }

    private final int $$robo$$dalvik_system_profiler_HprofData$getDepth() {
        return this.depth;
    }

    private final void $$robo$$dalvik_system_profiler_HprofData$setDepth(int depth) {
        this.depth = depth;
    }

    private final List<ThreadEvent> $$robo$$dalvik_system_profiler_HprofData$getThreadHistory() {
        return Collections.unmodifiableList(this.threadHistory);
    }

    private final Set<Sample> $$robo$$dalvik_system_profiler_HprofData$getSamples() {
        HashSet<Sample> samples = new HashSet<Sample>(this.stackTraces.size());
        for (Map.Entry<StackTrace, int[]> e : this.stackTraces.entrySet()) {
            StackTrace stackTrace = e.getKey();
            int[] countCell = e.getValue();
            int count = countCell[0];
            Sample sample = new Sample(stackTrace, count, null);
            samples.add(sample);
        }
        return samples;
    }

    private final void $$robo$$dalvik_system_profiler_HprofData$addThreadEvent(ThreadEvent event) {
        if (event == null) {
            throw new NullPointerException("event == null");
        }
        ThreadEvent old = this.threadIdToThreadEvent.put(event.threadId, event);
        switch (1.$SwitchMap$dalvik$system$profiler$HprofData$ThreadEventType[event.type.ordinal()]) {
            case 1: {
                if (old == null) break;
                throw new IllegalArgumentException("ThreadEvent already registered for id " + event.threadId);
            }
            case 2: {
                if (old == null || old.type != ThreadEventType.END) break;
                throw new IllegalArgumentException("Duplicate ThreadEvent.end for id " + event.threadId);
            }
        }
        this.threadHistory.add(event);
    }

    private final void $$robo$$dalvik_system_profiler_HprofData$addStackTrace(StackTrace stackTrace, int[] countCell) {
        if (!this.threadIdToThreadEvent.containsKey(stackTrace.threadId)) {
            throw new IllegalArgumentException("Unknown thread id " + stackTrace.threadId);
        }
        int[] old = this.stackTraces.put(stackTrace, countCell);
        if (old != null) {
            throw new IllegalArgumentException("StackTrace already registered for id " + stackTrace.stackTraceId + ":\n" + stackTrace);
        }
    }

    private void __constructor__(Map<StackTrace, int[]> map) {
        this.$$robo$$dalvik_system_profiler_HprofData$__constructor__(map);
    }

    public HprofData(Map<StackTrace, int[]> map) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData$__constructor__(java.util.Map<dalvik.system.profiler.HprofData$StackTrace, int[]> ), this, map);
    }

    public long getStartMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getStartMillis", $$robo$$dalvik_system_profiler_HprofData$getStartMillis(), this);
    }

    public void setStartMillis(long l) {
        InvokeDynamicSupport.bootstrap("setStartMillis", $$robo$$dalvik_system_profiler_HprofData$setStartMillis(long ), this, l);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$dalvik_system_profiler_HprofData$getFlags(), this);
    }

    public void setFlags(int n) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$dalvik_system_profiler_HprofData$setFlags(int ), this, n);
    }

    public int getDepth() {
        return (int)InvokeDynamicSupport.bootstrap("getDepth", $$robo$$dalvik_system_profiler_HprofData$getDepth(), this);
    }

    public void setDepth(int n) {
        InvokeDynamicSupport.bootstrap("setDepth", $$robo$$dalvik_system_profiler_HprofData$setDepth(int ), this, n);
    }

    public List<ThreadEvent> getThreadHistory() {
        return InvokeDynamicSupport.bootstrap("getThreadHistory", $$robo$$dalvik_system_profiler_HprofData$getThreadHistory(), this);
    }

    public Set<Sample> getSamples() {
        return InvokeDynamicSupport.bootstrap("getSamples", $$robo$$dalvik_system_profiler_HprofData$getSamples(), this);
    }

    public void addThreadEvent(ThreadEvent threadEvent) {
        InvokeDynamicSupport.bootstrap("addThreadEvent", $$robo$$dalvik_system_profiler_HprofData$addThreadEvent(dalvik.system.profiler.HprofData$ThreadEvent ), this, threadEvent);
    }

    public void addStackTrace(StackTrace stackTrace, int[] nArray) {
        InvokeDynamicSupport.bootstrap("addStackTrace", $$robo$$dalvik_system_profiler_HprofData$addStackTrace(dalvik.system.profiler.HprofData$StackTrace int[] ), this, stackTrace, nArray);
    }

    public /* synthetic */ HprofData() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HprofData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Sample
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public StackTrace stackTrace;
        public int count;

        private void $$robo$$dalvik_system_profiler_HprofData_Sample$__constructor__(StackTrace stackTrace, int count) {
            if (stackTrace == null) {
                throw new NullPointerException("stackTrace == null");
            }
            if (count < 0) {
                throw new IllegalArgumentException("count < 0:" + count);
            }
            this.stackTrace = stackTrace;
            this.count = count;
        }

        private final int $$robo$$dalvik_system_profiler_HprofData_Sample$hashCode() {
            int result = 17;
            result = 31 * result + this.stackTrace.hashCode();
            result = 31 * result + this.count;
            return result;
        }

        private final boolean $$robo$$dalvik_system_profiler_HprofData_Sample$equals(Object o) {
            if (!(o instanceof Sample)) {
                return false;
            }
            Sample s = (Sample)o;
            return this.count == s.count && this.stackTrace.equals(s.stackTrace);
        }

        private final String $$robo$$dalvik_system_profiler_HprofData_Sample$toString() {
            return "Sample[count=" + this.count + " " + this.stackTrace + "]";
        }

        private /* synthetic */ void $$robo$$dalvik_system_profiler_HprofData_Sample$__constructor__(StackTrace x0, int x1, 1 x2) {
        }

        private void __constructor__(StackTrace stackTrace, int n) {
            this.$$robo$$dalvik_system_profiler_HprofData_Sample$__constructor__(stackTrace, n);
        }

        public Sample(StackTrace stackTrace, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData_Sample$__constructor__(dalvik.system.profiler.HprofData$StackTrace int ), this, stackTrace, n);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$dalvik_system_profiler_HprofData_Sample$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$dalvik_system_profiler_HprofData_Sample$equals(java.lang.Object ), this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_profiler_HprofData_Sample$toString(), this);
        }

        private /* synthetic */ void __constructor__(StackTrace stackTrace, int n, 1 var3_3) {
            this.$$robo$$dalvik_system_profiler_HprofData_Sample$__constructor__(stackTrace, n, var3_3);
        }

        public /* synthetic */ Sample(StackTrace stackTrace, int n, 1 var3_3) {
            this(stackTrace, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData_Sample$__constructor__(dalvik.system.profiler.HprofData$StackTrace int dalvik.system.profiler.HprofData$1 ), this, stackTrace, n, var3_3);
        }

        public /* synthetic */ Sample() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Sample)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class StackTrace
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int stackTraceId;
        int threadId;
        StackTraceElement[] stackFrames;

        private void $$robo$$dalvik_system_profiler_HprofData_StackTrace$__constructor__() {
            this.stackTraceId = -1;
        }

        private void $$robo$$dalvik_system_profiler_HprofData_StackTrace$__constructor__(int stackTraceId, int threadId, StackTraceElement[] stackFrames) {
            if (stackFrames == null) {
                throw new NullPointerException("stackFrames == null");
            }
            this.stackTraceId = stackTraceId;
            this.threadId = threadId;
            this.stackFrames = stackFrames;
        }

        private final int $$robo$$dalvik_system_profiler_HprofData_StackTrace$getThreadId() {
            return this.threadId;
        }

        private final StackTraceElement[] $$robo$$dalvik_system_profiler_HprofData_StackTrace$getStackFrames() {
            return this.stackFrames;
        }

        private final int $$robo$$dalvik_system_profiler_HprofData_StackTrace$hashCode() {
            int result = 17;
            result = 31 * result + this.threadId;
            result = 31 * result + Arrays.hashCode(this.stackFrames);
            return result;
        }

        private final boolean $$robo$$dalvik_system_profiler_HprofData_StackTrace$equals(Object o) {
            if (!(o instanceof StackTrace)) {
                return false;
            }
            StackTrace s = (StackTrace)o;
            return this.threadId == s.threadId && Arrays.equals(this.stackFrames, s.stackFrames);
        }

        private final String $$robo$$dalvik_system_profiler_HprofData_StackTrace$toString() {
            StringBuilder frames = new StringBuilder();
            if (this.stackFrames.length > 0) {
                frames.append('\n');
                for (StackTraceElement stackFrame : this.stackFrames) {
                    frames.append("\t at ");
                    frames.append(stackFrame);
                    frames.append('\n');
                }
            } else {
                frames.append("<empty>");
            }
            return "StackTrace[stackTraceId=" + this.stackTraceId + ", threadId=" + this.threadId + ", frames=" + frames + "]";
        }

        private void __constructor__() {
            this.$$robo$$dalvik_system_profiler_HprofData_StackTrace$__constructor__();
        }

        public StackTrace() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData_StackTrace$__constructor__(), this);
        }

        private void __constructor__(int n, int n2, StackTraceElement[] stackTraceElementArray) {
            this.$$robo$$dalvik_system_profiler_HprofData_StackTrace$__constructor__(n, n2, stackTraceElementArray);
        }

        public StackTrace(int n, int n2, StackTraceElement[] stackTraceElementArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData_StackTrace$__constructor__(int int java.lang.StackTraceElement[] ), this, n, n2, stackTraceElementArray);
        }

        public int getThreadId() {
            return (int)InvokeDynamicSupport.bootstrap("getThreadId", $$robo$$dalvik_system_profiler_HprofData_StackTrace$getThreadId(), this);
        }

        public StackTraceElement[] getStackFrames() {
            return InvokeDynamicSupport.bootstrap("getStackFrames", $$robo$$dalvik_system_profiler_HprofData_StackTrace$getStackFrames(), this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$dalvik_system_profiler_HprofData_StackTrace$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$dalvik_system_profiler_HprofData_StackTrace$equals(java.lang.Object ), this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_profiler_HprofData_StackTrace$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackTrace)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ThreadEvent
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ThreadEventType type;
        public int objectId;
        public int threadId;
        public String threadName;
        public String groupName;
        public String parentGroupName;

        private static final ThreadEvent $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$start(int objectId, int threadId, String threadName, String groupName, String parentGroupName) {
            return new ThreadEvent(ThreadEventType.START, objectId, threadId, threadName, groupName, parentGroupName);
        }

        private static final ThreadEvent $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$end(int threadId) {
            return new ThreadEvent(ThreadEventType.END, threadId);
        }

        private void $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$__constructor__(ThreadEventType type, int objectId, int threadId, String threadName, String groupName, String parentGroupName) {
            if (threadName == null) {
                throw new NullPointerException("threadName == null");
            }
            this.type = ThreadEventType.START;
            this.objectId = objectId;
            this.threadId = threadId;
            this.threadName = threadName;
            this.groupName = groupName;
            this.parentGroupName = parentGroupName;
        }

        private void $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$__constructor__(ThreadEventType type, int threadId) {
            this.type = ThreadEventType.END;
            this.objectId = -1;
            this.threadId = threadId;
            this.threadName = null;
            this.groupName = null;
            this.parentGroupName = null;
        }

        private final int $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$hashCode() {
            int result = 17;
            result = 31 * result + this.objectId;
            result = 31 * result + this.threadId;
            result = 31 * result + ThreadEvent.hashCode(this.threadName);
            result = 31 * result + ThreadEvent.hashCode(this.groupName);
            result = 31 * result + ThreadEvent.hashCode(this.parentGroupName);
            return result;
        }

        private static final int $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$hashCode(Object o) {
            return o == null ? 0 : o.hashCode();
        }

        private final boolean $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$equals(Object o) {
            if (!(o instanceof ThreadEvent)) {
                return false;
            }
            ThreadEvent event = (ThreadEvent)o;
            return this.type == event.type && this.objectId == event.objectId && this.threadId == event.threadId && ThreadEvent.equal(this.threadName, event.threadName) && ThreadEvent.equal(this.groupName, event.groupName) && ThreadEvent.equal(this.parentGroupName, event.parentGroupName);
        }

        private static final boolean $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$equal(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }

        private final String $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$toString() {
            switch (1.$SwitchMap$dalvik$system$profiler$HprofData$ThreadEventType[this.type.ordinal()]) {
                case 1: {
                    return String.format("THREAD START (obj=%d, id = %d, name=\"%s\", group=\"%s\")", this.objectId, this.threadId, this.threadName, this.groupName);
                }
                case 2: {
                    return String.format("THREAD END (id = %d)", this.threadId);
                }
            }
            throw new IllegalStateException(this.type.toString());
        }

        public static ThreadEvent start(int n, int n2, String string2, String string3, String string4) {
            return InvokeDynamicSupport.bootstrapStatic("start", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$start(int int java.lang.String java.lang.String java.lang.String ), (int)n, (int)n2, (String)string2, (String)string3, (String)string4);
        }

        public static ThreadEvent end(int n) {
            return InvokeDynamicSupport.bootstrapStatic("end", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$end(int ), (int)n);
        }

        private void __constructor__(ThreadEventType threadEventType, int n, int n2, String string2, String string3, String string4) {
            this.$$robo$$dalvik_system_profiler_HprofData_ThreadEvent$__constructor__(threadEventType, n, n2, string2, string3, string4);
        }

        public ThreadEvent(ThreadEventType threadEventType, int n, int n2, String string2, String string3, String string4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$__constructor__(dalvik.system.profiler.HprofData$ThreadEventType int int java.lang.String java.lang.String java.lang.String ), this, threadEventType, n, n2, string2, string3, string4);
        }

        private void __constructor__(ThreadEventType threadEventType, int n) {
            this.$$robo$$dalvik_system_profiler_HprofData_ThreadEvent$__constructor__(threadEventType, n);
        }

        public ThreadEvent(ThreadEventType threadEventType, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$__constructor__(dalvik.system.profiler.HprofData$ThreadEventType int ), this, threadEventType, n);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$hashCode(), this);
        }

        private static int hashCode(Object object) {
            return (int)InvokeDynamicSupport.bootstrapStatic("hashCode", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$hashCode(java.lang.Object ), (Object)object);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$equals(java.lang.Object ), this, object);
        }

        private static boolean equal(Object object, Object object2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("equal", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$equal(java.lang.Object java.lang.Object ), (Object)object, (Object)object2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_profiler_HprofData_ThreadEvent$toString(), this);
        }

        public /* synthetic */ ThreadEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ThreadEventType
    extends Enum<ThreadEventType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ ThreadEventType START;
        public static /* enum */ ThreadEventType END;
        private static /* synthetic */ ThreadEventType[] $VALUES;

        private static final ThreadEventType[] $$robo$$dalvik_system_profiler_HprofData_ThreadEventType$values() {
            return (ThreadEventType[])$VALUES.clone();
        }

        private static final ThreadEventType $$robo$$dalvik_system_profiler_HprofData_ThreadEventType$valueOf(String name) {
            return Enum.valueOf(ThreadEventType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$dalvik_system_profiler_HprofData_ThreadEventType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            START = new ThreadEventType();
            END = new ThreadEventType();
            $VALUES = new ThreadEventType[]{START, END};
        }

        public static ThreadEventType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$dalvik_system_profiler_HprofData_ThreadEventType$values());
        }

        public static ThreadEventType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$dalvik_system_profiler_HprofData_ThreadEventType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$dalvik_system_profiler_HprofData_ThreadEventType$__constructor__(string2, n);
        }

        public ThreadEventType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofData_ThreadEventType$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ThreadEventType.class);
        }

        public /* synthetic */ ThreadEventType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadEventType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

