/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Rect;
import android.os.Environment;
import android.os.Handler;
import android.util.ArraySet;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.ThreadedRenderer;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Task;
import com.android.server.wm.TaskSnapshotCache;
import com.android.server.wm.TaskSnapshotLoader;
import com.android.server.wm.TaskSnapshotPersister;
import com.android.server.wm.TaskSnapshotSurface;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.google.android.collect.Sets;
import java.io.PrintWriter;

class TaskSnapshotController {
    static final int SNAPSHOT_MODE_REAL = 0;
    static final int SNAPSHOT_MODE_APP_THEME = 1;
    static final int SNAPSHOT_MODE_NONE = 2;
    private final WindowManagerService mService;
    private final TaskSnapshotCache mCache;
    private final TaskSnapshotPersister mPersister = new TaskSnapshotPersister(Environment::getDataSystemCeDirectory);
    private final TaskSnapshotLoader mLoader = new TaskSnapshotLoader(this.mPersister);
    private final ArraySet<Task> mTmpTasks = new ArraySet();
    private final Handler mHandler = new Handler();
    private final boolean mIsRunningOnTv;

    TaskSnapshotController(WindowManagerService service) {
        this.mService = service;
        this.mCache = new TaskSnapshotCache(this.mService, this.mLoader);
        this.mIsRunningOnTv = this.mService.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
    }

    void systemReady() {
        this.mPersister.start();
    }

    void onTransitionStarting() {
        this.handleClosingApps(this.mService.mClosingApps);
    }

    void notifyAppVisibilityChanged(AppWindowToken appWindowToken, boolean visible) {
        if (!visible) {
            this.handleClosingApps(Sets.newArraySet(appWindowToken));
        }
    }

    private void handleClosingApps(ArraySet<AppWindowToken> closingApps) {
        if (this.shouldDisableSnapshots()) {
            return;
        }
        this.getClosingTasks(closingApps, this.mTmpTasks);
        this.snapshotTasks(this.mTmpTasks);
    }

    private void snapshotTasks(ArraySet<Task> tasks) {
        block5: for (int i = tasks.size() - 1; i >= 0; --i) {
            ActivityManager.TaskSnapshot snapshot;
            Task task = tasks.valueAt(i);
            int mode = this.getSnapshotMode(task);
            switch (mode) {
                case 2: {
                    continue block5;
                }
                case 1: {
                    snapshot = this.drawAppThemeSnapshot(task);
                    break;
                }
                case 0: {
                    snapshot = this.snapshotTask(task);
                    break;
                }
                default: {
                    snapshot = null;
                }
            }
            if (snapshot == null) continue;
            this.mCache.putSnapshot(task, snapshot);
            this.mPersister.persistSnapshot(task.mTaskId, task.mUserId, snapshot);
            if (task.getController() == null) continue;
            task.getController().reportSnapshotChanged(snapshot);
        }
    }

    ActivityManager.TaskSnapshot getSnapshot(int taskId, int userId, boolean restoreFromDisk, boolean reducedResolution) {
        return this.mCache.getSnapshot(taskId, userId, restoreFromDisk, reducedResolution);
    }

    WindowManagerPolicy.StartingSurface createStartingSurface(AppWindowToken token, ActivityManager.TaskSnapshot snapshot) {
        return TaskSnapshotSurface.create(this.mService, token, snapshot);
    }

    private ActivityManager.TaskSnapshot snapshotTask(Task task) {
        AppWindowToken top = (AppWindowToken)task.getTopChild();
        if (top == null) {
            return null;
        }
        WindowState mainWindow = top.findMainWindow();
        if (mainWindow == null) {
            return null;
        }
        GraphicBuffer buffer = top.mDisplayContent.screenshotApplicationsToBuffer(top.token, -1, -1, false, 1.0f, false, true);
        if (buffer == null) {
            return null;
        }
        return new ActivityManager.TaskSnapshot(buffer, top.getConfiguration().orientation, this.minRect(mainWindow.mContentInsets, mainWindow.mStableInsets), false, 1.0f);
    }

    private boolean shouldDisableSnapshots() {
        return !ActivityManager.ENABLE_TASK_SNAPSHOTS || ActivityManager.isLowRamDeviceStatic() || this.mIsRunningOnTv;
    }

    private Rect minRect(Rect rect1, Rect rect2) {
        return new Rect(Math.min(rect1.left, rect2.left), Math.min(rect1.top, rect2.top), Math.min(rect1.right, rect2.right), Math.min(rect1.bottom, rect2.bottom));
    }

    void getClosingTasks(ArraySet<AppWindowToken> closingApps, ArraySet<Task> outClosingTasks) {
        outClosingTasks.clear();
        for (int i = closingApps.size() - 1; i >= 0; --i) {
            AppWindowToken atoken = closingApps.valueAt(i);
            Task task = atoken.getTask();
            if (task == null || task.isVisible()) continue;
            outClosingTasks.add(task);
        }
    }

    int getSnapshotMode(Task task) {
        AppWindowToken topChild = (AppWindowToken)task.getTopChild();
        if (ActivityManager.StackId.isHomeOrRecentsStack(task.mStack.mStackId)) {
            return 2;
        }
        if (topChild != null && topChild.shouldUseAppThemeSnapshot()) {
            return 1;
        }
        return 0;
    }

    private ActivityManager.TaskSnapshot drawAppThemeSnapshot(Task task) {
        AppWindowToken topChild = (AppWindowToken)task.getTopChild();
        if (topChild == null) {
            return null;
        }
        WindowState mainWindow = topChild.findMainWindow();
        if (mainWindow == null) {
            return null;
        }
        int color2 = task.getTaskDescription().getBackgroundColor();
        int statusBarColor = task.getTaskDescription().getStatusBarColor();
        int navigationBarColor = task.getTaskDescription().getNavigationBarColor();
        WindowManager.LayoutParams attrs = mainWindow.getAttrs();
        TaskSnapshotSurface.SystemBarBackgroundPainter decorPainter = new TaskSnapshotSurface.SystemBarBackgroundPainter(attrs.flags, attrs.privateFlags, attrs.systemUiVisibility, statusBarColor, navigationBarColor);
        int width = mainWindow.getFrameLw().width();
        int height = mainWindow.getFrameLw().height();
        RenderNode node = RenderNode.create("TaskSnapshotController", null);
        node.setLeftTopRightBottom(0, 0, width, height);
        node.setClipToBounds(false);
        DisplayListCanvas c = node.start(width, height);
        c.drawColor(color2);
        decorPainter.setInsets(mainWindow.mContentInsets, mainWindow.mStableInsets);
        decorPainter.drawDecors(c, null);
        node.end(c);
        Bitmap hwBitmap = ThreadedRenderer.createHardwareBitmap(node, width, height);
        return new ActivityManager.TaskSnapshot(hwBitmap.createGraphicBufferHandle(), topChild.getConfiguration().orientation, mainWindow.mStableInsets, false, 1.0f);
    }

    void onAppRemoved(AppWindowToken wtoken) {
        this.mCache.onAppRemoved(wtoken);
    }

    void onAppDied(AppWindowToken wtoken) {
        this.mCache.onAppDied(wtoken);
    }

    void notifyTaskRemovedFromRecents(int taskId, int userId) {
        this.mCache.onTaskRemoved(taskId);
        this.mPersister.onTaskRemovedFromRecents(taskId, userId);
    }

    void removeObsoleteTaskFiles(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
        this.mPersister.removeObsoleteFiles(persistentTaskIds, runningUserIds);
    }

    void setPersisterPaused(boolean paused) {
        this.mPersister.setPaused(paused);
    }

    void screenTurningOff(WindowManagerPolicy.ScreenOffListener listener) {
        if (this.shouldDisableSnapshots()) {
            listener.onScreenOff();
            return;
        }
        this.mHandler.post(() -> {
            try {
                WindowHashMap windowHashMap = this.mService.mWindowMap;
                synchronized (windowHashMap) {
                    this.mTmpTasks.clear();
                    this.mService.mRoot.forAllTasks(task -> {
                        if (task.isVisible()) {
                            this.mTmpTasks.add((Task)task);
                        }
                    });
                    this.snapshotTasks(this.mTmpTasks);
                }
            }
            finally {
                listener.onScreenOff();
            }
        });
    }

    void dump(PrintWriter pw, String prefix) {
        this.mCache.dump(pw, prefix);
    }
}

