/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.RemoteAction;
import android.graphics.Rect;
import com.android.server.wm.BoundsAnimationTarget;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.PinnedStackWindowListener;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.util.List;

public class PinnedStackWindowController
extends StackWindowController {
    private Rect mTmpFromBounds = new Rect();
    private Rect mTmpToBounds = new Rect();

    public PinnedStackWindowController(int stackId, PinnedStackWindowListener listener, int displayId, boolean onTop, Rect outBounds) {
        super(stackId, listener, displayId, onTop, outBounds, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect getPictureInPictureBounds(float aspectRatio, Rect stackBounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                return null;
            }
            DisplayContent displayContent = ((TaskStack)this.mContainer).getDisplayContent();
            if (displayContent == null) {
                return null;
            }
            PinnedStackController pinnedStackController = displayContent.getPinnedStackController();
            if (stackBounds == null) {
                stackBounds = pinnedStackController.getDefaultBounds();
            }
            if (pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio)) {
                return pinnedStackController.transformBoundsToAspectRatio(stackBounds, aspectRatio, true);
            }
            return stackBounds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateResizePinnedStack(Rect toBounds, Rect sourceHintBounds, int animationDuration, boolean fromFullscreen) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            boolean toFullscreen;
            if (this.mContainer == null) {
                throw new IllegalArgumentException("Pinned stack container not found :(");
            }
            Rect fromBounds = new Rect();
            ((TaskStack)this.mContainer).getBounds(fromBounds);
            int schedulePipModeChangedState = 0;
            boolean bl = toFullscreen = toBounds == null;
            if (toFullscreen) {
                if (fromFullscreen) {
                    throw new IllegalArgumentException("Should not defer scheduling PiP mode change on animation to fullscreen.");
                }
                schedulePipModeChangedState = 1;
                this.mService.getStackBounds(1, this.mTmpToBounds);
                if (!this.mTmpToBounds.isEmpty()) {
                    toBounds = new Rect(this.mTmpToBounds);
                } else {
                    toBounds = new Rect();
                    ((TaskStack)this.mContainer).getDisplayContent().getLogicalDisplayRect(toBounds);
                }
            } else if (fromFullscreen) {
                schedulePipModeChangedState = 2;
            }
            ((TaskStack)this.mContainer).setAnimationFinalBounds(sourceHintBounds, toBounds, toFullscreen);
            Rect finalToBounds = toBounds;
            int finalSchedulePipModeChangedState = schedulePipModeChangedState;
            this.mService.mBoundsAnimationController.getHandler().post(() -> {
                if (this.mContainer == null) {
                    return;
                }
                this.mService.mBoundsAnimationController.animateBounds((BoundsAnimationTarget)((Object)this.mContainer), fromBounds, finalToBounds, animationDuration, finalSchedulePipModeChangedState, fromFullscreen, toFullscreen);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureAspectRatio(float aspectRatio) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                return;
            }
            PinnedStackController pinnedStackController = ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController();
            if (Float.compare(aspectRatio, pinnedStackController.getAspectRatio()) != 0) {
                ((TaskStack)this.mContainer).getAnimationOrCurrentBounds(this.mTmpFromBounds);
                this.mTmpToBounds.set(this.mTmpFromBounds);
                this.getPictureInPictureBounds(aspectRatio, this.mTmpToBounds);
                if (!this.mTmpToBounds.equals(this.mTmpFromBounds)) {
                    this.animateResizePinnedStack(this.mTmpToBounds, null, -1, false);
                }
                pinnedStackController.setAspectRatio(pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio) ? aspectRatio : -1.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureActions(List<RemoteAction> actions) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                return;
            }
            ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController().setActions(actions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deferScheduleMultiWindowModeChanged() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            return ((TaskStack)this.mContainer).deferScheduleMultiWindowModeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnimatingBoundsToFullscreen() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            return ((TaskStack)this.mContainer).isAnimatingBoundsToFullscreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pinnedStackResizeDisallowed() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            return ((TaskStack)this.mContainer).pinnedStackResizeDisallowed();
        }
    }

    public void updatePictureInPictureModeForPinnedStackAnimation(Rect targetStackBounds) {
        if (this.mListener != null) {
            PinnedStackWindowListener listener = (PinnedStackWindowListener)this.mListener;
            listener.updatePictureInPictureModeForPinnedStackAnimation(targetStackBounds);
        }
    }
}

