/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Slog;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

public class DimLayer {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private SurfaceControl mDimSurface;
    private float mAlpha = 0.0f;
    private int mLayer = -1;
    private final Rect mBounds = new Rect();
    private final Rect mLastBounds = new Rect();
    private boolean mShowing = false;
    private float mStartAlpha = 0.0f;
    private float mTargetAlpha = 0.0f;
    private long mStartTime;
    private long mDuration;
    private boolean mDestroyed = false;
    private final int mDisplayId;
    private final DimLayerUser mUser;
    private final String mName;

    DimLayer(WindowManagerService service, DimLayerUser user, int displayId, String name) {
        this.mUser = user;
        this.mDisplayId = displayId;
        this.mService = service;
        this.mName = name;
    }

    private void constructSurface(WindowManagerService service) {
        service.openSurfaceTransaction();
        try {
            this.mDimSurface = new SurfaceControl(service.mFxSession, this.mName, 16, 16, -1, 131076);
            this.mDimSurface.setLayerStack(this.mDisplayId);
            this.adjustBounds();
            this.adjustAlpha(this.mAlpha);
            this.adjustLayer(this.mLayer);
        }
        catch (Exception e) {
            Slog.e(TAG, "Exception creating Dim surface", e);
        }
        finally {
            service.closeSurfaceTransaction();
        }
    }

    boolean isDimming() {
        return this.mTargetAlpha != 0.0f;
    }

    boolean isAnimating() {
        return this.mTargetAlpha != this.mAlpha;
    }

    float getTargetAlpha() {
        return this.mTargetAlpha;
    }

    void setLayer(int layer) {
        if (this.mLayer == layer) {
            return;
        }
        this.mLayer = layer;
        this.adjustLayer(layer);
    }

    private void adjustLayer(int layer) {
        if (this.mDimSurface != null) {
            this.mDimSurface.setLayer(layer);
        }
    }

    int getLayer() {
        return this.mLayer;
    }

    private void setAlpha(float alpha) {
        if (this.mAlpha == alpha) {
            return;
        }
        this.mAlpha = alpha;
        this.adjustAlpha(alpha);
    }

    private void adjustAlpha(float alpha) {
        try {
            if (this.mDimSurface != null) {
                this.mDimSurface.setAlpha(alpha);
            }
            if (alpha == 0.0f && this.mShowing) {
                if (this.mDimSurface != null) {
                    this.mDimSurface.hide();
                    this.mShowing = false;
                }
            } else if (alpha > 0.0f && !this.mShowing && this.mDimSurface != null) {
                this.mDimSurface.show();
                this.mShowing = true;
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Failure setting alpha immediately", e);
        }
    }

    private void adjustBounds() {
        if (this.mUser.dimFullscreen()) {
            this.getBoundsForFullscreen(this.mBounds);
        }
        if (this.mDimSurface != null) {
            this.mDimSurface.setPosition(this.mBounds.left, this.mBounds.top);
            this.mDimSurface.setSize(this.mBounds.width(), this.mBounds.height());
        }
        this.mLastBounds.set(this.mBounds);
    }

    private void getBoundsForFullscreen(Rect outBounds) {
        DisplayInfo info = this.mUser.getDisplayInfo();
        int dw = (int)((double)info.logicalWidth * 1.5);
        int dh = (int)((double)info.logicalHeight * 1.5);
        float xPos = -1 * dw / 6;
        float yPos = -1 * dh / 6;
        outBounds.set((int)xPos, (int)yPos, (int)xPos + dw, (int)yPos + dh);
    }

    void setBoundsForFullscreen() {
        this.getBoundsForFullscreen(this.mBounds);
        this.setBounds(this.mBounds);
    }

    void setBounds(Rect bounds) {
        this.mBounds.set(bounds);
        if (this.isDimming() && !this.mLastBounds.equals(bounds)) {
            try {
                this.mService.openSurfaceTransaction();
                this.adjustBounds();
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Failure setting size", e);
            }
            finally {
                this.mService.closeSurfaceTransaction();
            }
        }
    }

    private boolean durationEndsEarlier(long duration) {
        return SystemClock.uptimeMillis() + duration < this.mStartTime + this.mDuration;
    }

    void show() {
        if (this.isAnimating()) {
            this.show(this.mLayer, this.mTargetAlpha, 0L);
        }
    }

    void show(int layer, float alpha, long duration) {
        if (this.mDestroyed) {
            Slog.e(TAG, "show: no Surface");
            this.mAlpha = 0.0f;
            this.mTargetAlpha = 0.0f;
            return;
        }
        if (this.mDimSurface == null) {
            this.constructSurface(this.mService);
        }
        if (!this.mLastBounds.equals(this.mBounds)) {
            this.adjustBounds();
        }
        this.setLayer(layer);
        long curTime = SystemClock.uptimeMillis();
        boolean animating = this.isAnimating();
        if (animating && (this.mTargetAlpha != alpha || this.durationEndsEarlier(duration)) || !animating && this.mAlpha != alpha) {
            if (duration <= 0L) {
                this.setAlpha(alpha);
            } else {
                this.mStartAlpha = this.mAlpha;
                this.mStartTime = curTime;
                this.mDuration = duration;
            }
        }
        this.mTargetAlpha = alpha;
    }

    void hide() {
        if (this.mShowing) {
            this.hide(0L);
        }
    }

    void hide(long duration) {
        if (this.mShowing && (this.mTargetAlpha != 0.0f || this.durationEndsEarlier(duration))) {
            this.show(this.mLayer, 0.0f, duration);
        }
    }

    boolean stepAnimation() {
        if (this.mDestroyed) {
            Slog.e(TAG, "stepAnimation: surface destroyed");
            this.mAlpha = 0.0f;
            this.mTargetAlpha = 0.0f;
            return false;
        }
        if (this.isAnimating()) {
            long curTime = SystemClock.uptimeMillis();
            float alphaDelta = this.mTargetAlpha - this.mStartAlpha;
            float alpha = this.mStartAlpha + alphaDelta * (float)(curTime - this.mStartTime) / (float)this.mDuration;
            if (alphaDelta > 0.0f && alpha > this.mTargetAlpha || alphaDelta < 0.0f && alpha < this.mTargetAlpha) {
                alpha = this.mTargetAlpha;
            }
            this.setAlpha(alpha);
        }
        return this.isAnimating();
    }

    void destroySurface() {
        if (this.mDimSurface != null) {
            this.mDimSurface.destroy();
            this.mDimSurface = null;
        }
        this.mDestroyed = true;
    }

    public void printTo(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mDimSurface=");
        pw.print(this.mDimSurface);
        pw.print(" mLayer=");
        pw.print(this.mLayer);
        pw.print(" mAlpha=");
        pw.println(this.mAlpha);
        pw.print(prefix);
        pw.print("mLastBounds=");
        pw.print(this.mLastBounds.toShortString());
        pw.print(" mBounds=");
        pw.println(this.mBounds.toShortString());
        pw.print(prefix);
        pw.print("Last animation: ");
        pw.print(" mDuration=");
        pw.print(this.mDuration);
        pw.print(" mStartTime=");
        pw.print(this.mStartTime);
        pw.print(" curTime=");
        pw.println(SystemClock.uptimeMillis());
        pw.print(prefix);
        pw.print(" mStartAlpha=");
        pw.print(this.mStartAlpha);
        pw.print(" mTargetAlpha=");
        pw.println(this.mTargetAlpha);
    }

    static interface DimLayerUser {
        public boolean dimFullscreen();

        public DisplayInfo getDisplayInfo();

        public boolean isAttachedToDisplay();

        public void getDimBounds(Rect var1);

        public String toShortString();
    }
}

